<?php
if(!pegasus_module_exists('pegapi')){
	return;
}

class invtrans_pegapi_i01 extends pegapi_RestTableObject{
	public function __construct($method, $request = null, $file = null) {
		parent::__construct($method, $request , $file );
		$this->table = 'i01';
		$this->_d = 'i01_d';
		$this->module = 'invtrans';
	}
	
    public function get() {
		$nr01 = $this->request['nr01'];
		if ($nr01 > 0) {
			$data[] = $this->i01_get_one($nr01);
			$this->recperpage	= 1;
			$this->page			= 0;
			$this->totalrec = empty($data) ? 0 : 1;
		}
		else {
			$filter 	= $this->request['filter'];
			$order 		= $this->request['order_array'];
			$recperpage	= $this->request['recperpage'];
			$page		= $this->request['page'];

			$data = $this->i01_get_many(
				$filter,
				$order,
				$recperpage,
				$page
			);
		}
		if (empty($data)) {
			return array(
				'status'	=> 209,
				'code'		=> 209,
				'data'		=> array('error' => array('title' => "No Content", 'detail' => "No Content"))
			);
		}
		return array(
			'status'	=> 200,
			'code'		=> 200,
			'data'		=> $data
		);
	}
	/**
	 * (INSERT)
	 *
	 * @return void
	 */
	public function post()
	{
		try {
			$args = array();
			$fields = $this->i01_get_participate_fields();
			if (empty($fields)) {
				throw new Exception('No field available for Insert (i01)');
			}
			foreach ($fields as $field => $type) {
				if (isset($this->request[$field])) {
					$args[$field] = $this->request[$field];
				}
			}
			
			$resp = $this->i01_insert(
				$args
			);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			$ret = array(
				'status'	=> 201,
				'code'		=> 201,
			);
			$ret['data'] = $resp['data'];
			if (isset($resp['mydt'])) {
				$ret['info']['mydt'] = $resp['mydt'];
			}
			$this->recperpage = 1;
			$this->page = 0;
			$this->totalrec = 1;
			return $ret;
		} catch (Exception $e) {
			return array(
				'status'	=> 403,
				'code'		=> 403,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
	/**
	 * (UPDATE)
	 *
	 * @return void
	 */
	public function put()
	{
		try {
			$nr01 = $this->request['nr01'];
			if (!(pegasus_mysql_printfld('i01', 'nr01', 'nr01 = :nr01', array('nr01' => $nr01)) > 0)) {
				throw new Exception("Unknown action with nr01: $nr01");
			}
			$fields = $this->i01_get_participate_fields();
			if (empty($fields)) {
				throw new Exception('No field available for Insert (i01)');
			}
			foreach ($fields as $field => $type) {
				if (isset($this->request[$field])) {
					$args[$field] = $this->request[$field];
				}
			}
			
			$resp = $this->i01_update(
				$nr01,
				$args
			);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			$ret = array(
				'status'	=> 201,
				'code'		=> 200
			);
			$ret['data'] = $resp['data'];
			if (isset($resp['mydt'])) {
				$ret['info']['mydt'] = $resp['mydt'];
			}
			$this->recperpage = 1;
			$this->page = 0;
			$this->totalrec = 1;
			return $ret;
		} catch (Exception $e) {
			return array(
				'status'	=> 400,
				'code'		=> 400,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
	/**
	 * (DELETE)
	 *
	 * @return void
	 */
	public function delete()
	{
		$this->recperpage = 0;
		$this->page = 0;
		$this->totalrec = 0;
		try {
			$nr01 = $this->request['nr01'];
			if (!(pegasus_mysql_printfld('i01', 'nr01', 'nr01 = :nr01', array('nr01' => $nr01)) > 0)) {
				throw new Exception("Unknown action with nr01: $nr01");
			}
			$resp = $this->i01_delete($nr01);
			if (isset($resp['error'])) {
				throw new Exception($resp['message']);
			}
			return array(
				'code'		=> 204,
				'status'	=> 200,
				'data'		=> array('info' => array('title' => "Deleted", 'detail' => "Action (i01) with nr01: $nr01 deleted successfully"))
			);
		} catch (Exception $e) {
			return array(
				'status'	=> 400,
				'code'		=> 400,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
    /**
	 *
	 * @param  integer $nr01
	 * @return array
	 */
	private function i01_get_one($nr01 = 0 ) {
		$i01 = array();

		pegasus_mysql_use("SELECT * FROM i01 WHERE nr01 = :nr01",$i01,array('nr01' => $nr01));

		return $i01;
	}
	/**
	 *
	 * @param  array   $filter
	 * @param  array   $order
	 * @param  integer $recperpage
	 * @param  integer $page
	 * @return array
	 */
	private function i01_get_many(
		$filter = array(),
		$order = array(),
		$recperpage = 0,
		$page = 0
	) {
		if (!($recperpage > 0)) {
			$recperpage = 9999999999;
		}
		if (!($page >= 0)) {
			$recperpage = 0;
		}

		$recperpage = intval($recperpage);
		$page = intval($page);
		$this->recperpage = $recperpage;
		$this->page = $page;

		$tableFields = $this->i01_get_participate_fields();
		$filters = $this->makeFilterWhereFromArray($filter, $tableFields, '', true);


		$sql = " 1 = 1 ";
		$values = array();
		if (!empty($filters)) {
			$sql .= $filters['sql'];
			$values = array_merge($values, $filters['sqlParams']);
		}
		$count = pegasus_mysql_printfld('i01', 'COUNT(nr01)', $sql, $values);
		$this->totalrec = intval($count);

		$order = $this->makeOrderBy($tableFields, $order);
		
		$offset = $recperpage * $page;
		$limit = $recperpage;
		$sql = "SELECT * FROM i01 WHERE $sql $order LIMIT $offset,$limit";
		$res = pegasus_query($sql, $values);
		$i01s = array();
		while ($i01 = pegasus_fetch_assoc($res)) {
			$i01s[] = $i01;
		}
		return $i01s;
	}

	private function i01_get_participate_fields()
	{
		$fields = array();
		$sql = "	SELECT
						p51.desc05	AS fld,
						p51.desc16	AS tp,
						desc17 		AS fldsz,
						desc18 		AS flddec
					FROM  p51
					JOIN p61 ON p51.desc07 = p61.p00 and p61.isdbfld = 1

					WHERE p51.desc16 != ''
					AND p51.desc16 != 'V'
					AND p51.p02 = :p51_p02
					AND p51.module = :p51_module
		";
		$values = array(
			'p51_p02'		=> 'i01_d',
			'p51_module'	=> 'invtrans'
		);
		$res = pegasus_query($sql, $values);
		while ($rs = pegasus_fetch_assoc($res)) {
			$fields[$rs['fld']] = array(
				'fld'		=> $rs['fld'],
				'tp'		=> $rs['tp'],
				'fldsz'		=> $rs['fldsz'],
				'flddec'	=> $rs['flddec'],
			);
		}
		return $fields;
	}
	/**
	 *
	 * @param  array  $args
	 * @param  array  $i01
	 * @param  array  $i71
	 * @return array
	 */
	private function i01_insert(
		$args = array()
	) {
		$request = $_REQUEST;
		try {
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0, session_id(), 'i01_d');
			$screen->module = 'invtrans';
			$screen->_d = 'i01_d';
			$screen->table = 'i01';
			if(
				isset($args['nr01'])
				&& $args['nr01'] > 0
			) {
				throw new Exception('Error: nr01 field is not allowed on insert ');
			}
			$screen->read_data_from_db(1, 1);
			$screen->read_params_from_db();
			//	Περνάμε όλες τις μεταβλητές στο data
			foreach ($args as $k => $v) {
				$screen->data[$k] = $v;
			}

			//	Παίρνουμε το new_rec $nr01 από την οθόνη
			$nr01 = $screen->data['nr01'];
			//
			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
			$resp = $screen->save_data();
			peg_close_d($screen->container_id);
			$_REQUEST = $request;
			if ($resp[0] != 1) {
				$msg = '';
				foreach ($resp as $v) {
					if (!empty($v)) {
						$msg .= "$v<br>";
					}
				}
				throw new Exception($msg);
			}

			//	Επιστρέφουμε την εγγραφή που δημιουργήσαμε
			$data = $this->i01_get_one($nr01);
			$ret = array(
				'error'		=> null,
				'data'		=> $data
			);
			return $ret;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
	/**
	 *
	 * @param  integer $nr01
	 * @param  array   $args
	 */
	private function i01_update(
		$nr01 = 0,
		$args = array()
	) {
		try {
			$request = $_REQUEST;
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0, session_id(), 'i01_d');
			$screen->module = 'invtrans';
			$screen->_d = 'i01_d';
			$screen->table = 'i01';
			$screen->nr01 = $nr01;

			$screen->read_data_from_db(1, 1);
			$screen->read_params_from_db();

			foreach ($args as $k => $v) {
				$screen->data[$k] = $v;
			}
			//
			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
			$resp = $screen->save_data();
			peg_close_d($screen->container_id);
			$_REQUEST = $request;
			if ($resp[0] != 1) {
				$msg = '';
				foreach ($resp as $v) {
					if (!empty($v)) {
						$msg .= "$v<br>";
					}
				}
				throw new Exception($msg);
			}
			//	Επιστρέφουμε την εγγραφή που δημιουργήσαμε
			$data = $this->i01_get_one($nr01);
			$ret = array(
				'error'		=> null,
				'data'		=> $data
			);
			return $ret;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
		/**
	 *
	 * @param  integer $nr01
	 * @return array
	 */
	private function i01_delete(
		$nr01 = 0
	) {
		try {
			//	pegasus_mysql_full_delete('p50', $nr01, 0 , '', 0 , $permDeny , $check_perm_only);
			$_REQUEST['no_confim'] = 1;
			$resp = pegasus_mysql_full_delete(
				'i01',
				$nr01,
				0,
				'',
				0,
				array(),
				0,
				array()
			);
			$deny = array();
			foreach ($resp as $v) {
				if ($v['type'] != 'confirm') {
					$deny[] = $v;
				}
			}
			if (!empty($deny)) {
				$message = "";
				foreach ($deny as $pd) {
					if (strtoupper($pd['action']) == 'DELETE') {
						$message .= $_SESSION['peg_dic_core_perm_deny_del_table'];
						$message .= " " . pegasus_mysql_printfld('p50', 'p03',  'p01=?', array($pd['table']));
						$message .=  " (" . $pd['table'] . ")";
						$message .= "<br/>";
					}
				}
				throw new Exception($message);
			}
			return true;
		} catch (Exception $e) {
			return array(
				'error'		=> $e->getMessage(),
				'data'		=> null,
				'message'	=> $e->getMessage()
			);
		}
	}
}

?>