<?php
class mail_pegapi_actions extends pegapi_RestObject
{
    /**
     * @return array
     */
    public function send_mail()
    {
        switch ($this->method) {
            case 'POST':
                return $this->post();
                break;
        }
    }
	/**
     * Εκτελείται στο post.
     * Εκτελεί αποστολή πρότυπου e-mail.
     * Expected formdata:
     *            tbl           : Ο πίνακας στον οποίο ανήκει το πρότυπο e-mail
     *            tbl_nr01      : Το ΜΚ της εγγραφής του πίνακα
     *            mail02        : Το ΜΚ του πρότυπου e-mail
     *            p85           : Το ΜΚ της φόρμας εκτύπωσης
     *            recipients    : Διεθύνσεις e-mail παραλήπτη, δέχεται πολλαπλές χωρισμένες με ";"
     */
    
	private function post()
	{
		try {
			$ret = array(
				'status'	=> 200,
                'code'      => 200
			);
			$tbl 		= $this->request['tbl'];
			$tbl_nr01 	= $this->request['tbl_nr01'];
			$mail02 	= $this->request['mail02'];
			$p85 		= $this->request['p85'];
			$recipients = $this->request['recipients'];
			$cc = $this->request['cc'];
			$bcc = $this->request['bcc'];
			
			$ret_arr = array();
			$ret_arr['ok'] = 1;
            $code   = 403;
            $status = 403;
			if(!pegasus_mysql_table_exists($tbl)) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_tbl_not_exists'];
			}elseif(!pegasus_mysql_printfld($tbl, 'nr01', 'nr01 = ?', array($tbl_nr01))) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_record_not_exists'];
			}elseif(!pegasus_mysql_printfld('mail02', 'nr01', 'nr01 = ?', array($mail02))) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_mail02_not_exists'];
			}elseif(!empty($p85) && !pegasus_mysql_printfld('p85', 'nr01', 'nr01 = ?', array($p85))) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_p85_not_exists'];
			}elseif(pegasus_mysql_printfld('mail02', 'p50', 'nr01 = ?', array($mail02)) != $tbl) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_mail02_wrong_tbl'];
			}elseif(!empty($p85) && pegasus_mysql_printfld('p85', 'p50', 'nr01 = ?', array($p85)) != $tbl) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_p85_wrong_tbl'];
			}

			// Αν δεν έχω σφάλμα από πάνω.
			if($ret_arr['ok'] == 1) {
				$mail_arr = array();
				$mail_arr = mail00_get_data_from_mail02($mail02, $tbl, $tbl_nr01);
	
				
				$mail_arr['p30'] = mail00_format_html($mail_arr['p30']);
				$ret_arr = mail00_send_mail($recipients, $mail_arr['p01'], $mail_arr['p30'], 0, 0, $mail02, $p85, $tbl, $tbl_nr01,array(), array(), array(), $cc, $bcc);
				
				$ret_arr['msg'] = strip_tags(preg_replace("/\r|\n/", "", $ret_arr['msg'])); // Αφαιρεί html tags και new lines από τα μηνύματα.
                if($ret_arr['ok'] == 1) {
                    $code  = 200;
                    $status  = 200;
                }
			}
			
			$ret['data'] = array();
			$ret['data']['ok']  = $ret_arr['ok'];
			$ret['data']['msg'] = $ret_arr['msg'];
            $ret['code']    = $code;
            $ret['status']  = $status;
			return $ret;
		} catch(Exception $e) {
			return array(
				'status'	=> 403,
				'code'		=> 403,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
}