<?php
/**
 *
 * @param  array   $data
 * @param  string  $mmnr01
 * @param  integer $mnr01
 * @param  string  $_d
 * @param  string  $container_id
 * @return array
 */
function peg_masschan__change_fld_val_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d = '',
	$container_id = ''
) {
	if ($_d != '_change_fld_val_d') {
		return $data;
	}
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('peg_view_d'));
    $PegInput->addVar(new peg_input_alphanumeric('peg_view_module'));
	$PegInput->addVar(new peg_input_alphanumeric('grid_selection'));
	$PegInput->addVar(new peg_input_alphanumeric('peg_view_table'));
	$grid_selection = $PegInput->getRequest('grid_selection');
	$peg_view_table = $PegInput->getRequest('peg_view_table');
    $peg_view_d = $PegInput->getRequest('peg_view_d');
    $peg_view_module = $PegInput->getRequest('peg_view_module');
	$data['tbl'] = strip_tags($peg_view_table);
	
	if(!empty($grid_selection)) {
		$grid_selection_explode = explode(',',$grid_selection);
		$data['filters'] = str_replace(
			array('#cnt#'),
			array(count($grid_selection_explode)),
			$_SESSION['peg_dic_masschan_nr01_filter']
		);
	}
	// Δεν θέλουμε να συμμετέχουν τα υπόλοιπα φίλτρα αν έχει γίνει πολλαπλή επιλογή γραμμών
	if(empty($grid_selection)) {
		$peg_cont_id     = pegasus_container_id_get_parentBy_d($container_id, 'browse_d00');
		$peg_where_arr   = pegasusGetGlobalVar('gridData_' . $peg_cont_id . '_grid_where_array');
		$wwhr = '';
		$wwhrParams  = array();
		if (function_exists('peg002_make_grid_where')) {
			$whereTbl = peg002_make_grid_where($peg_where_arr, $data['tbl']);
			$wwhr = $whereTbl['where'];
			$wwhrParams = $whereTbl['whereParams'];
		} else {
			$wwhr = make_grid_where($peg_where_arr, $data['tbl']);
		}
		if (!empty($wwhr)) {
			$peg_d           = strip_tags($peg_view_d);
			$peg_module      = strip_tags($peg_view_module);
			$msg = make_grid_where_message(
				$peg_where_arr,
				$peg_d,
				$peg_module
			);
			$cnt = pegasus_mysql_printfld($data['tbl'], 'count(*)', $wwhr, $wwhrParams);
			$data['filters'] = str_replace(
				array('#cnt#'),
				array($cnt),
				$_SESSION['peg_dic_masschan_filter']
			)." $msg";
		}
	}
	if (empty($data['filters'])) {
		$data['filters'] = '<b style="color:red">' . $_SESSION['peg_dic_masschan_no_filters'] . '</b>';
	}
	return $data;
}
/**
 *
 * @param  array  $data
 * @param  string $mmnr01
 * @param  string $mnr01
 * @param  string $_d
 * @param  string $container_id
 * @return void
 */
function peg_masschan__change_fld_val_d_setGlobalWhere(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = '',
	$_d = '',
	$container_id = ''
) {
	if ($_d == '_change_fld_val_d') {
		pegasusSetGlobalVar(
			$container_id . '_where_fld_change_fld_val_d',
			' p51.p02="' . $data['tbl'] . '_d" and  p51.desc16 in (\'M\' , \'N\' , \'C\' , \'D\' , \'L\')'
		);
	}
}
/**
 *
 * @param  array  $retArray
 * @param  string $id
 * @return array
 */
function  peg_masschan_custom_actions_peg002(
	$retArray = array(),
	$id = ''
) {
	$peg_handler = "masschan_toolbar_item(screen.getContainer_ID(), '$id','{$_SESSION['peg_dic_core_perm_deny']}')";
	$retArray[] = array(
		'xtype' => 'pegasusToolBarGridAction',
		'peg_custom_id' => 'masschan',
		'viewModel' => array(
			'type' => 'GridButtonModel',
			'isToolBar' => 1,
			'data' => array(
				'toolBarButton' => 'masschan',

			)
		),
		'icon' => 'masschan_images/masschange_16x16.png',
		'text' =>  $_SESSION['peg_dic_masschan_title'],
		'peghandler' => $peg_handler
	);
	return $retArray;
}
/**
 *
 * @param  string  $container_id
 * @param  string  $tbl
 * @param  string  $fld
 * @param  string  $new_val
 * @param  integer $confirm
 * @return array
 */
function masschan_mass_change(
	$container_id = '',
	$tbl = '',
	$fld = '',
	$new_val = '',
	$confirm = 1,
	$grid_selection = array()
) {
	if (
		empty($tbl)
		|| !pegasus_mysql_table_exists($tbl)
		|| empty($container_id)
	) {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_tbl_empty']
		);
	}
	if (empty($fld)) {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_fld_empty']
		);
	}
	if (trim($new_val) == '') {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_new_val_empty']
		);
	}
	if (!pegasus_profile_check_data_permission($tbl, 'CHANGE',  $_SESSION['user_profile'])) {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_core_perm_deny_chan_table']
		);
	}
	$new_val = trim($new_val);
	if (
		substr($new_val, 0, 1) == '='
		&& !pegasus_mysql_table_field_exists($tbl, 'nr01')
	) {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_nr01_not_exist']
		);
	}

	if (
		!empty($grid_selection)
		&& !pegasus_mysql_table_field_exists($tbl, 'nr01')
	) {
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_nr01_not_exist_2']
		);
	}

	if((int)pegasus_mysql_printfld('cor000', 'msch_nobup', 'nr01 = 1') == 0){
		// make a backup for the table
		pegasus_mysql_backup_table($tbl);
	}
	//make the where...
	$cont_id = pegasus_container_id_get_parentBy_d($container_id, 'browse_d00');
	$where_array = pegasusGetGlobalVar('gridData_' . $cont_id . '_grid_where_array');
	$wwhr = '';
	$wwhrParams = array();
	// Δεν θέλουμε να συμμετέχουν τα υπόλοιπα φίλτρα αν έχει γίνει πολλαπλή επιλογή γραμμών
	if(
		!empty($grid_selection)
		&& count($grid_selection) > 1
	) {
		$in = pegasus_mysql_create_in($grid_selection,'tbl_nr01');
		$wwhr = " nr01 IN ({$in['sql']})";
		$wwhrParams = $in['sqlParams'];
	}
	elseif (function_exists('peg002_make_grid_where')) {
		$whereTbl = peg002_make_grid_where($where_array, $tbl);
		$wwhr = $whereTbl['where'];
		$wwhrParams = $whereTbl['whereParams'];
	} else {
		$wwhr = make_grid_where($where_array, $tbl);
	}

	if (empty($wwhr)) {
		$wwhr = 'nr01 > :nr01';
		$wwhrParams['nr01'] = 0;
	}

	if ($confirm == 1) {
		$cnt = pegasus_mysql_printfld($tbl, 'count(*)', $wwhr, $wwhrParams);
		return array(
			'confirm'	=> 1,
			'msg'		=> str_replace(
				'##count_recs##',
				$cnt,
				$_SESSION['peg_dic_masschan_confirm']
			)
		);
	}
	//first val den einai isii me to "="
	if (substr($new_val, 0, 1) != '=') {
		$new_val00 =  $new_val;
		pegasus_mysql_update($tbl,  array($fld),  array($new_val00), $wwhr, 0, 0, 1, $wwhrParams);
		if (
			($tbl == 'hota02' && $fld == 'en')
			|| ($tbl == 't07' && $fld == 'en')
		) {
			if ($new_val00 == 1) {
				$url = core_update_get_url();
				$_SESSION['update_url'] = $url;
				if (function_exists('core_update_get_modules')) {
					core_update_get_modules($url, '');
				}
				if (function_exists('pegasus_lock_get_licence')) {
					pegasus_lock_get_licence();
				}
			}
		}
		return array(
			'confirm'	=> 0,
			'msg'		=> $_SESSION['peg_dic_masschan_execute_successfully']
		);
	}
	$query = "SELECT * FROM $tbl WHERE $wwhr";
	$res = pegasus_query($query, $wwhrParams);
	while ($data = pegasus_fetch_assoc($res)) {
		$new_val00 = eval("return " . substr($new_val, 1) . ";");
		pegasus_mysql_update($tbl,  array($fld),  array($new_val00), 'nr01=:nr01', 0, 1, 1, array('nr01' => $data['nr01']));
	}
	if (($tbl == 'hota02' && $fld == 'en') || ($tbl == 't07' && $fld == 'en')) {
		if ($new_val00 == 1) {
			$url = core_update_get_url();
			$_SESSION['update_url'] = $url;
			if (function_exists('core_update_get_modules')) {
				core_update_get_modules($url, '');
			}
			if (function_exists('pegasus_lock_get_licence')) {
				pegasus_lock_get_licence();
			}
		}
	}
	return array(
		'confirm'	=> 0,
		'msg'		=> $_SESSION['peg_dic_masschan_execute_successfully']
	);
}
