<?php
	require('../massexport00/header.php');
	global $PegInput;

	$PegInput->addVar(new peg_input_alphanumeric('module'));
	$PegInput->addVar(new peg_input_alphanumeric('tbl'));
	$PegInput->addVar(new peg_input_alphanumeric('container_id'));
	$PegInput->addVar(new peg_input_alphanumeric('grid_d'));
	$PegInput->addVar(new peg_input_alphanumeric('grid_name'));
	$PegInput->addVar(new peg_input_alphanumeric('desc05'));
	$PegInput->addVar(new peg_input_alphanumeric('par_con_id'));
	$PegInput->addVar(new peg_input_alphanumeric('fname'));
	$PegInput->addVar(new peg_input_alphanumeric('ftype'));
	$PegInput->addVar(new peg_input_alphanumeric('decimal_number_separator'));

	$PegInput->addVar(new peg_input_number('confirm'));
	$PegInput->addVar(new peg_input_number('exp_no_titles'));
	

	$module				= $PegInput->getRequest('module');
	$tbl				= $PegInput->getRequest('tbl');
	
	$confirm			= $PegInput->getRequest('confirm');
	$container_id		= $PegInput->getRequest('container_id');
	$grid_d				= $PegInput->getRequest('grid_d');
	$grid_name			= $PegInput->getRequest('grid_name');
	$view_d				= $PegInput->getRequest('desc05');
	$peg_parent_cont_id = $PegInput->getRequest('par_con_id');
	$fname				= $PegInput->getRequest('fname');
	$ftype				= $PegInput->getRequest('ftype');

	$decimal_number_separator	= $PegInput->getRequest('decimal_number_separator');
	$exp_no_titles 				= $PegInput->getRequest('exp_no_titles');

	$filename = $fname.'.'.$ftype;
	

	if($decimal_number_separator != 1) {
		$decimal_number_separator = 0;
	}
	
	$return_array = array();
	$return_array['confirm'] = 0;

	$group_grid_flag = (empty($tbl) && peg_substr($grid_d, 0, 8)=='q10_d90_' && peg_substr($grid_d, -5, 5)=='_d200') ? true : false;

	if((empty($tbl) or (!pegasus_mysql_table_exists($tbl)) or empty($container_id)) && !$group_grid_flag){
		$return_array['msg'] = $_SESSION['peg_dic_massexport_tbl_empty'];
		echo json_encode($return_array);
		return ;	 
	}

	if(!pegasus_profile_check_data_permission($tbl , 'SHOW' ,  $_SESSION['user_profile']) && !$group_grid_flag){
		$return_array['msg'] = $_SESSION['peg_dic_core_perm_deny_chan_table'];
		echo json_encode($return_array);
		return ;		
	}
	
	if(!pegasus_check_permission('mass-export')){
		$return_array['msg'] = $_SESSION['peg_dic_core_perm_deny'] . '(mass-export) ';
		echo json_encode($return_array);
		return ;
	}
	
	if(!pegasus_module_exists($module)){
		$return_array['msg'] =$_SESSION['peg_dic_core_module_dont_exist'];
		echo json_encode($return_array);
		return ;
	}

	if(!class_exists('XMLWriter')){
		$return_array['msg'] = str_replace('##class_name##', 'XMLWriter', $_SESSION['peg_dic_core_php_class_not_exists']);
		echo json_encode($return_array);
		return ;
	}
	
	if(!class_exists('XMLReader')){
		$return_array['msg'] = str_replace('##class_name##', 'XMLReader', $_SESSION['peg_dic_core_php_class_not_exists']);
		echo json_encode($return_array);
		return ;
	}

	$peg_tmp_exp_data_query 			= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query');
	$peg_tmp_exp_data_queryWhereParams 	= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query_whereParams'  );
	
	$peg_tmp_exp_data_query00 			= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query00');
	$peg_tmp_exp_data_query00_code 		= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query00_code');
	
	$peg_tmp_exp_data_query_after 		= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query_after');
	$peg_tmp_exp_data_query_after_code 	= pegasusGetGlobalVar('gridData_' . $peg_parent_cont_id . '_' . $grid_name . '_query_after_code');
	
	
	pegasus_mysql_use("select count(*) as cnt from ($peg_tmp_exp_data_query) as tbl", $tmp_count, $peg_tmp_exp_data_queryWhereParams);
	$datacountexp = $tmp_count['cnt'];
	
	if($group_grid_flag){
		$q10_d902_grid_fields = pegasusGetGlobalVar($peg_parent_cont_id . '_q10_d902_grid_fields');
		$q10_d902_grid_title  = pegasusGetGlobalVar($peg_parent_cont_id . '_q10_d902_grid_titles');
		
		$peg_field_array = array();
		foreach ($q10_d902_grid_fields as $index => $fld) {
			$peg_field_array[$q10_d902_grid_title[$index]['name']] = array(
				'db_type' 			=> $fld['db_type'],
				'type' 				=> $fld['type'],
				'desc' 				=> $q10_d902_grid_title[$index]['header'],
				'length' 			=> $q10_d902_grid_title[$index]['length'],
				'decimal' 			=> $q10_d902_grid_title[$index]['decimalPrecision'],
				'browse_value' 		=> null, 
				'browse_value_code' => null, 
				'browse_sum' 		=> $q10_d902_grid_title[$index]['summaryType'], 
				'name' 				=> $q10_d902_grid_title[$index]['name']
			);
		}
		
		if(!(count($peg_field_array)>0)){
			$return_array['msg'] = $_SESSION['peg_dic_massexport_fields_empty'];
			echo json_encode($return_array);
			return ;
		}
	
	}else{
		$peg_tmp_exp_fld_query = "";
		$peg_tmp_exp_fld_queryParams = array();
		if( empty($_SESSION['user_profile'])){
			$peg_tmp_exp_fld_query = " select    p51.desc16  ,
											p51.desc05  ,
											p51.desc07  ,
											p51.desc02  ,
											if(p52.par_val_js = '' , p52.par_val , p52.par_val_js)as browse_val,
											p52.code as browse_val_code,
											p51.desc13,
											p51.desc17 ,
											p51.desc18 ,
											if( p95p51.tax!=0 ,  p95p51.tax , p51.desc13 ) as tax
										from p51
											left join p52 on p51.module=p52.module and p51.p02=p52.p02 and p51.desc05=p52.desc05 and p51.desc07=p52.desc07  and p52.par_nm=\"browse_value\"

											where p51.p02=:view_d  and p51.module=:module and ( p51.desc13>0 ) order by p51.desc13;";

				$peg_tmp_exp_fld_queryParams = array(
					'view_d' => $view_d,
					'module' => $module
				);
			//or  p51.desc13='-1'
		}else{
			$peg_tmp_exp_fld_query = "select
									p51.desc16  ,
									p51.desc05  ,
									p51.desc07  ,
									p51.desc02  ,
									if(p52_00.par_val_js = '', p52_00.par_val, p52_00.par_val_js) as browse_val,
									p52_00.code as browse_val_code,
									if(p52_01.par_val_js = '', p52_01.par_val, p52_01.par_val_js) as browse_sum, 
									p51.desc13,
									p51.desc17 ,
									p51.desc18 ,
									if( p95p51.tax!=0 ,  p95p51.tax , p51.desc13 ) as tax
									from  p51
										left join p52 as p52_00 on p51.module=p52_00.module and p51.p02=p52_00.p02 and p51.desc05=p52_00.desc05 and p51.desc07=p52_00.desc07 and p52_00.par_nm=\"browse_value\"
										left join p52 as p52_01 on p51.module=p52_01.module and p51.p02=p52_01.p02 and p51.desc05=p52_01.desc05 and p51.desc07=p52_01.desc07 and p52_01.par_nm=\"browse_summaryType\"
										left join  p95p51 on  p95p51.tp='grid' and p95p51.p02=p51.p02 and p95p51.module=p51.module and p95p51.desc05=p51.desc05  and p95p51.p95=:user_profile
									where
										p51.p02=:view_d  and p51.module=:module having ( tax>0 )   order by IF(p95p51.tax != 0, p95p51.tax, p51.desc13);";
			
			$peg_tmp_exp_fld_queryParams = array(
				'user_profile' => $_SESSION['user_profile'],
				'view_d' => $view_d,
				'module' => $module
			);
			//or  desc13='-1'
		}
		//$return_array['debug'] = $peg_tmp_exp_fld_query;
		$peg_field_array;
		$peg_tmp_exp_fld_res = pegasus_query($peg_tmp_exp_fld_query, $peg_tmp_exp_fld_queryParams);
		if(pegasus_num_rows($peg_tmp_exp_fld_res)<1){
			$return_array['msg'] = $_SESSION['peg_dic_massexport_fields_empty'];
			echo json_encode($return_array);
			return ;
		}
		while ($tmp_data = pegasus_fetch_assoc($peg_tmp_exp_fld_res)) {
			$peg_field_array[$tmp_data['desc05']] = array(
				'db_type' 			=> $tmp_data['desc16'],
				'type' 				=> $tmp_data['desc07'],
				'desc' 				=> $tmp_data['desc02'],
				'length' 			=> $tmp_data['desc17'],
				'decimal' 			=> $tmp_data['desc18'],
				'browse_value' 		=> $tmp_data['browse_val'], 
				'browse_value_code' => $tmp_data['browse_val_code'], 
				'browse_sum' 		=> $tmp_data['browse_sum'], 
				'name' 				=> $tmp_data['desc05']
			);

			if($tmp_data['desc07']=='selectbox'  || $tmp_data['desc07']=='comboboxV2'){
				$peg_field_array['v_selectbox_' . $tmp_data['desc05']] = array(
						'db_type' 				=> 'C',
						'type' 					=> 'textbox',
						'desc' 					=> $tmp_data['desc02'] . ' ' . $_SESSION['peg_dic_massexport_fld_selectbox_desc'],
						'length' 				=> 300,
						'decimal' 				=> 0,
						'browse_value' 			=> $tmp_data['browse_val'],
						'browse_value_code' 	=> $tmp_data['browse_val_code'], 
						'browse_sum' 			=> $tmp_data['browse_sum'], 
						'name' 					=> 'v_selectbox_' . $tmp_data['desc05']
				);    
			}

		}
	}
	

	//Αυτό είναι το array από griddata -> Θα πρέπει να ακολουθήσουμε την ίδια ονομασία
	//  array(
	// 	"tax" => $tax, //Δεν το χρειάζομαι γιατί το query φέρνει μόνο τα p51 όπου ( tax>0 or desc13>0 ) 
	// 	"desc13" => $desc13, //Δεν το χρειάζομαι γιατί το query φέρνει μόνο τα p51 όπου ( tax>0 or desc13>0 ) 
	// 	"name" => $desc05, ok 
	// 	"db_type" => $desc16, ok 
	// 	"type" => $desc07, ok
	// 	"desc17" => $desc17, // Δεν βλέπω που χρησιμοποιείται
	// 	"browse_jn_table" => $browse_jn_table, //Νομίζω ότι δεν το χρειάζομαι γιατί έχω το query έτοιμο ?
	// 	"browse_jn_as_table" => $browse_jn_as_table,   //Νομίζω ότι δεν το χρειάζομαι γιατί έχω το query έτοιμο ?
	// 	"browse_jn_where" => $browse_jn_where,  //Νομίζω ότι δεν το χρειάζομαι γιατί έχω το query έτοιμο ?
	// 	"browse_jn_type" => $browse_jn_type,  //Νομίζω ότι δεν το χρειάζομαι γιατί έχω το query έτοιμο ?
	// 	"browse_jn_field" => $browse_jn_field,  //Νομίζω ότι δεν το χρειάζομαι γιατί έχω το query έτοιμο ?
	// 	"ls_data" => $ls_data, 
	// 	"valueField" => $valueField, 
	// 	"displayField" => $displayField, 
	// 	"browse_value" => $browse_value, ok
	// 	"browse_value_code" => $browse_value_code, ok
	// 	"br_table" => $br_table, 
	// 	'browse_selectbox_type' =>  $browse_selectbox_type, 
	// 	'browse_selectbox_code_title' => $browse_selectbox_code_title
	// 	)

	$massexport_ar = array();
	$massexport_ar['exp_fld_json']				= json_encode($peg_field_array);
	$massexport_ar['exp_data_query']			= $peg_tmp_exp_data_query;
	$massexport_ar['exp_data_queryWhereParams']	= $peg_tmp_exp_data_queryWhereParams;

	$massexport_ar['exp_data_query00']     		= $peg_tmp_exp_data_query00;
	$massexport_ar['exp_data_query00_code'] 	= $peg_tmp_exp_data_query00_code;
	$massexport_ar['exp_data_query_after'] 		= $peg_tmp_exp_data_query_after;
	$massexport_ar['exp_data_query_after_code']	= $peg_tmp_exp_data_query_after_code;
	
	
	$massexport_ar['fname'] 		= $fname;
	$massexport_ar['ftype'] 		= $ftype;
	$massexport_ar['module'] 		= $module;
	$massexport_ar['tbl'] 			= $tbl;
	$massexport_ar['view_d'] 		= $view_d;
	$massexport_ar['cntexp'] 		= $datacountexp;
	$massexport_ar['container_id']  = $container_id;
	$massexport_ar['decimal_number_separator'] 	= $decimal_number_separator;
	$massexport_ar['exp_no_titles'] 			= $exp_no_titles;
	
	$return_array['dbg'] = $massexport_ar;

	pegasusSetGlobalVar(  'massexport_' . $container_id , $massexport_ar);
	if($confirm == 1){
		$return_array['msg'] = $_SESSION['peg_dic_massexport_confirm'];
		$return_array['confirm'] = 1;
		$return_array['msg'] = str_replace('##filename##' , $filename , $return_array['msg'] );
		
		echo json_encode($return_array);
		return ;
	}

	echo json_encode($return_array);
?>