<?php
	require_once('../massimport00/header.php');

	use PhpOffice\PhpSpreadsheet\Spreadsheet;
	use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
	use PhpOffice\PhpSpreadsheet\IOFactory;


	/**
	 * Επιστρέφει true / false ανάλογα με το αν ο προσωρινός πινάκας υπάρχει και ταιριάζουν 
	 * τα πεδία με τα πεδία του αρχείου που πάει να ανέβει.
	 *
	 * @param array $fields
	 * @param string $tmp_tbl
	 * @return boolean
	 */
	function peg_massimport_keep_table_check($fields=array(),$tmp_tbl=''){
		//	not old table select try to create new
		if($tmp_tbl==''){
			return false;
		}
		// Den mporw na kanw Show tables check
		$table_exist_check=pegasus_query("SHOW TABLES LIKE :tablename ",array('tablename'=>'massimport_z_'.$tmp_tbl));
		// Temporary table not exist
		if(pegasus_num_rows($table_exist_check)==0){
			return false;
		}
		$p50_nr01 = pegasus_mysql_printfld('p50', 'nr01', ' p01=:p01 ', array('p01' => 'massimport_z_'.$tmp_tbl));
		//	Tamporaary table not at p50
		if(empty($p50_nr01)){
			return false;
		}
		//	Δεν μπορούμε να συντάξουμε τα ονόματα των πεδίων ή δεν υπάρχουν
		
		if(empty($fields['field_names_array'])||empty($fields['field_desc_array'])){
			return false;
		}
		$massimport2_res=pegasus_query("SELECT * FROM massimport02 WHERE massimport01=:massimport01",array('massimport01'=>$tmp_tbl));
		$massimport2=pegasus_fetchall($massimport2_res);
		//	Δεν έχουμε εγγραφές για τα πεδία αυτού του πίνακα
		if(empty($massimport2)){
			return false;
		}
		$massimport2_fields=array();
		foreach($massimport2 as $massimport2_rec){
			if($massimport2_rec['tmp_p51desc']!=''){
				array_push($massimport2_fields,$massimport2_rec['tmp_p51desc']);
			}
		}
		foreach($fields['field_names_array'] as $field_name){
			//	Αν υπάρχει έστω και μια ασυμφωνία στα πεδία του massimport2 με το excel
			if(!in_array($field_name,$massimport2_fields)){
				return false;
			}
		}
		//	Αν όλα τα παραπάνω είναι οκ τότε μπορεί να χρησιμοποίηση τον ίδιο πίνακα
		return true;
	}
	/**
	 * Επιστρέφει ένα array με τα ονόματα τον πεδίων όπως αυτά θα γίνουν  alter στο table
	 *
	 * @param object $objWorksheet
	 * @param integer $highestColumnIndex
	 * @param boolean $fld_titles
	 * @return array
	 */
	function peg_massimport_objWorksheet_get_field_name($objWorksheet,$highestColumnIndex=0,$fld_titles=false){
		$field_names_array = array();
		$field_desc_array=array();
		for ($col = 0; $col < $highestColumnIndex; ++$col){
			$field_names_array[$col]='fld'.$col;
			//	Όταν η πρώτη σειρά έχει τα ονόματα των πεδίων
			if ($fld_titles == 1){
				//Στην PhpSpreadsheet όταν το col είναι 0 πηγαίνει στην στήλη Z1 του excel και όχι στην A1
				$field_desc_array[$col]= '(fld'.$col.') '.$objWorksheet->getCellByColumnAndRow($col+1, 1)->getValue();
			}
			else{
				$row_cell_tmp=$objWorksheet->getCellByColumnAndRow($col+1, 1)->getValue();
				$field_desc_array[$col]= '(fld'.$col.') '.substr($row_cell_tmp, 0, 100);
			}
		}
		return array(
			'field_names_array'=>$field_names_array,
			'field_desc_array'=>$field_desc_array
		);
	}






	$filename = pegasusGetGlobalVar('massimport_filename');
	$tmp_tbl= $_REQUEST['tmp_tbl'];
	$p01	= $_REQUEST['p01'];
	$step	= $_REQUEST['step'];
	$fld_titles = $_REQUEST['fld_titles'];
	$ret_arr = array();
	/*Make the file extention and path to make sure its ok to handle*/
	$fext = peg_getFileExt($filename);
	$path= '../../tmp/massimport_tmp/'.$filename;
	if (!file_exists($path)) {
		$errors = $_SESSION['peg_dic_massimport_no_file_found'];
		$ret_arr['ok'] = 0;
		$ret_arr['msg'] = $errors;
		echo json_encode($ret_arr);
		return;
	}
	
	/*handle the file with PHPExcel Library to find fields to be imported*/
	$highestColumn='A';
	$highestColumnIndex=0;
	if ($fext=='xlsx' or $fext=='xls'){
		$inputFileType = \PhpOffice\PhpSpreadsheet\IOFactory::identify($path);
		$objReader = \PhpOffice\PhpSpreadsheet\IOFactory::createReader($inputFileType);
		/* To apenergopoiw wste na paizei to
		 * PHPExcel_Shared_Date::isDateTime($cell)
		 * $objReader->setReadDataOnly(true); */
		$objReader->setReadDataOnly(false);
		$objPHPExcel = $objReader->load($path);
		$objWorksheet = $objPHPExcel->getActiveSheet();
		$highestColumn = $objWorksheet->getHighestDataColumn();
		$highestColumnIndex = \PhpOffice\PhpSpreadsheet\Cell\Coordinate::columnIndexFromString($highestColumn);
	}
	else{
		$errors = $_SESSION['peg_dic_massimport_fext_error'];
		$ret_arr['ok'] = 0;
		$ret_arr['msg'] = $errors;
		echo json_encode($ret_arr);
		return;
	}


	/**
	 * Αλλαγή στη λογική για το keep table να μην είναι με checkbox αλλά ένα function που να κάνει auto check
	 */
	//$keep_table=isset($_REQUEST['keep_table'])?$_REQUEST['keep_table']:0;
	$fields=peg_massimport_objWorksheet_get_field_name($objWorksheet,$highestColumnIndex,$fld_titles);
	$field_names_array=$fields['field_names_array'];
	$field_desc_array=$fields['field_desc_array'];
	$keep_table=peg_massimport_keep_table_check($fields,$tmp_tbl);


	


	if ($step==0){
		if (empty($p01)&&!$keep_table) {
			$errors = $_SESSION['peg_dic_massimport_set_desc'];
			$ret_arr['ok'] = 0;
			$ret_arr['msg'] = $errors;
			echo json_encode($ret_arr);
			return;

		}
		if (!empty($tmp_tbl)){
			$showConfMsg = false;
			$query ="SHOW TABLES LIKE :msz ";
			$result = pegasus_query($query, array('msz' => 'massimport_z_'.$tmp_tbl));

			if(pegasus_num_rows($result)==1){
				$showConfMsg = true;
			}else{
				$p50_nr01 = pegasus_mysql_printfld('p50', 'nr01', ' p01=:p01 ', array('p01' => 'massimport_z_'.$tmp_tbl));
				if(!empty($p50_nr01)){
					$showConfMsg = true;
				}
			}
			
			if($showConfMsg){
			/* table exists */
				$ret_arr['ok'] = 2;
				$ret_arr['msg'] = $_SESSION['peg_dic_massimport_del_table_conf'];
				echo json_encode($ret_arr);
				return;
			}
		}
	}elseif(!$keep_table){
		/*drop all previous records of p50 and drop table*/
		
		$p50_nr01 = pegasus_mysql_printfld('p50', 'nr01', ' p01=:p01 ', array('p01' => 'massimport_z_'.$tmp_tbl));
			
		pegasus_mysql_full_delete('p50', $p50_nr01, 0);
			
		pegasus_mysql_delete('p50' , 'p01=:p01', 0, array('p01' =>'massimport_z_'.$tmp_tbl));
		pegasus_mysql_delete('p81' , '_d=:massd', 0, array('massd' => 'massimport_z_'.$tmp_tbl.'_d'));
		//Valame to p52 na diagrafete giati upo periptwseis den to diegrafe
		pegasus_mysql_delete('p52' , 'p02=:p02', 0, array('p02' => 'massimport_z_'.$tmp_tbl.'_d'));
		pegasus_mysql_delete('massimport02' ,  'massimport01=:mass01', 0, array('mass01' => $tmp_tbl));
		pegasus_mysql_drop_table('massimport_z_'.$tmp_tbl);
		
		/* die("delete *"); */
	}
	if(!$keep_table)
	{
	if (!empty($tmp_tbl)){
		/*We update the existing record*/
		$nr01 = $tmp_tbl;
		$arr1 = array(); $arr2 = array();
		array_push($arr1, 'p01');	array_push($arr2, $p01);
		array_push($arr1, 'p50');	array_push($arr2, '');
		pegasus_mysql_update('massimport01', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1, array('nr01' => $nr01));
	}else{
		/*If no temporary table selected, we make an new record in massimport01*/
		$arr1 = array(); $arr2 = array();
		$nr01 = pegasus_mysql_newrec('massimport01');
		array_push($arr1, 'nr01');		array_push($arr2, $nr01); 
		array_push($arr1, 'p01');		array_push($arr2, $p01); 
		array_push($arr1, 'tbl_upd');	array_push($arr2, 'massimport_z_'.$nr01);
		pegasus_mysql_insert('massimport01' , $arr1 , $arr2 );
	}

	/*make the proper inputs to p50 for the temporary table*/
	$arr1 = array(); $arr2 = array();
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p50')); 
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d'); 
	array_push($arr1, 'p01');		array_push($arr2, 'massimport_z_'.$nr01);
	array_push($arr1, 'p03');		array_push($arr2, $p01);
	array_push($arr1, 'p102');		array_push($arr2, 1);
	array_push($arr1, 'cor006');		array_push($arr2, 2); //Πίνακες δεδομένων
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'p44');	array_push($arr2, "pegasusSetGlobalVar( \$container_id . '_where_massimport03' ,  ' temp_p50=\"massimport_z_".$nr01."\" and temp_p50_nr01='.\$data['nr01']);
	if(!(\$data['nr01']>0)){
		\$data['nr01']=pegasus_mysql_newrec('".'massimport_z_'.$nr01."');
		\$peg_is_newrec =1 ;
	}

	/*core_begin*/
	\$peg_is_newrec = 0;
	if((\$data['nr01']>0) && !( \$this->nr01 > 0)){
		\$this->nr01 = \$data['nr01'];
		\$peg_is_newrec =1;
	}	
	/*core_end*/
	");
	pegasus_mysql_insert('p50' , $arr1 , $arr2 );
	}


	if(!$keep_table)
	{
	/*make the proper inserts in p51 and massimport02 for each field of tmp table: 'massimport_z_[$nr01]_d'*/
	for ($i=0; $i < $highestColumnIndex ; $i++) {
		$arr1 = array(); $arr2 = array();		
		array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
		array_push($arr1, 'module');	array_push($arr2, 'massimport');
		array_push($arr1, 'desc05');	array_push($arr2, $field_names_array[$i]);
		array_push($arr1, 'desc16');	array_push($arr2, 'M');
		array_push($arr1, 'desc17');	array_push($arr2, 20);
		array_push($arr1, 'desc07');	array_push($arr2, 'textbox');
		array_push($arr1, 'desc06');	array_push($arr2, ($i+2)*10);
		array_push($arr1, 'desc13');	array_push($arr2, ($i+2)*10);
		array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
		array_push($arr1, 'desc02');	array_push($arr2, $field_desc_array[$i]);
		pegasus_mysql_insert('p51' , $arr1 , $arr2 );

		$arr1 = array(); $arr2 = array();		
		array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('massimport02'));
		array_push($arr1, 'tmp_p51desc');	array_push($arr2, $field_names_array[$i]);
		array_push($arr1, 'massimport01');	array_push($arr2, $nr01);
		pegasus_mysql_insert('massimport02' , $arr1 , $arr2 );
	}
    for ($i=0; $i < $highestColumnIndex ; $i++) {
        $arr1 = array(); $arr2 = array();
        array_push($arr1, 'p02');	array_push($arr2, 'massimport_z_'.$nr01.'_d');
        array_push($arr1, 'module');	array_push($arr2, 'massimport');
        array_push($arr1, 'desc05');	array_push($arr2, $field_names_array[$i] );
        array_push($arr1, 'desc07');	array_push($arr2, 'textbox');
        array_push($arr1, 'par_nm');	array_push($arr2, 'browse_edit');
        array_push($arr1, 'par_val_js');	array_push($arr2, '1');
        array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
        pegasus_mysql_insert('p52' , $arr1 , $arr2 );
    }
    /*make one insert for NR01 of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'nr01');
	array_push($arr1, 'desc16');	array_push($arr2, 'N');
	array_push($arr1, 'desc17');	array_push($arr2, 15);
	array_push($arr1, 'desc07');	array_push($arr2, 'numberbox');
	array_push($arr1, 'desc06');	array_push($arr2, '10');
	array_push($arr1, 'desc13');	array_push($arr2, 5);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'M.K.');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*make one insert in p52 for massimport_z_[$nr01]_d.nr01 to be readOnly */
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'nr01');
	array_push($arr1, 'desc07');	array_push($arr2, 'numberbox');
	array_push($arr1, 'par_nm');	array_push($arr2, 'readOnly');
	array_push($arr1, 'par_val');	array_push($arr2, '1');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );

	/*make one insert for error_flag of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'error_flag');
	array_push($arr1, 'desc16');	array_push($arr2, 'L');
	array_push($arr1, 'desc07');	array_push($arr2, 'checkbox');
	array_push($arr1, 'desc06');	array_push($arr2, (($highestColumnIndex+2)*10)-5);
	array_push($arr1, 'desc13');	array_push($arr2, (($highestColumnIndex+2)*10)-5);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'Υπήρξαν errors;');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*make one insert in p52 for massimport_z_[$nr01]_d.error_flag to be readOnly */
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'error_flag');
	array_push($arr1, 'desc07');	array_push($arr2, 'checkbox');
	array_push($arr1, 'par_nm');	array_push($arr2, 'readOnly');
	array_push($arr1, 'par_val');	array_push($arr2, '1');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	
	/*make one insert for error_flag of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'log');
	array_push($arr1, 'desc16');	array_push($arr2, 'M');
	array_push($arr1, 'desc07');	array_push($arr2, 'textarea');
	array_push($arr1, 'desc06');	array_push($arr2, (($highestColumnIndex+2)*10)-2);
	array_push($arr1, 'desc13');	array_push($arr2, -1);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'Log');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*make one insert in p52 for massimport_z_[$nr01]_d.error_flag to be readOnly */
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'log');
	array_push($arr1, 'desc07');	array_push($arr2, 'textarea');
	array_push($arr1, 'par_nm');	array_push($arr2, 'readOnly');
	array_push($arr1, 'par_val');	array_push($arr2, '1');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );

	/*make one insert for upd_tbl_nr01 of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'upd_tbl_nr01');
	array_push($arr1, 'desc16');	array_push($arr2, 'N');
	array_push($arr1, 'desc17');	array_push($arr2, 15);
	array_push($arr1, 'desc07');	array_push($arr2, 'numberbox');
	array_push($arr1, 'desc06');	array_push($arr2, 10);
	array_push($arr1, 'desc13');	array_push($arr2, 10);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'Ενημερώνει εγγραφές');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*make one insert in p52 for massimport_z_[$nr01]_d.upd_tbl_nr01 to be readOnly */
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'upd_tbl_nr01');
	array_push($arr1, 'desc07');	array_push($arr2, 'numberbox');
	array_push($arr1, 'par_nm');	array_push($arr2, 'readOnly');
	array_push($arr1, 'par_val');	array_push($arr2, '1');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );

	/*make one insert for --screen-- of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'screen');
	array_push($arr1, 'desc17');	array_push($arr2, 0);
	array_push($arr1, 'desc07');	array_push($arr2, 'screen');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, $p01);
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*-------------------- Make inserts in p52 for screen -------------------------------*/
		/* Body padding */
		$arr1 = array(); $arr2 = array();		
		array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
		array_push($arr1, 'desc05');	array_push($arr2, 'screen');
		array_push($arr1, 'desc07');	array_push($arr2, 'screen');
		array_push($arr1, 'module');	array_push($arr2, 'massimport');
		array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
		array_push($arr1, 'par_nm');	array_push($arr2, 'bodyPadding');
		array_push($arr1, 'par_val');	array_push($arr2, '10');
		pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Height */	
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr2, 'height');
	array_push($arr2, '850');
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Label Align */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr2, 'labelAlign');
	array_push($arr2, 'right');
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Label Width */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr2, 'labelWidth');
	array_push($arr2, '150');
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Layout */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr2, 'layout');
	array_push($arr2, "{type:'vbox', align:'stretch'}");
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Width */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr2, 'width');
	array_push($arr2, '990');
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	

	/*=====================================================================================*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'fldcont02');
	array_push($arr1, 'desc06');	array_push($arr2, ($highestColumnIndex+2)*10);
	array_push($arr1, 'desc17');	array_push($arr2, 0);
	array_push($arr1, 'desc07');	array_push($arr2, 'fieldSet');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'Αντιστοιχίες εγγραφών');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );
	$highestColumnIndex++;
	
	/*make one input for --grid0-- of tmp table: 'massimport_z_[$nr01]_d' in p51*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'desc05');	array_push($arr2, 'grid0');
	array_push($arr1, 'desc16');	array_push($arr2, 'L');
	array_push($arr1, 'desc07');	array_push($arr2, 'grid');
	array_push($arr1, 'desc06');	array_push($arr2, ($highestColumnIndex+2)*10);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p51'));
	array_push($arr1, 'desc02');	array_push($arr2, 'Συσχέτιση με εγγραφές');
	pegasus_mysql_insert('p51' , $arr1 , $arr2 );

	/*-------------------- Make inserts in p52 for grid0 -------------------------------*/
	/*fieldset*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'desc05');	array_push($arr2, 'grid0');
	array_push($arr1, 'desc07');	array_push($arr2, 'grid');	
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'par_val');	array_push($arr2, 'fldcont02');
	array_push($arr1, 'par_nm');	array_push($arr2, 'fieldset');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Flex */
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'desc05');	array_push($arr2, 'grid0');
	array_push($arr1, 'desc07');	array_push($arr2, 'grid');	
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'code');		array_push($arr2, '0');
	array_push($arr1, 'par_val_js'); array_push($arr2, '');
	array_push($arr1, 'par_val');	array_push($arr2, '1');
	array_push($arr1, 'par_nm');	array_push($arr2, 'flex');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	
	/* Module */	
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, '');
	array_push($arr2, 'massimport');
	array_push($arr2, 'module');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Record clear filters */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, 'def');
	array_push($arr2, 'record_clear_filters');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Record manage columns */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, 'record_mng_col');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Record psearch */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, 'record_psearch');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Record refresh */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, 'record_refresh');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Record search */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, 'record_search');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Table */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, '');
	array_push($arr2, 'massimport03');
	array_push($arr2, 'table');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* _d */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, '');
	array_push($arr2, 'massimport03_d');
	array_push($arr2, '_d');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Tmp Table Code */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, '1');
	array_push($arr2, 'return "";');
	array_push($arr2, 'return pegasusSetGlobalVar( $this->container_id . \'_where_massimport03\' ,  \' temp_p50="massimport_z_'.$nr01.'" and temp_p50_nr01=\'.$this->scr_nr01 );');
	array_push($arr2, 'tmp_table_code');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	/* Where */
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	$trash = array_pop($arr2);
	array_push($arr2, '');
	array_push($arr2, 'return pegasusGetGlobalVar($container_id . "_where_massimport03");');
	array_push($arr2, 'where');
	array_push($arr2, pegasus_mysql_newrec('p52'));
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	
	
	
	
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p02');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'desc05');	array_push($arr2, 'grid0');
	array_push($arr1, 'desc07');	array_push($arr2, 'grid');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p52'));
	array_push($arr1, 'par_nm');	array_push($arr2, 'height');
	array_push($arr1, 'par_val');	array_push($arr2, '300');
	pegasus_mysql_insert('p52' , $arr1 , $arr2 );
	
	/*=====================================================================================*/

	//Χρειάζεται unset γιατί δεν γινοταν create ξανα το table αν ειχα enabledcache 
	pegasusUnSetGlobalVar('pegasus_mysql_table_exist_' . 'massimport_z_'.$nr01);
	/*make the temporary table: 'massimport_z_[$nr01]'*/
	pegasus_change_stracture('massimport_z_'.$nr01 , 'massimport_z_'.$nr01.'_d' , 'massimport' , 1);

	/*make the buttons save and close for the _d. insert into p81*/
	$arr1 = array(); $arr2 = array();
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p81'));	
	array_push($arr1, 'pos');		array_push($arr2, 'bottom');
	array_push($arr1, 'tax');		array_push($arr2, 10);
	array_push($arr1, 'title');		array_push($arr2, 'Καταχώρηση');
	array_push($arr1, '_d');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'iconcls');	array_push($arr2, 'icon-save');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'type');		array_push($arr2, 'save_tab');
	array_push($arr1, 'module_00');		array_push($arr2, 'massimport');
	pegasus_mysql_insert('p81' , $arr1 , $arr2 );

	$arr1 = array(); $arr2 = array();
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p81'));	
	array_push($arr1, 'pos');		array_push($arr2, 'bottom');
	array_push($arr1, 'tax');		array_push($arr2, 20);
	array_push($arr1, 'title');		array_push($arr2, 'Κλείσιμο');
	array_push($arr1, '_d');		array_push($arr2, 'massimport_z_'.$nr01.'_d');
	array_push($arr1, 'iconcls');	array_push($arr2, 'icon-close');
	array_push($arr1, 'module');	array_push($arr2, 'massimport');
	array_push($arr1, 'type');		array_push($arr2, 'close_tab');
	array_push($arr1, 'module_00');		array_push($arr2, 'massimport');
	pegasus_mysql_insert('p81' , $arr1 , $arr2 );

	/*give rights for the active profile. insert into p95p50*/
	$arr1 = array(); $arr2 = array();		
	array_push($arr1, 'p50');		array_push($arr2, 'massimport_z_'.$nr01);
	array_push($arr1, 'p95');		array_push($arr2, $_SESSION['user_profile']);
	array_push($arr1, 'ins');		array_push($arr2, 1);
	array_push($arr1, 'del');		array_push($arr2, 1);
	array_push($arr1, 'chan');		array_push($arr2, 1);
	array_push($arr1, 'sh');		array_push($arr2, 1);
	array_push($arr1, 'nr01');		array_push($arr2, pegasus_mysql_newrec('p95p50'));
	pegasus_mysql_insert('p95p50' , $arr1 , $arr2 );
	}


//$calculateFormulas-;$formatData
	/*insert data foreach row of excel*/
	if($keep_table){
		$nr01=$tmp_tbl;
		pegasus_query('TRUNCATE TABLE massimport_z_'.$nr01);
	}
	$jj=0;
	array_push($field_names_array, 'nr01');
	foreach ($objWorksheet->getRowIterator() as $row) {
		$cellIterator = $row->getCellIterator();
		$cellIterator->setIterateOnlyExistingCells(false);
		$ii=0;
		if ($jj==0){
			if ($fld_titles==0){
				$arr2 = array();
				foreach ($cellIterator as $cell) {
					//array_push($arr2, $cell->getValue());
					array_push($arr2, massexport_getFieldValue($cell) );
					$ii++;
					if($ii==$highestColumnIndex){break;}
				}
				//ελεγχος για κενες γραμμες 
				$all_empty = true;
				foreach ($arr2 as $value) {
					if (!empty(trim($value))) {
						$all_empty = false;
						break;
					}			
				}

				if (!$all_empty) {
					array_push($arr2, pegasus_mysql_newrec('massimport_z_'.$nr01));
				}else{
					unset($field_names_array['nr01']);
				}

				if(!$all_empty){
					pegasus_mysql_insert('massimport_z_'.$nr01 , $field_names_array , $arr2 );
				}
			}
		}else{
			$arr2 = array();
			foreach ($cellIterator as $cell) {
				//array_push($arr2, $cell->getValue());
				array_push($arr2, massexport_getFieldValue($cell) ) ;
				$ii++;
				if($ii==$highestColumnIndex){break;}
			}

			// print_r($field_names_array);
			// print_r($arr2);
			// print_r(count($field_names_array));
			// print_r(count($arr2));
			// die('test');

			$all_empty = true;
			foreach ($arr2 as $value) {
				if (!empty(trim($value))) {
					$all_empty = false;
					break;
				}
			}

			if (!$all_empty) {
				array_push($arr2, pegasus_mysql_newrec('massimport_z_'.$nr01));
			}else{
				unset($field_names_array['nr01']);
			}

			if(!$all_empty){
				pegasus_mysql_insert('massimport_z_'.$nr01 , $field_names_array , $arr2 );
			}
		}
		$jj++;
	}

	peg002_clean_dCache('massimport_z_'.$nr01.'_d');
	pegasus_delete_directory('../../tmp/massimport/massimport_z_'.$nr01.'_d');
	
	/*return ok or errors to pegasus screen*/
	$ret_arr['ok'] = 1;
	$ret_arr['msg'] = $_SESSION['peg_dic_massimport_completed'];
	/*$ret_arr['msg'] .= 'Filename: '.$filename;
	$ret_arr['msg'] .= '<br/>highestColumn: '.$highestColumn;
	$ret_arr['msg'] .= '<br/>highestColumnIndex: '.$highestColumnIndex;*/
		
	echo json_encode($ret_arr);