<?php 
	// update v1r13

	function peg_merge_merge_d00_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id='', $merge_table='', $merge_from_nr01=0){
			
		$data['from_nr01'] = $merge_from_nr01;	
		$data['table'] = $merge_table;	
		
		$data['help'] = str_replace('##table##', pegasus_mysql_printfld('p50', 'p03', 'p01=?', array($merge_table)), $_SESSION['peg_dic_merge_msg']);
		return $data;
	}

	 function merge_custom_actions_peg002($retArray=array(), $id=''){
	 	$moduleExistsSuppliers 	= pegasus_module_exists('suppliers');
		$moduleExistsCustomers 	= pegasus_module_exists('customers');
		$moduleExistsCrm001 	= pegasus_module_exists('crm001');
		$moduleExistsInventory 	= pegasus_module_exists('inventory');
		$moduleExistsOrdercust 	= pegasus_module_exists('ordercust');
		$moduleExistsOrdersupp 	= pegasus_module_exists('ordersupp');
		$moduleExistsCrm000 	= pegasus_module_exists('crm000');

		if($moduleExistsSuppliers){
			$peg_handler = 'merge_toolbar_item_merge_a00(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_a00',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_a00',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}

		if($moduleExistsCustomers){
			$peg_handler = 'merge_toolbar_item_merge_a01(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_a01',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_a01',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}	

		if($moduleExistsCrm001){
			$peg_handler = 'merge_toolbar_item_merge_d00(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_d00',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_d00',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}		

		if($moduleExistsInventory){
			$peg_handler = 'merge_toolbar_item_merge_i00(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_i00',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_i00',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}

		if($moduleExistsOrdercust){
			$peg_handler = 'merge_toolbar_item_merge_a57(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_a57',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_a57',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}

		
		if($moduleExistsOrdersupp){
			$peg_handler = 'merge_toolbar_item_merge_a67(screen.getContainer_ID(), \''.$id. '\', \'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[]  = array(
			    'xtype' 		=> 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_a67',
			    'viewModel' 	=> array(
			        'type' 		=> 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' 		=> array(
			            'toolBarButton' => 'merge_a67',
			        )
			    ),
			    'icon'			=> 'merge_images/merge_16x16.png',
			    'text'			=> $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' 	=> $peg_handler
			);	 				
		}


		if($moduleExistsCrm000){
			$peg_handler = 'merge_toolbar_item_merge_d40(
								screen.getContainer_ID(), 
								\''.$id. '\', 
								\'' .$_SESSION['peg_dic_merge_not_selected_rec']. '\' );';
			$retArray[] = array(
			    'xtype' => 'pegasusToolBarGridAction',
			    'peg_custom_id' => 'merge_d40',
			    'viewModel' => array(
			        'type' => 'GridButtonModel',
			        'isToolBar' => 1,
			        'data' => array(
			            'toolBarButton' => 'merge_d40',
			        )
			    ) ,
			    'icon'=> 'merge_images/merge_16x16.png',
			    'text'=>  $_SESSION['peg_dic_merge_toolbar_dic'],
			    'peg_handler' => $peg_handler
			);	 				
		}

		return $retArray;
	 }
	/*
	 * Θα μου φέρει όλους τους πίνακες με τους οποίους
	 * υπάρχει relation με τον δικό μου πίνακα
	 * 
	 * $table:          O πίνακας όπου γίνεται merge
	 * $keys_arr:       Τα κλειδιά για τον πίνακά μου. π.χ. στον i00: pno, nr01
	 * */
	function merge_related_records_query($table='', $keys_arr=array() ){
		
		if(!pegasus_mysql_table_exists($table) || empty($keys_arr)){
			return 'Error 0';
		}
		
		$values = array();

		$query_unformatted = "
				   select 
		
					p20.p03 as rel_tbl,
					p20.p04 as rel_fld1,
					p20.p14 as rel_fld2,
					p20.p24 as rel_fld3,
					
					p20.p01 as main_tbl,
					p20.p02 as main_fld1,
					p20.p12 as main_fld2,
					p20.p22 as main_fld3,
					
					p50.p03 as rel_tbl_desc, 
					##update_fld1##,
					'##key##' as _key
					 
					from p20
					join p50 on p50.p01 = p20.p03 and p50.is_view <> 1
					where 
						##where1##
					
				  UNION
				  
				  select 
		
					p20.p01 as rel_tbl,
					p20.p02 as rel_fld1,
					p20.p12 as rel_fld2,
					p20.p22 as rel_fld3,
					
					p20.p03 as main_tbl,
					p20.p04 as main_fld1,
					p20.p14 as main_fld2,
					p20.p24 as main_fld3,
					
					p50.p03 as rel_tbl_desc, 
					##update_fld2##,
					'##key##' as _key
									  
					from p20
					join p50 on p50.p01 = p20.p01 and p50.is_view <> 1
					where 				  
						##where2##
					";
		
		$i=0;
		$j=1;
		$query = '';

		$values['table'] = $table;
		foreach ($keys_arr as $key => $value) {
			if($i>0){
				$query .= ' 
				  UNION ';
			}
			
			
			$where1 = " ( p20.p01=:table and ( p20.p02=:value_".$i." or p20.p12=:value_".$i." or p20.p22=:value_".$i." ) ) ";
			$where2 = " ( p20.p03=:table and ( p20.p04=:value_".$i." or p20.p14=:value_".$i." or p20.p24=:value_".$i." ) ) ";
			$values['value_'.$i] = $value;

			$update_fld1 = " 
					if( p20.p02='$value', p20.p04, 
										 if(p20.p12='$value', p20.p14, 
															 if(p20.p22='$value', p20.p24, '' )
										   ) 
					  ) as update_fld ";
								
			$update_fld2 = " 
					if( p20.p04='$value', p20.p02, 
										  if(p20.p14='$value', p20.p12, 
															   if(p20.p24='$value', p20.p22, '' )
											) 
						) as update_fld ";	
								
			$query.= str_replace(	array('##where1##', '##where2##', '##update_fld1##', '##update_fld2##', '##key##'), 
									array(  $where1,      $where2,      $update_fld1,      $update_fld2  ,    $value ), 
									$query_unformatted);
																
			$i = $i+1;
		}
		
		return array(
			'sql' => $query, 
			'sqlParams' => $values
		);
	}

	/*
	 * Η βασική συνάρτηση που μου κάνει το merge
	 * 
	 * $checkOnlyPerm == 1: Eμφανίζει το confirmation message
	 * */
	function merge_merge_records($table='', $from_nr01=0, $to_nr01=0, $checkOnlyPerm = 0){
		$res = array();	
		$res['ok'] = 0;
		$res['msg'] = '';
		
		if(!pegasus_mysql_table_exists($table)){
			$res['msg'] = 'Given Table does not exist';
			return $res;
		}		
		if(empty($from_nr01)){
			$from_nr01 = 0;
			merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);
			$table_descr = $main_table_descr ."(".$table.")";
			$res['msg'] = str_replace('##nr01##', $from_nr01, $table_descr.': '.$_SESSION['peg_dic_merge_record_not_found']);
			return $res;
		}
		if(empty($to_nr01)){
			$to_nr01 = 0;
			merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);
			$table_descr = $main_table_descr ."(".$table.")";		
			$res['msg'] = str_replace('##nr01##', $to_nr01, $table_descr.': '.$_SESSION['peg_dic_merge_record_not_found']);
			return $res;
		}	
			
		if(!(pegasus_mysql_printfld($table, 'nr01', ' nr01=? ', array($from_nr01)) >0) ){
			merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);
			$table_descr = $main_table_descr ."(".$table.")";	
			$res['msg'] = str_replace('##nr01##', $from_nr01, $table_descr.': '.$_SESSION['peg_dic_merge_record_not_found']);
			return $res;
		}
		if(!(pegasus_mysql_printfld($table, 'nr01', ' nr01=? ', array($to_nr01)) >0) ){
			merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);
			$table_descr = $main_table_descr ."(".$table.")";		
			$res['msg'] = str_replace('##nr01##', $to_nr01, $table_descr.': '.$_SESSION['peg_dic_merge_record_not_found']);
			return $res;
		}
			
		if($from_nr01 == $to_nr01){
			merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);
			$table_descr = $main_table_descr ."(".$table.")";			
			$res['msg'] = $_SESSION['peg_dic_merge_same_from_to'];
			return $res;
		}

		if(function_exists('merge_execute_extra_'.$table)){
			$extra = call_user_func( 'merge_execute_extra_'.$table, $from_nr01, $to_nr01, $checkOnlyPerm);
			if($extra['ok']!=1){
				$res['msg'] = $extra['msg'];
				return $res;
			}			
		}
		

		$message = merge_execute_merge($table, $from_nr01, $to_nr01, $checkOnlyPerm);


		if(function_exists('after_merge_execute_extra_'.$table)){
			$extra = call_user_func('after_merge_execute_extra_'.$table, $from_nr01, $to_nr01, $checkOnlyPerm);
			if($extra['ok']!=1){
				$res['msg'] = $extra['msg'];
				$res['dbg'] = $extra['dbg'];
				return $res;
			}			
		}
		
		$res['msg'] = $message."<br>".$extra['msg'];
		$res['ok'] = 1;
		
		return $res; ;
	}
	
	
	/*
	 * Επιστρέφει confirmation μήνυμα για την συγχώνευση 2 εγγραφών
	 * Στην περίπτωση που θα πειράξουμε και άλλους πίνακες(συσχετίσεις), 
	 * εμφανίζεται μήνυμα και για αυτούς
	 * */
	function merge_execute_merge($table='', $from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
		
		merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete, $main_table_descr);	

		$message = '';	
		$query   = merge_related_records_query($table, $keys_arr);
		//echo pegasus_replace_values_in_sql($query['sql'], $query['sqlParams']);
		$result  = pegasus_query($query['sql'], $query['sqlParams']);
		
		while($tbl = pegasus_fetch_assoc($result)){

			if(!(pegasus_mysql_printfld($tbl['main_tbl'], $tbl['_key'], ' nr01=? ', array($from_nr01)) >0) ){
				$table_descr = $main_table_descr ."(".$table.")";	
				$message 	.= '<br><br>' . str_replace('##nr01##', $from_nr01, $table_descr.': '.$_SESSION['peg_dic_merge_record_not_found']);
				break;
			}
			
			if($checkOnlyPerm == 1){
				if(!in_array($tbl['rel_tbl'], $exclude_tables) || in_array($tbl['rel_tbl'], $excluded_tables_to_delete)){
					if(in_array($tbl['rel_tbl'], $excluded_tables_to_delete)){
						$response = merge_format_message($tbl, $from_nr01, $to_nr01, 1);
						$message .= $response['msg'];	
					}else{
						$response = merge_format_message($tbl, $from_nr01, $to_nr01);	
						$message .= $response['msg'];
					}
				}
			}else{
				if(!pegasus_mysql_table_exists($tbl['main_tbl']) || 
				   !pegasus_mysql_table_field_exists($tbl['rel_tbl'], $tbl['update_fld']) ||
				   !pegasus_mysql_table_field_exists($tbl['main_tbl'], $tbl['_key'])){
					continue;
				}
				$where = merge_format_where($tbl, $from_nr01);
				if(!in_array($tbl['rel_tbl'], $exclude_tables)){
					$new_value = pegasus_mysql_printfld($tbl['main_tbl'], $tbl['_key'], 'nr01=?', array($to_nr01));
					if(($tbl['rel_tbl']=='a58' || $tbl['rel_tbl']=='a68')){
						//check Η συγχώνευση παραγγελιών ομαδοποιεί τις κινήσεις των ειδών
						if($tbl['rel_tbl'] == 'a58'){
							$check = $_SESSION['f02_pweb05'];
						}elseif($tbl['rel_tbl'] == 'a68'){
							$check = $_SESSION['f02_pweb06'];
						}
						if($check){
							merge_merge_transactions($from_nr01, $to_nr01, $tbl['rel_tbl']);
						}else{
							pegasus_mysql_update($tbl['rel_tbl'], array($tbl['update_fld']), array($new_value), $where['sql'], 0, 1, 1, $where['sqlParams']);
						}
					}else{
						pegasus_mysql_update($tbl['rel_tbl'], array($tbl['update_fld']), array($new_value), $where['sql'], 0, 1, 1, $where['sqlParams']);
						//$tt .= "\nupdate ". $tbl['rel_tbl'] . " set ". $tbl['update_fld'] . '=' . $new_value . ' where ' .$where;
					}
				}	
				else if(in_array($tbl['rel_tbl'], $excluded_tables_to_delete)){
					pegasus_mysql_delete($tbl['rel_tbl'], $where['sql'], 1, $where['sqlParams']);
				}			
			}
		}
		
		if($checkOnlyPerm == 1){
			if(!empty($message)){
				$message = $_SESSION['peg_dic_merge_confirmation_msg_relations']. "\n". $message;		
			}
			$message = "<b>".$main_table_descr."</b><br> ". $_SESSION['peg_dic_merge_confirmation_msg'] ."\n". $message;	
			
			$title_field = pegasus_mysql_printfld('p52', 'desc05', 'par_nm="isTitle" and p02=?', array($table.'_d'));
			if(empty($title_field)){
				$from = $from_nr01;
				$to = $to_nr01;	
			}		
			else{
				$from = pegasus_mysql_printfld($table, $title_field, ' nr01=? ', array($from_nr01)) .' ('.$from_nr01.')';
				$to = pegasus_mysql_printfld($table, $title_field, ' nr01=? ', array($to_nr01)).' ('.$to_nr01.')';				
			}
			
			$message = str_replace('##from##', $from, $message);
			$message = str_replace('##to##', $to, $message);			
		}
		else{
			pegasus_mysql_delete($table, ' nr01 = ? ', 1, array($from_nr01));
			$message .= "<b>".$main_table_descr."</b><br> ".$_SESSION['peg_dic_merge_ok'];			
		}

		
		return $message;
		
	}
	function merge_from_nr01_query($rel_tbl, $from_nr01){

		if($rel_tbl == 'a58'){
			$main_tbl = 'a57';
			$cs_tbl = 'a59';
		}elseif($rel_tbl == 'a68'){
			$main_tbl = 'a67';
			$cs_tbl = 'a69';
		}

		$extra_select = "";
		$extra_join = "";
		if(pegasus_module_exists("colorsize")){
			$extra_select .= ", count(".$cs_tbl.".nr01) as has_color_size ";
			$extra_join .=" LEFT JOIN ".$cs_tbl." on ".$cs_tbl.".p01 = ".$rel_tbl.".nr01 ";
		}
		else{
			$extra_select .= ", 0 as has_color_size ";
		}
		if(pegasus_module_exists("serial")){
			$extra_select .= ", count(i32.nr01) as has_serial ";
			$extra_join .=" LEFT JOIN i32 on i32.p00 = ".$rel_tbl.".nr01 ";
		}
		else{
			$extra_select .= ", 0 as has_serial ";
		}
		if(pegasus_module_exists("lot")){
			$extra_select .= ", count(i38.nr01) as has_lot ";
			$extra_join .=" LEFT JOIN i38 on i38.p01 = ".$rel_tbl.".nr01 ";
		}
		else{
			$extra_select .= ", 0 as has_lot ";
		}

		$my_query = 
			" select ".$rel_tbl.".*
				".$extra_select."
				from ".$rel_tbl." 
				join ".$main_tbl."  on ".$main_tbl.".nr01 = ".$rel_tbl.".p00 
				".$extra_join."
				WHERE ".$main_tbl.".nr01 = :from_nr01
				GROUP BY ".$rel_tbl.".nr01";  
		
	//    echo pegasus_replace_values_in_sql($my_query, array('from_nr01'=>$from_nr01));  
		return pegasus_query($my_query, array('from_nr01'=>$from_nr01));

   }
	function merge_merge_transactions($from_nr01, $to_nr01, $rel_tbl){
        
		if($rel_tbl == 'a58'){
			$cs_tbl = 'a59';
			$serial_p010 = '2';
			$lot_p010 = '2';
		}elseif($rel_tbl == 'a68'){
			$cs_tbl = 'a69';
			$serial_p010 = '3';
			$lot_p010 = '3';
		}

		$trans_res = merge_from_nr01_query($rel_tbl, $from_nr01);
	    while ($trans = pegasus_fetch_assoc($trans_res)) {  
                $extra_select = "";
                $extra_join = "";
				if(pegasus_module_exists("colorsize")){
                    $extra_select .= ", if(count(".$cs_tbl.".nr01)>0,1,0) as has_color_size ";
                    $extra_join .=" LEFT JOIN ".$cs_tbl." on ".$cs_tbl.".p01 = ".$rel_tbl.".nr01 ";
                }
                else{
                    $extra_select .= ", 0 as has_color_size ";
                }
                if(pegasus_module_exists("serial")){
                    $extra_select .= ", if(count(i32.nr01)>0,1,0) as has_serial ";
                    $extra_join .=" LEFT JOIN i32 on i32.p00 = ".$rel_tbl.".nr01 ";
                }
                else{
                    $extra_select .= ", 0 as has_serial ";
                }
                if(pegasus_module_exists("lot")){
                    $extra_select .= ", if(count(i38.nr01)>0,1,0) as has_lot ";
                    $extra_join .=" LEFT JOIN i38 on i38.p01 = ".$rel_tbl.".nr01 ";
                }
                else{
                    $extra_select .= ", 0 as has_lot ";
                }

                //Με το query αυτό, ψάχνω να βρω αν υπάρχει είδος που έχω ήδη καταχωρησει και μπορεί να groupαριστεί
                //με την εγγραφή που πάω να καταχωρήσω τώρα
				// v103 posothta, v101 kwdikos
                $sql_update = "SELECT 
                                ".$rel_tbl.".nr01 as nr01,
                                ".$rel_tbl.".v103 as v103, 
                                ".$rel_tbl.".v120 as v120, 
                                ".$rel_tbl.".v107 as v107, 
                                ".$rel_tbl.".v1042 as v1042, 
                                ".$rel_tbl.".v109 as v109, 
                                ".$rel_tbl.".v111 as v111, 
								".$rel_tbl.".v301 as v301,
                                ".$rel_tbl.".v101 as v101,
								".$rel_tbl.".v104 as v104,
								".$rel_tbl.".v105 as v105,
								".$rel_tbl.".v106 as v106,
								".$rel_tbl.".v106a as v106a,
								".$rel_tbl.".v102 as v102,
								".$rel_tbl.".v160 as v160,
								".$rel_tbl.".v1030_1 as v1030_1,
								".$rel_tbl.".v104_1 as v104_1,
								".$rel_tbl.".v900 as v900,
								".$rel_tbl.".p703 as p703,
								".$rel_tbl.".v616 as v616,
								".$rel_tbl.".v1041 as v1041,
								".$rel_tbl.".v310 as v310,
								".$rel_tbl.".v108 as v108,
								".$rel_tbl.".i18a58 as i18a58,
								".$rel_tbl.".i19p03 as i19p03,
								".$rel_tbl.".v302 as v302,
								".$rel_tbl.".v303 as v303,
								".$rel_tbl.".v304 as v304,
								".$rel_tbl.".v306 as v306,
								".$rel_tbl.".v309 as v309,
								".$rel_tbl.".v307 as v307,
								".$rel_tbl.".v308 as v308,
								".$rel_tbl.".v161 as v161,
								".$rel_tbl.".v614 as v614,
								".$rel_tbl.".vd100 as vd100,
								".$rel_tbl.".vd101 as vd101,
								".$rel_tbl.".vd102 as vd102,
								".$rel_tbl.".vd01 as vd01
                                ".$extra_select."
                                FROM ".$rel_tbl."
                                ".$extra_join." 
                                WHERE ".$rel_tbl.".v101= :v101  
								AND ".$rel_tbl.".p00 = :to_nr01
                                group by ".$rel_tbl.".nr01
                                having has_color_size = :has_colorsize 
                                        and has_serial = :has_serial 
                                        and has_lot = :has_lot
                                        and v104 = :v104
                                        and v105 = :v105
                                        and v106 = :v106
                                        and v106a = :v106a
                                        and v102 = :v102
                                        and v160 = :v160
                                        and v1030_1 = :v1030_1
                                        and v104_1 = :v104_1
                                        and v900 = :v900
                                        and p703 = :p703
                                        and v616 = :v616
                                        and v1041 = :v1041
                                        and v310 = :v310
                                        and v108 = :v108
                                        and i18a58 = :i18a58
                                        and i19p03 = :i19p03
                                        and v302 = :v302
                                        and v303 = :v303
                                        and v304 = :v304
                                        and v306 = :v306
                                        and v309 = :v309
                                        and v307 = :v307
                                        and v308 = :v308
                                        and v161 = :v161
                                        and v614 = :v614
                                        and vd101 = :vd101
                                        and vd102 = :vd102
                                        and vd01 = :vd01";
										
                pegasus_mysql_use(
                    $sql_update, 
                    $trans_tmp, 
                    array(
                            'v101' => $trans['v101'], 
                            'to_nr01' => $to_nr01, 
                            'has_colorsize' => ($trans['has_color_size'] > 0)?1:0  , 
                            'has_serial' => ($trans['has_serial'] > 0)?1:0, 
                            'has_lot' => ($trans['has_lot'] > 0)?1:0,
							'v104' => $trans['v104'],   // Τιμή Μονάδας
							'v105' => $trans['v105'],   // % ΦΠΑ
							'v106' => $trans['v106'],   // % Έκπτωσης 1
							'v106a' => $trans['v106a'], // % Έκπτωσης 2
							'v102' => $trans['v102'],   // Περιγραφή
							'v160' => $trans['v160'],	// Αιτιολογία
							'v1030_1' => $trans['v1030_1'], // Ποσότητα Συσκευασίας
							'v104_1' => $trans['v104_1'],	// Τιμή Συσκευασίας
							'v900' => $trans['v900'],		// Κατάσταση
							'p703' => $trans['p703'],		// Αποθήκη 1
							'v616' => $trans['v616'],		// ΕΦΚ
							'v1041' => $trans['v1041'],		// Εισφορά
							'v310' => $trans['v310'],		// Απόβαρο
							'v108' => $trans['v108'],		// Κατηγορία ΦΠΑ
							'i18a58' => $trans['i18a58'],	// M.K. Kίνησης είδους συνταγής
							'i19p03' => $trans['i19p03'],	// Ποσότητα συνταγής
							'v302' => $trans['v302'],		// Μήκος
							'v303' => $trans['v303'],		// Πλάτος
							'v304' => $trans['v304'],		// Ύψος
							'v306' => $trans['v306'],		// Βάρος
							'v309' => $trans['v309'],		// Κόλλα
							'v307' => $trans['v307'],		// Αλλαγή Τελ.Ποσότητας
							'v308' => $trans['v308'],		// Συσκευασία
							'v161' => $trans['v161'],		// Παλιός Κωδ.Παρτίδας
							'v614' => $trans['v614'],		// Κατώτερη Τιμή Πώλησης
							'vd101' => $trans['vd101'],		// Σχετικός Πίνακας
							'vd102' => $trans['vd102'],		// M.K.Σχετικής Κίνησης
							'vd01' => $trans['vd01'],		// Παράμετρος 1
                    )
                        
                ); 

				
				if($trans_tmp['nr01']>0){
					if($trans['has_color_size']==0 && $trans['has_serial']==0 && $trans['has_lot']==0){
						//ψάχνω ένα a58/a68 δεν έχει ούτε ΧΜ ούτε Serial ούτε Παρτίδες και έχει κοινό είδος
						//τα a58/a68 με το συγκεκριμένο είδος
						$arr1 = array();
						$arr2 = array();
						array_push($arr1, 'v103');           array_push($arr2, $trans_tmp['v103']+$trans['v103']); // Ποσότητα
						array_push($arr1, 'v120');           array_push($arr2, $trans_tmp['v120']+$trans['v120']); // Δευτ Ποσότητα
						array_push($arr1, 'v107');           array_push($arr2, $trans_tmp['v107']+$trans['v107']); // Σύνολο
						array_push($arr1, 'v1042');           array_push($arr2, $trans_tmp['v1042']+$trans['v1042']); // Επιπλέον Αξία
						array_push($arr1, 'v109');           array_push($arr2, $trans_tmp['v109']+$trans['v109']); // Τιμολογημένη Ποσότητα
						array_push($arr1, 'v111');           array_push($arr2, $trans_tmp['v111']+$trans['v111']); // Τιμολογημένα Τεμάχια
						array_push($arr1, 'v301');           array_push($arr2, $trans_tmp['v301']+$trans['v301']); // Τεμάχια
						
						pegasus_mysql_update(
							$rel_tbl, $arr1,  $arr2,  
							"nr01=?", 
							0, 1, 1, 
							array($trans_tmp['nr01'])
						);
						continue;
					}
					elseif($trans['has_color_size']>=1 && $trans['has_serial']==0 && $trans['has_lot']==0){
						// ψάχνω ένα a58/a68 έχει μόνο ΧΜ και έχει κοινό είδος 
						// Αν είναι ίδιο ΧΜ αθξάνω την ποσοτητα στο a59/a69 και στο a58/a68. Αλλιώς αυξάνω την ποσότητα στο a58/a68 και προσθέτω ένα a59/a69
						$arr1 = array();
						$arr2 = array();
						array_push($arr1, 'v103');           array_push($arr2, $trans_tmp['v103']+$trans['v103']); // Ποσότητα
						array_push($arr1, 'v120');           array_push($arr2, $trans_tmp['v120']+$trans['v120']); // Δευτ Ποσότητα
						array_push($arr1, 'v107');           array_push($arr2, $trans_tmp['v107']+$trans['v107']); // Σύνολο
						array_push($arr1, 'v1042');           array_push($arr2, $trans_tmp['v1042']+$trans['v1042']); // Επιπλέον Αξία
						array_push($arr1, 'v109');           array_push($arr2, $trans_tmp['v109']+$trans['v109']); // Τιμολογημένη Ποσότητα
						array_push($arr1, 'v111');           array_push($arr2, $trans_tmp['v111']+$trans['v111']); // Τιμολογημένα Τεμάχια
						array_push($arr1, 'v301');           array_push($arr2, $trans_tmp['v301']+$trans['v301']); // Τεμάχια
						
						
						pegasus_mysql_update(
							$rel_tbl, $arr1,  $arr2,  
							"nr01=?", 
							0, 1, 1, 
							array($trans_tmp['nr01'])
						);
						
						$res_a59_a69 = pegasus_query("SELECT * FROM ".$cs_tbl." WHERE p01 = :p01", array('p01' => $trans['nr01']));
						while($a59_a69 = pegasus_fetch($res_a59_a69)) {     
							//a59/a69 με το συγκεκριμένο είδος, χρώμα, μέγεθος
							pegasus_mysql_use(
								"SELECT * 
								FROM ".$cs_tbl." 
								WHERE 
									p01=:trans_nr01 AND 
									p02=:p02 AND 
									p03=:p03", 
								$a59_a69_tmp, 
								array( 
									'trans_nr01'=> $trans_tmp['nr01'], 
									'p02'=>$a59_a69['p02'], 
									'p03'=>$a59_a69['p03']
								)
							);
							if($a59_a69_tmp['nr01']>0){
								$arr3 = array();
								$arr4 = array();
								array_push($arr3, 'p04');           array_push($arr4, $a59_a69_tmp['p04']+$a59_a69['p04']);
								pegasus_mysql_update(
									$cs_tbl, $arr3,  $arr4,  
									"nr01=:nr01",
									0, 1, 1, 
									array('nr01' => $a59_a69_tmp['nr01'])
								);
							}else{
								pegasus_mysql_update($cs_tbl, array('p01'), array($trans_tmp['nr01']), "nr01=?", 0, 1, 1, array($a59_a69['nr01']));
							}
						}
						continue;
					}
					elseif($trans['has_color_size']==0 && $trans['has_serial']>=1 && $trans['has_lot']==0){
					    // ψάχνω ένα a58/a68 έχει μόνο SN και έχει κοινό είδος
					    // Αυξάνω την ποσότητα στο a58/a68 και προσθέτω ένα i32 
	   
						$arr1 = array();
						$arr2 = array();
						array_push($arr1, 'v103');           array_push($arr2, $trans_tmp['v103']+$trans['v103']); // Ποσότητα
						array_push($arr1, 'v120');           array_push($arr2, $trans_tmp['v120']+$trans['v120']); // Δευτ Ποσότητα
						array_push($arr1, 'v107');           array_push($arr2, $trans_tmp['v107']+$trans['v107']); // Σύνολο
						array_push($arr1, 'v1042');           array_push($arr2, $trans_tmp['v1042']+$trans['v1042']); // Επιπλέον Αξία
						array_push($arr1, 'v109');           array_push($arr2, $trans_tmp['v109']+$trans['v109']); // Τιμολογημένη Ποσότητα
						array_push($arr1, 'v111');           array_push($arr2, $trans_tmp['v111']+$trans['v111']); // Τιμολογημένα Τεμάχια
						array_push($arr1, 'v301');           array_push($arr2, $trans_tmp['v301']+$trans['v301']); // Τεμάχια
						
						pegasus_mysql_update(
							$rel_tbl, $arr1,  $arr2,  
							"nr01=?", 
							0, 1, 1,
							array($trans_tmp['nr01']) 
						);


						$i32_query = "select * from i32 where p010=:p010 and p00=:p00";
						$res_i32 = pegasus_query($i32_query, array('p010'=>$serial_p010, 'p00'=>$trans['nr01']));
	
						while ($i32 = pegasus_fetch($res_i32)) {
							pegasus_mysql_update('i32', array('p00'), array($trans_tmp['nr01']), "nr01=?", 0, 1, 1, array($i32['nr01']));
						}
						continue;
					}
					elseif($trans['has_color_size']==0 && $trans['has_serial']==0 && $trans['has_lot']>=1){
					     // ψάχνω ένα a58/a68 έχει μόνο Παρτίδα και έχει κοινό είδος
					     // Αν είναι ίδια παρτιδα αυξάνω την ποσοτητα στο i38 και στο a58/a68. Αλλιώς αυξάνω την ποσότητα στο a58/a68 και προσθέτω ένα i38
					 
		
					    if($trans_tmp['nr01']>0){
					        $arr1 = array();
					        $arr2 = array();
							array_push($arr1, 'v103');           array_push($arr2, $trans_tmp['v103']+$trans['v103']); // Ποσότητα
							array_push($arr1, 'v120');           array_push($arr2, $trans_tmp['v120']+$trans['v120']); // Δευτ Ποσότητα
							array_push($arr1, 'v107');           array_push($arr2, $trans_tmp['v107']+$trans['v107']); // Σύνολο
							array_push($arr1, 'v1042');           array_push($arr2, $trans_tmp['v1042']+$trans['v1042']); // Επιπλέον Αξία
							array_push($arr1, 'v109');           array_push($arr2, $trans_tmp['v109']+$trans['v109']); // Τιμολογημένη Ποσότητα
							array_push($arr1, 'v111');           array_push($arr2, $trans_tmp['v111']+$trans['v111']); // Τιμολογημένα Τεμάχια
							array_push($arr1, 'v301');           array_push($arr2, $trans_tmp['v301']+$trans['v301']); // Τεμάχια
							
					        pegasus_mysql_update(
								$rel_tbl, $arr1,  $arr2,  
								"nr01=?", 
								0, 1, 1,
								array($trans_tmp['nr01']) 
							);           
							
					        //  Παίρνουμε όλα τα i38 για αυτήν την κίνηση 
					        $i38_query = "select * from i38 where p010=:p010 and p01=:p01";
					        $res_i38 = pegasus_query($i38_query, array('p010'=>$lot_p010, 'p01'=>$trans['nr01']));
							
					        while ($i38 = pegasus_fetch($res_i38)) {
					            pegasus_mysql_use(
					                'SELECT * FROM i38 WHERE p01=:trans_nr01 AND p02=:p02', 
					                $i38_tmp,
					                array(
					                    'trans_nr01'=> $trans_tmp['nr01'],
					                    'p02'=>$i38['p02']
					                )
					            );
		
					            if($i38_tmp['nr01']>0){
					                $arr3 = array();
					                $arr4 = array();
					                array_push($arr3, 'p04');           array_push($arr4, $i38_tmp['p04']+$i38['p04']);
					                pegasus_mysql_update(
					                    'i38', $arr3,  $arr4,  
					                    'i38.nr01= :nr01', 
					                    0, 1, 1,
					                    array(
					                        'nr01' => $i38_tmp['nr01']
					                    ) 
					                );								
					            }else{
					                pegasus_mysql_update('i38', array('p01'), array($trans_tmp['nr01']), "nr01=?", 0, 1, 1, array($i38['nr01']));
					            }
					        }
					        continue;
					    }  
					}
				}else{
					pegasus_mysql_update($rel_tbl, array('p00'), array($to_nr01), 'nr01=?', 0, 1, 1, array($trans['nr01']));
				}
        }      
	} 


	/*
	 * $tbl : rel_tbl, rel_fld1, rel_fld2, rel_fld3, rel_tbl_desc
	 * 		  main_tbl, main_fld1, main_fld2, main_fld3, _key
	 * */
	
	function merge_format_message($tbl, $from_nr01, $to_nr01, $only_delete=0){

		$select = 'select p52.desc05 from p52 join p51 on p51.desc05=p52.desc05 and p51.p02=p52.p02 where p52.par_nm="isTitle" and p52.p02=?';
		pegasus_mysql_use($select, $p52_arr, array($tbl['rel_tbl'].'_d'));

		$title_field = $p52_arr['desc05'];
		if(empty($title_field)){
			$title_field = 'nr01';
		}
		$select  = "select if(".$title_field."='',nr01 ,".$title_field.") as title from ". $tbl['rel_tbl'] ;
		$where   = merge_format_where($tbl, $from_nr01);
		$select .= " where ". $where['sql'];
		

		$message = '';
		if($only_delete == 0){
			$field = pegasus_mysql_printfld('p51','desc02', 
			'p02=:p02 and desc05=:desc05 ', array(
				'p02' => $tbl['rel_tbl'] . '_d',
				'desc05' => $tbl['update_fld']
			));
			$message .= '<br><br>'.$_SESSION['peg_dic_merge_confirmation_msg_field_update'];			
		}
		else{
			$message .= '<br><br>'.$_SESSION['peg_dic_merge_confirmation_msg_field_delete'];	
		}
		
		$message = str_replace(array('##field##', '##rel_tbl_desc##', '##rel_tbl##'), array($field, $tbl['rel_tbl_desc'], $tbl['rel_tbl']), $message);					
							
		//$message .= $where;
		$result = pegasus_query($select, $where['sqlParams']);
		//echo pegasus_replace_values_in_sql($select, $where['sqlParams']);

		$count = 0;
		while($tbl_temp = pegasus_fetch_assoc($result)){
			if($count > 0){
				$nr01_str .= ', ';	
			}
			$nr01_str .= $tbl_temp['title'];
			$count = $count + 1;
		}	
		
		$message .= "<br>".$_SESSION['peg_dic_merge_confirmation_msg_num_of_recs'].$count;
		if($count > 0){
			$message .= "    (".$nr01_str.")";
			return array('count'=>$count, 'msg'=>$message);	
		}

		return array('count'=>0, 'msg'=>'');			
	}
	
	

	/*
	 * $tbl : rel_tbl, rel_fld1, rel_fld2, rel_fld3, rel_tbl_desc
	 * 		  main_tbl, main_fld1, main_fld2, main_fld3, _key
	 * */
	function merge_format_where($tbl, $from_nr01){

		$where = '  ';
		$values = array();

		if(substr($tbl['rel_fld1'], 0, 2) == "!:"){
			$where .= ' :rel_fld1 ';
			$values['rel_fld1'] = substr($tbl['rel_fld1'],2);
		}
		else{
			$where .= $tbl['rel_tbl'].'.'.$tbl['rel_fld1'];	
		}
		$where .='=';
		if(substr($tbl['main_fld1'], 0, 2) == "!:"){
			$where .= ' :main_fld1 ';
			$values['main_fld1'] = substr($tbl['main_fld1'],2);
		}
		else{
			$where .= ' :main_fld1 ';
			$values['main_fld1'] = pegasus_mysql_printfld($tbl['main_tbl'], 
			$tbl['main_tbl'].'.'.$tbl['main_fld1'], ' nr01=? ', array($from_nr01));
		}
							
		if( !empty($tbl['rel_fld2']) && !empty($tbl['main_fld2'])){
			$where .=' and ';
			if(substr($tbl['rel_fld2'], 0, 2) == "!:"){
				$where .= ' :rel_fld2 ';
				$values['rel_fld2'] = substr($tbl['rel_fld2'],2);
			} else {
				$where .= $tbl['rel_tbl'].'.'.$tbl['rel_fld2'];	
			}
			$where .='=';
			if(substr($tbl['main_fld2'], 0, 2) == "!:"){
				$where .= ' :main_fld2 ';
				$values['main_fld2'] = substr($tbl['main_fld2'],2);
			}
			else{
				$where .= ' :main_fld2 ';
				$values['main_fld2'] = pegasus_mysql_printfld($tbl['main_tbl'], $tbl['main_tbl'].'.'.$tbl['main_fld2'], ' nr01=? ', array($from_nr01));
			}
			
		}								

		if( !empty($tbl['rel_fld3']) && !empty($tbl['main_fld3'])){
			$where .=' and ';
			if(substr($tbl['rel_fld3'], 0, 2) == "!:"){
				$where .= ' :rel_fld3 ';
				$values['rel_fld3'] = substr($tbl['rel_fld3'],2);
			} else {
				$where .= $tbl['rel_tbl'].'.'.$tbl['rel_fld3'];	
			}
			$where .='=';
			
			if(substr($tbl['main_fld3'], 0, 2) == "!:"){
				$where .= ' :main_fld3 ';
				$values['main_fld3'] = substr($tbl['main_fld3'],2);
			}
			else{
				$where .= ' :main_fld3 ';
				$values['main_fld3'] = pegasus_mysql_printfld($tbl['main_tbl'], $tbl['main_tbl'].'.'.$tbl['main_fld3'], ' nr01=? ', array($from_nr01));
			}
		}		

		return array(
			'sql' => $where, 
			'sqlParams' => $values 
		);
	}
		

	function merge_initialize_table_values($table, &$keys_arr, &$exclude_tables, &$excluded_tables_to_delete, &$main_table_descr){

		switch ($table) {
			case "a57":
				$keys_arr 					= array('nr01');
				$excluded_tables_to_delete 	= array('courier01_02','courier03_01');
				$exclude_tables   			= array_merge($excluded_tables_to_delete, array('woocom20','skroutz00_01'));
				$main_table_descr 			= $_SESSION['peg_dic_merge_a57_title'];
		        break;

			case "a67":
				$keys_arr 					= array('nr01');
				$excluded_tables_to_delete 	= array();
				$exclude_tables   			= array();
				$main_table_descr 			= $_SESSION['peg_dic_merge_a67_title'];
		        break;

		    case "i00":
				$keys_arr = array('nr01', 'pno');
				$excluded_tables_to_delete = array(
					'a72','a74','herp01','herp07','herp80','herp90','herpg9','heru10',
					'i00tot','i00_multi','i05','i06','i07','i08','i17','i18','i19','i28',
					'i37','i39','i47tot','inventory_002','products02_01','rating01','z21','hota74'
				);
				$exclude_tables   = array_merge($excluded_tables_to_delete, array('i47'));
				$main_table_descr = $_SESSION['peg_dic_merge_i00_title'];
		        break;
		    case "d00":
				$keys_arr = array('nr01');
				$exclude_tables = array('z29', 'heru01', 'social01');
				$excluded_tables_to_delete = array('z29', 'heru01', 'social01');
				$main_table_descr = $_SESSION['peg_dic_merge_d00_title'];
		        break;
		    case "t00":
				$keys_arr = array('p01');
				$exclude_tables = array('t00tot', 'a01', 'a00');
				$excluded_tables_to_delete = array('t00tot');
				$main_table_descr = $_SESSION['peg_dic_merge_t00_title'];
		        break;
		    case "a01":
				$keys_arr = array('nr01');
				$exclude_tables = array('hota72');
				$excluded_tables_to_delete = array('hota72');
				$main_table_descr = $_SESSION['peg_dic_merge_a01_title'];
		        break;
		    case "a00":
				$keys_arr = array('nr01');
				$exclude_tables = array('r31');
				$excluded_tables_to_delete = array('r31');
				$main_table_descr = $_SESSION['peg_dic_merge_a00_title'];
		        break;	
			case "d40":
				$keys_arr = array('p02');
				$exclude_tables = array();
				$excluded_tables_to_delete = array();
				$main_table_descr = $_SESSION['peg_dic_merge_d40_title'];
				break;											
		    default:
				$keys_arr = array();
				$exclude_tables = array();
				$excluded_tables_to_delete = array();
				$main_table_descr = '';					
		        
		}
	}
		
	/*
	 * Πριν κάνω merge τον a01 θα πρέπει να κάνω merge και το t00(1-1 συσχέτιση)
	 * Εαν $checkOnlyPerm == 0 και υπάρχουν εγγραφές σε session πίνακα  εμφανιζω μήνυμα για ogin logout
	 * */
	function merge_execute_extra_a01($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
			
		$message = '';
		$t00_p01_from = pegasus_mysql_printfld('a01', 'p21', 'nr01=?', array($from_nr01));
		$t00_p01_to = pegasus_mysql_printfld('a01', 'p21', 'nr01=?', array($to_nr01));
		$t00_nr01_to = pegasus_mysql_printfld('t00', 'nr01', ' p01=? ', array($t00_p01_to)); 
		
		if( ($t00_nr01_from = pegasus_mysql_printfld('t00', 'nr01', ' p01=? ', array($t00_p01_from)))>0  /*or
			$t00_nr01_to>0 */) 
		{
			 $t00_res = merge_merge_records('t00', $t00_nr01_from, $t00_nr01_to, $checkOnlyPerm);	
			 $message .= $t00_res['msg'];
			 if($t00_res['ok']!=1){ return array('ok'=>0, 'msg'=>$message);}	
		}

		if($checkOnlyPerm == 0){
			$session_tables = array('herh00', 'cor003', 'hcou00', 'hota98');
			$message .= merge_is_logout_necessary('a01', $session_tables, $from_nr01, $to_nr01);
		}						 
		return array('ok'=>1, 'msg'=>$message);
	}
	
	/*
	 * Πριν κάνω merge τον a00 θα πρέπει να κάνω merge και το t00(1-1 συσχέτιση)
	 * Εαν $checkOnlyPerm == 0 και υπάρχουν εγγραφές σε session πίνακα  εμφανιζω μήνυμα για ogin logout
	 * */
	function merge_execute_extra_a00($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
			
		$message = '';
		$t00_p01_from = pegasus_mysql_printfld('a00', 'p21', 'nr01=?', array($from_nr01));
		$t00_p01_to = pegasus_mysql_printfld('a00', 'p21', 'nr01=?', array($to_nr01));
		$t00_nr01_to = pegasus_mysql_printfld('t00', 'nr01', ' p01=? ', array($t00_p01_to));
		
		if( ($t00_nr01_from = pegasus_mysql_printfld('t00', 'nr01', ' p01=? ', array($t00_p01_from)))>0 /* or
			$t00_nr01_to>0 */) 
		{
			 $t00_res = merge_merge_records('t00', $t00_nr01_from, $t00_nr01_to, $checkOnlyPerm);	
			 $message .= $t00_res['msg'];
			 if($t00_res['ok']!=1){ return array('ok'=>0, 'msg'=>$message);}	
		}
						 
		return array('ok'=>1, 'msg'=>$message);
	}	
	function merge_execute_extra_d00($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
		
		$message = '';
		if($checkOnlyPerm == 0){
			$session_tables = array('us0', 'hlrn00', 'dom000', 'herm99');
			$message = merge_is_logout_necessary('d00', $session_tables, $from_nr01, $to_nr01);
		}	

		return array('ok'=>1, 'msg'=>$message);			
	}

	/*
	 * Πριν κάνω merge τον i00 θα πρέπει να κάνω merge και το i47 (1-1 συσχέτιση)
	 * Εαν $checkOnlyPerm == 0 και υπάρχουν εγγραφές σε session πίνακα  εμφανιζω μήνυμα για ogin logout
	 * */
	function merge_execute_extra_i00($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
			
		$message = '';

		$tbl_arr = array();
		if($checkOnlyPerm == 1){
			$query  = merge_related_records_query('i00', array('nr01', 'pno'));
			$result = pegasus_query($query['sql'], $query['sqlParams']);
			while($tbl = pegasus_fetch_assoc($result)){
				if(in_array($tbl['rel_tbl'], array('i47'))){
					$tbl_arr[] = $tbl;	
					break;						
				}
			}
			
		}
		
		if(pegasus_module_exists('colorsize')){

			//Πλήθος Εγγραφών i47 "Απο Είδος"
			$i47_total = pegasus_mysql_printfld('i47', 'count(*)', 'i00=:from_nr01', array('from_nr01'=>$from_nr01));
	
			//i47: Αν βρω ιδιο 147 (χρωμα/μεγεθος) σε παλιο και νεο Ειδος κανω Delete του παλιου, αλλιώς Update
			$i47_query  = "select ifnull(group_concat(i47_1.nr01), '') as i47_1_in ";
			$i47_query .= "from i47 as i47_1, i47 as i47_2 ";
			$i47_query .= "where i47_2.p02=i47_1.p02 and i47_2.p03=i47_1.p03 ";
			$i47_query .= "and i47_1.i00=:from_nr01 and i47_2.i00=:to_nr01";
			pegasus_mysql_use($i47_query, $i47_in, array('from_nr01'=>$from_nr01,'to_nr01'=>$to_nr01));
			
			$i47_in_arr	= explode(',', $i47_in['i47_1_in']);
			$i47_cnt 	= count($i47_in_arr);
	
			if($i47_cnt>0){
				$i47_stm 	= pegasus_mysql_create_in($i47_in_arr, 'i47nr01');
	
				if($checkOnlyPerm == 1){
					foreach ($tbl_arr as $tbl_tmp) {
						$response = merge_format_message($tbl_tmp, $from_nr01, $to_nr01, 1);
						$message .= $response['msg'];
					}
					if($i47_cnt<$i47_total){
						$message = str_replace(array(':'.$response['count']), array(':'.$i47_cnt.'/'.$response['count']), $message);			
					}
				}else{
					pegasus_mysql_delete('i47', 'nr01 in (' .$i47_stm['sql'].')', 1, $i47_stm['sqlParams']);
				}			
			}
			
			if($i47_cnt<$i47_total){
				if($checkOnlyPerm == 1){
					foreach ($tbl_arr as $tbl_tmp) {
						$response = merge_format_message($tbl_tmp, $from_nr01, $to_nr01);
						$message .= $response['msg'];
					}
					$message = str_replace(array(':'.$response['count']), array(':'.($i47_total-$i47_cnt).'/'.$response['count']), $message);
				}else{
					$to_pno = pegasus_mysql_printfld('i00', 'pno', 'nr01=?', array($to_nr01));
					pegasus_mysql_update('i47', array('i00','p01'), array($to_nr01, $to_pno), 'i47.i00=:from_nr01', 0, 1, 1, array('from_nr01'=>$from_nr01));
				}
			}
			
		}	
		
		
		return array('ok'=>1, 'msg'=>$message);
	}
	
	function merge_is_logout_necessary($table, $session_tables, $from_nr01=0, $to_nr01=0)	{

		merge_initialize_table_values($table, $keys_arr, $exclude_tables, $excluded_tables_to_delete , $main_table_descr);	
		$logout_necessary = false;

		$query = merge_related_records_query($table, $keys_arr);
		$result = pegasus_query($query['sql'], $query['sqlParams']);
		while($tbl = pegasus_fetch_assoc($result)){
			if( (!in_array($tbl['rel_tbl'], $exclude_tables) ||
				  in_array($tbl['rel_tbl'], $excluded_tables_to_delete)
				 )
				 and in_array($tbl['rel_tbl'], $session_tables)){
				
				$where = merge_format_where($tbl, $from_nr01); 
				$nr01 = pegasus_mysql_printfld($tbl['rel_tbl'], 'nr01', $where['sql'], $where['sqlParams']);
				if( $nr01>0 ){
					$logout_necessary = true;
					break;
				}								
			}
		}
			

		if($logout_necessary){
			$message .= $_SESSION['peg_dic_merge_logout_necessary'];
		}			
		return $message;
	}
	
	
	/*
	 * Αφου κάνω merge τον a57 θα πρέπει να υπολογίζω ξανά τα Σύνολα
	 * */
	function after_merge_execute_extra_a57($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
			
		$message = '';

		$totals_array = array();
		if(pegasus_module_exists('invoices')){
			
			pegasus_mysql_use("select * from a57 where nr01=:to_nr01", $data_a57, array("to_nr01"=>$to_nr01));

			$nr01	 	   = $to_nr01;
			$mode   	   = "a57";
			$product_table = 'a58';	
			$product_where = array("sql"=>"p00=:to_nr01", "sqlParams"=>array("to_nr01"=>$to_nr01));

			
			$a01_p09 		  = $data_a57['p09'];
			$preview_with_vat = $data_a57['p07'];

			$p0101 	 = $data_a57['p0101'];
			$p0112 	 = $data_a57['p0112'];
			$p0113 	 = $data_a57['p0113'];
			$p0103   = $data_a57['p0103'];
			$p0108   = $data_a57['p0108'];
			$p410 	 = $data_a57['p410'];
			$p506 	 = $data_a57['p0101'];
			$p0102_1 = $data_a57['p0102_1'];
			$p0102_2 = $data_a57['p0102_2'];
			$p01080  = 0;
			$pn02    = 1;
			$date 	 = "";
			$_totals = array();

			$totals_array = invoices_calculate_total(
				$product_table,
				$product_where,
				$p0101,
				$p0112,
				$p0113,
				$p0103,
				$p0108,
				$a01_p09,
				$preview_with_vat,
				$p410,
				$_totals,
				$p506,
				$p0102_1,
				$p0102_2,
				$p01080,
				$mode,
				$date,
				$nr01,
				$pn02
			);

			if($checkOnlyPerm==0){
				$arr1 = array();	$arr2 = array();
				foreach ($totals_array as $key => $value) {				
					array_push($arr1, $key);	array_push($arr2, $value);
				}
				pegasus_mysql_update('a57', $arr1, $arr2, 'nr01=:to_nr01', 0, 1, 1, array('to_nr01'=>$to_nr01));
			}
		}
						 
		return array('ok'=>1, 'msg'=>$message);
	}


	/*
	 * Αφου κάνω merge τον a67 θα πρέπει να υπολογίζω ξανά τα Σύνολα
	 * */
	function after_merge_execute_extra_a67($from_nr01=0, $to_nr01=0, $checkOnlyPerm=0){
			
		$message      = '';
		$totals_array = array();

		if(pegasus_module_exists('invoices')){
			
			pegasus_mysql_use("select * from a67 where nr01=:to_nr01", $data_a67, array("to_nr01"=>$to_nr01));

			$nr01	 	   = $to_nr01;
			$mode   	   = "a67";
			$product_table = 'a68';	
			$product_where = array("sql"=>"p00=:to_nr01", "sqlParams"=>array("to_nr01"=>$to_nr01));

			
			$a00_p09 		  = $data_a67['p09'];
			$preview_with_vat = $data_a67['p07'];

			$p0101 	 = $data_a67['p0101'];
			$p0112 	 = $data_a67['p0112'];
			$p0113 	 = $data_a67['p0113'];
			$p0103   = $data_a67['p0103'];
			$p0108   = $data_a67['p0108'];
			$p410 	 = $data_a67['p410'];
			$p420    = $data_a67['p420'];
			$p506 	 = 0;	//Μ.Κ δωροεπιταγής - Υπάρχει μόνο σε παραγγελίες/παραστατικά πελάτη

			$p0102_1 = $data_a67['p0102_1'];	//Αξιακή Εκπτωση (από Χρήστη)
			$p0102_2 = $data_a67['p0102_2']; 	//Έκπτωση Στο Σύνολο (από Χρήστη)
			$p01080	 = 0;
			
			$pn02    = 1;
			$date 	 = $data_a67['p01'];	//Ημερομηνία
			$_totals = array();

			$totals_array = invoices_calculate_total(
				$product_table,
				$product_where,
				$p0101,
				$p0112,
				$p0113,
				$p0103,
				$p0108,
				$a00_p09,
				$preview_with_vat,
				$p410,
				$_totals,
				$p506,
				$p0102_1,
				$p0102_2,
				$p01080,
				$mode,
				$date,
				$nr01,
				$pn02,
				$p420
			);

			if($checkOnlyPerm==0){
				$arr1 = array();	$arr2 = array();
				foreach ($totals_array as $key => $value) {				
					array_push($arr1, $key);	array_push($arr2, $value);
				}
				pegasus_mysql_update('a67', $arr1, $arr2, 'nr01=:to_nr01', 0, 1, 1, array('to_nr01'=>$to_nr01));
			}
		}
						 
		return array('ok'=>1, 'msg'=>$message);
	}
	
?>