function mydt_tbl_open_relation(container_id , search_same_vat){
    mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d', '', 'mydt10_d');
    mydt10_d10_container_id = pegGetContainer_id_d(container_id, 'mydt10_d10', '', 'mydt10_d');
    mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');

    params = {};
    params.mydt10_container_id = mydt10_d_container_id;
    params.mydt10_nr01         = pegGetVal('nr01', mydt10_d_container_id);
    params.mydt10_tbl          = pegGetVal('tbl' , mydt10_d11_container_id);
    params.mydt10_tbl_nr01     = pegGetVal('tbl_nr01' , mydt10_d11_container_id);


    pegAjaxDefer('/'+main_path + '/mydt02/tbl_open_relation.php' , params , function(jsonData){
        if(jsonData.ok==1){
            pegAddTab_d('' , jsonData.view_table  , jsonData.view_d  , jsonData.view_module  , jsonData.view_con_id  , jsonData.view_nr01  , '' );  //'" .$this->container_id. "'				
        }else{
            pegToast(jsondata.msg,'alert'); 
        }

    } , 'json' , true);	
}

function mydt_select_relation(container_id , search_same_vat){
    mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d', '', 'mydt10_d');
    mydt10_d10_container_id = pegGetContainer_id_d(container_id, 'mydt10_d10', '', 'mydt10_d');
    mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');

    params = {};
    params.mydt10_container_id = mydt10_d_container_id;
    params.mydt10_nr01         = pegGetVal('nr01', mydt10_d_container_id);
    params.mydt10_p00          = pegGetVal('p00' , mydt10_d11_container_id);
    params.mydt10_p01          = pegGetVal('p01' , mydt10_d11_container_id);
    params.mydt10_is_vat       = pegGetVal('is_vat'    , mydt10_d10_container_id);
    params.mydt10_cp_vat       = pegGetVal('cp_vat'    , mydt10_d10_container_id);
    params.mydt10_issuedate    = pegGetVal('issuedate' , mydt10_d11_container_id);

    params.search_same_vat     = search_same_vat;


    pegAjaxDefer('/'+main_path + '/mydt02/check_if_invoice_could_be_related.php' , params , function(jsondata){
        if(jsondata.ok){
            pegWindowShow_d('', 'mydt10_d50', 'mydt', '', 0, '', mydt10_d_container_id, '', '', '', {}, false);
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    }); 
}

function mydt_cancel_relation(container_id){
    mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d', '', 'mydt10_d');
    mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');

    params = {};
    params.mydt10_container_id = mydt10_d_container_id;
    params.mydt10_nr01         = pegGetVal('nr01', mydt10_d_container_id);
    
    pegAjaxDefer('/'+main_path + '/mydt02/cancel_relation.php' , params , function(jsondata){
        if(jsondata.ok){ 
            pegSetVal('tbl'      , mydt10_d11_container_id, '');
            pegSetVal('tbl_nr01' , mydt10_d11_container_id, 0);
            pegSetVal('rel_nr'   , mydt10_d11_container_id, 0);
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    }); 

}

function mydt_submit_invoice(container_id){
    mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d', '', 'mydt10_d');
    mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');

    params = {};
    params.mydt10_nr01         = pegGetVal('nr01', mydt10_d_container_id);
    
    pegAjaxDefer('/'+main_path + '/mydt02/submit_invoice_from_mydt10.php' , params , function(jsondata){
        if(jsondata.ok){ 
            pegWindowShow_d('', 'mydt10_d54', 'mydt', '', 0, '', mydt10_d_container_id, '', '', '', {mydt10_invtype:pegGetVal('invtype' , mydt10_d11_container_id)}, false);
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    }); 

}

function mydt_mydt10_d_afterDraw_listeners(container_id) {
    var bt01 = pegGetCmp(container_id, 'bt01');
    bt01.setPeg_handler(function (me) {
        
        var qrurl = pegGetVal('qrurl', container_id);
        if(qrurl) {
            if(qrurl.substr(0, 4) == "http") {
                window.open(qrurl, '_blank');
            } else {
                window.open("https://"+qrurl, '_blank');
            }
        } else {
            pegGetDic('peg_dic_mydt_no_open_link', function (desc) {
                pegToast(desc, 'alert');
            });
        }
    });

    mydt10_d02_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');
    var but_00 = pegGetCmp(mydt10_d02_container_id, 'but_00');
    but_00.setPeg_handler(function (me) {
        mydt_select_relation(container_id, 0);
    });

    var but_01 = pegGetCmp(mydt10_d02_container_id, 'but_01');
    but_01.setPeg_handler(function (me) {
        mydt_select_relation(container_id, 1);
    });

    var but_03 = pegGetCmp(mydt10_d02_container_id, 'but_03');
    but_03.setPeg_handler(function (me) {
        mydt_select_relation(container_id, 2);
    });

    var but_02 = pegGetCmp(mydt10_d02_container_id, 'but_02');
    but_02.setPeg_handler(function (me) {
        mydt_cancel_relation(container_id);
    });

    var but_04 = pegGetCmp(mydt10_d02_container_id, 'but_04');
    but_04.setPeg_handler(function (me) {
        mydt_submit_invoice(container_id);
    });

    var bt_relation = pegGetCmp(mydt10_d02_container_id, 'bt_relation');
    bt_relation.setPeg_handler(function (me) {
        mydt_tbl_open_relation(container_id);
    });

    mydt10_d10_container_id = pegGetContainer_id_d(container_id, 'mydt10_d10', '', 'mydt10_d');
    var btn01 = pegGetCmp(mydt10_d10_container_id, 'btn01');
    btn01.setPeg_handler(function (me) {
        mydt_search_by_vat(mydt10_d10_container_id, pegGetVal('is_vat', mydt10_d10_container_id));
    });

    var btn02 = pegGetCmp(mydt10_d10_container_id, 'btn02');
    btn02.setPeg_handler(function (me) {
        mydt_search_by_vat(mydt10_d10_container_id, pegGetVal('is_vat', mydt10_d10_container_id), 1);
    });

    var btn03 = pegGetCmp(mydt10_d10_container_id, 'btn03');
    btn03.setPeg_handler(function (me) {
        mydt_search_by_vat(mydt10_d10_container_id, pegGetVal('cp_vat', mydt10_d10_container_id));
    });

    var btn04 = pegGetCmp(mydt10_d10_container_id, 'btn04');
    btn04.setPeg_handler(function (me) {
        mydt_search_by_vat(mydt10_d10_container_id, pegGetVal('cp_vat', mydt10_d10_container_id), 1);
    });
    
}

/***
 * mydt_update_mydt10('a55',params.nr01 )
 */
var mydt_update_mydt10_ajax=[];
function mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , only_if_auto,  callback, tr_fail_flag=0, check_for_mark=0){
    params = {};
    params.tbl = tbl;
    params.tbl_nr01 = tbl_nr01;
    params.tr_fail_flag = tr_fail_flag;
    params.check_for_mark = check_for_mark;
    if(pegIsEmpty(only_if_auto)){
        only_if_auto =false;
    }

    params.only_if_auto = only_if_auto;
    
    if(mydt_update_mydt10_ajax[tbl_nr01]){
		if(mydt_update_mydt10_ajax[tbl_nr01].id>0){ 
			Ext.ux.AjaxDefer.abort(mydt_update_mydt10_ajax[tbl_nr01] );  
		}
	}
	
    peg002_mask(container_id);
	mydt_update_mydt10_ajax[tbl_nr01]  = pegAjaxDefer('/'+main_path + '/mydt01/mydt10_create_n_send.php' , params , function(jsondata){
        peg002_unmask(container_id);
        i=0;
        if( jsondata.has_mark==1 ){
            return pegConfirmBox('',jsondata.msg,
                function(ans) {
                    if(ans == 'yes') {
                        mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , only_if_auto,  callback, 0, -1);
                    }
                }
            )
        }else if( jsondata.tr_fail_flag==1 ){
            return pegConfirmBox('',jsondata.msg,
                function(ans) {
                    if(ans == 'yes') {
                        mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , only_if_auto,  callback, 1, -1);
                    }else{
                        mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , only_if_auto,  callback, -1, -1);
                    }
                }
            )
        }else{
            jsondata.forEach(function(jsondata00){

                if ( !only_if_auto 
                    || jsondata00.has_pegasus_error == 1
                    || (only_if_auto && jsondata00.has_msg_from_mydt_send_to_aade == 1)
                ){
                    if(jsondata00.ok ){
                        pegToast(jsondata00.msg,'info');       
                    }else{  
            
                        pegToast(jsondata00.msg,'alert');       
                    }
                }

                if(callback && typeof(callback) === "function"){ 
                    callback(jsondata00);
                }
                
                //Εμφανιζουμε μηνυμα για την ολοκληρωση ΨΠ
                if(jsondata00.dc0001_arr && typeof dc00_dc0001_completion_screen === 'function') {
                    dc00_dc0001_completion_screen(jsondata00.dc0001_arr);
                }
            })

            
        }

        mydt_update_mydt10_ajax[tbl_nr01]='';
    });
}

/***
 *
 * mydt_send_to_mydata_multi_a55
 * a55_arr_nr01s = ["1025" , "1026" , "1028"]
 * index to index toy array π.χ 0 
 * container_id το container _id της οθονης
 */
function mydt_send_to_mydata_multi_a55( a55_arr_nr01s, index , container_id){
	//console.log(a55_arr_nr01s);
	if(a55_arr_nr01s[index]>0){
		mydt_update_mydt10_n_send('a55', a55_arr_nr01s[index] , container_id , true,  function(){
			index++;
			mydt_send_to_mydata_multi_a55( a55_arr_nr01s, index , container_id);
		});
	}
}

/***
 * mydt_open_mydt10('a55',params.nr01 )
 */
 var mydt_open_mydt10_ajax = '';
function mydt_open_mydt10(tbl, tbl_nr01 , container_id){
    params = {};
    params.tbl = tbl;
    params.tbl_nr01 = tbl_nr01;

    if(mydt_open_mydt10_ajax !=''){
		if(mydt_open_mydt10_ajax.id>0){ 
			Ext.ux.AjaxDefer.abort(mydt_open_mydt10_ajax );  
		}
	}

    var p_tab_id       = '';
    var p_table        = 'mydt10';
    var p__d           = 'mydt10_d';
    var p_module       = 'mydt';
    var p_container_id = '';
    var p_nr01         = '';

    mydt_open_mydt10_ajax  = pegAjaxDefer('/'+main_path + '/mydt01/mydt10_check.php' , params , function(jsondata){
        if(jsondata.ok){
            p_nr01 = jsondata.nr01;

            pegAddTab_d(p_tab_id , p_table , p__d , p_module , p_container_id , p_nr01 );
            
        }else{
            
            if(jsondata.show_confirm){
                pegConfirmBox( '', jsondata.msg, function (but) {
                    if(but === 'yes') {                     
                        pegAjaxDefer('/'+main_path + '/mydt01/mydt10_create_n_send.php' , params , function(jsondata){
                            if( jsondata.tr_fail_flag==1 ){
                                return pegConfirmBox('',jsondata.msg,
                                    function(ans) {

                                        if(ans == 'yes') {
                                            mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , false,  function(jsondata00){
                                                console.log(jsondata00);
                                                if(jsondata00.ok===1){
                                                    p_nr01 = jsondata00.nr01;
                                                    pegAddTab_d(p_tab_id , p_table , p__d , p_module , p_container_id , p_nr01 );
                                                }
                                            }, 1, -1);
                                        }else{
                                            mydt_update_mydt10_n_send(tbl, tbl_nr01 , container_id , false,  function(jsondata00){
                                                if(jsondata00.ok===1){
                                                    p_nr01 = jsondata00.nr01;
                                                    pegAddTab_d(p_tab_id , p_table , p__d , p_module , p_container_id , p_nr01 );
                                                }
                                            }, -1, -1);
                                        }
                                    }
                                )
                            }
                            if(jsondata[0].ok===1){
                                p_nr01 = jsondata[0].nr01;
                                pegAddTab_d(p_tab_id , p_table , p__d , p_module , p_container_id , p_nr01 );
                            }else{
                                pegToast(jsondata[0].msg,'alert'); 
                            }
                        });
                    }
                }); 
            }else{
                pegToast(jsondata.msg,'alert'); 
            }

            
        }
    });
}

function mydt_get_from_aade(container_id){
    params = {};
    params.rcv_mark     =  pegGetVal('rcv_mark' , container_id);
    params.rcv_ent_vat  =  pegGetVal('rcv_ent_vat' , container_id);
    params.rcv_dt_from  =  pegGetVal('rcv_dt_from' , container_id);
    params.rcv_dt_to    =  pegGetVal('rcv_dt_to' , container_id);
    params.rcv_rec_vat  =  pegGetVal('rcv_rec_vat' , container_id);
    params.rcv_invtype  =  pegGetVal('rcv_invtype' , container_id);
    params.rcv_maxmark  =  pegGetVal('rcv_maxmark' , container_id);
    params.but_receive_all  =  pegGetCmp(container_id, 'but_receive_all').text;
    
    // params.en_mark_search_on_receive =  pegGetVal('en_mark_search_on_receive' , container_id);
    pegAjaxDefer('/'+main_path + '/mydt02/get_from_aade.php' , params , function(jsondata){
        if(jsondata.ok){
            pegToast(jsondata.msg);
            pegGridRefresh(container_id , 'grid' );
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    });
}

/**
 * @param  mydt10_nr01  -1 means all
 */
 function mydt_remake_selected(mydt10_nr01, container_id){
    params = {};
    params.mydt10_nr01               = mydt10_nr01;

    var mode = pegGetCmp(container_id).peg__d;
    if(mode == '_mydtres_d'){
        params.but_remake_sel = pegGetCmp(container_id, 'but_remake_sel').text;
    }else if(mode == 'mydt10_d55'){
        params.but_remake_sel = pegGetCmp(container_id, 'but_remake').text; 
    }

    pegAjaxDefer('/'+main_path + '/mydt02/remake_selected_invoices.php' , params , function(jsondata){
        if(jsondata.ok){
            pegToast(jsondata.msg);
            pegGridRefresh(container_id , 'grid' );
        }else{
            pegToast(jsondata.msg,'alert'); 
            if(jsondata.refresh){
                pegGridRefresh(container_id , 'grid' );
            }
        }
    });
}

/**
 * @param  mydt10_nr01  -1 means all
 */
 function mydt_delete_selected(mydt10_nr01, container_id){
    params = {};
    params.mydt10_nr01               = mydt10_nr01;
    params.but_delete_sel            =  pegGetCmp(container_id, 'but_delete_sel').text;
    pegAjaxDefer('/'+main_path + '/mydt02/delete_selected_invoices.php' , params , function(jsondata){
        if(jsondata.ok){
            pegToast(jsondata.msg);
            pegGridRefresh(container_id , 'grid' );
        }else{
            pegToast(jsondata.msg,'alert'); 
            if(jsondata.refresh){
                pegGridRefresh(container_id , 'grid' );
            }
        }
    });
}

/**
 * @param  mydt10_nr01  -1 means all
 */
function mydt_send_to_aade(mydt10_nr01, container_id){
    params = {};
    params.mydt10_nr01               = mydt10_nr01;

    var mode = pegGetCmp(container_id).peg__d;
    if(mode == '_mydtres_d'){
        params.but_send_sel = pegGetCmp(container_id, 'but_send_sel').text;
    }else if(mode == 'mydt10_d55'){
        params.but_send_sel = pegGetCmp(container_id, 'but_send').text; 
    }
    params.mode = mode;
    
    pegAjaxDefer('/'+main_path + '/mydt02/send_to_aade.php' , params , function(jsondata){
        if(jsondata.ok){
            pegToast(jsondata.msg);
            pegGridRefresh(container_id , 'grid' );
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    });
}
var mydt_create_invoices_ajax = '';
function mydt_create_invoices(container_id , step='init',page=0){
    params = {};
    params.t_p01  =  pegGetVal('t_p01' , container_id);
    params.t_p02  =  pegGetVal('t_p02' , container_id);
    params.t_p07d =  pegGetVal('t_p07d', container_id);
    params.t_p08d =  pegGetVal('t_p08d', container_id);
    params.t_p07t =  pegGetVal('t_p07t', container_id);
    params.t_p08t =  pegGetVal('t_p08t', container_id);
    params.t_p06  =  pegGetVal('t_p06' , container_id);
    params.stores =  pegGetVal('stores', container_id);
    params.but_create =  pegGetCmp(container_id, 'but_create').text;
    
    params.step = step;
    params.page = page;

    if(mydt_create_invoices_ajax!=''){
        if(mydt_create_invoices_ajax.id>0){
            Ext.ux.AjaxDefer.abort(mydt_create_invoices_ajax);
        }
    }
    peg002_mask(container_id);
    mydt_create_invoices_ajax = pegAjaxDefer('/'+main_path + '/mydt02/create_invoices.php' , params , function(jsondata){
        if(jsondata.ok){
            if(jsondata.step!=='completed'){
                mydt_create_invoices(container_id, jsondata.step, jsondata.page);  
            }else{
                peg002_unmask(container_id);
                pegGridRefresh(container_id , 'grid' );
                pegToast(jsondata.msg);
            }
        }else{
            peg002_unmask(container_id);
            pegToast(jsondata.msg,'alert'); 
        }
    });
}
var mydt_mydt10_d55_refresh_grid_ajax='';
function mydt_mydt10_d55_afterDraw_listeners(container_id) {
    var but_remake  = pegGetCmp(container_id, 'but_remake');
    var but_send    = pegGetCmp(container_id, 'but_send');
    var search_btn  = pegGetCmp(container_id, 'search_btn');
    var grid   = pegGetCmp(container_id, 'grid');
    var dt_from = pegGetCmp(container_id, 'dt_from');//Πιθανή Αφιξη
	var dt_to = pegGetCmp(container_id, 'dt_to');//Πιθανή Αναχώρηση

    search_btn.setPeg_handler(function(me){
        params = {};
        params.container_id = container_id;
        params.dt_from = pegGetVal('dt_from', container_id);
        params.dt_to = pegGetVal('dt_to', container_id);

        if(mydt_mydt10_d55_refresh_grid_ajax!=''){
            if(mydt_mydt10_d55_refresh_grid_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_d55_refresh_grid_ajax);  
            }
        }
        
        mydt_mydt10_d55_refresh_grid_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d55_refresh_grid.php', params, 
            function(jsonData){
                pegGridRefresh(container_id , 'grid');
            } , 
        'json' , true);	
    });
    dt_from.on('blur', function (me) {
		if ((me.peg_onBlurValueHasChanged())) {
            params = {};
            params.container_id = container_id;
            params.dt_from = pegGetVal('dt_from', container_id);
            params.dt_to = pegGetVal('dt_to', container_id);

            if(mydt_mydt10_d55_refresh_grid_ajax!=''){
                if(mydt_mydt10_d55_refresh_grid_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d55_refresh_grid_ajax);  
                }
            }
            
            mydt_mydt10_d55_refresh_grid_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d55_refresh_grid.php', params, 
                function(jsonData){
                    pegGridRefresh(container_id , 'grid');
                } , 
            'json' , true);	

		}
	});
    dt_to.on('blur', function (me) {
		if ((me.peg_onBlurValueHasChanged())) {
			// var dateA = me.getValue();
			// var dateB = pegGetCmp(me.container_id, 'dt_from').getValue();
            params = {};
            params.container_id = container_id;
            params.dt_from = pegGetVal('dt_from', container_id);
            params.dt_to = pegGetVal('dt_to', container_id);

            if(mydt_mydt10_d55_refresh_grid_ajax!=''){
                if(mydt_mydt10_d55_refresh_grid_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d55_refresh_grid_ajax);  
                }
            }
            
            mydt_mydt10_d55_refresh_grid_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d55_refresh_grid.php', params, 
                function(jsonData){
                    pegGridRefresh(container_id , 'grid');
                } , 
            'json' , true);	

		}
	});
    but_remake.setPeg_handler(function (me) {
        var _nr01_str_rmk     = '';
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        selectedItems.forEach(function(item) {
            _nr01_str_rmk = _nr01_str_rmk + item.data['mydt10'] + ';' ;
        });
        var array = _nr01_str_rmk.split(';');
        var uniqueArray = array.filter(function(item, index){
            return array.indexOf(item) === index;
        });
        var _nr01_str_rmk = uniqueArray.join(';');


        if (!pegIsEmpty(_nr01_str_rmk)) {
            mydt_remake_selected(_nr01_str_rmk, container_id);    
        }else{
            pegAlert('No row selected');
        }                 
    });
    but_send.setPeg_handler(function (me) {
        var _nr01_str     = '';
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        selectedItems.forEach(function(item) {
            _nr01_str = _nr01_str + item.data['mydt10'] + ';' ;
        });
        var array = _nr01_str.split(';');
        var uniqueArray = array.filter(function(item, index){
            return array.indexOf(item) === index;
        });
        var _nr01_str = uniqueArray.join(';');

        if (!pegIsEmpty(_nr01_str)) {
            mydt_send_to_aade(_nr01_str, container_id);    
        }else{
            pegAlert('No row selected');
        }                 
    });
    grid.record_change = function(me,row){
        var row=pegGridGetSelectedRow( me.getContainer_ID() , 'grid');
        if(row){
            var nr01=row.mydt10;
            if(nr01<1){
                pegGetDic('peg_dic_core_perm_deny_edit_rec', function(desc){ pegAlert(desc); } );
                return;
            }
            pegAddTab_d(
                '' , 
                'mydt10' , 
                'mydt10_d', 
                'mydt', 
                '' , 
                nr01 , 
                me.store.url_vars00 , 
                {
                    mmnr01:me.getMmnr01(),
                    mnr01: me.getMnr01(),
                    peg_screen_parent_element_name: me.name,
                    peg_screen_parent_container_id: me.getContainer_ID(),
                    grid_element_name: me.name,
                    grid_element_con_id:  me.getContainer_ID()
                }
            );	
        }	
    };
}
function mydt__mydtres_d_afterDraw_listeners(container_id) {
    var but_send_sel    = pegGetCmp(container_id, 'but_send_sel');
    var but_remake_sel  = pegGetCmp(container_id, 'but_remake_sel');
    var but_delete_sel  = pegGetCmp(container_id, 'but_delete_sel');
    var but_create      = pegGetCmp(container_id, 'but_create');
    var but_receive_all = pegGetCmp(container_id, 'but_receive_all');
    var but_non_related = pegGetCmp(container_id, 'but_non_related');
    var but_char        = pegGetCmp(container_id, 'but_char');
    const but_report    = pegGetCmp(container_id, 'but_report');
    var grid = pegGetCmp(container_id,'grid');
    const btn_einv_00 = pegGetCmp(container_id, 'btn_einv_00');
    const btn_einv_01 = pegGetCmp(container_id, 'btn_einv_01');
    const btn_einv_02 = pegGetCmp(container_id, 'btn_einv_02');
    const btn_einv_03 = pegGetCmp(container_id, 'btn_einv_03');
    const btn_einv_04 = pegGetCmp(container_id, 'btn_einv_04');
    const btn_einv_05 = pegGetCmp(container_id, 'btn_einv_05');
    const btn_einv_06 = pegGetCmp(container_id, 'btn_einv_06');
    btn_einv_03.setPeg_handler(function(me) {
        const einv_date_from_val = pegGetVal('einv_date_from',container_id);
        const einv_date_to_val = pegGetVal('einv_date_to',container_id);
        einv_insert_or_update_mydt_from_einv(container_id,einv_date_from_val, einv_date_to_val);
    });
     btn_einv_04.setPeg_handler(function(me) {
        const einv_date_from_val = pegGetVal('einv_date_from',container_id);
        const einv_date_to_val = pegGetVal('einv_date_to',container_id);
        einv_insert_or_update_mydt13_from_einv_payments(container_id,einv_date_from_val, einv_date_to_val);
    });
    btn_einv_05.setPeg_handler(function(me) {
        pegAddTab_d('', '','einv22_d','einv');
    });
     btn_einv_06.setPeg_handler(function(me) {
         pegAddTab_d('', '','einv23_d','einv');
    });
    // Παραστατικα με απωλεια διασυνδεσης Παροχου με ΑΑΔΕ
    btn_einv_00.setPeg_handler(function(me) {
        pegAddTab_d(
            '', 
            '', 
            'mydt10_d52', 
            'mydt'
        );
    });
    // Παραστατικά με απωλεια διασυνδεσης WebApp με Παροχο
    btn_einv_01.setPeg_handler(function(me) {
        pegAddTab_d(
            '', 
            '', 
            'mydt10_d53', 
            'mydt'
        );
    });  
     // Παραστατικά με απωλεια διασυνδεσης WebApp με Παροχο
     btn_einv_02.setPeg_handler(function(me) {
        pegAddTab_d(
            '', 
            '', 
            'mydt10_d56', 
            'mydt'
        );
    });  

    but_create.setPeg_handler(function (me) {
        mydt_create_invoices(container_id);
    });

	but_receive_all.setPeg_handler(function (me) {
        mydt_get_from_aade(container_id);
    });

    but_non_related.setPeg_handler(function(me){
        pegAddTab_d('', '', 'mydt10_d51', 'mydt');
    });

    but_char.setPeg_handler(function(me){
        pegAddTab_d('', '', 'mydt10_d55', 'mydt');
    });

    but_remake_sel.setPeg_handler(function (me) {
        var _nr01_str_rmk     = '';
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        selectedItems.forEach(function(item) {
            _nr01_str_rmk = _nr01_str_rmk + item.data['nr01'] + ';' ;
        });


        if (!pegIsEmpty(_nr01_str_rmk)) {
            mydt_remake_selected(_nr01_str_rmk, container_id);    
        }else{
            pegAlert('No row selected');
        }                 
    });

    but_delete_sel.setPeg_handler(function (me) {
        var _nr01_str_del     = '';
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        selectedItems.forEach(function(item) {
            _nr01_str_del = _nr01_str_del + item.data['nr01'] + ';' ;
        });


        if (!pegIsEmpty(_nr01_str_del)) {
            mydt_delete_selected(_nr01_str_del, container_id);    
        }else{
            pegAlert('No row selected');
        }                 
    });

	but_send_sel.setPeg_handler(function (me) {
        var _nr01_str     = '';
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        selectedItems.forEach(function(item) {
            _nr01_str = _nr01_str + item.data['nr01'] + ';' ;
        });


        if (!pegIsEmpty(_nr01_str)) {
            mydt_send_to_aade(_nr01_str, container_id);    
        }else{
            pegAlert('No row selected');
        }                 
    });
    
    but_report.setPeg_handler(function (me) {
        pegAddTab_d('', 'q10', 'q10_d90_140000110000003_d', 'query', '', '140000110000003', '',{});
    });

    var filters_fields = [];
    filters_fields.push( pegGetCmp(container_id, 'show_only') );
    filters_fields.push( pegGetCmp(container_id, 'mydt10_p01') );
    filters_fields.push( pegGetCmp(container_id, 'related') );
    filters_fields.push( pegGetCmp(container_id, 'classified') );
    filters_fields.push( pegGetCmp(container_id, 'errors') );
    filters_fields.push( pegGetCmp(container_id, 'dt_from') );
    filters_fields.push( pegGetCmp(container_id, 'dt_to') );
    filters_fields.push( pegGetCmp(container_id, 'stores_search') );

    filters_fields.push( pegGetCmp(container_id, 'einv') );
    filters_fields.push( pegGetCmp(container_id, 'tr_fail') );

    filters_fields.forEach(function(fld){
        if(fld){
            fld.on('change', function (me, newValue, oldValue, eOpts) {
                if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
                    return;
                }
                
                mydt_filter_changed(container_id);
            });
        }
    });

    //grid
    var cols = [];
    cols.push(WebApp.view.grid.Grid.peg_getColumn(grid, 'nr01'));
    cols.push(WebApp.view.grid.Grid.peg_getColumn(grid, 'p00'));
    cols.push(WebApp.view.grid.Grid.peg_getColumn(grid, 'p01'));
    cols.push(WebApp.view.grid.Grid.peg_getColumn(grid, 'rel_nr'));


    cols.forEach(function(column00){
        column00.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {            
            try {
                var column	= this.getHeaderContainer().getHeaderAtIndex(colIndex);

                //  console.log('===================');
                //  console.log(record);
                //  console.log(column.name);
                //  console.log('p00');
                //  console.log(record.get('p00'));
                //  console.log('p01');
                //  console.log(record.get('p01'));
                //  console.log('===================');

                var is_related_color = '#efca79'; 
                var has_error_color  = '#f5d5d5'; 
                var is_esodo  = '#d7f0a1'; 
                var is_exodo  = '#c2ecff'; 
                var is_apostoli  = '#a3c6e6'; 
                var is_paralavi  = '#faeecd'; 
                var color = '';


                if( column.xtype == "pegasusSelectBoxColumn" ||
                    column.xtype == "pegasusComboBoxColumn"  || 
                    column.xtype == "pegasusDateColumn"      || 
                    column.xtype == "pegasusTextBoxColumn"   || 
                    column.xtype == "pegasusNumberColumn"    ){

                    if(column.name == 'rel_nr'){            
                         if(record.get('rel_nr')>0){
                            color = is_related_color;
                        }
                    }



                    if(column.name == 'nr01'){                                
                        if(record.get('v_error')==="true"){
                            color = has_error_color;
                        } else if(record.get('rel_nr')>0){
                            color = is_related_color;
                        }
                    }

                    if(column.name == 'p00'){    
                        if(record.get('p00')===1){
                            color = is_esodo;
                        } else {
                            color = is_exodo;
                        }
                    }

                    
                    if(column.name == 'p01'){                                
                        if(record.get('p01')===1){
                            color = is_apostoli;
                        } else {
                            color = is_paralavi;
                        }
                    }

                    
                           
                    if(color!=''){
                        metaData.tdStyle = "background-color:" + color + " ;";
                    }
                }
 
                if(column.xtype == "pegasusComboBoxColumn"){
                    return  Ext.getStore(column.storeid).getData().filterBy(column.valueField,value).items[0].data[column.displayField];
    
                }else if(column.xtype == "pegasusDateColumn"){
                    return Ext.util.Format.date(record.data[column.name], column.format);
    
                }else{
                    if(column.browse_selectbox_type == 2 && !pegIsEmpty(record.data['v_selectbox_'+column.name]) ){
                        return record.data['v_selectbox_'+column.name];
                    }else if (column.browse_selectbox_type == 1 && !pegIsEmpty(record.data[column.name])) {
                        return record.data[column.name];
                    }
                }	
			} catch (e) {
				// TODO: handle exception
            }
            
            return value;
        };
        
    });

}

function mydt_filter_changed(container_id){
    params = {};
    params.show_only  = pegGetVal('show_only' , container_id);
    params.mydt10_p01 = pegGetVal('mydt10_p01' , container_id);
    params.related    = pegGetVal('related'    , container_id);
    params.classified = pegGetVal('classified' , container_id);
    params.errors     = pegGetVal('errors'     , container_id);
    params.dt_from    = pegGetVal('dt_from'    , container_id);
    params.dt_to      = pegGetVal('dt_to'    , container_id);
    params.stores     = pegGetVal('stores_search'    , container_id);

    params.tr_fail = pegGetVal('tr_fail'    , container_id);
    params.einv = pegGetVal('einv'    , container_id);

    params.container_id    = container_id;
    pegAjaxDefer('/'+main_path + '/mydt02/set_filters.php' , params , function(jsondata){
        if(jsondata.ok){
            pegGridRefresh(container_id , 'grid' );
        }else{
            pegToast(jsondata.msg,'alert'); 
        }
    });
}

function mydt_mydt10_d50_afterDraw_listeners(container_id){
    var grid	= pegGetCmp(container_id , 'grid');
  
    var mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d'  , '', 'mydt10_d');
    var mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');

	grid.record_change = function(me,row){        


        params = {};
        params.nr01_0 = pegGetVal('nr01' , mydt10_d_container_id);
        params.nr01_1 = row.nr01;
        pegAjaxDefer('/'+main_path + '/mydt02/check_selected_record.php' , params , function(jsondata){
            if(jsondata.ok){
                
                if(jsondata.sayConfirm==1){
                    pegConfirmBox( '', jsondata.msg, function(selection){
                        if(selection=='yes'){
                            // pegSetVal('tbl'      , mydt10_d11_container_id, row.tbl);
                            // pegSetVal('tbl_nr01' , mydt10_d11_container_id, row.tbl_nr01);
                            pegSetVal('rel_nr'   , mydt10_d11_container_id, row.nr01);
                            pegWindowClose(Ext.getCmp(container_id).up().id);                
                        }
                    });
                }else{
                    // pegSetVal('tbl'      , mydt10_d11_container_id, row.tbl);
                    // pegSetVal('tbl_nr01' , mydt10_d11_container_id, row.tbl_nr01);
                    pegSetVal('rel_nr'   , mydt10_d11_container_id, row.nr01);
                    pegWindowClose(Ext.getCmp(container_id).up().id);                
                }


            }else{   
                pegToast(jsondata.msg,'alert');       
            }
        });
    };
    

}
function mydt_mydt10_d54_afterDraw_listeners(container_id){
    var btn_00	= pegGetCmp(container_id , 'btn_00');
    var btn_01	= pegGetCmp(container_id , 'btn_01');
  
    mydt10_d_container_id   = pegGetContainer_id_d(container_id, 'mydt10_d'  , '', 'mydt10_d');
    mydt10_d10_container_id = pegGetContainer_id_d(container_id, 'mydt10_d10', '', 'mydt10_d');
    mydt10_d11_container_id = pegGetContainer_id_d(container_id, 'mydt10_d11', '', 'mydt10_d');
    mydt10_d12_container_id = pegGetContainer_id_d(container_id, 'mydt10_d12', '', 'mydt10_d');
    var screen = pegGetCmp(mydt10_d_container_id);
    var mmnr01 = screen.getMmnr01();
   

	btn_00.setPeg_handler(function (me) {
        params = {};
        params.mmnr01 = mmnr01;
        params.mydt10_nr01          = pegGetVal('nr01', mydt10_d_container_id);
        params.mydt10_mark          = pegGetVal('mark', mydt10_d_container_id);
        params.mydt10_tgross_val    = pegGetVal('tgross_val', mydt10_d12_container_id);
        params.mydt10_issuedate     = pegGetVal('issuedate' , mydt10_d11_container_id);
        params.mydt10_issuetime     = pegGetVal('issuetime' , mydt10_d11_container_id);
        params.mydt10_series        = pegGetVal('series' , mydt10_d11_container_id);
        params.mydt10_aa            = pegGetVal('aa' , mydt10_d11_container_id);
        params.mydt10_is_vat        = pegGetVal('is_vat' , mydt10_d10_container_id);
        params.invoice_type         = pegGetVal('p01' , container_id);

        var type = 1;
        mydt_mydt10_d54_relate(container_id, params, type);

    });        
	btn_01.setPeg_handler(function (me) {
        params = {};
        params.mmnr01 = mmnr01;
        params.mydt10_nr01          = pegGetVal('nr01', mydt10_d_container_id);
        params.mydt10_mark          = pegGetVal('mark', mydt10_d_container_id);
        params.mydt10_tgross_val    = pegGetVal('tgross_val', mydt10_d12_container_id);
        params.mydt10_issuedate     = pegGetVal('issuedate' , mydt10_d11_container_id);
        params.mydt10_issuetime     = pegGetVal('issuetime' , mydt10_d11_container_id);
        params.mydt10_series        = pegGetVal('series' , mydt10_d11_container_id);
        params.mydt10_aa            = pegGetVal('aa' , mydt10_d11_container_id);
        params.mydt10_is_vat        = pegGetVal('is_vat' , mydt10_d10_container_id);
        params.invoice_type         = pegGetVal('p02' , container_id);
    
        var type = 2;
        mydt_mydt10_d54_relate(container_id, params, type);

    });        
    

}

var mydt_check_if_module_exists_ajax = '';
function mydt_mydt10_d54_relate(container_id, params, type) {
    mydt10_d10_container_id = pegGetContainer_id_d(container_id, 'mydt10_d10', '', 'mydt10_d');

    if (mydt_check_if_module_exists_ajax != '') {
        if (mydt_check_if_module_exists_ajax.dias_fld_mnr01 > 0) {
            Ext.ux.AjaxDefer.abort(mydt_check_if_module_exists_ajax);
        }
    }
    let param = {};
    param.type = type

    mydt_check_if_module_exists_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt_check_if_module_exists.php', param,
        function (jsondata) {
            if(jsondata.ok !== 1){
                pegAlert(jsondata.msg);
                return ; 
            }else{
                if(type == 1){
                    if(params.invoice_type==0 || params.invoice_type=='' ){
                        pegGetDic('peg_dic_mydt_invoice_not_found', function(desc){ pegAlert(desc); } );
                    }else{
                        pegAddTab_d("", "a56", "a56_d", "invsupp", "", 0, "", params, mydt10_d_container_id, id);
                        pegWindowClose(container_id);
                    }
                }
                if(type == 2){
                    if(params.invoice_type==0 || params.invoice_type=='' ){
                        pegGetDic('peg_dic_mydt_invoice_not_found', function(desc){ pegAlert(desc); } );
                    }else{
                        pegAddTab_d("", "t08", "t08_d", "receipts", "", 0, "", params, mydt10_d_container_id, id);
                        pegWindowClose(container_id);
                    }
                }
            }
            
        }
    );
}

var mydt_mydt70_d_search_ajax='';
var mydt_get_checked_relation_ajax='';	
function mydt_mydt70_d_afterDraw_listeners(container_id){
    var grid	= pegGetCmp(container_id , 'grid');
    var screen  = pegGetCmp(container_id);
    var but01  = pegGetCmp(container_id, 'but01');
	grid.record_change = function(me,row){        

        params = {};
        params.nr01 = row.nr01;             // M.K.
        params.p01 = row.p01;               // Συσχέτιση
        params.p03 = row.p03;               // Κωδικός κύριου πίνακα
        params.p05 = row.p05;               // Κωδικός Συσχέτισης
        params.vp03 = row.vp03;             // Περιγραφή κύριου πίνακα
        params.vp05 = row.vp05;             // Περιγραφή κωδικού συσχέτισης 
        params.container_id = container_id;

        if(mydt_get_checked_relation_ajax!=''){
            if(mydt_get_checked_relation_ajax.id>0){ 
               Ext.ux.AjaxDefer.abort(mydt_get_checked_relation_ajax);  
            }
         }
        mydt_get_checked_relation_ajax = pegAjaxDefer('/'+main_path + '/mydt02/check_relation.php' , params , function(jsondata){     
            
            if(jsondata.ok){
                peg_windowShow_d(
                    'q31',
                    'q31_d',
                    'core',
                    me.getContainer_ID(),
                    '',
                    jsondata.nr01,
                    '' ,
                    '',
                    {
                        mmnr01:me.getMmnr01(),
                        mnr01: me.getGridMnr01(),
                        peg_screen_parent_element_name: me.name,
                        peg_screen_parent_container_id: me.getContainer_ID()
                    },
                    false 
                ); 

              
            }

        });
    };
    but01.setPeg_handler(function(me){
		
		params00 = {};
		params00.container_id = container_id;
		params00.p01 = pegGetVal('p01', container_id);

    	if(mydt_mydt70_d_search_ajax!=''){
    		if(mydt_mydt70_d_search_ajax.id>0){ 
    		   Ext.ux.AjaxDefer.abort(mydt_mydt70_d_search_ajax);  
    		}
    	}
        
        mydt_mydt70_d_search_ajax = pegAjaxDefer(
            '/' + main_path + '/mydt02/refresh.php' , 
            params00 , 
        function(jsonData){
            pegGridRefresh(container_id , 'grid');
        } , 
        'json' , true);	
	});

    var cols = [];
    cols.push(WebApp.view.grid.Grid.peg_getColumn(grid, 'nr01'));

    cols.forEach(function(column00){
        column00.renderer = function(value, metaData, record, rowIndex, colIndex, store, view) {
            try {
                var column = this.getHeaderContainer().getHeaderAtIndex(colIndex);
                var red = '#f5d5d5';
                var color = ''; 

                if( column.xtype == "pegasusSelectBoxColumn" ||
                    column.xtype == "pegasusComboBoxColumn"  || 
                    column.xtype == "pegasusDateColumn"      || 
                    column.xtype == "pegasusTextBoxColumn"   || 
                    column.xtype == "pegasusNumberColumn"    ){
                    if(column.name == 'nr01'){                                
                        if(record.get('nr01')<0){
                                color = red;
                        }
                    }
                    
                    if(color!=''){
                        metaData.tdStyle = "background-color:" + color + " ;";
                    }
                }
                
            } catch (e) {
                    
            }
            return value;
        }

    });
    

}
function mydt_query_140000110000003(container_id, screens, main_screen_name) {
    const container_id_results = pegGetContainer_id_d(container_id, screens.results_tab_name, '', main_screen_name);
    const grid = pegGetCmp(container_id_results, 'grid01');
    const gridColsFields = ['deduction_am', 'fees_am', 'gross_val',
        'lektiko', 'mnth', 'netvalue', 'stamp_am',
        'tax_am', 'tp', 'vat_am', 'wthhld_am', 'yr'];
    let gridCols = [];
    const color_esoda = "a6b1f090";
    //const color_eksoda = "a6c7e460";
    const color_synola = "e5f1ff";
    const color_geniko_geniko_synolo = "d8f0a6";


    gridColsFields.forEach(colName => {
        gridCols[colName] = WebApp.view.grid.Grid.peg_getColumn(grid, colName);
        if (gridCols[colName]) {
            gridCols[colName].renderer = function (value, metaData, record, rowIndex, colIndex, store, view) {
                try {
                    if (record.get('cat') == '' && record.get('yr') == '') {
                        metaData.tdStyle = "background-color:#" + color_geniko_geniko_synolo + " ;";
                    } else if (record.get('mnth') == '' && record.get('yr') != '') {
                        metaData.tdStyle = "background-color:#" + color_synola + " ;";
                    } else if (record.get('mnth') == '' && record.get('yr') == '' && record.get('cat') != '') {
                        metaData.tdStyle = "background-color:#" + color_esoda + " ;";
                    }
                } catch (error) {

                }

                try {
                    var column = this.getHeaderContainer().getHeaderAtIndex(colIndex);
                    if (column.browse_selectbox_type == 2 && !pegIsEmpty(record.data['v_selectbox_' + column.name])) {
                        return record.data['v_selectbox_' + column.name];
                    } else if (column.browse_selectbox_type == 1 && !pegIsEmpty(record.data[column.name])) {
                        return record.data[column.name];
                    }
                } catch (e) {
                    // TODO: handle exception
                }
                return value;
            };
        }
    });

    grid.on('itemdblclick', function (me, record, item, index, e, opts) {
        const yr = record.get('yr');
        const mnth = record.get('mnth');

        if (pegIsEmpty(record.get('yr'))) {
            return false;
        }
        let df = Ext.Date.format(new Date(yr, (mnth > 0 ? mnth - 1 : 0), 1), "Y-m-d");
        let dt = Ext.Date.format(new Date(yr, (mnth > 0 ? mnth : 12), 0), "Y-m-d");

        const query_params = {
            peg_query_var_var3: df,
            peg_query_var_var5: dt,
            peg_query_var_tp: record.get('cat'),
        }
        pegAddTab_d('', 'q10', 'q10_d90_140000110000002_d', 'query', '', '140000110000002', '', query_params);
    });
}

var mydt11_update_linerel_ajax = '';
function mydt_toolbar_item_mydt11_update_linerel(container_id, id, mnr01, mmnr01) {
    var screen = pegGetCmp(container_id);
    if (mydt11_update_linerel_ajax != '') {
        if (mydt11_update_linerel_ajax.dias_fld_mnr01 > 0) {
            Ext.ux.AjaxDefer.abort(mydt11_update_linerel_ajax);
        }
    }
    let params = {};
    params.container_id = container_id;
    params.id = id;
    params.mnr01 = screen.getMnr01();
    params.mmnr01 = screen.getMmnr01();

    mydt11_update_linerel_ajax = pegAjaxDefer('/' + main_path + '/mydt02/mydt11_update_linerel.php', params,
        function (jsondata) {
            if(jsondata.ok === 1) {
                pegToast(jsondata.msg, 'info');
                pegGridRefresh(container_id , id);
            }else{
                pegToast(jsondata.msg, 'alert');
            }
        }
    );
}

var mydt_mydt10_d51_search_ajax='';
var mydt_mydt10_d51_relate_ajax='';
function mydt_mydt10_d51_afterDraw_listeners(container_id){

    var grid   = pegGetCmp(container_id, 'grid');
    var search_btn  = pegGetCmp(container_id, 'search_btn');
    var relate_btn  = pegGetCmp(container_id, 'relate_btn');
    var mark_btn  = pegGetCmp(container_id, 'mark_btn');

    search_btn.setPeg_handler(function(me){
        params = {};
        params.container_id = container_id;
        params.dt_from = pegGetVal('dt_from', container_id);
		params.dt_to = pegGetVal('dt_to', container_id);

        if(mydt_mydt10_d51_search_ajax!=''){
            if(mydt_mydt10_d51_search_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_d51_search_ajax);  
            }
        }
        
        mydt_mydt10_d51_search_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d51_refresh_values.php', params, 
            function(jsonData){
                pegGridRefresh(container_id , 'grid');
            } , 
            'json' , true);	
    });

    grid.record_change = function(me,row){
        var row=pegGridGetSelectedRow( me.getContainer_ID() , 'grid');
        if(row){
            var nr01=row.nr01;
            if(nr01<1){
                pegGetDic('peg_dic_core_perm_deny_edit_rec', function(desc){ pegAlert(desc); } );
                return;
            }
            pegAddTab_d(
                '' , 
                me.peg_view_table , 
                'mydt10_d', 
                'mydt', 
                '' , 
                nr01 , 
                me.store.url_vars00 , 
                {
                    mmnr01:me.getMmnr01(),
                    mnr01: me.getMnr01(),
                    peg_screen_parent_element_name: me.name,
                    peg_screen_parent_container_id: me.getContainer_ID(),
                    grid_element_name: me.name,
                    grid_element_con_id:  me.getContainer_ID()
                }
            );	
        }	
    };

    relate_btn.setPeg_handler(function(me){
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        
        var mydt_nr01 = '#';
        var pegasus_nr01 = '#';
        selectedItems.forEach(function(item) {
            mydt_nr01 += item.data['nr01_1'] + '#';
            pegasus_nr01 += item.data['nr01_2'] + '#';


        })
            params = {};
            params.mydt_nr01 = mydt_nr01;
            params.pegasus_nr01 = pegasus_nr01;

            if(mydt_mydt10_d51_relate_ajax!=''){
                if(mydt_mydt10_d51_relate_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d51_relate_ajax);  
                }
            }

            mydt_mydt10_d51_relate_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d51_relate_documents.php', params, 
            function(jsonData){

                
                if(jsonData.ok == 0){
                    pegToast(jsonData.msg, 'alert');
                }else{
                    pegGridRefresh(container_id , 'grid' );
                    pegToast(jsonData.msg, 'success');
                }
                
            } , 
            'json' , true);	
        
    })

    mark_btn.setPeg_handler(function(me){
        var selectedItems = pegGetCmp(container_id, 'grid').getSelectionModel().selected.items;
        
        var mydt_nr01 = '';
        selectedItems.forEach(function(item) {
            mydt_nr01 += item.data['nr01_1'] + ',';
        })
            params = {};
            params.mydt_nr01 = mydt_nr01;

            if(mydt_mydt10_d51_relate_ajax!=''){
                if(mydt_mydt10_d51_relate_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d51_relate_ajax);  
                }
            }

            mydt_mydt10_d51_relate_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt10_d51_mark_as_related.php', params, 
            function(jsonData){

                if(jsonData.ok == 0){
                    pegToast(jsonData.msg, 'alert');
                }else{
                    pegGridRefresh(container_id , 'grid' );
                    pegToast(jsonData.msg, 'success');
                }
                
            } , 
            'json' , true);	
        
    })
    
}


function mydt_mydt10_d5100_grid_view_afterDraw_listeners(container_id){
    var grid = pegGetCmp(container_id, 'grid');
    var parastatiko = WebApp.view.grid.Grid.peg_getColumn(grid, 'parastatiko');
    var nr01_2 = WebApp.view.grid.Grid.peg_getColumn(grid, 'nr01_2');
    if(parastatiko){
		parastatiko.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex){
			try{
					metaData.tdCls = 'peg_clickable_cell';
				}catch(error){
				}
				return metaData;
		
			}
		parastatiko.peg_column_celldblclick_handler=function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
            var module = '';
                switch(record.get("tbl")) {
                    case 't08':
                        module = 'receipts';
                    break;
                    case 'a55':
                        module = 'invcust';
                    break;
                    case 'tran01':
                        module = 'tran';
                    break;
                }
				pegAddTab_d('', record.get("tbl"), record.get("tbl")+'_d', module, '', record.get("tbl_nr01"));
				return false;
			}
				
	}

    if(nr01_2){
        nr01_2.peg_set_metaData = function (value, metaData, record, rowIndex, colIndex){
			try{
                    if( record.get("nr01_2") != 0){
                       metaData.tdCls = 'peg_clickable_cell'; 
                    }
					
				}catch(error){
				}
				return metaData;
		
			}
        nr01_2.peg_column_celldblclick_handler=function(grid, td, cellIndex, record, tr, rowIndex, e, eOpts){
         
            if( record.get("nr01_2") != 0){
			    pegAddTab_d('', 'mydt10', 'mydt10_d', 'mydt', '', record.get("nr01_2"));
            }
			return false;
		}
    }

}
mydt_search_by_vat_ajax = '';
function mydt_search_by_vat(container_id, vat, is_supplier = 0){
    if(mydt_search_by_vat_ajax !=''){
		if(mydt_search_by_vat_ajax.id>0){ 
			Ext.ux.AjaxDefer.abort(mydt_search_by_vat_ajax);  
		}
	}

    params = {};
    params.vat = vat;
    params.is_supplier = is_supplier;
    mydt_search_by_vat_ajax = pegAjaxDefer('/' + main_path + '/mydt01/mydt_search_by_vat.php', params, 
    function(jsonData){   
        if(jsonData.ok == 1){
            pegAddTab_d('', jsonData.tbl, jsonData.tbl+'_d', jsonData.module, '', jsonData.nr01);
        }else{
            pegAlert(jsonData.msg);
            
        }
    } , 
    'json' , true);	
	
}
var mydt_mydt10_d52_set_grid_where_global_var_ajax = '';
/**
 * 
 * @param {string} container_id 
 */
function mydt_mydt10_d52_afterDraw_listeners(container_id) {
    const search_btn = pegGetCmp(container_id,'search_btn');
    const btn00 = pegGetCmp(container_id,'btn00');
    const grid = pegGetCmp(container_id,'grid');
    search_btn.setPeg_handler(function(me) {
        const params = {
            container_id : container_id,
            dt_from : pegGetVal('dt_from',container_id),
            dt_to : pegGetVal('dt_to',container_id)
        }
        if(mydt_mydt10_d52_set_grid_where_global_var_ajax !=''){
            if(mydt_mydt10_d52_set_grid_where_global_var_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d52_set_grid_where_global_var_ajax);  
            }
        }
        mydt_mydt10_d52_set_grid_where_global_var_ajax = pegAjaxDefer(
            '/' + main_path + '/mydt01/mydt_mydt10_d52_set_grid_where_global_var.php', 
            params, 
            function(jsonData) {   
                pegGridRefresh(container_id,'grid');
            },
            'json',
            true
        );
    });
    btn00.setPeg_handler(function(me) {
        const selection = grid.getSelection();
        if (selection.length == 0) {
            return pegGetDic('peg_dic_core_no_item_selected',function(msg) {
                return pegAlert(msg);
            });
        }
        let nr01s = [];
        selection.forEach(row => {
			nr01s.push(row.data.nr01);
		})
       return mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01(nr01s,{success:0,sum:nr01s.length},function(dic,counters) {
            pegGridRefresh(container_id,'grid');
            if(counters.success == 0) {
                return;
            }
            if(counters.success != counters.sum) {
                msg = dic.warn.replace('#success#',counters.success).replace('#sum#',counters.sum);
                return pegToast(msg,'warn');
            }
            return pegToast(dic.success,'success');
       })
    });
    grid.record_change = function(me,row){
        var row = pegGridGetSelectedRow(me.getContainer_ID(),'grid');
        if(row){
            if(row.nr01 < 1){
               return  pegGetDic('peg_dic_core_perm_deny_edit_rec', function(desc){ 
                    return pegAlert(desc); 
                });
            }
            return mydt_mydt10_get_tbl_data_by_nr01(
                row.nr01,
                function(data) {
                    return pegAddTab_d(
                        '' , 
                        data.table , 
                        data._d, 
                        data.module, 
                        '' ,
                        data.nr01, 
                        '', 
                        {
                            mmnr01:me.getMmnr01(),
                            mnr01: me.getMnr01(),
                            peg_screen_parent_element_name: me.name,
                            peg_screen_parent_container_id: me.getContainer_ID(),
                            grid_element_name: me.name,
                            grid_element_con_id:  me.getContainer_ID()
                        }
                    );	
                }
            )
        }	
    };
    grid.peg_grid_totalCount_handler = function( totalCount, me, meStore ){
        return pegGetDic('peg_dic_mydt_mydt10_d52_grid_cnt',function(msg) {
            grid.setTitle(msg.replace('#cnt#',totalCount));
            return;
        })
    }
}
var mydt_mydt10_d53_set_grid_where_global_var_ajax = '';
var mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01_ajax = '';
/**
 * 
 * @param {string} container_id 
 */
function mydt_mydt10_d53_afterDraw_listeners(container_id) {
    const search_btn = pegGetCmp(container_id,'search_btn');
    const btn00 = pegGetCmp(container_id,'btn00');
    const grid = pegGetCmp(container_id,'grid');
    search_btn.setPeg_handler(function(me) {
        const params = {
            container_id : container_id,
            dt_from : pegGetVal('dt_from',container_id),
            dt_to : pegGetVal('dt_to',container_id)
        }
        if(mydt_mydt10_d53_set_grid_where_global_var_ajax !=''){
            if(mydt_mydt10_d53_set_grid_where_global_var_ajax.id>0){ 
                Ext.ux.AjaxDefer.abort(mydt_mydt10_d53_set_grid_where_global_var_ajax);  
            }
        }
        mydt_mydt10_d53_set_grid_where_global_var_ajax = pegAjaxDefer(
            '/' + main_path + '/mydt01/mydt_mydt10_d53_set_grid_where_global_var.php', 
            params, 
            function(jsonData) {   
                pegGridRefresh(container_id,'grid');
            },
            'json',
            true
        );
    });
    btn00.setPeg_handler(function(me) {
        const selection = grid.getSelection();
        if (selection.length == 0) {
            return pegGetDic('peg_dic_core_no_item_selected',function(msg) {
                return pegAlert(msg);
            });
        }
        let nr01s = [];
        selection.forEach(row => {
			nr01s.push(row.data.nr01);
		})
       return mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01(nr01s,{success:0,sum:nr01s.length},function(dic,counters) {
            pegGridRefresh(container_id,'grid');
            if(counters.success == 0) {
                return;
            }
            if(counters.success != counters.sum) {
                msg = dic.warn.replace('#success#',counters.success).replace('#sum#',counters.sum);
                return pegToast(msg,'warn');
            }
            return pegToast(dic.success,'success');
       })
    });
    grid.record_change = function(me,row){
        var row = pegGridGetSelectedRow(me.getContainer_ID(),'grid');
        if(row){
            if(row.nr01 < 1){
               return  pegGetDic('peg_dic_core_perm_deny_edit_rec', function(desc){ 
                    return pegAlert(desc); 
                });
            }
            return mydt_mydt10_get_tbl_data_by_nr01(
                row.nr01,
                function(data) {
                    return pegAddTab_d(
                        '' , 
                        data.table , 
                        data._d, 
                        data.module, 
                        '' ,
                        data.nr01, 
                        '', 
                        {
                            mmnr01:me.getMmnr01(),
                            mnr01: me.getMnr01(),
                            peg_screen_parent_element_name: me.name,
                            peg_screen_parent_container_id: me.getContainer_ID(),
                            grid_element_name: me.name,
                            grid_element_con_id:  me.getContainer_ID()
                        }
                    );	
                }
            )
        }	
    };
    grid.peg_grid_totalCount_handler = function( totalCount, me, meStore ){
        return pegGetDic('peg_dic_mydt_mydt10_d53_grid_cnt',function(msg) {
            grid.setTitle(msg.replace('#cnt#',totalCount));
            return;
        })
    }
}
/**
 * 
 * @param {string} container_id 
 */
function mydt_mydt10_d56_afterDraw_listeners(container_id) {
    const btn00 = pegGetCmp(container_id,'btn00');
    const grid = pegGetCmp(container_id,'grid');
    btn00.setPeg_handler(function(me) {
        const selection = grid.getSelection();
        if (selection.length == 0) {
            return pegGetDic('peg_dic_core_no_item_selected',function(msg) {
                return pegAlert(msg);
            });
        }
        let nr01s = [];
        selection.forEach(row => {
			nr01s.push(row.data.nr01);
		})
       return mydt_mydt10_d56_resend_multiple_mydt13(nr01s,{success:0,sum:nr01s.length},function(dic,counters) {
            pegGridRefresh(container_id,'grid');
            if(counters.success == 0) {
                return;
            }
            if(counters.success != counters.sum) {
                msg = dic.warn.replace('#success#',counters.success).replace('#sum#',counters.sum);
                return pegToast(msg,'warn');
            }
            return pegToast(dic.success,'success');
       })
    });
    grid.peg_grid_totalCount_handler = function( totalCount, me, meStore ){
        return pegGetDic('peg_dic_mydt_mydt10_d56_grid_cnt',function(msg) {
            grid.setTitle(msg.replace('#cnt#',totalCount));
            return;
        })
    }
}
function mydt_mydt_dashboard_show_mydt10_d53() {
    // Παραστατικά με απωλεια διασυνδεσης WebApp με Παροχο
    pegAddTab_d(
        '', 
        '', 
        'mydt10_d53', 
        'mydt'
    );
}
function mydt_mydt_dashboard_show_mydt10_d52() {
     // Παραστατικα με απωλεια διασυνδεσης Παροχου με ΑΑΔΕ
    pegAddTab_d(
        '', 
        '', 
        'mydt10_d52', 
        'mydt'
    );
}
function mydt_mydt_dashboard_show_mydt10_d56() {
    // Παραστατικα με απωλεια διασυνδεσης Παροχου με ΑΑΔΕ
   pegAddTab_d(
       '', 
       '', 
       'mydt10_d56', 
       'mydt'
   );
}
var mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01_ajax = '';
function mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01(
    nr01s,
    counters,
    next
) {
    const params = {
        nr01 : nr01s.pop()
    }
    if(mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01_ajax !=''){
        if(mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01_ajax);  
        }
    }
    mydt_mydt10_d52_set_grid_where_global_var_ajax = pegAjaxDefer(
        '/' + main_path + '/mydt01/mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01.php', 
        params, 
        function(jsonData) {   
            if(jsonData.ok != 1) {
                return pegAlert(jsonData.msg?jsonData.msg:'Error');
            }
            if(jsonData.data.toast) {
                pegToast(jsonData.data.toast.message,jsonData.data.toast.type);
            } else {
                counters.success += 1;
            }
            if(nr01s.length == 0) {
                return next(jsonData.dic,counters);
            }
            return mydt_mydt10_d52_einv_get_multiple_by_mydt01_nr01(nr01s,counters,next);
        },
        'json',
        true
    );
}
var mydt_mydt10_d56_resend_multiple_mydt13_ajax = '';
function mydt_mydt10_d56_resend_multiple_mydt13(
    nr01s,
    counters,
    next
) {
    const params = {
        nr01 : nr01s.pop()
    }
    if(mydt_mydt10_d56_resend_multiple_mydt13_ajax !=''){
        if(mydt_mydt10_d56_resend_multiple_mydt13_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_d56_resend_multiple_mydt13_ajax);  
        }
    }
    mydt_mydt10_d56_resend_multiple_mydt13_ajax = pegAjaxDefer(
        '/' + main_path + '/mydt01/mydt_mydt10_d56_resend_mydt13.php', 
        params, 
        function(jsonData) {   
            if(jsonData.ok != 1) {
                return pegAlert(jsonData.msg?jsonData.msg:'Error');
            }
            if(jsonData.data.toast) {
                pegToast(jsonData.data.toast.message,jsonData.data.toast.type);
            } else {
                counters.success += 1;
            }
            if(nr01s.length == 0) {
                return next(jsonData.dic,counters);
            }
            return mydt_mydt10_d56_resend_multiple_mydt13(nr01s,counters,next);
        },
        'json',
        true
    );
}
var mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01_ajax = '';
function mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01(
    nr01s,
    counters,
    next
) {
    const params = {
        nr01 : nr01s.pop()
    }
    if(mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01_ajax !=''){
        if(mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01_ajax);  
        }
    }
    mydt_mydt10_d53_set_grid_where_global_var_ajax = pegAjaxDefer(
        '/' + main_path + '/mydt01/mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01.php', 
        params, 
        function(jsonData) {   
            if(jsonData.ok != 1) {
                return pegAlert(jsonData.msg?jsonData.msg:'Error');
            }
            if(jsonData.data.toast) {
                pegToast(jsonData.data.toast.message,jsonData.data.toast.type);
            } else {
                counters.success += 1;
            }
            if(nr01s.length == 0) {
                return next(jsonData.dic,counters);
            }
            return mydt_mydt10_d53_einv_get_multiple_by_mydt01_nr01(nr01s,counters,next);
        },
        'json',
        true
    );
}
var mydt_mydt10_get_tbl_data_by_nr01_ajax = '';
/**
 * 
 * @param {number} mydt10_nr01 
 * @param {function} next 
 */
function mydt_mydt10_get_tbl_data_by_nr01(
    mydt10_nr01 = 0,
    next
) {
    const params = {
        mydt10 : mydt10_nr01
    }
    if(mydt_mydt10_get_tbl_data_by_nr01_ajax !=''){
        if(mydt_mydt10_get_tbl_data_by_nr01_ajax.id>0){ 
            Ext.ux.AjaxDefer.abort(mydt_mydt10_get_tbl_data_by_nr01_ajax);  
        }
    }
    mydt_mydt10_get_tbl_data_by_nr01_ajax = pegAjaxDefer(
        '/' + main_path + '/mydt01/mydt_mydt10_get_tbl_data_by_nr01.php', 
        params, 
        function(jsonData) {  
            if(jsonData.ok != 1) {
                return pegAlert(jsonData.msg?jsonData.msg:'Error');
            }
            return next(jsonData.data);
        },
        'json',
        true
    );
}

/**
 * @param {string} container_id
 */
function mydt_mydt13_d_afterDraw_listeners(
    container_id = ''
) {
    const btn00 = pegGetCmp(container_id,'btn00');
    const tbl = pegGetCmp(container_id,'tbl');
    btn00.setPeg_handler(function (me) {
        const tbl_value = pegGetVal('tbl',container_id);
        const tbl_nr01_value = pegGetVal('tbl_nr01',container_id);
        switch (tbl_value) {
            case 't01' :
                pegAddTab_d(
                    '', 
                    't01',
                    't01_d', 
                    'account', 
                    '', 
                    tbl_nr01_value
                );
            break;
            case 't19' :
                pegAddTab_d(
                    '', 
                    't19',
                    't19_d', 
                    'account00', 
                    '', 
                    tbl_nr01_value
                );
            break;
        }
    });
}

// dc0001_d80
function mydt_open_mydt10_screen(container_id){
    var row=pegGridGetSelectedRow(container_id, 'grid');
    params = {};

    pegAddTab_d('', 'mydt10', 'mydt10_d', 'mydt', '', row.mydt10, '', params, container_id);
}