<?php
require('../mydt00/header.php');
global $PegInput;

require_once('../mydt_libs/mydt_mydt10.php');
require_once('../mydt_libs/mydt_mydt12.php');

$PegInput->addVar(new peg_input_alphanumeric('mydt10_nr01'));
$mydt10_nr01_str = $PegInput->getRequest('mydt10_nr01');
$PegInput->addVar(new peg_input_alphanumeric('but_delete_sel'));
$but_delete_sel = $PegInput->getRequest('but_delete_sel');

if(!pegasus_check_permission('mydt.dashboard_buttons')){
    $ret_arr['ok'] = 0;  
    $message = str_replace("##button_label##", $but_delete_sel, $_SESSION['peg_dic_mydt_dashboard_buttons_perm_deny']);
    $ret_arr['msg']  = $message;
    echo json_encode($ret_arr);
    return;    
}

$ret_arr = array();
$ret_arr['debug'] = array();
$mydt10_nr01_arr = explode(';', $mydt10_nr01_str);
$mydt10_nr01_arr = array_filter($mydt10_nr01_arr);
try {
    $p01_cnt = 0;
    $p09_cnt = 0;
    $mark_cnt = 0;
    $dmark_cnt = 0;
    $einv_cnt = 0;
    $mydt10_cnt = 0;

    foreach($mydt10_nr01_arr as $key) {
        
        pegasus_mysql_use('SELECT p01, p09, mark, dmark, einv FROM mydt10 WHERE nr01 = ?', $mydt10_rec, array($key));
        
        if($mydt10_rec['einv']!=0){
            $einv_cnt++;
        }else{
            if($mydt10_rec['p01'] === 0) {
                $p01_cnt++;
            }
            if($mydt10_rec['p09'] != 0) {
                $p09_cnt++;
            }
            if($mydt10_rec['mark'] === '') {
                $mark_cnt++;
            }
            if($mydt10_rec['dmark'] != '') {
                $dmark_cnt++;
            }


            $arr1 = array(); $arr2 = array();
            array_push($arr1, 'p05');   array_push($arr2, 1); // Σημειώνω "Διαγράφηκε"
            array_push($arr1, 'p02_1'); array_push($arr2, 1); // Σημειώνω "Προς Επαναποστολή"
            array_push($arr1, 'dmark'); array_push($arr2, ''); // Σβήνω το dmark
            array_push($arr1, 'ddate'); array_push($arr2, '0100-01-01'); // Σβήνω την ημερομηνία διαγραφής.
            //p01 = 1 (Αποστολή)
            //p09 = 0 (Δημιουργήθηκε από Pegasus)
            //mark <> '' (Το παραστατικό έχει πάρει ΜΑΡΚ)
            //dmark = '' (Το παραστατικό δεν έχει deletion mark)
            $where = "nr01 = :nr01 AND p01 = 1 AND p09 = 0 AND mark <> '' AND dmark = ''";
            pegasus_mysql_update('mydt10', $arr1, $arr2, $where, 0, 1, 1, array("nr01" => $key));
    
            $ret_arr['debug'][] = $mydt10;
        }
        $mydt10_cnt++;
        


        
    }
    $fails = $p01_cnt + $p09_cnt + $mark_cnt + $dmark_cnt + $einv_cnt;
    $successes = $mydt10_cnt - $fails;
    $err_p01    = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_err_1'];
    $err_p09    = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_err_2'];
    $err_mark   = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_err_3'];
    $err_dmark  = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_err_4'];
    $err_einv   = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_err_5'];;
    $succ       = $_SESSION['peg_dic_mydt_mydt10_invoices_marked_for_del_successfully'];
    
    if($p01_cnt > 0) {
        $err_p01 = str_replace('##p01_cnt##', $p01_cnt, $err_p01);
        $ret_msg .= $err_p01 . "<br>"; 
    }
    if($p09_cnt > 0) {
        $err_p09 = str_replace('##p09_cnt##', $p09_cnt, $err_p09);
        $ret_msg .= $err_p09 . "<br>";
    }
    if($mark_cnt > 0) {
        $err_mark = str_replace('##mark_cnt##', $mark_cnt, $err_mark);
        $ret_msg .= $err_mark . "<br>";
    }
    if($einv_cnt > 0){
        $err_einv = str_replace('##einv_cnt##', $einv_cnt, $err_einv);
        $ret_msg .= $err_einv . "<br>";
    }
    if($dmark_cnt > 0) {
        $err_dmark = str_replace('##dmark_cnt##', $dmark_cnt, $err_dmark);
        $ret_msg .= $err_dmark . "<br>";
    }
    if($successes > 0) {
        $succ = str_replace('##succ_cnt##', $successes, $succ);
        $ret_msg .= $succ;
    }
    $ret_msg = str_replace("##mydt10_cnt##", $mydt10_cnt, $ret_msg);



    $ret_arr['ok']   = ($fails > 0) ? 0 : 1; 
    $ret_arr['refresh'] = ($fails > 0 && $successes > 0) ? 1 : 0; //Για να κάνει refresh το grid όταν έχω fail και τουλ. 1 success  
    $ret_arr['msg']  = $ret_msg;   
}catch(Exception $e) {
    $ret_arr['ok']   = 0;
    $ret_arr['msg']  = $e->getMessage();
}

 
echo json_encode($ret_arr);
