<?php
    class mydt_mydt10{

        private $tbl;
        private $tbl_nr01; 
        //private $tmp_table_name_0; 
        private $tmp_table_name_1; 
        private $tmp_table_name_2;
        //E: 10000857
        private $tmp_table_name_3;
        //E: 10001024
        private $tmp_table_name_4;
        private $sql_params;
        private $p_mydt10mark;
        private $p_mydt10tot;
        private $nt_p06; //Add only new records
        private $store_in_sql;
        private $mydt10_tmp_record_count; //μεταβλητη που μας λεει το count του  tmp πινακα mydt10
        private $mydt00_p105;
        private $nt_onlytemp; // Only tmp records
        

        function __construct($tbl='', $tbl_nr01=0 , $params = array() , $stores_str=''  ){

            $this->_isValid_tbl($tbl);
            $this->_isValid_tbl_nr01($tbl_nr01);

            $this->tbl            = $tbl; 
            $this->tbl_nr01       = $tbl_nr01;

            $this->nt_p06 = 0;
            if(isset($params['nt_p06'])){
                $this->nt_p06 = $params['nt_p06'];
            }

            $this->nt_p06 = 0;
            if(isset($params['nt_onlytemp'])) {
                $this->nt_onlytemp = $params['nt_onlytemp'];
            }

            $this->sql_params = array();
            $this->sql_params['nt_p01'] = '01000101';
            $this->sql_params['nt_p02'] = '29991231';
            $this->sql_params['nt_p03'] = 0;
            $this->sql_params['nt_p04'] = 9999999999;
            $this->sql_params['nt_p07d'] = '01000101';
            $this->sql_params['nt_p07t'] = '';
            $this->sql_params['nt_p08d'] = '29991231';
            $this->sql_params['nt_p08t'] = '99:99:99';
            $this->sql_params['user_pswd'] = $_SESSION['username'];   
            // Στοιχεία Επιχείρησης (Βασικές Παράμετροι Πυρήνα)  
            $this->sql_params['nt_p101_1'] = $_SESSION['cor000_f00p204']; //AFM
            $this->sql_params['nt_p101_2'] = $_SESSION['cor000_f00p203'] . ' ' . $_SESSION['cor000_f00p2031'] .' ' . $_SESSION['cor000_f00p2032']; // EPONIMIA ONOMA ONOMA PATROS
            $this->sql_params['nt_p101_3'] = $_SESSION['cor000_f00p207'] . ' ' . $_SESSION['cor000_f00p208']; //ODOS ARITHMOS
            $this->sql_params['nt_p101_4'] = $_SESSION['cor000_f00p206']; // Poli
            $this->sql_params['nt_p101_5'] = $_SESSION['cor000_f00p209']; // T.K.
            
           
           
           

            foreach ($params as $key => $value) {
                $this->sql_params[$key] = $value;
            }

            $stores_st = self::make_store_where( $stores_str);
            $this->store_in_sql =  $stores_st['sql'];
            if(is_array( $stores_st['sqlParams'])){
                $this->sql_params =  array_merge( $this->sql_params ,  $stores_st['sqlParams']);
            }            


            $this->set_mydt00_p105($_SESSION['mydt00_p105']);

            if( peg_dateIsEmpty($this->sql_params['nt_p01']) ){
                $this->sql_params['nt_p01'] = $_SESSION['mydt00_p104'];
                if(empty($_SESSION['mydt00_p104'])){
                    $this->sql_params['nt_p01']= '01000101';
                }
            }
            if( peg_dateIsEmpty($this->sql_params['nt_p02']) ){
                $this->sql_params['nt_p02']= '01000101';
            }
            if( peg_dateIsEmpty($this->sql_params['nt_p07d']) ){
                $this->sql_params['nt_p07d']= '01000101';
            }
            if( peg_dateIsEmpty($this->sql_params['nt_p08d']) ){
                $this->sql_params['nt_p08d']= '20990101';
            }

            if($tbl_nr01<0){
                $tbl_nr01 = '_';
            }
            
            $this->tmp_table_name_1 = 'peg_tmp_mydt_tbl1_' . date('Ymd') . '_' . $tbl . '_' . $tbl_nr01 . '_' . rand();
            $this->tmp_table_name_2 = 'peg_tmp_mydt_tbl2_' . date('Ymd') . '_' . $tbl . '_' . $tbl_nr01 . '_' . rand();
            //E: 10000857
            $this->tmp_table_name_3 = 'peg_tmp_mydt_tbl3_' . date('Ymd') . '_' . $tbl . '_' . $tbl_nr01 . '_' . rand();
            //E: 10001024
            $this->tmp_table_name_4 = 'peg_tmp_mydt_tbl4_' . date('Ymd') . '_' . $tbl . '_' . $tbl_nr01 . '_' . rand();

            $this->p_mydt10mark     = '@2del@_' . date('Ymd') .  '_' . rand(0, 99999);
            $this->p_mydt10tot      = '@tot@_' . date('Ymd') .  '_' . rand(0, 99999);
        }
        
        public static function make_store_where($stores_str){
             
            if(pegasus_module_exists('stores')){
                $stores_arr00 = explode('#' , $stores_str );
                foreach ($stores_arr00 as $key => $value) {
                    if($value!==''){
                        $stores_arr[$key] = $value;
                    }
                }
    
                $stores_st =  pegasus_mysql_prepare_in_statement($stores_arr,  'store_p01_');
                return   $stores_st;
            }
        }

        public function check_before_update(){

            if( $this->tbl == 'a55'){          
                $sql = $this->_read_sql('../mydt_sql/a55/mydt10p200202_check.sql');
                $sql = str_replace( '{p_mydt10where}', "a55.nr01=:tbl_nr01" , $sql);
            }

            if( $this->tbl == 'a56'){
                $sql = $this->_read_sql('../mydt_sql/a56/mydt10p200203_check.sql');
                $sql = str_replace( '{p_mydt10where}', "a56.nr01=:tbl_nr01" , $sql);
            }

            if( $this->tbl == 't08'){
                $sql = $this->_read_sql('../mydt_sql/t08/mydt10p200204_check.sql');

                if(!pegasus_module_exists('invsupp')){
                    $sql = str_replace( "/**start_module_exists_invsupp**/" , "/**" , $sql);
                    $sql = str_replace( "/**end_module_exists_invsupp**/"   , "**/" , $sql);
                }
    
                if(pegasus_module_exists('invsupp')){
                    $sql = str_replace( "/**start_module_not_exists_invsupp**/" , "/**" , $sql);
                    $sql = str_replace( "/**end_module_not_exists_invsupp**/"   , "**/" , $sql);
                }
                
                if(!pegasus_module_exists('suppliers')){
                    $sql = str_replace( "/**start_module_exists_suppliers**/" , "/**" , $sql);
                    $sql = str_replace( "/**end_module_exists_suppliers**/"   , "**/" , $sql);
                }
    
                if(pegasus_module_exists('suppliers')){
                    $sql = str_replace( "/**start_module_not_exists_suppliers**/" , "/**" , $sql);
                    $sql = str_replace( "/**end_module_not_exists_suppliers**/"   , "**/" , $sql);
                }

                $sql = str_replace( '{p_mydt10where}', "t08.nr01=:tbl_nr01" , $sql);
            }

            if( $this->tbl == 'tran01'){
                $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205_check.sql');
                $sql = str_replace( '{p_mydt10where}', "tran01.nr01=:tbl_nr01" , $sql);
            }

            if( $this->tbl == 'a60'){
                $sql = $this->_read_sql('../mydt_sql/a60/mydt10p200209_check.sql');
                $sql = str_replace( '{p_mydt10where}', "a60.nr01=:tbl_nr01" , $sql);
            }

            if( $this->tbl == 'tran09'){
                $sql = $this->_read_sql('../mydt_sql/tran09/mydt10p200210_check.sql');
                $sql = str_replace( '{p_mydt10where}', "tran09.nr01=:tbl_nr01" , $sql);
            }
            
            pegasus_mysql_use($sql , $tbl , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            
            if($tbl['cnt']>0){
                return true;
            }else{
                return false;
            }

        }

        /**
         * Αυτη η μεθοδος χρησιμοποιέιτε για να βρει τα δεδομενα το mydt10
         * Xωρις να καταχωρήσει mydt10
         * Ειναι χρησιμό οταν χρειαζομαστε π.χ. το είδος του παραστατικό ή τα συναλα για να παραξουμε υπογραφη πληρωμης.
         */
        public function get_mydt10_data(){
            $this->create_tmp_to_DB();
            if( $this->tbl != 'a55' ||  !($this->tbl_nr01>0) ){
                return array();
            }            
            $this->update_tmp_from_a55();
            $this->correct_mydt_tmp_data();
            
            
            pegasus_mysql_use("select * from ". $this->tmp_table_name_1 . ";" , $mydt10);

            if(!empty($mydt10)){
                $this->drop_tmp_to_DB();
                return $mydt10;     
            }       

            //ψαχνω ανα υπαρχει καταχωρημενο 
            pegasus_mysql_use("select * from mydt10 where tbl=:tbl && tbl_nr01=:tbl_nr01;" , $mydt10 ,  array("tbl" => $this->tbl , "tbl_nr01" => $this->tbl_nr01) );
            return $mydt10;
        }


        public function execute_update($limit_sql = '', $action=''){

            $this->create_tmp_to_DB();
            //αν ερχεται με άδειες τις παραμέτρους υποθέτω ότι θα παίξει για 1 παραστατικο.
            $single_mode = false;
            if($limit_sql === '' && $action === ''){
                $single_mode = true;
            }

            if( $this->tbl == 'a55'){
                if($action=='insert' || $single_mode === true){
                    $this->update_tmp_from_a55($limit_sql);
                }
                if($action=='delete' || $single_mode === true){
                    $this->update_mydt10_a55_with_mydt10mark();
                }
            }

            if( $this->tbl == 'a56'){
                if($action=='insert' || $single_mode === true ){
                 $this->update_tmp_from_a56();
                }
                if($action=='delete' || $single_mode === true ){
                    $this->update_mydt10_a56_with_mydt10mark();
                }
            }

            if( $this->tbl == 't08'){
                if($action=='insert' || $single_mode === true ){
                    $this->update_tmp_from_t08();
                }
            }

            if( $this->tbl == 'tran01'){
                if($action=='insert' || $single_mode === true ){
                    $this->update_tmp_from_tran01();
                }
                if($action=='delete' || $single_mode === true ){
                    $this->update_mydt10_tran01_with_mydt10mark();

                }
            }

            if( $this->tbl == 'a60'){
                if($action=='insert' || $single_mode === true ){
                    $this->update_tmp_from_a60();
                }
                if($action=='delete' || $single_mode === true ){
                    $this->update_mydt10_a60_with_mydt10mark();

                }
            }

            if( $this->tbl == 'tran09'){
                if($action=='insert' || $single_mode === true ){
                    $this->update_tmp_from_tran09();
                }
                if($action=='delete' || $single_mode === true ){
                    $this->update_mydt10_tran09_with_mydt10mark();
                }
            }

            //mydt10_tmp_record_count - εγγραφων tmp
            //αν εχει 100 συνεχιζω
            if(!$single_mode){
                $this->mydt10_tmp_record_count = pegasus_mysql_printfld($this->tmp_table_name_1,'count(*)','1=1');
            }
            
            $this->correct_mydt_tmp_data();
            $this->update_mydt_from_tmp();
            //$this->create_mydt12_records();
            mydt_mydt10::create_mydt12_records($this->tbl ,$this->tbl_nr01 , $this->p_mydt10mark, $this->p_mydt10tot, $this->get_mydt00_p105());
            $this->drop_tmp_to_DB();
            $this->check_if_is_correct(); 

            //update των εγγραφων του mydttot
            if(!empty($this->p_mydt10tot)){
                pegasus_mysql_update('mydt10', array('remguc'), array(''), 'mydt10.remguc=:p_mydt10tot', 0, 1, 1, array('p_mydt10tot' => $this->p_mydt10tot));
                pegasus_mysql_update('mydt11', array('remguc'), array(''), 'mydt11.remguc=:p_mydt10tot', 0, 1, 1, array('p_mydt10tot' => $this->p_mydt10tot));
                //E: 10000857
                pegasus_mysql_update('mydt13', array('remguc'), array(''), 'mydt13.remguc=:p_mydt10tot', 0, 1, 1, array('p_mydt10tot' => $this->p_mydt10tot));
                //E: 10001024
                pegasus_mysql_update('mydt14', array('remguc'), array(''), 'mydt14.remguc=:p_mydt10tot', 0, 1, 1, array('p_mydt10tot' => $this->p_mydt10tot));
            }

        }    

        public function get_mydt10_tmp_record_count(){
            return $this->mydt10_tmp_record_count;
        }

        static function create_mydt12_records( $tbl='' , $tbl_nr01=0 , $p_mydt10mark='', $p_mydt10tot='', $mydt00_p105=-1){
            $sql='';
            $ret_sql='';

            if($mydt00_p105 == -1) {
                $mydt00_p105 = $_SESSION['mydt00_p105'];
            }
            
            $tbl_nr01_00 = $tbl_nr01;
            if($tbl_nr01<0){
                $tbl_nr01_00 = '_';
            }
            $tmp_table_name_0 = 'peg_tmp_mydt_tbl0_' . date('Ymd') . '_' . $tbl . '_' . $tbl_nr01_00 . '_' . rand();
    
            //Το εχω σε μεεταβλητη για να κανεi ενα delete 
            if(empty($p_mydt10mark)){
                $p_mydt10mark = '@2del@_' . date('Ymd') .  '_' . rand(0, 99999);
            }
            
            $sql = peg_read_file('../mydt_sql/create_mydt12_records/mydt10p22_1.sql');
            $sql = str_replace( '{p_mydt10tbl0}', $tmp_table_name_0 , $sql);

            // Αν θέλουμε ξεχωριστές συνοπτικές γραμμές για κάθε είδος. Βασική παράμετρος για mydt, έρχεται πάντα 1 στην περίπτωση ηλεκτρονικής.
            if($mydt00_p105 == 1) {
                // $sql = str_replace('{virtual_groupby_fld}', ", CASE WHEN mydt11.rectype = 0 THEN mydt11.nr01 ELSE 0 END", $sql);
                $sql = str_replace( '{peg_arr[2]}', 1 , $sql);
            }else{
                // $sql = str_replace('{virtual_groupby_fld}', "", $sql);
                $sql = str_replace( '{peg_arr[2]}', 0 , $sql);
            }
            

            if( $tbl_nr01>0){
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01" , $sql);
            }else{
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.remguc=:p_mydt10tot" , $sql);
            }
    
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query( $_sql,   array('tbl' => $tbl,'tbl_nr01' => $tbl_nr01 , 'p_mydt10mark' => $p_mydt10mark , 'username' => $_SESSION['username'], 'p_mydt10tot' => $p_mydt10tot)  ) ;
                //$ret_sql .= pegasus_replace_values_in_sql( $_sql,   array('tbl' => $tbl,'tbl_nr01' => $tbl_nr01 , 'p_mydt10mark' => $p_mydt10mark , 'username' => $_SESSION['username'], 'p_mydt10tot' => $p_mydt10tot)  ) ;
            }           
    
           
            $sql = peg_read_file('../mydt_sql/create_mydt12_records/mydt10p22_2.sql');
            $sql = str_replace( '{p_mydt10tbl0}', $tmp_table_name_0 , $sql);
            if( $tbl_nr01>0){
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01" , $sql);
            }else{
                $sql = str_replace( '{peg_arr[1]}', "  ( mydt10.remguc=:p_mydt10tot || mydt11.remguc=:p_mydt10tot ) " , $sql);
            }
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query( $_sql,   array('tbl' => $tbl,'tbl_nr01' => $tbl_nr01 , 'p_mydt10mark' => $p_mydt10mark , 'username' => $_SESSION['username'], 'p_mydt10tot' => $p_mydt10tot)  ) ;
                //$ret_sql .= pegasus_replace_values_in_sql( $_sql,   array('tbl' => $tbl,'tbl_nr01' => $tbl_nr01 , 'p_mydt10mark' => $p_mydt10mark , 'username' => $_SESSION['username'], 'p_mydt10tot' => $p_mydt10tot)  ) ;
            }      

            pegasus_mysql_delete('mydt12' ,  'mydt12.remguc=:p_mydt10mark' , 1 ,  array('p_mydt10mark' => $p_mydt10mark));
            pegasus_mysql_drop_table( $tmp_table_name_0 );
        }

        private function check_if_is_correct(){


            if( $this->tbl_nr01>0){
                $sqlWhere =  " ifnull(p04, '')<>''  && mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01 ";
            }else{
                $sqlWhere =  " ifnull(p04, '')<>''  &&  mydt10.tbl_nr01>0 ";
            }

            
            //**set error codes=''
            pegasus_mysql_update('mydt10' , array('p04') , array('') , 
            $sqlWhere , 
            0 , 
            1,
            1, 
            array_merge($this->sql_params , array('tbl' => $this->tbl,'tbl_nr01' => $this->tbl_nr01)));
            
            $ret_sql='';
            //**mydt98.nr01=1
            $sql = $this->_read_sql('../mydt_sql/check_if_is_correct/mydt10p21_1.sql');
            if( $this->tbl_nr01>0){
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01" , $sql);
            }else{
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.remguc=:p_mydt10tot" , $sql);
            }
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query( $_sql, array_merge($this->sql_params , array('tbl' => $this->tbl,'tbl_nr01' => $this->tbl_nr01, 'p_mydt10tot' => $this->p_mydt10tot)) ) ;
                //$ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('tbl' => $this->tbl,'tbl_nr01' => $this->tbl_nr01, 'p_mydt10mark' => $this->p_mydt10mark)) );
            }           
            
            //**mydt98.nr01=2
            $sql = $this->_read_sql('../mydt_sql/check_if_is_correct/mydt10p21_2.sql');
            if( $this->tbl_nr01>0){
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01" , $sql);
            }else{
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.remguc=:p_mydt10tot" , $sql);
            }
            
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query( $_sql, array_merge($this->sql_params , array('tbl' => $this->tbl, 'tbl_nr01' => $this->tbl_nr01, 'p_mydt10tot' => $this->p_mydt10tot)) );
                //$ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('tbl' => $this->tbl,'tbl_nr01' => $this->tbl_nr01, 'p_mydt10mark' => $this->p_mydt10mark)) );
            } 

            //**mydt98.nr01=3
            $sql = $this->_read_sql('../mydt_sql/check_if_is_correct/mydt10p21_3.sql');
            if( $this->tbl_nr01>0){
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.tbl=:tbl && mydt10.tbl_nr01=:tbl_nr01" , $sql);
            }else{
                $sql = str_replace( '{peg_arr[1]}', "  mydt10.remguc=:p_mydt10tot" , $sql);
            }
            
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query( $_sql, array_merge($this->sql_params , array('tbl' => $this->tbl, 'tbl_nr01' => $this->tbl_nr01, 'p_mydt10tot' => $this->p_mydt10tot)) );
                //$ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('tbl' => $this->tbl,'tbl_nr01' => $this->tbl_nr01, 'p_mydt10mark' => $this->p_mydt10mark)) );
            } 

             //echo $ret_sql;
        }

        private function create_tmp_to_DB(){
            $sql = $this->_read_sql('../mydt_sql/mydt10p200200.sql');   // ADD E: 10000857 & ADD E: 10001024
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql);
                // echo $sql;
            }           
        }

        private function update_tmp_from_a55($limit_sql='') {
            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/a55/mydt10p200202.sql');
            if( $this->tbl_nr01 ==-1){
                $sql = str_replace( '{p_mydt10where}', "a55.nr01>0 && a55.y_ekd=0" , $sql);
            }else{
                $sql = str_replace( '{p_mydt10where}', "a55.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }
            
            if(!pegasus_module_exists('hot000')){
                $sql = str_replace( "/**start_module_exist_hot000**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_exist_hot000**/"   , "**/" , $sql);
                $sql = pegasus_replace_modules_exists_tags($sql);
            }
            
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            }   
            
            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/a55/mydt10p200202_1.sql');
            pegasus_query($sql); 

            //E: 10000857
            // mydt13 records.
            $sql = $this->_read_sql('../mydt_sql/a55/mydt10p200202_3.sql');
            // echo $sql; 
            // die();
            pegasus_query($sql);    

        }

        private function update_mydt10_a55_with_mydt10mark(){
             $ret_sql = '';
             // mark records to delete
             if(!$this->nt_p06){
                $sql = $this->_read_sql('../mydt_sql/a55/mydt10p200202_2.sql');
                if( $this->tbl_nr01 ==-1){
                    $sql = str_replace( '{p_mydt10where}', "a55.nr01>0" , $sql);
                }else{
                    $sql = str_replace( '{p_mydt10where}', "a55.nr01=:tbl_nr01" , $sql);
                }

                $sql_array  = explode('/*peg_end*/' , $sql);
                foreach($sql_array as $_sql){
                    pegasus_query($_sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01)) );
                     $ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01))  );
                }
            }
        }

        private function update_tmp_from_a56($limit_sql=''){
            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/a56/mydt10p200203.sql');
            if( $this->tbl_nr01 ==-1){
                $sql = str_replace( '{p_mydt10where}', "a56.nr01>0" , $sql);
            }else{
                $sql = str_replace( '{p_mydt10where}', "a56.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }
            // pegasus_query($sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            // $ret_sql =  pegasus_replace_values_in_sql($sql ,   array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            $ret_sql = '';
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            }

            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/a56/mydt10p200203_1.sql');
            pegasus_query($sql);
            $ret_sql .=  $sql  ;

            //E: 10000857
            // mydt13 records.
            $sql = $this->_read_sql('../mydt_sql/a56/mydt10p200203_3.sql');
            pegasus_query($sql);
            $ret_sql .=  $sql  ;

        }

        private function update_mydt10_a56_with_mydt10mark()
        {
            $ret_sql = '';
            // mark records to be deleted
            if (!$this->nt_p06) {
                $sql = $this->_read_sql('../mydt_sql/a56/mydt10p200203_2.sql');
                if ($this->tbl_nr01 == -1) {
                    $sql = str_replace('{p_mydt10where}', "a56.nr01>0", $sql);
                } else {
                    $sql = str_replace('{p_mydt10where}', "a56.nr01=:tbl_nr01", $sql);
                }
    
                $sql_array  = explode('/*peg_end*/', $sql);
                foreach ($sql_array as $_sql) {
                    pegasus_query($_sql, array_merge($this->sql_params, array('p_mydt10mark' => $this->p_mydt10mark, 'tbl_nr01' => $this->tbl_nr01)));
                    $ret_sql .=  pegasus_replace_values_in_sql($_sql,   array_merge($this->sql_params, array('p_mydt10mark' => $this->p_mydt10mark, 'tbl_nr01' => $this->tbl_nr01)));
                }
            }
        }

        private function update_tmp_from_t08($limit_sql=''){
           
            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/t08/mydt10p200204.sql');


            if(!pegasus_module_exists('invsupp')){
                $sql = str_replace( "/**start_module_exists_invsupp**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_exists_invsupp**/"   , "**/" , $sql);
            }

            if(pegasus_module_exists('invsupp')){
                $sql = str_replace( "/**start_module_not_exists_invsupp**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_not_exists_invsupp**/"   , "**/" , $sql);
            }
            
            if(!pegasus_module_exists('suppliers')){
                $sql = str_replace( "/**start_module_exists_suppliers**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_exists_suppliers**/"   , "**/" , $sql);
            }

            if(pegasus_module_exists('suppliers')){
                $sql = str_replace( "/**start_module_not_exists_suppliers**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_not_exists_suppliers**/"   , "**/" , $sql);
            }

            if( $this->tbl_nr01 ==-1){
                $sql = str_replace( '{p_mydt10where}', "t08.nr01>0" , $sql);
            }else{
                $sql = str_replace( '{p_mydt10where}', "t08.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }

            pegasus_query($sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
  
            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/t08/mydt10p200204_1.sql');
            pegasus_query($sql);

            // mydt11 records.
            if(!$this->nt_p06){
                $sql = $this->_read_sql('../mydt_sql/t08/mydt10p200204_2.sql');
                if( $this->tbl_nr01 ==-1){
                  $sql = str_replace( '{p_mydt10where}', "t08.nr01>0" , $sql);
                }else{
                    $sql = str_replace( '{p_mydt10where}', "t08.nr01=:tbl_nr01" , $sql);
                }
                pegasus_query($sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01)) );
                //   $ret_sql .=  pegasus_replace_values_in_sql($sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark)));
            }
            // throw new Exception('<pre>'.$ret_sql.'</pre>');   

            //E: 10000857
            // mydt13 records.
            $sql = $this->_read_sql('../mydt_sql/t08/mydt10p200204_3.sql');
            pegasus_query($sql);
            // echo $sql;
            // die("--");
        }

        private function update_tmp_from_tran01($limit_sql=''){
           
            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205.sql');
            if( $this->tbl_nr01 ==-1){
                $sql = str_replace( '{p_mydt10where}', "tran01.nr01>0" , $sql);
            }else{
                $sql = str_replace( '{p_mydt10where}', "tran01.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }

            $p82_arr = array(
                'tran_mydt_tran02_nr01',  
                'tran_mydt_tran02_p01',
                'tran_mydt_tran02_p02',
                'tran_mydt_tran02_p05',
                'tran_mydt_tran02_p06',
                'tran_mydt_tran02_p09',
                'tran_mydt_tran05_p01', 
                'tran_mydt_tran15_p01', 
                'tran_mydt_tran02_p04'
            );

            foreach ($p82_arr as $fld) {
                $sql = str_replace( '{peg_dic_'.$fld.'}', $_SESSION['peg_dic_'.$fld], $sql);
            }


            pegasus_query($sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
  
            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205_1.sql');
            pegasus_query($sql);

            //E: 10000857
            // mydt13 records.
            $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205_3.sql');

            //E: 10001024
            // mydt14 records.
            $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205_4.sql');

            pegasus_query($sql);

            //  die('<pre>'.$ret_sql.'</pre>');   

        }

        private function update_mydt10_tran01_with_mydt10mark()
        {
            $ret_sql = '';
            //mark records to be deleted 
            if(!$this->nt_p06){
                $sql = $this->_read_sql('../mydt_sql/tran01/mydt10p200205_2.sql');
                if( $this->tbl_nr01 ==-1){
                  $sql = str_replace( '{p_mydt10where}', "tran01.nr01>0" , $sql);
                }else{
                    $sql = str_replace( '{p_mydt10where}', "tran01.nr01=:tbl_nr01" , $sql);
                }

                $sql_array  = explode('/*peg_end*/' , $sql);
                foreach($sql_array as $_sql){
                    pegasus_query($_sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01)) );
                     $ret_sql =  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01))  );
                }
            }
        }

        private function update_tmp_from_a60($limit_sql='') {
            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/a60/mydt10p200209.sql');
            if( $this->tbl_nr01 ==-1){
                // $sql = str_replace( '{p_mydt10where}', "a60.nr01>0 && a60.y_ekd=0" , $sql);
                $sql = str_replace( '{p_mydt10where}', "a60.nr01>0 " , $sql); //TODO εδώ νομίζω δεν θα έχουμε y_ekd
            }else{
                $sql = str_replace( '{p_mydt10where}', "a60.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }
            
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            }   
            // echo pegasus_replace_values_in_sql($sql,  array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01))); 
            // die();
            
            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/a60/mydt10p200209_1.sql');
            pegasus_query($sql); 

            // mydt13 records.
            $sql = $this->_read_sql('../mydt_sql/a60/mydt10p200209_3.sql');
            // echo $sql; 
            // die();
            pegasus_query($sql);    

        }

        private function update_mydt10_a60_with_mydt10mark(){
            $ret_sql = '';
            // mark records to delete
            if(!$this->nt_p06){
               $sql = $this->_read_sql('../mydt_sql/a60/mydt10p200209_2.sql');
               if( $this->tbl_nr01 ==-1){
                   $sql = str_replace( '{p_mydt10where}', "a60.nr01>0" , $sql);
               }else{
                   $sql = str_replace( '{p_mydt10where}', "a60.nr01=:tbl_nr01" , $sql);
               }

               $sql_array  = explode('/*peg_end*/' , $sql);
               foreach($sql_array as $_sql){
                   pegasus_query($_sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01)) );
                    $ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01))  );
               }
           }
       }

       private function update_tmp_from_tran09($limit_sql='') {

            // mydt10 records.
            $sql = $this->_read_sql('../mydt_sql/tran09/mydt10p200210.sql');

            if( $this->tbl_nr01 ==-1){
                $sql = str_replace( '{p_mydt10where}', "tran09.nr01>0 ", $sql);
            }else{
                $sql = str_replace( '{p_mydt10where}', "tran09.nr01=:tbl_nr01" , $sql);
            }

            if(!empty($limit_sql)){
                $sql = str_replace( '{p_mydt10limit}', $limit_sql , $sql);
            }else{
                $sql = str_replace( '{p_mydt10limit}', '' , $sql);
            }
            
            $sql_array  = explode('/*peg_end*/' , $sql); 
            foreach($sql_array as $_sql){
                pegasus_query($_sql , array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01)) );
            }   
            // echo pegasus_replace_values_in_sql($sql,  array_merge($this->sql_params , array('tbl_nr01' => $this->tbl_nr01))); 
            // die();
            
            // mydt11 records.
            $sql = $this->_read_sql('../mydt_sql/tran09/mydt10p200210_1.sql');
            pegasus_query($sql); 
        }

        private function update_mydt10_tran09_with_mydt10mark(){
            $ret_sql = '';
            // mark records to delete
            if(!$this->nt_p06){
                $sql = $this->_read_sql('../mydt_sql/tran09/mydt10p200210_2.sql');
                
                if( $this->tbl_nr01 ==-1){
                    $sql = str_replace( '{p_mydt10where}', "tran09.nr01>0", $sql);
                }else{
                    $sql = str_replace( '{p_mydt10where}', "tran09.nr01=:tbl_nr01", $sql);
                }

                $sql_array  = explode('/*peg_end*/' , $sql);
                foreach($sql_array as $_sql){
                    pegasus_query($_sql , array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01)) );
                        $ret_sql .=  pegasus_replace_values_in_sql($_sql ,   array_merge($this->sql_params , array('p_mydt10mark' => $this->p_mydt10mark,'tbl_nr01' => $this->tbl_nr01))  );
                }
            }
        }

        private function correct_mydt_tmp_data(){
            //Ενημέρωση του Αρ. Εγκαταστασης οταν δεν εχουμε το module stores.
            if(!pegasus_module_exists('stores')){
                $sql = $this->_read_sql('../mydt_sql/_update_branch_from_mydt00.sql');
                pegasus_query($sql);
            }

            $ret_sql = '';
            //Link Tables...
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299.sql');           // ADD E: 10000857 && ADD E: 10001024
            if(!pegasus_module_exists('stores')){
                $sql = str_replace( "/**start_stores**/" , "/**" , $sql);
                $sql = str_replace( "/**end_stores**/"   , "**/" , $sql);
            }

            if($this->nt_p06!='1'){
                $sql = str_replace( "/**start_delete_existing_records**/" , "/**" , $sql);
                $sql = str_replace( "/**end_delete_existing_records**/"   , "**/" , $sql);
            }

            if($this->nt_onlytemp == 1) {
                $sql = str_replace( "/**start_only_temp_records**/" , "/**" , $sql);
                $sql = str_replace( "/**end_only_temp_records**/"   , "**/" , $sql);
            }

            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql ,  $this->sql_params  );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
            }

            //  echo $ret_sql;
            //  die();
            //**std corrections    
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299_900.sql');

            if(!pegasus_module_exists('stores')){
                $sql = str_replace( "/**start_stores**/" , "/**" , $sql);
                $sql = str_replace( "/**end_stores**/"   , "**/" , $sql);
            }

            if(pegasus_module_exists('stores')){
                $sql = str_replace( "/**start_not_exists_stores**/" , "/**" , $sql);
                $sql = str_replace( "/**end_not_exists_stores**/"   , "**/" , $sql);
            }

            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql ,  $this->sql_params  );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
            }


            if($_SESSION['mydt00_p100']==1){
                
                //**def e3 from mydt65    
                $sql = $this->_read_sql('../mydt_sql/mydt10p200299_901.sql');
                $sql_array  = explode('/*peg_end*/' , $sql);
                foreach($sql_array as $_sql){
                    pegasus_query($_sql ,  $this->sql_params  );
                }
            }

            //**std corrections mydt10p200299_902
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299_902.sql');
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql ,  $this->sql_params  );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
            }


        }
        private function update_mydt_from_tmp(){
            
            
            //update mydt10...
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299_1.sql');
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql ,  array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark, 'p_mydt10tot' => $this->p_mydt10tot))  );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark, 'p_mydt10tot' => $this->p_mydt10tot)) );
            }

            //update mydt11...
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299_2.sql');
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark, 'p_mydt10tot' => $this->p_mydt10tot))  ) ;
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
            }
            //E: 10000857
             //update mydt13...
             $sql = $this->_read_sql('../mydt_sql/mydt10p200299_4.sql');
             $sql_array  = explode('/*peg_end*/' , $sql);
             foreach($sql_array as $_sql){
                 pegasus_query($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark, 'p_mydt10tot' => $this->p_mydt10tot))  ) ;
                 $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
             }

              //E: 10001024
             //update mydt14...
             $sql = $this->_read_sql('../mydt_sql/mydt10p200299_5.sql');
             $sql_array  = explode('/*peg_end*/' , $sql);
             foreach($sql_array as $_sql){
                 pegasus_query($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark, 'p_mydt10tot' => $this->p_mydt10tot))  ) ;
                 $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
             }

            //Delete marked Records...
            $sql = $this->_read_sql('../mydt_sql/mydt10p200299_3.sql'); // ADD E: 10000857 && ADD E: 10001024
            $sql_array  = explode('/*peg_end*/' , $sql);
            foreach($sql_array as $_sql){
                pegasus_query($_sql ,   array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark))  );
                $ret_sql .=  pegasus_replace_values_in_sql($_sql , array_merge($this->sql_params , array('user_pswd' => $_SESSION['username'],'p_mydt10mark' => $this->p_mydt10mark)) );
            }
            
            pegasus_mysql_delete('mydt10' ,  'mydt10.remguc=:p_mydt10mark' , 1 ,  array('p_mydt10mark' => $this->p_mydt10mark));
            pegasus_mysql_delete('mydt11' ,  'mydt11.remguc=:p_mydt10mark' , 1 ,  array('p_mydt10mark' => $this->p_mydt10mark));
            pegasus_mysql_delete('mydt13' ,  'mydt13.remguc=:p_mydt10mark' , 1 ,  array('p_mydt10mark' => $this->p_mydt10mark));
            pegasus_mysql_delete('mydt14' ,  'mydt14.remguc=:p_mydt10mark' , 1 ,  array('p_mydt10mark' => $this->p_mydt10mark));

            //  echo $ret_sql;
            //  die();
        }

        private function drop_tmp_to_DB(){
            pegasus_mysql_drop_table( $this->tmp_table_name_1 );
            pegasus_mysql_drop_table( $this->tmp_table_name_2 );
            //E: 10000857
            pegasus_mysql_drop_table( $this->tmp_table_name_3 );
            //E: 10001024
            pegasus_mysql_drop_table( $this->tmp_table_name_4 );
        }

        private function _read_sql($sql){
            $sql = peg_read_file($sql);
            
            $sql = str_replace( '{peg_dek}',  '2' , $sql);
            //$sql = str_replace( '{p_mydt10tbl0}',  $this->tmp_table_name_0 , $sql);
            $sql = str_replace( '{p_mydt10tbl1}',  $this->tmp_table_name_1 , $sql);
            $sql = str_replace( '{p_mydt10tbl2}',  $this->tmp_table_name_2 , $sql);
            //E: 10000857
            $sql = str_replace( '{p_mydt10tbl3}',  $this->tmp_table_name_3 , $sql);
             //E: 10001024
             $sql = str_replace( '{p_mydt10tbl4}',  $this->tmp_table_name_4 , $sql);

            //Αυτο πρεπει να το διορθωσουμε .... να διαβαζει την παραμετρο
            $sql = str_replace( '{nt_napost}'  ,  '1'  , $sql);
            $sql = str_replace( '{nt_nparal}'  ,  '1'  , $sql);

            $sql = str_replace( '\'{odbcdtos(nt_p01)}\''  ,  ':nt_p01'  , $sql);
            $sql = str_replace( '\'{odbcdtos(nt_p02)}\''  ,  ':nt_p02'  , $sql);
            $sql = str_replace( '{nt_p03}'                ,  ':nt_p03'  , $sql);
            $sql = str_replace( '{nt_p04}'                ,  ':nt_p04'  , $sql);
            $sql = str_replace( '\'{odbcdtos(nt_p07d)}\'' ,  ':nt_p07d' , $sql);
            $sql = str_replace( '\'{nt_p07t}\''           ,  ':nt_p07t' , $sql);
            $sql = str_replace( '\'{odbcdtos(nt_p08d)}\'' ,  ':nt_p08d' , $sql);
            $sql = str_replace( '\'{nt_p08t}\''           ,  ':nt_p08t' , $sql);
            $sql = str_replace( '\'{user_pswd}\''         ,  ':user_pswd' , $sql);

            // 14/06/2023 - Αλλαγή του replace με bound parameters γιατί τα single quotes στις παραμέτρους εσπαγαν το query.
            // 14/06/2023 - Τα parameter values ορίζονται στον constructor
            $sql = str_replace( '\'{nt_p101[1]}\'' ,  ':nt_p101_1' , $sql); // AFM
            $sql = str_replace( '\'{nt_p101[2]}\'' ,  ':nt_p101_2' , $sql); // EPONIMIA ONOMA ONOMA PATROS
            $sql = str_replace( '\'{nt_p101[3]}\'' ,  ':nt_p101_3' , $sql); // ODOS ARITHMOS
            $sql = str_replace( '\'{nt_p101[4]}\'' ,  ':nt_p101_4' , $sql); // Poli
            $sql = str_replace( '\'{nt_p101[5]}\'' ,  ':nt_p101_5' , $sql); // T.K.

            $sql = str_replace( '{nt_p101[6]}' ,  'f00', $sql);
            $sql = str_replace( '{nt_p101[7]}' ,  1    , $sql);

            // Τα χρησιμοποιεί στην τοπική για την εύρεση της υπογραφής, μπορούμε να τα έχουμε 0 όπως μου είπε ο ΔΘ.
            $sql = str_replace( '{nt_p010}' , 0 , $sql);
            $sql = str_replace( '{nt_p011}' , 0 , $sql);

            if(pegasus_mysql_table_exists('t19') && pegasus_module_exists('account00')){
                $sql = str_replace( '##start_table_exists_t19##',  '' , $sql);
                $sql = str_replace( '##end_table_exists_t19##'  ,  '' , $sql);
                $sql = str_replace( '##start_table_not_exists_t19##',  '/**' , $sql);
                $sql = str_replace( '##end_table_not_exists_t19##'  ,  '**/' , $sql);
            }else{
                $sql = str_replace( '##start_table_exists_t19##',  '/**' , $sql);
                $sql = str_replace( '##end_table_exists_t19##'  ,  '**/' , $sql);
                $sql = str_replace( '##start_table_not_exists_t19##',  '' , $sql);
                $sql = str_replace( '##end_table_not_exists_t19##'  ,  '' , $sql);
            }

            $sql = str_replace( '##store_in_sql##' ,  ':' . $this->store_in_sql , $sql); // T.K.

            if(pegasus_module_exists('stores') and !empty($this->store_in_sql)){
                $sql = str_replace( '##start_module_exist_stores##',  '' , $sql);
                $sql = str_replace( '##end_module_exist_stores##'  ,  '' , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_stores##',  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_stores##'  ,  '**/' , $sql);
            }

            if(pegasus_module_exists('tran')){
                $sql = str_replace( '##start_module_exist_tran##',  '' , $sql);
                $sql = str_replace( '##end_module_exist_tran##'  ,  '' , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_tran##',  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_tran##'  ,  '**/' , $sql);
            }

            if(pegasus_module_exists('invsupp')){
                $sql = str_replace( '##start_module_exist_invsupp##',  '' , $sql);
                $sql = str_replace( '##end_module_exist_invsupp##'  ,  '' , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_invsupp##',  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_invsupp##'  ,  '**/' , $sql);
            }

            if(pegasus_module_exists('receipts')){
                $sql = str_replace( '##start_module_exist_receipts##',  '' , $sql);
                $sql = str_replace( '##end_module_exist_receipts##'  ,  '' , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_receipts##',  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_receipts##'  ,  '**/' , $sql);
            }

            if(pegasus_module_exists('oil')){
                $sql = str_replace( '##start_module_exist_oil##',  '' , $sql);
                $sql = str_replace( '##end_module_exist_oil##'  ,  '' , $sql);
                $sql = str_replace( '##a55_cp_p600_from_oil##'  ,  "if(a55.p04 = '', oila04.p02, if(oila10.p02 = '', oila04.p02, oila10.p02))" , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_oil##',  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_oil##'  ,  '**/' , $sql);
                $sql = str_replace( '##a55_cp_p600_from_oil##'  ,  "''" , $sql);
            }

            if(!pegasus_module_exists('estiasi')){
                $sql = str_replace( "/**start_module_exists_estiasi**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_exists_estiasi**/"   , "**/" , $sql);
            }else{
                $sql = str_replace( "/**start_module_not_exists_estiasi**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_not_exists_estiasi**/"   , "**/" , $sql);
            }

            if(!pegasus_module_exists('account01')){
                $sql = str_replace( "/**start_module_exists_account01**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_exists_account01**/"   , "**/" , $sql);
            }else{
                $sql = str_replace( "/**start_module_not_exists_account01**/" , "/**" , $sql);
                $sql = str_replace( "/**end_module_not_exists_account01**/"   , "**/" , $sql);
            }
            return  $sql;
        }

        private function _isValid_tbl($tbl){

            if(strtolower($tbl) == 'a55'){
                return true;
            }

            if(strtolower($tbl) == 'a56'){
                return true;
            }

            if(strtolower($tbl) == 't08'){
                return true;
            }

            if(strtolower($tbl) == 'tran01'){
                return true;
            }

            if(strtolower($tbl) == 'a60'){
                return true;
            }
            
            if(strtolower($tbl) == 'tran09'){
                return true;
            }

            throw new Exception('Table ' .$tbl . ' isn\'t valid');
            
        }

        private function _isValid_tbl_nr01($tbl_nr01){

            if($tbl_nr01>=0 and $tbl_nr01<99999999999999 ){
                return true;
            }

            if($tbl_nr01=='-1'){
                return true;
            }

            throw new Exception('Table nr01' .$tbl_nr01 . ' isn\'t valid');
            
        }

        public static function get_eidiko_akirotiko_nr01($tbl , $tbl_nr01){
            $tbl_nr01_tosend ='';
            if($tbl=='a55'){
                pegasus_mysql_use("select * from a55 where nr01=:nr01" , $a55 , array('nr01'=>$tbl_nr01));
                //Αν ειναι ειδικό ακυρωτικό αλλαζει το nr01
                if(!empty($a55['p414'])){
                    pegasus_mysql_use("select * from a55 where p601a=:nr01" , $a55_00 , array('nr01'=>$tbl_nr01));
                    if($a55_00['nr01']>0){
                        $tbl_nr01_tosend = $a55_00['nr01'];
                    }
                }
            }

            if($tbl=='a56'){
                pegasus_mysql_use("select * from a56 where nr01=:nr01" , $a56 , array('nr01'=>$tbl_nr01));
                //Αν ειναι ειδικό ακυρωτικό αλλαζει το nr01
                if(!empty($a56['p414'])){
                    pegasus_mysql_use("select * from a56 where p601a=:nr01" , $a56_00 , array('nr01'=>$tbl_nr01));
                    if($a56_00['nr01']>0){
                        $tbl_nr01_tosend = $a56_00['nr01'];
                    }
                }
            }

            if($tbl=='tran01'){
                pegasus_mysql_use("select * from tran01 where nr01=:nr01" , $tran01 , array('nr01'=>$tbl_nr01));
                //Αν ειναι ειδικό ακυρωτικό αλλαζει το nr01
                if(!empty($tran01['p107'])){
                    pegasus_mysql_use("select * from tran01 where pa00=:nr01" , $tran01_00 , array('nr01'=>$tbl_nr01));

                    if($tran01_00['nr01']>0){
                        $tbl_nr01_tosend = $tran01_00['nr01'];
                    }
                }
            }

            if($tbl=='tran09'){
                pegasus_mysql_use("select * from tran09 where nr01=:nr01" , $tran09 , array('nr01'=>$tbl_nr01));
                //Αν ειναι ειδικό ακυρωτικό αλλαζει το nr01
                if(!empty($tran09['p102'])){
                    pegasus_mysql_use("select * from tran09 where p103=:nr01" , $tran09_00 , array('nr01'=>$tbl_nr01));
                    if($tran09_00['nr01']>0){
                        $tbl_nr01_tosend = $tran09_00['nr01'];
                    }
                }
            }

            return $tbl_nr01_tosend;
        }

        public static function check_is_akyromeno($tbl , $tbl_nr01){
            if($tbl=='a55'){
                pegasus_mysql_use("select * from a55 where nr01=:nr01" , $a55 , array('nr01'=>$tbl_nr01));
                if( $a55['p601a']>0 ){
                    return true;
                }
            }
            if($tbl=='a56'){
                pegasus_mysql_use("select * from a56 where nr01=:nr01" , $a56 , array('nr01'=>$tbl_nr01));
                if( $a56['p601a']>0 ){
                    return true;
                }
            }
            if($tbl=='tran01'){
                pegasus_mysql_use("select * from tran01 where nr01=:nr01" , $tran01 , array('nr01'=>$tbl_nr01));
                if( $tran01['pa00']>0 ){
                    return true;
                }
            }
            if($tbl=='tran09'){
                pegasus_mysql_use("select * from tran09 where nr01=:nr01" , $tran09 , array('nr01'=>$tbl_nr01));
                if( $tran09['p103']>0 ){
                    return true;
                }
            }
            return false;
        }

        public static function find_errors_descriptions($mydt10_p04){
            $array =  explode('#', $mydt10_p04);
            if(count($array)==0){
                return '';
            }

            $mydt98_nr01_st =  pegasus_mysql_create_in($array,  'mydt98_nr01_');
            
            $sql = '';
            $sql .= " select group_concat(mydt98.p01)  as ttt from mydt98 ";
            $sql .= " where mydt98.nr01 in ( ##mydt98_nr01s## )   ";
            $sql = str_replace( ' ##mydt98_nr01s##',  $mydt98_nr01_st['sql']  , $sql);

            pegasus_mysql_use($sql , $data, $mydt98_nr01_st['sqlParams']);
            return $data['ttt'];
        }

        static function get_is_cp_data($tbl='' , $tbl_nr01=0 ){
            $ret_arr = array();
            $ret_arr['issuer'] = array();
            $ret_arr['counterpart'] = array();

            if(empty($tbl) || empty($tbl_nr01)) {
                return $ret_arr;
            }
            $query = 'SELECT is_tbl, is_nr01, cp_tbl, cp_nr01 FROM mydt10 WHERE tbl = :tbl AND tbl_nr01 = :tbl_nr01';
            $queryParams = array('tbl' => $tbl, 'tbl_nr01' => $tbl_nr01);
            pegasus_mysql_use($query, $mydt10, $queryParams);

            if(empty($mydt10)) {
                return $ret_arr;
            }

            $f00_query = "SELECT 
                                concat( ifnull(concat(f00p203, ' '), ''),
                                        ifnull(concat(f00p2031, ' '), '') ) as company_name, /* Επώνυμια/Επώνυμο & Όνομα */
                                f00p204 as afm,    /* ΑΦΜ */
                                f00p207 as address,    /* Οδός */
                                f00p208 as address_num,    /* Αριθμός */
                                f00p206 as city,    /* Πόλη */
                                f00p209 as zip,    /* ΤΚ */
                                '' as doy,
                                '' as doy_code,
                                '' as phone_1,
                                '' as phone_2,
                                '' as email
                            FROM cor000
                            WHERE nr01 = :nr01;
                        ";
            $t05_query = "SELECT 
                                concat( ifnull(concat(p203, ' '), ''),
                                        ifnull(concat(p2031, ' '), '') ) as company_name, /* Επώνυμια/Επώνυμο & Όνομα */
                                p204 as afm,   /* ΑΦΜ */
                                p207 as address,   /* Οδός */
                                p208 as address_num,   /* Αριθμός */
                                p206 as city,   /* Πόλη */
                                p209 as zip,   /* ΤΚ */
                                '' as doy,
                                '' as doy_code,
                                '' as phone_1,
                                '' as phone_2,
                                '' as email
                            FROM t05
                            WHERE nr01 = :nr01;
                        ";
            $a00_query = "SELECT
                                a00.p19 as company_name,
                                a00.p20 as afm,
                                a00.p4 as address,
                                '' as address_num,
                                concat( ifnull(concat(d22.p02, ' '), ''), 
                                        ifnull(concat(a00.p5, ' '), ''),
                                        ifnull(concat(a00.p6, ' '), '') ) as city,
                                a00.p7 as zip,
                                a00.p22 as doy,
                                a00.pc22 as doy_code,
                                a00.p8 as phone_1,
                                a00.p9 as phone_2,
                                a00.p01 as email
                            FROM a00
                            LEFT JOIN d22 ON d22.p01=a00.p4_3
                            WHERE a00.nr01 = :nr01";
            $a01_query = "SELECT
                                a01.p19 as company_name,
                                a01.p20 as afm,
                                a01.p4 as address,
                                '' as address_num,
                                concat( ifnull(concat(d22.p02, ' '), ''), 
                                        ifnull(concat(a01.p5, ' '), ''),
                                        ifnull(concat(a01.p6, ' '), '') ) as city,
                                a01.p7 as zip,
                                a01.p22 as doy,
                                a01.pc22 as doy_code,
                                a01.p8 as phone_1,
                                a01.p9 as phone_2,
                                a01.p01 as email
                            FROM a01
                            LEFT JOIN d22 ON d22.p01=a01.p4_3
                            WHERE a01.nr01 = :nr01";
            $a71_query = "SELECT
                                a01.p19 as company_name,
                                a01.p20 as afm,
                                a71.p603 as address,
                                '' as address_num,
                                a71.p605 as city,
                                a71.p604 as zip,
                                a01.p22 as doy,
                                a01.pc22 as doy_code,
                                a71.p606 as phone_1,
                                a71.p607 as phone_2,
                                a71.p6011 as email
                            FROM a01
                            LEFT JOIN a71 ON a71.p601 = a01.nr01
                            WHERE a71.nr01 = :nr01";
            $a76_query = "SELECT
                                a00.p19 as company_name,
                                a00.p20 as afm,
                                a76.p604 as address,
                                '' as address_num,
                                a76.p605 as city,
                                a76.p604 as zip,
                                a00.p22 as doy,
                                a00.pc22 as doy_code,
                                a76.p606 as phone_1,
                                a76.p607 as phone_2,
                                a76.p6011 as email
                            FROM a00
                            LEFT JOIN a76 ON a76.p601=a00.nr01
                            WHERE a76.nr01 = :nr01";

            $t00_query = "SELECT
                                t00.p02 as company_name,
                                '' as afm,
                                t00.p102 as address,
                                '' as address_num,
                                t00.p103 as city,
                                '' as zip,
                                '' as doy,
                                '' as doy_code,
                                t00.p104 as phone_1,
                                '' as phone_2,
                                '' as email
                            FROM t00
                            WHERE t00.nr01 = :nr01";

            if(!empty($mydt10['is_tbl']) && !empty($mydt10['is_nr01'])) {
                $issuer_queryParams = array('nr01' => $mydt10['is_nr01']);
                if($mydt10['is_tbl'] == 'f00') {
                    $issuer_query = $f00_query;
                }
                if($mydt10['is_tbl'] == 't05') {
                    $issuer_query = $t05_query;
                }
                if($mydt10['is_tbl'] == 'a00') {
                    $issuer_query = $a00_query;
                }
                if($mydt10['is_tbl'] == 'a76') {
                    $issuer_query = $a76_query;
                }
                if($mydt10['is_tbl'] == 'a01') {
                    $issuer_query = $a01_query;
                }
                if($mydt10['is_tbl'] == 'a71') {
                    $issuer_query = $a71_query;
                }
                if($mydt10['is_tbl'] == 't00') {
                    $issuer_query = $t00_query;
                }
                if(!empty($issuer_query)) {
                    pegasus_mysql_use($issuer_query, $issuer, $issuer_queryParams);
                }
            }

            if(!empty($mydt10['cp_tbl']) && !empty($mydt10['cp_nr01'])) {
                $counterpart_queryParams = array('nr01' => $mydt10['cp_nr01']);
                if($mydt10['cp_tbl'] == 'f00') {
                    $counterpart_query = $f00_query;
                }
                if($mydt10['cp_tbl'] == 't05') {
                    $counterpart_query = $t05_query;
                }
                if($mydt10['cp_tbl'] == 'a00') {
                    $counterpart_query = $a00_query;
                }
                if($mydt10['cp_tbl'] == 'a76') {
                    $counterpart_query = $a76_query;
                }
                if($mydt10['cp_tbl'] == 'a01') {
                    $counterpart_query = $a01_query;
                }
                if($mydt10['cp_tbl'] == 'a71') {
                    $counterpart_query = $a71_query;
                }
                if($mydt10['cp_tbl'] == 't00') {
                    $counterpart_query = $t00_query;
                }

                if(!empty($counterpart_query)) {
                    pegasus_mysql_use($counterpart_query, $counterpart, $counterpart_queryParams);
                }
            }

            $ret_arr['issuer'] = $issuer;
            $ret_arr['counterpart'] = $counterpart;

            return $ret_arr;
        }


        public function set_mydt00_p105($value){
            $this->mydt00_p105 = $value;
        }

        private function get_mydt00_p105(){
            return $this->mydt00_p105;
        }
    }
?>