<?php

    /**
     * $mydt01_nr01=-1 =  all  , =null  is null , ='12312' is mydt01.nr01
     */
    class mydt_xml{

        private $_taxesTotalsArray = array();

        public function invoicesDoc_create_xml( $mydt10_nr01_array = '' , $mydt01_nr01 = -2 , $correlated=0){



            $mydt10_totals = array();
            $mydt10_nr01s = array();
            $mydt10_data00 = $this->_invoicesDoc_mydt10_data( $mydt10_nr01_array , $mydt01_nr01, $correlated);


            $xw = new XMLWriter();
            $xw->openMemory();
            $xw->startDocument("1.0" , "utf-8");
            $xw->startElement("InvoicesDoc");
                
            $xw->startAttribute('xmlns');
            $xw->text('http://www.aade.gr/myDATA/invoice/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xsi:schemaLocation');
            //$xw->text('http://www.aade.gr/myDATA/invoice/v1.0 schema.xsd');
            // $xw->text('http://www.aade.gr/myDATA/invoice/v1.0/InvoicesDoc-v0.6.xsd');
            $xw->text('http://www.aade.gr/myDATA/invoice/v1.0');

            $xw->endAttribute();

            $xw->startAttribute('xmlns:icls');
            $xw->text('https://www.aade.gr/myDATA/incomeClassificaton/v1.0');
            $xw->endAttribute();
                    
            $xw->startAttribute('xmlns:ecls');
            $xw->text('https://www.aade.gr/myDATA/expensesClassificaton/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xmlns:xsi');
            $xw->text('http://www.w3.org/2001/XMLSchema-instance');
            $xw->endAttribute();

            foreach ($mydt10_data00 as $mydt10_data) {

                    
                        if($correlated==1 ){
                            $correlinv=$this->_checkCorrelated($mydt10_data['nr01']);
                            if($correlinv===false){    
                                continue;
                            }
                            $mydt10_data['correlatedInvoices']=$correlinv;
                        }


                        array_push( $mydt10_nr01s , $mydt10_data['nr01']);
                        $mydt10_totals = array();
                        $xw->startElement("invoice");
    
                            //uid
                            if(!empty($mydt10_data['uid'])){
                                $xw->startElement("uid");
                                $xw->text($mydt10_data['uid']);
                                $xw->endElement();
                            }
    
                            //mark
                            if(!empty($mydt10_data['mark'])){
                                $xw->startElement("mark");
                                $xw->text($mydt10_data['mark']);
                                $xw->endElement();
                            }

                            //transmission failure
                            if(!empty($mydt10_data['transmissionFailure'])){
                                $xw->startElement("transmissionFailure");
                                $xw->text($mydt10_data['transmissionFailure']);
                                $xw->endElement();
                            }
    
                            //Start Issuer
                            if($mydt10_data['mydt50_p101']!=1){
                                $xw->startElement("issuer");
    
                                $xw->startElement("vatNumber");
                                $xw->text($mydt10_data['is_vatNumber']);
                                $xw->endElement();
    
                                $xw->startElement("country");
                                $xw->text($mydt10_data['is_country']);
                                $xw->endElement();
    
                                $xw->startElement("branch");
                                $xw->text($mydt10_data['is_branch']);
                                $xw->endElement();

                                if(   ($mydt10_data['is_country'] != '' && $mydt10_data['is_country'] != 'GR') 
                                    || $mydt10_data['isDeliveryNote'] != 0 
                                    || $mydt10_data['mydt50_p107'] != 0
                                ) {
                                    $xw->startElement("name");
                                    $xw->text($mydt10_data['is_name']);
                                    $xw->endElement();
                                }
    
                                // if(!empty($mydt10_data['is_name'])){
                                //     $xw->startElement("name");
                                //     $xw->text($mydt10_data['is_name']);
                                //     $xw->endElement();
                                // }
    
                                if(    $mydt10_data['is_country']!='GR'
                                    || $mydt10_data['isDeliveryNote'] != 0 
                                    || $mydt10_data['mydt50_p107'] != 0
                                    
                                ){
                                    $xw->startElement("address");
    
                                        $xw->startElement("street");
                                        $xw->text($mydt10_data['is_address']);
                                        $xw->endElement();
    
                                        $xw->startElement("number");
                                        $xw->text("0");
                                        $xw->endElement();
    
                                        $xw->startElement("postalCode");
                                        $xw->text($mydt10_data['is_zip']);
                                        $xw->endElement();
    
                                        $xw->startElement("city");
                                        $xw->text($mydt10_data['is_city']);
                                        $xw->endElement();
    
                                    $xw->endElement();
                                }
    
    
                                $xw->endElement();
                            }
                            //End Issuer
                
                            //Start counterpart
                            // 18/01/2024 - Αν έχω deliveryNote, o counterpart ειναι απαραίτητος και στις Λιανικές
                            if($mydt10_data['mydt50_p102']!=1 || $mydt10_data['isDeliveryNote'] != 0){
                                $xw->startElement("counterpart");
    
                                    $xw->startElement("vatNumber");
                                    $xw->text($mydt10_data['cp_vatNumber']);
                                    $xw->endElement();
    
                                    $xw->startElement("country");
                                    $xw->text($mydt10_data['cp_country']);
                                    $xw->endElement();
    
                                    $xw->startElement("branch");
                                    $xw->text($mydt10_data['cp_branch']);
                                    $xw->endElement();
    
                                    if(   ($mydt10_data['cp_country'] != '' && $mydt10_data['cp_country'] != 'GR') 
                                        || $mydt10_data['isDeliveryNote'] != 0 
                                        || $mydt10_data['mydt50_p107'] != 0
                                    ) {
                                        $xw->startElement("name");
                                        $xw->text($mydt10_data['cp_name']);
                                        $xw->endElement();
                                    }
    
                                    //if($mydt10_data['cp_country']!='GR'){
                                        $xw->startElement("address");
    
                                            $xw->startElement("street");
                                            $xw->text($mydt10_data['cp_address']);
                                            $xw->endElement();
    
                                            $xw->startElement("number");
                                            $xw->text("0");
                                            $xw->endElement();
    
                                            $xw->startElement("postalCode");
                                            $xw->text($mydt10_data['cp_zip']);
                                            $xw->endElement();
    
                                            $xw->startElement("city");
                                            $xw->text($mydt10_data['cp_city']);
                                            $xw->endElement();
    
                                        $xw->endElement();
                                    //
    
                                $xw->endElement();
                            }
                            //End counterpart
    
    
                            //Start invoiceHeader
                            $xw->startElement("invoiceHeader");
    
                                $xw->startElement("series");
                                $xw->text($mydt10_data['series']);
                                $xw->endElement();
    
                                $xw->startElement("aa");
                                $xw->text($mydt10_data['aa']);
                                $xw->endElement();
    
                                $xw->startElement("issueDate");
                                $xw->text($mydt10_data['issueDate']);
                                $xw->endElement();

                                $xw->startElement("invoiceType");
                                $xw->text($mydt10_data['invoiceType']);
                                $xw->endElement();
                                

                                if($mydt10_data['vatPaymentSuspension']==1){
                                    $xw->startElement("vatPaymentSuspension");
                                    $xw->text($mydt10_data['vatPaymentSuspension']);
                                    $xw->endElement();
                                }

                                if($mydt10_data['mydt50_p107']!=1){
                                    $xw->startElement("currency");
                                    $xw->text($mydt10_data['currency']);
                                    $xw->endElement();
                                }
    
                                if(!empty($mydt10_data['exchangeRate'])){
                                    $xw->startElement("exchangeRate");
                                    $xw->text($mydt10_data['exchangeRate']);
                                    $xw->endElement();
                                }                   
                                  
                                if(!empty($mydt10_data['correlatedInvoices']) && $mydt10_data['mydt50_p103']!=1){
                                    
                                    foreach(explode(',' , $mydt10_data['correlatedInvoices']) as $cor){  /* web v1.00 r015 */
                                        $xw->startElement("correlatedInvoices");
                                        $xw->text($cor);
                                        $xw->endElement();
                                    }
                                }
    
                                if($mydt10_data['selfPricing']==1){
                                    $xw->startElement("selfPricing");
                                    $xw->text($mydt10_data['selfPricing']);
                                    $xw->endElement();
                                }

                                // Όχι Στοιχεία Αποστολής part 1
                                if($mydt10_data['mydt50_p106']!=1){
                                    if(!peg_dateIsEmpty($mydt10_data['dispatchDate'])){
                                        $xw->startElement("dispatchDate");
                                        $xw->text($mydt10_data['dispatchDate']);
                                        $xw->endElement();    
                                    }
                                    
                                    if(!empty($mydt10_data['dispatchTime'])){
                                        $xw->startElement("dispatchTime");
                                        $xw->text($mydt10_data['dispatchTime']);
                                        $xw->endElement();
                                    }
        
                                    if(!empty($mydt10_data['vehicleNumber'])){
                                        $xw->startElement("vehicleNumber");
                                        $xw->text($mydt10_data['vehicleNumber']);
                                        $xw->endElement();
                                    }
        
                                    if(!empty($mydt10_data['movePurpose'])){
                                        $xw->startElement("movePurpose");
                                        $xw->text($mydt10_data['movePurpose']);
                                        $xw->endElement();
                                    }
                                }

                                if(!empty($mydt10_data['specialInvoiceCategory'])) {
                                    $xw->startElement("specialInvoiceCategory");
                                    $xw->text($mydt10_data['specialInvoiceCategory']);
                                    $xw->endElement();
                                }
                                
                                if(!empty($mydt10_data['invoiceVariationType'])) {
                                    $xw->startElement("invoiceVariationType");
                                    $xw->text($mydt10_data['invoiceVariationType']);
                                    $xw->endElement();
                                }
                                // Όχι Στοιχεία Αποστολής part 2
                                if($mydt10_data['mydt50_p106']!=1){
                                    if(!empty($mydt10_data['isDeliveryNote']) || $mydt10_data['mydt50_p107'] == 1) {
                                        $xw->startElement("otherDeliveryNoteHeader");
                                            $xw->startElement("loadingAddress");
                                                $xw->startElement("street");
                                                $xw->text($mydt10_data['ldstreet']);
                                                $xw->endElement();

                                                $xw->startElement("number");
                                                $xw->text($mydt10_data['ldnumber']);
                                                $xw->endElement();

                                                $xw->startElement("postalCode");
                                                $xw->text($mydt10_data['ldzip']);
                                                $xw->endElement();

                                                $xw->startElement("city");
                                                $xw->text($mydt10_data['ldcity']);
                                                $xw->endElement();
                                            $xw->endElement();
                                            
                                            $xw->startElement("deliveryAddress");
                                                $xw->startElement("street");
                                                $xw->text($mydt10_data['dlvstreet']);
                                                $xw->endElement();

                                                $xw->startElement("number");
                                                $xw->text($mydt10_data['dlvnumber']);
                                                $xw->endElement();

                                                $xw->startElement("postalCode");
                                                $xw->text($mydt10_data['dlvzip']);
                                                $xw->endElement();

                                                $xw->startElement("city");
                                                $xw->text($mydt10_data['dlvcity']);
                                                $xw->endElement();
                                            $xw->endElement();

                                            if(!empty($mydt10_data['startShippingBranch'])) {
                                                $xw->startElement("startShippingBranch");
                                                $xw->text($mydt10_data['startShippingBranch']);
                                                $xw->endElement();
                                            }

                                            if(!empty($mydt10_data['completeShippingBranch'])) {
                                                $xw->startElement("completeShippingBranch");
                                                $xw->text($mydt10_data['completeShippingBranch']);
                                                $xw->endElement();
                                            }
                                        $xw->endElement();
                                    }
                                    if(!empty($mydt10_data['isDeliveryNote'])) {
                                        $xw->startElement("isDeliveryNote");
                                        $xw->text($mydt10_data['isDeliveryNote']);
                                        $xw->endElement();
                                    }

                                    if(!empty($mydt10_data['otherMovePurposeTitle'])){
                                        $xw->startElement("otherMovePurposeTitle");
                                        $xw->text($mydt10_data['otherMovePurposeTitle']);
                                        $xw->endElement();
                                    }   
                                }
                            if(!empty($mydt10_data['thirdPartyCollection'])) {
                                $xw->startElement("thirdPartyCollection");
                                $xw->text($mydt10_data['thirdPartyCollection']);
                                $xw->endElement();
                            }
    
                            $xw->endElement();
                            //End invoiceHeader 

                            //Start paymentMethods
                            if($mydt10_data['mydt50_p107']!=1){

                                $mydt13_data_arr = $this->_invoicesDoc_mydt13_data($mydt10_data['nr01']);
                                //print_r($mydt13_data_arr);
                                // die();
                                if($mydt10_data['mydt50_p104'] != 1) {
                                    // Αν έχουμε εγγραφές στον mydt13
                                    if(!empty( $mydt13_data_arr)) {
                                        $xw->startElement("paymentMethods");
                                        foreach($mydt13_data_arr as $mydt13) {
                                            $xw->startElement("paymentMethodDetails");
                                                $xw->startElement("type");
                                                $xw->text($mydt13['type']);
                                                $xw->endElement();
                                                $xw->startElement("amount");
                                                $xw->text($mydt13['amount']);
                                                $xw->endElement();
                                                //
                                            $xw->endElement();
                                        }
                                        $xw->endElement();
                                    } else {
                                        // Αν ~ΔΕΝ~ έχουμε εγγραφές στον mydt13
                                        if(!empty($mydt10_data['payType'])){
                                            $xw->startElement("paymentMethods");
                                                $xw->startElement("paymentMethodDetails");
                                                    $xw->startElement("type");
                                                    $xw->text($mydt10_data['payType']);
                                                    $xw->endElement();

                                                    $xw->startElement("amount");
                                                    $xw->text(abs($mydt10_data['totalGrossValue']));
                                                    $xw->endElement();
                                                $xw->endElement();
                                            $xw->endElement();
                                        }
                                    }
                                }
                                //End paymentMethods
                            }
    
                            $mydt12_data_arr = $this->_invoicesDoc_mydt12_data($mydt10_data['nr01']);

                            $this->_taxesTotalsArray = array();
                            $sum_tot_array = array(
                                'totalNetValue'         => 0,
                                'totalVatAmount'        => 0,
                                'totalWithheldAmount'   => 0,
                                'totalFeesAmount'       => 0,
                                'totalStampDutyAmount'  => 0,
                                'totalOtherTaxesAmount' => 0,
                                'totalDeductionsAmount' => 0
                            );
                            foreach($mydt12_data_arr as $mydt12_data){
                                    

                                    // Αν το πάραστατικό ειναι Διακινησης π.χ. 9.3 και εχει τιμες τις βγαζω για να ενημερωσω το myDATA χωρις
                                    if($mydt10_data['mydt50_p107']==1){
                                        $mydt12_data['netValue'] = 0;
                                        $mydt12_data['vatAmount'] = 0;
                                        $mydt12_data['withheldAmount'] = 0;
                                        $mydt12_data['feesAmount'] = 0;
                                        $mydt12_data['stampDutyAmount'] = 0;
                                        $mydt12_data['otherTaxesAmount'] = 0;
                                        $mydt12_data['deductionsAmount'] = 0;         
                                        $mydt12_data['vatCategory']   = 8;
                                        $mydt12_data['class_amount'] = 0;
                                    }

                                    $sum_tot_array['totalNetValue']          += round($mydt12_data['netValue'], 2);
                                    $sum_tot_array['totalVatAmount']         += round($mydt12_data['vatAmount'], 2);
                                    $sum_tot_array['totalWithheldAmount']    += round($mydt12_data['withheldAmount'], 2);
                                    $sum_tot_array['totalFeesAmount']        += round($mydt12_data['feesAmount'], 2);
                                    $sum_tot_array['totalStampDutyAmount']   += round($mydt12_data['stampDutyAmount'], 2);
                                    $sum_tot_array['totalOtherTaxesAmount']  += round($mydt12_data['otherTaxesAmount'], 2);
                                    $sum_tot_array['totalDeductionsAmount']  += round($mydt12_data['deductionsAmount'], 2);
                                

                                    if(!empty($mydt12_data['taxtype'])){
                                        array_push($this->_taxesTotalsArray , array(
                                            "taxtype"   => $mydt12_data['taxtype']   , 
                                            "taxcat"    => $mydt12_data['taxcat']    ,  
                                            "taxamount" => $mydt12_data['taxamount'] , 
                                            "taxunder"  => $mydt12_data['taxunder'] 
                                        ));
                                        continue;
                                    }
                                        
                                    //Start invoiceDetails
                                    $xw->startElement("invoiceDetails");
    
                                        $xw->startElement("lineNumber");
                                        $xw->text($mydt12_data['lineNumber']);
                                        $xw->endElement();

                                        if($mydt12_data['rectype']>0){
                                            $xw->startElement("recType");
                                            $xw->text( $mydt12_data['rectype'] );
                                            $xw->endElement();
                                        }

                                        //σημείωση: itemcode πάει εδώ

                                        if(!empty($mydt10_data['isDeliveryNote']) || $mydt10_data['mydt50_p107'] == 1 || $mydt10_data['mydt50_p111'] == 1) {
                                            $xw->startElement("itemCode");
                                            $xw->text($mydt12_data['itemCode']);
                                            $xw->endElement();


                                            $xw->startElement("itemDescr");
                                            $xw->text($mydt12_data['itemDescr']);
                                            $xw->endElement();
                                        }
        
                                        // p105 = Όχι Ποσότητα/ΜΜ
                                        if($mydt10_data['mydt50_p105']!=1){
                                            if($mydt12_data['quantity']>0){
                                                $xw->startElement("quantity");
                                                $xw->text( $mydt12_data['quantity'] );
                                                $xw->endElement();
                                            }
            
                                            if(!empty($mydt12_data['measurementUnit'])){
                                                $xw->startElement("measurementUnit");
                                                $xw->text($mydt12_data['measurementUnit']);
                                                $xw->endElement();
                                            }
                                        }
                                        
                                        if(!empty($mydt12_data['invoiceDetailType'])){
                                            $xw->startElement("invoiceDetailType");
                                            $xw->text($mydt12_data['invoiceDetailType']);
                                            $xw->endElement();
                                        }
        
                                        if($mydt12_data['netValue']>=0){
                                            $xw->startElement("netValue");
                                            $xw->text(round($mydt12_data['netValue'] , 5));
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['vatCategory'])){
                                            $xw->startElement("vatCategory");
                                            $xw->text($mydt12_data['vatCategory']);
                                            $xw->endElement();
                                        }
        
                                        $xw->startElement("vatAmount");
                                        $xw->text(round($mydt12_data['vatAmount'] , 5));
                                        $xw->endElement();
        
                                        if(!empty($mydt12_data['vatExemptionCategory'])){
                                            $xw->startElement("vatExemptionCategory");
                                            $xw->text($mydt12_data['vatExemptionCategory']);
                                            $xw->endElement();
                                        }              
                                        
                                        if($mydt12_data['discountOption']==1){
                                            $xw->startElement("discountOption");
                                            $xw->text($mydt12_data['discountOption']==1? true : false);
                                            $xw->endElement();
                                        }              
        
                                        if($mydt12_data['withheldAmount']>0){
                                            $xw->startElement("withheldAmount");
                                            $xw->text(round($mydt12_data['withheldAmount'] , 5));
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['withheldPercentCategory'])){
                                            $xw->startElement("withheldPercentCategory");
                                            $xw->text($mydt12_data['withheldPercentCategory']);
                                            $xw->endElement();
                                        }

                                        if($mydt12_data['stampDutyAmount']>0){
                                            $xw->startElement("stampDutyAmount");
                                            $xw->text($mydt12_data['stampDutyAmount']);
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['stampDutyPercentCategory'])){
                                            $xw->startElement("stampDutyPercentCategory");
                                            $xw->text($mydt12_data['stampDutyPercentCategory']);
                                            $xw->endElement();
                                        }
        
                                        if($mydt12_data['feesAmount']>0){
                                            $xw->startElement("feesAmount");
                                            $xw->text(round($mydt12_data['feesAmount'] , 5));
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['feesPercentCategory'])){
                                            $xw->startElement("feesPercentCategory");
                                            $xw->text($mydt12_data['feesPercentCategory']);
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['otherTaxesPercentCategory'])){
                                            $xw->startElement("otherTaxesPercentCategory");
                                            $xw->text($mydt12_data['otherTaxesPercentCategory']);
                                            $xw->endElement();
                                        }
        
                                        if($mydt12_data['otherTaxesAmount']>0){
                                            $xw->startElement("otherTaxesAmount");
                                            $xw->text($mydt12_data['otherTaxesAmount']);
                                            $xw->endElement();
                                        }
        
                                        if($mydt12_data['deductionsAmount']>0){
                                            $xw->startElement("deductionsAmount");
                                            $xw->text($mydt12_data['deductionsAmount']);
                                            $xw->endElement();
                                        }
        
                                        if(!empty($mydt12_data['lineComments'])){
                                            $xw->startElement("lineComments");
                                            $xw->text($mydt12_data['lineComments']);
                                            $xw->endElement();
                                        }        
        
                                        if ($mydt12_data['rectype'] != 2 && $mydt12_data['rectype'] != 3) {
                                            if($mydt12_data['mydt10_p00']==1){
                                              
                                                    $xw->startElement("incomeClassification");
                                                
                                                    if (!empty($mydt12_data['classificationType'])) {
                                                        $xw->startElement("icls:classificationType");
                                                        $xw->text($mydt12_data['classificationType']);
                                                        $xw->endElement();
                                                    }
                                                
                                                    if (!empty($mydt12_data['classificationCategory'])) {
                                                        $xw->startElement("icls:classificationCategory");
                                                        $xw->text($mydt12_data['classificationCategory']);
                                                        $xw->endElement();
                                                    }
                                                
                                                    //if(!empty($mydt12_data['class_amount'])){
                                                    $xw->startElement("icls:amount");
                                                    $xw->text($mydt12_data['class_amount']);
                                                    $xw->endElement();
                                                    //}
                                                    
                                                    $xw->startElement("icls:id");
                                                    $xw->text("1");
                                                    $xw->endElement();
                                                    
                                                    $xw->endElement();
                                               
                                            }else{
                                                $xw->startElement("expensesClassification");
                                            
                                                    if(!empty($mydt12_data['classificationType'])){
                                                        $xw->startElement("ecls:classificationType");
                                                        $xw->text($mydt12_data['classificationType']);
                                                        $xw->endElement();
                                                    }
                                                    
                                                    if(!empty($mydt12_data['classificationCategory'])){
                                                        $xw->startElement("ecls:classificationCategory");
                                                        $xw->text($mydt12_data['classificationCategory']);
                                                        $xw->endElement();
                                                    }
            
                                                    //if(!empty($mydt12_data['class_amount'])){
                                                        $xw->startElement("ecls:amount");
                                                        $xw->text($mydt12_data['class_amount']);
                                                        $xw->endElement();
                                                    //}
            
                                                    $xw->startElement("ecls:id");
                                                    $xw->text("2");
                                                    $xw->endElement();
                                                
                                                $xw->endElement();                                    
                                            }
        
                                            //classificationType
                                            $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['classificationType'] . '_'  . $mydt12_data['classificationCategory']]['classificationCategory'] = $mydt12_data['classificationCategory'];
                                            $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['classificationType'] . '_'  . $mydt12_data['classificationCategory']]['classificationType']     = $mydt12_data['classificationType'];
                                            $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['classificationType'] . '_'  . $mydt12_data['classificationCategory']]['mydt10_p00']             = $mydt12_data['mydt10_p00'];
                                            $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['classificationType'] . '_'  . $mydt12_data['classificationCategory']]['amount']                += $mydt12_data['class_amount'];
                                         
                                            //vclasification
                                            if(!empty($mydt12_data['vclassificationType'] /*and $mydt10_data['invoiceType']!='8.2'*/  )){
                                                if($mydt12_data['mydt10_p00']==1){
                                               
                                                    $xw->startElement("incomeClassification");

                                                    if (!empty($mydt12_data['vclassificationType'])) {
                                                        $xw->startElement("icls:classificationType");
                                                        $xw->text($mydt12_data['vclassificationType']);
                                                        $xw->endElement();
                                                    }

                                                    if (!empty($mydt12_data['classificationCategory'])) {
                                                        $xw->startElement("icls:classificationCategory");
                                                        $xw->text($mydt12_data['classificationCategory']);
                                                        $xw->endElement();
                                                    }

                                                    //if(!empty($mydt12_data['class_amount'])){
                                                    $xw->startElement("icls:amount");
                                                    $xw->text($mydt12_data['class_amount']);
                                                    $xw->endElement();
                                                    //}

                                                    $xw->startElement("icls:id");
                                                    $xw->text("1");
                                                    $xw->endElement();

                                                    $xw->endElement();
                                               
            
                                                }else{
                                                    $xw->startElement("expensesClassification");
                                                
                                                        if(!empty($mydt12_data['vclassificationType'])){
                                                            $xw->startElement("ecls:classificationType");
                                                            $xw->text($mydt12_data['vclassificationType']);
                                                            $xw->endElement();
                                                        }
                                                        
                                                        if(!empty($mydt12_data['classificationCategory'])){
                                                            $xw->startElement("ecls:classificationCategory");
                                                            $xw->text($mydt12_data['classificationCategory']);
                                                            $xw->endElement();
                                                        }
                
                                                        // if(!empty($mydt12_data['class_amount'])){
                                                            $xw->startElement("ecls:amount");
                                                            $xw->text($mydt12_data['class_amount']);
                                                            $xw->endElement();
                                                        //}
                
                                                        $xw->startElement("ecls:id");
                                                        $xw->text("2");
                                                        $xw->endElement();
                                                    
                                                    $xw->endElement();                                    
                                                }
                                                if ($mydt12_data['rectype'] != 2 && $mydt12_data['rectype'] != 3) {
                                                    //vclassificationType
                                                    $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['vclassificationType'] . '_'  . $mydt12_data['classificationCategory']]['classificationCategory'] = $mydt12_data['classificationCategory'];
                                                    $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['vclassificationType'] . '_'  . $mydt12_data['classificationCategory']]['classificationType']     = $mydt12_data['vclassificationType'];
                                                    $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['vclassificationType'] . '_'  . $mydt12_data['classificationCategory']]['mydt10_p00']             = $mydt12_data['mydt10_p00'];
                                                    $mydt10_totals[$mydt12_data['mydt10_p00'] . '_' . $mydt12_data['vclassificationType'] . '_'  . $mydt12_data['classificationCategory']]['amount']                += $mydt12_data['class_amount'];
                                                }
                                            }    
                                        }                                

                                        if(!empty($mydt12_data['omunit'])){
                                            $xw->startElement("otherMeasurementUnitQuantity");
                                            $xw->text($mydt12_data['omunit']);
                                            $xw->endElement();
                                        }

                                        if(!empty($mydt12_data['omuntl'])){
                                            $xw->startElement("otherMeasurementUnitTitle");
                                            $xw->text($mydt12_data['omuntl']);
                                            $xw->endElement();
                                        }

                                        if(!empty($mydt12_data['notVAT195'])){
                                            $xw->startElement("notVAT195");
                                            $xw->text($mydt12_data['notVAT195']==1? true : false);
                                            $xw->endElement();
                                        }
                                    $xw->endElement();
                                    //End invoiceDetails
                            }
 

                            if( count($this->_taxesTotalsArray)>0 ){
                                $xw->startElement("taxesTotals");

                                foreach($this->_taxesTotalsArray as $_taxesTotalsArray){
                                    $xw->startElement("taxes");

                                        $xw->startElement("taxType");
                                        $xw->text($_taxesTotalsArray['taxtype']);
                                        $xw->endElement();

                                        if(!empty($_taxesTotalsArray['taxcat'])){
                                            $xw->startElement("taxCategory");
                                            $xw->text($_taxesTotalsArray['taxcat']);
                                            $xw->endElement();
                                        }
                                        if($_taxesTotalsArray['taxunder'] > 0){
                                            $xw->startElement("underlyingValue");
                                            $xw->text($_taxesTotalsArray['taxunder']);
                                            $xw->endElement();    
                                        }

                                        $xw->startElement("taxAmount");
                                        $xw->text($_taxesTotalsArray['taxamount']);
                                        $xw->endElement();


                                    $xw->endElement();
        
                                }

                                $xw->endElement();
                            }

                            $sum_tot_array['totalGrossValue'] = 
                                round($sum_tot_array['totalNetValue'] +
                                      $sum_tot_array['totalVatAmount'] -
                                      $sum_tot_array['totalWithheldAmount'] +
                                      $sum_tot_array['totalFeesAmount'] +
                                      $sum_tot_array['totalStampDutyAmount'] +
                                      $sum_tot_array['totalOtherTaxesAmount'] -
                                      $sum_tot_array['totalDeductionsAmount'], 
                                2)
                            ;
                            //Start invoiceSummary
                            $xw->startElement("invoiceSummary");
    
                                $xw->startElement("totalNetValue");
                                // $xw->text($mydt10_data['totalNetValue']);
                                $xw->text($sum_tot_array['totalNetValue']);
                                $xw->endElement();
    
                                $xw->startElement("totalVatAmount");
                                // $xw->text($mydt10_data['totalVatAmount']);
                                $xw->text($sum_tot_array['totalVatAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalWithheldAmount");
                                // $xw->text($mydt10_data['totalWithheldAmount']);
                                $xw->text($sum_tot_array['totalWithheldAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalFeesAmount");
                                // $xw->text($mydt10_data['totalFeesAmount']);
                                $xw->text($sum_tot_array['totalFeesAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalStampDutyAmount");
                                // $xw->text($mydt10_data['totalStampDutyAmount']);
                                $xw->text($sum_tot_array['totalStampDutyAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalOtherTaxesAmount");
                                // $xw->text($mydt10_data['totalOtherTaxesAmount']);
                                $xw->text($sum_tot_array['totalOtherTaxesAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalDeductionsAmount");
                                // $xw->text($mydt10_data['totalDeductionsAmount']);
                                $xw->text($sum_tot_array['totalDeductionsAmount']);
                                $xw->endElement();
    
                                $xw->startElement("totalGrossValue");
                                // $xw->text($mydt10_data['totalGrossValue']);
                                $xw->text($sum_tot_array['totalGrossValue']);
                                $xw->endElement();
    
                                // Θέλει πρώτα τα incomeClassifications και μετα τα expense στα totals -- Validation Error
                                // Ta income ξεκινουν από 1_ γιαυτό δουλέυει η asort()
                                asort($mydt10_totals);
 
                                foreach ($mydt10_totals as $mydt10_total) {
    
                                    if($mydt10_total['mydt10_p00']==1){
                                        $xw->startElement("incomeClassification");
                                    
                                            if(!empty($mydt10_total['classificationType'])){
                                                $xw->startElement("icls:classificationType");
                                                $xw->text($mydt10_total['classificationType']);
                                                $xw->endElement();
                                            }
                                            
                                            if(!empty($mydt10_total['classificationCategory'])){
                                                $xw->startElement("icls:classificationCategory");
                                                $xw->text($mydt10_total['classificationCategory']);
                                                $xw->endElement();
                                            }
    
                                            //if(!empty($mydt10_total['amount'])){
                                                $xw->startElement("icls:amount");
                                                $xw->text($mydt10_total['amount']);
                                                $xw->endElement();
                                            //}
    
                                            $xw->startElement("icls:id");
                                            $xw->text("1");
                                            $xw->endElement();
    
                                        $xw->endElement();
    
                                    }else{
                                        $xw->startElement("expensesClassification");
                                    
                                            if(!empty($mydt10_total['classificationType'])){
                                                $xw->startElement("ecls:classificationType");
                                                $xw->text($mydt10_total['classificationType']);
                                                $xw->endElement();
                                            }
                                            
                                            if(!empty($mydt10_total['classificationCategory'])){
                                                $xw->startElement("ecls:classificationCategory");
                                                $xw->text($mydt10_total['classificationCategory']);
                                                $xw->endElement();
                                            }
    
                                            //if(!empty($mydt10_total['amount'])){
                                                $xw->startElement("ecls:amount");
                                                $xw->text($mydt10_total['amount']);
                                                $xw->endElement();
                                            //}
    
                                            $xw->startElement("ecls:id");
                                            $xw->text("2");
                                            $xw->endElement();
                                        
                                        $xw->endElement();                                    
                                    }
    
                                }
                            $xw->endElement();
                            //End invoiceSummary
                        $xw->endElement();
            }

            $xw->endElement();
            $xw->endDocument();
            return array('xml' => $xw->outputMemory() , 'nr01_array' => $mydt10_nr01s ) ; 

        }

        public function expensesClassificationsDoc_create_xml($data , $postPerInvoice=false){
            
            if(empty($data[0]['mark'])){
                return '';
            }

            $np_idcoun = 1;

            $xw = new XMLWriter();
            $xw->openMemory();
            $xw->startDocument("1.0" , "utf-8");
            $xw->startElement("ExpensesClassificationsDoc");
                
            $xw->startAttribute('xmlns:xs');
            $xw->text('http://www.w3.org/2001/XMLSchema');
            $xw->endAttribute();

            $xw->startAttribute('xmlns:ecls');
            $xw->text('https://www.aade.gr/myDATA/expensesClassificaton/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xmlns:inv');
            $xw->text('http://www.aade.gr/myDATA/invoice/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xmlns');
            $xw->text('https://www.aade.gr/myDATA/expensesClassificaton/v1.0');
            $xw->endAttribute();


                $mark='';
                $nr01_array=array();
                foreach ($data as $data00){
                    

                    if($data00['mark'] != $mark){
                        if(!empty($mark)){
                            $xw->endElement();
                        }

                        $xw->startElement("expensesInvoiceClassification");
                        $mark = $data00['mark'];
                        array_push($nr01_array , $data00['nr01']);
                        $xw->startElement("invoiceMark");
                        $xw->text($mark);
                        $xw->endElement();    

                        if(!empty($data00['entityVatNumber'])){
                            $xw->startElement("entityVatNumber");
                            $xw->text($data00['entityVatNumber']);
                            $xw->endElement();  
                        }
                        
                    }

                    $amount = $postPerInvoice? $data00['amount_post_per_invoice'] : $data00['amount'];
                    $fpavalue=0;
                    if($data00['classificationCategory'] == "category2_5"){
                        $amount = $data00['amount'] + $data00['fpavalue'];
                    }

                    if(!($amount>0)){
                        continue;
                    }

                    $xw->startElement("invoicesExpensesClassificationDetails");

                        $xw->startElement("lineNumber");
                        $xw->text($data00['lineNumber']);
                        $xw->endElement();

                        $xw->startElement("expensesClassificationDetailData");

                            if(!empty($data00['classificationType'])){
                                $xw->startElement("classificationType");
                                $xw->text($data00['classificationType']);
                                $xw->endElement();
                            }

                            $xw->startElement("classificationCategory");
                            $xw->text($data00['classificationCategory']);
                            $xw->endElement();

                            $xw->startElement("amount");
                            $xw->text($amount);
                            $xw->endElement();


                            $contition  = (($data00['vatcat']!=8 && $data00['vatcat']!=7) || $data00['vatexcat']=='16');
                            if($data00['classificationCategory'] == "category2_5"){
                                $contition = false;
                            }

                            if($postPerInvoice  &&  $contition ){
                                $xw->startElement("vatAmount");
                                $xw->text($data00['fpavalue']);
                                $xw->endElement();

                                $xw->startElement("vatCategory");
                                $xw->text($data00['vatcat']);
                                $xw->endElement();

                                if(!empty($data00['vatexcat'])){
                                    $xw->startElement("vatExemptionCategory");
                                    $xw->text($data00['vatexcat']);
                                    $xw->endElement();
                                }
                            }

                            $xw->startElement("id");
                            $xw->text($np_idcoun++);
                            $xw->endElement();
                        $xw->endElement();

                       
                        $vattype = '';
                        // Αλλαγη μονο για το αρθρο 39α    
                        if($data00['vatexcat']=='16' && $postPerInvoice){
                            $fpavalue=round($amount*0.24,2);
                            $vattype = "VAT_366";
                            $vatcat = '1';
                        }elseif($data00['classificationCategory'] == "category2_5"){
                            $amount   = 0;
                            $fpavalue = 0;
                            $vattype  = "";
                            $vatcat   = '8';                            
                        }else{
                            $fpavalue=$data00['fpavalue'];
                            $vattype = $data00['vattype'];
                            $vatcat = $data00['vatcat'];
                        } 

                        if(!empty($vattype) && $vatcat!=8 && $vatcat!=7){
                            $xw->startElement("expensesClassificationDetailData");

                                
                                $xw->startElement("classificationType");
                                $xw->text($vattype);
                                $xw->endElement();
                                

                                $xw->startElement("classificationCategory");
                                $xw->text($data00['classificationCategory']);
                                $xw->endElement();

                                $xw->startElement("amount");
                                $xw->text($amount);
                                $xw->endElement();

                                if($postPerInvoice && $vatcat!=8 && $vatcat!=7){
                                    $xw->startElement("vatAmount");
                                    $xw->text($fpavalue);
                                    $xw->endElement();

                                    $xw->startElement("vatCategory");
                                    $xw->text($vatcat);
                                    $xw->endElement();

                                    if(!empty($data00['vatexcat'])){
                                        $xw->startElement("vatExemptionCategory");
                                        $xw->text($data00['vatexcat']);
                                        $xw->endElement();
                                    }
                                }

                                $xw->startElement("id");
                                $xw->text($np_idcoun++);
                                $xw->endElement();
                            $xw->endElement(); 
                        }

                        
                    $xw->endElement();                  

               
                }


                $xw->endElement();
            $xw->endElement();
            $xw->endDocument();
            return  array('xml' => $xw->outputMemory() /*,  'nr01_array' => $nr01_array*/); 
        }

        public function incomeClassificationsDoc_create_xml($data){
            if(empty($data[0]['mark'])){
                return '';
            }

            $xw = new XMLWriter();
            $xw->openMemory();
            $xw->startDocument("1.0" , "utf-8");
            $xw->startElement("IncomeClassificationsDoc");
                
            $xw->startAttribute('xmlns:xs');
            $xw->text('http://www.w3.org/2001/XMLSchema');
            $xw->endAttribute();

            $xw->startAttribute('xmlns:ecls');
            $xw->text('https://www.aade.gr/myDATA/incomeClassificaton/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xmlns:inv');
            $xw->text('http://www.aade.gr/myDATA/invoice/v1.0');
            $xw->endAttribute();

            $xw->startAttribute('xmlns');
            $xw->text('https://www.aade.gr/myDATA/incomeClassificaton/v1.0');
            $xw->endAttribute();


                $mark='';
                $nr01_array=array();
                foreach ($data as $data00){
                    
                    if($data00['mark'] != $mark){

                        if(!empty($mark)){
                            $xw->endElement();
                        }

                        $xw->startElement("incomeInvoiceClassification");
                        $mark = $data00['mark'];
                        array_push($nr01_array , $data00['nr01']);
                        $xw->startElement("invoiceMark");
                        $xw->text($mark);
                        $xw->endElement();    
                    }

                    $xw->startElement("invoicesIncomeClassificationDetails");

                        $xw->startElement("lineNumber");
                        $xw->text($data00['lineNumber']);
                        $xw->endElement();

                        $xw->startElement("incomeClassificationDetailData");

                            if(!empty($data00['classificationType'])){
                                $xw->startElement("classificationType");
                                $xw->text($data00['classificationType']);
                                $xw->endElement();
                            }
                            
                            $xw->startElement("classificationCategory");
                            $xw->text($data00['classificationCategory']);
                            $xw->endElement();

                            $xw->startElement("amount");
                            $xw->text($data00['amount']);
                            $xw->endElement();

                        $xw->endElement();

                        
                    $xw->endElement();                  

               
                }


                $xw->endElement();
            $xw->endElement();
            $xw->endDocument();
            return  array('xml' => $xw->outputMemory() /*,  'nr01_array' => $nr01_array*/); 
        }

        public function find_mydt01_array($mydt10_nr01_array){


            $data = array();
            if(!pegasus_module_exists('stores')){
                return $data; 
            }

            $mydt10_nr01_st =  pegasus_mysql_prepare_in_statement($mydt10_nr01_array,  'mydt10_nr01_');
            
            $sql = '';
            $sql .= " select ifnull(mydt01.nr01 , -1) as nr01, mydt01.user_id, mydt01.subsc_id , t05.p02 as t05_p02 from mydt10 ";
            $sql .= " left join t07 on mydt10.p03=t07.p01 ";
            $sql .= " left join t05 on t05.p01=t07.p07 ";
            $sql .= " left join mydt01 on mydt01.p100=t05.p01 ";
            $sql .= " where mydt10.nr01 in ( ##mydt10_nr01s## )  group by mydt01.p100";

            // $sql = $this->_read_sql('../mydt_sql/_mydt10.sql');
            $sql = str_replace( ' ##mydt10_nr01s##',  ':' . $mydt10_nr01_st['sql']  , $sql);
         
           // echo pegasus_replace_values_in_sql($sql ,   $mydt10_nr01_st['sqlParams']);
            $res  = pegasus_query($sql ,   $mydt10_nr01_st['sqlParams'] );
            $data = pegasus_fetchall($res, PEG_FETCH_ASSOC);
                        
            return $data;
        }

        private function _invoicesDoc_mydt10_data($mydt10_nr01_array ,  $mydt01_nr01 = -2 ,  $correlated=0){

            
            // ##start_module_exist_stores##
            // ##end_module_exist_stores##
            // ##mydt10_nr01_where##
    

            $data = array();
            $mydt10_nr01_st =  pegasus_mysql_prepare_in_statement($mydt10_nr01_array,  'mydt10_nr01_');

            
            $sql = $this->_read_sql('../mydt_sql/_mydt10.sql');
            $sql = str_replace( ' ##mydt10_nr01s##',  ':' . $mydt10_nr01_st['sql']  , $sql);
            //echo pegasus_replace_values_in_sql($sql ,   $mydt10_nr01_st['sqlParams'] );
            
            $whereCorrelated = '';
            if($correlated==0){
                //Oχι Συσχετιζομενα και κενο το πεδιο συσχετιζομενα 
                $whereCorrelated = ' && (mydt50.p103=1 || tbl01.pcor=\'\') ';
            }else{
                //Oχι Συσχετιζομενα=0 και οχι κενο το πεδιο συσχετιζομενα
                $whereCorrelated = '  && (mydt50.p103=0 && tbl01.pcor!=\'\') ';
            }
            $sql = str_replace( '##correlated_where##',  $whereCorrelated  , $sql);
            


            if(!pegasus_module_exists('stores') || $mydt01_nr01 == -2 ){
                $sql = str_replace( '##start_module_exist_stores##' ,  '/**' , $sql);
                $sql = str_replace( '##end_module_exist_stores##'   ,  '**/' , $sql);
                $sql = str_replace( '##mydt10_nr01_where##'         ,  '' , $sql);
            }elseif($mydt01_nr01 == -1 ){
                $sql = str_replace( '##start_module_exist_stores##' ,  '' , $sql);
                $sql = str_replace( '##end_module_exist_stores##'   ,  '' , $sql);
                $sql = str_replace( '##mydt10_nr01_where##'         ,  ' && mydt01.nr01 is null ' , $sql);
            }else{
                $sql = str_replace( '##start_module_exist_stores##' ,  '' , $sql);
                $sql = str_replace( '##end_module_exist_stores##'   ,  '' , $sql);
                $sql = str_replace( '##mydt10_nr01_where##'         ,  ' && mydt01.nr01=:mydt01_nr01 ' , $sql);
                $mydt10_nr01_st['sqlParams']['mydt01_nr01'] = $mydt01_nr01;
            }

            // echo '<br>=========================================<br>';
            // echo '<pre>';
            // echo pegasus_replace_values_in_sql($sql ,   $mydt10_nr01_st['sqlParams'] );
            // echo '</pre>';
            // echo '<br>=========================================<br>';

            $res  = pegasus_query($sql ,   $mydt10_nr01_st['sqlParams'] );
            $data = pegasus_fetchall($res, PEG_FETCH_ASSOC);
                        
            // if(!($data[0]['nr01']>0)){
            //     throw new Exception(  $_SESSION['peg_dic_mydt_mydt10_no_invoice_to_send']);
            // }
            
            return $data;
        }

        private function _invoicesDoc_mydt12_data($mydt10_nr01 = -1){
            $data = array();
            $sql = $this->_read_sql('../mydt_sql/_mydt12.sql');
            
            // $ret_sql =  pegasus_replace_values_in_sql($sql ,  array('mydt10_nr01' => $mydt10_nr01)  );
            // echo $ret_sql;

            $res = pegasus_query($sql ,  array('mydt10_nr01' => $mydt10_nr01) );
            $data = pegasus_fetchall($res, PEG_FETCH_ASSOC);
            
     
            
            return $data;
        }
        private function _invoicesDoc_mydt13_data($mydt10_nr01 = -1){
            $sql = $this->_read_sql('../mydt_sql/_mydt13.sql');
            $res = pegasus_query($sql, array('mydt10_nr01' => $mydt10_nr01));
            $data = pegasus_fetchall($res, PEG_FETCH_ASSOC);
            return $data;
        }

        private function _checkCorrelated($mydt10_nr01){
            pegasus_mysql_use("select * from mydt10 where mydt10.nr01=:mydt10_nr01;", $mydt10, array('mydt10_nr01' => $mydt10_nr01));
            $pcorArray = explode('#' ,$mydt10['pcor']);
            
            $i=0;
            $pcorSQL = '';
            $pcorSQLParams = array();
            foreach( $pcorArray as $pcor){

                //elegxei an to sysxetizomeno parastatiko exei eggrafi sto q31 allios dne to symperilambanei sto metriti
                $has_q31=true;
                if( $mydt10['tbl']=='a55' ){
                    $a55p05= pegasus_mysql_printfld( 'a55' , 'p05' , 'nr01=:nr01' ,array('nr01'=> $pcor));
                    $count = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620014, 620068) and  q31.p03=:q31_p03', array('q31_p03'=> $a55p05) );
                    if(!($count>0)){
                        $has_q31=false;
                    }
                }
                if( $mydt10['tbl']=='a56'){
                    //12-01-2023
                    $a56p05 = pegasus_mysql_printfld( 'a56' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcor));
                    $count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01 IN (620017, 620069) and q31.p03=:q31_p03', array('q31_p03' => $a56p05) );
                    if(!($count>0)){
                        $has_q31=false;
                    }
                }
                if( $mydt10['tbl']=='t08'){
                    $t08p05 = pegasus_mysql_printfld( 't08' , 'p05' , 'nr01=:nr01' , array('nr01' => $pcor));
                    $count  = pegasus_mysql_printfld( 'q31' , 'count(*)' , 'q31.p01=620019 and q31.p03=:q31_p03', array('q31_p03' => $t08p05) );
                    if(!($count>0)){
                        $has_q31=false;
                    }
                }

                if(!empty($pcor) and !array_search($pcor,$pcorSQLParams,true) and $has_q31 ){
                    if(!empty($pcorSQL)){
                        $pcorSQL .= ' , ';
                    }
                    $pcorSQL .= ':pcorre_' . $i; 
                    $pcorSQLParams['pcorre_' . $i] =$pcor ; 

                    $i++;
                }
            }

            $ii=0;
            //TODO Εδώ θέλει συνθήκη να μην εκτελεί query αν το $pcorSQL είναι κενό γιατί χτυπάει sql error.
            if($mydt10['tbl'] == 'a56') {
                //12-01-2023
                $query = "select 
                            mydt10.mark ,
                            mydt50.p103 as mydt50_p103 
                        from mydt10 
                        join mydt50 on mydt50.p00=mydt10.invtype 
                            where /*mydt10.mark!='' and*/ mydt10.tbl='a56' and mydt10.tbl_nr01 in (".$pcorSQL.");";
            }elseif($mydt10['tbl'] == 't08'){
                $query = "select 
                            mydt10.mark ,
                            mydt50.p103 as mydt50_p103 
                        from mydt10 
                        join mydt50 on mydt50.p00=mydt10.invtype 
                            where /*mydt10.mark!='' and*/ mydt10.tbl='t08' and mydt10.tbl_nr01 in (".$pcorSQL.");";
            }else{
                $query = "select 
                            mydt10.mark ,
                            mydt50.p103 as mydt50_p103 
                        from mydt10 
                        join mydt50 on mydt50.p00=mydt10.invtype 
                            where /*mydt10.mark!='' and*/ mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pcorSQL.");";
            }
            $res = pegasus_query($query, $pcorSQLParams);

            //echo pegasus_replace_values_in_sql("select * from mydt10 where mydt10.mark!='' and mydt10.tbl='a55' and mydt10.tbl_nr01 in (".$pcorSQL.");" ,$pcorSQLParams);
            while($mydt10_00 = pegasus_fetch_assoc( $res)){

                if($mydt10_00['mydt50_p103']==0){
                    $i--;
                }

                if($mydt10_00['mark']!='' && $mydt10_00['mydt50_p103']==1){
                    if(!empty($correlinv)){
                        $correlinv .= ',';
                    }
                    $correlinv .= $mydt10_00['mark'];
                    $ii++;    
                }
            }

            if($i!==$ii){
                $p04 = $mydt10['p04'];
                if(empty($p04)){
                    $p04 .= '#4#';
                }else{
                    $p04 .= '4#';
                }
                pegasus_mysql_update('mydt10' , array('p04') , array( $p04 ) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
            }

            if($i===$ii and $i>0){

                $p04 = $mydt10['p04'];
                if($p04 == '#4#'){
                    $p04 = '';
                }else{
                    $p04 = str_replace('4#' ,'' ,$p04) ;
                }
                pegasus_mysql_update('mydt10' , array('correlinv','p04') , array($correlinv,$p04) , 'nr01=:nr01' , 0 , 1 , 1 ,  array('nr01'=>$mydt10_nr01));
                return $correlinv;
            }

            return false;
        }

        private function _read_sql($sql){
            $sql = peg_read_file($sql);
            return $sql;
        }    

    }
?>