<?php


class mydt_sync{



    // $code	=	"";
	// $url = 'http://services.tesae.gr/services01/execute.php';
	// $sn		=	pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
	// $username=urlencode($_SESSION['customers_000_ckafmuser']);
	// $password=urlencode($_SESSION['customers_000_ckafmpass']);
    // $ckafmafm=urlencode($_SESSION['customers_000_ckafmafm']);
    
    // $ret_xml =  pegasus_curl_request($url . '?action=login&user=' . $_SESSION['cor000_tesae_user'] .'&pass=' .$_SESSION['cor000_tesae_pass'] .'&un=1' );
    // $xml_login = simplexml_load_string($ret_xml);
    


    private  $url;
    private  $tesae_username;
    private  $tesae_password;
    private  $my_data_user_id;
    private  $my_data_subscription_id;
    private  $my_data_user_lo;
    private  $my_data_subscription_lo;
    private  $sn;
    private  $dev_mode;
    private  $unicode;
    private  $sid;
    private  $last_login_my_data_user_id;
    private  $last_login_user_id_store;


    function __construct(){

        $this->_setUrl();
        //$this->url = "https://www.tesae.gr/services/my_data/execute.php";
        $this->tesae_username = $_SESSION['cor000_tesae_user'];
        $this->tesae_password = $_SESSION['cor000_tesae_pass'];

        $this->my_data_user_id         = $_SESSION['mydt00_user_id'];
        $this->my_data_subscription_id = $_SESSION['mydt00_subsc_id'];

        $this->my_data_user_lo         = $_SESSION['mydt00_user_lo'];
        $this->my_data_subscription_lo = $_SESSION['mydt00_subsc_lo'];


        $this->dev_mode = $_SESSION['mydt00_dev_mode'];

        $this->last_login_my_data_user_id = '';
        $this->last_login_user_id_store   = '';

        $this->sn                      = pegasus_leading_zeros($_SESSION['cor000_sn'], 7);
        $this->unicode                 = 1;
    }

    private function login($mydt01_nr01=-2 , $isLogistis=0){

        $my_data_user_id          = '';
        $my_data_subscription_id  = '';
        $dev_mode = '';
        $last_login_user_id_store = '';
    
        if( ($mydt01_nr01>0) ){
            pegasus_mysql_use("select * from mydt01 where mydt01.nr01=:mydt01_nr01;" , $mydt01 , array('mydt01_nr01' => $mydt01_nr01) );
            if($isLogistis==0){
                $my_data_user_id         = $mydt01['user_id'];
                $my_data_subscription_id = $mydt01['subsc_id'];    
            }else{
                $my_data_user_id         = $mydt01['user_lo'];
                $my_data_subscription_id = $mydt01['subsc_lo'];
            }
            $dev_mode = $mydt01['p00'];
            //* Αν συνδέεται με στοιχεία από ομάδα καταστήματος και η ομάδα έχει μόνο ένα κατάστημα
            //* Κρατάει το κατάστημα στη last_login_user_id_store ώστε να το προσθέσει στην mydt10.p03 εγγραφή από την παραλαβή (_invoiceDoc_get00)
            $query = "  SELECT 
                            t07.p01 as code_store
                        FROM t07 
                        JOIN t05 ON t05.p01 = t07.p07
                        JOIN mydt01 ON mydt01.p100=t05.p01 
                        WHERE mydt01.user_id!='' and mydt01.user_id!=:mydt00_user_id";
            $queryParams = array('mydt00_user_id' => $_SESSION['mydt00_user_id']);
            $res = pegasus_query($query, $queryParams);
            if(pegasus_num_rows($res) == 1) {
                while($store = pegasus_fetch($res)){
                    $last_login_user_id_store = $store['code_store'];
                }
            }
        }

        if(empty($my_data_user_id)){
            if($isLogistis==0){
                $my_data_user_id = $this->my_data_user_id;
                $my_data_subscription_id = $this->my_data_subscription_id;
            }else{
                $my_data_user_id = $this->my_data_user_lo;
                $my_data_subscription_id = $this->my_data_subscription_lo;
            }

            $dev_mode = $this->dev_mode;
        }


        $params= array();
        $params['action'] = 'login';
        $params['user'] = $this->tesae_username;
        $params['pass'] = $this->tesae_password;        
        $params['my_data_user_id'] = $my_data_user_id;
        $params['my_data_subscription_id'] = $my_data_subscription_id;
        $params['sn'] = $this->sn;
        $params['un'] = 1;
        $params['dev_mode'] = $dev_mode;
        
        
        $ret_xml = pegasus_curl_request_post($this->url, $params);
        $xml_login = simplexml_load_string($ret_xml);

        if($xml_login->code=='100'){
            $this->sid = (string) $xml_login->sid;
            $this->last_login_my_data_user_id = (string) $params['my_data_user_id'];
            $this->last_login_user_id_store   = (string) $last_login_user_id_store;
            return array('ok'=>1);
        }else{
            //debug 
            peg_mydt_debugs_logs('login',  print_r( $params , true) , $xml_login);
            return array('ok'=>0 , 'msg' => 'Login:' .$xml_login->description);
        }
    }

    private function logout(){
        
        $params= array();
        $params['action'] = 'sessionDestroy';
        $params['sid'] = $this->sid;

        
        $ret_xml = pegasus_curl_request_post($this->url, $params);
        $xml_logout = simplexml_load_string($ret_xml);


        if($xml_logout->code=='998' || $xml_logout->code=='999'){
            $this->sid = '';
            return array('ok'=>1);
        }else{
            //debug 
            peg_mydt_debugs_logs('logout',    print_r( $params , true) , $xml_logout);
            return array('ok'=>0 , 'msg' => 'Logout:' . $xml_logout->description);
        }


    }    

    public function download_table($table_name){

        $ret_array = $this->login();
        if(!$ret_array['ok']==1){
            return $ret_array;
        }

        //Ειδη παραστατικου
        if($table_name=='mydt50'){
            
            $params= array();
            $params['action'] = 'getApi450';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->inv_types->inv_type;
            $this->UploadDatatoDB($table_name, $records);

        }

        //Συντελεστές ΦΠΑ
        if($table_name=='mydt51'){
            
            $params= array();
            $params['action'] = 'getApi451';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->fpa_factors->fpa_factor;
            $this->UploadDatatoDB($table_name, $records);

        }

        //Κωδικοί Εξαίρεσης από ΦΠΑ
        if($table_name=='mydt52'){
            
            $params= array();
            $params['action'] = 'getApi452';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->fpa_excl_codes->fpa_excl_code;
            $this->UploadDatatoDB($table_name, $records);

        }

        //Συντελεστές παρακράτησης φόρου
        if($table_name=='mydt53'){
            
            $params= array();
            $params['action'] = 'getApi453';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->fpa_parakratisi_factors->fpa_parakratisi_factor;
            $this->UploadDatatoDB($table_name, $records);

        }

        //Συντελεστές λοιπών φόρων
        if($table_name=='mydt54'){
            
            $params= array();
            $params['action'] = 'getApi454';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->other_taxes_factors->other_taxes_factor;
            $this->UploadDatatoDB($table_name, $records);

        }


        //Συντελεστές Χαρτοσήμου
        if($table_name=='mydt55'){
            
            $params= array();
            $params['action'] = 'getApi455';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->stamp_factors->stamp_factor;
            $this->UploadDatatoDB($table_name, $records);

        }


        //Συντελεστές τελών
        if($table_name=='mydt56'){
            
            $params= array();
            $params['action'] = 'getApi456';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->fee_factors->fee_factor;
            $this->UploadDatatoDB($table_name, $records);
        }


        //Χαρακτηρισμοί εσόδων
        if($table_name=='mydt57'){
            
            $params= array();
            $params['action'] = 'getApi457';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->income_descs->income_desc;
            $this->UploadDatatoDB($table_name, $records);
        }

         //Χαρακτηρισμοί εξόδων
         if($table_name=='mydt58'){
            
            $params= array();
            $params['action'] = 'getApi458';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->outcome_descs->outcome_desc;
            $this->UploadDatatoDB($table_name, $records);
        }

         //Μονάδες Μέτρησης
         if($table_name=='mydt59'){
            
            $params= array();
            $params['action'] = 'getApi459';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->mus->mu;
            $this->UploadDatatoDB($table_name, $records);
        }

         //Επισημάνσεις
         if($table_name=='mydt60'){
            
            $params= array();
            $params['action'] = 'getApi460';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->markings->marking;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Χαρακτηρισμός E3 Εσόδου
        if($table_name=='mydt61'){
            
            $params= array();
            $params['action'] = 'getApi461';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->markings->marking;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Χαρακτηρισμός E3 Εξοδου
        if($table_name=='mydt62'){
            
            $params= array();
            $params['action'] = 'getApi462';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->markings->marking;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Σκοποί Διακίνησης
        if($table_name=='mydt63'){
            
            $params= array();
            $params['action'] = 'getApi463';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->markings->marking;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Σκοποί Διακίνησης
        if($table_name=='mydt64'){
            
            $params= array();
            $params['action'] = 'getApi464';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->markings->marking;
            $this->UploadDatatoDB($table_name, $records);
        }


        //Συνδυασμοί Χαρακτηριστικών - Ε3
        if($table_name=='mydt65'){
            
            $params= array();
            $params['action'] = 'getApi465';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->records->record;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Ειδική Κατηγορία Παραστατικού
        if($table_name=='mydt66'){
            
            $params= array();
            $params['action'] = 'getApi466';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->records->record;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Τύπος Απόκλισης Παραστατικού
        if($table_name=='mydt67'){
            
            $params= array();
            $params['action'] = 'getApi467';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->records->record;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Κωδικοί Καυσίμων
        if($table_name=='mydt68'){
            
            $params= array();
            $params['action'] = 'getApi468';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->records->record;
            $this->UploadDatatoDB($table_name, $records);
        }

        //Κατηγορία Οντότητας
        if($table_name=='mydt69'){
            
            $params= array();
            $params['action'] = 'getApi469';
            $params['sid'] = $this->sid;

            $ret_xml = pegasus_curl_request_post($this->url, $params);
            $xml_obj = simplexml_load_string($ret_xml);
            $records = $xml_obj->records->record;
            $this->UploadDatatoDB($table_name, $records);
        }

        $ret_array = $this->logout();
        if(!$ret_array['ok']==1){
            return $ret_array;
        }


        return array('ok'=>1);
    }

    private function UploadDatatoDB($table_name, $records ) {
        //Delete alla data
        pegasus_mysql_delete($table_name ,'nr01>0');

        //Find Tables Fields
        $res  = pegasus_query("SELECT * FROM INFORMATION_SCHEMA.columns WHERE table_schema = ? AND table_name = ?   ;",array(DB_NAME,$table_name));
        $table_fields = pegasus_fetchall($res);

        foreach( $records  as $record){
            // var_dump($record);
            $array_fields = array(); $array_values = array();
            // $res= pegasus_query("SELECT * FROM INFORMATION_SCHEMA.columns WHERE table_schema = ? AND table_name = ?   ;",array(DB_NAME,$table_name));
            foreach($table_fields as $fields){
                if(isset($record->{ $fields['COLUMN_NAME'] })){
                    array_push($array_fields, $fields['COLUMN_NAME'] ); array_push($array_values, $record->{ $fields['COLUMN_NAME'] } );
                }
            }
            pegasus_mysql_insert($table_name , $array_fields , $array_values);
        }

    }    

    public function invoiceDoc_send($XML_string , $mydt10_array , $mydt01_nr01=-2){
        
        if( count($mydt10_array)==0 ){
            $ok = 0;
            $msg = '(-1) ' . $_SESSION['peg_dic_mydt_no_invoices_to_send']; 
            return array('ok' => $ok , 'msg' => $msg);
        }


        $ret_array = $this->login($mydt01_nr01);


        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Login:' . $ret_array['msg'];
            return $ret_array;
        }

        $post_data= array();
        $post_data['action'] = 'apiSendInvoices';
        $post_data['XML']    = $XML_string;
        $post_data['sid']    = $this->sid;

        $ret_xml = pegasus_curl_request_post($this->url, $post_data);
        $xml_obj = simplexml_load_string($ret_xml);
        
        //debug 
        peg_mydt_debugs_logs('apiSendInvoices',  print_r($post_data,true) , $ret_xml);
        

        $ret_array = $this->logout();
        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Logout:' . $ret_array['msg'];
             return $ret_array;
        }

        $ok = 1;
        if( $xml_obj->code == 208 || $xml_obj->code == 209 || $xml_obj->code == 210 ){
            $ok = 0;
            $msg = '';
            foreach($xml_obj->AADEXMLResponse->response->errors->error as $error){
                $msg .= '(1) Code:' . $error->code . ' ' .  $error->message . '<br>';
            }

        }elseif( $xml_obj->code != 210){
            $ok = 0;
            $msg = '<pre>(2)' . $xml_obj->AADEXMLResponse->Message . '</pre>';
        } 

        //Success 
        if($xml_obj->code == 210){
            $ok = 0;
            $msg = "Success";
            $succeeded=0;
            foreach($xml_obj->AADEXMLResponse->response as $resp){

                if($resp->statusCode == 'Success'){
                    $ok = 1;
                    $arr1 = array();  $arr2 = array();
                    array_push($arr1 , 'p30');  array_push($arr2 , '' );
                    array_push($arr1 , 'p04');  array_push($arr2 , '' );
                    array_push($arr1 , 'uid');  array_push($arr2 , '' . $resp->invoiceUid);
                    array_push($arr1 , 'mark'); array_push($arr2 , '' . $resp->invoiceMark);
                    array_push($arr1 , 'qrurl'); array_push($arr2 , '' . $resp->qrUrl);
                    array_push($arr1 , 'p02');  array_push($arr2 , '1' );
                    array_push($arr1 , 'p02_1'); array_push($arr2 , 0);

                    pegasus_mysql_update('mydt10' , $arr1 , $arr2 , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $mydt10_array[$resp->index-1]));
                    $succeeded++;
                }else{
                    $p30='';
                    foreach ($resp->errors->error as $error) {
                        $p30.= 'Code:' . $error->code . ' ' .  $error->message  . "\n";
                    }
                    pegasus_mysql_update('mydt10' , array('p30') , array($p30) , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $mydt10_array[$resp->index-1]));
                    //Aν γινεται αποστολή μονο ενος παραστατικόυ
                }
            } 

            $msg = str_replace('##1##' ,  $succeeded . '/' . count($mydt10_array)  , $_SESSION['peg_dic_mydt_mydt10_invoices_succeeded']);

            if( count($mydt10_array) ==1 && !empty($p30)){
                $msg .= "<br><pre>Εrror:\n" .  $p30 . '</pre>'; 
            }

        }
        return array('ok' => $ok , 'msg' => $msg);
    }

    public function invoiceDoc_cancel($mydt10_nr01_arr){
 

        //Διορθωση του flag για επανααποστολή αν ειανι δειγραμενο ακι υπαρχει μαρκ διαγραφης 
        //pegasus_query("update mydt10 set p02_1=0 where p02_1=1 and p05=1 and  mark!='' and  dmark!='';");

        $canceled = 0;
        $total = 0;
        $mydt10_nr01_st =  pegasus_mysql_prepare_in_statement($mydt10_nr01_arr,  'mydt10_nr01_');
        $sql =  $this->_read_sql('../mydt_sql/smep110300.sql');
        $sql =  str_replace( ' ##mydt10_nr01s##',  ':' . $mydt10_nr01_st['sql']  , $sql);


        $res =  pegasus_query( $sql ,  $mydt10_nr01_st['sqlParams'] );
        //echo pegasus_replace_values_in_sql( $sql ,  $mydt10_nr01_st['sqlParams'] );

        $ret_array = $this->login();
        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Login:' . $ret_array['msg'];
            return $ret_array;
        }
 
        $p30_all_cancels = '';
        $mydt10_katastima = '';
        while($mydt10 = pegasus_fetch($res)){
            if($mydt10_katastima!=$mydt10['mydt10_p03'] && pegasus_module_exists('stores')){                
                pegasus_mysql_use("select mydt01.* from t07 left join t05 on t05.p01=t07.p07 left join mydt01 on mydt01.p100=t05.p01 where t07.p01=:t07_p01 ;", $mydt01 , array('t07_p01' => $mydt10['mydt10_p03']) );
                $ret_array = $this->login($mydt01['nr01']);
                if(!$ret_array['ok']==1){
                    $ret_array['msg'] =  'Login:' . $ret_array['msg'];
                    return $ret_array;
                }
            }

            if(empty($mydt10_katastima)){
                $mydt10_katastima = $mydt10['mydt10_p03'];
            }

            $total++;
            $post_data= array();
            $post_data['action'] = 'apiCancelInvoice';
            $post_data['sid']    = $this->sid;            
            $post_data['mark']   = $mydt10['mark'];
    
            $ret_xml = pegasus_curl_request_post($this->url, $post_data);
            $xml_obj = simplexml_load_string($ret_xml);
            //var_dump($ret_xml);
            // die();
            //debug 
            peg_mydt_debugs_logs('apiCancelInvoice', print_r($post_data,true) , $ret_xml);

            if($xml_obj->code=='210'){
                if($xml_obj->AADEXMLResponse->response->statusCode=='Success'){
                    $canceled++;
                    $arr1 = array(); $arr2 = array();
                    array_push($arr1 , 'p30');     array_push($arr2 , '');
                    array_push($arr1 , 'p04');     array_push($arr2 , '');
                    array_push($arr1 , 'dmark');   array_push($arr2 , (string) $xml_obj->AADEXMLResponse->response->cancellationMark);
                    array_push($arr1 , 'ddate');   array_push($arr2 , date('Y-m-d'));

                    array_push($arr1 , 'p02_1');   array_push($arr2 , '0');
                    pegasus_mysql_update('mydt10' , $arr1 , $arr2 , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $mydt10['nr01'] ));
                }
                else{
                    $p30='';
                    $p30_251 = '';
                    foreach ($xml_obj->AADEXMLResponse->response->errors->error as $error) {
                        if( $error->code == '251' ){ //invoice is allready canceled
                            $p30_251 .= 'Code:' . $error->code . ' ' .  $error->message  . "\n";
                        }else{
                            $p30.= 'Code:' . $error->code . ' ' .  $error->message  . "\n";
                        }
                    }

                    if($p30=='' and $p30_251!=''){
                        pegasus_mysql_update('mydt10' , array('p02_1' , 'p30') , array('0' , '') , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $mydt10['nr01']));
                    } 

                    pegasus_mysql_update('mydt10' , array('p30') , array($p30) , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $mydt10['nr01']));
                    $p30_all_cancels .= $p30 . $p30_251;
                }

            }

        }

        $ret_array = $this->logout();
        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Logout:' . $ret_array['msg'];
             return $ret_array;
        }

        if( $total >0 ){
            $ok  = 1;
            $msg =   str_replace('##1##' ,  $canceled . '/' . $total  , $_SESSION['peg_dic_mydt_mydt10_invoices_canceled']);
            if(!empty($p30_all_cancels)){
                $msg .= "<br><pre>Εrror:\n" .  $p30_all_cancels . '</pre>';
            }
        }
        return array('ok' => $ok , 'msg' => $msg);
    }

    public function invoiceDoc_get($p_mydt10tot ='', $params = array()){
        /**
         * 22/02/2023 - Removed "$en_mark_search_on_receive=1" parameter.
         */

        $message = '';
        if(!empty($_SESSION['mydt00_user_id'])){
            $ret_array = $this->login();
            if(!$ret_array['ok']==1){
                $message .= 'Login:' . $ret_array['msg'];
            }else{
                $records_added   = 0;
                $records_deleted = 0;
                // $mark_id = 0;
                // if($en_mark_search_on_receive==1){
                //     $mark_id= pegasus_mysql_printfld("mydt10" , "max(mark)" , " p01=2 and user_id=:user_id" , array('user_id'=> $this->last_login_my_data_user_id));
                // }
                
                $this->_invoiceDoc_get00($records_added , $records_deleted,  $p_mydt10tot, $params);

                $message .=  '<b>'.$records_added.'</b> ' . $_SESSION['peg_dic_mydt_mydt10_records_upd_from_aade'];
                $message .=  '<br><b>'.$records_deleted.'</b> ' . $_SESSION['peg_dic_mydt_mydt10_records_canceled_from_aade'];

    
                $ret_array = $this->logout();
                if(!$ret_array['ok']==1){
                    $message .=  'Logout:' . $ret_array['msg'];
                }
            }
        }



        if(pegasus_module_exists('stores')){
            $query = 
            "select t05.p01 as t05_p01,t05.p02 as t05_p02,mydt01.* 
                from mydt01 
                join t05 on mydt01.p100=t05.p01 
                where mydt01.user_id!='' and mydt01.user_id!=:mydt00_user_id";

            $res   = pegasus_query($query , array("mydt00_user_id" => $_SESSION['mydt00_user_id']));
            while($tbl = pegasus_fetch_assoc($res)){
                $message .=  '<br>----------------------------------------------<br><b>' . $tbl['t05_p02'] . '</b><br>';

                $ret_array = $this->login($tbl['nr01']);
                if(!$ret_array['ok']==1){
                    $message .= 'Login:' . $ret_array['msg'];
                }else{
                    $records_added   = 0;
                    $records_deleted = 0;
                    // $mark_id = 0;
                    // if($en_mark_search_on_receive==1){
                    //     $mark_id= pegasus_mysql_printfld("mydt10" , "max(mark)" , " p01=2 and user_id=:user_id" , array('user_id'=> $this->last_login_my_data_user_id));
                    // }
                    $this->_invoiceDoc_get00($records_added , $records_deleted,  $p_mydt10tot, $params);
                    $message .=  '<b>'.$records_added.'</b> ' . $_SESSION['peg_dic_mydt_mydt10_records_upd_from_aade'];
                    $message .=  '<br><b>'.$records_deleted.'</b> ' . $_SESSION['peg_dic_mydt_mydt10_records_canceled_from_aade'];

                    $ret_array = $this->logout();
                    if(!$ret_array['ok']==1){
                        $message .=  'Logout:' . $ret_array['msg'];
                    }
                }
            }
        }
        return array('ok' => 1, 'msg' => $message);

    }

    private function _invoiceDoc_get00(&$records_added ,  &$records_deleted,  $p_mydt10tot='', $params = array()){
        /**
         * 22/02/2023 - Removed "$mark_id=0" parameter.
         * $post_data['mark']   = $_mark_id; 
         */

        $post_data['action'] = 'apiRequestDocs';

        // Αρχικοποιώ με 0 (όλα). Αν έχει δώσει ΜΑΡΚ στο dashboard, θα περάσει από το $params['rcv_mark']
        $post_data['mark']   = 0; // Το μόνο απαραίτητο (από το mydata) να υπάρχει στο request.
        $post_data['sid']    = $this->sid;

        // New Fields Start
        if(isset($params['rcv_mark'])) {
            $post_data['mark'] = $params['rcv_mark'];
        }
        if(isset($params['rcv_ent_vat']) && !empty($params['rcv_ent_vat'])) {
            $post_data['entityVatNumber'] = $params['rcv_ent_vat'];
        }
        if(isset($params['rcv_dt_from']) && !empty($params['rcv_dt_from'])) {
            $post_data['dateFrom'] = $params['rcv_dt_from'];
        }
        if(isset($params['rcv_dt_to']) && !empty($params['rcv_dt_to'])) {
            $post_data['dateTo'] = $params['rcv_dt_to'];
        }
        if(isset($params['rcv_rec_vat']) && !empty($params['rcv_rec_vat'])) {
            $post_data['receiverVatNumber'] = $params['rcv_rec_vat'];
        }
        if(isset($params['rcv_invtype']) && !empty($params['rcv_invtype'])) {
            $post_data['invType'] = $params['rcv_invtype'];
        }
        if(isset($params['rcv_maxmark']) && !empty($params['rcv_maxmark'])) {
            $post_data['maxMark'] = $params['rcv_maxmark'];
        }
        //* nextPartitionKey και nextRowKey έρχονται μόνο από τον εαυτό της αν στην προηγούμενη κλήση είχα continuationToken
        if(isset($params['nextPartitionKey']) && !empty($params['nextPartitionKey'])) {
            $post_data['nextPartitionKey'] = $params['nextPartitionKey'];
        }
        if(isset($params['nextRowKey']) && !empty($params['nextRowKey'])) {
            $post_data['nextRowKey'] = $params['nextRowKey'];
        }
        // New Fields End
        $mydt11_remguc = "mark_to_be_del_".date('Ymdhis') . rand(5, getrandmax());

        $ret_xml = pegasus_curl_request_post($this->url, $post_data);
        $xml_obj = simplexml_load_string($ret_xml);

        //debug 
        peg_mydt_debugs_logs('apiRequestDocs', print_r($post_data,true) , $ret_xml);

        // if( $xml_obj->code == 200){
            // if(isset($xml_obj->AADEXMLResponse->RequestedDoc->continuationToken)) {
            //     $next_partition_key = (string) $xml_obj->AADEXMLResponse->RequestedDoc->continuationToken->nextPartitionKey;
            //     $next_row_key       = (string) $xml_obj->AADEXMLResponse->RequestedDoc->continuationToken->nextRowKey;
            //     if( !empty($next_partition_key) && !empty($next_row_key) ){
            //         $params['nextPartitionKey']  = $next_partition_key;
            //         $params['nextRowKey']        = $next_row_key;
            //         $this->_invoiceDoc_get00($records_added , $records_deleted ,$p_mydt10tot, $params);  
            //     }
            // }
        // }

        

        if( $xml_obj->code != 210 and $xml_obj->code != 200){
            $msg = (string) $xml_obj->AADEXMLResponse->Message ;
            throw new Exception( '<pre>' . $msg . '</pre>' );
        } 
        // return; // uncomment to debug without updating db.
       
        if( $xml_obj->code == 200){
            $mydt11_remguc = "m2del_". date('Ymdhis') . "_" . rand(5, getrandmax());

            foreach($xml_obj->AADEXMLResponse->RequestedDoc->invoicesDoc->invoice as $invoice){

                if(!empty($invoice->cancelledByMark)) {
                    continue;
                }

                $uid  = (string) $invoice->uid;
                $mark = (string) $invoice->mark;

                $arr1 = array();  $arr2 = array();
                array_push($arr1 , 'p00'); array_push($arr2 , '2');
                array_push($arr1 , 'p01'); array_push($arr2 , '2');
                array_push($arr1 , 'p09'); array_push($arr2 , '1');

                array_push($arr1 , 'uid');  array_push($arr2 , $uid);
                array_push($arr1 , 'mark'); array_push($arr2 , $mark);
               
                array_push($arr1 , 'user_id');       array_push($arr2 , (string) $this->last_login_my_data_user_id);

                //* Γεμίζει όταν έχω συνδεθεί με στοιχεία από ομάδα καταστήματος η οποία έχει μόνο ένα κατάστημα.
                if(!empty($this->last_login_user_id_store)) {
                    array_push($arr1 , 'p03');       array_push($arr2 , (string) $this->last_login_user_id_store);
                }

                array_push($arr1 , 'is_vat');       array_push($arr2 , (string) $invoice->issuer->vatNumber);
                array_push($arr1 , 'is_country');   array_push($arr2 , (string) $invoice->issuer->country);
                array_push($arr1 , 'is_branch');    array_push($arr2 , (string) $invoice->issuer->branch);
                array_push($arr1 , 'is_address');   array_push($arr2 , (string) $invoice->issuer->address->street);
                array_push($arr1 , 'is_zip');       array_push($arr2 , (string) $invoice->issuer->address->postalCode);
                array_push($arr1 , 'is_city');      array_push($arr2 , (string) $invoice->issuer->address->city);

                array_push($arr1 , 'cp_vat');       array_push($arr2 , (string) $invoice->counterpart->vatNumber);
                array_push($arr1 , 'cp_country');   array_push($arr2 , (string) $invoice->counterpart->country);
                array_push($arr1 , 'cp_branch');    array_push($arr2 , (string) $invoice->counterpart->branch);
                array_push($arr1 , 'cp_address');   array_push($arr2 , (string) $invoice->counterpart->address->street);
                array_push($arr1 , 'cp_zip');       array_push($arr2 , (string) $invoice->counterpart->address->postalCode);
                array_push($arr1 , 'cp_city');      array_push($arr2 , (string) $invoice->counterpart->address->city);

                array_push($arr1 , 'series');       array_push($arr2 , (string) $invoice->invoiceHeader->series);
                array_push($arr1 , 'aa');           array_push($arr2 , (string) $invoice->invoiceHeader->aa);
                array_push($arr1 , 'issuedate');    array_push($arr2 , (string) $invoice->invoiceHeader->issueDate);
                array_push($arr1 , 'invtype');      array_push($arr2 , (string) $invoice->invoiceHeader->invoiceType);
                array_push($arr1 , 'vatpaysusp');   array_push($arr2 , (string) $invoice->invoiceHeader->vatPaymentSuspension);
                array_push($arr1 , 'currency');     array_push($arr2 , (string) $invoice->invoiceHeader->currency);
                array_push($arr1 , 'exchrate');     array_push($arr2 , (string) $invoice->invoiceHeader->exchangeRate);
                array_push($arr1 , 'correlinv');    array_push($arr2 , (string) $invoice->invoiceHeader->correlatedInvoices);
                array_push($arr1 , 'slfpricing');   array_push($arr2 , (string) $invoice->invoiceHeader->selfPricing==false ? 0 : 1 );
                array_push($arr1 , 'fuelinv');      array_push($arr2 , (string) $invoice->invoiceHeader->fuelInvoice==false ? 0 : 1 );
                
                array_push($arr1 , 'dispdate');     array_push($arr2 , (string) $invoice->invoiceHeader->dispatchDate);
                array_push($arr1 , 'disptime');     array_push($arr2 , (string) $invoice->invoiceHeader->dispatchTime);
                array_push($arr1 , 'mvpurpose');    array_push($arr2 , (string) $invoice->invoiceHeader->movePurpose);
                array_push($arr1 , 'vehiclenum');   array_push($arr2 , (string) $invoice->invoiceHeader->vehiclenum);
                array_push($arr1 , 'paytype');      array_push($arr2 , (string) $invoice->paymentMethods->paymentMethodDetails->type);

                array_push($arr1 , 'tnetvalue');      array_push($arr2 , (string) $invoice->invoiceSummary->totalNetValue);
                array_push($arr1 , 'tvat_am');        array_push($arr2 , (string) $invoice->invoiceSummary->totalVatAmount);
                array_push($arr1 , 'twthhld_am');     array_push($arr2 , (string) $invoice->invoiceSummary->totalWithheldAmount);
                array_push($arr1 , 'tfees_am');       array_push($arr2 , (string) $invoice->invoiceSummary->totalFeesAmount);
                array_push($arr1 , 'tstamp_am');      array_push($arr2 , (string) $invoice->invoiceSummary->totalStampDutyAmount);
                array_push($arr1 , 'ttax_am');        array_push($arr2 , (string) $invoice->invoiceSummary->totalOtherTaxesAmount);
                array_push($arr1 , 'tdeduction');     array_push($arr2 , (string) $invoice->invoiceSummary->totalDeductionsAmount);
                array_push($arr1 , 'tgross_val');     array_push($arr2 , (string) $invoice->invoiceSummary->totalGrossValue);

                array_push($arr1 , 'ddate');     array_push($arr2 , '0100-01-01');
                array_push($arr1 , 'dmark');     array_push($arr2 , '');
                array_push($arr1 , 'p05');       array_push($arr2 , '');
 
                array_push($arr1, 'remguc');            array_push($arr2, $p_mydt10tot);
                $uid  = $invoice->uid;
                $mark = $invoice->mark;
                $mydt10_nr01 = pegasus_mysql_printfld('mydt10', 'nr01', "p09=1 && p00=2 && uid=:uid", array('uid' => $uid));
                
                $records_added++;
                if ( !($mydt10_nr01 > 0) ) {
                    $mydt10_nr01 = pegasus_mysql_newrec('mydt10');
                    array_push($arr1 , 'nr01');     array_push($arr2 , $mydt10_nr01);
                    pegasus_mysql_insert('mydt10', $arr1, $arr2);
                } else {
                    pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1,  array('nr01' => $mydt10_nr01));


                    // Aν ξαναπαραλάβω το παραστατικό τότε ελεγχω αν mark που παρελαβα ειναι μεγαλυτερο και αν ναι σβηνω το mark του χαρακτηρισμού.
                    $sql = "update mydt10 as mydt10_from_pegasus 
                                join mydt10 as mydt10_from_mydata on mydt10_from_mydata.rel_nr=mydt10_from_pegasus.nr01 

                                set 
                                    mydt10_from_pegasus.entuid='',
                                    mydt10_from_pegasus.p02=0,
                                    mydt10_from_pegasus.mark = mydt10_from_mydata.mark,
                                    mydt10_from_pegasus.remdate =  curdate(),
                                    mydt10_from_pegasus.remtime =  curtime()

                                where mydt10_from_mydata.nr01=:nr01 and mydt10_from_pegasus.mark<:mark and mydt10_from_pegasus.entuid!=''; ";


                    
                    pegasus_query( $sql , array("mark" =>  $mark /* το μαρκ που παρέλαβα*/, "nr01" => $mydt10_nr01 /* το mydt10.nr01 του παραστατικού που παρελαβα απο το mydata */));            

                    //echo pegasus_replace_values_in_sql($sql , array("mark" =>  $mark /* το μαρκ που παρέλαβα*/, "nr01" => $mydt10_nr01 /* το mydt10.nr01 του παραστατικού που παρελαβα απο το mydata */));

                }

                /**
                 * Rollback: Μπορώ να έχω cancelledByMark χωρίς ακύρωση, αν π.χ. έχω ξαναστείλει το ίδιο παραστατικό
                 */
                // if(!empty($invoice->cancelledByMark)) {
                //     $cancelledByMark = (string) $invoice->cancelledByMark;
                //     $deleted = $this->_update_cancelled_invoice($mark, $cancelledByMark);
                //     if($deleted === true) {
                //         $records_deleted++;
                //     }
                // }
                

                //Μαρκαρω τις εγγραφες για διαγραφη γιατι ενα παραστατικό μπορει να το βρω πολλες φορες και να εχουν αλλαξιε οι γραμμες του
                pegasus_mysql_update('mydt11', array('remguc'), array( $mydt11_remguc ), 'mydt10=:mydt10', 0, 1, 1,  array('mydt10' => $mydt10_nr01));

                foreach( $invoice->invoiceDetails as $invoiceDetails){

                    $arr1 = array();  $arr2 = array();
                    array_push($arr1 , 'mydt10');       array_push($arr2 , $mydt10_nr01);
                    array_push($arr1 , 'linenumber');   array_push($arr2 , $invoiceDetails->lineNumber);
                    array_push($arr1 , 'munit');        array_push($arr2 , $invoiceDetails->measurementUnit);
                    array_push($arr1 , 'netValue');     array_push($arr2 , $invoiceDetails->netValue);
                    array_push($arr1 , 'fpavalue');     array_push($arr2 , $invoiceDetails->vatAmount);                    
                    array_push($arr1 , 'vatcat');       array_push($arr2 , $invoiceDetails->vatCategory );
                    array_push($arr1 , 'discoption');   array_push($arr2 , $invoiceDetails->discountOption == false ? 0 :1 );
                    array_push($arr1 , 'wthhld_am');    array_push($arr2 , $invoiceDetails->withheldAmount );
                    array_push($arr1 , 'wthhldpcat');   array_push($arr2 , $invoiceDetails->withheldPercentCategory );
                    array_push($arr1 , 'otaxpcat');     array_push($arr2 , $invoiceDetails->otherTaxesPercentCategory );
                    array_push($arr1 , 'otax_am');      array_push($arr2 , $invoiceDetails->otherTaxesAmount );
                    array_push($arr1 , 'quantity');     array_push($arr2 , $invoiceDetails->quantity );
                    array_push($arr1 , 'vatexcat');     array_push($arr2 , $invoiceDetails->vatExemptionCategory );
                    array_push($arr1 , 'stamppcat');    array_push($arr2 , $invoiceDetails->stampDutyPercentCategory );
                    array_push($arr1 , 'fees_am');      array_push($arr2 , $invoiceDetails->feesAmount );
                    array_push($arr1 , 'feestype');     array_push($arr2 , $invoiceDetails->feesPercentCategory );
                    array_push($arr1 , 'comments');     array_push($arr2 , $invoiceDetails->lineComments );
                    array_push($arr1 , 'fuelcode');     array_push($arr2 , $invoiceDetails->fuelCode );
                    array_push($arr1 , 'itemcode');     array_push($arr2 , $invoiceDetails->itemCode );
                    array_push($arr1 , 'itemdescr');    array_push($arr2 , $invoiceDetails->itemDescr );
                    
                    array_push($arr1 , 'remguc');       array_push($arr2 , '');

                    $mydt11_nr01 = pegasus_mysql_printfld('mydt11', 'nr01', "mydt10=:mydt10 && linenumber=:linenumber", array('mydt10' => $mydt10_nr01, 'linenumber' => $invoiceDetails->lineNumber));
                    if(!$mydt11_nr01>0){
                        $mydt11_nr01 = pegasus_mysql_newrec('mydt11');
                        array_push($arr1 , 'nr01');     array_push($arr2 , $mydt11_nr01);
                        pegasus_mysql_insert('mydt11', $arr1, $arr2);
                    } else {
                        pegasus_mysql_update('mydt11', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1,  array('nr01' => $mydt11_nr01));
                    }
                }
            }

            //Διαγραφω τα mydt10 που δεν βρηκα (δεν τα καναμε ποτε update)
             pegasus_mysql_delete('mydt11' , 'remguc=:remguc', 1 ,  array('remguc' => $mydt11_remguc) );


            foreach($xml_obj->AADEXMLResponse->RequestedDoc->cancelledInvoicesDoc->cancelledInvoice as $cancelledInvoice){

                // <invoiceMark>400000128073484</invoiceMark>
                // <cancellationMark>400000144711332</cancellationMark>
                // <cancellationDate>2021-10-13</cancellationDate>
                // //var_dump( $invoice);
                $invoiceMark  = (string) $cancelledInvoice->invoiceMark;
                $cancellationMark = (string) $cancelledInvoice->cancellationMark;
                $cancellationDate = (string) $cancelledInvoice->cancellationDate;

                $deleted = $this->_update_cancelled_invoice($invoiceMark, $cancellationMark, $cancellationDate);
                if($deleted === true) {
                    $records_deleted++;
                }

            }

            //! Προηγούμενη λογική με mark από βάση
            // if( !empty($mark) ){
            //     $this->_invoiceDoc_get00($mark , $records_added , $records_deleted ,$p_mydt10tot);  
            // }
            //! Νέα λογική με continuationToken (nextPartitionKey, nextRowKey)
            if(isset($xml_obj->AADEXMLResponse->RequestedDoc->continuationToken)) {
                $next_partition_key = (string) $xml_obj->AADEXMLResponse->RequestedDoc->continuationToken->nextPartitionKey;
                $next_row_key       = (string) $xml_obj->AADEXMLResponse->RequestedDoc->continuationToken->nextRowKey;
                if( !empty($next_partition_key) && !empty($next_row_key) ){
                    $params['nextPartitionKey']  = $next_partition_key;
                    $params['nextRowKey']        = $next_row_key;
                    $this->_invoiceDoc_get00($records_added , $records_deleted ,$p_mydt10tot, $params);  
                }
            }
        }



    }

    private function _update_cancelled_invoice($invoiceMark, $cancellationMark, $cancellationDate) {
        
        //Removed - Δεν το χρειαζόμαστε πλέον εφόσον βγάλαμε την ενημέρωση από cancelledByMark
        // if(!empty($cancellationDate)) {
        //     // Αν έχει ενημερωθεί από "cancelledByMark" και την βρω και εδώ, θέλω να ενημερώσω το cancellationDate.
        //     pegasus_mysql_use("SELECT * FROM mydt10 WHERE mark=:mark AND p09=1 AND dmark=:dmark AND ddate<>:ddate" , $mydt10_0000 , array("mark" =>  $invoiceMark, "dmark" => $cancellationMark, "ddate" => $cancellationDate));
            
        //     $arr1 = array('tbl');  $arr2 = array('');
        //     array_push($arr1 , 'ddate');     array_push($arr2 , $cancellationDate);
        //     pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1,  array('nr01' => $mydt10_0000['nr01']));
        // }


        pegasus_mysql_use("SELECT * FROM mydt10 WHERE mark=:mark AND p09=1 AND dmark=''" , $mydt10_000 , array("mark" =>  $invoiceMark));
        if($mydt10_000['nr01']>0){
            // update παραστατικο pigasoy
            $arr1 = array('mark');  $arr2 = array('');
            array_push($arr1 , 'uid');     array_push($arr2 , '');
            pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1,  array('nr01' => $mydt10_000['rel_nr']));

            // update παραστατικο myDATA
            $arr1 = array('tbl');  $arr2 = array('');
            array_push($arr1 , 'tbl_nr01');     array_push($arr2 , 0);
            array_push($arr1 , 'rel_nr');       array_push($arr2 , 0);
            array_push($arr1 , 'p05');          array_push($arr2 , 1);
            
            array_push($arr1 , 'dmark');        array_push($arr2 , $cancellationMark);
            array_push($arr1 , 'ddate');        array_push($arr2 , $cancellationDate);

            //Removed - Eφόσον βγάλαμε την ενημέρωση από cancelledByMark, εδώ ερχόμαστε πάντα με $cancellationDate γεμάτο.
            // if(!empty($cancellationDate)) {
            //     array_push($arr1 , 'ddate');    array_push($arr2 , $cancellationDate);
            // }else{
            //     array_push($arr1 , 'ddate');    array_push($arr2 , date('Y-m-d'));
            // }
            
            pegasus_mysql_update('mydt10', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1,  array('nr01' => $mydt10_000['nr01']));

            
            return true;
        }else{
            return false;
        }
    }

    private function _read_sql($sql){
        $sql = peg_read_file($sql);
        return  $sql;
    }    

    private function _setUrl(){

        
        try {
            $json_response = pegasus_curl_request('https://services00.pegcloud.io/is_alive.php', false,  array(), array(CURLOPT_TIMEOUT => 4));
        } catch (Exception $ex) {
            $json_response = false;
        }
        
        if( !empty($json_response) and  $json_response == 'true') {
            $this->url = "https://services00.pegcloud.io/my_data/execute.php";
        }else{
            $this->url = "https://services.tesae.gr/my_data/execute.php";
        }
    }
    

    /**
     * $type =  1=incomes , 2=expenses
     * 
     */
    public function classification_send($XML_string , $type , $nr01 , $mydt01_nr01 , $postPerInvoice=false ){


        if($type==1){
            $isLogistis=0;
        }else{
            $isLogistis=1;
        }

        $ret_array = $this->login($mydt01_nr01 , $isLogistis);
        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Login:' . $ret_array['msg'];
            return $ret_array;
        }

        $post_data= array();
        $post_data['action'] = $type==1 ? 'apiIncomeClassification' : 'apiExpensesClassification';
        $post_data['XML']    = $XML_string;
        $post_data['sid']    = $this->sid;

        if($postPerInvoice == true){
            $post_data['postPerInvoice'] = true;  
        }

        $ret_xml = pegasus_curl_request_post($this->url, $post_data);

        //debug 
        peg_mydt_debugs_logs($post_data['action'] ,  print_r($post_data, true) , $ret_xml);

        // echo  $ret_xml ;
        $xml_obj = simplexml_load_string($ret_xml);
 

        $ret_array = $this->logout();
        if(!$ret_array['ok']==1){
            $ret_array['msg'] =  'Logout:' . $ret_array['msg'];
             return $ret_array;
        }


        //var_dump( $xml_obj );
        $ok = 1;
        $msg = '';
        if( $xml_obj->code == 208 || $xml_obj->code == 209 || $xml_obj->code == 210 ){
             $ok = 0;
             $msg = '';
             foreach($xml_obj->AADEXMLResponse->response->errors->error as $error){
                 $msg .= '(1) Code:' . $error->code . ' ' .  $error->message . '<br>';
             }

        }elseif( $xml_obj->code == 401){
           $ok = 0;
           $msg = $_SESSION['peg_dic_mydt_classification_send_error'];
        }
        elseif( $xml_obj->code != 210){
            $ok = 0;
            $msg = '(2) ' . $xml_obj->AADEXMLResponse->response->Message;
        }

        //Success 
        if($xml_obj->code == 210){
            $ok = 1;
            $msg = "";
            foreach($xml_obj->AADEXMLResponse->response as $resp){
                // echo '<pre>'. print_r($resp,true).'</pre>';
                if($resp->statusCode == 'Success'){
                    $arr1 = array();  $arr2 = array();
                    array_push($arr1 , 'p30');    array_push($arr2 , '');
                    array_push($arr1 , 'p04');    array_push($arr2 , '');
                    array_push($arr1 , 'entuid'); array_push($arr2 , $resp->classificationMark);
                    array_push($arr1 , 'p02'); array_push($arr2 , 1);
                    array_push($arr1 , 'p02_1'); array_push($arr2 , 0);
                    
                    pegasus_mysql_update('mydt10' , $arr1 , $arr2 , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $nr01 ));

                    $ok =  1;
                    //$msg = "classifiacation successed -> " .   $nr01;
                    $msg = str_replace('##nr01##' , $nr01 , $_SESSION['peg_dic_mydt_mydt10_classification_successed'] );

                }else{
                    $p30='';
                    foreach ($resp->errors->error as $error) {
                        $p30.= 'Code:' . $error->code . ' ' .  $error->message  . "\n";
                    }
                    pegasus_mysql_update('mydt10' , array('p30') , array($p30) , "nr01=:nr01" , 0 , 1 , 1 , array('nr01' => $nr01));

                    $ok =  0;
                    $msg = str_replace('##nr01##' , $nr01 , $_SESSION['peg_dic_mydt_mydt10_classification_failed'] . '<br> (' . $p30 . ')');
                    
                }
            } 
        }
        return array('ok' => $ok , 'msg' => $msg);
    }
    
}

?>