insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t, 
currency, exchrate, slfpricing,
mvpurpose, vatpaysusp, 
vehiclenum, spinvcat, invvarty,
series, aa, issuedate, issuetime, invtype, paytype,  
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01, 
dispdate, disptime, ldstreet, ldzip, ldnumber, ldcity, dlvstreet, dlvzip, dlvnumber, dlvcity,
ss_branch, cs_branch, isdlvno, cp_p600, othmvpur, tableaa, tcdord, p103, 
/*v1.105*/ p_notes )

SELECT tbl as tbl, 
       tbl_nr01 as tbl_nr01, 
       p00 as p00, 
       p01 as p01, 
       p03 as p03, 
       p06 as p06, 
       p07 as p07, 
       p08d as p08d, 
       p08t as p08t, 
       currency as currency, 
       exchrate as exchrate, 
       slfpricing as slfpricing,       
       mvpurpose as mvpurpose,
       vatpaysusp as vatpaysusp,      
       vehiclenum as vehiclenum,
       spinvcat   as spinvcat,
       invvarty   as invvarty,
      
       if(  if( mydt00_p103=1 || invtype='8.6', 
                concat(series_1, if(series_2='', '', '-'), series_2), 
                series_2
              )='', '0', 
            if( mydt00_p103=1 || invtype='8.6', 
                concat(series_1, if(series_2='', '', '-'), series_2), 
                series_2
              )  
         )  as series, 
      aa as aa,

       issuedate as issuedate, 
       issuetime as issuetime, 
       invtype as invtype, 
       paytype as paytype, 
       
       ''             as is_country,
       '{nt_p101[1]}' as is_vat, 
       '{nt_p101[2]}' as is_name, 
       '{nt_p101[3]}' as is_address, 
       '{nt_p101[4]}' as is_city, 
       '{nt_p101[5]}' as is_zip,

       '{nt_p101[6]}' as is_tbl,
       '{nt_p101[7]}' as is_nr01,
       a_country as cp_country,
       a_vat     as cp_vat, 
       a_name    as cp_name, 
       a_address as cp_address, 
       a_city    as cp_city, 
       a_zip     as cp_zip, 
       a_tbl     as cp_tbl, 
       a_nr01    as cp_nr01, 

       dispdate  as dispdate,
       disptime  as disptime,

       ldstreet   as ldstreet, 
       ldzip      as ldzip, 
       ldnumber   as ldnumber, 
       ldcity     as ldcity,
       dlvstreet  as dlvstreet, 
       dlvzip     as dlvzip, 
       dlvnumber  as dlvnumber, 
       dlvcity    as dlvcity,
       /*v1.88*/
       ss_branch  as ss_branch, 
       cs_branch  as cs_branch,        
       isdlvno    as isdlvno,
       cp_p600    as cp_p600 ,
       othmvpur   as othmvpur, 
       tableaa    as tableaa, 
       tcdord     as tcdord,  
       if(p103_1<>'', p103_1, if(p103_2<>'', p103_2, p103_3)) as p103, 
       /*v1.105*/
       p_notes as p_notes

FROM
(
      /***********************************************
             Παραστατικά προς αποστολή
             q30.nr01=620014
      ***********************************************/
      (
      SELECT 'a55' as tbl, 
             a55.nr01 as tbl_nr01, 
             1 as p00,
             1 as p01,
             a55.p0121 as p03, 
             a55.p09 as p06, 
             ifnull(a10.p04, 0) as p07, 
             a55.remdate as p08d, 
             a55.remtime as p08t,
             ifnull(t12.p05, '') as currency, 
             a55.pn02 as exchrate,
             ifnull(a10.p013, 0) as slfpricing,

             ifnull( (select q31_in.p05
                      from q31 as q31_in, 
                           erpa13 as erpa13_in
                      where q31_in.p01=620057
                         && q31_in.p03=erpa13_in.nr01
                         && erpa13_in.p01=a55.p012
                      limit 1), '') as mvpurpose,
             a55.p807 as vatpaysusp,      
             
             a55.p702 as vehiclenum,
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620061
                         && q31_in.p03=a10.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620062
                         && q31_in.p03=a10.p01
                      limit 1), '') as invvarty,
             
             /**στοιχεία παραστατικού*/
             /*v1.77*/
             ifnull(a10.p00, '') as series_1, 
             a55.p701 as series_2,             
             ifnull(mydt00.p103, 0) as mydt00_p103,
                             
             a55.p06  as aa, 
             a55.p01 as issuedate, 
             a55.p02 as issuetime, 
             
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620068
                         && q31_in.p03=a10.p01
                      limit 1), 
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620014
                         && q31_in.p03=a10.p01
                      limit 1), '')) as invtype,

             if((i15.p04 - i15.p03 != 0) 
               && (ifnull( (select 1
                  from q31 as q31_in
                  where q31_in.p01=620068
                     && q31_in.p03=a10.p01
                  limit 1), 0 ) = 1), 1, 0) as isdlvno,
                               
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=a55.p015
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a71.p603_1, ifnull(d23.p01, '')) as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a71.p603, ifnull(a01.p4, '')) as a_address, 
             ifnull(a71.p605, concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   )) as a_city, 
             ifnull(a71.p604, ifnull(a01.p7, '')) as a_zip,
             if(ifnull(a71.nr01, 0)>0, 'a71', 'a01') as a_tbl,
             ifnull(a71.nr01, ifnull(a01.nr01, 0)) as a_nr01,
             
             if(a55.d_p01 > cast('0100-01-01' as date) , a55.d_p01 , cast('0100-01-01' as date)) as dispdate,
             if(a55.d_p02 = '', '', concat(a55.d_p02, ':00')) as disptime,
             
             /*v1.88*/
             a55.ldstreet  as ldstreet, 
             a55.ldzip     as ldzip, 
             a55.ldnumber  as ldnumber, 
             a55.ldcity    as ldcity,
             a55.dlvstreet as dlvstreet, 
             a55.dlvzip    as dlvzip, 
             a55.dlvnumber as dlvnumber, 
             a55.dlvcity   as dlvcity,
             a55.ss_branch as ss_branch, 
             a55.cs_branch as cs_branch, 
                   
             ##a55_cp_p600_from_oil## as cp_p600,             
            /*v1.81*/
            if(a55.p012='', 'Πώληση', a55.p012) as othmvpur,
             
            /**start_module_exists_estiasi**/
            ifnull( (select este51.p01 
                        from a55 as a55_este
                        join i01 as i01_este on a55_este.nr01 = i01_este.p06 and i01_este.p07=2 
                        join este03  on i01_este.pd101  = 'este03' and i01_este.pd102=este03.nr01
                        JOIN este02  on este02.nr01 = este03.p01
                        JOIN este01  on este01.nr01 = este02.p00
                        JOIN este51  on este01.p01  = este51.nr01
                        where a55_este.nr01=a55.nr01 
                        limit 1), '') as tableaa,
            /**end_module_exists_estiasi**/
            /**start_module_not_exists_estiasi**/
            '' as tableaa,
            /**end_module_not_exists_estiasi**/             

           0  as tcdord, 
           if(ifnull(a55.p08, 0)=0, ifnull(a10.p08, ''),    '') as p103_1, 
           if(ifnull(a55.p08, 0)=0, ifnull(a10_ak.p08, ''), '') as p103_2, 
           if(ifnull(a55.p08, 0)=0, ifnull(f02.p010, ''),   '') as p103_3, 
           
           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a55.p011<>'', 
                         concat(a55.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a55.p30, '')<>'', 
                         concat(ifnull(a55.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes        
            
      FROM q31
      LEFT JOIN a10 ON q31.p03=a10.p01
      LEFT JOIN a55 ON a55.p05=a10.p01
                    && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    
                    ##start_module_exist_stores##
                    && a55.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   
              
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=a55.p03
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      LEFT JOIN d23 ON d23.p01=a01.p4_1
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN i15 ON i15.p01 = a10.p05
      LEFT JOIN i16 ON i16.p00 = a55.p703
      LEFT JOIN t12 ON t12.p01=a55.pn01
      LEFT JOIN a71 ON a71.p601 = a01.nr01
                    && a71.nr01=a55.p04 
      LEFT JOIN a10 as a10_ak on a10_ak.p01=a55.p414
                              && a55.p414<>0
      LEFT JOIN f02 on f02.nr01=1
      ##start_module_exist_oil##
      LEFT JOIN oila04 ON oila04.p00 = a01.nr01               
      LEFT JOIN oila10 ON oila10.p00 = a71.nr01               
      ##end_module_exist_oil## 
      WHERE q31.p01 in (620014 , 620068)
         && a55.nr01 is not null
         && a10.nr01 is not null
         && a55.p414=0
         && a55.p601a=0
         && a55.pweb01=0
         && {p_mydt10where} 
         && {nt_napost}=1
      GROUP BY a55.nr01
      )
      
      UNION ALL

      /*v1.74*/
      /***********************************************
             Ειδικό Ακυρωτικό 
             Παραστατικά προς αποστολή
             (μόνο για τα 8.6 που πήγαν πάροχο)
             q30.nr01=620014
      ***********************************************/
      (
      SELECT 'a55' as tbl, 
             a55.nr01 as tbl_nr01, 
             1 as p00,
             1 as p01,
             a55.p0121 as p03, 
             a55.p09 as p06, 
             ifnull(a10.p04, 0) as p07, 
             a55.remdate as p08d, 
             a55.remtime as p08t,
             ifnull(t12.p05, '') as currency, 
             a55.pn02 as exchrate,
             ifnull(a10.p013, 0) as slfpricing,
             ifnull( (select q31_in.p05
                      from q31 as q31_in, 
                           erpa13 as erpa13_in
                      where q31_in.p01=620057
                         && q31_in.p03=erpa13_in.nr01
                         && erpa13_in.p01=a55.p012
                      limit 1), '') as mvpurpose,
             a55.p807 as vatpaysusp,      
             
             a55.p702 as vehiclenum,
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620061
                         && q31_in.p03=a10.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620062
                         && q31_in.p03=a10.p01
                      limit 1), '') as invvarty,
             
             /**στοιχεία παραστατικού - βάζουμε πάντα το λεκτικό στην σειρά στο ακυρωτικό */
             ifnull(a10_can.p00, '') as series_1, 
             a55.p701 as series_2,             
             ifnull(mydt00.p103, 0) as mydt00_p103,
             
             a55.p06  as aa, 
             a55.p01 as issuedate, 
             a55.p02 as issuetime, 
             
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620068
                         && q31_in.p03=a10.p01
                      limit 1), 
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620014
                         && q31_in.p03=a10.p01
                      limit 1), '')) as invtype,

             if((i15.p04 - i15.p03 != 0) 
               && (ifnull( (select 1
                  from q31 as q31_in
                  where q31_in.p01=620068
                     && q31_in.p03=a10.p01
                  limit 1), 0 ) = 1), 1, 0) as isdlvno,
                               
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=a55.p015
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a71.p603_1, ifnull(d23.p01, '')) as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a71.p603, ifnull(a01.p4, '')) as a_address, 
             ifnull(a71.p605, concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   )) as a_city, 
             ifnull(a71.p604, ifnull(a01.p7, '')) as a_zip,
             if(ifnull(a71.nr01, 0)>0, 'a71', 'a01') as a_tbl,
             ifnull(a71.nr01, ifnull(a01.nr01, 0)) as a_nr01,
             
             if(a55.d_p01 > cast('0100-01-01' as date) , a55.d_p01 , cast('0100-01-01' as date)) as dispdate,
             if(a55.d_p02 = '', '', concat(a55.d_p02, ':00')) AS disptime,
             
             /*v1.88*/
             a55.ldstreet  as ldstreet, 
             a55.ldzip     as ldzip, 
             a55.ldnumber  as ldnumber, 
             a55.ldcity    as ldcity,
             a55.dlvstreet as dlvstreet, 
             a55.dlvzip    as dlvzip, 
             a55.dlvnumber as dlvnumber, 
             a55.dlvcity   as dlvcity,
             a55.ss_branch as ss_branch, 
             a55.cs_branch as cs_branch, 

             ##a55_cp_p600_from_oil## as cp_p600,             
             if(a55.p012='', 'Πώληση', a55.p012) as othmvpur,
             
             /**start_module_exists_estiasi**/
             ifnull( (select este51.p01 
                        from a55 as a55_este
                        join i01 as i01_este on a55_este.nr01 = i01_este.p06 and i01_este.p07=2 
                        join este03  on i01_este.pd101  = 'este03' and i01_este.pd102=este03.nr01
                        JOIN este02  on este02.nr01 = este03.p01
                        JOIN este01  on este01.nr01 = este02.p00
                        JOIN este51  on este01.p01  = este51.nr01
                        where a55_este.nr01=a55.nr01 
                        limit 1), '') as tableaa,
            /**end_module_exists_estiasi**/
            /**start_module_not_exists_estiasi**/
            '' as tableaa,
            /**end_module_not_exists_estiasi**/             

           1  as tcdord, 
           if(ifnull(a55.p08, 0)=0, ifnull(a10.p08, ''),    '') as p103_1, 
           if(ifnull(a55.p08, 0)=0, ifnull(a10_ak.p08, ''), '') as p103_2, 
           if(ifnull(a55.p08, 0)=0, ifnull(f02.p010, ''),   '') as p103_3, 

           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a55.p011<>'', 
                         concat(a55.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a55.p30, '')<>'', 
                         concat(ifnull(a55.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes        
            
          
      FROM q31
      LEFT JOIN a10 ON q31.p03=a10.p01
      LEFT JOIN a55 ON a55.p414=a10.p01
                    && a55.p414<>0
                    && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    
                    ##start_module_exist_stores##
                    && a55.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   
      LEFT JOIN a55 as a55_canceled ON a55_canceled.p601a=a55.nr01              
                                    && a55_canceled.p601a<>0
      LEFT JOIN a10 as a10_can ON a10_can.p01=a55.p05
      LEFT JOIN mydt10 ON mydt10.tbl='a55'
                       && mydt10.tbl_nr01=a55_canceled.nr01
                       && mydt10.einv<>0
                       && mydt10.invtype='8.6'
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=a55.p03
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      LEFT JOIN d23 ON d23.p01=a01.p4_1
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN i15 ON i15.p01 = a10.p05
      LEFT JOIN i16 ON i16.p00 = a55.p703
      LEFT JOIN t12 ON t12.p01=a55.pn01
      LEFT JOIN a71 ON a71.p601 = a01.nr01
                    && a71.nr01=a55.p04      
      LEFT JOIN a10 as a10_ak on a10_ak.p01=a55.p414
                              && a55.p414<>0
      LEFT JOIN f02 on f02.nr01=1
      ##start_module_exist_oil##
      LEFT JOIN oila04 ON oila04.p00 = a01.nr01               
      LEFT JOIN oila10 ON oila10.p00 = a71.nr01               
      ##end_module_exist_oil## 
      WHERE q31.p01 in (620014 , 620068)
         && a55.nr01 is not null
         && a10.nr01 is not null
         && a55.p414<>0
         && a55.pweb01=0
         && a55.p08=0
         && mydt10.nr01 is not null
         && {p_mydt10where} 
         && {nt_napost}=1
      GROUP BY a55.nr01
      )
      
      UNION ALL

      /***********************************************
             Παραστατικά προς παραλαβή
             q30.nr01=620015
      ***********************************************/
      (
      SELECT 'a55' as tbl, 
             a55.nr01 as tbl_nr01, 
             1 as p00,
             2 as p01,
             a55.p0121 as p03, 
             a55.p09 as p06, 
             ifnull(a10.p04, 0) as p07, 
             a55.remdate as p08d, 
             a55.remtime as p08t,
             ifnull(t12.p05, '') as currency, 
             a55.pn02 as exchrate,
             ifnull(a10.p013, 0) as slfpricing,                    
             ifnull( (select q31_in.p05
                      from q31 as q31_in, 
                           erpa13 as erpa13_in
                      where q31_in.p01=620057
                         && q31_in.p03=erpa13_in.nr01
                         && erpa13_in.p01=a55.p012
                      limit 1), '') as mvpurpose,
             a55.p807 as vatpaysusp,      
             a55.p702 as vehiclenum,
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620061
                         && q31_in.p03=a10.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620062
                         && q31_in.p03=a10.p01
                      limit 1), '') as invvarty,

             /**στοιχεία παραστατικού*/
             ifnull(a10.p00, '') as series_1, 
             a55.p701 as series_2,             
             ifnull(mydt00.p103, 0) as mydt00_p103,
             a55.p06  as aa, 
             a55.p01 as issuedate, 
             a55.p02 as issuetime, 
             ifnull(mydt50.p00, '') as invtype, 
             
             0 as isdlvno,

             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=a55.p015
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a71.p603_1, ifnull(d23.p01, '')) as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a71.p603, ifnull(a01.p4, '')) as a_address, 
             ifnull(a71.p605, concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   )) as a_city, 
             ifnull(a71.p604, ifnull(a01.p7, '')) as a_zip,
             if(ifnull(a71.nr01, 0)>0, 'a71', 'a01') as a_tbl,
             ifnull(a71.nr01, ifnull(a01.nr01, 0)) as a_nr01,

             if(a55.d_p01 > cast('0100-01-01' as date) , a55.d_p01 , cast('0100-01-01' as date)) as dispdate,
             if(a55.d_p02 = '', '', concat(a55.d_p02, ':00')) AS disptime,

             /*v1.88*/
             a55.ldstreet  as ldstreet, 
             a55.ldzip     as ldzip, 
             a55.ldnumber  as ldnumber, 
             a55.ldcity    as ldcity,
             a55.dlvstreet as dlvstreet, 
             a55.dlvzip    as dlvzip, 
             a55.dlvnumber as dlvnumber, 
             a55.dlvcity   as dlvcity,
             a55.ss_branch as ss_branch, 
             a55.cs_branch as cs_branch, 

             ##a55_cp_p600_from_oil## as cp_p600,  
            if(a55.p012='', 'Πώληση', a55.p012) as othmvpur,
             
            /**start_module_exists_estiasi**/
            ifnull( (select este51.p01 
                        from a55 as a55_este
                        join i01 as i01_este on a55_este.nr01 = i01_este.p06 and i01_este.p07=2  
                        join este03  on i01_este.pd101  = 'este03' and i01_este.pd102=este03.nr01
                        JOIN este02  on este02.nr01 = este03.p01
                        JOIN este01  on este01.nr01 = este02.p00
                        JOIN este51  on este01.p01  = este51.nr01
                        where a55_este.nr01=a55.nr01
                        limit 1), '') as tableaa,
            /**end_module_exists_estiasi**/
            /**start_module_not_exists_estiasi**/
            '' as tableaa,
            /**end_module_not_exists_estiasi**/

           0  as tcdord,
           if(ifnull(a55.p08, 0)=0, ifnull(a10.p08, ''),    '') as p103_1, 
           if(ifnull(a55.p08, 0)=0, ifnull(a10_ak.p08, ''), '') as p103_2, 
           if(ifnull(a55.p08, 0)=0, ifnull(f02.p010, ''),   '') as p103_3, 
           
           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a55.p011<>'', 
                         concat(a55.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a55.p30, '')<>'', 
                         concat(ifnull(a55.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes        
                           
      FROM q31
      LEFT JOIN a10 ON q31.p03=a10.p01
      LEFT JOIN a55 ON a55.p05=a10.p01
                    && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    
                    ##start_module_exist_stores##
                    && a55.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   
                   
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=a55.p03
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      LEFT JOIN d23 ON d23.p01=a01.p4_1
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN i15    ON i15.p01 = a10.p05
      LEFT JOIN i16    ON i16.p00 = a55.p703
      LEFT JOIN t12 ON t12.p01=a55.pn01
      LEFT JOIN a71 ON a71.p601 = a01.nr01
                    && a71.nr01=a55.p04      
      LEFT JOIN a10 as a10_ak on a10_ak.p01=a55.p414
                              && a55.p414<>0
      LEFT JOIN f02 on f02.nr01=1
      ##start_module_exist_oil##
      LEFT JOIN oila04 ON oila04.p00 = a01.nr01               
      LEFT JOIN oila10 ON oila10.p00 = a71.nr01               
      ##end_module_exist_oil## 
      WHERE q31.p01=620015
         && a55.nr01 is not null
         && a10.nr01 is not null
         && a55.p414=0
         && a55.p601a=0
         && a55.p601a=0
         && a55.pweb01=0
         && {p_mydt10where} 
         && {nt_nparal}=1
      GROUP BY a55.nr01
      )

) as tbl01
where tbl_nr01 is not null
   && tbl is not null
group by tbl, tbl_nr01;
/*peg_end*/

/*******************************************
    Συσχετιζόμενα από το hotel
*******************************************/
/**start_module_exist_hot000**/
update 
       {p_mydt10tbl1},
       (select concat('#' , group_concat(DISTINCT(a55_00.nr01) SEPARATOR '#') , '#') as pcor,
               'a55' as tbl, 
                a55.nr01 as tbl_nr01
        from a55
        join i01 on i01.p06=a55.nr01 and i01.p07=2  
        left join hota17 on i01.pd101='hota17' and i01.pd102=hota17.nr01
        left join hota04 on (i01.pd101='hota04' and i01.pd102=hota04.nr01)
        /**end_module_exist_hot000**/ 
        /**pegasus_module_exists_start_hot002**/
         left join hota14 on (hota04.p050 = hota14.nr01)
         left join hot002_01 on (hot002_01.hota14 = hota14.nr01)
         /**pegasus_module_exists_end_hot002**/
         /**start_module_exist_hot000**/
        join i01 as i01_00 on ( i01_00.pd101='hota17' and i01_00.pd102=hota17.nr01) 
                           or (i01_00.pd101='hota04' and i01_00.pd102=hota04.nr01) 
                           or (i01_00.pd101='hota04' and i01_00.pd102=hota17.pnr01)
                           /**end_module_exist_hot000**/
                            /**pegasus_module_exists_start_hot002**/
                           or ( i01_00.pd101='hota002_01' and i01_00.pd102=hot002_01.nr01) 
                            /**pegasus_module_exists_end_hot002**/
         /**start_module_exist_hot000**/
        join a55 as a55_00 on i01_00.p06=a55_00.nr01 and i01_00.p07=2  and a55_00.nr01!=a55.nr01 and a55_00.p601a=0 and a55_00.p414=0 and a55_00.pweb01=0
        where a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
           && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
           && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
           && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
           && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
           && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
           && a55.pweb01=0
           && {p_mydt10where}
        group by tbl,tbl_nr01)  as tbl_a55 
set {p_mydt10tbl1}.pcor = tbl_a55.pcor
where {p_mydt10tbl1}.tbl = tbl_a55.tbl 
   && {p_mydt10tbl1}.tbl_nr01 = tbl_a55.tbl_nr01;
/**end_module_exist_hot000**/ 
/*peg_end*/ 



/*******************************************
    Συσχετιζόμενα από το a55
*******************************************/
update {p_mydt10tbl1} as mydt10,
       (select ifnull(mydt10_in.tbl, '') as tbl,
               ifnull(mydt10_in.tbl_nr01, 0) as tbl_nr01,
               concat( if(ifnull(mydt10_in.pcor, '')='','#', mydt10_in.pcor) , group_concat(DISTINCT(a55_00.nr01) SEPARATOR '#') , '#') as pcor 
        from {p_mydt10tbl1} as mydt10_in 
        left join i01 on i01.p06=mydt10_in.tbl_nr01
                      && i01.p07=2  
        left join a55 as a55_arxiko on i01.p06=a55_arxiko.nr01 
                                    && i01.p07=2  
        left join i01 as i01_00 on i01_00.nr01=i01.p3051
        /*v1.23*/
        left join a55 as a55_00 on (    (i01_00.p06=a55_00.nr01 && i01_00.p07=2) 
                                    )  
                                 && a55_00.nr01<>mydt10_in.tbl_nr01 
                                 && a55_00.p601a=0 
                                 && a55_00.p414=0
                                 /*v1.57*/
                                 && a55_00.pweb01=0
                                 
        where mydt10_in.tbl='a55' 
           && mydt10_in.tbl is not null
           && mydt10_in.tbl_nr01 is not null
           && locate( concat('#', a55_00.nr01, '#'), ifnull(mydt10_in.pcor, ''))<=0     
        group by mydt10_in.tbl, mydt10_in.tbl_nr01
        ) as tbl01   
set mydt10.pcor = tbl01.pcor
where mydt10.tbl = tbl01.tbl 
   && mydt10.tbl_nr01 = tbl01.tbl_nr01 
   && tbl01.pcor is not null; 
/*peg_end*/

update {p_mydt10tbl1} as mydt10,
       (select ifnull(mydt10_in.tbl, '') as tbl,
               ifnull(mydt10_in.tbl_nr01, 0) as tbl_nr01,
               concat( if(ifnull(mydt10_in.pcor, '')='','#', mydt10_in.pcor) , group_concat(DISTINCT(a55_00.nr01) SEPARATOR '#') , '#') as pcor 
        from {p_mydt10tbl1} as mydt10_in 
        left join i01 on i01.p06=mydt10_in.tbl_nr01
                      && i01.p07=2  
        left join a55 as a55_arxiko on i01.p06=a55_arxiko.nr01 
                                    && i01.p07=2  
        left join i01 as i01_00 on i01_00.nr01=i01.p3051
        left join a55 as a55_00 on a55_arxiko.p601=a55_00.nr01                                   
                                 && a55_00.nr01<>mydt10_in.tbl_nr01 
                                 && a55_00.p601a=0 
                                 && a55_00.p414=0
                                 /*v1.57*/
                                 && a55_00.pweb01=0
                                 
        where mydt10_in.tbl='a55'      
           && mydt10_in.tbl is not null
           && mydt10_in.tbl_nr01 is not null
           && locate( concat('#', a55_00.nr01, '#'), ifnull(mydt10_in.pcor, ''))<=0     
        group by mydt10_in.tbl, mydt10_in.tbl_nr01
        ) as tbl01   
set mydt10.pcor = tbl01.pcor
where mydt10.tbl = tbl01.tbl 
   && mydt10.tbl_nr01 = tbl01.tbl_nr01 
   && tbl01.pcor is not null; 
/*peg_end*/

/*******************************************************************
    Συσχετιζόμενα - συνδεδεμένα και ακυρωμένα από το Estiasi
********************************************************************/
/**start_module_exists_estiasi**/
update {p_mydt10tbl1}, 
       ( select ifnull(mydt10_in.tbl, '') as tbl, 
                ifnull(mydt10_in.tbl_nr01, 0) as tbl_nr01, 
                mydt10_in.pcor, 
                mydt10_cor.nr01, 
                ifnull(group_concat(DISTINCT(mydt10_cor.mark) SEPARATOR ','), '') as mconmrk, 
                ifnull(group_concat(DISTINCT(mydt10_cor.auth_cd) SEPARATOR ','), '') as mconauth, 
                ifnull(group_concat(DISTINCT(concat(mydt10_cor.tbl, ':', mydt10_cor.tbl_nr01)) SEPARATOR ','), '') as pmcon
         from {p_mydt10tbl1} as mydt10_in, 
              i01 as i01_in, 
              a55 as a55_in, 
              este98 as este98_in, 
              i01 as i01_cor,
              a55 as a55_cor,
              mydt10 as mydt10_cor 
         where i01_in.p07=2
            && i01_in.p06=mydt10_in.tbl_nr01
            && i01_in.p3051<>0
            && a55_in.nr01=i01_in.p06
            && este98_in.nr01=1
            && i01_cor.nr01=i01_in.p3051
            && i01_cor.p07=2
            && a55_cor.nr01=i01_cor.p06
            && mydt10_cor.tbl=mydt10_in.tbl
            && mydt10_cor.tbl_nr01=i01_cor.p06
            && (   (    a55_in.p05 not in (este98_in.p244 , este98_in.p245) 
                     && a55_cor.p05=este98_in.p244
                   )
                ||     
                   (    a55_in.p05=este98_in.p245
                     && a55_cor.p05=este98_in.p244
                   )  
               )    
         group by mydt10_in.tbl, mydt10_in.tbl_nr01
         ) as tbl_a55
set {p_mydt10tbl1}.mconmrk = ifnull(tbl_a55.mconmrk, ''), 
    {p_mydt10tbl1}.mconauth = ifnull(tbl_a55.mconauth, ''), 
    {p_mydt10tbl1}.pmcon   = ifnull(tbl_a55.pmcon, ''), 
    {p_mydt10tbl1}.pcor = ''
where {p_mydt10tbl1}.tbl = tbl_a55.tbl 
   && {p_mydt10tbl1}.tbl_nr01 = tbl_a55.tbl_nr01
   && ifnull(tbl_a55.pmcon, '')<>'';
/**end_module_exists_estiasi**/ 
/*peg_end*/ 

/*******************************************************
    συνδεδεμένα από t38
*******************************************************/
/**start_module_exists_account01**/
update
   {p_mydt10tbl1},
   (select ifnull(group_concat(DISTINCT(mydt10.mark) SEPARATOR ','), '') as mconmrk,
           ifnull(group_concat(DISTINCT(mydt10.auth_cd) SEPARATOR ','), '') as mconauth,
           ifnull(group_concat(DISTINCT(concat(mydt10.tbl, ':', mydt10.tbl_nr01)) SEPARATOR ','), '') as pmcon,
           'a55' as tbl, 
           a55.nr01 as tbl_nr01
    from {p_mydt10tbl1} as mydt10_in
    LEFT JOIN a55 on a55.nr01=mydt10_in.tbl_nr01
    left join t01 on t01.p303 = 2
                  && t01.p302 = a55.nr01 
    left join t38 on t01.nr01=t38.p01
    left join t01 as t01_00 on t01_00.nr01=t38.p02 
                            && t01_00.p303 = 6  
    left join t08 on t01_00.p302 = t08.nr01
    left join mydt10 on t08.nr01 = mydt10.tbl_nr01 
                     && mydt10.tbl = 't08'
    where mydt10_in.tbl='a55'
       && mydt10.nr01 is not null
   ) as tbl_a55
set {p_mydt10tbl1}.mconmrk  = ifnull(tbl_a55.mconmrk, ''),
    {p_mydt10tbl1}.mconauth = ifnull(tbl_a55.mconauth, ''),
    {p_mydt10tbl1}.pmcon    = ifnull(tbl_a55.pmcon, '') 
where {p_mydt10tbl1}.tbl = tbl_a55.tbl 
   && {p_mydt10tbl1}.tbl_nr01 = tbl_a55.tbl_nr01
   && ifnull(tbl_a55.pmcon, '')<>'';
/**end_module_exists_account01**/ 
/*peg_end*/ 