SELECT tbl01.rectype, 
       tbl01.tbl, 
       tbl01.tbl_nr01, 
       tbl01.ptbl, 
       tbl01.ptbl_nr01, 
       tbl01.comments, 
       tbl01.mydt57_p00,
       tbl01.vatcat,
       if(tbl01.vatexcat1='',tbl01.vatexcat, tbl01.vatexcat1),
       if(tbl01.wthhldpcat='', tbl01.wthhldpcat_1, tbl01.wthhldpcat) as wthhldpcat,
       tbl01.otaxpcat,
       if(tbl01.stamppcat='', tbl01.stamppcat_1, tbl01.stamppcat) as stampcat,
       tbl01.feestype,
       tbl01.invdtype,
       tbl01.mydt61_p00,
       if(   wthhldpcat=''
          && wthhldpcat_1=''
          && otaxpcat=''  
          && feestype=''  
          && stamppcat='' 
          && stamppcat_1='', i01p011, 0) as netvalue, 
       if(vatcat<>''    , i01fp011, 0) as fpavalue, 
       if(wthhldpcat<>'' || wthhldpcat_1<>'' , i01p011, 0) + wthhld_am as wthhld_am, 
       if(otaxpcat<>''  , i01p011, 0) + otax_am as otax_am, 
       if(feestype<>''  , i01p011, 0) as fees_am,
       if(stamppcat<>'' || stamppcat_1<>'', i01p011, 0) as stampvalue, 
       deducvalue as deducvalue, 
       taxunder as taxunder, 
       discoption as discoption,
       quantity as quantity, 
       munit as munit, 
              
       p101  as p101, 
       p101f as p101f, 
       p102  as p102, 
       p102f as p102f, 
       p103  as p103, 
       p103f as p103f, 
       quantity  as p105, 
       comments  as p106, 
       fuelcode  as fuelcode, 
       itemcode  as itemcode, 
       itemdescr as itemdescr, 
       /*v1.66*/
       if(i01p011=0 && i01fp011=0 && tbl='i01' , 1 , 0) as isinfo
       
FROM  
(
    /*********************************************************
           transactions
    *********************************************************/
    
    /******************************************************
            i01.records
    ******************************************************/
    (
    select if(mydt10.invtype='8.6' && i15.p04=-1 , 7 ,  0) as rectype,
           i01.p011 as i01p011, 
           i01.fp011 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           0 as deducvalue,

           'i01' as tbl, 
           i01.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           /*v1.44*/
           concat(i01.p01, ' ', i01.p02, ' ', i01.p0601) as comments,
           
           ifnull( (select mydt_in.p00 
                    from mydt57 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620020
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt57_p00,
                            
           ifnull( (select mydt_in.p00 
                    from mydt51 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620024
                       && q31_in.p03=i13.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as vatcat,
       
           /* vat exception from invoice (a77)*/
           if( i01.fp011<>0, '', 
                   ifnull( (select mydt_in.p00 
                            from mydt52 as mydt_in, 
                                 q31 as q31_in
                            where q31_in.p01=620051
                               && q31_in.p03=a55.p706c
                               && q31_in.p05=mydt_in.p00
                             limit 1), 
                         '') 
               ) as vatexcat,       


           /* vat exception from product type (i10)*/
           if( i01.fp011<>0, '', 
                   ifnull( (select mydt_in.p00 
                            from mydt52 as mydt_in, 
                                 q31 as q31_in
                            where q31_in.p01=620050
                               && q31_in.p03=i10.p01
                               && q31_in.p05=mydt_in.p00
                             limit 1), 
                         '') 
               ) as vatexcat1,       

           ifnull( (select mydt_in.p00 
                    from mydt53 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620026
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as wthhldpcat,
           /*v1.43*/
           '' as wthhldpcat_1,         

           ifnull( (select mydt_in.p00 
                    from mydt54 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620027
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as otaxpcat,

           /*** stamp from product ***/
           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620028
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat,

           /*** stamp from vat ***/
           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620025
                       && q31_in.p03=i13.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat_1,

           ifnull( (select mydt_in.p00 
                    from mydt56 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620029
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as feestype,

           /*v1.36*/       
           ifnull( (select mydt_in.p00 
                    from mydt60 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620058
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as invdtype,
       
           ifnull( (select mydt_in.p00 
                    from mydt61 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620022
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt61_p00, 

           /*v1.55*/
           ifnull( (select mydt_in.p00 
                    from mydt68 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620067
                       && q31_in.p03=i00.pno
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as fuelcode,
           i00.pno  as itemcode,
                    
           0 as taxunder, 
           if( locate( concat('#', ifnull(i10.p01, 0), '#'), ifnull(mydt00.p010, ''))>0, 1, 0) as discoption,
           /*v1.46*/
           ifnull(i01.p03, 0) as quantity, 
           ifnull( (select mydt_in.p00 
                    from mydt59 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620060
                       && q31_in.p03=i24.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as munit, 
          
           if(ifnull(mydt00.p101, 0)=1, round(ifnull(i01.p03*i01.p041, 0), {peg_dek}), 0) as p101, 
           if(ifnull(mydt00.p101, 0)=1, round(ifnull(i01.p03*i01.p041*i01.p08/100, 0), {peg_dek}), 0) as p101f, 
           if(ifnull(mydt00.p101, 0)=1, round(ifnull(i01.p03*i01.p616, 0), {peg_dek}), 0) as p102, 
           if(ifnull(mydt00.p101, 0)=1, round(ifnull(i01.p03*i01.p616*i01.p08/100, 0), {peg_dek}), 0) as p102f, 
           if(ifnull(mydt00.p101, 0)=1, round(ifnull( i01.p011*i10.p101/(100+i10.p101), 0), {peg_dek}), 0) as p103,
           if(ifnull(mydt00.p101, 0)=1, round(ifnull( i01.p08*i01.p011*i10.p101/(100*(100+i10.p101)), 0), {peg_dek}), 0) as p103f, 

           ifnull(i01.p03, 0) as p105,
           concat(i01.p01, ' ', i01.p02, ' ', i01.p0601) as p106,
           concat(i01.p01, ' ', i01.p02, ' ', i01.p0601) as itemdescr           
           
    from {p_mydt10tbl1} as mydt10
    left join i01 on i01.p06=mydt10.tbl_nr01
                  && i01.p07=2
    left join i15 ON i15.p01 = i01.p05   
    left join a55 ON a55.nr01=i01.p06
    left join i00 ON i00.pno=i01.p01
    left join i10 on i10.p01=i00.p62
    left join i13 on i13.p01=i01.p081
    left join i24 on i24.p01=i00.ths
    left join mydt00 on mydt00.nr01=1
    where i01.nr01 is not null
       && ifnull(i10.p106, 0)=0
    group by i01.nr01
    )
    
    
    UNION ALL

    /******************************************************
            a55.vp0112 + a55.vp0113
            total deducvalue
    ******************************************************/
    (
    select 0 as rectype,
           0 as i01p011, 
           0 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           
           if( a55.vp0112>0 && ifnull(mydt00.p06, 0)=0, a55.vp0112, 0 ) +
           if( a55.vp0113>0 && ifnull(mydt00.p07, 0)=0, a55.vp0113, 0 ) +
           if( a55.vp0112<0 && ifnull(mydt00.p08, 0)=0, a55.vp0112, 0 ) +
           if( a55.vp0113<0 && ifnull(mydt00.p09, 0)=0, a55.vp0113, 0 ) as deducvalue,
           
           'a55' as tbl, 
           a55.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           /*v1.42*/
           'Βασικές Κρατήσεις - Φόρος' as comments,
           '' as mydt57_p00,
           '7' as vatcat,
           '21' as vatexcat,       
           '21' as vatexcat1,       
           '' as wthhldpcat,
           /*v1.43*/
           '' as wthhldpcat_1,         
           '' as otaxpcat,
           '' as stamppcat,
           '' as stamppcat_1,
           '' as feestype,
           '' as invdtype,
           '' as mydt61_p00, 
           /*v1.55*/
           '' as fuelcode,
           '' as itemcode,
           a55.p0100-a55.p0102 as taxunder,
           0 as discoption,
           /*v1.46*/
           0 as quantity,
           '' as munit,
           0  as p101, 
           0 as p101f, 
           0  as p102, 
           0 as p102f, 
           0  as p103, 
           0 as p103f,

           0 as p105,
           'Βασικές Κρατήσεις - Φόρος' as p106,
           'Βασικές Κρατήσεις - Φόρος' as itemdescr

    from {p_mydt10tbl1} as mydt10
    left join mydt00 on mydt00.nr01=1
    left join a55 on a55.nr01=mydt10.tbl_nr01
                  && (    ( a55.vp0112>0 && ifnull(mydt00.p06, 0)=0 )
                       || ( a55.vp0113>0 && ifnull(mydt00.p07, 0)=0 )
                       || ( a55.vp0112<0 && ifnull(mydt00.p08, 0)=0 )
                       || ( a55.vp0113<0 && ifnull(mydt00.p09, 0)=0 )
                     )
    where a55.nr01 is not null
    group by a55.nr01
    )

    UNION ALL

    /******************************************************
            a55.vp0112
            using i70
    ******************************************************/
    (
    select 0 as rectype,
           abs(a55.vp0112) as i01p011, 
           0 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           0 as deducvalue,

           'a55_1' as tbl, 
           a55.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           /*v1.42*/
           concat('Βασικές Κρατήσεις: ', ifnull(i70.p01, '')) as comments,
           
           '' mydt57_p00,                            
           '7' as vatcat,       
           '21' as vatexcat,       
           '21' as vatexcat1,

           ifnull( (select mydt_in.p00 
                    from mydt53 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620046
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as wthhldpcat,
           /*v1.43*/
           '' as wthhldpcat_1,         

           ifnull( (select mydt_in.p00 
                    from mydt54 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620047
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as otaxpcat,

           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620048
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat,
           '' as stamppcat_1,

           ifnull( (select mydt_in.p00 
                    from mydt56 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620049
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as feestype,
       
           /*v1.36*/       
           ifnull( (select mydt_in.p00 
                    from mydt60 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620059
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as invdtype,

           '' as mydt61_p00, 
           /*v1.55*/
           '' as fuelcode,
           '' as itemcode,
           if(i70.p03 in (1, 3, 5), a55.p0100-a55.p0102, 0) as taxunder, 
           0 as discoption,
           /*v1.46*/
           0 as quantity,
           '' as munit,            
           0  as p101, 
           0 as p101f, 
           0  as p102, 
           0 as p102f, 
           0  as p103, 
           0 as p103f,

           0 as p105,
           concat('Βασικές Κρατήσεις: ', ifnull(i70.p01, '')) as p106,
           concat('Βασικές Κρατήσεις: ', ifnull(i70.p01, '')) as itemdescr

    from {p_mydt10tbl1} as mydt10
    left join mydt00 on mydt00.nr01=1
    left join a55 on a55.nr01=mydt10.tbl_nr01
                  && (    ( a55.vp0112>0 && ifnull(mydt00.p06, 0)<>0 )
                       || ( a55.vp0112<0 && ifnull(mydt00.p08, 0)<>0 )
                     )
    left join i70 ON (    (i70.nr01=ifnull(mydt00.p06,0) && a55.vp0112>0)
                       || (i70.nr01=ifnull(mydt00.p08,0) && a55.vp0112<0)
                     )
    where i70.nr01 is not null
       && i70.nr01<>0 
       && ifnull(i70.p106, 0)=0
       && a55.vp0112<>0
       && a55.nr01 is not null
    group by a55.nr01
    )

    UNION ALL

    /******************************************************
            a55.vp0113
            using i70
    ******************************************************/
    (
    select 0 as rectype,
           abs(a55.vp0113) as i01p011, 
           0 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           0 as deducvalue,

           'a55_2' as tbl, 
           a55.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           /*v1.42*/
           concat('Βασικός Φόρος: ', ifnull(i70.p01, '') ) as comments,
           
           '' mydt57_p00,                            
           '7' as vatcat,       
           '21' as vatexcat,       
           '21' as vatexcat1,

           ifnull( (select mydt_in.p00 
                    from mydt53 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620046
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as wthhldpcat,
           /*v1.43*/
           '' as wthhldpcat_1,         

           ifnull( (select mydt_in.p00 
                    from mydt54 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620047
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as otaxpcat,

           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620048
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat,
           '' as stamppcat_1,

           ifnull( (select mydt_in.p00 
                    from mydt56 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620049
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as feestype,
       
           /*v1.36*/       
           ifnull( (select mydt_in.p00 
                    from mydt60 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620059
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as invdtype,

           '' as mydt61_p00, 
           /*v1.55*/
           '' as fuelcode,
           '' as itemcode,
           if(i70.p03 in (1, 3, 5), a55.p0100-a55.p0102-a55.vp0112, 0) as taxunder, 
           0 as discoption,
           /*v1.46*/
           0 as quantity,
           '' as munit,            
           0  as p101, 
           0 as p101f, 
           0  as p102, 
           0 as p102f, 
           0  as p103, 
           0 as p103f,

           0 as p105,
           concat('Βασικός Φόρος: ', ifnull(i70.p01, '') ) as p106,
           concat('Βασικός Φόρος: ', ifnull(i70.p01, '') ) as itemdescr

    from {p_mydt10tbl1} as mydt10
    left join mydt00 on mydt00.nr01=1
    left join a55 on a55.nr01=mydt10.tbl_nr01
                  && (    ( a55.vp0113>0 && ifnull(mydt00.p07, 0)<>0 )
                       || ( a55.vp0113<0 && ifnull(mydt00.p09, 0)<>0 )
                     )
    left join i70 ON (    (i70.nr01=ifnull(mydt00.p07,0) && a55.vp0113>0)
                       || (i70.nr01=ifnull(mydt00.p09,0) && a55.vp0113<0)
                     )
    where i70.nr01 is not null
       && i70.nr01<>0 
       && ifnull(i70.p106, 0)=0
       && a55.vp0113<>0
       && a55.nr01 is not null
    group by a55.nr01
    )

    
    
    UNION ALL

    /******************************************************
            a55.p0108
    ******************************************************/
    (
    select 0 as rectype,
           if(a55.p0108>0, a55.p0108, 0) as i01p011, 
           0 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           /*v1.41*/
           if(a55.p0108<0, -1*a55.p0108, 0) as deducvalue,
           
           /*use differ. table for any new line must be created for a55*/
           'a55_3' as tbl, 
           a55.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           /*v1.41*/
           'Επιβάρυνση' as comments,
           ifnull(mydt00.p01, '') as mydt57_p00,
           '7' as vatcat,
           '21' as vatexcat,       
           '21' as vatexcat1,       
           '' as wthhldpcat,
           /*v1.43*/
           '' as wthhldpcat_1,         
           '' as otaxpcat,
           '' as stamppcat,
           '' as stamppcat_1,
           '' as feestype,
           '' as invdtype,
           ifnull(mydt00.p02, '') as mydt61_p00, 
           /*v1.55*/
           '' as fuelcode,
           '' as itemcode,
           0 as taxunder,
           0 as discoption,
           /*v1.46*/
           0 as quantity,
           '' as munit,            
           0  as p101, 
           0 as p101f, 
           0  as p102, 
           0 as p102f, 
           0  as p103, 
           0 as p103f,

           0 as p105,
           'Επιβάρυνση' as p106,
           'Επιβάρυνση' as itemdescr

    from {p_mydt10tbl1} as mydt10
    left join a55 on a55.nr01=mydt10.tbl_nr01
                  && a55.p0108<>0
    left join mydt00 on mydt00.nr01=1
    where a55.nr01 is not null
           /*v1.55*/
           && ifnull(mydt00.p106, 0)=0
    group by a55.nr01
    )
    
    UNION ALL
    
   
    /******************************************************
            i70.records
    ******************************************************/
    (
    select 0 as rectype,
           i71.p100 as i01p011, 
           0 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           0 as deducvalue,

           'i71' as tbl, 
           i71.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           ifnull(i70.p01, '') as comments,
           
           ifnull( (select mydt_in.p00 
                    from mydt57 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620052
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt57_p00,

           '7' as vatcat,       
           '21' as vatexcat,       
           '21' as vatexcat1,

           ifnull( (select mydt_in.p00 
                    from mydt53 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620046
                       && q31_in.p03=i71.i70
                       && q31_in.p05=mydt_in.p00
                       /*v1.50*/
                       && ifnull(i70.p02, 0)=2
                    limit 1), '') as wthhldpcat,

           if(ifnull(i70.p02, 0)=2, 'peg01', '') as wthhldpcat_1,         

           ifnull( (select mydt_in.p00 
                    from mydt54 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620047
                       && q31_in.p03=i71.i70
                       && q31_in.p05=mydt_in.p00
                       /*v1.50*/
                       && ifnull(i70.p02, 0)<>2
                    limit 1), '') as otaxpcat,

           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620048
                       && q31_in.p03=i71.i70
                       && q31_in.p05=mydt_in.p00
                       /*v1.50*/
                       && ifnull(i70.p02, 0)<>2
                    limit 1), '') as stamppcat,
           '' as stamppcat_1,

           ifnull( (select mydt_in.p00 
                    from mydt56 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620049
                       && q31_in.p03=i71.i70
                       && q31_in.p05=mydt_in.p00
                       /*v1.50*/
                       && ifnull(i70.p02, 0)<>2
                    limit 1), '') as feestype,
       
           /*v1.36*/       
           ifnull( (select mydt_in.p00 
                    from mydt60 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620059
                       && q31_in.p03=i71.i70
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as invdtype,
           
           ifnull( (select mydt_in.p00 
                    from mydt61 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620053
                       && q31_in.p03=i70.nr01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt61_p00, 
                    
           /*v1.55*/
           '' as fuelcode,
           '' as itemcode,
           if(i71.p04<>0, i71.p05, 0) as taxunder, 
           0 as discoption,
           /*v1.46*/
           0 as quantity,
           '' as munit,
           0  as p101, 
           0 as p101f, 
           0  as p102, 
           0 as p102f, 
           0  as p103, 
           0 as p103f,

           0 as p105,
           ifnull(i70.p01, '') as p106,
           ifnull(i70.p01, '') as itemdescr

    from {p_mydt10tbl1} as mydt10
    left join i71 on i71.tbl_nr=mydt10.tbl_nr01
                  && i71.tbl='a55'
                  && i71.i70p07=1
    left join i70 ON i70.nr01=i71.i70
    where i71.nr01 is not null
       && ifnull(i70.p106, 0)=0
    group by i71.nr01
    )
    
) as tbl01;
/*peg_end*/