INSERT INTO {p_mydt10tbl3}
( tbl, tbl_nr01, type, amount, ptbl, ptbl_nr01, amount_t, p_sign, tid)

SELECT tbl01.tbl       as tbl, 
       tbl01.tbl_nr01  as tbl_nr01, 
       tbl01.type      as type, 
       abs(tbl01.amount) as amount, 
       tbl01.ptbl      as ptbl, 
       tbl01.ptbl_nr01 as ptbl_nr01, 
       ifnull(tbl01.amount_t, 0)   as amount_t, 
       ifnull(tbl01.p_sign, '')    as p_sign, 
       ifnull(tbl01.tid, '')       as tid

FROM 
(
        /*******************************************************************
             t01.p303=4
        *******************************************************************/
        (
        SELECT 't01'           as tbl, 
               t01.nr01        as tbl_nr01, 
               q31.p05         as type, 
               t01.p03 + t01.p04 as amount, 
               mydt10.tbl      as ptbl, 
               mydt10.tbl_nr01 as ptbl_nr01, 

               ##start_table_exists_t19##
               t19.tip_am      as amount_t, 
               t19.p_sign      as p_sign, 
               t19.tid         as tid
               ##end_table_exists_t19##

               ##start_table_not_exists_t19##
               0              as amount_t, 
               ''             as p_sign, 
               ''             as tid
               ##end_table_not_exists_t19##
         FROM {p_mydt10tbl1} as mydt10
         LEFT JOIN t01 ON t01.p302=mydt10.tbl_nr01
                       && t01.p303=4
                       && t01.p03+t01.p04<>0
         LEFT JOIN a55 ON a55.nr01=t01.p302
         LEFT JOIN q31 ON q31.p01=620042 
                       && q31.p03=a55.p015

          ##start_table_exists_t19##
          LEFT JOIN t19 on t01.nr01 = t19.t01 and t19.tid <> ''
          ##end_table_exists_t19##

         WHERE ifnull(q31.p05, '')<>''
         GROUP BY t01.nr01
	 )
	 
	 UNION ALL

        /*******************************************************************
             t01.p303=9 με ενημερωμένο το pd101
        *******************************************************************/
        (
        SELECT 't01'           as tbl, 
               t01.nr01        as tbl_nr01, 
               q31.p05         as type, 
               t01.p03 + t01.p04 as amount, 
               mydt10.tbl      as ptbl, 
               mydt10.tbl_nr01 as ptbl_nr01, 

               ##start_table_exists_t19##
               t19.tip_am      as amount_t, 
               t19.p_sign      as p_sign, 
               t19.tid         as tid
               ##end_table_exists_t19##

               ##start_table_not_exists_t19##
               0              as amount_t, 
               ''             as p_sign, 
               ''             as tid
               ##end_table_not_exists_t19##
         FROM {p_mydt10tbl1} as mydt10
         LEFT JOIN t01 ON t01.p302=mydt10.tbl_nr01
                       && t01.p303=9
                       && t01.pd101='a14'
                       && t01.p03+t01.p04<>0
         LEFT JOIN q31 ON q31.p01=620042 
                       && q31.p03=t01.pd102

          ##start_table_exists_t19##
          LEFT JOIN t19 on t01.nr01 = t19.t01 and t19.tid <> ''
          ##end_table_exists_t19##
                                 
         WHERE ifnull(q31.p05, '')<>''
         GROUP BY t01.nr01
	 )

	 UNION ALL

        /*******************************************************************
             t01.p303=9 με μη ενημερωμένο το pd101
        *******************************************************************/
        (
        SELECT 't01'           as tbl, 
               t01.nr01        as tbl_nr01, 
               q31.p05         as type, 
               t01.p03 + t01.p04 as amount, 
               mydt10.tbl      as ptbl, 
               mydt10.tbl_nr01 as ptbl_nr01, 

               ##start_table_exists_t19##
               t19.tip_am      as amount_t, 
               t19.p_sign      as p_sign, 
               t19.tid         as tid
               ##end_table_exists_t19##

               ##start_table_not_exists_t19##
               0              as amount_t, 
               ''             as p_sign, 
               ''             as tid
               ##end_table_not_exists_t19##

         FROM {p_mydt10tbl1} as mydt10
         LEFT JOIN t01 ON t01.p302=mydt10.tbl_nr01
                       && t01.p303=9
                       && t01.pd101<>'a14'
                       && t01.p03+t01.p04<>0
         LEFT JOIN a14 ON a14.p02=t01.p07
         LEFT JOIN q31 ON q31.p01=620042 
                       && q31.p03=a14.nr01

          ##start_table_exists_t19##
          LEFT JOIN t19 on t01.nr01 = t19.t01 and t19.tid <> ''
          ##end_table_exists_t19##

         WHERE ifnull(q31.p05, '')<>''
            && t01.nr01 is not null
         GROUP BY t01.nr01              
	 )


) as tbl01

;