SELECT 
       count(*) as cnt 

FROM 
       (
              SELECT tbl as tbl, 
                     tbl_nr01 as tbl_nr01, 
                     p00 as p00, 
                     p01 as p01, 
                     p03 as p03, 
                     p06 as p06, 
                     p07 as p07, 
                     p08d as p08d, 
                     p08t as p08t, 
                     currency as currency, 
                     exchrate as exchrate, 
                     series as series, 
                     aa as aa, 
                     issuedate as issuedate, 
                     invtype as invtype, 
                     paytype as paytype, 
                     vehiclenum as vehiclenum,
                     
                     ''             as is_country,
                     '{nt_p101[1]}' as is_vat, 
                     '{nt_p101[2]}' as is_name, 
                     '{nt_p101[3]}' as is_address, 
                     '{nt_p101[4]}' as is_city, 
                     '{nt_p101[5]}' as is_zip,
                     /* Web v1.153 */
                     '{nt_p101[6]}' as is_tbl,
                     '{nt_p101[7]}' as is_nr01,
                     a_country as cp_country,
                     a_vat     as cp_vat, 
                     a_name    as cp_name, 
                     a_address as cp_address, 
                     a_city    as cp_city, 
                     a_zip     as cp_zip,
                     /* Web v1.153 */
                     a_tbl     as cp_tbl,
                     a_nr01    as cp_nr01

              FROM
              (
              /***********************************************
                     Παραστατικά προς αποστολή
                     q30.nr01=620014
              ***********************************************/
              (
              SELECT 'a55' as tbl, 
                     a55.nr01 as tbl_nr01, 
                     1 as p00,
                     1 as p01,
                     a55.p0121 as p03, 
                     a55.p09 as p06, 
                     ifnull(a10.p04, 0) as p07, 
                     a55.remdate as p08d, 
                     a55.remtime as p08t,             
                     a55.pn01 as currency, 
                     a55.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     a55.p701 as series, 
                     a55.p06  as aa, 
                     a55.p01 as issuedate, 
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620068
                                   && q31_in.p03=a10.p01
                                   limit 1), 
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620014
                                   && q31_in.p03=a10.p01
                                   limit 1), '')) as invtype,
                     
                     /**paytype**/           
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620042
                                   && q31_in.p03=a55.p015
                                   limit 1), '') as paytype,
                     /*Αρ. Κυκλοφορίας*/
                     a55.p702 as vehiclenum,
                     /*αντισυμβαλλόμενος*/
                     ifnull(a01.p4_1, '') as a_country, 
                     ifnull(a01.p20, '') as a_vat, 
                     ifnull(a01.p19, '') as a_name, 
                     ifnull(a01.p4, '') as a_address, 
                     concat( ifnull(concat(d22.p02, ' '), ''), 
                                   ifnull(concat(a01.p5, ' '), ''),
                                   ifnull(concat(a01.p6, ' '), '')
                            ) as a_city, 
                     ifnull(a01.p7, '') as a_zip,
                     /* Web v1.153 */
                     'a01' as a_tbl,
                     ifnull(a01.nr01, 0) as a_nr01
              FROM q31
              LEFT JOIN a10 ON q31.p03=a10.p01
              LEFT JOIN a55 ON a55.p05=a10.p01
                            && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                            ##start_module_exist_stores##
                            && a55.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##
                            
              LEFT JOIN a01 ON a01.nr01=a55.p03
              LEFT JOIN d22 ON d22.p01=a01.p4_3
              WHERE q31.p01 in (620014 , 620068 )
                     && a55.nr01 is not null
                     && a10.nr01 is not null
                     && a55.p414=0
                     && a55.p601a=0
                     && a55.pweb01=0
                     && a55.p08=0
                     && {p_mydt10where} 
              GROUP BY a55.nr01
              )
              
              UNION ALL

              /***********************************************
                     Παραστατικά προς παραλαβή
                     q30.nr01=620014
              ***********************************************/
              (
              SELECT 'a55' as tbl, 
                     a55.nr01 as tbl_nr01, 
                     1 as p00,
                     2 as p01,
                     a55.p0121 as p03, 
                     a55.p09 as p06, 
                     ifnull(a10.p04, 0) as p07, 
                     a55.remdate as p08d, 
                     a55.remtime as p08t,             
                     a55.pn01 as currency, 
                     a55.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     a55.p701 as series, 
                     a55.p06  as aa, 
                     a55.p01 as issuedate, 
                     ifnull(mydt50.p00, '') as invtype, 

                     /**paytype**/           
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620042
                                   && q31_in.p03=a55.p015
                                   limit 1), '') as paytype,
                                   
                     /*Αρ. Κυκλοφορίας*/
                     a55.p702 as vehiclenum,
                     /*αντισυμβαλλόμενος*/
                     ifnull(a01.p4_1, '') as a_country, 
                     ifnull(a01.p20, '') as a_vat, 
                     ifnull(a01.p19, '') as a_name, 
                     ifnull(a01.p4, '') as a_address, 
                     concat( ifnull(concat(d22.p02, ' '), ''), 
                                   ifnull(concat(a01.p5, ' '), ''),
                                   ifnull(concat(a01.p6, ' '), '')
                            ) as a_city, 
                     ifnull(a01.p7, '') as a_zip,
                     /* Web v1.153 */
                     'a01' as a_tbl,
                     ifnull(a01.nr01, 0) as a_nr01
              FROM q31
              LEFT JOIN a10 ON q31.p03=a10.p01
              LEFT JOIN a55 ON a55.p05=a10.p01
                            && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                            
                            ##start_module_exist_stores##
                            && a55.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##

              LEFT JOIN mydt50 ON mydt50.p00=q31.p05
              LEFT JOIN a01 ON a01.nr01=a55.p03
              LEFT JOIN d22 ON d22.p01=a01.p4_3
              WHERE q31.p01=620015
                     && a55.nr01 is not null
                     && a10.nr01 is not null
                     && a55.p414=0
                     && a55.p601a=0
                     && a55.pweb01=0
                     && {p_mydt10where} 
              GROUP BY a55.nr01
              )

              ) as tbl01    
       )
       as tttttt;       