insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t,
currency, exchrate, slfpricing,
mvpurpose, vatpaysusp, 
vehiclenum, spinvcat, invvarty,
series, aa, issuedate, issuetime, invtype, paytype, 
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01, 
dispdate, disptime, ldstreet, ldzip, ldnumber, ldcity, dlvstreet, dlvzip, dlvnumber, dlvcity,
ss_branch, cs_branch, isdlvno, othmvpur, p103, 
/*v1.105*/ p_notes )

SELECT tbl as tbl, 
       tbl_nr01 as tbl_nr01, 
       p00 as p00, 
       p01 as p01, 
       p03 as p03, 
       p06 as p06, 
       p07 as p07, 
       p08d as p08d, 
       p08t as p08t, 
       currency as currency, 
       exchrate as exchrate, 
       slfpricing as slfpricing,       
       mvpurpose as mvpurpose,
       vatpaysusp as vatpaysusp,             
       /*v1.46*/ 
       vehiclenum as vehiclenum,
       spinvcat   as spinvcat,
       invvarty   as invvarty,
       if(series='', '0', series) as series,
       aa as aa, 
       issuedate as issuedate, 
       issuetime as issuetime, 
       invtype as invtype, 
       paytype as paytype, 
       
       a_country as is_country,
       a_vat     as is_vat, 
       a_name    as is_name, 
       a_address as is_address, 
       a_city    as is_city, 
       a_zip     as is_zip, 
       a_tbl     as is_tbl, 
       a_nr01    as is_nr01,
       '' as cp_country,
       '{nt_p101[1]}' as cp_vat, 
       '{nt_p101[2]}' as cp_name, 
       '{nt_p101[3]}' as cp_address, 
       '{nt_p101[4]}' as cp_city, 
       '{nt_p101[5]}' as cp_zip, 
       '{nt_p101[6]}' as cp_tbl, 
       '{nt_p101[7]}' as cp_nr01, 
        dispdate  as dispdate,
        disptime  as disptime,
        ldstreet   as ldstreet, 

        ldzip      as ldzip, 
        ldnumber   as ldnumber, 
        ldcity     as ldcity,
        dlvstreet  as dlvstreet, 
        dlvzip     as dlvzip, 
        dlvnumber  as dlvnumber, 
        dlvcity    as dlvcity,
        /*v1.88*/
        ss_branch  as ss_branch, 
        cs_branch  as cs_branch,
        isdlvno    as isdlvno,
        othmvpur    as othmvpur,  
        if(p103_1<>'', p103_1, if(p103_2<>'', p103_2, p103_3)) as p103, 
       /*v1.105*/
       p_notes as p_notes

FROM
(
      /***********************************************
             Παραστατικά προς αποστολή
             q30.nr01=620017
      ***********************************************/
      (
      SELECT 'a56' as tbl, 
             a56.nr01 as tbl_nr01, 
             2 as p00,
             1 as p01,
             a56.p0121 as p03, 
             a56.p09 as p06, 
             ifnull(a11.p04, 0) as p07, 
             a56.remdate as p08d, 
             a56.remtime as p08t,             
             ifnull(t12.p05, '') as currency, 
             a56.pn02 as exchrate,
             ifnull(a11.p013, 0) as slfpricing,                    
             ifnull( (select q31_in.p05
                      from q31 as q31_in, 
                           erpa13 as erpa13_in
                      where q31_in.p01=620057
                         && q31_in.p03=erpa13_in.nr01
                         && erpa13_in.p01=a56.p012
                      limit 1), '') as mvpurpose,
             a56.p807 as vatpaysusp,      
             a56.p702 as vehiclenum,
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620063
                         && q31_in.p03=a11.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620064
                         && q31_in.p03=a11.p01
                      limit 1), '') as invvarty,
       
             /**στοιχεία παραστατικού*/
             if( ifnull(mydt00.p103, 0)=1, 
                 concat(ifnull(a11.p00, ''), if(a56.p701='', '', '-'), a56.p701), 
                 a56.p701
                ) as series, 
             a56.p06  as aa, 
             a56.p01 as issuedate, 
             a56.p02 as issuetime, 

             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620069
                         && q31_in.p03=a11.p01
                      limit 1), 
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620017
                         && q31_in.p03=a11.p01
                      limit 1), '')) as invtype,

            if((i15.p04 - i15.p03 != 0) 
               && (ifnull( (select 1
                  from q31 as q31_in
                  where q31_in.p01=620069
                     && q31_in.p03=a11.p01
                  limit 1), 0 ) = 1), 1, 0) as isdlvno,
                                        
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620043
                         && q31_in.p03=a56.p015
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a76.p603_1, ifnull(d23.p01, '')) as a_country, 
             ifnull(a00.p20, '') as a_vat, 
             ifnull(a00.p19, '') as a_name, 
             ifnull(a76.p603, ifnull(a00.p4, '')) as a_address, 
             ifnull(a76.p605, concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a00.p5, ' '), ''),
                     ifnull(concat(a00.p6, ' '), '')
                   )) as a_city, 
             ifnull(a76.p604, ifnull(a00.p7, '')) as a_zip,
             if(ifnull(a76.nr01, 0)>0, 'a76', 'a00') as a_tbl,
             ifnull(a76.nr01, ifnull(a00.nr01, 0)) as a_nr01,

             if(a56.d_p01 > cast('0100-01-01' as date) , a56.d_p01 , cast('0100-01-01' as date))  as dispdate,
             if(a56.d_p02 = '', '', concat(a56.d_p02, ':00')) AS disptime,
             
             /*v1.88*/
             a56.ldstreet  as ldstreet, 
             a56.ldzip     as ldzip, 
             a56.ldnumber  as ldnumber, 
             a56.ldcity    as ldcity,
             a56.dlvstreet as dlvstreet, 
             a56.dlvzip    as dlvzip, 
             a56.dlvnumber as dlvnumber, 
             a56.dlvcity   as dlvcity,
             a56.ss_branch as ss_branch, 
             a56.cs_branch as cs_branch, 

             if(a56.p012='', 'Αγορά', a56.p012) as othmvpur, 
             if(ifnull(a56.p08, 0)=0, ifnull(a11.p08, ''),    '') as p103_1, 
             if(ifnull(a56.p08, 0)=0, ifnull(a11_ak.p08, ''), '') as p103_2, 
             if(ifnull(a56.p08, 0)=0, ifnull(f02.p010, ''),   '') as p103_3, 
           
           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a56.p011<>'', 
                         concat(a56.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a56.p30, '')<>'', 
                         concat(ifnull(a56.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes  
             
      FROM q31
      LEFT JOIN a11 ON q31.p03=a11.p01
      LEFT JOIN a56 ON a56.p05=a11.p01
                    && a56.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a56.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a56.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a56.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a56.remdate, a56.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a56.remdate, a56.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    
                    ##start_module_exist_stores##
                    && a56.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##                      

      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a00 ON a00.nr01=a56.p03
      LEFT JOIN d22 ON d22.p01=a00.p4_3
      LEFT JOIN d23 ON d23.p01=a00.p4_1
      LEFT JOIN t12 ON t12.p01=a56.pn01
      LEFT JOIN a76 ON a76.p601=a00.nr01 
                    && a76.nr01=a56.p04
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN i15    ON i15.p01 = a11.p05
      LEFT JOIN i16    ON i16.p00 = a56.p703      
      LEFT JOIN a11 as a11_ak on a11_ak.p01=a56.p414
                              && a56.p414<>0
      LEFT JOIN f02 on f02.nr01=1
      WHERE q31.p01 in (620017 , 620069 )
         && a56.nr01 is not null
         && a11.nr01 is not null
         && a56.p414=0
         && a56.p601a=0
         && a56.pweb01=0
         && {p_mydt10where} 
         && {nt_napost}=1
      GROUP BY a56.nr01
      {p_mydt10limit}
      )
      
      UNION ALL

      /***********************************************
             Παραστατικά προς παραλαβή
             q30.nr01=620016
      ***********************************************/
      (
      SELECT 'a56' as tbl, 
             a56.nr01 as tbl_nr01, 
             2 as p00,
             2 as p01,
             a56.p0121 as p03, 
             a56.p09 as p06, 
             ifnull(a11.p04, 0) as p07, 
             a56.remdate as p08d, 
             a56.remtime as p08t,             
             ifnull(t12.p05, '') as currency, 
             a56.pn02 as exchrate,
             ifnull(a11.p013, 0) as slfpricing,                    
             ifnull( (select q31_in.p05
                      from q31 as q31_in, 
                           erpa13 as erpa13_in
                      where q31_in.p01=620057
                         && q31_in.p03=erpa13_in.nr01
                         && erpa13_in.p01=a56.p012
                      limit 1), '') as mvpurpose,
             a56.p807 as vatpaysusp,      
             a56.p702 as vehiclenum,
             /**special invoice category**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620063
                         && q31_in.p03=a11.p01
                      limit 1), '') as spinvcat,
             /**invoice variation type**/
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620064
                         && q31_in.p03=a11.p01
                      limit 1), '') as invvarty,
       
             /**στοιχεία παραστατικού*/
             if( ifnull(mydt00.p103, 0)=1, 
                 concat(ifnull(a11.p00, ''), if(a56.p701='', '', '-'), a56.p701), 
                 a56.p701
                ) as series, 
             a56.p06  as aa, 
             a56.p01 as issuedate, 
             a56.p02 as issuetime, 
             ifnull(mydt50.p00, '') as invtype, 
             0  as isdlvno,             

             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620043
                         && q31_in.p03=a56.p015
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a76.p603_1, ifnull(d23.p01, '')) as a_country, 
             ifnull(a00.p20, '') as a_vat, 
             ifnull(a00.p19, '') as a_name, 
             ifnull(a76.p603, ifnull(a00.p4, '')) as a_address, 
             ifnull(a76.p605, concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a00.p5, ' '), ''),
                     ifnull(concat(a00.p6, ' '), '')
                   )) as a_city, 
             ifnull(a76.p604, ifnull(a00.p7, '')) as a_zip,
             if(ifnull(a76.nr01, 0)>0, 'a76', 'a00') as a_tbl,
             ifnull(a76.nr01, ifnull(a00.nr01, 0)) as a_nr01,

             if(a56.d_p01 > cast('0100-01-01' as date) , a56.d_p01 , cast('0100-01-01' as date))  as dispdate,
             if(a56.d_p02 = '', '', concat(a56.d_p02, ':00')) AS disptime,

             /*v1.88*/
             a56.ldstreet  as ldstreet, 
             a56.ldzip     as ldzip, 
             a56.ldnumber  as ldnumber, 
             a56.ldcity    as ldcity,
             a56.dlvstreet as dlvstreet, 
             a56.dlvzip    as dlvzip, 
             a56.dlvnumber as dlvnumber, 
             a56.dlvcity   as dlvcity,
             a56.ss_branch as ss_branch, 
             a56.cs_branch as cs_branch, 
             
             if(a56.p012='', 'Αγορά', a56.p012) as othmvpur, 
             if(ifnull(a56.p08, 0)=0, ifnull(a11.p08, ''),    '') as p103_1, 
             if(ifnull(a56.p08, 0)=0, ifnull(a11_ak.p08, ''), '') as p103_2, 
             if(ifnull(a56.p08, 0)=0, ifnull(f02.p010, ''),   '') as p103_3, 
           
           /*v1.105*/
           concat(   if( ifnull(mydt00.p112, 0)=1 && a56.p011<>'', 
                         concat(a56.p011, char(13), char(10)), 
                         ''
                       ), 
                     if( ifnull(mydt00.p113, 0)=1 && ifnull(a56.p30, '')<>'', 
                         concat(ifnull(a56.p30, ''), char(13), char(10)), 
                         ''
                       )
                 ) as p_notes     
      FROM q31
      LEFT JOIN a11 ON q31.p03=a11.p01
      LEFT JOIN a56 ON a56.p05=a11.p01
                    && a56.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a56.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a56.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a56.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a56.remdate, a56.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a56.remdate, a56.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                    ##start_module_exist_stores##
                    && a56.p0121 in (##store_in_sql##)                 
                    ##end_module_exist_stores##   

      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a00 ON a00.nr01=a56.p03
      LEFT JOIN d22 ON d22.p01=a00.p4_3
      LEFT JOIN d23 ON d23.p01=a00.p4_1
      LEFT JOIN t12 ON t12.p01=a56.pn01
      LEFT JOIN a76 ON a76.p601=a00.nr01 
                    && a76.nr01=a56.p04
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN i15    ON i15.p01 = a11.p05
      LEFT JOIN i16    ON i16.p00 = a56.p703      
      /*v1.82*/
      LEFT JOIN a11 as a11_ak on a11_ak.p01=a56.p414
                              && a56.p414<>0
      LEFT JOIN f02 on f02.nr01=1
      WHERE q31.p01=620016
         && a56.nr01 is not null
         && a11.nr01 is not null
         && a56.p414=0
         && a56.p601a=0
         /*v1.57*/
         && a56.pweb01=0
         && {p_mydt10where} 
         && {nt_nparal}=1
      GROUP BY a56.nr01
      {p_mydt10limit}
      )

) as tbl01;   
/*peg_end*/
         

/*******************************************
    Συσχετιζόμενα από το a56
*******************************************/
update {p_mydt10tbl1} as mydt10,
       (select mydt10_in.tbl as tbl,
               mydt10_in.tbl_nr01 as tbl_nr01,
               concat( if(ifnull(mydt10_in.pcor, '')='','#', mydt10_in.pcor) , group_concat(DISTINCT(a56_00.nr01) SEPARATOR '#') , '#') as pcor 
        from {p_mydt10tbl1} as mydt10_in 
        left join i01 on i01.p06=mydt10_in.tbl_nr01
                      && i01.p07=1  
        left join a56 as a56_arxiko on i01.p06=a56_arxiko.nr01 
                                    && i01.p07=1 
        left join i01 as i01_00 on i01_00.nr01=i01.p3051
        left join a56 as a56_00 on (    (i01_00.p06=a56_00.nr01 && i01_00.p07=1) 
                                    ) 
                                && a56_00.nr01<>mydt10_in.tbl_nr01 
                                && a56_00.p601a=0 
                                && a56_00.p414=0                                
                                /*v1.57*/
                                && a56_00.pweb01=0
        where mydt10_in.tbl='a56'      
           && locate( concat('#', a56_00.nr01, '#'), ifnull(mydt10_in.pcor, ''))<=0     
        group by mydt10_in.tbl, mydt10_in.tbl_nr01
        ) as tbl01	
set mydt10.pcor = tbl01.pcor
where mydt10.tbl = tbl01.tbl 
   && mydt10.tbl_nr01 = tbl01.tbl_nr01;
/*peg_end*/

update {p_mydt10tbl1} as mydt10,
       (select mydt10_in.tbl as tbl,
               mydt10_in.tbl_nr01 as tbl_nr01,
               concat( if(ifnull(mydt10_in.pcor, '')='','#', mydt10_in.pcor) , group_concat(DISTINCT(a56_00.nr01) SEPARATOR '#') , '#') as pcor 
        from {p_mydt10tbl1} as mydt10_in 
        left join i01 on i01.p06=mydt10_in.tbl_nr01
                      && i01.p07=1  
        left join a56 as a56_arxiko on i01.p06=a56_arxiko.nr01 
                                    && i01.p07=1 
        left join i01 as i01_00 on i01_00.nr01=i01.p3051
        left join a56 as a56_00 on a56_arxiko.p601=a56_00.nr01 
                                && a56_00.nr01<>mydt10_in.tbl_nr01 
                                && a56_00.p601a=0 
                                && a56_00.p414=0                                
                                /*v1.57*/
                                && a56_00.pweb01=0
        where mydt10_in.tbl='a56'      
           /*v1.37*/
           && locate( concat('#', a56_00.nr01, '#'), ifnull(mydt10_in.pcor, ''))<=0     
        group by mydt10_in.tbl, mydt10_in.tbl_nr01
        ) as tbl01	
set mydt10.pcor = tbl01.pcor
where mydt10.tbl = tbl01.tbl 
   && mydt10.tbl_nr01 = tbl01.tbl_nr01;
/*peg_end*/
