SELECT 
       count(*) as cnt 

FROM 
       (

              SELECT tbl as tbl, 
                     tbl_nr01 as tbl_nr01, 
                     p00 as p00, 
                     p01 as p01, 
                     p03 as p03, 
                     p06 as p06, 
                     p07 as p07, 
                     p08d as p08d, 
                     p08t as p08t, 
                     currency as currency, 
                     exchrate as exchrate, 
                     series as series, 
                     aa as aa, 
                     issuedate as issuedate, 
                     invtype as invtype, 
                     paytype as paytype, 
                     vehiclenum as vehiclenum,
                     
                     a_country as is_country,
                     a_vat     as is_vat, 
                     a_name    as is_name, 
                     a_address as is_address, 
                     a_city    as is_city, 
                     a_zip     as is_zip, 
                     /* Web v1.153 */
                     a_tbl     as is_tbl,
                     a_nr01    as is_nr01,
                     '{nt_p101[1]}' as cp_vat, 
                     '{nt_p101[2]}' as cp_name, 
                     '{nt_p101[3]}' as cp_address, 
                     '{nt_p101[4]}' as cp_city, 
                     '{nt_p101[5]}' as cp_zip,
                     /* Web v1.153 */
                     '{nt_p101[6]}' as cp_tbl,
                     '{nt_p101[7]}' as cp_nr01

              FROM
              (
              /***********************************************
                     Παραστατικά προς αποστολή
                     q30.nr01=620017
              ***********************************************/
              (
              SELECT 'a56' as tbl, 
                     a56.nr01 as tbl_nr01, 
                     2 as p00,
                     1 as p01,
                     a56.p0121 as p03, 
                     a56.p09 as p06, 
                     ifnull(a11.p04, 0) as p07, 
                     a56.remdate as p08d, 
                     a56.remtime as p08t,             
                     a56.pn01 as currency, 
                     a56.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     a56.p701 as series, 
                     a56.p06  as aa, 
                     a56.p01 as issuedate,  
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620069
                                   && q31_in.p03=a11.p01
                                   limit 1), 
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620017
                                   && q31_in.p03=a11.p01
                                   limit 1), '')) as invtype,
                     /**paytype**/           
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620043
                                   && q31_in.p03=a56.p015
                                   limit 1), '') as paytype,
                     /*Αρ. Κυκλοφορίας*/
                     a56.p702 as vehiclenum,
                     /*αντισυμβαλλόμενος*/
                     ifnull(a00.p4_1, '') as a_country, 
                     ifnull(a00.p20, '') as a_vat, 
                     ifnull(a00.p19, '') as a_name, 
                     ifnull(a00.p4, '') as a_address, 
                     concat( ifnull(concat(d22.p02 , ' '), ''), 
                                   ifnull(concat(a00.p5  , ' '), ''),
                                   ifnull(concat(a00.p6  , ' '), '')
                            ) as a_city, 
                     ifnull(a00.p7, '') as a_zip,
                     /* Web v1.153 */
                     'a00' as a_tbl,
                     ifnull(a00.nr01, 0) as a_nr01
              FROM q31
              LEFT JOIN a11 ON q31.p03=a11.p01
              LEFT JOIN a56 ON a56.p05=a11.p01
                            && a56.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && a56.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && a56.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && a56.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(a56.remdate, a56.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(a56.remdate, a56.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                            
                            ##start_module_exist_stores##
                            && a56.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##                  

              LEFT JOIN a00 ON a00.nr01=a56.p03
              LEFT JOIN d22 ON d22.p01=a00.p4_3
              WHERE q31.p01  in (620017 , 620069)
                     && a56.nr01 is not null
                     && a11.nr01 is not null
                     && a56.p414=0
                     && a56.p601a=0
                     && a56.pweb01=0
                     && {p_mydt10where} 
              GROUP BY a56.nr01
              )
              
              UNION ALL

              /***********************************************
                     Παραστατικά προς παραλαβή
                     q30.nr01=620016
              ***********************************************/
              (
              SELECT 'a56' as tbl, 
                     a56.nr01 as tbl_nr01, 
                     2 as p00,
                     2 as p01,
                     a56.p0121 as p03, 
                     a56.p09 as p06, 
                     ifnull(a11.p04, 0) as p07, 
                     a56.remdate as p08d, 
                     a56.remtime as p08t,             
                     a56.pn01 as currency, 
                     a56.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     a56.p701 as series, 
                     a56.p06  as aa, 
                     a56.p01 as issuedate, 
                     ifnull(mydt50.p00, '') as invtype, 

                     /**paytype**/           
                     ifnull( (select q31_in.p05
                                   from q31 as q31_in
                                   where q31_in.p01=620043
                                   && q31_in.p03=a56.p015
                                   limit 1), '') as paytype,
                     /*Αρ. Κυκλοφορίας*/
                     a56.p702 as vehiclenum,
                     /*αντισυμβαλλόμενος*/
                     ifnull(a00.p4_1, '') as a_country, 
                     ifnull(a00.p20, '') as a_vat, 
                     ifnull(a00.p19, '') as a_name, 
                     ifnull(a00.p4, '') as a_address, 
                     concat( ifnull(concat(d22.p02, ' '), ''), 
                                   ifnull(concat(a00.p5, ' '), ''),
                                   ifnull(concat(a00.p6, ' '), '')
                            ) as a_city, 
                     ifnull(a00.p7, '') as a_zip,
                     /* Web v1.153 */
                     'a00' as a_tbl,
                     ifnull(a00.nr01, 0) as a_nr01
              FROM q31
              LEFT JOIN a11 ON q31.p03=a11.p01
              LEFT JOIN a56 ON a56.p05=a11.p01
                            && a56.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && a56.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && a56.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && a56.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(a56.remdate, a56.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(a56.remdate, a56.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')

                            ##start_module_exist_stores##
                            && a56.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##                  
                            
              LEFT JOIN mydt50 ON mydt50.p00=q31.p05
              LEFT JOIN a00 ON a00.nr01=a56.p03
              LEFT JOIN d22 ON d22.p01=a00.p4_3
              WHERE q31.p01=620016
                     && a56.nr01 is not null
                     && a11.nr01 is not null
                     && a56.p414=0
                     && a56.p601a=0
                     && a56.pweb01=0
                     && {p_mydt10where} 
              GROUP BY a56.nr01
              )

              ) as tbl01
       )              
                     
       as tttttt ;                   