update mydt10, 
      (select mydt10.nr01 as nr01, 
              mydt10.tnetvalue as tnetvalue, 
              mydt10.tvat_am as tvat_am,
              mydt10.twthhld_am as twthhld_am, 
              mydt10.ttax_am as ttax_am,
              mydt10.tfees_am as tfees_am,
              mydt10.tstamp_am as tstamp_am,
              mydt10.tdeduction as tdeduction,
              mydt10.tgross_val as tgross_val,

              sum(ifnull(mydt11.netvalue,   0)) as netvalue, 
              sum(ifnull(mydt11.fpavalue,   0)) as fpavalue, 
              sum(ifnull(mydt11.wthhld_am,  0)) as wthhld_am, 
              sum(ifnull(mydt11.otax_am,    0)) as otax_am, 
              sum(ifnull(mydt11.fees_am,    0)) as fees_am,
              sum(ifnull(mydt11.stampvalue, 0)) as stampvalue, 
              sum(ifnull(mydt11.deducvalue, 0)) as deducvalue
       from mydt10
       left join mydt11 on mydt11.mydt10=mydt10.nr01
       where ( {peg_arr[1]} ) && mydt11.isinfo=0
       group by mydt10.nr01
      ) as tbl01
set mydt10.p04 = replace(concat(ifnull(mydt10.p04, ''), '#1#'), '##', '#'), 
    mydt10.remdate = curdate(),        
    mydt10.remtime = curtime(),        
    mydt10.remuser = '{user_pswd}'
where mydt10.nr01=tbl01.nr01
   && (    mydt10.tnetvalue <> tbl01.netvalue 
        || mydt10.tvat_am   <> tbl01.fpavalue
        || mydt10.twthhld_am<> tbl01.wthhld_am
        || mydt10.ttax_am   <> tbl01.otax_am
        || mydt10.tfees_am  <> tbl01.fees_am
        || mydt10.tstamp_am <> tbl01.stampvalue
        || mydt10.tdeduction<> tbl01.deducvalue 
        || mydt10.tgross_val<> tbl01.netvalue + tbl01.fpavalue - tbl01.wthhld_am + tbl01.otax_am + tbl01.fees_am + tbl01.stampvalue - tbl01.deducvalue
       );
/*peg_end*/
