insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t, 
currency, exchrate, 
series, aa, issuedate, invtype, paytype,  
is_country, is_vat, is_name, is_address, is_city, is_zip, 
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip)

SELECT tbl as tbl, 
       tbl_nr01 as tbl_nr01, 
       p00 as p00, 
       p01 as p01, 
       p03 as p03, 
       p06 as p06, 
       p07 as p07, 
       p08d as p08d, 
       p08t as p08t, 
       currency as currency, 
       exchrate as exchrate, 
       series as series, 
       peg_abschr(peg_abschr(aa, ''), "ABCDEFGHIJKLMNOPQRSTUVWXYZ~`@#$%^&*()-+ /?.>,<'") as aa, 
       issuedate as issuedate, 
       invtype as invtype, 
       paytype as paytype, 
       
       ''             as cp_country,
       '{nt_p101[1]}' as cp_vat, 
       '{nt_p101[2]}' as cp_name, 
       '{nt_p101[3]}' as cp_address, 
       '{nt_p101[4]}' as cp_city, 
       '{nt_p101[5]}' as cp_zip,
       a_country as is_country,
       a_vat     as is_vat, 
       a_name    as is_name, 
       a_address as is_address, 
       a_city    as is_city, 
       a_zip     as is_zip 

FROM
(
      /***********************************************
             Παραστατικά προς αποστολή
             q30.nr01=620014
      ***********************************************/
      (
      SELECT 'a55' as tbl, 
             a55.nr01 as tbl_nr01, 
             1 as p00,
             1 as p01,
             a55.p0121 as p03, 
             a55.p09 as p06, 
             ifnull(a10.p04, 0) as p07, 
             a55.remdate as p08d, 
             a55.remtime as p08t,             
             a55.pn01 as currency, 
             a55.pn02 as exchrate,
             
             /**στοιχεία παραστατικού*/
             a55.p701 as series, 
             a55.p06  as aa, 
             a55.p01 as issuedate, 
             ifnull(mydt50.p00, '') as invtype, 
             
             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=a55.p015
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a01.p4_1, '') as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a01.p4, '') as a_address, 
             concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   ) as a_city, 
             ifnull(a01.p7, '') as a_zip 
      FROM q31
      LEFT JOIN a10 ON q31.p03=a10.p01
      LEFT JOIN a55 ON a55.p05=a10.p01
                    && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    && a55.p0121>={nt_p03}
                    && a55.p0121<={nt_p04}                    
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=a55.p03
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      WHERE q31.p01=620014
         && a55.nr01 is not null
         && a10.nr01 is not null
         && a55.p414=0
         && a55.p601a=0
         && {p_mydt10where} 
      GROUP BY a55.nr01
      )
      
      UNION ALL

      /***********************************************
             Παραστατικά προς παραλαβή
             q30.nr01=620014
      ***********************************************/
      (
      SELECT 'a55' as tbl, 
             a55.nr01 as tbl_nr01, 
             1 as p00,
             2 as p01,
             a55.p0121 as p03, 
             a55.p09 as p06, 
             ifnull(a10.p04, 0) as p07, 
             a55.remdate as p08d, 
             a55.remtime as p08t,             
             a55.pn01 as currency, 
             a55.pn02 as exchrate,
       
             /**στοιχεία παραστατικού*/
             a55.p701 as series, 
             a55.p06  as aa, 
             a55.p01 as issuedate, 
             ifnull(mydt50.p00, '') as invtype, 

             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=a55.p015
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(a01.p4_1, '') as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a01.p4, '') as a_address, 
             concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   ) as a_city, 
             ifnull(a01.p7, '') as a_zip 
      FROM q31
      LEFT JOIN a10 ON q31.p03=a10.p01
      LEFT JOIN a55 ON a55.p05=a10.p01
                    && a55.p01>=cast('{odbcdtos(nt_p01)}' as date)
                    && a55.p01<=cast('{odbcdtos(nt_p02)}' as date)
                    && a55.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                    && a55.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                    && concat(a55.remdate, a55.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                    && concat(a55.remdate, a55.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                    && a55.p0121>={nt_p03}
                    && a55.p0121<={nt_p04}                    
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=a55.p03
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      WHERE q31.p01=620015
         && a55.nr01 is not null
         && a10.nr01 is not null
         && a55.p414=0
         && a55.p601a=0
         && {p_mydt10where} 
      GROUP BY a55.nr01
      )

) as tbl01;           
       