insert into {p_mydt10tbl2}
( tbl, tbl_nr01, ptbl, ptbl_nr01, comments, mydt57_p00, 
  vatcat, vatexcat, wthhldpcat, otaxpcat, stamppcat,
  feestype, invdtype, mydt61_p00, netvalue, fpavalue, wthhld_am, otax_am, fees_am, stampvalue, deducvalue )


SELECT tbl01.tbl, 
       tbl01.tbl_nr01, 
       tbl01.ptbl, 
       tbl01.ptbl_nr01, 
       tbl01.comments, 
       tbl01.mydt57_p00,
       tbl01.vatcat,
       tbl01.vatexcat,       
       tbl01.wthhldpcat,
       tbl01.otaxpcat,
       if(tbl01.stamppcat='', tbl01.stamppcat_1, tbl01.stamppcat) as stampcat,
       tbl01.feestype,
       tbl01.invdtype,
       tbl01.mydt61_p00,
       if(   wthhldpcat=''
          && otaxpcat=''  
          && feestype=''  
          && stamppcat='' 
          && stamppcat_1='', i01p011, 0) as netvalue, 
       if(vatcat<>''    , i01fp011, 0) as fpavalue, 
       if(wthhldpcat<>'', i01p011, 0) + wthhld_am as wthhld_am, 
       if(otaxpcat<>''  , i01p011, 0) + otax_am as otax_am, 
       if(feestype<>''  , i01p011, 0) as fees_am,
       if(stamppcat<>'' || stamppcat_1<>'', i01p011, 0) as stampvalue, 
       deducvalue as deducvalue 
       
FROM  
(
    /*********************************************************
           transactions
    *********************************************************/
    
    /******************************************************
            i01.records
    ******************************************************/
    (
    select i01.p011 as i01p011, 
           i01.fp011 as i01fp011, 
           0 as otax_am, 
           0 as wthhld_am,
           0 as deducvalue,
    
           'i01' as tbl, 
           i01.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           i00.pno as comments,
           
           ifnull( (select mydt_in.p00 
                    from mydt57 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620020
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt57_p00,
                            
           ifnull( (select mydt_in.p00 
                    from mydt51 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620024
                       && q31_in.p03=i13.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as vatcat,
       
           '' as vatexcat,       

           ifnull( (select mydt_in.p00 
                    from mydt53 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620026
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as wthhldpcat,

           ifnull( (select mydt_in.p00 
                    from mydt54 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620027
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as otaxpcat,

           /*** stamp from product ***/
           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620028
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat,

           /*** stamp from vat ***/
           ifnull( (select mydt_in.p00 
                    from mydt55 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620025
                       && q31_in.p03=i13.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as stamppcat_1,

           ifnull( (select mydt_in.p00 
                    from mydt56 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620029
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as feestype,
       
           '' as invdtype,
       
           ifnull( (select mydt_in.p00 
                    from mydt61 as mydt_in, 
                         q31 as q31_in
                    where q31_in.p01=620022
                       && q31_in.p03=i10.p01
                       && q31_in.p05=mydt_in.p00
                    limit 1), '') as mydt61_p00

    from {p_mydt10tbl1} as mydt10
    left join i01 on i01.p06=mydt10.tbl_nr01
                  && i01.p07=2
    left join i00 ON i00.pno=i01.p01
    left join i10 on i10.p01=i00.p62
    left join i13 on i13.p01=i01.p081
    where i00.nr01 is not null
    group by i01.nr01
    )
    
    
    UNION ALL

    /******************************************************
            krathseis a55
    ******************************************************/
    (
    select 0 as i01p011, 
           0 as i01fp011, 
           a55.p0108 as otax_am, 
           0 as wthhld_am,
           a55.vp0112 + a55.vp0113 as deducvalue,
           
    
           'a55' as tbl, 
           a55.nr01 as tbl_nr01,            
           mydt10.tbl as ptbl, 
           mydt10.tbl_nr01 as ptbl_nr01, 
           '' as comments,
           '' as mydt57_p00,
           '' as vatcat,
           '' as vatexcat,       
           '' as wthhldpcat,
           '' as otaxpcat,
           '' as stamppcat,
           '' as stamppcat_1,
           '' as feestype,
           '' as invdtype,
           '' as mydt61_p00

    from {p_mydt10tbl1} as mydt10
    left join a55 on a55.nr01=mydt10.tbl_nr01
                  && (    a55.vp0112 + a55.vp0113<>0
                       || a55.p0108<>0
                     )
    where a55.nr01 is not null
    group by a55.nr01
    )
    
    
) as tbl01    ;