/***************************************************
      delete mydt10 records with mydt10.nr01=0
***************************************************/
delete from mydt10 where nr01=0;
/*peg_end*/
delete from mydt11 where mydt10=0;
/*peg_end*/
delete from mydt12 where mydt10=0;
/*peg_end*/
delete from mydt13 where mydt10=0;
/*peg_end*/
delete from mydt14 where mydt10=0;
/*peg_end*/


/************************************************
            delete existed records
            if nt_p06=.t. 
            (only new records)
************************************************/
/**start_delete_existing_records**/
delete tbl1
from mydt10, {p_mydt10tbl1} as tbl1
where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01;
/**end_delete_existing_records**/
/*peg_end*/

/**start_delete_existing_records**/
delete tbl2
from mydt10, {p_mydt10tbl2} as tbl2
where tbl2.ptbl=mydt10.tbl
   && tbl2.ptbl_nr01=mydt10.tbl_nr01;
/**end_delete_existing_records**/
/*peg_end*/

/**start_delete_existing_records**/
delete tbl3
from mydt10, {p_mydt10tbl3} as tbl3
where tbl3.ptbl=mydt10.tbl
   && tbl3.ptbl_nr01=mydt10.tbl_nr01;
/**end_delete_existing_records**/
/*peg_end*/

/************************************************
            delete existed records
            if DA and closed
            and not to be deleted
************************************************/
delete tbl1
from mydt10, mydt50, {p_mydt10tbl1} as tbl1
where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01
   && mydt10.p02=1
   /*v1.92*/
   && mydt10.invtype=mydt50.p00
   /*v1.91*/       
   && mydt10.remguc<>'{p_mydt10mark}'
   /*v1.92*/
   && (    mydt50.p107=1
        || mydt10.isdlvno=1
      );
/*peg_end*/

delete tbl2
from mydt10, mydt50, {p_mydt10tbl2} as tbl2
where tbl2.ptbl=mydt10.tbl
   && tbl2.ptbl_nr01=mydt10.tbl_nr01
   && mydt10.p02=1        
   /*v1.92*/
   && mydt10.invtype=mydt50.p00
   /*v1.91*/       
   && mydt10.remguc<>'{p_mydt10mark}'
   /*v1.92*/
   && (    mydt50.p107=1
        || mydt10.isdlvno=1
      );
/*peg_end*/

delete tbl3
from mydt10, mydt50, {p_mydt10tbl3} as tbl3
where tbl3.ptbl=mydt10.tbl
   && tbl3.ptbl_nr01=mydt10.tbl_nr01
   && mydt10.p02=1        
   /*v1.92*/
   && mydt10.invtype=mydt50.p00
   /*v1.91*/       
   && mydt10.remguc<>'{p_mydt10mark}'
   /*v1.92*/
   && (    mydt50.p107=1
        || mydt10.isdlvno=1
      );
/*peg_end*/


/****************************************************
      delete records with no transacions
****************************************************/
delete tbl1 
from {p_mydt10tbl1} as tbl1
left join {p_mydt10tbl2} as tbl2 on tbl1.tbl=tbl2.ptbl
                                  && tbl1.tbl_nr01=tbl2.ptbl_nr01
where tbl2.ptbl_nr01 is null;
/*peg_end*/

/*****************************************
   update mydt10 is_xxx and cp_xxx
   from t05
*****************************************/
/**start_stores**/
update {p_mydt10tbl1} as tbl1, t07, t05
set is_vat     = if(tbl1.p00=1, t05.p204, tbl1.is_vat), 
    is_name    = if(tbl1.p00=1, concat(t05.p203, ' ', t05.p2031, ' ', t05.p2032), tbl1.is_name), 
    is_address = if(tbl1.p00=1, concat(t05.p207, ' ', t05.p208), tbl1.is_address), 
    is_city    = if(tbl1.p00=1, t05.p206, tbl1.is_city), 
    is_zip     = if(tbl1.p00=1, t05.p209, tbl1.is_zip), 

    is_tbl     = if(tbl1.p00=1, 't05',    tbl1.is_tbl), 
    is_nr01    = if(tbl1.p00=1, t05.nr01, tbl1.is_nr01), 
    
    cp_vat     = if(tbl1.p00=2, t05.p204, tbl1.cp_vat), 
    cp_name    = if(tbl1.p00=2, concat(t05.p203, ' ', t05.p2031, ' ', t05.p2032), tbl1.cp_name), 
    cp_address = if(tbl1.p00=2, concat(t05.p207, ' ', t05.p208), tbl1.cp_address), 
    cp_city    = if(tbl1.p00=2, t05.p206, tbl1.cp_city), 
    cp_zip     = if(tbl1.p00=2, t05.p209, tbl1.cp_zip),

    cp_tbl     = if(tbl1.p00=2, 't05',    tbl1.cp_tbl), 
    cp_nr01    = if(tbl1.p00=2, t05.nr01, tbl1.cp_nr01) 
    
where tbl1.p03=t07.p01
   && t05.p01=t07.p07   
   && t05.p204<>''
   -- && mydt01.p100=t05.p01
   ;
/**end_stores**/
/*peg_end*/

/*v1.60*/
/**************************************************
    update mydt10.einv (from input parameter)
     or from mydt10 if old and closed record 
**************************************************/
update {p_mydt10tbl1} 
set einv={nt_p010}, 
    einv_nr={nt_p011}
where {nt_p010}<>0
   && {nt_p011}<>0
   && tbl not in ('eleo20_43');
/*peg_end*/

update mydt10, {p_mydt10tbl1} as tbl1
set tbl1.einv=mydt10.einv, 
    tbl1.einv_nr=mydt10.einv_nr
where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01
   && mydt10.p02=1
   && mydt10.tbl not in ('eleo20_43');
/*peg_end*/


/*****************************************
      update mydt10 branch from t07
*****************************************/
/**start_stores**/
update {p_mydt10tbl1} as tbl1, t07
set tbl1.is_branch=if(tbl1.p00=1, cast(t07.p06 as decimal), tbl1.is_branch), 
    tbl1.cp_branch=if(tbl1.p00=2, cast(t07.p06 as decimal), tbl1.cp_branch) 
where tbl1.p03=t07.p01
   && cast(t07.p06 as decimal)<>0;
/**end_stores**/
/*peg_end*/

/************************************************
    puid (mydt10.pnr01)
    see mydt10_d integrity method too
        and p21.f_mydata
************************************************/
update {p_mydt10tbl1}
set pnr01=substr( concat(is_vat, '#', 
                         date_format(issuedate, '%Y%m%d'), '#', 
                         is_branch, '#', 
                         invtype, '#', 
                         series, '#', 
                         aa, '#', 
                         cp_vat, '#'), 1, 100);
/*peg_end*/

/*ενημερώνει το mydt10.pnr01 με τον ίδιο τρόπο ώστε να συγκρίνει ίδια πράγματα*/
/*Το απενεργοποιούμε γιατί δημιουργούσε θέματα*/
/*update mydt10, {p_mydt10tbl1} as tbl1
set mydt10.pnr01=substr( concat(mydt10.is_vat, '#', 
                                date_format(mydt10.issuedate, '%Y%m%d'), '#', 
                                mydt10.is_branch, '#', 
                                mydt10.invtype, '#', 
                                mydt10.series, '#', 
                                mydt10.aa, '#', 
                                mydt10.cp_vat, '#'), 1, 100), 
    mydt10.remdate=curdate(), 
    mydt10.remtime=curtime(), 
    mydt10.remuser='{user_pswd}' 

where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01
   && mydt10.pnr01<> substr( concat(mydt10.is_vat, '#', 
                                    date_format(mydt10.issuedate, '%Y%m%d'), '#', 
                                    mydt10.is_branch, '#', 
                                    mydt10.invtype, '#', 
                                    mydt10.series, '#', 
                                    mydt10.aa, '#', 
                                    mydt10.cp_vat, '#'), 1, 100);
*/
/*peg_end*/

/************************************************
   unlink old records if pnr01 is changed 
   and mydt10.p02=1
   Set them as deleted.
************************************************/
update mydt10, mydt11, {p_mydt10tbl1} as tbl1
set mydt10.tbl=concat('#', mydt10.tbl, '#'),
    mydt10.p05=1, 
    mydt10.remdate=curdate(), 
    mydt10.remtime=curtime(), 
    mydt10.remuser='{user_pswd}', 
    
    mydt11.tbl=concat('#', mydt11.tbl, '#'),
    mydt11.remdate=curdate(), 
    mydt11.remtime=curtime(), 
    mydt11.remuser='{user_pswd}'
where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01
   && mydt10.nr01=mydt11.mydt10
   && mydt10.p02=1
   && mydt10.p01=1
   && mydt10.p09=0
   && mydt10.p05<>1
   && mydt10.einv=0
   && tbl1.pnr01<>mydt10.pnr01
   && mydt10.pnr01<>substr( concat(tbl1.is_vat, '#', 
                                     date_format(tbl1.issuedate, '%Y%m%d'), '#', 
                                     tbl1.is_branch, '#', 
                                     tbl1.invtype, '#', 
                                     if(tbl1.series='0', '', tbl1.series) , '#', 
                                     tbl1.aa, '#', 
                                     tbl1.cp_vat, '#'), 1, 100)    
   ;
/*peg_end*/

/************************************************
            link old records
************************************************/
update mydt10, {p_mydt10tbl1} as tbl1
set tbl1.nr01=mydt10.nr01, 
    tbl1.mark=mydt10.mark,
    tbl1.p02=mydt10.p02,
    tbl1.p02_1=mydt10.p02_1, 
    tbl1.p010=mydt10.p010
where tbl1.tbl=mydt10.tbl
   && tbl1.tbl_nr01=mydt10.tbl_nr01;
/*peg_end*/

/**add mydt10 too - ignores mydt11 records no linked with mydt10**/
update mydt11, {p_mydt10tbl2} as tbl2, mydt10
set tbl2.nr01=mydt11.nr01
where tbl2.tbl=mydt11.tbl
   && tbl2.tbl_nr01=mydt11.tbl_nr01
   && mydt10.nr01=mydt11.mydt10;
/*peg_end*/

update mydt13, {p_mydt10tbl3} as tbl3, mydt10
set tbl3.nr01=mydt13.nr01
where tbl3.tbl=mydt13.tbl
   && tbl3.tbl_nr01=mydt13.tbl_nr01
   && mydt10.nr01=mydt13.mydt10;
/*peg_end*/

update mydt14, {p_mydt10tbl4} as tbl4, mydt10
set tbl4.nr01 = mydt14.nr01
where tbl4.tbl=mydt14.tbl
   && tbl4.tbl_nr=mydt14.tbl_nr
   && mydt10.nr01=mydt14.mydt10;
/*peg_end*/

/***************************************
   delete temp lines with no values
   not delete zero i01 sales 
***************************************/
delete from {p_mydt10tbl2}
where netvalue=0
   && wthhld_am=0
   && otax_am=0
   && fees_am=0
   && stamppcat=''
   && fpavalue=0 
   && stampvalue=0 
   && deducvalue=0
   /*v1.90*/
   && tbl not in ('i01', 'tran01', 'tran02', 'eleo20', 'c78');
/*peg_end*/

/******************************************
     set invtype=relative invtype
     στα αντιστοιχισμένα
******************************************/
update {p_mydt10tbl1} as tbl1,
       mydt10, mydt00
set tbl1.invtype=mydt10.invtype       
where mydt00.nr01=1
   && mydt00.p107=1
   && tbl1.nr01 = mydt10.rel_nr
   && mydt10.rel_nr!=0
   && mydt10.p09 = 1;
/*peg_end*/


/*********************************************************************************************
    delete antistoixismena 
    tbl1.nr01 = mydt10.rel_nr and mydt10.p09 = 1 (created by myDATA)
**********************************************************************************************/
/*********************************************************************************************
    Τα κρατάμε για να μπορεί να γίνει επαναδημιουργία χαρακτηριστικών μετά την αντιστοίχιση
    με βάση το παραστατικό του προμηθευτή. 
**********************************************************************************************/
/*delete tbl2
from {p_mydt10tbl1} as tbl1, 
     {p_mydt10tbl2} as tbl2,
     mydt10
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01
   && tbl1.nr01 = mydt10.rel_nr
   && mydt10.rel_nr!=0
   && mydt10.p09 = 1;
 */
/*peg_end*/

/*
delete tbl1
from {p_mydt10tbl1} as tbl1,
     mydt10
where 
     tbl1.nr01 = mydt10.rel_nr
     && mydt10.rel_nr!=0
     && mydt10.p09 = 1;
*/
/*peg_end*/


/*****************************************
    delete marked old records
    if no resend or e-innvoicing
*****************************************/
delete tbl2
from {p_mydt10tbl1} as tbl1, 
     {p_mydt10tbl2} as tbl2
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01
   && (    ( tbl1.p02=1 && ( tbl1.p02_1=0 || tbl1.einv<>0) )
        || ( tbl1.p010=1)
      )  ;
/*peg_end*/

delete tbl1
from {p_mydt10tbl1} as tbl1
where (    ( tbl1.p02=1 && ( tbl1.p02_1=0 || tbl1.einv<>0) )
        || ( tbl1.p010=1)
      )  ;

/*peg_end*/

/****************************************************
      delete records with no transacions
      again
****************************************************/
delete tbl1 
from {p_mydt10tbl1} as tbl1
left join {p_mydt10tbl2} as tbl2 on tbl1.tbl=tbl2.ptbl
                                  && tbl1.tbl_nr01=tbl2.ptbl_nr01
where tbl2.ptbl_nr01 is null;
/*peg_end*/


/***************************************
    initial values from mydt98
***************************************/
update {p_mydt10tbl1} as tbl1, 
       {p_mydt10tbl2} as tbl2, 
       mydt00
set tbl2.mydt57_p00=if(tbl2.mydt57_p00='', mydt00.p01, tbl2.mydt57_p00), 
    tbl2.mydt61_p00=if(tbl2.mydt61_p00='', mydt00.p02, tbl2.mydt61_p00)
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01
   && tbl1.p00=1
   && mydt00.nr01=1
   && (    ( tbl2.mydt57_p00='' && mydt00.p01<>'' )
        || ( tbl2.mydt61_p00='' && mydt00.p02<>'' )
      );
/*peg_end*/      

update {p_mydt10tbl1} as tbl1, 
       {p_mydt10tbl2} as tbl2, 
       mydt00
set tbl2.mydt58_p00=if(tbl2.mydt58_p00='', mydt00.p03, tbl2.mydt58_p00), 
    tbl2.mydt62_p00=if(tbl2.mydt62_p00='', mydt00.p04, tbl2.mydt62_p00)
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01
   && tbl1.p00=2
   && mydt00.nr01=1
   && (    ( tbl2.mydt58_p00='' && mydt00.p01<>'' )
        || ( tbl2.mydt62_p00='' && mydt00.p02<>'' )
      );
/*peg_end*/      


/***************************************
     mydt10 correct values (using default)
***************************************/
update {p_mydt10tbl1} as tbl1
set tbl1.currency='EUR' 
where tbl1.currency in('', '0');
/*peg_end*/      

update {p_mydt10tbl1} as tbl1
set tbl1.exchrate=1 
where tbl1.exchrate=0;
/*peg_end*/      

update {p_mydt10tbl1} as tbl1
set tbl1.cp_country='GR' 
where tbl1.cp_country='';
/*peg_end*/      

update {p_mydt10tbl1} as tbl1
set tbl1.is_country='GR' 
where tbl1.is_country='';
/*peg_end*/      

/*update {p_mydt10tbl1} as tbl1
set tbl1.series='0' 
where tbl1.series='';
*/
/*peg_end*/      

update {p_mydt10tbl1} as tbl1
set tbl1.paytype='5' 
where tbl1.paytype='';
/*peg_end*/      

 

/***************************************
      mydt10.new nr01
***************************************/
/**start_only_temp_records**/
update {p_mydt10tbl1}
set nr01=peg_new_nr01('mydt10', 1) 
where nr01=0;
/**end_only_temp_records**/
/*peg_end*/

update {p_mydt10tbl1} as tbl1, {p_mydt10tbl2} as tbl2
set tbl2.mydt10=tbl1.nr01
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01;
/*peg_end*/

update {p_mydt10tbl1} as tbl1, {p_mydt10tbl3} as tbl3
set tbl3.mydt10=tbl1.nr01
where tbl1.tbl=tbl3.ptbl
   && tbl1.tbl_nr01=tbl3.ptbl_nr01;
/*peg_end*/

update {p_mydt10tbl1} as tbl1, {p_mydt10tbl4} as tbl2
set tbl2.mydt10=tbl1.nr01
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01;
/*peg_end*/

/***************************************
      mydt11.new nr01
***************************************/
/**start_only_temp_records**/
update {p_mydt10tbl2}
set nr01=peg_new_nr01('mydt11', 1) 
where nr01=0;
/**end_only_temp_records**/
/*peg_end*/


/***************************************
      mydt13.new nr01
***************************************/
/**start_only_temp_records**/
update {p_mydt10tbl3}
set nr01 = peg_new_nr01('mydt13', 1) 
where nr01 = 0;
/**end_only_temp_records**/
/*peg_end*/

/***************************************
      mydt14.new nr01
***************************************/
/**start_only_temp_records**/
update {p_mydt10tbl4}
set nr01 = peg_new_nr01('mydt14', 1) 
where nr01 = 0;
/**end_only_temp_records**/
/*peg_end*/

/***************************************
       linenumbers
***************************************/
SET @prnr1=0, @prnr2=0, @n1=0;
/*peg_end*/

update {p_mydt10tbl2} as tbl2, 
      (SELECT tbl2.nr01, 
              tbl2.mydt10, 
              @prnr1:=tbl2.mydt10,
              @n1:=if(@prnr1=@prnr2, @n1+1, 1) as linenumber, 
              @prnr2:=tbl2.mydt10
       FROM {p_mydt10tbl2} as tbl2
       order by mydt10, nr01
      ) as tbl01
set tbl2.linenumber=tbl01.linenumber
where tbl2.nr01=tbl01.nr01;
/*peg_end*/

/*************************************
   update e3 fields from mydt40
*************************************/
UPDATE {p_mydt10tbl2} as mydt11, mydt40, 
    (SELECT mydt11.nr01 as nr01, 
            ifnull( (select mydt40_in.nr01
                     from mydt40 as mydt40_in
                     where mydt40_in.p02=mydt11.mydt57_p00                        
                        && (   locate( concat('#', mydt10.p07, '#'), mydt40_in.p01)>0
                            || ifnull(mydt40_in.p01, '')=''
                            )
                        && (   locate( concat('#', mydt10.invtype, '#'), mydt40_in.p08)>0
                            || ifnull(mydt40_in.p08, '')=''
                            )
                        && (   mydt40_in.p03=mydt10.p06
                            || mydt40_in.p03=0
                           )
                        && (   mydt40_in.p04=mydt11.vatcat
                            || mydt40_in.p04=''
                           )
                     order by if(mydt40_in.p03<>0 && mydt40_in.p04<>'', 4, 0)
                            + if(mydt40_in.p03<>0 && mydt40_in.p04='',  3, 0)      
                            + if(mydt40_in.p03=0  && mydt40_in.p04<>'', 2, 0)      
                            + if(mydt40_in.p03=0  && mydt40_in.p04='',  1, 0) desc
                     limit 1), 0) as mydt40nr01
                            
     FROM {p_mydt10tbl1} as mydt10, 
          {p_mydt10tbl2} as mydt11 
     WHERE mydt11.mydt10=mydt10.nr01       
    ) as tbl1
SET mydt11.mydt61_p00=if(mydt40.p05<>'', mydt40.p05, mydt11.mydt61_p00), 
    mydt11.vatexcat  =if(mydt11.vatexcat='' && mydt40.p06<>'', mydt40.p06, mydt11.vatexcat)  
where mydt11.nr01=tbl1.nr01
   && mydt40.nr01=tbl1.mydt40nr01
   && tbl1.mydt40nr01<>0;
/*peg_end*/

/*************************************
   update e3 fields from mydt41
*************************************/
UPDATE {p_mydt10tbl2} as mydt11, mydt41, 
    (SELECT mydt11.nr01 as nr01, 
            ifnull( (select mydt41_in.nr01
                     from mydt41 as mydt41_in
                     where mydt41_in.p02=mydt11.mydt58_p00                        
                        && (   locate( concat('#', mydt10.p07, '#'), mydt41_in.p01)>0
                            || ifnull(mydt41_in.p01, '')=''
                            )
                        && (   locate( concat('#', mydt10.invtype, '#'), mydt41_in.p08)>0
                            || ifnull(mydt41_in.p08, '')=''
                            )
                        && (   mydt41_in.p03=mydt10.p06
                            || mydt41_in.p03=0
                           )
                        && (   mydt41_in.p04=mydt11.vatcat
                            || mydt41_in.p04=''
                           )
                     order by if(mydt41_in.p03<>0 && mydt41_in.p04<>'', 4, 0)
                            + if(mydt41_in.p03<>0 && mydt41_in.p04='',  3, 0)      
                            + if(mydt41_in.p03=0  && mydt41_in.p04<>'', 2, 0)      
                            + if(mydt41_in.p03=0  && mydt41_in.p04='',  1, 0) desc
                     limit 1), 0) as mydt41nr01
                            
     FROM {p_mydt10tbl1} as mydt10, 
          {p_mydt10tbl2} as mydt11 
     WHERE mydt11.mydt10=mydt10.nr01       
    ) as tbl1
SET mydt11.mydt62_p00=if(mydt41.p05<>'', mydt41.p05, mydt11.mydt62_p00), 
    mydt11.mydt62_p01=if(mydt41.p07<>'', mydt41.p07, mydt11.mydt62_p01), 
    mydt11.vatexcat  =if(mydt11.vatexcat='' && mydt41.p06<>'', mydt41.p06, mydt11.vatexcat) 
where mydt11.nr01=tbl1.nr01
   && mydt41.nr01=tbl1.mydt41nr01
   && tbl1.mydt41nr01<>0;
/*peg_end*/

/***********************************************
         default vatexcat
***********************************************/
/********************
   from mydt00.p05
********************/
UPDATE {p_mydt10tbl2} as mydt11, mydt00
set mydt11.vatexcat=mydt00.p05
where mydt00.nr01=1
   && mydt00.p05<>''
   && mydt11.vatcat='7'
   && mydt11.vatexcat='';
/*peg_end*/

/*********************
    vatexcat='27'
*********************/
UPDATE {p_mydt10tbl2} as mydt11
set mydt11.vatexcat='27'
where mydt11.vatcat='7'
   && mydt11.vatexcat='';
/*peg_end*/


/**************************************
    Παραστατικό 8.2
**************************************/
/*
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11 
set mydt11.rectype ='3'               , 
    mydt11.netvalue = mydt11.otax_am  ,
    mydt11.otax_am  = 0
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.invtype in ('8.2');
*/   
/*peg_end*/

/************************************************
     update deducvalue and wthhld_am as abs
************************************************/
update {p_mydt10tbl2} as mydt11
set deducvalue=abs(deducvalue)
WHERE deducvalue<0;
/*peg_end*/

update {p_mydt10tbl2} as mydt11
set wthhld_am=abs(wthhld_am)
WHERE wthhld_am<0;
/*peg_end*/

/************************************************
     update deducvalue 
     if wthhldpcat='peg01'
     transfer 
************************************************/
update {p_mydt10tbl2} as mydt11
set deducvalue=deducvalue + wthhld_am
WHERE wthhldpcat='peg01'
   && wthhld_am<>0;
/*peg_end*/

update {p_mydt10tbl2} as mydt11
set wthhldpcat='', 
    wthhld_am=0
WHERE wthhldpcat='peg01'
   && wthhld_am<>0;
/*peg_end*/

/************************************************
       update rectype
************************************************/
update {p_mydt10tbl2} as mydt11
set mydt11.rectype = if(mydt11.feestype<>'', 2, 0) + if(mydt11.otaxpcat<>'', 3, 0), 
    mydt11.netvalue= mydt11.fees_am + mydt11.otax_am
where (    mydt11.feestype<>''
        || mydt11.otaxpcat<>''
      )
   && mydt11.fpavalue<>0;
/*peg_end*/

update {p_mydt10tbl2} as mydt11
set fees_am=0, 
    otax_am=0
where rectype in (2, 3);
/*peg_end*/
        
      
/*******************************************************************
        Μεταφορά των φόρων στο taxesTotals (taxtype<>'')
        Για να γίνει η μεταφορά τους, ελέγχεται επιπλέον η συνθήκη ότι υπάρχει έστω ενα mydt11 στο παραστατικό που δεν είναι φόρος
*******************************************************************/
/***************************************************
     set taxtype, taxcat, taxamount
***************************************************/
UPDATE {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11, 
       ( Select ptbl as ptbl, 
                ptbl_nr01 as ptbl_nr01, 
                sum( if(    wthhldpcat='' 
                         && feestype='' 
                         && otaxpcat='' 
                         && stamppcat='' 
                         && deducvalue=0, 1, 0)) as plit
         from {p_mydt10tbl2}
         group by ptbl, ptbl_nr01) as mydt11_sum
                         
set mydt11.taxtype= coalesce( if(mydt11.wthhldpcat='', null, '1'),
                              if(mydt11.feestype='',   null, '2'),
                              if(mydt11.otaxpcat='',   null, '3'),
                              if(mydt11.stamppcat='',  null, '4'),
                              if(mydt11.deducvalue=0,  null, '5'),
                              ''
                             ), 
    mydt11.taxcat  = coalesce(if(mydt11.wthhldpcat='', null, wthhldpcat),
                              if(mydt11.feestype='',   null, feestype),
                              if(mydt11.otaxpcat='',   null, otaxpcat),
                              if(mydt11.stamppcat='',  null, stamppcat),
                              if(mydt11.deducvalue=0,  null, ''),
                              ''
                             ), 
    mydt11.taxamount=mydt11.netvalue + mydt11.fpavalue + mydt11.wthhld_am + mydt11.otax_am + mydt11.fees_am + mydt11.stampvalue + mydt11.deducvalue     
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt10.tbl=mydt11_sum.ptbl
   && mydt10.tbl_nr01=mydt11_sum.ptbl_nr01
   && mydt11_sum.plit>0
   && (   mydt11.wthhldpcat<>'' 
       || mydt11.feestype<>''
       || mydt11.otaxpcat<>''
       || mydt11.stamppcat<>''
       || mydt11.deducvalue<>0
      ) 
   && mydt11.rectype not in (2, 3)
   && mydt10.invtype in ('1.1', '1.2', '1.3', '1.4', '1.5', '1.6', 
                         '2.1', '2.2', '2.3', '2.4',  
                         '3.1', '3.2',
                         '5.1', '5.2', 
                         '8.1', 
                         '11.1' 
                        );
/*peg_end*/

/***********************************************
     add netvalue and fpavalue to taxes
***********************************************/
UPDATE {p_mydt10tbl2} as mydt11
SET wthhld_am = if(wthhldpcat<>'', taxamount, 0), 
    otax_am   = if(otaxpcat<>'',   taxamount, 0), 
    fees_am   = if(feestype<>'',   taxamount, 0), 
    stampvalue= if(stamppcat<>'',  taxamount, 0), 
    deducvalue= if(deducvalue<>0,  taxamount, 0) 
WHERE taxtype<>''
   && mydt11.rectype not in (2, 3);
/*peg_end*/

/***********************************************
     delete netvalue and fpavalue from taxes
***********************************************/
UPDATE {p_mydt10tbl2} as mydt11
SET netvalue=0, 
    fpavalue=0
WHERE taxtype<>''
   && mydt11.rectype not in (2, 3);
/*peg_end*/

/***************************************
    set rectype=7
    Τα αρνητικά γίνονται θετικά και 
    το rectype=7
***************************************/
/*v1.99*/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl2} as mydt11, 
       mydt50
set mydt11.rectype=7,
    mydt11.netvalue  = abs(mydt11.netvalue),
    mydt11.fpavalue  = abs(mydt11.fpavalue),  
    mydt11.wthhld_am = abs(mydt11.wthhld_am), 
    mydt11.otax_am   = abs(mydt11.otax_am),   
    mydt11.fees_am   = abs(mydt11.fees_am),   
    mydt11.stampvalue= abs(mydt11.stampvalue),
    mydt11.deducvalue= abs(mydt11.deducvalue)
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && mydt50.p00=mydt10.invtype
   && mydt50.p112=1
   && mydt11.rectype=0
   && (    mydt11.netvalue<0
        || mydt11.fpavalue<0
        || mydt11.wthhld_am<0
        || mydt11.otax_am<0
        || mydt11.fees_am<0
        || mydt11.stampvalue<0
        || mydt11.deducvalue<0
      );
/*peg_end*/
   

/***************************************
      update totals into mydt10
      look mydt10p011 too if change
***************************************/
/*v1.99*/
update {p_mydt10tbl1} as tbl1,
     (select ptbl as ptbl, 
             ptbl_nr01 as ptbl_nr01, 
             sum(netvalue)   as netvalue, 
             sum(fpavalue)   as fpavalue, 
             sum(wthhld_am)  as wthhld_am, 
             sum(otax_am)    as otax_am, 
             sum(fees_am)    as fees_am,
             sum(stampvalue) as stampvalue, 
             sum(deducvalue) as deducvalue, 
             /*v1.99*/
             sum(if(rectype=7, -1, 1) * netvalue)   as init_netvalue, 
             sum(if(rectype=7, -1, 1) * fpavalue)   as init_fpavalue, 
             sum(if(rectype=7, -1, 1) * wthhld_am)  as init_wthhld_am, 
             sum(if(rectype=7, -1, 1) * otax_am)    as init_otax_am, 
             sum(if(rectype=7, -1, 1) * fees_am)    as init_fees_am,
             sum(if(rectype=7, -1, 1) * stampvalue) as init_stampvalue, 
             sum(if(rectype=7, -1, 1) * deducvalue) as init_deducvalue, 
             if(group_concat(fuelcode SEPARATOR '') <> '', 1, 0) AS has_fuelcode
      from {p_mydt10tbl2}
      group by ptbl, ptbl_nr01
     ) as tbl2, mydt50
set tbl1.tnetvalue=tbl2.netvalue, 
    tbl1.tvat_am=tbl2.fpavalue,
    tbl1.twthhld_am=tbl2.wthhld_am,
    tbl1.ttax_am=tbl2.otax_am,
    tbl1.tfees_am=tbl2.fees_am,
    tbl1.tstamp_am=tbl2.stampvalue,
    tbl1.tdeduction=tbl2.deducvalue, 
    tbl1.tgross_val = tbl2.netvalue + tbl2.fpavalue - tbl2.wthhld_am + tbl2.otax_am + tbl2.fees_am + tbl2.stampvalue - tbl2.deducvalue, 
    /*v1.100*/
    tbl1.tgross = if( tbl1.invtype in ('8.6'), 
                      tbl2.netvalue + tbl2.fpavalue - tbl2.wthhld_am + tbl2.otax_am + tbl2.fees_am + tbl2.stampvalue - tbl2.deducvalue,  
                      tbl2.init_netvalue + tbl2.init_fpavalue - tbl2.init_wthhld_am + tbl2.init_otax_am 
                     + tbl2.init_fees_am + tbl2.init_stampvalue - tbl2.init_deducvalue
                    ), 
    tbl1.fuelinv = if(mydt50.p107=1 , 0,  tbl2.has_fuelcode)
where tbl1.tbl=tbl2.ptbl
   && tbl1.tbl_nr01=tbl2.ptbl_nr01
   && tbl1.invtype=mydt50.p00;
/*peg_end*/


/***************************************
   delete mydt11 lines with no values
   if mydt10 has values
***************************************/
delete mydt11
from {p_mydt10tbl1} as mydt10, 
     {p_mydt10tbl2} as mydt11
where mydt10.tbl=mydt11.ptbl
   && mydt10.tbl_nr01=mydt11.ptbl_nr01
   && (    mydt10.tnetvalue  <>0
        || mydt10.tvat_am    <>0
        || mydt10.twthhld_am <>0
        || mydt10.tfees_am   <>0
        || mydt10.tstamp_am  <>0
        || mydt10.ttax_am    <>0
        || mydt10.tdeduction <>0
        || mydt10.tgross_val <>0
      )
   && mydt11.wthhld_am=0
   && mydt11.netvalue  =0
   && mydt11.fpavalue  =0 
   && mydt11.stampvalue=0
   && mydt11.fees_am=0
   && mydt11.otax_am=0
   && mydt11.deducvalue =0
   && mydt11.p101 =0
   && mydt11.p101f =0
   && mydt11.p102 =0
   && mydt11.p102f =0
   && mydt11.p103 =0
   && mydt11.p103f =0
   && mydt11.isinfo =0
/*peg_end*/

/******************************************
     set fuelinv=relative fuelinv
     στα αντιστοιχισμένα
******************************************/
update {p_mydt10tbl1} as tbl1,
       mydt10
set tbl1.fuelinv=mydt10.fuelinv
where tbl1.nr01 = mydt10.rel_nr
   && mydt10.rel_nr!=0
   && mydt10.p09 = 1;
/*peg_end*/

/**************************************************
    update cinvtype (correlated document code)
**************************************************/
update {p_mydt10tbl1} as mydt10 
set mydt10.cinvtype='';
/*peg_end*/
   

/* search relatives into temporary*/
update {p_mydt10tbl1} as mydt10, 
       {p_mydt10tbl1} as mydt10_1, 
       mydt50
set mydt10.cinvtype=mydt10_1.invtype
where mydt10.invtype=mydt50.p00
   && mydt10.invtype='5.1'
   && mydt50.p103=0
   && ifnull(mydt10.pcor, '')<>''
   && ifnull(mydt10.cinvtype, '')=''
   && mydt10.tbl=mydt10_1.tbl
   && locate(concat('#', mydt10_1.tbl_nr01, '#'), ifnull(mydt10.pcor, ''))>0;
/*peg_end*/
   
/* search relatives into mydt10*/
update {p_mydt10tbl1} as mydt10, 
       mydt10 as mydt10_1, 
       mydt50
set mydt10.cinvtype=mydt10_1.invtype
where mydt10.invtype=mydt50.p00
   && mydt10.invtype='5.1'
   && mydt50.p103=0
   && ifnull(mydt10.pcor, '')<>''
   && ifnull(mydt10.cinvtype, '')=''
   && mydt10.tbl=mydt10_1.tbl
   && locate(concat('#', mydt10_1.tbl_nr01, '#'), ifnull(mydt10.pcor, ''))>0;
/*peg_end*/
   
    