/******************************************************************
   set line number =0 and marks as to be deleted lines not exists
******************************************************************/
update mydt14,
	(SELECT mydt14.nr01
	 FROM {p_mydt10tbl1} as tbl1
	 LEFT JOIN mydt14 ON mydt14.mydt10=tbl1.nr01
	 LEFT JOIN {p_mydt10tbl4} as tbl4 ON tbl4.nr01=mydt14.nr01
	 WHERE mydt14.nr01 is not null
	    && tbl4.nr01 is null
	) as tbl01
SET mydt14.remguc=:p_mydt10mark
WHERE mydt14.nr01=tbl01.nr01;
/*peg_end*/


/*****************************************************
	update old records
*****************************************************/
update mydt10, mydt14, {p_mydt10tbl4} as tbl1
set
	mydt14.tbl		= tbl1.tbl,
	mydt14.tbl_nr	= tbl1.tbl_nr,
	mydt14.mydt10		= tbl1.mydt10,

	mydt14.type		= tbl1.type,
	mydt14.branch		= tbl1.branch,
	mydt14.vat		= tbl1.vat,
	mydt14.country	= tbl1.country,
	mydt14.name		= tbl1.name,
	mydt14.address	= tbl1.address,
	mydt14.city		= tbl1.city,
	mydt14.zip		= tbl1.zip,

	mydt14.remdate        = curdate(),
	mydt14.remtime        = curtime(),
	mydt14.remuser        = :user_pswd,
	mydt10.p30 = '',
	mydt10.remdate        = curdate(),
	mydt10.remtime        = curtime(),
	mydt10.remuser        = :user_pswd,
	mydt10.remguc		 = :p_mydt10tot

where mydt14.nr01 = tbl1.nr01
   && mydt10.nr01 = mydt14.mydt10
   && (   mydt14.tbl            <> tbl1.tbl
	|| mydt14.tbl_nr       <> tbl1.tbl_nr
	|| mydt14.mydt10         <> tbl1.mydt10

	|| mydt14.type	<> tbl1.type
	|| mydt14.branch	<> tbl1.branch
	|| mydt14.vat		<> tbl1.vat
	|| mydt14.country	<> tbl1.country
	|| mydt14.name	<> tbl1.name
	|| mydt14.address	<> tbl1.address
	|| mydt14.city	<> tbl1.city
	|| mydt14.zip		<> tbl1.zip
     );
/*peg_end*/

INSERT INTO mydt14
(
	nr01,
	tbl,
	tbl_nr,
	mydt10,

	`type`,
	branch,
	vat,
	country,
	`name`,
	`address`,
	city,
	zip,

 	remfdate,
	remftime,
	remfuser,
	remdate,
	remtime,
	remuser,
	remguc
)
SELECT
	tbl1.nr01,
	tbl1.tbl,
	tbl1.tbl_nr,
	tbl1.mydt10,

	tbl1.type,
	tbl1.branch,
	tbl1.vat,
	tbl1.country,
	tbl1.name,
	tbl1.address,
	tbl1.city,
	tbl1.zip,

	curdate() as remfdate,
	curtime() as remftime,
	:user_pswd as remfuser,
	curdate() as remdate,
	curtime() as remtime,
	:user_pswd as remuser,
	:p_mydt10tot as remguc
FROM {p_mydt10tbl4} as tbl1
LEFT JOIN mydt14 ON mydt14.nr01=tbl1.nr01
WHERE mydt14.nr01 is null;
/*peg_end*/