SELECT 
       count(*) as cnt 

FROM 
       (

              SELECT tbl as tbl, 
                     tbl_nr01 as tbl_nr01, 
                     p00 as p00, 
                     p01 as p01, 
                     p03 as p03, 
                     p06 as p06, 
                     p07 as p07, 
                     p08d as p08d, 
                     p08t as p08t, 
                     currency as currency, 
                     exchrate as exchrate, 
                     series as series, 
                     aa as aa, 
                     issuedate as issuedate, 
                     invtype as invtype, 
                     if( mkfs in (2, 3), '', a_country)     as is_country, 
                     if( mkfs in (2, 3), '{nt_p101[1]}', a_vat)     as is_vat, 
                     if( mkfs in (2, 3), '{nt_p101[2]}', a_name)    as is_name, 
                     if( mkfs in (2, 3), '{nt_p101[3]}', a_address) as is_address, 
                     if( mkfs in (2, 3), '{nt_p101[4]}', a_city)    as is_city, 
                     if( mkfs in (2, 3), '{nt_p101[5]}', a_zip)     as is_zip, 
                     /* Web v1.153 */
                     if( mkfs in (2, 3), '{nt_p101[6]}', a_tbl)      as is_tbl, 
                     if( mkfs in (2, 3), '{nt_p101[7]}', a_nr01)     as is_nr01, 
                     if( mkfs not in (2, 3), '', a_country)             as cp_country, 
                     if( mkfs not in (2, 3), '{nt_p101[1]}', a_vat)     as cp_vat, 
                     if( mkfs not in (2, 3), '{nt_p101[2]}', a_name)    as cp_name, 
                     if( mkfs not in (2, 3), '{nt_p101[3]}', a_address) as cp_address, 
                     if( mkfs not in (2, 3), '{nt_p101[4]}', a_city)    as cp_city, 
                     if( mkfs not in (2, 3), '{nt_p101[5]}', a_zip)     as cp_zip,
                     /* Web v1.153 */
                     if( mkfs not in (2, 3), '{nt_p101[6]}', a_tbl)     as cp_tbl, 
                     if( mkfs not in (2, 3), '{nt_p101[7]}', a_nr01)    as cp_nr01 

              FROM
              (
              /***********************************************
                     Παραστατικά προς πρλ
                     q30.nr01=620018
              ***********************************************/
              (
              SELECT t02.p012 as mkfs,   
                     't08' as tbl, 
                     t08.nr01 as tbl_nr01, 
                     if(t02.p012 in (2, 3), 1, 2) as p00,
                     2 as p01,
                     t08.p0121 as p03, 
                     0 as p06, 
                     ifnull(t02.p01, 0) as p07, 
                     t08.remdate as p08d, 
                     t08.remtime as p08t,             
                     t08.pn01 as currency, 
                     t08.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     t08.p701 as series, 
                     t08.p06 as aa, 
                     t08.p01 as issuedate, 
                     ifnull(mydt50.p00, '') as invtype, 
                     
                     /*αντισυμβαλλόμενος*/
                     /**start_module_exists_suppliers**/
                     ifnull(a01.p4_1, ifnull(a00.p4_1, '')) as a_country,
                     ifnull(a01.p20,  ifnull(a00.p20, '')) as a_vat,
                     ifnull(a01.p19,  ifnull(a00.p19, ifnull(t00.p02, ''))) as a_name, 
                     ifnull(a01.p4,   ifnull(a00.p4,  ifnull(t00.p102, ''))) as a_address, 
                     ifnull(concat(a01.p5, ' ', a01.p6),   ifnull(concat(a00.p5, ' ', a00.p6),  ifnull(t00.p103, ''))) a_city, 
                     ifnull(a01.p7,   ifnull(a00.p7, '')) as a_zip,
                     -- Web v1.153
                     if(a01.nr01 is null ,  if(a00.nr01 is null , 't00' , 'a00') , 'a01') as a_tbl, 
                     ifnull(a01.nr01, ifnull(a00.nr01, t00.nr01)) as a_nr01
                     /**end_module_exists_suppliers**/

                     /**start_module_not_exists_suppliers**/
                     ifnull(a01.p4_1, '') as a_country,
                     ifnull(a01.p20,  '') as a_vat,
                     ifnull(a01.p19,  '') as a_name, 
                     ifnull(a01.p4,   '') as a_address, 
                     ifnull(concat(a01.p5, ' ', a01.p6),   '') a_city, 
                     ifnull(a01.p7,   '') as a_zip,
                     -- Web v1.153
                     if(a01.nr01 is null ,    't00'  , 'a01') as a_tbl, 
                     ifnull(a01.nr01,   t00.nr01) as a_nr01
                     /**end_module_not_exists_suppliers**/

              FROM q31
              LEFT JOIN t10 ON q31.p03=t10.p01
              LEFT JOIN t02 ON t02.p01=t10.p04
              LEFT JOIN t08 ON t08.p05=t10.p01
                            && t08.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && t08.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && t08.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && t08.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(t08.remdate, t08.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(t08.remdate, t08.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                            
                            ##start_module_exist_stores##
                            && t08.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##

              LEFT JOIN mydt50 ON mydt50.p00=q31.p05
              LEFT JOIN a01 ON a01.p21=t08.p03
              /**start_module_exists_suppliers**/
              LEFT JOIN a00 ON a00.p21=t08.p03
              /**end_module_exists_suppliers**/
              LEFT JOIN t00 ON t00.p01=t08.p03
              
              WHERE q31.p01=620018
                     && t08.nr01 is not null
                     && t02.nr01 is not null
                     && {p_mydt10where} 
              GROUP BY t10.nr01
              )

              UNION ALL
              
              /***********************************************
                     Παραστατικά προς αποσ
                     q30.nr01=620019
              ***********************************************/
              (
              SELECT t02.p012 as mkfs,   
                     't08' as tbl, 
                     t08.nr01 as tbl_nr01, 
                     if(t02.p012 in (2, 3), 1, 2) as p00,
                     1 as p01,
                     t08.p0121 as p03, 
                     0 as p06, 
                     ifnull(t02.p01, 0) as p07, 
                     t08.remdate as p08d, 
                     t08.remtime as p08t,             
                     t08.pn01 as currency, 
                     t08.pn02 as exchrate,
                     
                     /**στοιχεία παραστατικού*/
                     t08.p701 as series, 
                     t08.p06 as aa, 
                     t08.p01 as issuedate, 
                     ifnull(mydt50.p00, '') as invtype, 
                     
                     /*αντισυμβαλλόμενος*/
                     /**start_module_exists_suppliers**/
                     ifnull(a01.p4_1, ifnull(a00.p4_1, '')) as a_country,
                     ifnull(a01.p20,  ifnull(a00.p20, '')) as a_vat,
                     ifnull(a01.p19,  ifnull(a00.p19, ifnull(t00.p02, ''))) as a_name, 
                     ifnull(a01.p4,   ifnull(a00.p4,  ifnull(t00.p102, ''))) as a_address, 
                     ifnull(concat(a01.p5, ' ', a01.p6),   ifnull(concat(a00.p5, ' ', a00.p6),  ifnull(t00.p103, ''))) a_city, 
                     ifnull(a01.p7,   ifnull(a00.p7, '')) as a_zip,
                     -- Web v1.153 
                     if(a01.nr01 is null ,  if(a00.nr01 is null , 't00' , 'a00') , 'a01') as a_tbl, 
                     ifnull(a01.nr01, ifnull(a00.nr01, t00.nr01)) as a_nr01
                     /**end_module_exists_suppliers**/

                     /**start_module_not_exists_suppliers**/
                     ifnull(a01.p4_1, '') as a_country,
                     ifnull(a01.p20,  '') as a_vat,
                     ifnull(a01.p19,  '') as a_name, 
                     ifnull(a01.p4,   '') as a_address, 
                     ifnull(concat(a01.p5, ' ', a01.p6),   '') a_city, 
                     ifnull(a01.p7,   '') as a_zip,
                     -- Web v1.153
                     if(a01.nr01 is null ,    't00'  , 'a01') as a_tbl, 
                     ifnull(a01.nr01,   t00.nr01) as a_nr01
                     /**end_module_not_exists_suppliers**/

              FROM q31
              LEFT JOIN t10 ON q31.p03=t10.p01
              LEFT JOIN t02 ON t02.p01=t10.p04
              LEFT JOIN t08 ON t08.p05=t10.p01
                            && t08.p01>=cast('{odbcdtos(nt_p01)}' as date)
                            && t08.p01<=cast('{odbcdtos(nt_p02)}' as date)
                            && t08.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                            && t08.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                            && concat(t08.remdate, t08.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                            && concat(t08.remdate, t08.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                            
                            ##start_module_exist_stores##
                            && t08.p0121 in (##store_in_sql##)                 
                            ##end_module_exist_stores##


              LEFT JOIN mydt50 ON mydt50.p00=q31.p05
              LEFT JOIN a01 ON a01.p21=t08.p03
              /**start_module_exists_suppliers**/
              LEFT JOIN a00 ON a00.p21=t08.p03
              /**end_module_exists_suppliers**/
              LEFT JOIN t00 ON t00.p01=t08.p03
              
              WHERE q31.p01=620019
                     && t08.nr01 is not null
                     && ( (a01.p21 is not null AND t08.p08 = 0) OR (a01.p21 is null) )
                     && t02.nr01 is not null
                     && {p_mydt10where} 
              GROUP BY t10.nr01
              )
                     
              ) as tbl01
       )    
       as tttttt;