insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03,  p06, p07, p08d, p08t,
currency, exchrate, 
series, aa, issuedate, issuetime, invtype, paytype, 
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01, 
p_notes, /*v1.82*/ p103)

SELECT tbl as tbl, 
       tbl_nr01 as tbl_nr01, 
       p00 as p00, 
       p01 as p01, 
       p03 as p03, 
       p06 as p06, 
       p07 as p07, 
       p08d as p08d, 
       p08t as p08t, 
       currency as currency, 
       exchrate as exchrate, 
       if(series='', '0', series) as series, 
       aa as aa, 
       issuedate as issuedate, 
       issuetime as issuetime, 
       invtype as invtype, 
       paytype as paytype, 
       
       ''             as is_country,
       '{nt_p101[1]}' as is_vat, 
       '{nt_p101[2]}' as is_name, 
       '{nt_p101[3]}' as is_address, 
       '{nt_p101[4]}' as is_city, 
       '{nt_p101[5]}' as is_zip,
       /*v1.50*/
       '{nt_p101[6]}' as is_tbl,
       '{nt_p101[7]}' as is_nr01,
       a_country as cp_country,
       a_vat     as cp_vat, 
       a_name    as cp_name, 
       a_address as cp_address, 
       a_city    as cp_city, 
       a_zip     as cp_zip, 
       /*v1.50*/
       a_tbl     as cp_tbl, 
       a_nr01    as cp_nr01, 
       CONCAT(
		p_notes_part_1,
		"\n\n",
		p_notes_part_2		
	)			AS p_notes, 
       /*v1.82*/
       if(p103_1<>'', p103_1, p103_2) as p103
	 
FROM
(
      /***********************************************
             Παραστατικά προς αποστολή
             q30.nr01=620030
      ***********************************************/
      (
      SELECT 'tran01' as tbl, 
             tran01.nr01 as tbl_nr01, 
             1 as p00,
             1 as p01,
             tran01.p704 as p03, 
             tran01.p114 as p06, 
             ifnull(tran20.p04, 0) as p07, 
             tran01.remdate as p08d, 
             tran01.remtime as p08t,             
             '' as currency, 
             0 as exchrate,
       
             /**στοιχεία παραστατικού*/
             if( ifnull(mydt00.p103, 0)=1, 
                 concat(ifnull(tran20.p00, ''), if(tran01.sp00='', '', '-'), tran01.sp00), 
                 tran01.sp00
                ) as series, 
             tran01.p00  as aa, 
             tran01.p014 as issuedate, 
             tran01.p017 as issuetime, 
             ifnull(mydt50.p00, '') as invtype, 

             /**paytype**/           
             ifnull( (select q31_in.p05
                      from q31 as q31_in
                      where q31_in.p01=620042
                         && q31_in.p03=tran01.p99
                         && q31_in.p05!='7'
                      limit 1), '') as paytype,
             
             /*αντισυμβαλλόμενος*/
             ifnull(d23.p01, '') as a_country, 
             ifnull(a01.p20, '') as a_vat, 
             ifnull(a01.p19, '') as a_name, 
             ifnull(a01.p4, '') as a_address, 
             concat( ifnull(concat(d22.p02, ' '), ''), 
                     ifnull(concat(a01.p5, ' '), ''),
                     ifnull(concat(a01.p6, ' '), '')
                   ) as a_city, 
             ifnull(a01.p7, '') as a_zip, 
             /*v1.50*/
             'a01' as a_tbl, 
             tran01.p61 as a_nr01, 

			CONCAT(
				"{peg_dic_tran_mydt_tran05_p01}: ",
				IFNULL(tran05.p01,'')
			) AS p_notes_part_1,
			GROUP_CONCAT(distinct 
				IF(
					tran02.p01 != '',
					CONCAT('{peg_dic_tran_mydt_tran02_p01}: ', tran02.p01,' - '),
					''
				),
				IF(
					tran15.p01 != '',
					CONCAT('{peg_dic_tran_mydt_tran15_p01}: ', tran15.p01,' - '),
					''
				),
				IF(
					tran02.p04 != '',
					CONCAT('{peg_dic_tran_mydt_tran02_p04}: ', tran02.p04,' - '),
					''
				),
				IF(
					tran02.p02 > 0,
					CONCAT('{peg_dic_tran_mydt_tran02_p02}: ', tran02.p02,' - '),
					''
				),
				IF(
					tran02.p06 > 0,
					CONCAT('{peg_dic_tran_mydt_tran02_p06}: ', tran02.p06,' - '),
					''
				),
				IF(
					tran02.p05 > 0,
					CONCAT('{peg_dic_tran_mydt_tran02_p05}: ', tran02.p05,' - '),
					''
				),
				IF(
					tran02.p09 > 0,
					CONCAT('{peg_dic_tran_mydt_tran02_p09}: ', tran02.p09,' - '),
					''
				),				
				CONCAT('[{peg_dic_tran_mydt_tran02_nr01}: ', tran02.nr01, '] ')
				SEPARATOR "\n"
			) AS p_notes_part_2,				
            /*v1.82*/
            /*Εκτυπωτής παραστατικού αν δεν είναι χειρόγραφο*/
            if( tran01.sp01=0, ifnull(tran20.p08, ''),  '') as p103_1,
            if( tran01.sp01=0, ifnull(tran98.p104, ''), '') as p103_2
		
             
      FROM q31
      LEFT JOIN tran20 ON q31.p03=tran20.p01
      LEFT JOIN tran01 ON tran01.p105=tran20.p01
		      && tran01.p014>=cast('{odbcdtos(nt_p01)}' as date)
		      && tran01.p014<=cast('{odbcdtos(nt_p02)}' as date)
		      && tran01.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
		      && tran01.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
		      && concat(tran01.remdate, tran01.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
		      && concat(tran01.remdate, tran01.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
		      && tran01.p704>={nt_p03}
		      && tran01.p704<={nt_p04}                    
      LEFT JOIN mydt50 ON mydt50.p00=q31.p05
      LEFT JOIN a01 ON a01.nr01=tran01.p61
      LEFT JOIN d22 ON d22.p01=a01.p4_3
      LEFT JOIN d23 ON d23.p01=a01.p4_1      
      LEFT JOIN mydt00 ON mydt00.nr01=1
      LEFT JOIN tran05 ON tran05.p00 = tran01.p701
      LEFT JOIN tran02 ON tran02.p00 = tran01.nr01
      LEFT JOIN tran15 ON tran15.p00 = tran02.p03
      /*v1.82*/
      LEFT JOIN tran98 ON tran98.nr01=1

      WHERE q31.p01=620030
         && tran01.nr01 is not null
         && tran20.nr01 is not null
         && tran01.pa00=0
         && tran01.pa01=0
         && (tran01.sp01<>0 || tran01.sp02<>0)
         && {p_mydt10where} 
         && {nt_napost}=1
      GROUP BY tran01.nr01
      {p_mydt10limit}
      )

) as tbl01;   
/*peg_end*/         
       