INSERT INTO {p_mydt10tbl4}
( 
	ptbl,
	ptbl_nr01,
	`type`,
	branch,
	vat,
	country,
	tbl,
	tbl_nr,
	`name`,
	`address`,
	city,
	zip
)
SELECT
	tbl01.ptbl			AS ptbl, 
	tbl01.ptbl_nr01		AS ptbl_nr01,
	tbl01.type			AS `type`,
	tbl01.branch			AS branch,
	IFNULL(tbl01.vat,'')		AS vat,
	IFNULL(tbl01.country,'')	AS country,
	tbl01.tbl			AS tbl, 
	tbl01.tbl_nr		AS tbl_nr, 
	IFNULL(tbl01.name,'')	AS `name`,
	IFNULL(tbl01.address,'')	AS `address`,
	IFNULL(tbl01.city,'')	AS city,
	IFNULL(tbl01.zip,'')		AS zip
	
FROM 
(
	 (
		SELECT
			mydt10.tbl			AS ptbl, 
			mydt10.tbl_nr01		AS ptbl_nr01,
			'sender'			AS `type`,
			0				AS branch,
			d00.p20			AS vat,
			d00.p013			AS country,
			IF(
				d88.nr01 IS NULL,
				'd00',
				'd88'
			)				AS tbl, 
			IF(
				d88.nr01 IS NULL,
				d00.nr01,
				d88.nr01
			)				AS tbl_nr, 
			IF(
				d88.nr01 IS NULL 
				OR d88.p600 = '',
				d00.p19,
				d88.p600
			)				AS `name`,
			IF(
				d88.nr01 IS NULL,
				d00.p4,
				d88.p603
			)				AS `address`,
			IF(
				d88.nr01 IS NULL,
				d22_00.p02,
				d88.p605
			)				AS city,
			IF(
				d88.nr01 IS NULL,
				d00.p7,
				d88.p604
			)				AS zip
		FROM {p_mydt10tbl1} AS mydt10
		JOIN tran01 ON tran01.nr01 = mydt10.tbl_nr01 AND mydt10.tbl = 'tran01'
		LEFT JOIN d00	ON d00.nr01 = tran01.p01
		LEFT JOIN d22 AS d22_00 ON d22_00.p01 = d00.p06
		LEFT JOIN d88	ON d88.nr01 = tran01.yp01
	 )
	 UNION ALL
	  (
		SELECT
			mydt10.tbl			AS ptbl, 
			mydt10.tbl_nr01		AS ptbl_nr01,
			'receiver'			AS `type`,
			0				AS branch,
			d00.p20			AS vat,
			d00.p013			AS country,
			IF(
				d88.nr01 IS NULL,
				'd00',
				'd88'
			)				AS tbl, 
			IF(
				d88.nr01 IS NULL,
				d00.nr01,
				d88.nr01
			)				AS tbl_nr, 
			IF(
				d88.nr01 IS NULL,
				d00.p19,
				d88.p600
			)				AS `name`,
			IF(
				d88.nr01 IS NULL,
				d00.p4,
				d88.p603
			)				AS `address`,
			IF(
				d88.nr01 IS NULL,
				d22_00.p02,
				d88.p605
			)				AS city,
			IF(
				d88.nr01 IS NULL,
				d00.p7,
				d88.p604
			)				AS zip
		FROM {p_mydt10tbl1} AS mydt10
		JOIN tran01 ON tran01.nr01 = mydt10.tbl_nr01 AND mydt10.tbl = 'tran01'
		LEFT JOIN d00	ON d00.nr01 = tran01.p02
		LEFT JOIN d22 AS d22_00 ON d22_00.p01 = d00.p06
		LEFT JOIN d88	ON d88.nr01 = tran01.yp02
	 )
) AS tbl01