insert into {p_mydt10tbl1}
(tbl, tbl_nr01, p00, p01, p03, p06, p07, p08d, p08t,
currency, exchrate, slfpricing,
mvpurpose, vatpaysusp,
vehiclenum, spinvcat, invvarty,
series, aa, issuedate, issuetime, invtype, paytype,  
is_country, is_vat, is_name, is_address, is_city, is_zip, is_tbl, is_nr01,
cp_country, cp_vat, cp_name, cp_address, cp_city, cp_zip, cp_tbl, cp_nr01,
dispdate, disptime, ldstreet, ldzip, ldnumber, ldcity, dlvstreet, dlvzip, dlvnumber, dlvcity, ss_branch, cs_branch, 
othmvpur, p103)

SELECT tbl          as tbl,
       tbl_nr01     as tbl_nr01,
       p00          as p00,
       p01          as p01,
       p03          as p03,
       p06          as p06,
       p07          as p07,
       p08d         as p08d,
       p08t         as p08t,
       currency     as currency,
       exchrate     as exchrate,
       slfpricing   as slfpricing,      
       mvpurpose    as mvpurpose,
       vatpaysusp   as vatpaysusp,      
       vehiclenum   as vehiclenum,
       spinvcat     as spinvcat,
       invvarty     as invvarty,
       series       as series,
       aa           as aa,
       issuedate    as issuedate,
       issuetime    as issuetime,
       invtype      as invtype,
       paytype      as paytype,
       
       ''             as is_country,
       '{nt_p101[1]}' as is_vat,
       '{nt_p101[2]}' as is_name,
       '{nt_p101[3]}' as is_address,
       '{nt_p101[4]}' as is_city,
       '{nt_p101[5]}' as is_zip,
       '{nt_p101[6]}' as is_tbl,
       '{nt_p101[7]}' as is_nr01,

       a_country    as cp_country,
       a_vat        as cp_vat,
       a_name       as cp_name,
       a_address    as cp_address,
       a_city       as cp_city,
       a_zip        as cp_zip,
       a_tbl        as cp_tbl,
       a_nr01       as cp_nr01,

       dispdate     as dispdate,
       disptime     as disptime,

       ldstreet     as ldstreet, 
       ldzip        as ldzip, 
       ldnumber     as ldnumber, 
       ldcity       as ldcity,
       dlvstreet    as dlvstreet, 
       dlvzip       as dlvzip, 
       dlvnumber    as dlvnumber, 
       dlvcity      as dlvcity,

       ss_branch    as ss_branch,
       cs_branch    as cs_branch,

       othmvpur     as othmvpur, 
       if(p103_1<>'', p103_1, p103_2) as p103

FROM
(
      /***********************************************
            Δελτία Αποστολής Φορτωτικών προς αποστολή
            q30.nr01=620075
      ***********************************************/
    (
        SELECT 'tran09'         as tbl,
                tran09.nr01     as tbl_nr01,
                1               as p00, /* 1 = Έσοδο*/
                1               as p01, /* 1 = Αποστολη */
                tran09.p020     as p03, /* Καταστημα*/
                0               as p06, /* Καθεστως ΦΠΑ */
                0               as p07, /* Κ.Κ. Λογιστηριου */
                tran09.remdate  as p08d,
                tran09.remtime  as p08t, 

                ''  as currency,
                '1' as exchrate,
                0   as slfpricing,

                ifnull( 
                        (select q31_in.p05
                        from    q31 as q31_in, 
                                tran24 as tran24_in
                        where   q31_in.p01=620077
                                and q31_in.p03=tran24_in.p01
								and tran24_in.p01=tran09.p101
                        limit 1), '8')  as mvpurpose,
                    
                tran24.p02  as othmvpur,     
                0           as vatpaysusp,      
                
                
                tran09.p04  as vehiclenum,
                ''          as spinvcat,

                /**invoice variation type**/
                ''          as invvarty,
                
                /**στοιχεία παραστατικού*/
                tran09.p021             as series,
                tran09.p01              as aa,
                tran09.p010             as issuedate,
                ''                      as issuetime,
                ifnull(mydt50.p00, '')  as invtype,
                
                /**paytype**/          
                ''  as paytype,
                
                /*αντισυμβαλλόμενος*/
                /**ΣΤΑ COUNTERPART ΌΛΑ ΚΕΝΑ ΚΑΙ ΤΟ ΑΦΜ ΜΕ 9 ΜΗΔΕΝΙΚΑ **/
                ''          as a_country,
                '000000000' as a_vat,
                '-'         as a_name,
                '-'         as a_address,
                '-'         as a_city,
                '00000'     as a_zip,

                /* Web v1.153 */
                '' as a_tbl,
                '' as a_nr01,

                cast('0100-01-01' as date)  as dispdate,
                ''                          as disptime,

                tran05.ldstreet     as ldstreet,
                tran05.ldzip        as ldzip,
                tran05.ldcity       as ldcity,
                tran05.ldnumber     as ldnumber, 

                tran05.dlvstreet    as dlvstreet,
                tran05.dlvzip       as dlvzip,
                tran05.dlvcity      as dlvcity,
                tran05.dlvnumber    as dlvnumber, 
                
                tran05.ss_branch    as ss_branch,
                tran05.cs_branch    as cs_branch,

                /*Εκτυπωτής παραστατικού*/
                ifnull(tran24.p08, '')  as p103_1,
                ifnull(tran98.p114, '') as p103_2

        FROM q31
        LEFT JOIN tran24 ON q31.p03=tran24.p01
        LEFT JOIN tran09 ON tran09.p101=tran24.p01
                         && tran09.p01>0
                         && tran09.p010>cast('0100-01-01' as date)
                         && tran09.p02>=cast('{odbcdtos(nt_p01)}' as date)
                         && tran09.p02<=cast('{odbcdtos(nt_p02)}' as date)
                         && tran09.remdate>=cast('{odbcdtos(nt_p07d)}' as date)
                         && tran09.remdate<=cast('{odbcdtos(nt_p08d)}' as date)
                         && concat(tran09.remdate, tran09.remtime)>=concat(cast('{odbcdtos(nt_p07d)}' as date), '{nt_p07t}')
                         && concat(tran09.remdate, tran09.remtime)<=concat(cast('{odbcdtos(nt_p08d)}' as date), '{nt_p08t}')
                         
                         ##start_module_exist_stores##
                         && tran09.p020 in (##store_in_sql##)                
                         ##end_module_exist_stores##  

        LEFT JOIN tran05 ON tran05.p00=tran09.p03
        LEFT JOIN tran98 ON tran98.nr01=1
        LEFT JOIN mydt50 ON mydt50.p00=q31.p05
        LEFT JOIN f02 ON f02.nr01=1
        LEFT JOIN mydt00 ON mydt00.nr01=1
        WHERE q31.p01=620075 
            and tran09.nr01 is not null
            and tran24.nr01 is not null
            and {p_mydt10where}
            and {nt_napost}=1
        GROUP BY tran09.nr01
        {p_mydt10limit}
      )

) as tbl01;          
/*peg_end*/