<?php 

	class ordercust_pegapi_actions extends pegapi_RestObject{

		


		private function get($nr01,$code = 200, $status = 200){
			
			$query_a57="select * from a57 "; 
			$query_a57_arr=array();
			$query_a57.=" where 1=1 ";

			if($nr01>0){
				$query_a57.=" and nr01=:nr01 ";
				$query_a57_arr['nr01'] = $nr01;
			} 
			//$this->_getFieldsFromTable($table);

			$tableFields =  array();
			$tableFields['remdate']     = array('fld' => 'remdate'    ,'tp' => 'D', 'fldsz' => 10 ,  'flddec' => 0);
			$tableFields['remtime']     = array('fld' => 'remtime'    ,'tp' => 'C', 'fldsz' => 10 ,  'flddec' => 0);
			$tableFields['remuser']     = array('fld' => 'remuser'    ,'tp' => 'C', 'fldsz' => 50 ,  'flddec' => 0);
			$tableFields['remfdate']    = array('fld' => 'remfdate'   ,'tp' => 'D', 'fldsz' => 10 ,  'flddec' => 0);
			$tableFields['remftime']    = array('fld' => 'remftime'   ,'tp' => 'C', 'fldsz' => 10 ,  'flddec' => 0);
			$tableFields['remfuser']    = array('fld' => 'remfuser'   ,'tp' => 'C', 'fldsz' => 50 ,  'flddec' => 0); 
			$tableFields['remdatetime'] = array('fld' => 'remdatetime','tp' => 'C', 'fldsz' => 20 ,  'flddec' => 0 , 'whfldnm' => 'concat(remdate , \' \' , remtime)');
			
			if($code == 200) {

				$sql = "	SELECT 
								p51.desc05	AS fld, 
								p51.desc16	AS tp,
								desc17 		AS fldsz,
								desc18 		AS flddec
							FROM  p51
							JOIN p61 ON p51.desc07 = p61.p00 and p61.isdbfld = 1

							WHERE p51.desc16 != ''
							AND p51.desc16 != 'V'
							AND p51.p02 = :p51_p02
							AND p51.module = :p51_module
				";
				$values = array (
					'p51_p02'		=> 'a57_d',
					'p51_module'	=> 'ordercust'
				);
				$res = pegasus_query($sql,$values);
				while($rs = pegasus_fetch_assoc($res)) {
					$tableFields[$rs['fld']] = array(
						'fld'		=> $rs['fld'],
						'tp'		=> $rs['tp'],
						'fldsz'		=> $rs['fldsz'],
						'flddec'	=> $rs['flddec'],
					);
				}
	
			}
			
			$whereArray = $this->makeFilterWhereFromArray($this->request['filter'], $tableFields,'',true);

			if(!empty($whereArray)){
				$query_a57 .= $whereArray['sql'];
				$query_a57_arr = array_merge($query_a57_arr,$whereArray['sqlParams']);
			}

			if($code == 200) {
				$this->totalrec = pegasus_mysql_printfld('a57',"COUNT(a57.nr01)",' 1=1 '.$whereArray['sql'],$whereArray['sqlParams']);
				$query_a57 .= ' LIMIT '.$this->page.','.(($this->page + 1) * $this->recperpage);
			}
			
			// die(pegasus_replace_values_in_sql($query_a57,$query_a57_arr));

			$data = array();
			$res_a57=pegasus_query($query_a57,$query_a57_arr);
			while($a57 = pegasus_fetch($res_a57,PEG_FETCH_ASSOC)){
				$a57['a58']=array();
				$query_a58='select * from a58 where p00=?';
				$query_a58_arr=array($a57['nr01']);
				$res_a58=pegasus_query($query_a58,$query_a58_arr);
				while($a58 = pegasus_fetch($res_a58,PEG_FETCH_ASSOC)){
					if(pegasus_mysql_table_exists('a59')){
						$a58['a59']=array();
						$query_a59='select * from a59 where p01=?';
						$query_a59_arr=array($a58['nr01']);
						$res_a59=pegasus_query($query_a59,$query_a59_arr);
						while($a59 = pegasus_fetch($res_a59,PEG_FETCH_ASSOC)){
							$a58['a59'][]=$a59;
						}
					}
					$a57['a58'][]=$a58;
				}
				$data[]=$a57;
			}
			if(empty($data)){
				$data= array(
					'error'=> array('title'=>"No Content",'detail'=>"No Content")
				);
				$code = 209;
				$status=209;
			}

			return array(
				'status'	=> $status,
				'code'		=> $code,
				'data'		=> $data
			);
		}
 
		
		private function delete($nr01){
			$nr01=pegasus_mysql_printfld('a57','nr01','nr01=?',array($nr01));
			
			if(!($nr01>0)){
				$data= array(
					'error'=> array('title'=>"No Content",'detail'=>"No Content")
				);
				$code = 209;
				$status=209;
			}else{
				$code = 200;
				$status=200;
				$message='ok';
				$permDeny =pegasus_mysql_full_delete('a57',$nr01);
				$ok=true;
				if(is_array($permDeny) && !empty($permDeny)){
					$message='';
					$code = 400;
					$ok=false;
					$status=400;
					foreach ($permDeny as $pd){
						if(!empty($message)){
							$message .= ',';
						}
						if(strtoupper($pd['action']) == 'DELETE' ){
							$message .= $_SESSION['peg_dic_core_perm_deny_del_table'] . " " . pegasus_mysql_printfld( 'p50' , 'p03' ,  'p01=?', array($pd['table'])).  " (". $pd['table'] . ")";
						}
					}
				}
	
				$data= array(
					'msg'=> $message,
					"ok"=>$ok
				);
				
			}
			return array(
				'status'	=> $status,
				'code'		=> $code,
				'data'		=> $data
			);
			
		}

		public function order(){
			if ($this->method == 'GET'){
				$nr01=$this->request['nr01'];
				return $this->get($nr01);
			}

			if ($this->method == 'DELETE'){
				$nr01=$this->request['nr01'];
				return $this->delete($nr01);
			}

			$nr01=$this->request['nr01'];
			if($this->method=="PUT"  ){
				//$nr01=$this->request['nr01'];
				if(!(pegasus_mysql_printfld('a57','nr01','nr01=?',array($nr01))>0)){
					$data =array ( 'msg'=> "Invalid ID") ;
					$code = 401;
					$status=401;
					return array(
							'status'	=> $status,
							'code'		=> $code,
							'data'		=> $data
					);
				}
			}else if($this->method=="POST"){
				$nr01=NULL;
			}
			
			$a57_flds=array(
				'p03',		// pelatis
				'p04',		// ypokatasthma
				'p05', 		// parastatiko
				'p06',		// arithmos
				'p09', 		// Kathestws fpa
				'p015',		// tropos eispraxis
				'p010',		// aitiologia
				'p011',		// parathrihseis
				'p012',		// skopos diakinhshs
				'p013', 	// apo	
				'p014', 	// pros
				'p702',		// ar.kukloforias
				'p016',		// pwlhths
				'p017',		// torpos metaforas
				'p703',		// apothikeutikos xwros
				'p0121',	// katastima
				'p501',		// apostoleas
				'p502',		// paralhpths
				'p590',		// katastash
				'p30',		// Shmeiwseis
				'p901',		// Epi8umhth paradosh
				'p902',		// paradothike
				'pn01',		// nomisma
				'p07'      //Η παραγγελία περιέχει ΦΠΑ
			);
			for ($i=401; $i <=410 ; $i++) {
				array_push($a57_flds, 'p'.$i); // lektika 1 ews 9  && den upologizontai automata 
			}
			$a57 = array();
			foreach ($a57_flds as $key => $value) {
				if(isset($this->request[$value])){
					$a57[$value]=$this->request[$value];
				}
			}
			//echo $nr01;
			$_REQUEST['ingore_axx_p500'] = 1;
			$_REQUEST['ingore_axx_p501'] = 1;
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0 , session_id() , 'a57_d');
			$screen->module       = 'ordercust';
			$screen->_d           = 'a57_d';
			$screen->table        = 'a57';
			$screen->data['p03']  = $a57['p03'];
			$screen->data['p05']  = $a57['p05'];

			$screen->nr01=$nr01;
			$screen->read_data_from_db(1 , 1);
			$screen->read_params_from_db();
			
			//Ελέγχουμε αν μας έρχεται συμπληρωμένο το p07 από το Request και στην συνέχεια το περνάμε στο $screen->data['p07']
			if(!empty($a57['p07'])){
				$screen->data['p07']  = $a57['p07'];
				pegasusSetGlobalVar('peg_a57_d-' .$screen->data['nr01']. '_p07', $screen->data['p07']);
			}
			
			if($nr01>0){ //put method 
				$where =	" peg_mnr01= :peg_mnr01 and peg_mmnr01= :peg_mmnr01 and peg_sess_id= :peg_sess_id and peg_flag!= :peg_flag ";
				$where_arr=array(	'peg_mnr01'=> $nr01,
									'peg_mmnr01'=>"a57_d-".$nr01, 
									'peg_sess_id'=>session_id(),
									'peg_flag'=>"9");
				/*Διαγράφω όλες τις εγγραφές από τον tmp*/	
				pegasus_mysql_update('peg_tmp_a58',array('peg_flag'),array('9'),$where,0,1,1,$where_arr);
			}
			
			if(isset($this->request['a58']) && !empty($this->request['a58'])){
				$this->request['a58'] = json_decode($this->request['a58'], true);
				if($this->request['a58'] === null){
					$error = '';
					switch (json_last_error()) {
						case JSON_ERROR_NONE:
							$error = ' - No errors';
							break;
						case JSON_ERROR_DEPTH:
							$error =' - Maximum stack depth exceeded';
							break;
						case JSON_ERROR_STATE_MISMATCH:
							$error =' - Underflow or the modes mismatch';
							break;
						case JSON_ERROR_CTRL_CHAR:
							$error =' - Unexpected control character found';
							break;
						case JSON_ERROR_SYNTAX:
							$error =' - Syntax error, malformed JSON';
							break;
						case JSON_ERROR_UTF8:
							$error =' - Malformed UTF-8 characters, possibly incorrectly encoded';
							break;
						default:
							$error =' - Unknown error';
							break;
					}
					throw new PegApiException($error, 400, null,400, 'Products Json Decode Error',$error);
					return;
				}
			}
			$a57['a58']= $this->request['a58'];
			
			
			foreach ($a57['a58'] as $product) {
				$this->add_a58($product,$a57,$screen);
				
			}
			foreach ($a57 as $key => $value) {
				$screen->data[$key]=$value;
			}
			
			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
		
			$ret_array = $screen->save_data();
			
			peg_close_d($screen->container_id);
			$code = 201;
			$status=201;
			if(!empty($ret_array[1])){
				$data =array ( 'msg'=> $ret_array[1]) ;
				$code = 403;
				$status=403;
			}else{
				if($this->method=="PUT") {
					return $this->get($screen->data['nr01'],200,200);
				}
				return $this->get($screen->data['nr01'],201,201);
			}

			return array(
				'status'	=> $status,
				'code'		=> $code,
				'data'		=> $data
			);
		}

		private function add_a58($product,$a57,&$screen){
			$a58_flds=array(
				'p00',		//	Μ.Κ.Παραγγελίας
				'v101',		//	Κωδικός
				'v103',		//	Ποσότητα
				'v104',		//	Τιμή Μονάδας
				'v106',		//	% Εκπτωσης 1
				'v106a',	//	% Εκπτωσης 2
				'v160'		//	Αιτιολογία --> Δ.2086290
			);
			$a58=array();
			$a58['peg_mnr01']=$screen->data['nr01']  ;
			$a58['peg_mmnr01']='a57_d-'. $screen->data['nr01'];
			$a58['peg_sess_id']=session_id();
			$a58['nr01']=pegasus_mysql_printfld('peg_tmp_a58','nr01',"nr01=?",array($product['nr01']));
			
			foreach ($a58_flds as $key => $value) {
				if(isset($product[$value])){
					$a58[$value]=$product[$value];
				}
			}
			
			if(empty($a58['p00'])){
				$a58['p00']=$screen->data['nr01'];
			}
			/* Αν δεν είναι ενημέρωση παλιάς εγγραφής τη δημιουργώ*/
			if(!($a58['nr01']>0)){
				$a58['nr01']=pegasus_mysql_newrec('a58');
				$a58['peg_flag']=1;
				pegasus_mysql_insert("peg_tmp_a58", array_keys($a58),  array_values($a58));
					
			}				
				
			pegasus_mysql_use("select * from i00 where pno=?",$i00,array($a58['v101']));

			$req_arr = array();
			$req_arr['a57_nr01'] = $screen->data['nr01'];
			$req_arr['a58_nr01'] = $a58['nr01'];
			$req_arr['v101']	 = $a58['v101'];
			$req_arr['v103']	 = $a58['v103'];
			$req_arr['a57_p03']  = $screen->data['p03'];
			$req_arr['a57_p07']  = $screen->data['p07'];
			$req_arr['date']     = date('Y-m-d');
			$req_arr['mnr01']	 = $a58['peg_mnr01'];
			$req_arr['mmnr01']	 = $a58['peg_mmnr01'];
			$req_arr['kath_fpa'] = $screen->data['p09'];
			$req_arr['timh1']	 = $i00['timh1'];
			$req_arr['timh2']	 = $i00['timh2'];
			$req_arr['timh3']	 = $i00['timh3'];
			$req_arr['timh4']	 = $i00['timh4'];
			$req_arr['p703']	 = $a57['p703'];

			
			
			
			$result_arr = peg_invoice_find_product_data($req_arr);			
			$zero_prices = invoices_check_if_zero_prices('a57', $screen->data['nr01']);
			$recalculate_total=false;
			if($a58['v103']>0){
				$result_arr['v103'] = $a58['v103'];
				$recalculate_total  = true;
			}
			$v104_set_from_request = false; // Η τιμή ειναι ορισμένη απο το Request
			if($a58['v104']>0 && $zero_prices != 1 ){ //Τιμή Μονάδας
				$result_arr['v104'] = $a58['v104'];
				$result_arr['v106'] = $a58['v106'];//Εκπτωση 1
				$result_arr['v106a'] = $a58['v106a'];//Εκπτωση 2
				$recalculate_total  = true;
				$v104_set_from_request = true;
			}

			/* Αν έχει δώσει ποσότητα ή τιμή μονάδας ξαναβρίσκω τα σύνολα*/
			if($recalculate_total){
				$result_arr['v107']=invoices_make_product_total(
					$result_arr['v103'] , 
					$result_arr['v104'] ,
					$result_arr['v105'] , 
					$result_arr['v106'] , 
					$result_arr['v106a'] , 
					$result_arr['v1041'], 
					$result_arr['v616'] , 
					$screen->data['p07'] 
				) ;
			}

			if(isset($product['v102'])) {
				$a58['v102'] = $product['v102'];
			} else {
				$a58['v102']  = $result_arr['v102'];
			}
			
			if(!empty($result_arr['v160'])) {
				$a58['v160']  .= ' - '.$result_arr['v160'];
			}
			
			$a58['v120']  = $result_arr['v120'];
			$a58['v301']  = $result_arr['v301'];
			$a58['v302']  = $result_arr['v302'];
			$a58['v303']  = $result_arr['v303'];
			$a58['v304']  = $result_arr['v304'];
			$a58['v306']  = $result_arr['v306'];
			$a58['v307']  = $result_arr['v307'];
			$a58['v104']  = $result_arr['v104'];
			$a58['v105']  = $result_arr['fpa'];
			$a58['v108']  = $result_arr['kfpa'];
			$a58['v106']  = $result_arr['v106'];
			$a58['v106a'] = $result_arr['v106a'];
			$a58['v1041'] = $result_arr['v1041'];
			$a58['v616']  = $result_arr['v616'];
			$a58['v309']  = $result_arr['v309'];
			$a58['v308']  = $result_arr['v308'];
			$a58['v107']  = $result_arr['v107'];
			$a58['timh1'] = $result_arr['timh1'];
			$a58['timh2'] = $result_arr['timh2'];
			$a58['timh3'] = $result_arr['timh3'];
			$a58['timh4'] = $result_arr['timh4'];


			$has_cs=0;
			if(is_array($product['a59']) && !empty($product['a59'])){	
				foreach($product['a59'] as $colsize){
					$i47_query="select i47.nr01 
								from i47 
								join i00 on i00.nr01=i47.i00
								where i00.pno=? and p02=? and p03=?";
					pegasus_mysql_use($i47_query,$i47,array($product['v101'],$colsize['p02'],$colsize['p03']));
					if($i47['nr01']>0){
						$a58 = $this->add_a59($colsize,$a58,$screen, $v104_set_from_request);
					}else{
						throw new PegApiException('',401, null, 400, ('Invalid Color-Size'), 'The color / size codes given are not valid for the item '.$product['v101'] );
					}
				}
			}	
			unset($a58['peg_mmnr01']);
			unset($a58['peg_mnr01']);
			unset($a58['peg_sess_id']);
				
			pegasus_mysql_update("peg_tmp_a58", array_keys($a58),  array_values($a58),'nr01=?',0,1,1,array($a58['nr01']));
					
		}
		/**
		 * @param $colsize
		 * @param $a58
		 * @param &$screen
		 * @param  $v104_set_from_request είναι true εφόσον έχει λάβει v104>0
		 */
		private function add_a59($colsize,$a58,&$screen, $v104_set_from_request = false){
			$a59_flds=array('p02','p03','p04');
			$a59=array();
			$a59['peg_mnr01']=$a58['nr01']  ;
			$a59['peg_mmnr01']='a57_d-'. $screen->data['nr01'];
			$a59['peg_sess_id']=session_id();
			
			foreach ($a59_flds as $key => $value) {
				if(isset($colsize[$value])){
					$a59[$value]=$colsize[$value];
				}
			}
				if(empty($a59['p01'])){
				$a59['p01']=$a58['nr01'];
			}
			/* Αν δεν είναι ενημέρωση παλιάς εγγραφής τη δημιουργώ*/
			if(!($a59['nr01']>0)){
				$a59['nr01']=pegasus_mysql_newrec('a59');
				$a59['peg_flag']=1;
				pegasus_mysql_insert("peg_tmp_a59", array_keys($a59),  array_values($a59));
			}



			$req_array=array();
			$req_array['mode'] = 'a57'; 
			$req_array['a57_p03']  = $screen->data['p03'] ; 
			$req_array['a57_p07']  = $screen->data['p07'] ; 
			$req_array['date']     = $screen->data['p01'];
			$req_array['kath_fpa'] = $screen->data['p09'];
			$req_array['a58_nr01'] = $a58['nr01'];
			$req_array['a57_nr01'] = $a58['p00'];
			$req_array['i18a58']   = 0; 
			$req_array['v105']	   = $a58['v105']; 
			$req_array['v106']     = $a58['v106']; 
			$req_array['v106a']    = $a58['v106a']; 
			$req_array['v1042']    = $a58['v1042']; 
			$req_array['v1041']    = $a58['v1041']; 
			$req_array['v616']     = $a58['v616']; 
			$req_array['v101']     = $a58['v101']; 
			$req_array['v103']     = $a58['v103']; 
			$req_array['v301']     = $a58['v301'];  
			$req_array['v302']     = $a58['v302']; 
			$req_array['v303']     = $a58['v303']; 
			$req_array['v304']     = $a58['v304']; 
			$req_array['v306']     = $a58['v306']; 
			$req_array['v310']     = $a58['v310']; 
			$req_array['v309']     = $a58['v309']; 
			$req_array['v308']     = $a58['v308']; 
			$req_array['v307']     = $a58['v307'];

			$ret_array = invoices_find_product_quantity($req_array);
			
			$a58['v103']  = $ret_array['v103'];	//Ποσότητα	
			$a58['v310']  = $ret_array['v310'];
			$a58['v120']  = $ret_array['v120'];

			if($v104_set_from_request){ // Αν ειναι true τοτε γινεται ο υπολογισμός βάσει των στοιχείων του a58
				$result_arr['v107']=invoices_make_product_total(
					$a58['v103'] , 
					$a58['v104'] ,
					$a58['v105'] , 
					$a58['v106'] , 
					$a58['v106a'] , 
					$a58['v1041'], 
					$a58['v616'] , 
					$screen->data['p07'] 
				) ;
			}
			else{
				$a58['v104']  = $ret_array['v104']; //Τιμη Μονάδας
				$a58['v106']  = $ret_array['v106']; //Έκπττωση 1
				$a58['v106a'] = $ret_array['v106a']; //Έκπττωση 2
				$a58['v107']  = $ret_array['v107']; //Σύνολο
			}
			
			return $a58;
		}
}
?>