<?php 
require_once '../peg002_classes/Peg002_Cookie.php';
require_once '../peg002_00/functions.php'; 

class Peg002_Cache{
    private static $noCache = false;
    private static $noCache_d = array( 
        'browse_d0011',
        'browse_d0012',
        'browse_d0013',
        'browse_d0014',
        'browse_d0015',
        'browse_d0016', 
        
        '_dashboard_d' ,
        
        'massimport01_d',
        'massimport01_d03',
        
        'mlang_grid_d',
        'kernel_03_d',
        
        '_massexport_data',

        'core_q31_select_d'
    );
    
    private $lang;
    private $profile;
    private $profilePath;
    private $module;
    private $_d;
    private $table;
    private $peg_parent_grid_name;
    private $isMobile;
    private $isStore;
     
    
    /**
     * 
     * @var {'store', 'structure'}
     */
    private $type ;
    private $display_type ;
    private static $mainPath = '../../tmp/';
    
    protected $curCacheFile = '';
    
    public static $p82HtmlString = ":p82HtmlTag01,:p82HtmlTag02,:p82HtmlTag03,:p82HtmlTag04,:p82HtmlTag05,:p82HtmlTag06,:p82HtmlTag07,:p82HtmlTag08,:p82HtmlTag09,:p82HtmlTag10,:p82HtmlTag11,:p82HtmlTag12,:p82HtmlTag13,:p82HtmlTag14,:p82HtmlTag15,:p82HtmlTag16,:p82HtmlTag17,:p82HtmlTag18,:p82HtmlTag19,:p82HtmlTag20,:p82HtmlTag21,:p82HtmlTag22,:p82HtmlTag23,:p82HtmlTag24,:p82HtmlTag25,:p82HtmlTag26,:p82HtmlTag27,:p82HtmlTag28,:p82HtmlTag29,:p82HtmlTag30,:p82HtmlTag31,:p82HtmlTag32,:p82HtmlTag33,:p82HtmlTag34,:p82HtmlTag35,:p82HtmlTag36,:p82HtmlTag37,:p82HtmlTag38,:p82HtmlTag39,:p82HtmlTag40,:p82HtmlTag41,:p82HtmlTag42,:p82HtmlTag43,:p82HtmlTag44,:p82HtmlTag45,:p82HtmlTag46,:p82HtmlTag47,:p82HtmlTag48,:p82HtmlTag49,:p82HtmlTag50,:p82HtmlTag51,:p82HtmlTag52,:p82HtmlTag53,:p82HtmlTag54,:p82HtmlTag55,:p82HtmlTag56,:p82HtmlTag57,:p82HtmlTag58,:p82HtmlTag59,:p82HtmlTag60,:p82HtmlTag61,:p82HtmlTag62,:p82HtmlTag63,:p82HtmlTag64,:p82HtmlTag65,:p82HtmlTag66,:p82HtmlTag67,:p82HtmlTag68,:p82HtmlTag69,:p82HtmlTag70,:p82HtmlTag71,:p82HtmlTag72,:p82HtmlTag73,:p82HtmlTag74,:p82HtmlTag75,:p82HtmlTag76, :p82HtmlTag77, :p82HtmlTag78, :p82HtmlTag79, :p82HtmlTag80, :p82HtmlTag81, :p82HtmlTag82, :p82HtmlTag83";
    public static $p82HtmlTagArray = array(
        'p82HtmlTag01' => 'peg002_tab_items',
        'p82HtmlTag02' => 'core_submit',
        'p82HtmlTag03' => 'core_cancel',
        'p82HtmlTag04' => 'core_count',
        'p82HtmlTag05' => 'peg002_close_tab_label',
        'p82HtmlTag06' => 'peg002_close_all_tabs_label',
        'p82HtmlTag07' => 'peg002_close_all_other_tabs_label',
        'p82HtmlTag08' => 'core_is_not_pegasus_client',
        'p82HtmlTag09' => 'core_select_color',
        'p82HtmlTag10' => 'core_deny_empty_field_value',
        'p82HtmlTag11' => 'core_only_for_selectbox',
        'p82HtmlTag12' => 'core_selectbox_mng',
        'p82HtmlTag13' => 'core_selectbox_erase',
        'p82HtmlTag14' => 'core_selectbox_edit',
        'p82HtmlTag15' => 'core_selectbox_search',
        'p82HtmlTag16' => 'core_selectbox_list',
        'p82HtmlTag17' => 'core_dragtext',
        'p82HtmlTag18' => 'core_enable_editmode_title',
        'p82HtmlTag19' => 'core_dis_editmode_title',
        'p82HtmlTag20' => 'core_en_dis_editmode_title',
        'p82HtmlTag21' => 'core_no_item_selected',
        'p82HtmlTag22' => 'core_perm_deny_edit_rec',
        'p82HtmlTag23' => 'core_perm_deny',
        'p82HtmlTag24' => 'core_mask_msg',
        'p82HtmlTag25' => 'core_please_wait',
        'p82HtmlTag26' => 'core_export_forms_updfrst',
        'p82HtmlTag27' => 'core_confirm_submit',
        'p82HtmlTag28' => 'core_no',
        'p82HtmlTag29' => 'core_yes',
        'p82HtmlTag30' => 'core_no_rec_found',
        'p82HtmlTag31' => 'core_f5keydown_msg', 
        'p82HtmlTag32' => 'core_f5keydown_title',
        'p82HtmlTag33' => 'core_failed_to_load_data_ttl',
        'p82HtmlTag34' => 'core_failed_to_load_data_msg',
        'p82HtmlTag35' => 'core_logoutandrelogin' ,
        'p82HtmlTag36' => 'peg002_no_tabs_open' ,
        'p82HtmlTag37' => 'peg002_close_all_right_tabs_label' ,
        'p82HtmlTag38' => 'peg002_comboboxV2_quickFind' ,
        'p82HtmlTag39' => 'peg002_selectbox_add' ,
        'p82HtmlTag40' => 'peg002_selectbox_edit' ,
        'p82HtmlTag41' => 'peg002_selectbox_mng' ,
        'p82HtmlTag42' => 'peg002_selectbox_erase' ,
        'p82HtmlTag43' => 'peg002_comboboxV2_search_from' ,
        'p82HtmlTag44' => 'peg002_comboboxV2_search_to' ,
        'p82HtmlTag45' => 'peg002_comboboxV2_search_placeholder' ,
        'p82HtmlTag46' => 'peg002_comboboxV2_search_checkbox_label' ,
        'p82HtmlTag47' => 'peg002_comboboxV2_emptyText' ,
        'p82HtmlTag48' => 'peg002_comboboxV2_minSearchChars_text' ,
        'p82HtmlTag49' => 'core_actions' ,
        'p82HtmlTag50' => 'peg002_close__d',
        'p82HtmlTag51' => 'peg002_comboboxV2_select',
        'p82HtmlTag52' => 'peg002_reveal_password',
        'p82HtmlTag53' => 'peg002_pwd_encr_alert',
        'p82HtmlTag54' => 'peg002_filemanager_search',
        'p82HtmlTag55' => 'peg002_multidel_loading_txt00',
        'p82HtmlTag56' => 'peg002_multidel_loading_txt01',
        'p82HtmlTag57' => 'peg002_multidel_deleting',
        'p82HtmlTag58' => 'peg002_multidel_check_label',
        'p82HtmlTag59' => 'peg002_multidel_check_ok',
        'p82HtmlTag60' => 'peg002_multidel_check_error',
        'p82HtmlTag61' => 'peg002_multidel_success',
        'p82HtmlTag62' => 'peg002_global_search_placeholder',
        'p82HtmlTag63' => 'peg002_disk_usage_exceed_d_msg',
        'p82HtmlTag64' => 'peg002_contract_expired_d_msg',
        'p82HtmlTag65' => 'peg002_pwa_msg',
        'p82HtmlTag66' => 'peg002_scan_qr_code',
        'p82HtmlTag67' => 'core_browse_combo_tag',
        'p82HtmlTag68' => 'peg002_disk_usage_exceed_80_d_msg',
        'p82HtmlTag69' => 'peg002_contract_expires_warn_d_msg',
        'p82HtmlTag70' => 'peg002_fileexplorer_upload_failure_msg',
        'p82HtmlTag71' => 'peg002_fileexplorer_upload_failure_progress_msg',
        'p82HtmlTag72' => 'peg002_fileexplorer_action_delete_text',
        'p82HtmlTag73' => 'peg002_fileexplorer_action_rename_text',
        'p82HtmlTag74' => 'peg002_fileexplorer_action_open_text',
        'p82HtmlTag75' => 'peg002_fileexplorer_toast_uploading_title',
        'p82HtmlTag76' => 'peg002_fileexplorer_toast_uploaded_title',
        'p82HtmlTag77' => 'peg002_grid_check_failure_generic',
        'p82HtmlTag78' => 'peg002_grid_check_failure_no_recs',
        'p82HtmlTag79' => 'peg002_grid_check_success',
        'p82HtmlTag80' => 'peg002_grid_checkall_success',
        'p82HtmlTag81' => 'peg002_grid_uncheckall_success',
        'p82HtmlTag82' => 'peg002_en_dis_editmode_title',
        'p82HtmlTag83' => 'peg002_en_dis_multiselmode_title'

    );
    
    
    
    public function __construct( ){
        $this->isStore = false;
        $userCookie = new Peg002_Cookie();
        $this->lang = $userCookie->getLang();
        $this->set_profile($userCookie->getUser_profile());
         
        if(isset($_REQUEST['module'])){
            $this->set_module($_REQUEST['module']);
        }else{
            $this->set_module('');
        }
        
        if(isset($_REQUEST['_d'])){
            $this->set__d($_REQUEST['_d']);
        }else{
            $this->set__d('');
        }
        if(isset($_REQUEST['peg_parent_grid_name'])){
            $this->set_peg_parent_grid_name($_REQUEST['peg_parent_grid_name']);
        }else{
            $this->set_peg_parent_grid_name('');
        }
        if(isset($_REQUEST['isMobile'])){
            $this->set_isMobile($_REQUEST['isMobile']);
        }else{
            $this->set_isMobile('');
        }

        $this->display_type = '';
        if(isset($_REQUEST['display_type'])){
            $this->display_type = $_REQUEST['display_type']; 
            if($this->display_type == '_selectbox_grid' || $this->display_type == '_comboboxV2_grid'){
                $this->set_module($_REQUEST['dias_view_module']);
                $this->set__d($_REQUEST['dias_view_d']);
                if(isset($_REQUEST['peg_parent_grid_name'])){
                    $this->set_peg_parent_grid_name($_REQUEST['peg_parent_grid_name']);
                }else{
                    $this->set_peg_parent_grid_name('');
                }
            }
        }
//         $this->set_module($_REQUEST['module']);
//         $this->set__d($_REQUEST['_d']);
    }
    public function __toString(){
        
        if( $_SERVER['REMOTE_ADDR'] === '127.0.0.1'){
            peg002_optionHeader();
            if($_SERVER['REQUEST_METHOD'] == 'OPTIONS')
                return '';
        }
        
        
        $data = $this->getCurrentCacheFile();
        header('Content-Type: application/json');
        //         header("Content-Length:" . strlen($data));
        //         set_time_limit(0);
        return $data;
    }
    public function get_curCacheFile(){
        return $this->curCacheFile;
    }
    public function get_profile(){
        return $this->profile;
    }
    public function set_module($module){
        $this->module = $module; 
    }
    
    public function set__d($_d){    
        $this->_d = $_d; 
    }
    public function set_table($table){
        $this->table = $table;
    }
    public function set_isMobile($isMobile){    
        $this->isMobile = $isMobile; 
    }
    public function set_peg_parent_grid_name($peg_parent_grid_name){    
        $this->peg_parent_grid_name = $peg_parent_grid_name; 
    }
    public function set_profile($profile){ 
        
        $this->profile = $profile;
        if(!empty(  $this->profile )){
            $this->profilePath = 'profile_'.  $profile . '/';
        }else {
            $this->profilePath = 'profile'.  '/';
        }
    }
    

    
    
    public function getCurrentCacheFile(){
        if(self::$noCache && $this->type!='store'){
            return '';
        }
        
        if(empty($this->curCacheFile)){
            return '';
        }
        $file = file_get_contents( $this->curCacheFile);
        if($file === false){
            return '';
        }
//         $data = unserialize($file);
        return $file ;
    }
    
    public function getstructure_has_cache(){
        if(self::$noCache || in_array( $this->_d , self::$noCache_d)){
            //XXX Oi othones pou den prepei na exoun cache
            return false;
        }
        $this->curCacheFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCacheFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCacheFile .= substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if( $this->display_type == 'browse_d00'){
            if($this->isMobile=='true'){
                $this->curCacheFile .= $this->_d .'_browse_d00_mobile.json';
            }else{
                $this->curCacheFile .= $this->_d .'_browse_d00.json';
            }
        }elseif ( $this->display_type == '_selectbox_grid') {
            $this->curCacheFile .=  $this->_d .'_selectbox_grid.json';
        }elseif ( $this->display_type == '_comboboxV2_grid') {
            $mob_str='';
            if($this->isMobile=='true'){
                $mob_str='_mobile';
            }
            if(!empty($this->peg_parent_grid_name)){
                $this->curCacheFile .=  $this->_d .'_'.$this->peg_parent_grid_name.'_comboboxV2_grid'.$mob_str.'.json';
            }else{
                $this->curCacheFile .=  $this->_d .'_comboboxV2_grid'.$mob_str.'.json';
            }
        }else{
            if($this->isMobile=='true'){
                $this->curCacheFile .= $this->_d .'_mobile.json';
            }else{
                $this->curCacheFile .= $this->_d .'.json';
            }
        }
       
        if(file_exists( $this->curCacheFile )){
            
            return true;
        } 
        return false;
            
    }
    
    public function getstructure_generate_cache($data){
        if(is_array($data)){
            $data['cached'] = true; 
        }
        //die(var_dump($this->curCacheFile));
        return $this->_file_put_contents($data);
        
    }
    
    
    public function getfields_has_cache(){
        if(self::$noCache || in_array( $this->_d , self::$noCache_d)){
            //XXX Oi othones pou den prepei na exoun cache
            return false;
        }
        
        $this->curCacheFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCacheFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCacheFile .= substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCacheFile .= $this->_d .'_fields_browse_d00.json';
        }else{
            $this->curCacheFile .= $this->_d .'_fields.json';
        }
        if(file_exists( $this->curCacheFile )){ 
            return true;
        } 
        return false;
        
    }
    public function getfields_generate_cache($data){
        return $this->_file_put_contents($data);
       
    }
     
    
    public function  store_has_cache($storename){
        $this->type = "store";
        /* 
        if(self::$noCache )
            return false;
        } */  
        if(empty($storename)){
            return false;
        }
        
        $this->curCacheFile = static::$mainPath .$this->profilePath . 'store/'.$storename.'.json';  
        if(file_exists( $this->curCacheFile )){
            return true;
        }
        return false;
    }
    public function  store_has_cache_with_lang($storename, $lang = ''){ 
        if(empty($lang)){
            $lang = $this->lang ;
        }
        if(empty($storename) || empty( $lang )){
            return false;
        }
        $storename .= '_' .  $lang;

        return $this->store_has_cache($storename);
    }
    public function  store_generate_cache($data){
        return $this->_file_put_contents($data);
    }
    
    public function getData_p52_has_cache(){
        if(self::$noCache  ){
            //XXX Oi othones pou den prepei na exoun cache
            return false;
        }
        
        $this->curCacheFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        if(!empty($this->lang)){
            $this->curCacheFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCacheFile .=substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCacheFile .= $this->_d .'_p52_browse_d00.json';
        }else{
            $this->curCacheFile .= $this->_d .'_p52.json';
        }
        if(file_exists( $this->curCacheFile )){
            
            return true;
        }
        return false;
    }
    public function getData_p52_generate_cache($data){
        return $this->_file_put_contents($data);
        
    }
    
    public function getData_query_has_cache(){
        if(self::$noCache  ){
            //XXX Oi othones pou den prepei na exoun cache
            return false;
        }
        
        $this->curCacheFile = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/'.$this->table.'/';
        if(!empty($this->lang)){
            $this->curCacheFile .= $this->lang.'/';
        }
        if(!empty($_REQUEST['peg_ext_containerid'])){
            $this->curCacheFile .=substr($_REQUEST['peg_ext_containerid'], 0, 5).'/';
        }
        if(isset($_REQUEST['display_type'] ) && $_REQUEST['display_type'] == 'browse_d00'){
            $this->curCacheFile .= $this->_d .'_query_browse_d00.json';
        }else{
            $this->curCacheFile .= $this->_d .'_query.json';
        }
        if(file_exists( $this->curCacheFile )){ 
            return true;
        }
        return false;
    }
    public function getData_query_generate_cache($data){
        return $this->_file_put_contents($data);
        
    }
    
    public function logLastDataQuery($filename ='' , $query = ''){
        $tmpPath00 = static::$mainPath .$this->profilePath .$this->module.'/'.$this->_d.'/';
        $tmpPath ='';
        if(!empty($this->lang)){
            $this->curCacheFile .= $this->lang.'/';
        }
        if(!empty($filename)){
            $tmpPath00 .= $filename .'.sql'; 
        }else{
            $tmpPath00 .= 'dataQuery.sql'; 
        }
        $dirAr = explode('/', str_replace( static::$mainPath, '',$tmpPath00 ));
        $counter = (count($dirAr) - 1);
        for ($i = 0; $i < $counter ; $i++) {
            $tmpPath .= $dirAr[$i] .'/';
            if(!is_dir($tmpPath)){
                mkdir($tmpPath, 0777 , true);
            }
        }
        file_put_contents($tmpPath00, $query);
    }
    
    private function _file_put_contents($data){
        $tmpPath = static::$mainPath;
        $dirAr = explode('/', str_replace( static::$mainPath, '', $this->curCacheFile ));
        $counter = (count($dirAr) - 1);
        for ($i = 0; $i < $counter ; $i++) {
            $tmpPath .= $dirAr[$i] .'/';
            if(!is_dir($tmpPath)){
                mkdir($tmpPath, 0777 , true);
            }
        }
        if($this->curCacheFile){
            file_put_contents($this->curCacheFile, json_encode($data),LOCK_EX);
        }
    }
    
} 