<?php 

class Peg002_MySQL{
    private static $tmpPath = '../../tmp/queryLog/';
    
    public static function pegasus_query($query , $values = array(), $no_log=0 ){
       
        $dt = microtime(TRUE);
        
        $tmpvar = pegasus_query($query,$values,  $no_log); 
        if ((!$tmpvar) and pegasus_displayErrors()) {
            debug_backtrace() ;
            // mysql _ error();
            var_dump(  debug_backtrace() );
            var_dump($query);
            var_dump($values);
            // var_dump($GLOBALS['pdo']->errorMsg);
            die('Whole query: ' . $query  . "\n<br>");
        }
        
        Peg002_MySQL::_writeLogFile('EndQuery ' . $query . " duration " .( microtime(TRUE)- $dt ), $query);
        return $tmpvar;
    }
    
   /**
	 * H συναρτηση αυτή επιστρέφει την τιμή του πεδίου $field του πίνακα $table που για το οποίο ισχύει η συνθήκη στο $where
	 *
	 * @param string $table O Πίνακας στην βάση
	 * @param string $field το πεδίο
	 * @param string $where η συνθήκη που θα φέρει το πεδίο
	 * @param array $values o πίνακας με τις τιμές που θα πάρουν τα αναγνωριστικά στο query. Μπορεί να είναι associative ή indexed.
	 * @return mixed
	 *
	 * @example
	 *  <pre>
	 *  <code>
	 *  $us0_p97 = Peg002_MySQL::pegasus_printfld(
	 *     'us0' ,
	 *     'p97' ,
	 *     'p01=:user_name',
	 *     array(
	 *         'user_name' => $user_name
	 *     )
	 *  );
	 * </code>
	 * </pre>
	 */
    public static function pegasus_printfld($table , $field , $where,$values=array()){
        return pegasus_mysql_printfld($table , $field , $where, $values);
    }
    
    private static function _writeLogFile($action,$var  ){ 
        return ;  
        $mode = 'a';
        /* if($this->execForTime==0){
         $mode = 'w';
         } */
        
        $fp = fopen(Peg002_MySQL::$tmpPath.'/query.log', $mode );
        if(!empty($var)){
            fprintf($fp, "Exec time time %s \n \t Current action: %s \n\tdump: %s MB \n  ",date('Y-m-d H:i:s'),$action,var_export($var,true) );
        }else{
            fprintf($fp, "Exec time time %s \n \t Current action: %s  \n\tdump: %s MB \n  ",date('Y-m-d H:i:s'),$action,var_export($this,true) );
        }
        fclose($fp);
    } 
}

