<?php 
    class GridProperty{
        private $container_id;
        private $caching;
        private $name;
        private $_d;
        private $table;
        private $module;
        private $nr01;
        private $var1;
        private $var2;
        private $var3;
        private $var4;
        private $var5;
        private $view_d;
        private $view_table;
        private $view_module;
        private $view_nr01;
        private $view_grid_name;
        private $view_grid_where_array;
        private $view_grid_order_array;
        private $where_array;
        private $p52;
        private $p51;
        private $p51_filter;
        //Στο query_fields κρατάμε τις στήλες του select από το query ή table_query(εφόσον αυτό υπάρχει στο grid)
        private $query_fields;
        private $property_grid_container_id;
        /**  */
        private $field_data_array; 
        private $result_array;
        private $json_data_arr;
        private $is_browse_d0021_display;

        private $debug;
        private $debug_last_caller;

        private $records_count;



        public function __construct($container_id='',$name='',$_d='',$table='',$module='',$nr01='',$view_d='',$view_table='',$view_module='',$view_nr01='',$view_grid_name=''){
            $this->caching=$_SESSION['cor000_en_caching'];$this->caching=0;
            /** Set data from request **/
            $this->set_container_id($container_id);
            $this->set_name($name);
            $this->set__d($_d);
            $this->set_module($module);
            $this->set_nr01($nr01);
            $this->set_view_d($view_d);
            $this->set_view_table($view_table);
            $this->set_view_module($view_module);
            $this->set_view_nr01($view_nr01);
            $this->set_view_grid_name($view_grid_name);
            $this->set_vars_1_to_5();
            $this->set_where_array();
            $this->field_data_array=array();
            $this->is_browse_d0021_display=false;
            $this->set_debug(false);
            // $this->set_debug(true);
        }  
    /********************** S E T T E R S **********************/
        public function set_container_id($container_id){
            $this->container_id=$container_id;
        }
        public function set_name($name=''){
            /** If $name is empty I read it from the request/session */
            if(empty($name)){
                $name=$this->read_param_from_request('name');
            }
            $this->name=$name;
        }
        public function set__d($_d=''){
            /** If $_d is empty I read it from the request/session */
            if(empty($_d)){
                $_d=$this->read_param_from_request('_d');
            }
            $this->_d=$_d;
        }
        public function set_table($table=''){
            /** If $_d is empty I read it from the request/session */
            if(empty($table)){
                $table=$this->read_param_from_request('table');
            }
            $this->table=$table;
        }
        public function set_module($module=''){
            /** If $module is empty I read it from the request/session */
            if(empty($module)){
                $module=$this->read_param_from_request('module');
            }
            $this->module=$module;
        }
        public function set_nr01($nr01=''){
            /** If $nr01 is empty I read it from the request/session */
            if(empty($nr01)){
                $nr01=$this->read_param_from_request('nr01');
            }
            $this->nr01=$nr01;
        }
        public function set_vars_1_to_5($var1='',$var2='',$var3='',$var4='',$var5=''){
            /** If $nr01 is empty I read it from the request/session */
        	for($i=1; $i<6; $i++){
                if(empty(${'var' . $i})){
                    ${'var' . $i}=$this->read_param_from_request('var' . $i);
                }
            }
            $this->var1=$var1;
            $this->var2=$var2;
            $this->var3=$var3;
            $this->var4=$var4;
            $this->var5=$var5;
        }
        public function set_view_d($view_d=''){
            /** If $view_d is empty I read it from the request/session */
            if(empty($view_d)){
                $view_d=$this->read_param_from_request('view_d');
            }
            $this->view_d=$view_d;
        }
        public function set_view_table($view_table=''){
            /** If $view_table is empty I read it from the request/session */
            if(empty($view_table)){
                $view_table=$this->read_param_from_request('view_table');
            }
            $this->view_table=$view_table;
        }
        public function set_view_module($view_module=''){
            /** If $view_module is empty I read it from the request/session */
            if(empty($view_module)){
                $view_module=$this->read_param_from_request('view_module');
            }
            $this->view_module=$view_module;
        }
        public function set_view_nr01($view_nr01=''){
            /** If $view_nr01 is empty I read it from the request/session */
            if(empty($view_nr01)){
                $view_nr01=$this->read_param_from_request('view_nr01');
            }
            $this->view_nr01=$view_nr01;
        }
        public function set_view_grid_name($view_grid_name=''){
            /** If $view_grid_name is empty I read it from the request/session */
            if(empty($view_grid_name)){
                $view_grid_name=$this->read_param_from_request('view_grid_name');
            }
            $this->view_grid_name=$view_grid_name;
        }
        public function set_where_array(){
            $sess_var_name='gridData_' . $this->container_id . '_' . $this->name . '_where_array';
            $where_array = $_SESSION[$sess_var_name];
            if(empty($where_array)){
                $where_array = array();
            }
            pegasusSessionSetVar($sess_var_name, $where_array);
            $this->where_array=$where_array;
        }
        public function set_view_grid_where_array($view_grid_where_array){
            // var_dump($view_grid_where_array);
            $this->view_grid_where_array=$view_grid_where_array;
        }
        public function set_view_grid_order_array($view_grid_order_array){
            $this->view_grid_order_array=$view_grid_order_array;
        }
        public function set_p52_values(){
            $var_name = 'property_griddata_p52_peg002_'.  $this->get_module().'_'.$this->get__d().'_'.$this->get_name().'_'.$_SESSION['user_profile'];
	        $folder_name=$this->get_module().'/'.$this->get__d();
            $p52 = pegasusGetGlobalVar($var_name,$folder_name);$p52='';
            if($p52=='' or $this->caching==0){
                $p52_query_arr= $this->get_p52_query();
                $res = Peg002_MySQL::pegasus_query($p52_query_arr['sql'],$p52_query_arr['sqlParams']);
                // echo(pegasus_replace_values_in_sql($p52_query_arr['sql'], $p52_query_arr['sqlParams']));
                $p52=array();
                while($p520 = pegasus_fetch_assoc($res)){
                    $p52[$p520['par_nm']] = $p520['par_val'];
                    $p52[$p520['par_nm'] . '_code'] = $p520['code'];
                }
                pegasusSetGlobalVar($var_name , $p52, $folder_name); 
            }
            /** Σεταρω αυτες τις μεταβλητες γιατι μπορει να χρησιμοποιούνται στο p52 */
            $view_d=$this->get_view_d();            $_d=$this->get__d();
            $view_module=$this->get_view_module();  $module=$this->get_module();
            $view_table=$this->get_view_table();    $table=$this->get_table();
            $nr01=$this->get_nr01();                $view_nr01=$this->get_view_nr01();
            $var1=$this->get_var1();$var2=$this->get_var2();$var3=$this->get_var3();$var4=$this->get_var4();$var5=$this->get_var5();
            $container_id=$this->get_container_id();
            $name=$this->get_name();

            if($p52['_d_code']==1){
                $p52['_d'] = eval($p52['_d']);
            }
            if($p52['module_code']==1){
                $p52['module'] = eval($p52['module']);
            }
            if($p52['table_code']==1){
                $p52['table']  = eval($p52['table']);
            }
            if($p52['table_query_code']==1){
                $p52['table_query']  = eval($p52['table_query']);
            }
            if($p52['nr01_code']==1){
                $p52['nr01']   = eval($p52['nr01']);
            }	
            if($p52['query_code']==1){
                $p52['query']   = eval($p52['query']);
            }
            if(!empty($p52['_d'])){
                $this->set_view_d($p52['_d']);
            }
            if(!empty($p52['table'])){
                $this->set_view_table($p52['table']);
            }
            if(!empty($p52['module'])){
                $this->set_view_module($p52['module']);
            }
            if(!empty($p52['query'])){
                // var_dump($p52['query']);
                // $this->set_query($p52['query']);
            }
            // echo $this->get_view_table();
            // echo $this->get_view_d();
            // echo $this->get_view_module();
            $this->p52=$p52;
        }
        public function set_p51_values(){
            $var_name = 'property_griddata_p51_peg002_'.$this->get_module().'_'.$this->get__d().$_SESSION['user_profile'].'_'.$GLOBALS['userCookie']->getLang();
            $folder_name=$this->get_module().'/'.$this->get__d();
            $p51 = pegasusGetGlobalVar($var_name,$folder_name); $p51='';
            if($p51=='' || $this->caching==0 || (is_array($p51) && count($p51)< 1)){
                $p51_query_arr= $this->get_p51_query();
                $res = Peg002_MySQL::pegasus_query( $p51_query_arr['sql'], $p51_query_arr['sqlParams']);
                $p51= pegasus_fetchall($res);
                pegasusSetGlobalVar($var_name , $p51, $folder_name); 
            }
            $this->p51=$p51;
        }
        public function set_p51_filter($p51_filter=''){
            /** If $view_table is empty I read it from the request/session */
            if(empty($p51_filter)){
                $p51_filter=$this->read_param_from_request('p51_filter');
            }
            $this->p51_filter=$p51_filter;
        }
        public function set_property_grid_container_id($property_grid_container_id=''){
            if(empty($property_grid_container_id)){
                $property_grid_container_id=$this->read_param_from_request('property_grid_container_id');
            }
            $this->property_grid_container_id=$property_grid_container_id;
        }
        
        public function set_is_browse_d0021_display($is_browse_d0021_display){
            $this->is_browse_d0021_display=trim($is_browse_d0021_display);
        }
        public function set_debug($debug){
            $this->debug=$debug;
        }
        public function set_records_count($records_count){
            $this->records_count=$records_count;
        }
    /********************** G E T T E R S **********************/
        public function get_where_array(){
            return $this->where_array;
        }
        public function get_view_grid_where_array(){
            return $this->view_grid_where_array;
        }
        public function get_view_grid_order_array(){
            return $this->view_grid_order_array;
        }
        public function get_name(){
            return $this->name;
        }
        public function get__d(){
            return $this->_d;
        }
        public function get_table(){
            if(empty($this->table)){
                return $this->get_view_table();
            }
            return $this->table;
        }
        public function get_module(){
            return $this->module;
        }
        public function get_nr01(){
            return $this->nr01;
        }
        public function get_view_d(){
            return $this->view_d;
        }
        public function get_view_table(){
            return $this->view_table;
        }
        public function get_view_module(){
            return $this->view_module;
        }
        public function get_view_nr01(){
            return $this->view_nr01;
        }
        public function get_view_grid_name(){
            return $this->view_grid_name;
        }
        public function get_var1(){
            return $this->var1;
        }
        public function get_var2(){
            return $this->var2;
        }
        public function get_var3(){
            return $this->var3;
        }
        public function get_var4(){
            return $this->var4;
        }
        public function get_var5(){
            return $this->var5;
        }
        public function get_container_id(){
            return $this->container_id;
        }
        public function get_p51_filter(){
            return $this->p51_filter;
        }
        public function get_property_grid_container_id(){
            return $this->property_grid_container_id;
        }
        public function get_is_browse_d0021_display(){
            return $this->is_browse_d0021_display;
        }
        public function get_debug(){
            return $this->debug;
        }
        public function get_records_count(){
            return $this->records_count;
        }
    /********************** P U B L I C   M E T H O D S **********************/
        /** This method creates the sql query that gets all property grid data and saves the result in $this->result_array
         * @return array('sql'=> '...', 'sqlParams' => array(...) ) An array containing the query and the pdo params
         */
        public function make_query(){
            $this->debug(   "view table:".$this->get_view_table()."\n".
                            "table:".$this->get_table()."\n".
                            "view _d:".$this->get_view_d()."\n".
                            "_d:".$this->get__d()."\n".
                            "view module:".$this->get_view_module()."\n".
                            "module:".$this->get_module());
            $this->set_p52_values();
            $this->find_query_fields(); //Γεμίζω τον πίνακα με τα fields, εφόσον έχει σεταριστεί το this->p52["table_query"] και this->p52["query"]
            $this->debug(   "view table:".$this->get_view_table()."\n".
                            "table:".$this->get_table()."\n".
                            "view _d:".$this->get_view_d()."\n".
                            "_d:".$this->get__d()."\n".
                            "view module:".$this->get_view_module()."\n".
                            "module:".$this->get_module());
            $this->set_view_grid_where_array(pegasusGetGlobalVar( 'gridData_' . $this->get_container_id() . '_' . $this->get_view_grid_name() . '_where_array' ));
            $this->set_view_grid_order_array(pegasusGetGlobalVar( 'gridData_' . $this->get_container_id() . '_' . $this->get_view_grid_name() . '_order_array' ));
            $this->set_p51_values();


            $desc05='';
            $desc02='';
            $field_arr=array();
            foreach ($this->p51 as $p51) {
                $this->debug(print_r($p51,1));
                $this->update_field_data($p51);
            }

            foreach ($this->field_data_array as $key => $value) {
                if(isset($value['browse_jn_table']) && !pegasus_mysql_table_exists($value['browse_jn_table'])){
                    unset($this->field_data_array[$key]);
                }
            } 
            $this->add_remfields();
            $query_fields=$this->make_query_fields();
            $whereArr=$this->make_query_where();
            $where=$whereArr['sql'];
            $whereParams=$whereArr['sqlParams'];
            $join=$this->make_query_join();
            $query='';	
            
            /** Σεταρω αυτες τις μεταβλητες γιατι μπορει να χρησιμοποιούνται στο p52 */
            $view_d=$this->get_view_d();$_d=$this->get__d();
            $view_module=$this->get_view_module();$module=$this->get_module();
            $view_table=$this->get_view_table();$table=$this->get_table();
            $nr01=$this->get_nr01();$view_nr01=$this->get_view_nr01();
            $var1=$this->get_var1();$var2=$this->get_var2();$var3=$this->get_var3();$var4=$this->get_var4();$var5=$this->get_var5();
            $container_id=$this->get_container_id();
            $name=$this->get_name();

            if(!empty($this->p52['query'])){               
                $query_p52 =  $this->p52['query'];
                if(is_array($query_p52)){
                    $whereParams=array_merge($whereParams,$query_p52['sqlParams']);
                    $query_p52 =$query_p52['sql'];
                }
                $query_p52 =rtrim($query_p52,"; \t\n\r\0\x0B");
                $query = " select "	. $query_fields . " from (".$query_p52.") as " . $this->get_table() . " " . $join  . $where . " limit 1;";	 
           
            }else{
                $this_table=$this->get_table();
                if (!empty($this->p52['table_query'])) {
                    $table_query_p52 =  $this->p52['table_query'];
                    if(is_array($table_query_p52)){
                        $whereParams=array_merge($whereParams,$table_query_p52['sqlParams']);
                        $table_query_p52['sql'] = trim(str_replace(';', '', $table_query_p52['sql']));
                        $this_table = '(' . $table_query_p52['sql']. ') as ' . $this_table;
                    }else{
                        $table_query_p52 = trim(str_replace(';', '', $table_query_p52));
                        $this_table = '(' . $table_query_p52. ') as ' . $this_table;
                    }
                }
            
                if(!empty($this_table)){
                    $query = " select "	. $query_fields . " from " . $this_table . " " . $join  . $where . " limit 1;";	 
                }
            }

            $this_table=$this->get_table();
            
            //προσθέσαμε τον έλεγχο για $this->get_view_nr01 , γιατί δεν έχει νόημα να γίνει query χωρίς where nr01. 
            //Εκτελούταν στο browse_d0021 μέσα στην print_data χωρίς where και καθυστερούσε πολύ το tesae, εκεί δεν έχουμε επιλεγμένο where
            if(empty($query) || empty($this_table) || !($this->get_view_nr01()>0)){
                $this->result_array=array();

            }else{
                $this->debug (pegasus_replace_values_in_sql($query,$whereParams));
                // peg_write_file('../../tmp/browse00_prop.sql', pegasus_replace_values_in_sql($query, $whereParams));
	            pegasus_mysql_use($query , $this->result_array , $whereParams ); 
            }
            
            return array('sql'=>$query,'sqlParams'=> $whereParams);
        }
        /** This method returns the result as a php array or HTML string. If method make_query has not been executed before, it gets called inside print_data. 
         * @param int $return_html Pass 1 to return the data as an HTML string. 
         * @return string|array The result data
         */
        public function print_data($return_html=0){
            $res_arr=array();
             
            if(empty($this->result_array)){
                $this->make_query();
            } 
	        foreach ($this->field_data_array as $desc05 => $fld) {
                $arr=array();

                if( $fld['name'] =='remuser' ||  $fld['name']=='remfuser'){
                    $us0_p100=pegasus_mysql_printfld('us0','p100','p01=?',array(  $this->result_array[$fld['name']] ));
                    if(!empty($us0_p100)){
                        $this->result_array[$fld['name']] = "(".$this->result_array[$fld['name']].") ".$us0_p100;
                    }
                }
                if(  
                    $fld['type']=='multi_selectbox' &&  
                    !empty($fld['multi_selectbox_displayField']) &&
                    !empty( $fld['multi_selectbox_valueField'] ) && 
                    pegasus_mysql_table_exists($fld['grid_table']) ){
                    $arr['value'] = '';
                 //   var_dump($fld['name'],$this->result_array);
                    $value_array = explode( "#" ,$this->result_array[$fld['name']]);
                    foreach ($value_array as $value) {
                        if(!empty($value)){
                            $displayValue = pegasus_mysql_printfld(
                                $fld['grid_table'] , 
                                $fld['multi_selectbox_displayField'] ,  
                                $fld['multi_selectbox_valueField'] .' = ?',
                                array($value) ); 
                            $arr['value'] .= empty($arr['value']) ? $displayValue : ',' . $displayValue;
                        }
                    }
                    
                    $arr['field'] = $fld['name']; 
                    $arr['type']  = $fld['type'];
                    $arr['db_type']  = $fld['db_type'];
                    $arr['name']  = $fld['browse_title'] ;
                }elseif( 
                    ($fld['type']=='selectbox' or $fld['type']=='comboboxV2') and   
                    $fld['br_table']!='' and 
                    pegasus_mysql_table_exists( $fld['br_table']) and 
                    $fld['browse_jn_table']=='' 
                    ){

               
                    
                    if($fld['browse_selectbox_type']==1){ //μονο code
                        if(trim($fld['browse_selectbox_code_title'])!=''){
                            $arr['name']  = $fld['browse_selectbox_code_title'];
                        } else{				
                            $arr['name']  = $fld['browse_title'] . '(' . $_SESSION['peg_dic_core_code'] . ')'; 
                        }
                        $arr['field'] = $fld['name']; 
                        $arr['value'] = $this->result_array[$fld['name']];
                        $arr['type']  = $fld['type'];
                        $arr['db_type']  = $fld['db_type'];
                    }elseif($fld['browse_selectbox_type']==3){ //code και περιγραφή
                        if(!empty($fld['browse_selectbox_code_title'])){
                            $arr['name']  = $fld['browse_selectbox_code_title'];
                        } else{				
                            $arr['name']  = $fld['browse_title'] . '(' . $_SESSION['peg_dic_core_code'] . ')'; 
                        }
                        $arr['field'] = $fld['name']; 
                        $arr['value'] = $this->result_array[$fld['name']];
                        $arr['type']  = $fld['type'];
                        $arr['db_type']  = $fld['db_type'];
                        array_push($res_arr , $arr);	
                        
                        $arr=array();
                        $arr['name']  = $fld['browse_title']; 
                        $arr['field'] = $fld['name']; 
                        $arr['value'] = $this->result_array[ 'v_selectbox_' .  $fld['name']];
                        $arr['type']  = $fld['type'];
                        $arr['db_type']  = $fld['db_type'];
                        
                    }else{ //μόνο περιγραφή
                        $arr=array();
                        $arr['name']  = $fld['browse_title'] ; 
                        $arr['field'] = $fld['name']; 
                        $arr['value'] = $this->result_array[ 'v_selectbox_' .  $fld['name']];
                        $arr['type']  = $fld['type'];
                        $arr['db_type']  = $fld['db_type'];
                    
                    }
                    
                    if(!empty($this->result_array[$fld['name']])){
                        $url = $this->add_tab_js_code(
                            $fld['br_table'],
                            $fld['_d'],
                            $fld['module'],
                            $fld['valueField'],
                            $this->result_array[$fld['name']]
                        );
                        if (!empty($url)) {
                            $displayValue =  $arr['value'];
                            $displayValue = "<a href=\"#\" onclick=\"$url\">$displayValue</a>";
                            $arr['value'] = $displayValue;
                        }
                    }

                }else{
                    $arr['name']  = $fld['browse_title']; 
                    $arr['field'] = $fld['name']; 
                    
                    if( !empty($fld['ls_data']) ){
                        $ls_data = json_decode($fld['ls_data'] , true);
                        if(is_array($ls_data)){
                            foreach ($ls_data as $combo_arr00){
                                if($combo_arr00[$fld['valueField']] == $this->result_array[$fld['name']]){
                                    $arr['value'] = $combo_arr00[$fld['displayField']];
                                }
                            }
                        }
                        
                    }elseif($fld['db_type']=='L'){
                        if($this->result_array[$fld['name']]=='1'){
                            $arr['value'] = $_SESSION['peg_dic_core_yes'];
                        }else{
                            $arr['value'] = $_SESSION['peg_dic_core_no'];
                        }
                        
                    }elseif($fld['db_type']=='D'){
                        $arr['value'] = peg_dateToStr($this->result_array[$fld['name']] , $_SESSION['cor000_dt_format']);        
                    }elseif ($fld['type']=='numberbox'){
                        $decimal_plases = $fld['desc18'];
                        if(!($decimal_plases>0)){
                            $decimal_plases=0;
                        }
                        $val = $this->result_array[$fld['name']];
                        if(empty($val)){
                            $val = 0;
                        }			
                        $arr['desc18']=$fld['desc18'];			
                        $arr['thousand_format']=$fld['thousand_format'];
                        if(!($arr['thousand_format']>0)){
                            $arr['thousand_format']=0;
                        }
                        
                        $arr['value']=peg002_format_number($val,$decimal_plases,$arr['thousand_format']);
                    }else{

                        $arr['value'] = $this->result_array[$fld['name']];
                        if(isset($this->result_array[$fld['name'] . '_fld_value']) && !empty($fld['br_table'])){
                            // echo $fld['name'] . '_fld_value';
                            //Το βάζω για τα comboboxv2 που έχουν συμπληρωμένο το browse_jn_table
                            // var_dump($this->result_array);
                            $url = $this->add_tab_js_code(
                                $fld['br_table'],
                                $fld['_d'],
                                $fld['module'],
                                $fld['valueField'],
                                $this->result_array[$fld['name'] . '_fld_value']
                            );
                            if (!empty($url)) {
                                $displayValue =  $arr['value'];
                                $displayValue = "<a href=\"#\"  onclick=\"$url\">$displayValue</a>";
                                $arr['value'] = $displayValue;
                            }
                        }

                       
                        
                    }
                    $arr['type']     = $fld['type'];
                    $arr['db_type']  = $fld['db_type'];
                    
                }
                array_push($res_arr , $arr);                
            }
            $this->json_data_arr=$res_arr;
            if($return_html==1){
                return $this->print_data_html();
            }
          //  var_dump($res_arr);
            return $res_arr;
        }
        /** This method returns an HTML string for a collapsible item. 
         * @param string $title The title of the collapsible
         * @param string $content The content of the collapsible 
         * @return string The HTML for the collapsible item
         */
        public function print_html_collapsible($title,$content,$prop=array()){
            $button_search='';
            if(!empty($prop)){ 
                $button_search='<button title="'.$_SESSION['peg_dic_peg002_search'].'" class="peg_grid_prop_icon_search" onclick="event.stopPropagation();'.$this->search_js_code($prop).' " >
                <i class="fas fa-search"></i>
            </button>';
            }
            return '
            <div type="button" class="peg_grid_prop_collapsible" onclick="peg002_GridProperty_html_collapse(this)">'
                        .$title.'
                        <div class="peg_grid_prop_icon peg_grid_prop_icon_expanded">
                            <i class="fas fa-angle-up"></i>
                        </div>
                        <div class="peg_grid_prop_icon peg_grid_prop_icon_collapsed" style="display:none">
                            <i class="fas fa-angle-down"></i>
                        </div> 
                        '.$button_search.'
                    </div>
                    <div class="peg_grid_prop_content" style="display:block;"> 
             
                    <p>'.$content.'</p>
                    </div>'.$this->print_html_row_fliters($prop);
        }
        /** This method returns an HTML string for a data row 
         * @param string $label The data label
         * @param string $value The value
         * @param string $i The index of the data row
         * @return string The HTML for the data row
         */
        public function print_html_row($label,$value,$i=0,$prop=array()){
            if($this->get_view_nr01()>0){
                $label.=':';
            }
            $html='<div class="peg_grid_prop peg_grid_prop'.($i%2).'">';
            $html.='<span class="peg_grid_prop_label ">'.$label.'</span>';
            $html.=' <span class="peg_grid_prop_value">'.$value.'</span>';
            
            $html.=$this->print_html_row_fliters($prop);
            $html.='</div>';
            return $html;
        }

        public function print_html_row_fliters($prop){
            if(!function_exists('make_grid_where_message00')){
                return '';
            }
            $grid_where_array=$this->get_view_grid_where_array();
            
            $grid_order_array=$this->get_view_grid_order_array();
            $html='';
            $i=0;
            foreach ($grid_where_array as $filter) { 
                // var_dump($filter,$prop);
                $filter_content='';
                if($filter['field_name']==$prop['field']){
                    // if(!(empty($filter['mode']) && empty($filter['value']) ) ){
                        $filter_content.=    "<div class='peg_grid_prop_tag_content' >".
                                                 make_grid_where_message00( $filter , $this->get_view_d() , $this->get_view_module()). 
                                             ' </div>';

                    // }
                    foreach($grid_order_array as $order){
                        if($order['name']==$prop['field'] && in_array($order['order'],array('asc','desc')) ){
                            if(!empty($filter_content)){
                                $filter_content.='<br>';
                            }
                            $filter_content.=    "<div class='peg_grid_prop_tag_content' >".
                                                    '<div class=\'peg_grid_prop_tag_content_icon\' ><i class="fa fa-caret-'.(($order['order']=='asc')?'up':'down').'" aria-hidden="true"></i> </div> '.
                                                    $_SESSION['peg_dic_peg002_order_by_'.$order['order']].
                                                    " (".$order['order_tax'].")".
                                                    ' </div>';
                        }

                    }
                } 

                if(!empty($filter_content)){
                    $html.= "<div class='peg_grid_prop_tag' id='peg_prop_tag_".$this->get_container_id()."_$i' onclick=\"javascript:".$this->search_js_code($prop)."\"> ".
                                '<div class="peg_grid_prop_tag_close" onClick=\'event.stopPropagation();peg002ClearFilter('.json_encode($filter).',"'.$this->get_container_id().'","'.$this->get_view_grid_name().'","peg_prop_tag_'.$this->get_container_id().'_'.$i.'")\'>
                                    <i class="fa fa-times" aria-hidden="true"></i> 
                                </div>'.
                                $filter_content.
                            "</div>";
                }
                $i++;
            }
            return $html;
        }
    /********************** P R I V A T E   M E T H O D S **********************/
        private function find_query_fields(){

            //$filename = "../../tmp/check_table_query_column.txt";


            if (!empty($this->p52['table_query'])) {
                $table_query_p52 =  $this->p52['table_query'];
                if(is_array($table_query_p52)){
                    $table_query_p52['sql'] = trim(str_replace(';', '', $table_query_p52['sql']));
                    pegasus_mysql_use("select * from (" . $table_query_p52['sql'] . ") as gridprop limit 1", $cols, $table_query_p52['sqlParams']);
                    //die("tt:" .print_r($cols, 1));
                }else{
                    $table_query_p52 = trim(str_replace(';', '', $table_query_p52));
                    pegasus_mysql_use("select * from (" . $table_query_p52. ") as gridprop limit 1",$cols);
                }
                $this->query_fields = array_keys($cols);
            }

            
            // if (!empty($this->p52['query'])) {
            //     $query_p52 =  $this->p52['query'];
            //     if(is_array($query_p52)){
            //         $query_p52['sql'] = trim(str_replace(';', '', $query_p52['sql']));
            //         pegasus_mysql_use("select * from (" .$query_p52['sql']. ") as gridprop limit 1",$cols,$query_p52['sqlParams']);
            //     }else{
            //         $query_p52 = trim(str_replace(';', '', $query_p52));
            //         pegasus_mysql_use("select * from (" .$query_p52. ") as gridprop limit 1",$cols);
            //     }
            //     $this->query_fields = array_keys($cols);
            // }

            //peg_write_file($filename, print_r($this->query_fields, 1));
            
        }

        private function check_table_query_column($colName=''){
            if(empty($colName)){
                return true;
            }

            if (!empty($this->p52['table_query']) || !empty($this->p52['query']) ){
       
                if(!empty($this->query_fields) && !in_array($colName, $this->query_fields)){
                    return true;
                }
                foreach($this->json_data_arr as $fld_arr){
                    if( $fld_arr['field']==$colName && !in_array($colName,array('remdate','remdfate','remtime','remftime','remuser','remfuser','remguc'))){
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private function read_param_from_request($name){
            $sess_var_name='gridData_' .$this->container_id. '_' . $this->name . '_' . $name;
            if(isset($_REQUEST[$name])){
                $value=$_REQUEST[$name];
                pegasusSessionSetVar($sess_var_name , $value );
            }else{
                $value = $_SESSION[$sess_var_name] ;
            }
            return $value;
        }
        private function get_p52_query(){
            $query = peg_read_file('../peg002_sql/GridProperty/p52.sql'); 
            $queryParams=array(
                'lang'      =>  $GLOBALS['userCookie']->getLang(),
                'name'      =>  $this->get_view_grid_name(),
				'module'    =>  $this->get_module(),
				'_d'        =>  $this->get__d()
            );
            $this->debug(pegasus_replace_values_in_sql( $query , $queryParams));
            return array('sql'=>$query , 'sqlParams'=>$queryParams);
        }
        private function get_p51_query(){
            $query = peg_read_file('../peg002_sql/GridProperty/p51.sql'); 
            $queryParams=array(
                'lang_00'       =>  $GLOBALS['userCookie']->getLang(),
                'lang_01'       =>  $GLOBALS['userCookie']->getLang(),
				'_d'            =>  $this->get_view_d(),
				'module'        =>  $this->get_view_module(),
				'user_profile'  =>  $_SESSION['user_profile'],
                'p51_filter00'  =>  $this->get_p51_filter(),
                'p51_filter01'  =>  $this->get_p51_filter(),
                'p51_filter02'  =>  $this->get_p51_filter(),
                'p51_filter03'  =>  $this->get_p51_filter()
            );
            $this->debug(pegasus_replace_values_in_sql( $query , $queryParams));
            return array('sql'=>$query , 'sqlParams'=>$queryParams);
        }
        private function update_field_data($p51){
            if(!isset($this->field_data_array[$p51['desc05']])){
                $field_data=array(  "browse_title"  =>  $p51['desc02'] , 
                                    "desc07"        =>  $p51['desc07'], 
                                    "type"          =>  $p51['desc07'], 
                                    "name"          =>  $p51['desc05'], 
                                    "desc16"        =>  $p51['desc16'], 
                                    "desc02"        =>  $p51['desc02'], 
                                    "desc17"        =>  $p51['desc17'], 
                                    "db_type"        =>  $p51['desc16'],
                                    "desc18"        =>  $p51['desc18']);
                $this->field_data_array[$p51['desc05']]=$field_data;
            }
            /** Σεταρω αυτες τις μεταβλητες γιατι μπορει να χρησιμοποιούνται στο p52 */
            $view_d=$this->get_view_d();$_d=$this->get__d();
            $view_module=$this->get_view_module();$module=$this->get_module();
            $view_table=$this->get_view_table();$table=$this->get_table();
            $nr01=$this->get_nr01();$view_nr01=$this->get_view_nr01();
            $var1=$this->get_var1();$var2=$this->get_var2();$var3=$this->get_var3();$var4=$this->get_var4();$var5=$this->get_var5();
            $container_id=$this->get_container_id();
            $name=$this->get_name();
            $par_nm_array=array(
                'ls_data',
                'displayField',
                'valueField',
                'browse_selectbox_type',
                'browse_selectbox_code_title',
                'browse_jn_table',
                'browse_jn_as_table',
                'browse_jn_where',
                'browse_jn_field',
                'browse_jn_type',
                'browse_title',
                'multi_selectbox_valueField',
                'multi_selectbox_displayField',
                'thousand_format',
                'module',
                '_d'
            );
            if(in_array($p51['par_nm'],$par_nm_array)){
                if($p51['code']==1){
                    $val = eval($p51['par_val']);
                }else{
                    $val = $p51['par_val'];
                }
                $this->field_data_array[$p51['desc05']][$p51['par_nm']]=$val;
            }else{
                if($p51['par_nm']=='table'){
                    if($p51['code']==1){
                        $br_table = eval($p51['par_val']);
                    }else{
                        $br_table = $p51['par_val'];
                    }
                    $this->field_data_array[$p51['desc05']]['br_table']=$br_table;
                }	
                if($p51['par_nm']=='table'){
                    if($p51['code']==1){
                        $grid_table = eval($p51['par_val']);
                    }else{
                        $grid_table = $p51['par_val'];
                    }	
                    $this->field_data_array[$p51['desc05']]['grid_table']=$grid_table;				 
                }
            }
        }
        private function make_query_fields(){
	        $query_fields = '';

            foreach ($this->field_data_array as $desc05 => $field_data) {
                if ($this->check_table_query_column($desc05)==false){
                    continue;
                }
                if( (!empty($field_data['browse_jn_field'])) && 
                    (pegasus_mysql_table_exists($field_data['browse_jn_table']) || empty($field_data['browse_jn_table']) ) ){
                    if(!empty($query_fields)){$query_fields .= ',';}
                    // if(  pegasus_mysql_table_field_exists($field_data['browse_jn_table'], $field_data['browse_jn_field'] ) ){
                    
                        $query_fields.=$field_data['browse_jn_field'].' as '.$desc05;
                    // }

                    if(pegasus_mysql_table_field_exists($this->get_table(), $desc05)){
                        //Πρέπει να ελέγξω αν υπάρχει το field γιατι θα μπορούσε να είναι ψέυτικο πεδίο
                        if(!empty($query_fields)){$query_fields .= ',';}
                        $query_fields.=$this->get_table() . '.'.$desc05.' as '.$desc05 . "_fld_value";    
                    }
                }else{
                    $desc07=$field_data['desc07'];
                    $displayField=$field_data['displayField'];
                    $br_table=$field_data['br_table'];
                    $browse_jn_field=$field_data['browse_jn_field'];

                    if( ($desc07=='selectbox' or $desc07=='comboboxV2') && !empty($br_table)  &&  pegasus_mysql_table_exists($br_table)){
                        if(!empty($query_fields)){$query_fields .= ',';}
                        $query_fields .= $this->get_table()  . '.' . $desc05;
                        if( pegasus_mysql_table_field_exists($br_table, $displayField) ){
                            $query_fields .= ', selectbox_'.$desc05.'_' . $br_table  . '.' . $displayField .' as v_selectbox_' . $desc05;
                        }else{
                            $query_fields .= ','.$displayField.' as v_selectbox_' . $desc05;
                        }
                    }else{
                        if(empty($browse_jn_field)){
                            if(!empty($query_fields)){$query_fields .= ',';}
                            $query_fields .= $this->get_table() . '.'.$desc05;
                        } 
                    }
                }
            }
            if(empty($query_fields )){
                $query_fields =" nr01 ";
            }
            $this->debug($query_fields);
            return $query_fields;
        }
        private function make_query_where(){
	        $query_where='';
            $whereParams = array();
            
            /** Σεταρω αυτες τις μεταβλητες γιατι μπορει να χρησιμοποιούνται στο p52 */
            $view_d=$this->get_view_d();$_d=$this->get__d();
            $view_module=$this->get_view_module();$module=$this->get_module();
            $view_table=$this->get_view_table();$table=$this->get_table();
            $nr01=$this->get_nr01();$view_nr01=$this->get_view_nr01();
            $var1=$this->get_var1();$var2=$this->get_var2();$var3=$this->get_var3();$var4=$this->get_var4();$var5=$this->get_var5();
            $container_id=$this->get_container_id();
            $name=$this->get_name();
            // if(!empty($this->p52['where']) and $this->p52['where']!="''" and $this->p52['where']!='""' ){ 
            //     if($this->p52['where_code']==1){
            //         $www = @eval($this->p52['where']);
            //         if ( $www === false && ($error = error_get_last()) ) {
            //             if(pegasus_displayErrors()){
            //                 echo $this->p52['where'];
            //                 var_dump($error);
            //             }
                        
            //             die('Error in eval');
            //         } 

            //         if(!empty($www)){
            //             if(is_array($www)){
            //                 $whereParams=array_merge($whereParams,$www['sqlParams']);
            //                 $www=  $www['sql'];
            //             } 
                        
            //             $query_where = ' where /****/' . $www;
            //         }
            //     }else{
            //         $query_where = ' where ' . $this->p52['where'];
            //     }
            // }
            
            if($this->get_view_nr01()>0){
                $whereParams['nr01'] = $this->get_view_nr01();
                if(empty($query_where)){
                    $query_where  = " where ".$this->get_table().".nr01=:nr01 " ;
                }else{
                    $query_where  .= " and ".$this->get_table().".nr01= :nr01 " ;
                }
            }	
            $this->debug(pegasus_replace_values_in_sql($query_where,$whereParams));
            return array('sql' => $query_where ,'sqlParams'=>$whereParams);
        }
        private function make_query_join(){
            $join = array();
            foreach ($this->field_data_array as $desc05 => $jn){    
                if ($this->check_table_query_column($desc05)==false){
                    continue;
                }
                if( !empty($jn['browse_jn_table']) && pegasus_mysql_table_exists($jn['browse_jn_table']) && !empty( $jn['browse_jn_where']) ){
                    if(!empty($jn['browse_jn_type'])){ 
                        $tb = $jn['browse_jn_type'] . ' join ' ; 
                    }else{
                        $tb = ' left join ' ;
                    }
                    $tb .= $jn['browse_jn_table'];
                    if(!empty($jn['browse_jn_as_table'])){ 
                        $tb .= " as " . $jn['browse_jn_as_table'];
                    } 
                    //join on
                    if(!empty($join[$tb])){ 
                        $join[$tb] .= " and " ;
                    }
                    $join[$tb] .=   $jn['browse_jn_where'];
                }elseif(($jn['type']=='selectbox' || $jn['type']=='comboboxV2')  &&  pegasus_mysql_table_exists($jn['br_table'])){
                    $tb = ' left join ' ;
                    $tb .= $jn['br_table']  .  ' as selectbox_'.$jn['name'].'_' . $jn['br_table'] ;
                    
                    if(!empty($jn['browse_jn_field'])){
                        $join[$tb] .=  $jn['browse_jn_field'] . '= selectbox_'.  $jn['name'].'_' .  $jn['br_table'] . '.' .  $jn['valueField'];
                    }else{
                        $join[$tb] .=   $this->get_table() . '.' . $jn['name'] . '= selectbox_'.  $jn['name'].'_' .  $jn['br_table'] . '.' .  $jn['valueField'];
                    }		
                }
            }
            $q_join='';
            foreach ($join as  $key => $value) {
                $q_join .= "   " . $key . " on " . $value;	
            }
            $this->debug($q_join);
            return $q_join;
        }
        private function print_data_html(){
            $html='';
            $i=0;
            $tinyMCE='';
            if($this->get_records_count()>=0 && !$this->get_is_browse_d0021_display() ){
                $count_html=$this->print_html_row($_SESSION['peg_dic_peg002_property_grid_total_recs'],$this->get_records_count(),1);
            }
            $html.=$count_html;
            foreach($this->json_data_arr as $prop){ 
                if ($this->check_table_query_column($prop['field'])==false){
                    continue;
                }
                if($prop['type']=='textarea'){
                    if(!($this->get_view_nr01()>0)){
                        $prop['value']='';
                    }else{
                        if(empty($tinyMCE)){
                            $tinyMCE.='<br>';
                        }
                        $tinyMCE.=$this->print_html_collapsible($prop['name'],$prop['value'],$prop);
                        continue;
                    }
                }
                if($this->get_view_nr01()>0){
                    if($prop['type']=='datebox' && !empty($prop['value'])){
                        // var_dump($prop['value']);
                        // $prop['value']=peg_dateToStr($prop['value'],'d/m/Y');
                    }
                    if($prop['type']=='checkbox'){ 
                        if($prop['value']==1){
                            $prop['value']=$_SESSION['peg_dic_core_yes'];
                        }else if ($prop['value']===0 || $prop['value']==='0' ){
                            $prop['value']=$_SESSION['peg_dic_core_no'];
                        }
                    }
                }else{
                    $prop['value']='';
                }
               
                $label=$prop['name']; 
                if($prop['db_type']!='V' ||  in_array($prop['type'],array('textbox','numberbox','datebox','checkbox'))){
                    $label= "<a style='color:inherit' onclick=\"javascript:".$this->search_js_code($prop)."\">".$prop['name']."</a>";
                }
                $row=$this->print_html_row($label,$prop['value'],$i,$prop);
                if($prop['type']=='textarea'){ 
                    $tinyMCE.= $row;
                }else{
                    $html.= $row;
                }
                $i++;
            }
            if( !$this->get_is_browse_d0021_display() ){
                $top_html_content='';
                $onclick="\"javascript:".$this->open_search_screen_js_code()."\"";
                $cor012=pegasus_mysql_printfld('cor012','p01','nr01=?',array( pegasusGetGlobalVar($this->get_container_id().'_cor012_value')) );
                if(!empty(pegasusGetGlobalVar($this->get_container_id().'_cor012_value'))){
                    $top_html_content=str_replace(
                        array('##cor012##','##onclick##'),
                        array($cor012,$onclick), 
                        $_SESSION['peg_dic_peg002_cor012_value_label']);
                    if( peg002_where_array_cor012_diff( $this->get_container_id() ,$this->get_view_grid_name())   ){
                        $top_html_content.="<br>".str_replace('##onclick##',$onclick,$_SESSION['peg_dic_peg002_cor012_update_prop_msg']);
                    }
                }else{
                    if(  (!empty($this->get_view_grid_where_array()) || !empty($this->get_view_grid_order_array()) ) ){
                        $top_html_content.=str_replace('##onclick##',$onclick,$_SESSION['peg_dic_peg002_cor012_save_prop_msg']);
                    }
                }
                if(!empty($top_html_content)){
                    $html= "<div class='peg_alert_info_plain ' style='margin:5px; width: -moz-available;width: -webkit-fill-available;width: fill-available;'>$top_html_content</div>".$html;
                }
            }
            return $html.$tinyMCE;
        }

        private function search_js_code($prop){
            return "peg002_GridSearchBox(
                '',
               '".$this->get_view_d()."',
               '".$this->get_view_table()."',
                '".$prop['field']."',
                '".$prop['type']."', 
                '".strip_tags ($prop['name'])."', 
                '".$this->get_container_id()."',
                '".$this->get_view_module()."',
                '".$this->get_view_grid_name()."',
                '".$prop['db_type']."',
                '".$prop['field']."',
                '".$this->get_property_grid_container_id()."'

        );";
        }

        private function add_tab_js_code($table, $_d, $module, $valuefield, $value){

            if(!pegasus_mysql_table_exists($table)){
                return '';
            }

            // if($this->name != "grid_prop"){
            //     var_dump(33);
            //     return '';
            // }
            
            return 
            'peg002_editRec2Tab( 
                \''.$table.'\', 
                \''.$_d.'\', 
                \''.$module.'\', 
                0 , 
                \''.$valuefield.'\', 
                \''.$value.'\'
            )'; 
        
        }

        private function open_search_screen_js_code(){
            return "WebApp.view.grid.Grid.peg_search(pegGetCmp('".$this->get_container_id()."','".$this->get_view_grid_name()."')); ";
        }
        private function debug($msg){
            if(!$this->get_debug()){
                return;
            }
             // Create an exception
            $ex = new Exception();
      
            // Call getTrace() function
            $trace = $ex->getTrace();
      
            // Position 0 would be the line
            // that called this function
            $final_call = $trace[1];

            $last_caller='** '.$final_call['class'].'->'.$final_call['function'].'(l:'.$trace[0]['line'].')'." **\n";

            if($last_caller!=$this->debug_last_caller){
                $this->debug_last_caller=$last_caller;
                echo "\n".$last_caller;
            } 
            echo $msg."\n";
            
        }
        private function add_remfields(){
            // var_dump($this->p52['table_query']);
            if ($this->check_table_query_column('remdate')==false){
                return;
            }
            $this->field_data_array['remdate']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remdate'],
                'desc07'        =>  'datebox',
                'type'          =>  'datebox',
                'name'          =>  'remdate',
                'desc16'        =>  'D',
                'desc02'        =>  $_SESSION['peg_dic_core_remdate'],
                'desc17'        =>  10,
                'db_type'       =>  'D',
                'desc18'        =>  '0'
            );
            $this->field_data_array['remtime']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remtime'],
                'desc07'        =>  'timefield',
                'type'          =>  'timefield',
                'name'          =>  'remtime',
                'desc16'        =>  'C',
                'desc02'        =>  $_SESSION['peg_dic_core_remtime'],
                'desc17'        =>  10,
                'db_type'       =>  'C',
                'desc18'        =>  '0'
            );
            $this->field_data_array['remuser']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remuser'],
                'desc07'        =>  'textbox',
                'type'          =>  'textbox',
                'name'          =>  'remuser',
                'desc16'        =>  'C',
                'desc02'        =>  $_SESSION['peg_dic_core_remuser'],
                'desc17'        =>  15,
                'db_type'       =>  'C',
                'desc18'        =>  '0'
            );

            
            $this->field_data_array['remfdate']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remfdate'],
                'desc07'        =>  'datebox',
                'type'          =>  'datebox',
                'name'          =>  'remfdate',
                'desc16'        =>  'D',
                'desc02'        =>  $_SESSION['peg_dic_core_remfdate'],
                'desc17'        =>  10,
                'db_type'       =>  'D',
                'desc18'        =>  '0'
            );
            $this->field_data_array['remftime']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remftime'],
                'desc07'        =>  'timefield',
                'type'          =>  'timefield',
                'name'          =>  'remftime',
                'desc16'        =>  'C',
                'desc02'        =>  $_SESSION['peg_dic_core_remftime'],
                'desc17'        =>  10,
                'db_type'       =>  'C',
                'desc18'        =>  '0'
            );
            $this->field_data_array['remfuser']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remfuser'],
                'desc07'        =>  'textbox',
                'type'          =>  'textbox',
                'name'          =>  'remfuser',
                'desc16'        =>  'C',
                'desc02'        =>  $_SESSION['peg_dic_core_remfuser'],
                'desc17'        =>  15,
                'db_type'       =>  'C',
                'desc18'        =>  '0'
            );

            
            $this->field_data_array['remguc']=array(
                'browse_title'  =>  $_SESSION['peg_dic_core_remguc'],
                'desc07'        =>  'textbox',
                'type'          =>  'textbox',
                'name'          =>  'remguc',
                'desc16'        =>  'C',
                'desc02'        =>  $_SESSION['peg_dic_core_remguc'],
                'desc17'        =>  25,
                'db_type'       =>  'C',
                'desc18'        =>  '0'
            );
        }
    }
