<?php 

class Peg002_Menu{
    private static $checkPermission = true;
    
    public static function actionBrowse(
        $pcode,
        $peg_tab_id,
        $con_id,
        $title, 
        $icon,
        $iconCls,
        $view_d,
        $view_module,
        $view_table,
        $view_orderby,
        $view_groupby,
        $browse_edit = 1,
        $browse_copy = 1,
        $full_text_search = 1,
        $urlparams  ='',
        $peghandler = ''
    ){
        if(pegasus_lock_check_app()==1){
            $peghandler .= " pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "'); ";
        }
        if(self::$checkPermission && !empty($view_table)){
            if(!pegasus_profile_check_data_permission($view_table , 'SHOW' , $_SESSION['user_profile'])){
                return null;
            }
        }  
        $xtype = 'pegasusMenuItemBrowse';
        if(empty($pcode)){
            $xtype =  'pegasusToolBarBrowse';
        }
        
        
        return array(
            'xtype' => $xtype,
           'peg_tab_id' => $peg_tab_id,
           'con_id' => $con_id,
           'text' =>$title,
           'icon' => $icon,
           'iconCls' => $iconCls,
           'view_d' => $view_d,
           'view_module' => $view_module,
           'view_table' => $view_table,
           'view_orderby' => $view_orderby,
           'view_groupby' => $view_groupby,
           'browse_edit' => (int)$browse_edit,
           'browse_copy' => (int)$browse_copy,
            'enable_quick_find' => (int)$full_text_search,
           'urlparams' => $urlparams,
           'peg_handler' => $peghandler
        );
    }

    public static function actionShow_d(
        $pcode,
        $peg_tab_id,
        $con_id,
        $title,
        $icon = '',
        $iconCls = '',
        $view_d='',
        $view_module='',
        $view_table='', 
        $urlparams  ='',
        $peghandler = ''
        ){
            if(pegasus_lock_check_app()==1){
                $peghandler .= " pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "'); ";
            }
            if(self::$checkPermission && !empty($view_table)){
                if(!pegasus_profile_check_data_permission($view_table , 'SHOW' , $_SESSION['user_profile'])){
                    return null;
                }
            }
            
            $xtype = 'pegasusMenuItemShow_d';
            if(empty($pcode)){
                $xtype =  'pegasusToolBarShow_d';
            }
            
            return array(
                'xtype' => $xtype,
                'peg_tab_id' => $peg_tab_id,
                'con_id' => $con_id,
                'text' =>$title,
                'icon' => $icon,
                'iconCls' => $iconCls,
                'view_d' => $view_d,
                'view_module' => $view_module,
                'view_table' => $view_table, 
                'urlparams' => $urlparams,
                'peg_handler' => $peghandler
            );
    }
    
    public static function actionMethod(
        $pcode,
        $peg_tab_id,
        $con_id,
        $title,
        $icon,
        $iconCls,
        $meth ='',
        $peghandler =''
        ){
            if(pegasus_lock_check_app()==1){
                $peghandler .= " pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "'); ";
            }
            
            $xtype = 'pegasusMenuItemMethod';
            if(empty($pcode)){
                $xtype =  'pegasusToolBarMethod';
            }
            
            return array(
                'xtype' => $xtype,
                'peg_tab_id' => $peg_tab_id,
                'con_id' => $con_id,
                'text' =>$title,
                'icon' => $icon,
                'iconCls' => $iconCls,
                'meth' => $meth,
                'peg_handler' => $peghandler
            );
    }
    
    public static function actionMenuItem(
        $pcode,
        $title,
        $icon,
        $iconCls, 
        $peghandler ='',
        $cd=''
        ){
            if(empty($peghandler)){
                $peghandler .= " console.error('Empty Hander for menu Item with title=".$title." ') ";
            }
            
            if(pegasus_lock_check_app()==1){
                $peghandler .= " pegAlert('" .$_SESSION['peg_dic_core_lock_is_demo_alert']. "'); ";
            }
            
            $xtype = 'pegasusMenuItemAction';
            if(empty($pcode)){
                $xtype =  'pegasusToolBarAction';
            }
            $ret_arr=array(
                'xtype' => $xtype, 
                'text' =>$title,
                'icon' => $icon,
                'iconCls' => $iconCls, 
                'peg_handler' => $peghandler, 
                'pcode' => $pcode
            );
            if(!empty($cd)){
                $ret_arr['cd']=$cd;
            }
            return $ret_arr;
    }
}
?>