<?php


class viva_wallet_api {
    
    private $username;
    private $password;
    private $token;
    private $demo;
    private $enable_bypass = false;
    // private $bypass_url = "https://vivapayments00.pegcloud.io/test_api.php";
    private $token_url = "https://vivapayments00.pegcloud.io/viva_token.php";
    private $devices_url = "https://vivapayments00.pegcloud.io/viva_devices.php";
    private $sale_url = "https://vivapayments00.pegcloud.io/viva_sale.php";
    private $refund_url = "https://vivapayments00.pegcloud.io/viva_refund.php";
    private $session_url = "https://vivapayments00.pegcloud.io/viva_session.php";

    public function __construct($demo=false){
        $this->set_demo($demo);      
        // $this->set_username($username);
        // $this->set_password($password);   
    }

    private function set_username($username=''){
        $this->username = $username;
    }

    private function set_password($password=''){
        $this->password = $password;
    }

    private function set_demo($demo=true){
        $this->demo = $demo;
    }

    private function set_token($token=''){
        $this->token = $token;
    }

    private function get_host_url_prefix(){

        $url  = "https://";
        $url .= ($this->demo==true) ? "demo-" : "";
        return $url;
    }
    private function get_host_url($url, $type = '', $sid = ''){
        $demo = ($this->demo==true) ? "?demo=1" : "";
        $session = '';
        // $bypass_url = $this->bypass_url . $url . $demo;

        if($this->enable_bypass){
            switch($type){
                case 'TOKEN':
                    $bypass_url = $this->token_url;
                    break;
                case 'DEVICES':
                    $bypass_url = $this->devices_url;
                    break;
                case 'SALE':
                    $bypass_url = $this->sale_url;
                    break;
                case 'REFUND':
                    $bypass_url = $this->refund_url;
                    break;
                case 'SESSION':
                    $bypass_url = $this->session_url;
                    $session = "&sid=".$sid;
                    break;
            }

            return $bypass_url .$demo.$session; 
        }
        return $url;
    }


    private function get_headers(){
        $headers = array(
            'Authorization: Bearer '.$this->token,
        );

        return $headers;
    }

    private function get_pos00_01($pos00_01_nr01=0, $pos00_04_nr01=0){

        $values = array();
        if($pos00_01_nr01>0){
            $query  = 'select pos00_01.* from pos00_01 where pos00_01.nr01=:pos00_01_nr01;';
            $values = array('pos00_01_nr01'=>$pos00_01_nr01);
        }else{
            $query  = 'select pos00_01.* ';
            $query .= 'from pos00_01 ';
            $query .= 'join pos00_04 on pos00_04.pos00_01=pos00_01.nr01 ';
            $query .= 'where pos00_04.nr01=:pos00_04_nr01 ';
            $values = array('pos00_04_nr01'=>$pos00_04_nr01);    
        }

        pegasus_mysql_use($query, $data, $values);

        return $data;
    }

    private function get_pos00_04($pos00_04_nr01=0){

        $values = array();
        $query  = 'select * from pos00_04 where pos00_04.nr01=:pos00_04_nr01;';
        $values = array('pos00_04_nr01'=>$pos00_04_nr01);

        pegasus_mysql_use($query, $data, $values);

        return $data;
    }
    

    private function obtain_token($second_try=false){
        $response = array('ok'=>1, 'msg'=>'', 'api'=>null);

        $url = $this->get_host_url_prefix()."accounts.vivapayments.com/connect/token";

        $headers = array(
            'Content-Type: application/x-www-form-urlencoded'
        );
        
        $curl_options = array(
            CURLOPT_USERNAME => $this->username,
            CURLOPT_PASSWORD => $this->password
        );

        $payload = array(
			'grant_type' => 'client_credentials'
		);

        try {
            $curl_result = pegasus_curl_request_post($this->get_host_url($url, 'TOKEN'), http_build_query($payload), false, $headers, $curl_options, true);
            $obtain_token = json_decode($curl_result['response'], true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("viva_wallet_api:obtain_token:curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:obtain_token:curl_exception:".$response['code'], $response['msg'], $payload, $response, true);
            return $response;
        }

        //Αν έχει γίνει blacklist η IP δοκίμασε να κάνεις bypass
        if($curl_result['http_code'] == 403 && $second_try == false){
            pos00_add_to_log("viva_wallet_api:obtain_token:fail:".$curl_result['http_code'].":will_retry", $payload, $response, $url);
            if(!$this->demo){
                pos00_add_external_log($url, "viva_wallet_api:obtain_token:fail:".$curl_result['http_code'].":will_retry", '403', $payload, $curl_result, true);
            }
            $this->enable_bypass = true;
            return $this->obtain_token(true);
        }
        $response['api']['http_code'] = $curl_result['http_code'];
        $response['api']['response']  = $obtain_token;

        if(!in_array($curl_result['http_code'], array("200"))){
            $response['ok']  = 0;
            $response['msg'] = $_SESSION['peg_dic_pos00_viva_invalid_request']; 
        }

        if(isset($obtain_token['error']) && !empty($obtain_token['error'])){
            $response['ok']  = 0; 
            $response['msg'] = $_SESSION['peg_dic_pos00_viva_'.$obtain_token['error']];
        }

        if(isset($obtain_token['message']) && !empty($obtain_token['message'])){
            $response['ok']  = 0; 
            $response['msg'] = $obtain_token['message'];
        }



        $response['curl_result'] = $curl_result;
        if($response['ok']==0){           
            pos00_add_to_log("viva_wallet_api:obtain_token:fail:".$curl_result['http_code'], $payload, $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:obtain_token:fail:".$curl_result['http_code'], $response['msg'], $payload, $response, true);
            return $response;
        }


        $this->set_token($obtain_token['access_token']);
        pos00_add_to_log("viva_wallet_api:obtain_token:success", $payload, $response, $url);
        pos00_add_external_log($url, "viva_wallet_api:obtain_token:success", "Obtained Token", $payload, $response, false);
        return $response;
    }

    public function search_pos_devices($pos00_01_nr01=0, $status_id=1){
        $response = array('ok'=>1, 'msg'=>'', 'api'=>null);

        $pos00_01 = $this->get_pos00_01($pos00_01_nr01);
        $this->set_demo($pos00_01['p04']);        
        $this->set_username($pos00_01['viva_user']);
        $this->set_password($pos00_01['viva_pass']);   

        $obtain_token = $this->obtain_token();
        
        if($obtain_token['ok']==0){
            return $obtain_token;
        }       
        

        $url = $this->get_host_url_prefix()."api.vivapayments.com/ecr/v1/devices:search";

        $headers   = $this->get_headers();
        $headers[] = 'Content-Type: application/json';

        $payload = array(
			'statusId' => $status_id
		);

        try {
            $curl_result = pegasus_curl_request_post($this->get_host_url($url, 'DEVICES'), json_encode($payload), false, $headers, array(), true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage(); 
            $response['code'] = $e->getCode();

            pos00_add_to_log("viva_wallet_api:search_pos_devices:curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:search_pos_devices:curl_exception:".$response['code'], $response['msg'], $payload, $response, true);
            return $response;
        }
        
        $pos_devices = json_decode($curl_result['response'], true);
        
        $response['api']['action']    = "/v1/devices:search";
        $response['api']['http_code'] = $curl_result['http_code'];
        $response['api']['request']   = $payload;
        $response['api']['response']  = $pos_devices;

        $log_status = "success";
        if(!in_array($curl_result['http_code'], array("200"))){
            $response['ok'] = 0; 
            $log_status     = "fail";
        }

        $response['msg'] = $_SESSION['peg_dic_pos00_viva_error_code_'.$curl_result['http_code']];

        if(isset($pos_devices['message']) && !empty($pos_devices['message']) && empty($response['msg'])){
            $response['msg'] = $pos_devices['message'];
        }

        if(isset($pos_devices['detail']) && empty($response['msg'])){
            if(is_array($pos_devices['detail'])){
                foreach ($pos_devices['detail'] as $detail) {
                    $loc = implode(' ', $detail['loc']);
                    $response['msg'] .= "<br>" . $loc . ": " . $detail['msg'];
                }
            }else{
                $response['msg'] = $pos_devices['detail'];
            }
        }

        if(isset($pos_devices[0]['statusId'])){
            $response['msg'] = "Βρέθηκαν " . count($pos_devices) . " Viva POS";
        }

        pos00_add_to_log("viva_wallet_api:search_pos_devices:".$log_status.":".$curl_result['http_code'], $payload, $response, $url);
        pos00_add_external_log($url, "viva_wallet_api:search_pos_devices:".$log_status.":".$curl_result['http_code'], $response['msg'], $payload, $response, !$response['ok']);
        
        return $response;
    }

    public function initiate_sale($pos00_04_nr01=0, $amount=0){
        $response = array('ok'=>1, 'msg'=>'', 'api'=>null);

        $pos00_01 = $this->get_pos00_01(0, $pos00_04_nr01);
        $this->set_demo($pos00_01['p04']);        
        $this->set_username($pos00_01['viva_user']);
        $this->set_password($pos00_01['viva_pass']); 

        $obtain_token = $this->obtain_token();
        if($obtain_token['ok']==0){
            return $obtain_token;
        } 
        
        
        $url = $this->get_host_url_prefix()."api.vivapayments.com/ecr/v1/transactions:sale";
        
        $pos00_04 = $this->get_pos00_04($pos00_04_nr01);

        if(empty($pos00_01['viva_tid'])){
            $response['ok']  = 0; 
            $response['msg'] = $_SESSION['peg_dic_pos00_viva_invalid_terminal_id'];
            pos00_add_external_log($url, "viva_wallet_api:initiate_sale:fail", $response['msg'], array(), $response, true);
            return $response;
        }
        

        $headers   = $this->get_headers();
        $headers[] = 'Content-Type: application/json';


        // Round διότι η PHP έχει κάποια θέματα με το floating point precision με αποτέλεσμα σε μερικές περιπτώσεις
        // στο json_encode αντί για 912 έφερνε 911.999999
        $amount  = $amount*100;
        $amount = round($amount);

        $tip_amount = 0;

        $pos00_04_type = 1; // Sale ----> Στη Viva όλη η μέθοδος εδώ αφορά sale, να προσέξουμε όταν φτιάξουμε τα refund/void να ενημερώνουμε και εκεί

        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);

        $tidnsp            = $pos00_01['viva_tid'];
        $pegasus_reference = $pos00_04['nr01'] . date("YmdHis");
        $txnid             = $pegasus_reference;
        pegasus_mysql_update("pos00_04", array("p03", "txnid", "type", "descr"), array($pegasus_reference, $txnid, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));

        $instalments = "0";
        if($pos00_04['instalments']>1){
            $instalments = $pos00_04['instalments'];
        }
        
        $payload = array(
			'sessionId'         => $pegasus_reference,
            'terminalId'        => $tidnsp,
            'cashRegisterId'    => "00", //Σε Λεπτά του EUR
            'amount'            => $amount,
            'currencyCode'      => '978', //EUR
            'merchantReference' => $pegasus_reference,
            'preauth'           => false,
            'maxInstalments'    => $instalments,
            'tipAmount'         => $tip_amount
		);

        
        $p_sign = '';
        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19 where nr01=?", $t19, array($pos00_04['t19']));  
            $provider_id = ($this->demo==true) ? "116" : "116";
            $p_sign      = $t19['p_sign']; 

            $payload["aadeProviderId"]            = $provider_id;
            $payload["aadeProviderSignatureData"] = $t19['p_sign_s'];
            $payload["aadeProviderSignature"]     = $t19['p_sign'];
            
            if($pos00_04['profortosi'] == 1){
                $payload["aadePreloaded"]         = 1;
                $payload["aadePreloadedDuration"] = 24;
            }
        }



        try {
            $curl_result = pegasus_curl_request_post($this->get_host_url($url, 'SALE'), json_encode($payload), false, $headers, array(), true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("viva_wallet_api:initiate_sale:curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:initiate_sale:curl_exception:".$response['code'], $response['msg'], $payload, $response, true, $p_sign);
            return $response;
        }
        
        $transaction = (json_decode($curl_result['response'], true)) ? json_decode($curl_result['response'], true) : $curl_result['response'];

        $response['data']['action']    = "/v1/transactions:sale";
        $response['data']['http_code'] = $curl_result['http_code'];
        $response['data']['request']   = $payload;
        $response['data']['response']  = $transaction;

        $log_status = "success";
        if(!in_array($curl_result['http_code'], array("200"))){
            $response['ok'] = 0; 
            $log_status     = "fail";
        }

        $response['msg'] = $_SESSION['peg_dic_pos00_viva_error_code_'.$curl_result['http_code']];

        if(isset($transaction['message']) && !empty($transaction['message']) && empty($response['msg'])){
            $response['msg'] = $transaction['message'];
        }

        if(isset($transaction['detail']) && empty($response['msg'])){
            if(is_array($transaction['detail'])){
                foreach ($transaction['detail'] as $detail) {
                    $loc = implode(' ', $detail['loc']);
                    $response['msg'] .= "<br>" . $loc . ": " . $detail['msg'];
                }
            }else{
                $response['msg'] = $transaction['detail'];
            }
        }

        $log_msg = (!empty($response['msg'])) ? $response['msg'] : "Viva Sale";
        pos00_add_to_log('viva-initiate-sale', $payload, $response['data'], $url);
        pos00_add_external_log($url, "viva_wallet_api:initiate_sale:".$log_status.":".$curl_result['http_code'], $log_msg, $payload, $response['data'], !$response['ok'], $p_sign);

        return $response;
    }


    public function initiate_refund($pos00_04_nr01=0, $amount=0){
        $response = array('ok'=>1, 'msg'=>'', 'api'=>null);

        $pos00_01 = $this->get_pos00_01(0, $pos00_04_nr01);
        $this->set_demo($pos00_01['p04']);        
        $this->set_username($pos00_01['viva_user']);
        $this->set_password($pos00_01['viva_pass']); 

        $obtain_token = $this->obtain_token();
        if($obtain_token['ok']==0){
            return $obtain_token;
        } 
        
        

        $url = $this->get_host_url_prefix()."api.vivapayments.com/ecr/v1/transactions:refund";
        
        $pos00_04 = $this->get_pos00_04($pos00_04_nr01);
        
        if(empty($pos00_01['viva_tid'])){
            $response['ok']  = 0; 
            $response['msg'] = $_SESSION['peg_dic_pos00_viva_invalid_terminal_id'];
            pos00_add_external_log($url, "viva_wallet_api:initiate_refund:fail", $response['msg'], array(), $response, true);
            return $response;
        }

        $headers   = $this->get_headers();
        $headers[] = 'Content-Type: application/json';


        // Round διότι η PHP έχει κάποια θέματα με το floating point precision με αποτέλεσμα σε μερικές περιπτώσεις
        // στο json_encode αντί για 912 έφερνε 911.999999
        $amount  = $amount*100;
        $amount = round($amount);

        $pos00_04_type     = 2;
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $tidnsp            = $pos00_01['viva_tid'];
        $pegasus_reference = $pos00_04['nr01'] . date("YmdHis");
        $txnid             = $pegasus_reference;
        pegasus_mysql_update("pos00_04", array("p03", "txnid", "type", "descr"), array($pegasus_reference, $txnid, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
        
        
        $payload = array(
			'sessionId'         => $pegasus_reference,
            'terminalId'        => $tidnsp,
            'cashRegisterId'    => "00", //Σε Λεπτά του EUR
			'parentSessionId'   => $pos00_04['txnidinit'],
            'amount'            => $amount,
            'currencyCode'      => '978', //EUR
            'merchantReference' => $pegasus_reference
		);

        
        $p_sign = '';
        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19 where nr01=?", $t19, array($pos00_04['t19']));  
            $provider_id = ($this->demo==true) ? "116" : "116";
            $p_sign      = $t19['p_sign']; 

            $payload["aadeProviderId"]            = $provider_id;
            $payload["aadeProviderSignatureData"] = $t19['p_sign_s'];
            $payload["aadeProviderSignature"]     = $t19['p_sign'];
        }




        try {
            $curl_result = pegasus_curl_request_post($this->get_host_url($url, 'REFUND'), json_encode($payload), false, $headers, array(), true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("viva_wallet_api:initiate_refund:curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:initiate_refund:curl_exception:".$response['code'], $response['msg'], $payload, $response, true, $p_sign);
            return $response;
        }


        
        $transaction = (json_decode($curl_result['response'], true)) ? json_decode($curl_result['response'], true) : $curl_result['response'];

        $response['data']['action']    = "/v1/transactions:refund";
        $response['data']['http_code'] = $curl_result['http_code'];
        $response['data']['request']   = $payload;
        $response['data']['response']  = $transaction;

        
        $log_status = "success";
        if(!in_array($curl_result['http_code'], array("200"))){
            $response['ok'] = 0; 
            $log_status     = "fail";
        }

        $response['msg'] = $_SESSION['peg_dic_pos00_viva_error_code_'.$curl_result['http_code']];

        if(isset($transaction['message']) && !empty($transaction['message']) && empty($response['msg'])){
            $response['msg'] = $transaction['message'];
        }

        if(isset($transaction['detail']) && empty($response['msg'])){
            if(is_array($transaction['detail'])){
                foreach ($transaction['detail'] as $detail) {
                    $loc = implode(' ', $detail['loc']);
                    $response['msg'] .= "<br>" . $loc . ": " . $detail['msg'];
                }
            }else{
                $response['msg'] = $transaction['detail'];
            }
        }

        $log_msg = (!empty($response['msg'])) ? $response['msg'] : "Viva Refund";
        pos00_add_to_log('viva-initiate-refund', $payload, $response['data'], $url);
        pos00_add_external_log($url, "viva_wallet_api:initiate_refund:".$log_status.":".$curl_result['http_code'], $log_msg, $payload, $response['data'], !$response['ok'], $p_sign);

        return $response;
    }

    public function retrieve_session_by_id($pos00_04_nr01=0){
        $response = array('ok'=>1, 'msg'=>'', 'data'=>null);

        $pos00_01 = $this->get_pos00_01(0, $pos00_04_nr01);
        $this->set_demo($pos00_01['p04']);        
        $this->set_username($pos00_01['viva_user']);
        $this->set_password($pos00_01['viva_pass']); 

        
        $obtain_token = $this->obtain_token();
        if($obtain_token['ok']==0){
            return $obtain_token;
        } 

        $pos00_04   = $this->get_pos00_04($pos00_04_nr01); 
        $session_id = $pos00_04['p03'];
        $p_sign     = '';
        if(!empty($pos00_04['t19'])) {
            $p_sign = pegasus_mysql_printfld('t19', 'p_sign', 'nr01=:nr01', array('nr01'=>$pos00_04['t19'])); 
        }
        
        if(empty($session_id)){
            $response['ok']  = 0; 
            $response['msg'] = $_SESSION['peg_dic_pos00_viva_invalid_session_id'];
            pos00_add_external_log('', "viva_wallet_api:retrieve_session_by_id:fail", $response['msg'], array(), $response, true, $p_sign);
            return $response;
        }
        
        $url = $this->get_host_url_prefix()."api.vivapayments.com/ecr/v1/sessions/".$session_id;

        $headers   = $this->get_headers();
        $headers[] = 'Content-Type: application/json';

        try {
            $curl_result = pegasus_curl_request($this->get_host_url($url, 'SESSION', $session_id), false, $headers, array(), true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("viva_wallet_api:retrieve_session_by_id:curl_exception:".$response['code'], array(), $response, $url);
            pos00_add_external_log($url, "viva_wallet_api:retrieve_session_by_id:curl_exception:".$response['code'], $response['msg'], array(), $response, true, $p_sign);
            return $response;
        }  
        
        $transaction = json_decode($curl_result['response'], true);
        $response['data']['action']    = "/v1/sessions";
        $response['data']['http_code'] = $curl_result['http_code'];
        $response['data']['request']   = $session_id;
        $response['data']['response']  = $transaction;


        //Response Messages
        if(isset($transaction['message']) && !empty($transaction['message'])){
            $response['msg'] = $transaction['message'];
        }

        if(isset($transaction['detail'])){
            if(is_array($transaction['detail'])){
                foreach ($transaction['detail'] as $detail) {
                    $loc = implode(' ', $detail['loc']);
                    $response['msg'] .= (!empty($response['msg'])) ? "<br>" : "";
                    $response['msg'] .= $loc . ": " . $detail['msg'];
                }
            }else{
                $response['msg'] = $transaction['detail'];
            }
        }


        $log_status = "success";
        if(!in_array($curl_result['http_code'], array("200", "202"))){
            $response['ok'] = 0; 
            $log_status     = "fail";
        }elseif($curl_result['http_code']=="200" && $transaction['success']==true){
            $response['msg'] = $_SESSION['peg_dic_pos00_trans_success'];
        }
        
        switch ($transaction['transactionTypeId']) {
            case '4':
                $type = 'refund';
                break;
            case '5':
                $type = 'sale';
                break;
            case '7':
                $type = 'reversal';
                break;
        }

        pos00_add_to_log('viva-retrieve-session-by-id-'.$type, array(), $response['data'], $url);        
        pos00_add_external_log($url, "viva_wallet_api:retrieve_session_by_id:".$type.":".$log_status.":".$curl_result['http_code'], $response['msg'], array(), $response['data'], !$response['ok'], $p_sign);



        //Αν ΔΕΝ εχει ολοκληρωθεί η Πληρωμή εκτελω pos00_complete_payment (success/fail)
        $pos00_04_check = pos00_check_pos_transaction_is_completed($pos00_04['nr01'], false);

        if($pos00_04_check===false){ 

            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01, 
                $transaction['referenceNumber'],
                (abs($transaction['amount'])-$transaction["tipAmount"])/100,
                $transaction["tipAmount"]/100,
                $transaction["aadeTransactionId"],
                $transaction["sessionId"]
            );
    
            if($response['ok']==1 && $response['data']['http_code']=="200"){
                if($transaction['success']==true){
                    $response['complete'] = $pos_complete->on_successful_payment();
                }else{
                    $response['complete'] = $pos_complete->on_failed_payment($response['msg']);    
                } 
                $response['msg'] = $response['complete']['msg'];
                   
            }elseif($response['ok']==0){
                $response['complete'] = $pos_complete->on_failed_payment($response['msg']);   
                $response['msg']      = $response['complete']['msg'];    
            }

        }

        return $response;
    }

}

class pos00_initiate_payment{
    public function __construct()
    {
        
    }

    public function initiate(
        $amount,
        $pos00_01_nr01, 
        $t02p01, 
        $a55_nr01 = 0,      //Στην περίπτωση παραστατικού
        $pos00_02_nr01 = 0, //Στην περίπτωση παραστατικού
        $profortosi = 0,    //Στην περίπτωση του παραστατικού, προς το παρόν μόνο στην οθόνη του account00
        $txnidinit = 0,     //Το initial transaction id, π.χ. το transaction id που κάνουμε refund. Προς το παρόν ελεύθερο text πεδίο 
        $instalments = 0,   // Αριθμός δόσεων
        $mailphone = 0,     // Αν αφορά μέιλ/τηλεφωνική παραγγελία.
        $pos00_04_init = 0, // MK αρχικής Κίνησης POS        
        $hota04_nr01 = 0,   // MK Κράτησης
        $tran01_nr01 = 0,   // MK Φορτωτικής
        $a55_nr01s = '',    // MK Παραστατικών για estiasi
        $este03_nr01s = '', // Είδη για Πληρωμή για estiasi
        $a14 = 0,
        $este01_nr01 = 0
    ){
        $result = array(
            "ok"  => 0, 
            "msg" => "", 
            "pos00_04_nr01" => 0
        ); 

        pegasus_mysql_use("SELECT * FROM pos00_01 WHERE nr01 = ?", $pos00_01, array($pos00_01_nr01));
        
        if($pos00_01["req_sign"]){
            $tidnsp = $pos00_01["tidnsp"];
            /**
             * Ε: 10001355 Δ: 10169584
             * Αφαίρεση ελέγχου καταχώρισης tidnsp από το webApp. Ο έλεγχος μετατέθηκε στο service
             * 
             */
            // echo $tidnsp;
            // if(empty($tidnsp)){
            //     return array(
            //         'ok'	=> 0,
            //         'msg'	=> $_SESSION['peg_dic_account00_tidnsp_missing']
            //     );
            // }

            $tbl      = '';
            $tbl_nr01 = 0;
            if($tran01_nr01>0){
                $tbl      = 'tran01';
                $tbl_nr01 = $tran01_nr01;
            }elseif($a55_nr01>0){
                $tbl      = 'a55';
                $tbl_nr01 = $a55_nr01;
            }elseif($este01_nr01>0){ // Mπαινει μονο στα πολλαπλα παραστατικα , αν ειναι ενα παραστατικο και σοτ εστιαση θα περασει $a55_nr01;
                $tbl      = 'este01';// kai to anoigma
                $tbl_nr01 = $este01_nr01;
            }
            
            $pos_protocol   = pos00_device_properties::get_pos_protocol($pos00_01["p02"]);      
            $signature      = new account00_create_signature();
            //μέσα στο στην create_t19 να μπει το παραπάνω
            $response       = $signature->create_t19($amount, $tidnsp, $tbl, $tbl_nr01, $pos_protocol);

            if($response["ok"] == 0){
                return $response;
            }
            
            $t19_nr01 = $response["t19_nr01"];
        }

        $descr = pos00_device_properties::get_pos_type_description($pos00_01["p02"]);
        
        $pos00_04_nr01 = pegasus_mysql_newrec('pos00_04'); 


        //code_review este03_nr01s ,  a55_nr01s  
        $pos00_04_data = array(
            "pos00_02"      => $pos00_02_nr01,
            "pos00_01"      => $pos00_01_nr01,
            "a55"           => $a55_nr01,
            "t02p01"        => $t02p01, 
            "t19"           => $t19_nr01, 
            "profortosi"    => $profortosi,
            "txnidinit"     => $txnidinit,
            "instalments"   => $instalments,
            "mailphone"     => $mailphone,
            "amount"        => $amount,
            "descr"         => $descr,
            "pos00_04_init" => $pos00_04_init,
            "hota04"        => $hota04_nr01,
            "tran01"        => $tran01_nr01,
            "a55_nr01s"     => $a55_nr01s,
            "este03_nr01s"  => $este03_nr01s,
            "a14"           => $a14
        );
        if($tbl == 'este01'){
            $pos00_04_data['este01'] = $tbl_nr01;
        }
        pos00_set_pos_transaction($pos00_04_nr01, $pos00_04_data); 

        return array(
            "ok"  => 1, 
            "msg" => "Επιτυχής αρχικοποίηση πληρωμής", 
            "pos00_04_nr01" => $pos00_04_nr01
        ); 
    }

    
}
class pos00_complete_payment{
    
    private $pos00_04;
        private $reference_number; //Αυτό είναι το referencenumber της πληρωμής. Αυτός είναι και ο κωδικός που χρησιμοποιούμε αν σε δεύτερο χρόνο μπορούμε να πάρουμε στοιχεία για την πληρωμή
        private $amount; //Το ποσό που τελικά πληρώθηκε από το POS
        private $tip_amount; //Το tip που τελικά πληρώθηκε από το POS
        private $transaction_id; //Η μοναδική ταυτότητα πληρωμής από το POS. Είναι ένα string χωρισμένο με ερωτηματικά.
        private $txnid; // Το transaction id του POS για την συναλλαγή. *ΔΕΝ ΕΙΝΑΙ ΤΟ ΙΔΙΟ ΜΕ ΤΟ $transaction_id


    public function __construct(
        $pos00_04_nr01, 
        $reference_number,
        $amount = 0, 
        $tip_amount = 0, 
        $transaction_id = "",
        $txnid = ""
        ){

        pegasus_mysql_use("SELECT * FROM pos00_04 WHERE nr01 = ?", $this->pos00_04, array($pos00_04_nr01));
        if(empty( $this->pos00_04["nr01"] )){
            throw new Exception("pos00_04 empty", 1);
        }

        $this->reference_number = $reference_number;
        $this->amount = $amount;
        $this->tip_amount = $tip_amount;
        $this->transaction_id = $transaction_id;
        $this->txnid = $txnid;

    }

    public function on_successful_payment(){
        
        pegasus_mysql_update('pos00_04', array('p01', 'txnid'), array($this->reference_number, $this->txnid), "nr01 = ? ", 0, 1, 1, array($this->pos00_04["nr01"]));


        if($this->pos00_04["t19"] > 0){
            $post_pos_payment = new account00_post_pos_payment_actions(
                $this->pos00_04["nr01"], 
                $this->amount, 
                $this->tip_amount, 
                $this->transaction_id, 
                "", 
                1
            );
            return $post_pos_payment->exec();
        }
        else{
            //TO TEST
            pegasus_mysql_use("SELECT * FROM pos00_02 WHERE nr01 = ?", $pos00_02, array($this->pos00_04["pos00_02"]));
            pegasus_mysql_use("SELECT * FROM pos00_01 WHERE nr01 = ?", $pos00_01, array($pos00_02["pos00_01"]));
            $t01_data = array(
                "p02"  => date("Y-m-d"),
                "p02t" => date("H:i:s"),
                "p302" => $this->pos00_04["a55"], //TODO: Θα πρέπει να σετάρεται σωστά στην αρχικοποίηση της πληρωμής
                "p07"  => $this->pos00_04["t02p01"],  //TODO: Θα πρέπει να σετάρεται σωστά στην αρχικοποίηση της πληρωμής
                "vp03" => $this->amount,
                "a14_nr01" => $pos00_02["a14"], 
                "p05" => str_replace('##pos00_01_p01##', $pos00_01['p01'], $_SESSION['peg_dic_pos00_pos_transaction'])
            );
            pegasus_mysql_use("select * from a55 where nr01 = ?", $a55, array($this->pos00_04["a55"]));
            $t01_nr01 = pos00_set_account_transaction(0,  $t01_data, "a55", $a55);
            pos00_set_pos_transaction($this->pos00_04["nr01"], array("t01" => $t01_nr01));

        

            //Δοκιμαστική επιστροφή μηνυματος
            return array(
				"ok"  => 1,
				"msg" => "Ολοκληρώθηκε η πληρωμή"
			);
        }
    }

    public function on_failed_payment($cancel_reason){

        pegasus_mysql_update('pos00_04', array('p01', 'p02'), array($this->reference_number, 1), "nr01 = ? ", 0, 1, 1, array($this->pos00_04["nr01"]));

        if($this->pos00_04["t19"] > 0){
            $post_pos_payment = new account00_post_pos_payment_actions(
                $this->pos00_04["nr01"], 
                $this->amount, 
                $this->tip_amount, 
                $this->transaction_id, 
                $cancel_reason,
                0
         );
         return $post_pos_payment->exec();
        }
        else{
            //TODO
        }
    }
}


class pos00_device_properties {

    public function __construct(){

    }

    /**
     * Επιτρέφει στατικές ιδιότητες του εκάστοτε πρωτοκόλλου.
     * Σε περίπτωση που ο τύπος που δόθηκε δεν υποστηρίζεται (π.χ. παλιά μέθοδος POS), επιστρέφει όλες τις ιδιότητες με false εκτός του "no_req_sign"
     * 
     * Ενημερώνεται αμφίδρομα με βάση το παρακάτω:
     * https://docs.google.com/spreadsheets/d/16f_u9CnyuLq2NbFSy_3JD6wv95FNxurSGeUGifKADe0/edit?gid=0#gid=0 
     * 
     * @param int $type (pos00_01.p02)
     * @return array
     */
    
    
    static function get_properties($type) {
        switch ($type) {
            case 4: //* VIVA
                $data = array(
                    "refund"                => false,
                    "void"                  => true,
                    "preload"               => true,
                    "receive_one"           => true,
                    "sync"                  => false,
                    "instalments"           => true,        
                    "instalments_amount"    => false,        //Δεν έχει χρήση 
                    "moto"                  => false,       //disable temporarily **** Mail / phone order ****
                    "req_sign"              => true,
                    "no_req_sign"           => true,
                    "tid_readonly"          => true,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
                break;
            case 5: //* Mellon v2
                $data = array(
                    "refund"                => true,
                    "void"                  => false,
                    "preload"               => true,
                    "receive_one"           => true,
                    "sync"                  => false,
                    "instalments"           => false,
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => true,
                    "req_sign"              => true,
                    "no_req_sign"           => false,
                    "tid_readonly"          => false,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
                break;
            case 6: //* EDPS
                $data = array(
                    "refund"                => true,
                    "void"                  => true,
                    "preload"               => true,
                    "receive_one"           => true,
                    "sync"                  => true,
                    "instalments"           => false,
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => false,
                    "req_sign"              => true,
                    "no_req_sign"           => false,
                    "tid_readonly"          => true,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
                break;
            case 7: //* Cardlink v2
                $data = array(
                    "refund"                => true,
                    "void"                  => true,
                    "preload"               => true,
                    "receive_one"           => true,
                    "sync"                  => true,
                    "instalments"           => false, //Δεν δέχεται δόσεις - μόνο γυρνάει
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => false,
                    "req_sign"              => true,
                    "no_req_sign"           => true,
                    "tid_readonly"          => false,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
                break;
            case 8: //* Euronet Web ECR 
                $data = array(
                    "refund"                => true,
                    "void"                  => false,
                    "preload"               => true,
                    "receive_one"           => true,
                    "sync"                  => false,
                    "instalments"           => false,
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => false,
                    "req_sign"              => true,
                    "no_req_sign"           => false,
                    "tid_readonly"          => true,
                    "preauth"               => false,
                    "complete_preauth"      => false    // E: 10001362 Δ: 10176565
                );
                break;
            case 9: //* Neosoft 
                $data = array(
                    "refund"                => true,
                    "void"                  => false, //TODO Να δω αν παίρνει υπογραφή στο void. Λογικά ναι --- Δεν παίρνει υπογραφή, false
                    "preload"               => true, //TODO Υποστηρίζει αλλά δεν έχουμε ακόμα info
                    "receive_one"           => true, // Μέσω του endpoint
                    "sync"                  => false, // το endpoint είναι για μια-μια
                    "instalments"           => false, // πάνω στο τερματικό
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => false, // Δεν υποστηρίζει
                    "req_sign"              => true,
                    "no_req_sign"           => false,
                    "tid_readonly"          => false, //TODO Να το ρωτήσω, αλλά λογικά το δίνουν αυτοί, δεν έχουν endpoint --- Είναι το TID του παρόχου (acquirer). Αν ο έμπορος δεν το γνωρίζει, το κοινοποιούμε.
                    "preauth"               => false, //TODO Υποστηρίζει βάσει documentation, το αφήνω ως todo
                    "complete_preauth"      => false  //TODO Υποστηρίζει βάσει documentation, το αφήνω ως todo
                );
                break;
            case 10: //* INSS 
                $data = array(
                    "refund"                => false,			
                    "void"                  => true,
                    "preload"               => false, //TODO Υποστηρίζει αλλά δεν έχουμε ακόμα info
                    "receive_one"           => true, // Μέσω του endpoint
                    "sync"                  => true, // το endpoint είναι για μια-μια
                    "instalments"           => false,
                    "instalments_amount"    => false,
                    "moto"                  => false, // Δεν υποστηρίζει
                    "req_sign"              => true,
                    "no_req_sign"           => false,
                    "tid_readonly"          => false,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
                break;
            default: 
                $data = array(
                    "refund"                => false,
                    "void"                  => false,
                    "preload"               => false,
                    "receive_one"           => false,
                    "sync"                  => false,
                    "instalments"           => false,
                    "instalments_amount"    => false,       // Δεν έχει χρήση 
                    "moto"                  => false,
                    "req_sign"              => false,
                    "no_req_sign"           => true,
                    "tid_readonly"          => false,
                    "preauth"               => false,
                    "complete_preauth"      => false
                );
        }
        return $data;
    }

    /**
     * Επιτρέφει το pos protocol για τον κάθε Τύπο Συσκευής που χρειαζεται για τη δημιουργία της Υπογαρφής
     * 0: Mellon Web ECR 
	 * 1: ΕDPS Json Protocol
	 * 2: Viva Wallet
	 * 3: Cardlink (6.3)
     * 4: Euronet Web ECR
     * 
     * @param int $type (pos00_01.p02)
     * @return int
     */
    static function get_pos_protocol($type) {

        switch ($type) {
            case 5: //* Mellon v2
                $pos_protocol = 0;
                break;
            case 6: //* EDPS
                $pos_protocol = 1;
                break;
            case 4: //* VIVA
                $pos_protocol = 2;
                break;
            case 7: //* Cardlink v2
                $pos_protocol = 3;
                break;
            case 8: // Euronet Web ECR
                $pos_protocol = 4;
                break;
            case 9: // Neosoft
                $pos_protocol = 5;
                break;
            case 10: // INSS
                $pos_protocol = 6;
                break;
            default: 
                $pos_protocol = 999;
        }

        return $pos_protocol;
    }

    static function get_pos_type_description($type) {
        switch ($type) {
            case 5: //* Mellon v2
                $pos_description = "Mellon Web ECR | Συμβατή με Α1155";
                break;
            case 6: //* EDPS
                $pos_description = "ΕDPS Json Protocol | Συμβατή με Α1155";
                break;
            case 4: //* VIVA
                $pos_description = "Viva Wallet | Συμβατή με Α1155";
                break;
            case 7: //* Cardlink v2
                $pos_description = "Cardlink (6.3) | Συμβατή με Α1155";
                break;
            case 8: // Euronet Web ECR
                $pos_description = "Euronet Web ECR | Συμβατή με Α1155";
                break;
            case 9: // Neosoft
                $pos_description = "Neosoft | Συμβατή με Α1155";
                break;
            case 10: // Neosoft
                $pos_description = "INSS | Συμβατή με Α1155";
                break;
            case 90: //* Demo POS
                $pos_description = "Demo POS | Συμβατή με Α1155";
                break;
            default: 
                $pos_description = "";
        }

        return $pos_description;
    }
}