<?php
    
    function pos00_after_update(){
        pegasus_mysql_use('select * from p55 where p00="pos00"', $p55);        
        
        if($p55['ver']=='1' && $p55['rel']<='6') { 
            /** Διαγραφή μεθόδων που δεν χρησιμοποιούνται */
            if (file_exists('../pos00_01/account_check_t01.php')) {
                unlink('../pos00_01/account_check_t01.php');
            }  
            
            if (file_exists('../pos00_01/initiate_pos_transaction.php')) {
                unlink('../pos00_01/initiate_pos_transaction.php');
            } 

            if (file_exists('../pos00_01/recalculate_unpaid_amount.php')) {
                unlink('../pos00_01/recalculate_unpaid_amount.php');
            } 

            if (file_exists('../pos00_02/search_pos_devices.php')) {
                unlink('../pos00_02/search_pos_devices.php');
            }
            
            if (file_exists('../pos00_01/show_pos_account_transactions.php')) {
                unlink('../pos00_01/show_pos_account_transactions.php');
            }

            if (file_exists('../pos00_03/find_pos00_01.php')) {
                unlink('../pos00_03/find_pos00_01.php');
            }  
        }
        if($p55['ver']=='1' && $p55['rel']<='64') { 
            if (file_exists('../pos00_01/mellv2_check_credentials.php')) {
                unlink('../pos00_01/mellv2_check_credentials.php');
            }
        }
        
        if($p55['ver']=='1' && $p55['rel']<='119') { 
            $files_arr = array(
                '../pos00_01/pos00_02_change_pos00_01.php',
                '../pos00_01/show_pos00_d00.php',
                '../pos00_01/euronet2_check_credentials.php',
                '../pos00_01/mellv2_check_details.php',
                '../pos00_02/viva_webhook.php',
                '../pos00_03/find_pos00_01.php',
                '../pos00_03/edps_sync_request.php', 
                '../pos00_03/edps_sync_response.php',
                '../pos00_03/cardlink_v2_resend_all_request.php',
                '../pos00_03/cardlink_v2_resend_all_response.php',
                '../pos00_03/cardlink_v2_resend_next_request.php',  
                '../pos00_03/cardlink_v2_resend_next_response.php', 
                '../pos00_03/cardlink_v2_get_pos_transaction.php',  
            );

            foreach ($files_arr as $file) {
                if (file_exists($file)) {
                    unlink($file);
                }
            }
        }
        if($p55['ver']=='1' && $p55['rel']<='105') {
            if(file_exists("../pos00_01/retrieve_pos_transaction.php")) {
                unlink("../pos00_01/retrieve_pos_transaction.php");
            }
        }

        if($p55['ver']=='1' && $p55['rel']<='119') { 
            //Απενεργοποιεί το τσεκ "Δυνατότητα Mail/Phone Order" αυτό στις υφιστάμενες εγκαταστάσεις
            pegasus_mysql_update("pos00_02", array("p01"), array(0), "nr01>0", 0, 1, 1);
        }

        if($p55['ver']=='1' && $p55['rel']<='147') { 
            $files_arr = array(
                '../pos00_01/check_pos_transaction.php',
                '../pos00_01/complete_pos_transaction.php',
                '../pos00_01/send_pos_transaction.php'
            );

            foreach ($files_arr as $file) {
                if (file_exists($file)) {
                    unlink($file);
                }
            }
        }
    }

    function pos00_pos00_d04_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {   
        /**
         * Ε: 10001355 Δ: 10169584
         * Παραμετροποίηση οθόνης pos00_d04 για την περίπτωση προφόρτωσης πληρωμών
         * 
         */
        global $PegInput;
        $PegInput->addVar(new peg_input_number('pos00_04_nr01'));
        $PegInput->addVar(new peg_input_number('v_profortosi'));
        $pos00_04_nr01 = $PegInput->getRequest('pos00_04_nr01');
        $v_profortosi = $PegInput->getRequest('v_profortosi');
        
        $data['v_message'] = $_SESSION['peg_dic_pos00_trans_submit_transaction'];
        if($v_profortosi == 1) {
            $data['peg_screenTitle'] = $_SESSION['peg_dic_pos00_d04_profortosi_title'];
            $data['v_message'] = $_SESSION['peg_dic_pos00_d04_profortosi_message'];
            $data['btn_00_text'] = $_SESSION['peg_dic_pos00_d04_profortosi_btn'];
        }
        $data['v_message_readonly'] = 1;    
        $data["pos00_04_nr01"] = $pos00_04_nr01;
        
        return $data;
    }

    function pos00_pos00_d05_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
        
        $data["v_pos00_04"]         = $_REQUEST['pos00_04_nr01'];
        $data['v_message']          = $_SESSION['peg_dic_pos00_trans_submit_transaction'];
        $data['v_message_readonly'] = 1;              
        
        return $data;
    }

    function pos00_pos00_01_d_p02_ls_data($data=array()) {

        $types_inactive = array(1, 2, 3, 7, 90);
        $types = array(
            4  => "Viva Wallet | Συμβατή με Α1155",
            5  => "Mellon Web ECR | Συμβατή με Α1155",
            6  => "ΕDPS Json Protocol | Συμβατή με Α1155",
            7  => "Cardlink (6.3) | Συμβατή με Α1155",
            8  => "Euronet Web ECR | Συμβατή με Α1155",
            9  => "Neosoft | Συμβατή με Α1155",
            10 => "INSS | Συμβατή με Α1155",
            1  => "Cardlink 2.8.1 (Deprecated)",
            2  => "Euronet Verifone (Deprecated)",
            3  => "Mellon Ingenico (Deprecated)",
            90 => "Demo POS | Συμβατή με Α1155 (Deprecated)",
        );

        $ls_data = array();
        foreach ($types as $key => $value) {
            //Δεν εμφανίζονται στο combobox οι inactive Τύποι POS
            //Εμφανίζονται μόνο grid "browse_d00" και στην περίπτωση που ειναι ήδη επιλεγμένοι - όχι σε νέες Εγγραφές
            if(count($data)>0 && in_array($key, $types_inactive) && isset($data) && (!($data['nr01']>0) || $data['p02']!=$key)){
                continue;
            }
            $ls_data[] = array("p01" => $key, "p02" => $value);           
        }
        
		return json_encode($ls_data);
	}

    function pos00_pos00_01_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){

        $newrec = 0;            
        if(!($data['nr01']>0)){
            $newrec = 1;
        }
        

        $data["pos00_pos00_01_d_p02_ls_data"] = pos00_pos00_01_d_p02_ls_data($data);


        $data['p03_hidden']       = true;
        $data['p04_hidden']       = true;
        $data['tidnsp_hidden']    = 2;

        for ($type=4; $type<=10; $type++) { 
            $data['fldset_'.pegasus_leading_zeros($type, 2).'_hidden'] = true;
        }

        $data['message'] = '';
        if($data['p02'] == 1 || $data['p02'] == 2 || $data['p02'] == 3 || $data['p02'] == 90){ //Deprecated methods
            $data['message'] = $_SESSION['peg_dic_pos00_deprecated_pos00_01'];
        }
        if (empty($data['message'])) {
            $data['message_hidden'] = 1;
        }

        //Cardlink V2
        $data['crdlinkv2_port_hidden']      = 2;
        $data['crdlinkv2_bdr_hidden']       = 2;
        $data['crdlinkv2_prt_hidden']       = 2;
        $data['crdlinkv2_stp_bts_hidden']   = 2;
        $data['crdlinkv2_bt_sz_hidden']     = 2;
        $data['crdlinkv2_host_hidden']      = 2;
        $data['crdlinkv2_host_port_hidden'] = 2;


        $data['req_sign_hidden']   = 1;
        $data['req_sign_readonly'] = 1;

        if($newrec==1){
            //Cardlink V2
            $data['crdlinkv2_bdr']     = 9600;
            $data['crdlinkv2_prt']     = 0;
            $data['crdlinkv2_stp_bts'] = 1;
            $data['crdlinkv2_bt_sz']   = 8;
            
        }
        
                   
        if($data['p02']>0){
            $data['fldset_'.pegasus_leading_zeros($data['p02'], 2).'_hidden'] = false; 
        }          

        
        //Cardlink V2
        if($data['crdlinkv2_tp']==1){
            $data['crdlinkv2_host_hidden']      = 0;
            $data['crdlinkv2_host_port_hidden'] = 0;
        }elseif($data['crdlinkv2_tp']==2){
            $data['crdlinkv2_port_hidden']    = 0;
            $data['crdlinkv2_bdr_hidden']     = 0;
            $data['crdlinkv2_prt_hidden']     = 0;
            $data['crdlinkv2_stp_bts_hidden'] = 0;
            $data['crdlinkv2_bt_sz_hidden']   = 0;
        }

        if($data['p02']==4){                
            //Viva
            $data['p04_hidden'] = false;
            // $data['tidnsp_readonly']   = 1;
            // $data['req_sign_hidden']   = 0;
            // $data['req_sign_readonly'] = 0;
        }

        if($data['p02']==10){                
            $data['p04_hidden'] = false;
        }

        // if($data['p02']==90 || $data['p02']==7){ 
        //     $data['req_sign_hidden']   = 0;
        //     $data['req_sign_readonly'] = 0;
        // } 

        // if(in_array($data['p02'], array(5, 6))){
        //     $data['tidnsp_readonly']   = 1;
        //     $data['req_sign_hidden']   = 0;
        //     $data['req_sign_readonly'] = 0;
        // }
            

        if(!empty($data['p02'])) {
            $device_properties = pos00_device_properties::get_properties($data['p02']);
            
            $data['req_sign_hidden'] = 1;
            $data['req_sign_readonly'] = 1;
            $data['tidnsp_readonly'] = 0;

            if($device_properties['req_sign']) {
                $data['req_sign_hidden'] = 0;
                if(!$device_properties['no_req_sign']) {
                    $data['req_sign'] = 1;
                }
            }
            if($device_properties['no_req_sign']) {
                $data['req_sign_readonly'] = 0;
            }
            if($device_properties['tid_readonly']) {
                $data['tidnsp_readonly'] = 1;
            }
        }

        if($data['req_sign'] == 1){
            $data['tidnsp_hidden'] = 0;
        }

        // echo "<pre>" .print_r($data, 1). '</pre>';


        $data["pos00_pos00_01_d_viva_tid_ls_data"] = array();

        return $data;
    }

    function pos00_pos00_01_d_onsave($data , $permDeny , $mmnr01 , $checkOnlyPerm){

        /**
         * Ε: 10001355 Δ: 10169584
         * Δεν κάνουμε έλεγχο για το tidnsp
         * 
         */
        // if($data['req_sign']==1 && empty($data['tidnsp'])){
        //     array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_pos00_01_tidnsp_missing']));
        // }

        
        /**
         * Έλεγχος καταχώρισης Ταυτότητα Μέσου Πληρωμών για συσκευής POS Cardlink (6.3) | Συμβατή με Α1155.
         */
        if(
            $data['p02'] == '7'             // Τύπος: Cardlink (6.3) | Συμβατή με Α1155
            && $data['req_sign'] == '1'     // Απαιτεί υπογραφή Παρόχου/ΦΗΜΑΣ/ΑΔΗΜΕ
            && empty($data['tidnsp'])       // Ταυτότητα Μέσου Πληρωμών
        ) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_tidnsp_not_set']));
        }

        if(
            $data['p02'] == '5'   // Mellon Web ECR | Συμβατή με Α1155
            && empty($data['mellv2_bnk'])
         ) {
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_mellv2_no_bnk']));
        }
        
        if($data['req_sign']==1 && $data['p02']==1){
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_incompatible_crdlink_signature']));
        }

        //INSS: Όταν αλλάζω το ΑΦΜ από την οθόνη της Συσκευής, αρχικοποιούνται με κενό string τα INSS tokens (inss_btn_00/pegSave_d)
        $inss_vat_id = pegasus_mysql_printfld('pos00_01', 'inss_vat_id', 'nr01=?', array($data['nr01'])); 
        if($data['inss_vat_id']!=$inss_vat_id){
            $data['inss_token']         = "";
            $data['inss_refreshtoken']  = "";
        }

        return array($data, $permDeny);
    }

    function pos00_pos00_02_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){

        $new_rec = 0;            
        if(!($data['nr01']>0)){
            $new_rec = 1;
        }

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='a14_d'){
            if($new_rec==1){
                $data['a14'] = $mmnr01_arr[1];
            }            
            $data['a14_readonly'] = 1;
            $data['a14_hidden']   = 2;
            $data['este55_readonly'] = 1;
            $data['este55_hidden']   = 2;
        }
        if($mmnr01_arr[0]=='este55_d'){
            if($new_rec==1){
                $data['este55'] = $mmnr01_arr[1];
            }            
            $data['cor003p01_readonly'] = 1;
            $data['cor003p01_hidden']   = 1;
            $data['este55_readonly'] = 1;
            $data['este55_hidden'] = 0;
            
            pegasusSetGlobalVar($container_id . '_where_pos00_01', 
                array(
                    'sql'=>'pos00_01.p02!=7 && pos00_01.p02!=6'
                )
            );
        }
               
        pegasusSetGlobalVar($container_id . '_where_a14', 
            array(
                'sql'=>'a14.p02=0', 
                'sqlParams'=>array()
            )
        ); 
        
        pegasusSetGlobalVar($container_id . '_where_t02p01', 
            array(
                'sql'=>'t02.p04 in ("-1","1")'
            )
        );

        $data['p00_hidden'] = true;
        $data['p01_hidden'] = true;
        $data['p02_hidden'] = true;
        if(!empty($data['pos00_01'])) {
            pegasus_mysql_use('select * from pos00_01 where nr01=:pos00_01', $pos00_01, array('pos00_01'=>$data['pos00_01'])); 

            if(!empty($pos00_01['p02'])) {
                $t02_p04 = pegasus_mysql_printfld('t02', 'p04', 'p01=:t02p01', array('t02p01'=>$data['t02p01']));

                $device_properties = pos00_device_properties::get_properties($pos00_01['p02']);
                if($device_properties['instalments']) {
                    $data['p00_hidden'] = false;
                }
                if($device_properties['moto'] && $t02_p04>0 && $pos00_01['mellv2_bnk']!=8) {
                    $data['p01_hidden'] = false;
                }
                if($device_properties['complete_preauth']) {
                    $data['p02_hidden'] = false;
                }
            }
        }
        
        return $data;
    }

    function pos00_pos00_02_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){

        $ret_arr  = pos00_pos00_02_check_data($data, $permDeny, $mmnr01, $checkOnlyPerm);
        $data     = $ret_arr[0];
        $permDeny = $ret_arr[1];
        
        return array($data, $permDeny);
    }

    function pos00_pos00_02_check_data($data, $permDeny, $mmnr01, $checkOnlyPerm){

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]!='a14_d'){
            $q31_nr01 = pegasus_mysql_printfld('q31', 'nr01', 'p01="620042" and p05="7" and p03=:a14nr01', array('a14nr01'=>$data['a14']));
            if(!($q31_nr01>0)){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_pos00_02_a14_mydt_not_related']));
            }

            $req_sign = pegasus_mysql_printfld('pos00_01', 'req_sign', 'nr01=:pos00_01_nr01', array('pos00_01_nr01'=>$data['pos00_01']));
            if($req_sign!=1){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_pos00_02_req_sign']));
            }
        }
        if($mmnr01_arr[0]!='este55_d'){
            if(empty($data['cor003p01'])){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_pos00_02_cor003p01_empty']));
            }
        }


        return array($data, $permDeny);
    }

    function pos00_pos00_04_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
        if(!empty($data['p30'])) {
            $data['p30_hidden'] = false;
        }
        if(!empty($data['p31'])) {
            $data['p31_hidden'] = false;
        }
        return $data;
    }

    /**
	 * Εύρεση Συσκευής POS
     * Αν $pos00_02_nr01>0 γίνεται Εύρεση Συσκευής με βάση τη Ρυθμιση Συσκευής (pos00_02)
	 *
	 * @param  int      $pos00_01_nr01
	 * @param  int      $pos00_02_nr01
	 * @return mixed    
	 */
    function pos00_find_pos00_01($pos00_01_nr01=0, $pos00_02_nr01=0){

        $values = array();
        if($pos00_01_nr01>0){
            $where  = ' and pos00_01.nr01=:pos00_01_nr01 ';
            $values = array('pos00_01_nr01'=>$pos00_01_nr01);
        }

        $pos00_02_select = "";
        $pos00_02_join   = "";

        if($pos00_02_nr01>0){
            $where  = ' and pos00_02.nr01=:pos00_02_nr01 ';
            $values = array('pos00_02_nr01'=>$pos00_02_nr01);    

            $pos00_02_select = "    pos00_02.a14        as pos00_02_a14, 
                                    pos00_02.cor003p01  as pos00_02_cor003p01, 
                                    pos00_02.t02p01     as pos00_02_t02p01, ";
            $pos00_02_join = " join pos00_02 on pos00_02.pos00_01=pos00_01.nr01 ";
        }

        $query = '  SELECT pos00_01.*, 
                            '.$pos00_02_select.'
                            pos00_03.ip         as pos00_03_ip,
                            pos00_03.port       as pos00_03_port,
                            pos00_03.secret     as pos00_03_secret
                            
                    
                    from pos00_01 
                    '.$pos00_02_join.'
                    left join pos00_03 on pos00_03.nr01=(
                        CASE pos00_01.p02
                            WHEN 1 THEN pos00_01.crdlink_pos00_03
                            WHEN 2 THEN pos00_01.euronet_pos00_03
                            WHEN 3 THEN pos00_01.mellon_pos00_03
                            WHEN 6 THEN pos00_01.edps_pos00_03
                            WHEN 7 THEN pos00_01.crdlinkv2_pos00_03
                            ELSE 0
                            END
                        )
                    where 1=1 ' . $where;

        pegasus_mysql_use($query, $pos00_01, $values);

        return $pos00_01;
    }

    function pos00_find_pos00_02($a14nr01=0, $cor003p01=''){
        $query = 'select * from pos00_02 where a14=:a14nr01 and cor003p01=:cor003p01';
        pegasus_mysql_use($query, $pos00_02, array('a14nr01'=>$a14nr01, 'cor003p01'=>$cor003p01));

        return $pos00_02;
    }

    function pos00_find_pos00_04($pos00_04_nr01=0){
        $query = 'select * from pos00_04 where nr01=:nr01';
        pegasus_mysql_use($query, $pos00_04, array('nr01'=>$pos00_04_nr01));

        return $pos00_04;
    }

    /**
	 * Έλεγχος αν το POS transaction έχει ολοκληρωθεί 
     * (Αν ΕΧΕΙ συνδεση με t01 & ΕΧΕΙ Ref. Number ή ΕΙΝΑΙ Άκυρη-POS Failure)
     * Αν $validity==true ΔΕΝ ελεγχεται η εγκυρότητα της Πληρωμής
     * Αν εχει ολοκληρωθεί επιστρεφει το αντιστοιχο record απο τη βαση
	 *
	 * @param  int      $pos00_04_nr01
	 * @param  bool     $validity       
	 * @return mixed    
	 */
    function pos00_check_pos_transaction_is_completed($pos00_04_nr01=0, $validity=true){

        $where  = ' pos00_04.nr01=:pos00_04_nr01';
        $where .= ' and ((pos00_04.t01>0 and pos00_04.p01!="")';
        $where .= ($validity==true) ? ' or pos00_04.p02=1' : '';
        $where .= ') ';
        
        $query = '  select  pos00_04.nr01, pos00_04.t01, pos00_04.p02, pos00_04.p03  
                    from    pos00_04 
                    where   '. $where;

        pegasus_mysql_use($query, $pos00_04, array('pos00_04_nr01'=>$pos00_04_nr01));
        
        if($pos00_04['nr01']>0){
            return $pos00_04;
        }else{
            return false;
        }
    }
    
    /**
	 * Insert/Update pos00_04 record
	 *
	 * @param  int      $nr01   (pos00_04 nr01)
	 * @param  array    $data   (pos00_04 data)
	 * @return int      $nr01
	 */
    function pos00_set_pos_transaction($nr01=0, $data=array()){

        if($nr01==0){
            $nr01 = pegasus_mysql_newrec('pos00_04');
        }
        
        $arr1 = array();    $arr2 = array();
        foreach ($data as $key => $value) {
            array_push($arr1, $key);    array_push($arr2, $value);
        }
        
        if(pegasus_mysql_printfld('pos00_04', 'nr01', 'nr01=:nr01', array('nr01'=>$nr01))>0){
            pegasus_mysql_update('pos00_04', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1, array('nr01'=>$nr01));
        }else{
            array_push($arr1, 'nr01');    array_push($arr2, $nr01);
            pegasus_mysql_insert('pos00_04', $arr1, $arr2);
        }

        return $nr01;
    }
    
    /**
	 * Insert/Update t01 record
	 *
	 * @param  int      $nr01
	 * @param  array    $data (t01 data)
	 * @param  string   $tbl ('a55'/'tran01')
	 * @param  array    $tbl_data (a55 data)
	 * @return int      $nr01
	 * @param  array    $return_array: Από estiasi για να επιστρέψει και aa
	 */
    function pos00_set_account_transaction($t01_nr01=0, $data=array(), $tbl='a55', $tbl_data=array(), $return_array=false){ 
        
        $p_kklo = $data['p07'];
        if($p_kklo!=0) {

            pegasus_mysql_use('select * from t02 where p01=? ', $t02, array($p_kklo));

            // echo pegasus_replace_values_in_sql('select * from t02 where p01=? ',array($p_kklo));
            $p_kkxr = $t02['p03'];
			$p_kkpi = $t02['p04'];

            if(!($p_kkxr==0 && $p_kkpi==0)){

                if($tbl=='a55'){
                    pegasus_mysql_use('select * from a10 where p01=?', $a10, array($tbl_data['p05']));
                    pegasus_mysql_use("select * from a01 where nr01=?", $a01, array($tbl_data['p03']));

                    $p06  = $a10['p00'] . ' ' . $tbl_data['p701'] . ' ' . $tbl_data['p06']; //παραστατικο
                    $p09  = $tbl_data['p0121'];                                             //καταστημα
                    $p900 = $tbl_data['p04'];                                               //υποκατάστημα
                    $p503 = $tbl_data['p503'];                                              //κωδ.έργου
                    $p504 = $tbl_data['p504'];                                              //κωδ.εργασίας
                    $p401 = $tbl_data['p016'];                                              //κωδ.πωλιτή

                }elseif($tbl=='tran01'){
                    pegasus_mysql_use('select * from tran20 where p01=?', $tran20, array($tbl_data['p105']));
                    pegasus_mysql_use("select * from a01 where nr01=?", $a01, array($tbl_data['p61']));

                    $p06  = $tran20['p00'] . ' ' . $tbl_data['sp00'] . ' ' . $tbl_data['p00'];
                    $p09  = $tbl_data['p704'];
                    $p900 = $tbl_data['p611'];
                    $p503 = $tbl_data['p302'];
                    $p504 = $tbl_data['p303'];
                    $p401 = $tbl_data['p101'];
                }elseif($tbl=='este01'){
                    pegasus_mysql_use("select a01.p21 from este01 left join a01 on a01.nr01=este01.p05 where este01.nr01=?", $a01, array($data['p302']));
                }

                $tbl_data['pn02'] = (!empty($tbl_data['pn02'])) ? $tbl_data['pn02'] : 1;

                $arr1 = array();            $arr2 = array();
                array_push($arr1, 'p01');   array_push($arr2, $a01['p21']);
                array_push($arr1, 'p03');   array_push($arr2, $data['vp03'] * $p_kkxr);
                array_push($arr1, 'p04');   array_push($arr2, $data['vp03'] * $p_kkpi);

                array_push($arr1, 'pn03');  array_push($arr2, $data['vp03'] * $p_kkxr * $tbl_data['pn02']);
                array_push($arr1, 'pn04');  array_push($arr2, $data['vp03'] * $p_kkpi * $tbl_data['pn02']);

                array_push($arr1, 'pn01');  array_push($arr2, $tbl_data['pn01']);
                array_push($arr1, 'pn02');  array_push($arr2, $tbl_data['pn02']);

                array_push($arr1, 'p07');   array_push($arr2, $p_kklo);

				array_push($arr1, 'p900');  array_push($arr2, $p900);
                
				array_push($arr1, 'p503');  array_push($arr2, $p503);
				array_push($arr1, 'p504');  array_push($arr2, $p504);
				

                if($data['p02']!=''){
                    array_push($arr1, 'p02');   array_push($arr2, $data['p02']);
                }
                if($data['p02t']!=''){
                    array_push($arr1, 'p02t');  array_push($arr2, $data['p02t']);
                }
                if($data['p05']!=''){
				    array_push($arr1, 'p05');   array_push($arr2, $data['p05']);
                }


                if($t01_nr01>0){ //Υπάρχον t01 για αυτό το pos04_00
                    array_push($arr1, 'p06');   array_push($arr2, $p06);
                    array_push($arr1, 'p09');   array_push($arr2, $p09);
                    array_push($arr1, 'p401');  array_push($arr2, $p401);
                    pegasus_mysql_update('t01', $arr1, $arr2, 'nr01=:nr01', 0, 1, 1, array('nr01'=>$t01_nr01));
                }else{
                    $p401 = $_SESSION['username'];                          //εισπράκτορας
                    $p303 = ((!isset($data['p303'])) && $tbl=='a55') ? '9' : $data['p303'];
                    $p303 = ((empty($p303)) && $tbl=='este01') ? '71' :  $p303;     //Για είσπραξη ανοίγματος

                    $aa = 0;
                    if(($p303=='0' || $p303=='71') && !empty($t02['p0903'])){
                        $p09 = $_SESSION['cor003_p104'];
                        $aa = account_make_invoice_num($p09, $t02['p0903'], $t02['p0903_2']);
            
                        $p06 = "";
                        if(!empty($t02['p0903_1'])) {
                            $p06 .= $t02['p0903_1'] . " ";
                        }
                        if(!empty($t02['p0903_2'])) {
                            $p06 .= $t02['p0903_2']. " ";
                        }
                
                        $p06 .= $aa;
                    }

                    array_push($arr1, 'p06');   array_push($arr2, $p06);
                    array_push($arr1, 'p09');   array_push($arr2, $p09);
                    array_push($arr1, 'p401');  array_push($arr2, $p401);


                    
                    $t01_nr01 = pegasus_mysql_newrec('t01');

                    array_push($arr1, 'nr01');  array_push($arr2, $t01_nr01);
                    array_push($arr1, 'p303');  array_push($arr2, $p303);

                    if(!empty($data['a14_nr01'])) {
                        array_push($arr1, 'pd101'); array_push($arr2, 'a14');
                        array_push($arr1, 'pd102'); array_push($arr2, $data['a14_nr01']);
                    }
                    
                    if(isset($data['p302'])){
                        array_push($arr1, 'p302');  array_push($arr2, $data['p302']);
                    }
                    pegasus_mysql_insert('t01', $arr1, $arr2);
                }
            }

        }

        if($return_array===true){
            return array('t01_nr01' => $t01_nr01 , 'aa' => $aa);
        }
        return $t01_nr01;
    }

    /**
	 * Επιστρεφει decode το response απο μια POS Συσκευή
	 *
	 * @param  string   $data_as_base64_string
	 * @param  int      $pos00_01_p02   (Cardlink:1, Euronet:2, 3, Viva:4)
	 * @return array    $sales_response
	 */
    function pos00_decode_sales_response($data_as_base64_string, $pos00_01_p02){

        $data_string = base64_decode($data_as_base64_string);        
        $sales_response = array();

        if($pos00_01_p02==1){
            $data_string = str_replace(array("\r\n","\n"), array("_#peg#_","_#peg#_"), $data_string);
            $string_arr_00 = explode("_#peg#_", $data_string);
            foreach (array_filter($string_arr_00) as $string_tmp) {
                $string_arr_01 = explode(" :", $string_tmp);
                $sales_response[trim($string_arr_01[0])] = trim($string_arr_01[1]);
            }

        }elseif($pos00_01_p02==7){
            //Cardlink V2
            $data_string = str_replace(array("\r\n","\n"," :"), array("_#peg#_","_#peg#_",":"), $data_string);
            $string_arr_00 = explode("_#peg#_", $data_string);
            foreach (array_filter($string_arr_00) as $string_tmp) {
                $string_arr_01 = explode(":", $string_tmp);
                //$sales_response[trim($string_arr_01[0])] = trim($string_arr_01[1]);
                $string_arr_01 = array_map("trim", $string_arr_01);
                $index = array_shift($string_arr_01);
                $sales_response[$index] = implode(":", $string_arr_01);
                // for ($i=1; $i<count($string_arr_01); $i++) { 
                //     if(isset($sales_response[trim($string_arr_01[0])])){}
                //     $sales_response[trim($string_arr_01[0])] .= trim($string_arr_01[$i]);
                // }
            }

        }elseif($pos00_01_p02==2){
            $data_string = str_replace(array("\r\n","\n"), array("_#peg#_","_#peg#_"), $data_string);
            $string_arr_00 = explode("_#peg#_", $data_string);
            foreach (array_filter($string_arr_00) as $string_tmp) {
                $string_arr_01 = explode(":", $string_tmp);
                $sales_response[trim($string_arr_01[0])] = trim($string_arr_01[1]);
            }
        }elseif($pos00_01_p02==3){
            //Exception: A connection attempt failed because the connected party did not properly respond after a period of time, or established connection failed because connected host has failed to respond 192.168.167.177:4000
            $string_arr_00 = explode(":", $data_string);
            if($string_arr_00[0]=='Exception'){
                $sales_response['exception'] = $data_string;
                return $sales_response;
            }


            //MEL0101R/S991812/C00/DDebit Mastercard:516732******3242:100:100:11:64999993:000037:222222100003:000057:123459:20230831183742
            $sales_response['direction_indicator'] = substr($data_string, 0, 3);
            $sales_response['protocol_variant']    = substr($data_string, 3, 2);
            $sales_response['protocol_version']    = substr($data_string, 5, 2);

            $transaction_data_flds = array(
                'card-type', 'cardpan masked', 'amount', 'final-amount',
                'acqId', 'terminalId', 'batch-num', 'rrn', 'stan', 'authcode', 'datetime'	
            );

            $string_arr_00 = explode("/", $data_string);
            foreach (array_filter($string_arr_00) as $key=>$value) {
                if($key==0) {continue;}
                
                $index = substr($value, 0, 1);
                switch ($index) {
                    case 'S':
                        $sales_response['result']["session_number"] = substr($value, 1);
                        break;
                    case 'C':
                        $sales_response['result']["processing_code"] = substr($value, 1);
                        break;
                    case 'D':
                        $transaction_data_tmp = explode(":", substr($value, 1));
                        foreach ($transaction_data_tmp as $i=>$v) {
                            $transaction_data[$transaction_data_flds[$i]] = $v;
                        }
                        $sales_response['result']["transaction_data"] = $transaction_data;
                    break;
                    default:
                        $sales_response['result'][$index] = substr($value, 1);
                        break;
                }
            }
        }
        return $sales_response;
    }

    /**
     * Δημιουργία του URL για την κλήση του Web ECR της Mellon
     * @param  int  $pos00_01_nr01
     * @param  boolean $oath Αν το URL προορίζετε για την διαδικασία του Authorization 
     * @return string
     */
    function pos00_mellv2_get_url($pos00_01_nr01,$oath=false){
        $mellv2_bnk = pegasus_mysql_printfld('pos00_01', 'mellv2_bnk', 'nr01 = :nr01', array('nr01' => $pos00_01_nr01));
        $url = '';
        /**
         * Ε:10001830
         * Αν έχει οριστεί η pos00_nexi_url της παραμέτρους χρήστη (DEV mode)
         */
        if(
            $mellv2_bnk == 8
            && !empty($_SESSION['cor011_pos00_nexi_url'])
        ) {
            $url = rtrim($_SESSION['cor011_pos00_nexi_url'],'/');
        }
        /**
         * Ε:10001830
         * Αν έχει οριστεί η pos00_mellonv2_url της παραμέτρους χρήστη (DEV mode)
         */
        elseif(!empty($_SESSION['cor011_pos00_mellonv2_url'])){
            $url = rtrim($_SESSION['cor011_pos00_mellonv2_url'],'/');
        } 
        /**
         * Ε:10001830
         * Αρχικοποίηση του url ανάλογα με την τράπεζα
         */
        else {
            switch($mellv2_bnk) {
                case '1' :  // NBG
                    $url = 'https://www.mreceipts.com/api';
                    break;
                case '2' :  // Attica
                case '3' :  // Pancreta
                case '4' :  // JCC
                case '7' :  // PBT
                case '9' :  // myPOS
                    $url = 'https://gbl.mreceipts.com/api';
                    break;
                case '5' :  // Nexi (Ingenico)
                    $url = 'https://nexi.mreceipts.com/api';
                    break;
                case '6' :  // Wordline
                    $url = 'https://wl.mreceipts.com/api';
                    break;
                case '8' :  // Nexi (Android // SoftPOS)
                    $url = 'https://ecr.prd.api-fintechiq.com/v1';
                    break;
            }
        }
        /**
         * Ε:10001830
         * Αν δεν είναι για την διαδικασία του Authorization προσθέτουμε το /v2.1 για τα 
         * route της Mellon (!= 8 Nexi Android // SoftPOS)
         */
        if(!$oath) {
            switch($mellv2_bnk) {
                case '1' :  // NBG
                case '2' :  // Attica
                case '3' :  // Pancreta
                case '4' :  // JCC
                case '5' :  // Nexi (Ingenico)
                case '6' :  // Wordline
                case '7' :  // PBT
                case '9' :  // myPOS
                    $url .= '/v2.1';
                    break;
            }
        }
        return $url;
    }
    function pos00_mellv2_get_vendor_account($pos00_01_nr01) {
        
        $mellv2_bnk = pegasus_mysql_printfld('pos00_01', 'mellv2_bnk', 'nr01 = :nr01', array('nr01' => $pos00_01_nr01));
        $username = 'PegasusWebAppInitiator';
        $password = 'KU-lhEq)@DXv@(8';
        $env = 'PROD';
        /**
         * Ε:10001830
         * Production credential στης Nexi. Είναι τα ίδια με τα dev.
         */
        if($mellv2_bnk == 8) {
            $username = 'tesae';
            $password = 'x?DGZc0V!';
            $env = 'PROD';
        }
        /**
         * Αν έχει οριστεί το url στις παραμέτρους χρήστη για την Mellon τότε χρησιμοποιούμε τα DEV credentials της Mellon
         */
        if(!empty($_SESSION['cor011_pos00_mellonv2_url'])) {
            $username = 'f.psarra@tesae.com';
            $password = 'ajs886%$$$AA1';
            $env = 'DEV';
        }
        /**
         * Ε:10001830
         * Aν έχει οριστεί το url στις παραμέτρους χρήστη για την Nexi τότε χρησιμοποιούμε τα DEV credentials της Nexi
         */
        if(
            $mellv2_bnk == 8
            && !empty($_SESSION['cor011_pos00_nexi_url'])
        ) { 
            $username = 'tesae';
            $password = 'x?DGZc0V!';
            $env = 'DEV';
        }
        return array(
            'username'  => $username,
            'password'  => $password,
            'env'       => $env
        );
    }
    /**
     * Καλεί το /api/token/ και σετάρει το pos00_01.mellv2_token και pos00_01.mellv2_refreshtoken
     * @param int $pos00_01_nr01
     * @return array [ok, msg, token]
     * 
     */
    function pos00_mellv2_set_token(
        $pos00_01_nr01,
        $log_p_sign = ''
    ) {

        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01,true);
        $service_url = '/token/';
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url_token = $pos00_mellv2_get_url.$service_url;
        $pos00_mellv2_get_vendor_account = pos00_mellv2_get_vendor_account($pos00_01_nr01);
        $data = array(
            'username'  => $pos00_mellv2_get_vendor_account['username'],
            'password'  => $pos00_mellv2_get_vendor_account['password']
        );
        $log_request = array('env' => $pos00_mellv2_get_vendor_account['env']);
        try {
            $response_token = pegasus_curl_request_post(
                $url_token,
                json_encode($data),
                false,
                array(
                    'Content-Type: application/json',
                    'Accept: application/json'
                ),
                array(),
                true
            );
        } catch (Exception $exc) {
            $msg = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url_token,
                "pos00_mellv2_set_token:curl:{$exc->getCode()}",
                $msg,
                array(),
                array(),
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'mellon:check-credentials',
                array(),
                $msg, 
                $url_token
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        pos00_add_to_log(
            'mellon:check-credentials',
            array(),
            $response_token['response'], 
            $url_token
        );
        if($response_token["http_code"] == 401) {
            $msg = $_SESSION['peg_dic_pos00_pos00_01_wrong_credentials'];
            pos00_add_external_log(
                $url_token,
                "pos00_mellv2_set_token:http_code:401",
                $msg,
                array(),
                $response_token,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $response_arr2 = json_decode($response_token['response'], true);
        if(empty($response_arr2) ) {
            $msg = str_replace(
                '#response#', 
                $response_token['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url_token,
                "pos00_mellv2_set_token:json_decode",
                $msg,
                array(),
                $response_token,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $tokens = array(
            'mellv2_token'          => $response_arr2["access"],
            'mellv2_refreshtoken'   => $response_arr2["refresh"]
        );
        /**
         * Ε: 10001355 Δ: 10169584
         * Κατά την ενημέρωση του api key δεν κάνουμε update τα date για να μην έχουμε αργότερα confirm στο save της οθόνης.
         * 
         */
        pegasus_mysql_update(
            'pos00_01',
            array_keys($tokens),
            array_values($tokens),
            'nr01 = :nr01',
            1, 1, 1, 
            array('nr01' => $pos00_01_nr01)
        );
        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_connection'];
        return array(
            'ok' => 1,
            'msg' => $msg, 
            'mellv2_token'=>  $tokens['mellv2_token']
        );
    }
    /**
     *
     * @param  int $pos00_01_nr01
     * @return array
     */
    function pos00_mellv2_get_token($pos00_01_nr01,$log_p_sign = ''){

        $data = array(
            "ok" => 1, 
            "msg" => "", 
            "mellv2_token" => ""
        );
        $mellv2_token = pegasus_mysql_printfld('pos00_01', 'mellv2_token', 'nr01=?', array($pos00_01_nr01));        
        $data['mellv2_token'] = $mellv2_token;
        if(empty($mellv2_token)){
            $data = pos00_mellv2_set_token($pos00_01_nr01, $log_p_sign);
        }
        return $data;
    }
    /**
     * Καλεί το / authorization/redeem/ και σετάρει το pos00_01.mellv2_api_key
     * @param int $pos00_01_nr01
     * @return array [ok, msg, token]
     * 
     */
    function pos00_mellv2_create_api_key($pos00_01_nr01, $called_after_refresh=false){
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        if(empty($pos00_01['mellv2_auth_code'])){
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_pos00_pos00_01_empty_auth_code']
            );
        }
        $data_token = pos00_mellv2_get_token($pos00_01_nr01);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01);
        $service_url = '/authorization/redeem/';
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            pos00_add_external_log(
                $service_url,
                "pos00_mellv2_create_api_key:pos00_mellv2_get_url",
                $msg,
                array('pos00_01_nr01' => $pos00_01_nr01),
                array(),
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url_redeem = $pos00_mellv2_get_url.$service_url;

        $data = array(
            'Type' => 'webecr',
            'Code' => $pos00_01['mellv2_auth_code']
        );
        try {
            $response_api_key = pegasus_curl_request_post(
                $url_redeem , 
                json_encode($data),
                false,
                array(
                    'Content-Type: application/json',
                    'Authorization: Bearer ' . $data_token['mellv2_token']
                ),
                array(),
                true
            );
        } catch (Exception $exc) {
            $msg = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url_redeem,
                "pos00_mellv2_create_api_key:curl:{$exc->getCode()}",
                $msg,
                $data,
                array(),
                true
            );
            pos00_add_to_log(
                'mellon:create-api-key',
                $data,
                $msg, 
                $url_redeem
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        pos00_add_to_log(
            'mellon:create-api-key',
            $data,
            $response_api_key['response'], 
            $url_redeem
        );
        if(
            $response_api_key["http_code"] == 401 
            && $called_after_refresh == false
        ){
            $res_refresh = pos00_mellv2_refresh_token($pos00_01_nr01);
            if($res_refresh['ok'] == 0){
                return $res_refresh;
            }
            return pos00_mellv2_create_api_key($pos00_01_nr01, true);
        }
        else if($response_api_key["http_code"] == 401){
            $msg = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key'];
            pos00_add_external_log(
                $url_redeem,
                "pos00_mellv2_create_api_key:http_code:401",
                $msg,
                $data,
                $response_api_key,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $response_arr2 = json_decode($response_api_key['response'], true);
        if($response_arr2 === NULL){
            $msg = str_replace(
                '#response#', 
                $response_api_key['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url_redeem,
                "pos00_mellv2_create_api_key:json_decode",
                $msg,
                $data,
                $response_api_key,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        /**
         * Ε:10001830
         * Το status = invald_authorization_code αναφαίρετε σε error της Mellon
         * Το code = INVALID_CODE αναφαίρετε σε error της Nexi
         */
        if(
            $response_arr2["status"] == "invald_authorization_code"
            || $response_arr2["Code"] == "INVALID_CODE"
        ){
            $msg = $_SESSION['peg_dic_pos00_pos00_01_wrong_auth_code'];
            pos00_add_external_log(
                $url_redeem,
                "pos00_mellv2_create_api_key:invald_authorization_code",
                $msg,
                $data,
                $response_arr2,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $api_key = array();
        $api_key['mellv2_api_key'] = $response_arr2['Id'];
        /**
         * Ε: 10001355 Δ: 10169584
         * Κατά την ενημέρωση του api key δεν κάνουμε update τα date για να μην έχουμε αργότερα confirm στο save της οθόνης.
         * 
         */
        pegasus_mysql_update(
            'pos00_01',
            array_keys($api_key),
            array_values($api_key),
            'nr01 = :nr01',
            1, 1, 1, 
            array('nr01' => $pos00_01_nr01)
        );

        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_api_key'];
        return array(
            'ok'                => 1,
            'msg'               => $msg,
            'mellv2_api_key'    => $response_arr2['Id']
        );
    }
    

    function pos00_mellv2_find_pos($pos00_01_nr01,  $called_after_refresh = false){
        $result = array(
            'ok' => 1,
            'msg' => '',
            'pos00_05' => ''
        );
    
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        if(empty($pos00_01['mellv2_api_key'])){
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_pos00_pos00_01_check_mellv2_api_key']
            );
        }
        $data_token = pos00_mellv2_get_token($pos00_01_nr01);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01);
        $service_url = '/terminal/';
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            pos00_add_external_log(
                $service_url,
                "pos00_mellv2_find_pos:pos00_mellv2_get_url",
                $msg,
                array('pos00_01_nr01' => $pos00_01_nr01),
                array(),
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url = $pos00_mellv2_get_url.$service_url;
        try {
            $req_response = pegasus_curl_request(
                $url, 
                false, 
                array(
                    'X-Api-Key: ' . $pos00_01['mellv2_api_key'],
                    'Authorization: Bearer ' . $data_token['mellv2_token']
                    ),
                array(),
                true
            );
            
        } catch (Exception $exc) {
            $msg = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_mellv2_find_pos:curl:{$exc->getCode()}",
                $msg,
                array(),
                array(),
                true
            );
            pos00_add_to_log(
                'mellon:find-pos',
                array(),
                $msg, 
                $url
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        pos00_add_to_log(
            'mellon:find-pos',
            array(),
            $req_response['response'], 
            $url
        );

        if(
            $req_response["http_code"] == 401 
            && $called_after_refresh == false
        ) {
            $res_refresh = pos00_mellv2_refresh_token($pos00_01_nr01);
            if($res_refresh['ok'] == 0){
                return $res_refresh;
            }
            return pos00_mellv2_find_pos($pos00_01_nr01, true);
        }
        else if($req_response["http_code"] == 401){
            $msg = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key'];
            pos00_add_external_log(
                $url,
                "pos00_mellv2_find_pos:http_code:401",
                $msg,
                array(),
                $req_response,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }


        $response_arr = json_decode($req_response['response'], true);
        if($response_arr === NULL){
            $msg = str_replace('#response#', $req_response['response'], $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']);
            pos00_add_external_log(
                $url,
                "pos00_euronet2_find_pos:response",
                $msg,
                array(),
                $req_response,
                true
            );
            return array(
                'ok'    => 0,
                'meg'  => $msg
            );
        }
        if($response_arr["count"] == 0){
            $msg = $_SESSION['peg_dic_pos00_pos00_01_no_pos_found'];
            pos00_add_external_log(
                $url,
                "pos00_euronet2_find_pos:peg_dic_pos00_pos00_01_no_pos_found",
                $msg,
                array(),
                $response_arr,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $pos00_05_nr01 = 0;
        foreach ($response_arr["results"] as $terminal) {
            $pos00_05 = array(
                'id'          => $terminal["Id"],
                'tid'         => $terminal['TerminalID'],
                'description' => $terminal['FriendlyName'],
                'pos00_01'    => $pos00_01_nr01
            );
            /**
             * E:10001830
             * Αν ο Acquirer είναι Nexi Android // SoftPOS
             */
            if($pos00_01['mellv2_bnk'] == 8){
                $pos00_05 = array(
                    'id'          => $terminal["id"],
                    'tid'         => $terminal['TerminalID'],
                    'description' => $terminal["TerminalID"],
                    'pos00_01'    => $pos00_01_nr01
                );
            }
            $pos00_05_nr01 = pegasus_mysql_printfld("pos00_05", "nr01", "id=? && pos00_01=?", array($pos00_05["id"], $pos00_01_nr01));
            if($pos00_05_nr01 > 0 ){
                pegasus_mysql_update(
                    'pos00_05',
                    array_keys($pos00_05),
                    array_values($pos00_05),
                    " nr01 = ?",
                    0, 1, 1,
                    array($pos00_05_nr01)
                );
            }
            else{
                $pos00_05['nr01'] = pegasus_mysql_newrec('pos00_05');
                $pos00_05_nr01 = $pos00_05['nr01'];
                pegasus_mysql_insert('pos00_05', array_keys($pos00_05), array_values(($pos00_05)));
            }
        }
        $result = array(
            'ok'    => 1,
            'msg'   => $_SESSION['peg_dic_pos00_pos00_01_success_found_mul_devices']
        );
        /**
         * Ε: 10001355 Δ: 10169584
         * Αν βρει μόνο ένα τερματικό τότε το καταχωρεί αυτόματα στον pos00_01 και το κάνει επιλογή στο combo box
         * 
         */
        if($response_arr["count"] == 1){
            $pos00_05 = array();
            pegasus_mysql_use("SELECT * FROM pos00_05 WHERE nr01 = :nr01", $pos00_05, array('nr01' => $pos00_05_nr01));
            $update = array(
                'mellv2_pos00_05'   => $pos00_05['nr01'],
                'tidnsp'            => $pos00_05['tid']
            );
            pegasus_mysql_update(
                'pos00_01',
                array_keys($update),
                array_values($update),
                'nr01 = :nr01',
                1,1,1,
                array('nr01' => $pos00_01_nr01)
            );
            $result['pos00_05'] = array(
                'value'     => $pos00_05['nr01'],
                'display'   => $pos00_05['description']
            );
            $result['pos00_05_tid'] = $pos00_05['tid'];
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_success_one_pos_found'];
        }
        return $result;
    }
    /**
     *
     * @param  int $pos00_01_nr01
     * @return array
     */
    function pos00_mellv2_refresh_token(
        $pos00_01_nr01,
        $log_p_sign = ''
    ){
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01,true);
        $service_url = '/token/refresh/';
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url_refresh = $pos00_mellv2_get_url.$service_url;
        $mellv2_refreshtoken = pegasus_mysql_printfld('pos00_01', 'mellv2_refreshtoken', 'nr01=?', array($pos00_01_nr01)); 
        if(empty($mellv2_refreshtoken)){
            //Θεωρητικά, δεν πρέπει να μπει ποτέ εδώ
            die("Το refresh token ειναι κενό");
        }
        $data = array('refresh' => $mellv2_refreshtoken);
        try {
            $response_refreshtk = pegasus_curl_request_post(
                $url_refresh,
                json_encode($data),
                false,
                array(
                    'Content-Type: application/json',
                    'Accept: application/json'
                ),
                array(),
                true
            );
        } catch (Exception $exc) {
            $msg = "Exception " . $exc->getMessage();
            pos00_add_to_log(
                'mellon:refresh-token',
                array(),
                $msg, 
                $url_refresh
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $response_arr = json_decode($response_refreshtk['response'], true);
        if($response_arr === NULL){ 
            $msg = str_replace(
                '#response#', 
                $response_refreshtk['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url_refresh,
                "pos00_mellv2_set_token:json_decode",
                $msg,
                array(),
                $response_refreshtk,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        pos00_add_to_log(
            'mellon:refresh-token',
            array(),
            array(), 
            $url_refresh
        );
        if(empty($response_arr["access"])){
            $msg = $_SESSION['peg_dic_pos00_pos00_01_fail_find_refresh_token'];
            /**
             * Αν κάτι δεν πάει καλά και δεν μπορεί να πάρει νέο token από 
             * το refresh token τότε θα πρέπει να δοκιμάσει να ξανά κάνει 
             * login (get token).
             * πχ. Στην περίπτωση expired refresh token.
             */
            return pos00_mellv2_set_token(
                $pos00_01_nr01,
                $log_p_sign
            );
        }
        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_refresh_token'];
        $mellv2_token = $response_arr["access"];
        pegasus_mysql_update(
            'pos00_01',
            array('mellv2_token'),
            array($mellv2_token),
            'nr01=:nr01',
            1, 1, 1,
            array('nr01'=> $pos00_01_nr01)
        );
        return array(
            'ok'    => 1,
            'msg'   => $msg
        );
    }
    /**
     * Στέλνει μί αίτηση πληρωμής στο pos
     * @param mixed $pos00_04_nr01 
     * @param mixed $amount 
     * @param bool $called_after_refresh 
     * @return mixed 
     */
    function pos00_mellv2_send_transaction($pos00_04_nr01, $amount, $called_after_refresh = false){
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        pegasus_mysql_use("select * from pos00_05 where nr01 = ?", $pos00_05, array($pos00_01["mellv2_pos00_05"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }
        $data_token = pos00_mellv2_get_token($pos00_01_nr01, $log_p_sign);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01);
        $service_url = '/terminal/'.$pos00_05["id"].'/txninit/';
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url = $pos00_mellv2_get_url.$service_url;
        $transaction_type = 0;
        if($kodikos_pistosis < 0){
            $transaction_type = 1; //refund
        }
        if(!empty($pos00_04['mailphone'])) {
            $transaction_type = 4; // Mail order/Telephone order
        }
        $pos00_04_type = 1; // Sale
        if($transaction_type == 1) {
            $pos00_04_type = 2; // Refund
        }
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $pegasus_reference = $pos00_04_nr01 . date("YmdHis");
        pegasus_mysql_update("pos00_04", array("p03", "type", "descr"), array($pegasus_reference, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
        /**
         * E:10001830
         * Προσθέσαμε cast σε όλα τα πεδία του txninit με βαση το https://aade.mellongroup.com/Portals/0/Library/EFTPOS-WebECR%20v2.5.10.pdf?ver=j-7iPbQp2zwQvsH2EJiAtQ%3D%3D σελ. 10
         * αλλιώς έχουμε error στα int πεδία από την Nexi (Android // SoftPOS)
         */
        $data = array(  
            "TxnType"           => (int)  $transaction_type,
            "Amount"            => (int) round($amount*100), 
            "TipAmount"         => (int) 0, 
            "CurrencyCode"      => (int) 978,
            "CustomerReference" => (string) $pegasus_reference
            //, "CustomerEmail" => 'f.psarra@tesae.com', 
            // "CustomerPhone" => '6948686468'
            /*,"Timeout"  => 20*/
        );
        if($pos00_04['profortosi']){
            $data['PreloadTransaction'] = true;
            $data['PreloadExpiration'] = (int) 1440; //TODO: Να δούμε πόσα λεπτά χρειάζεται να βάλω στην προφόρτωση
        }
        // Αριθμός Δόσεων αν είναι συμπληρωμένος. //? Εδώ περνάνε και τα 0 και τα αρνητικά στο API τους.
        if($pos00_04['instalments'] > 0) {
            $data['Instalments'] = (int) $pos00_04['instalments'];
        }
    
        // Αν έχω επιστροφή και συμπληρωμένο initial transaction id
        if($transaction_type == 1 && !empty($pos00_04['txnidinit'])) {
            $data['InitialTransaction'] = (string) $pos00_04['txnidinit']; 
        }
        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19  where nr01 = ?", $t19, array($pos00_04['t19']));  
            $p_sign_s = $t19['p_sign_s']; //Το μήνυμα της υπογραφής
            $p_sign_s_arr = explode(";", $p_sign_s);
            $povider_data = [
                "Uid"  => (string) $p_sign_s_arr["0"],
                "Mark"  => (string) empty($p_sign_s_arr["1"])?null:$p_sign_s_arr["1"],
                "SignatureTimestamp"  => (string) $p_sign_s_arr["2"],
                "NetAmount"  => (int) $p_sign_s_arr["3"],
                "VatAmount"  => (int) $p_sign_s_arr["4"],
                "TotalAmount" => (int) $p_sign_s_arr["5"],
                "ProviderId" => (string) "016",
                "Signature"  => (string) bin2hex(base64_decode($t19['p_sign']))
            ];
            if($pos00_01['mellv2_bnk'] == 8) {
                $povider_data['ProviderId'] = (int) 16;
                $povider_data['Signature'] = (string) $t19['p_sign'];
            }
            $data["ProviderData"] = $povider_data;
        }
        $request = array(
            'header'    =>  array(
                'Content-Type: application/json', 
                'X-Api-Key: ' . $pos00_01['mellv2_api_key'],
                'Authorization: Bearer ' . $data_token['mellv2_token']
            ),
            'data' => $data
        );
        try {
            $txinit_resp = pegasus_curl_request_post(
                $url, 
                json_encode($request['data']),
                false, 
                $request['header'], 
                array(), 
                true
            );
           
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_mellv2_send_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                $request['data'],
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'mellon:send-transaction',
                $data,
                'JSON: '.$exc->getMessage(), 
                $url
            );
            return $result;
        }
        pos00_add_to_log(
            'mellon:send-transaction',
            $data,
            $txinit_resp['response'], 
            $url
        );
        if($txinit_resp["http_code"] == 401 and $called_after_refresh == false){
            $res_refresh = pos00_mellv2_refresh_token($pos00_01_nr01, $log_p_sign);
            if($res_refresh['ok'] == 0){
                pos00_add_external_log(
                    $url,
                    "pos00_mellv2_send_transaction:pos00_mellv2_refresh_token",
                    "Δεν είναι δυνατή η αποστολή πληρωμής (http_code 401)",
                    $request['data'],
                    array(
                        'pos00_mellv2_send_transaction' => $txinit_resp,
                        'pos00_mellv2_refresh_token'    => $res_refresh
                    ),
                    true,
                    $log_p_sign
                );
                return $res_refresh;
            }
            return pos00_mellv2_send_transaction($pos00_04_nr01, $amount, true);
        }
        else if($txinit_resp["http_code"] == 401){
            $result['ok'] = 0;
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key'];
            pos00_add_external_log(
                $url,
                "pos00_mellv2_send_transaction:http_code:401",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        $response_arr2 = json_decode($txinit_resp['response'], true);
        if($response_arr2 === NULL || $txinit_resp['http_code'] != 200){
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $txinit_resp['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url,
                "pos00_mellv2_send_transaction:http_code:{$txinit_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        if($response_arr2["status"] == "invald_authorization_code"){
            $result['ok'] = 0;
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_wrong_auth_code'];
            pos00_add_external_log(
                $url,
                "pos00_mellv2_send_transaction:invald_authorization_code",
                $result['msg'],
                $request['data'],
                $response_arr2,
                true,
                $log_p_sign
            );
            return $result;
        }
        if(empty($response_arr2["Id"])){
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $response_arr2,
                $_SESSION['peg_dic_pos00_pos00_01_fail_transanction']
            );
            pos00_add_external_log(
                $url,
                "pos00_mellv2_send_transaction:IdError",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        //03/06/2024 - Προσθέτω και το νέο txnid
        pegasus_mysql_update('pos00_04', array('p01', 'txnid'), array($response_arr2["Id"], $response_arr2['Transaction']), "nr01 = ? ", 0, 1, 1, array($pos00_04_nr01));
        pos00_add_external_log(
            $url,
            "pos00_mellv2_send_transaction:success",
            "Επιτυχής εκτέλεση πληρωμής",
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );
        return  array(
            'ok'  =>  1,
            'msg'  =>  str_replace(
                '#id#',
                $response_arr2["id"],
                $_SESSION['peg_dic_pos00_pos00_01_success_tx']
            )
        );
    }
    /**
     * Ελέγχει αν η πληρωμή ολοκληρώθηκε καλώντας την την https://uat.mreceipts.com/api/v2/transactionintent/{ID} και έπειτα την https://uat.mreceipts.com/api/v2/transaction/{txID} 
     * @param mixed $pos00_04_nr01 
     * @param bool $called_after_refresh 
     * @return mixed 
     */
    function pos00_mellv2_check_transaction($pos00_04_nr01, $called_after_refresh = false){
        $result = array(
            "ok" => 0, 
            "msg" => "", 
            "pending" => 0  //Αν είναι pending, δεν πρέπει να κλείσει την οθόνη
        ); 
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }
        
        $data_token = pos00_mellv2_get_token($pos00_01_nr01,$log_p_sign);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01);
        $service_url = '/transactionintent/?CustomerReference='.$pos00_04['p03'];
        /**
         * E:10001830
         * Αν ο Acquirer είναι Nexi Android // SoftPOS δεν υποστηρίζει το φίλτρο 
         * οπότε κάνουμε get single record (by Id).
         */
        if($pos00_01['mellv2_bnk'] == 8){
            $service_url = '/transactionintent/'.$pos00_04['p01'];
        }
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url = $pos00_mellv2_get_url.$service_url;
        try {
            $request = array(
               'headers'    =>  array(
                    'X-Api-Key: ' . $pos00_01['mellv2_api_key'],
                    'Authorization: Bearer ' . $data_token['mellv2_token']
                )
            );
            $txintent_resp = pegasus_curl_request(    
                $url, 
                false, 
                $request['headers'], 
                array(
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_FOLLOWLOCATION => true
                ), 
                true
            );
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_mellv2_check_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                array(),
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'mellon:check-transaction',
                null,
                'JSON: '.$exc->getMessage(), 
                $url
            );
            return $result;
        }
        pos00_add_to_log(
            'mellon:check-transaction',
            null,
            $txintent_resp['response'], 
            $url
        );
        
        if($txintent_resp["http_code"] == 401 and $called_after_refresh == false){
            $res_refresh = pos00_mellv2_refresh_token($pos00_01_nr01);
            if($res_refresh['ok'] == 0){
                pos00_add_external_log(
                    $url,
                    "pos00_mellv2_check_transaction:pos00_mellv2_refresh_token",
                    "Δεν είναι δυνατή η εκτέλεση ελέγχου πληρωμής (HTTP 401)",
                    array(),
                    array(
                        'pos00_mellv2_check_transaction'    => $txintent_resp,
                        'pos00_mellv2_refresh_token'        => $res_refresh
                    ),
                    true,
                    $log_p_sign
                );
                return $res_refresh;
            }
            return pos00_mellv2_check_transaction($pos00_04_nr01, true);
        }
        else if($txintent_resp["http_code"] == 401){
            $result['ok'] = 0;
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key'];
            pos00_add_external_log(
                $url,
                "pos00_mellv2_check_transaction:http_code:401",
                $result['msg'],
                array(),
                $txintent_resp,
                true,
                $log_p_sign
            );
            return $result;
        }

        $response_arr2 = json_decode($txintent_resp['response'], true);
        $transactionintent = $response_arr2['results'][0]??array();
        /**
         * E:10001830
         * Αν ο Acquirer είναι Nexi Android // SoftPOS κανουμε get single 
         * record (by Id) και εχει αλλο response
         */
        if($pos00_01['mellv2_bnk'] == 8){
            $transactionintent = $response_arr2??array();
        }
        if(
            $txintent_resp['http_code'] != 200
            || empty($transactionintent)
        ){
            $result['ok']  = 0;
            $result['msg'] = str_replace(
                '#response#',
                "",
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );

            $result['msg'] .= " "."Δεν βρέθηκε η πληρωμή.";

            pos00_add_external_log(
                $url,
                "pos00_mellv2_check_transaction:http_code:{$txintent_resp['http_code']}",
                $result['msg'],
                array(),
                $txintent_resp,
                true,
                $log_p_sign
            );

            return $result;
        }
        $response_arr2 = $transactionintent;
        /**
         * Intent status
         * The possible values for the intent status are:
         * 1: PENDING - Intent has been registered to the backend and is pending to be sent to the device
         * 2: SENT - Intent has been sent to the device
         * 3: COMPLETED - Intent has been successfully completed by the device and has registered the results
         * */
        if(empty($response_arr2["Status"]) || empty($response_arr2["Result"])){
            $result['ok']  = 0;
            $result['msg'] = str_replace(
                '#response#',
                "",
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            
            $result['msg'] .= " "."Δεν βρέθηκε η πληρωμή.";

            pos00_add_external_log(
                $url,
                "pos00_mellv2_check_transaction:StatusResultError",
                $result['msg'],
                array(),
                $response_arr2,
                true,
                $log_p_sign
            );

            return $result;   
        }
        if($response_arr2["Status"] == 1){
            $result['ok']       = 0;
            $result["pending"]  = 1; 
            $result['msg']      = "Η πληρωμή είναι σε κατάσταση: PENDING";
            //Δεν το χρειάζομαι αυτό το log
            //pos00_add_external_log( $url, "pos00_mellv2_check_transaction:StatusError", $result['msg'], $request, $response_arr2, true, $log_p_sign);
            return $result;   
        }
        /**
         * Ε: 10001355 Δ: 10169584
         * Αλλαγή στον τρόπο διαχείρισης των επιτυχών μηνυμάτων προφόρτωσης Status  = 2 (SEND)
         * 
         */
        if($response_arr2["Status"] == 2) {
            if($pos00_04["profortosi"] == 1) {
                return array(
                    'ok'        => 1,
                    'pending'   => 0,
                    'msg'       => $_SESSION["peg_dic_pos00_mellon_status_sent_profortosi"],
                    'dbg'       => $response_arr2
                );
            } else {
                return array(
                    'ok'        => 0,
                    'pending'   => 1,
                    'msg'       => $_SESSION["peg_dic_pos00_mellon_status_sent"]
                );
            }
        }
        
        $expected_results = [
            "1" => "APPROVED - The transaction has been completed and approved by the authorization system", 
            "2" => "DECLINED - The transaction has been completed and declined by the authorization system", 
            "3" => "CANCELLED - The transaction has been cancelled by the POS user before reaching completion", 
            "4" => "FAILED - The transaction has failed to complete", 
            "5" => "UNKNOWN - The transaction result is unknown. Only possible if the device hasn't responded with resuls", 
            "6" => "BUSY - The transaction has failed because the POS is currently unavailable for transactions (either processing another transaction or under maintenance)", 
            "7" => "MAX_TRANSACTIONS - The POS device has reached its transaction limit for the specific batch. Batch closing should be performed on the device before continuing transactions"
        ];


        
        if($response_arr2["Result"] != 1){ //Transaction failed
            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01, 
                $pos00_04['p01']
            );
    
            return $pos_complete->on_failed_payment($expected_results[$response_arr2["Result"]]);
        }
        
        $transaction_res = pos00_mellv2_get_transaction(
            $pos00_04_nr01, $response_arr2["Transaction"], $called_after_refresh
        );
        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01, 
            $pos00_04['p01'],
            $transaction_res['data']['Amount']/100, 
            $transaction_res['data']['TipAmount']/100, 
            $response_arr2['TransactionId'], // 03/06/2024 Αλλάξαμε το $response_arr2["Transaction"]. Δίνουμε αυτό με τα χωρισμένα ;
            $response_arr2['Transaction'] // To transaction id της συναλλαγής του POS. Το αποθηκεύουμε στο pos00_04.txnid
        );

        pos00_add_external_log(
            $url,
            "pos00_mellv2_check_transaction:success",
            "Ο έλεγχος πληρωμής εκτελέστηκε με επιτυχία",
            array(),
            $response_arr2,
            false,
            $log_p_sign
        );

        return $pos_complete->on_successful_payment();
    }

    function pos00_mellv2_get_transaction(
        $pos00_04_nr01,
        $transaction_id,
        $called_after_refresh = false
    ) {
        $result = array(
            'ok' => 1,
            'msg' => '', 
            'data' => array()
        );
        
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));

        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }

        $data_token = pos00_mellv2_get_token($pos00_01_nr01);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
        $pos00_mellv2_get_url = pos00_mellv2_get_url($pos00_01_nr01);
        $service_url = '/transaction/' . $transaction_id;
        if(empty($pos00_mellv2_get_url)) {
            $msg = $_SESSION['peg_dic_pos00_mellv2_no_bnk'];
            pos00_add_external_log(
                $service_url,
                "pos00_mellv2_get_transaction:pos00_mellv2_get_url",
                $msg,
                array('pos00_01_nr01' => $pos00_01_nr01),
                array(),
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $url_transaction = $pos00_mellv2_get_url.$service_url;

        $request = array(
            'headers' => array(
                'X-Api-Key: ' . $pos00_01['mellv2_api_key'],
                'Authorization: Bearer ' . $data_token['mellv2_token']
            )
        );
        try {
            $tx_resp = pegasus_curl_request(
                $url_transaction,
                false,
                $request['headers'],
                array(
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_FOLLOWLOCATION => true
                ),
                true
            );
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url_transaction,
                "pos00_mellv2_get_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                array(),
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'mellon:get-transaction',
                null,
                'JSON: ' . $exc->getMessage(), 
                $url_transaction
            );
            return $result;
        }
        pos00_add_to_log(
            'mellon:get-transaction',
            null,
            $tx_resp['response'], 
            $url_transaction
        );

        if ($tx_resp["http_code"] == 401 and $called_after_refresh == false) {
            $res_refresh = pos00_mellv2_get_transaction(
                $pos00_04_nr01,
                $transaction_id,
                true
            );
            if ($res_refresh['ok'] == 0) {
                return $res_refresh;
            }
            return pos00_mellv2_check_transaction($pos00_04_nr01, true);
        } else if ($tx_resp["http_code"] == 401) {
            $result['ok'] = 0;
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key'];
            pos00_add_external_log(
                $url_transaction,
                "pos00_mellv2_get_transaction:http_code:401",
                $result['msg'],
                array(),
                $tx_resp,
                true,
                $log_p_sign
            );
            return $result;
        }

        $response_arr2 = json_decode($tx_resp['response'], true);
        if ($response_arr2 === NULL || $tx_resp['http_code'] != 200) {
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $tx_resp['http_code'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url_transaction,
                "pos00_mellv2_get_transaction:http_code:{$tx_resp['http_code']}}",
                $result['msg'],
                array(),
                $tx_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        $result['data'] = $response_arr2;
        pos00_add_external_log(
            $url_transaction,
            "pos00_mellv2_get_transaction:success",
            "Επιτυχής παραλαβή transaction από mellon",
            array(),
            $response_arr2,
            false,
            $log_p_sign
        );
        return $result;
    }

        /**
     * Στέλνει μί αίτηση πληρωμής στο pos
     * @param mixed $pos00_04_nr01 
     * @param mixed $amount 
     * @param bool $called_after_refresh 
     * @return mixed 
     */
    function pos00_neosoft_send_transaction($pos00_04_nr01, $amount){

        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        pegasus_mysql_use("select * from pos00_05 where nr01 = ?", $pos00_05, array($pos00_01["mellv2_pos00_05"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));

        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }

        if(!empty($_SESSION['cor011_pos00_neosoft_url'])){
            $url = $_SESSION['cor011_pos00_neosoft_url'];
            $cert_path = "../../nsf-api-tesae.test.pfx";
            $cert_pass = "tesae@nsf";
        }else{
            $url = "https://gw1.neopayments.gr";
            $cert_path = "../pos00_00/nsf-api-TESAE.prod.pfx";
            $cert_pass = "T3SAe!@nsF";
        }
        $service_url = "/cpr-orders/ws/erp/cprcreate";
        $url = $url . $service_url; 

        /**
         * NEOSOFT TRANSACTION TYPES
         *  020000: Sale
         *  020002: Void Sale
         *  020020: Refund
         *  020022: Void Refund
         *  010000: Pre-authorization
         *  010002: Void Pre-authorization
         *  022000: Post-authorization (capture)
         */
        $transaction_type = "020000";
        if($kodikos_pistosis < 0){
            $transaction_type = "020020"; //refund
        }

        $pos00_04_type = 1; // Sale
        if($transaction_type == "020020") {
            $pos00_04_type = 2; // Refund
        }
        //! Δεν παίρνουν υπογραφή στο void, λογικά δεν το υλοποιούμε.
        // elseif($transaction_type == "020002" || $transaction_type == "020022") { //TODO να δούμε στην πράξη το Void Refund, δεν ξερω αν το καλύπτουμε
        //     $pos00_04_type = 3; // Void
        // }
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $pegasus_reference = $pos00_04_nr01 . date("YmdHis");
        pegasus_mysql_update("pos00_04", array("p03", "type", "descr"), array($pegasus_reference, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));

        $amount = round($amount*100);
        // Δημιουργία digest
        // Είναι το md5 του shared key που δίνουν από τη Neosoft
        $mac_seed = md5($pos00_01['neosoft_mac_seed'], true);
        $hmac_data = $transaction_type . sprintf('%012d', $amount) . $pos00_01['neosoft_store_id'] . $pegasus_reference;
        // echo '<pre>' .$hmac_data. '</pre>';
        $digest = hash_hmac('sha256', $hmac_data, $mac_seed);

        $data = array(  
            "txn_type"  =>  $transaction_type,
            "store_id" => $pos00_01['neosoft_store_id'],
            "pos_id" => $pos00_01['tidnsp'],
            // "user_id" => '',
            "order_id" => $pegasus_reference,
            "amount"  =>  $amount, 
            "payment_plan"  =>  "0100",  //είναι standard
            "digest" => $digest
        );

        if($pos00_04['profortosi']){
            //TODO 
        }
        
        // Αν έχω επιστροφή και συμπληρωμένο initial transaction id
        //TODO ???
        if($transaction_type == "020020" && !empty($pos00_04['txnidinit'])) {
            // $data['InitialTransaction'] = $pos00_04['txnidinit']; //TODO Έχω σημειώσει ερώτηση, δεν ξέρω το πεδίο του request.
            //* Update: Δεν ελέγχουν προηγούμενη συναλλαγή στο refund.
        }

        
        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19  where nr01 = ?", $t19, array($pos00_04['t19']));  
            $p_sign_s = $t19['p_sign_s']; //Το μήνυμα της υπογραφής
            $p_sign_s_arr = explode(";", $p_sign_s);
            
            $povider_data = [
                "provider" => "016",
                "payload" => $p_sign_s,
                "uid"  => $p_sign_s_arr["0"],
                "mark"  => empty($p_sign_s_arr["1"]) ? "''" : $p_sign_s_arr["1"],
                "time"  => $p_sign_s_arr["2"],
                "amt_net"  => $p_sign_s_arr["3"],
                "amt_vat"  => $p_sign_s_arr["4"],
                "amt_tot" => $p_sign_s_arr["5"],
                
                "esig"  => bin2hex(base64_decode($t19['p_sign']))
            ];
            $data["einvoice"] = $povider_data;
        }
        $request = array(
            'header'    =>  array(
                'Content-Type: application/json'
            ),
            'data' => $data
        );

        // echo '<pre>' .$url. '</pre>';
        // echo '<pre>' .$curl_port. '</pre>';
        // echo '<pre>' .print_r($data, 1). '</pre>';
        // return array(
        //     'ok' => 0,
        //     'msg' => 'test'
        // );

        //* Παίζει και το .pfx δεν χρειάζεται να το κάνουμε convert σε pem.
        $curl_options = array(
            CURLOPT_SSLCERTTYPE => 'P12',
            CURLOPT_SSLCERT => $cert_path,
            CURLOPT_SSLCERTPASSWD => $cert_pass,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        );
        try {
         
            $txinit_resp = pegasus_curl_request_post(
                $url, 
                json_encode($request['data']),
                false, 
                $request['header'], 
                $curl_options, 
                true
            );
            // echo '<pre>' .$url. '</pre>';
            // echo '<pre>' .print_r($txinit_resp, 1). '</pre>';
            // return array(
            //     'ok' => 0,
            //     'msg' => 'test'
            // );
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_neosoft_send_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                $request['data'],
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'neosoft:send-transaction',
                $data,
                'JSON: '.$exc->getMessage(), 
                $url
            );
            return $result;
        }
        pos00_add_to_log(
            'neosoft:send-transaction',
            $data,
            $txinit_resp['response'], 
            $url
        );

        // RESPONSE CODES
        // 201: Success, CPR created
        // 400: Bad request – invalid digest or invoice provider/signature
        // 401: Forbidden – invalid client TLS certificate
        // 404: Store/POS not found
        // 429: Pending request for the EFT/POS exists
        // 503: Internal service error
        switch ($txinit_resp["http_code"]) {
            case 401:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "401: Forbidden - invalid client TLS certificate";
                break;
            case 400:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "400: Bad request - invalid digest or invoice provider/signature";
                break;
            case 403:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "403: Forbidden - invalid invoice provider/signature"; //* Εγώ το έχω γράψει αυτό, δεν το αναφέρουν στο docu.
                break;
            case 404:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "404: Store/POS not found";
                break;
            case 429:
                //* Αν ξαναστείλω συναλλαγή που έχει ήδη σταλεί, επιστρέφει αυτό.
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "429: Pending request for the EFT/POS exists";
                break;
            case 503:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "401: Forbidden - invalid client TLS certificate";
                break;
        }
        
        if($txinit_resp['http_code'] != 201) {
            pos00_add_external_log(
                $url,
                "pos00_neosoft_send_transaction:http_code:{$txinit_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        
        $response_arr2 = json_decode($txinit_resp['response'], true);

        // print_r($response_arr2);
        if(/*$response_arr2 === NULL ||*/ $txinit_resp['http_code'] != 201){
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $txinit_resp['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            pos00_add_external_log(
                $url,
                "pos00_neosoft_send_transaction:http_code:{$txinit_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        //03/06/2024 - Προσθέτω και το νέο txnid
        // Στη neosoft δεν παίρνω απάντηση από το cprcreate, δεν κάνω κάτι update.
        // pegasus_mysql_update('pos00_04', array('p01', 'txnid'), array($response_arr2["Id"], $response_arr2['Transaction']), "nr01 = ? ", 0, 1, 1, array($pos00_04_nr01));
        pos00_add_external_log(
            $url,
            "pos00_neosoft_send_transaction:success",
            "Επιτυχής αποστολή πληρωμής",
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );
        return  array(
            'ok'  =>  1,
            'msg'  =>  str_replace(
                '#id#',
                $pegasus_reference, //TODO δεν είμαι απόλυτα σίγουρος, αλλά εξυπηρετεί.
                $_SESSION['peg_dic_pos00_pos00_01_success_tx']
            )
        );
    }

    function pos00_neosoft_check_transaction($pos00_04_nr01){

        //TODO ???
        $result = array(
            "ok" => 0, 
            "msg" => "", 
            "pending" => 0  //Αν είναι pending, δεν πρέπει να κλείσει την οθόνη
        ); 
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }

        if(!empty($_SESSION['cor011_pos00_neosoft_url'])){
            $url = $_SESSION['cor011_pos00_neosoft_url'];
            $cert_path = "../../nsf-api-tesae.test.pfx";
            $cert_pass = "tesae@nsf";
        }else{
            $url = "https://gw1.neopayments.gr";
            $cert_path = "../pos00_00/nsf-api-TESAE.prod.pfx";
            $cert_pass = "T3SAe!@nsF";
        }
        /**
         * Το δοκιμάζω αρχικά με false, ίσως το true βολεύει καλύτερα.
         * $sync => Boolean value:
         *   false: asynchronous mode, response return immediately with current state
         *   true: synchronous/blocking mode, response returns with final transaction state
         */
        $service_url = "/cpr-orders/ws/erp/cprstatus/".$pos00_01['neosoft_store_id']."/".$pos00_01['tidnsp']."/".$pos00_04['p03']."/false";
        $url = $url . $service_url; 
        
        $curl_options = array(
            CURLOPT_SSLCERTTYPE => 'P12',
            CURLOPT_SSLCERT => $cert_path,
            CURLOPT_SSLCERTPASSWD => $cert_pass,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false
        );
        
        try {
            $request = array(
                'header'    =>  array(
                    'Content-Type: application/json'
                ),
            );
            $txintent_resp = pegasus_curl_request(    
                $url, 
                false, 
                $request['headers'], 
                $curl_options, 
                true
            );
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_neosoft_check_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                $request,
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'neosoft:check-transaction',
                null,
                'JSON: '.$exc->getMessage(), 
                $url
            );
            return $result;
        }
        pos00_add_to_log(
            'neosoft:check-transaction',
            null,
            $txintent_resp['response'], 
            $url
        );
        

        switch ($txintent_resp["http_code"]) {
            case 404:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "404: CPR not found";
                break;
            case 503:
                $result['ok'] = 0;
                $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_cant_call_api_key']; //TODO Αλλαγή λεκτικού
                $result['msg'] = "503: Internal service error";
                break;
        }

        if($txintent_resp['http_code'] != 200) {
            pos00_add_external_log(
                $url,
                "pos00_neosoft_check_transaction:http_code:{$txintent_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $txintent_resp,
                true,
                $log_p_sign
            );
            return $result;
        }

        $response_arr2 = json_decode($txintent_resp['response'], true);
        if(
            $response_arr2 === NULL 
            || empty($response_arr2)
        ){
            $result['ok']  = 0;
            $result['msg'] = str_replace(
                '#response#',
                "",
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );

            pos00_add_external_log(
                $url,
                "pos00_neosoft_check_transaction:http_code:{$txintent_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $txintent_resp,
                true,
                $log_p_sign
            );

            return $result;
        }

        /**
          *  The key response field is “status”. The list of possible values is:
          *   I => initial, just created (transient)
          *   P => in POS processing (transient)
          *   s => successful (transient, for authorizations)
          *   S => successful (final, completed)
          *   F => declined (final)
          *   V => successfully canceled (final)
          *   R => reversed (connection/network error) (final)
          *   X => transaction communication error (final, exception!) 
          *   T => timeout (more than 180sec, configuration item) (final, abort)
         * */
        // if(empty($response_arr2["Status"]) || empty($response_arr2["Result"])){
        //     $result['ok']  = 0;
        //     $result['msg'] = str_replace(
        //         '#response#',
        //         "",
        //         $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
        //     );

        //     pos00_add_external_log(
        //         $url,
        //         "pos00_status_check_transaction:StatusResultError",
        //         $result['msg'],
        //         $request,
        //         $response_arr2,
        //         true,
        //         $log_p_sign
        //     );

        //     return $result;   
        // }
        if($response_arr2["status"] == "I" || $response_arr2["status"] == "P"){
            $result['ok']       = 0;
            $result["pending"]  = 1; 
            $result['msg']      = "Η πληρωμή δεν έχει ολοκληρωθεί ακόμη";
            pos00_add_external_log(
                $url,
                "pos00_neosoft_check_transaction:StatusError", //TODO ??? Γιατί StatusError στο external log το pending???
                $result['msg'],
                $request['data'],
                $response_arr2,
                true,
                $log_p_sign
            );
            return $result;   
        }
        //TODO
        //TODO
        //TODO KEEP IN MIND ΚΑΠΟΥ ΕΔΩ ΘΑ ΠΡΕΠΕΙ ΝΑ ΔΙΑΧΕΙΡΙΣΤΕΙ ΚΑΙ Η ΠΡΟΦΟΡΤΩΣΗ.
        //TODO
        //TODO

        // * Τα final result states (δεν συμπεριλαμβάνω τα transient)
        //* Σχολιάζω το V γιατί αν το υλοποιήσουμε θα θέλει διαφορετική αντιμετώπιση.
        $expected_results = [
            "S" => "Successful (final, completed)",
            "F" => "Declined (final)",
            // "V" => "successfully canceled (final)",
            "R" => "Reversed (connection/network error) (final)",
            "X" => "Transaction communication error (final, exception!) ",
            "T" => "Timeout (final, abort)"
        ];


        
        if($response_arr2["status"] != "S"){ //Transaction failed
            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01, 
                $pos00_04['p01']
            );
    
            return $pos_complete->on_failed_payment($expected_results[$response_arr2["status"]]);
        }
        
        // $transaction_res = pos00_mellv2_get_transaction(
        //     $pos00_04_nr01, $response_arr2["Transaction"], $called_after_refresh
        // );

        $tip = 0;
        // Το γράφω έτσι για ασφάλεια γιατί στο demo δεν είχαμε tip στην απάντηση.
        if(isset($response_arr2['tip']) && !empty($response_arr2['tip'])) {
            $tip = $response_arr2['tip'];
        }

        //TODO Εδώ διαβάζω το response του success και ενημερώνω αντίστοιχα.
        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01, 
            $response_arr2['rrn'], //* Retrieval Reference Number
            $pos00_04['amount'], //* Δεν το επιστρέφει στο response, το δίνω όπως το έχω στην κίνηση
            $tip, //TODO Να τους ρωτήσω αν επιστρέφουν το TIP στο response, δεν το γράφει στο docu - Βάζω 0
            $response_arr2['idkey'], // Μοναδική Ταυτότητα Πληρωμής
            $response_arr2['order_id'] // Το Pegasus Reference που έδωσα ως Order Id.
        );

        pos00_add_external_log(
            $url,
            "pos00_neosoft_check_transaction:success",
            "Ο έλεγχος πληρωμής εκτελέστηκε με επιτυχία",
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );

        return $pos_complete->on_successful_payment();
    }

    function pos00_neosoft_health_check($pos00_01_nr01) {
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));

        if(!empty($_SESSION['cor011_pos00_neosoft_url'])){
            $url = $_SESSION['cor011_pos00_neosoft_url'];
            $cert_path = "../../nsf-api-tesae.test.pfx";
            $cert_pass = "tesae@nsf";
        }else{
            $url = "https://gw1.neopayments.gr";
            $cert_path = "../pos00_00/nsf-api-TESAE.prod.pfx";
            $cert_pass = "T3SAe!@nsF";
        }
        $service_url = "/cpr-orders/ws/erp/cprfunc";
        $url = $url . $service_url; 

        $data = array(  
            "func"  =>  "0800", //health check
            "store_id" => $pos00_01['neosoft_store_id'],
            "pos_id" => $pos00_01['tidnsp']
            // "user_id" => ''
        );

        $request = array(
            'header'    =>  array(
                'Content-Type: application/json'
            ),
            'data' => $data
        );

        //* Παίζει και το .pfx δεν χρειάζεται να το κάνουμε convert σε pem.
        $curl_options = array(
            CURLOPT_SSLCERTTYPE => 'P12',
            CURLOPT_SSLCERT => $cert_path,
            CURLOPT_SSLCERTPASSWD => $cert_pass,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_SSL_VERIFYHOST => false,
            CURLOPT_TIMEOUT => 20
        );
        try {
         
            $health_check_resp = pegasus_curl_request_post(
                $url, 
                json_encode($request['data']),
                false, 
                $request['header'], 
                $curl_options, 
                true
            );
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $url,
                "pos00_neosoft_health_check:curl:{$exc->getCode()}",
                $result['msg'],
                $request['data'],
                $result,
                true
            );
            pos00_add_to_log(
                'neosoft:health-check',
                $data,
                'JSON: '.$exc->getMessage(), 
                $url
            );

            $ok = 0;
            $msg = "Η επικοινωνία με τη συσκευή δεν ήταν επιτυχής.";

            return array(
                'ok' => $ok,
                'msg' => $msg
            );
        }

        pos00_add_to_log(
            'neosoft:health-check',
            $data,
            $health_check_resp['response'], 
            $url
        );

        $health_check_resp_res= json_decode($health_check_resp['response'], true);

        if($health_check_resp['http_code'] == 200) {
            if($health_check_resp_res['status'] != "S") {
                $ok = 0;
                $msg = 'Πραγματοποιήθηκε επικοινωνία με τη συσκευή αλλά το αποτέλεσμα δεν ήταν επιτυχές';
            }else{
                $ok = 1;
                $msg = 'Η επικοινωνία με τη συσκευή πραγματοποιήθηκε επιτυχώς.';
            }
        }else{
            $ok = 0;
            $msg = "Η επικοινωνία με τη συσκευή δεν ήταν επιτυχής.";

            $result['ok'] = 0;
            $result['msg'] = "Η επικοινωνία με τη συσκευή δεν ήταν επιτυχής.";
            pos00_add_external_log(
                $url,
                "pos00_neosoft_health_check:http_code:{$health_check_resp['http_code']}",
                $result['msg'],
                $request['data'],
                $result,
                true
            );
        }


        return array(
            'ok' => $ok,
            'msg' => $msg
        );
    }
    function pos00_cardlink_v2_check_before_prepare_transaction($pos00_04_nr01, $type){
        $response = array(
            'ok'   =>  1,
            'msg'  =>  '',
            'data' => array()
        );
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        if($type == "registerReceipt10"){
            //Ψάχνω να βρω αν για το ίδιο παραστατικό έχω και άλλη προφορτωμένη σε εκκρεμότητα(μη άκυρη και χωρίς μοναδική ταυτότητα πληρωμής)
            $query = 
            "SELECT  count(*) as cc, 
                GROUP_CONCAT(pos00_04.nr01) as perigrafi
                FROM pos00_04 
                LEFT JOIN t19 ON t19.nr01 = pos00_04.t19
                WHERE pos00_04.profortosi=1 AND pos00_04.nr01<>? AND pos00_04.p02=0 AND IFNULL(t19.tid, '') = '' AND pos00_04.a55 = ?";
            pegasus_mysql_use($query, $count, array($pos00_04_nr01, $pos00_04['a55']));
            //print $count['cc'];
            if($count['cc'] > 0 ){
                $response['ok'] = 0;
                $response['msg'] = $_SESSION['peg_dic_pos00_unique_profortomeni_per_a55'] ;
            }
        }
        return $response;
    }
    function pos00_cardlink_v2_prepare_transaction($pos00_04_nr01, $amount){
                
        $response = array(
            'ok'   =>  1,
            'msg'  =>  '',
            'data' => array()
        );


        $transaction_data = array();

        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        $pos00_01      = pos00_find_pos00_01($pos00_01_nr01);
        
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));

        $transaction_type = "sale10";
        if($kodikos_pistosis < 0 ){
            $transaction_type = "refund10";  
            //Καταργειται η λειτουργία της FullVoid - Ακύρωσης Πληρωμής
        } 
        

        if($pos00_04['profortosi'] == 1){
            $transaction_type = "registerReceipt10";
            
            $select  = "select a55.p701, a55.p06, a10.p00 as a10_p00 ";
            $select .= "from a55 ";
            $select .= "join a10 on a10.p01=a55.p05 ";
            $select .= "where a55.nr01=:a55nr01 ";
            pegasus_mysql_use($select, $a55, array('a55nr01'=>$pos00_04['a55']));

            $transaction_data["transactionDateTime"]    = date("Ymd", strtotime($pos00_04['remfdate'])) . date("His", strtotime($pos00_04['remftime']));
            $transaction_data["receiptNumber"]          = $a55['a10_p00'].$a55['p701'] . pegasus_leading_zeros($a55['p06'], 8); //πχ: ΤΠΥΑ00001033

            
            $expressions = peg_core_greekToGreekenglish(true);
			$transaction_data["receiptNumber"]  = preg_replace(array_keys($expressions), array_values($expressions), $transaction_data["receiptNumber"] );
			//Πετάω ότι δεν είναι γράμμα ή χαρακτήρας
			$transaction_data["receiptNumber"] = preg_replace("/[^α-ωa-z0-9]/iu", '', $transaction_data["receiptNumber"]);
            $transaction_data["receiptNumber"] = strtoupper($transaction_data["receiptNumber"]);
        }

        $pos00_04_type = 1; // Sale
        if($transaction_type == "refund10") {
            $pos00_04_type = 2; // Refund
        }

       
        
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);

        $check = pos00_cardlink_v2_check_before_prepare_transaction($pos00_04_nr01, $transaction_type);
        if($check["ok"] == 0){
            pegasus_mysql_update("pos00_04", array("p02", "descr"), array(1, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
            return $check;
        }

        
        $reference = date("YmdHis") . rand(0, 999999999);
        pegasus_mysql_update("pos00_04", array("type", "descr", "p01"), array($pos00_04_type, $descr, $reference), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
        
        
        //uniqueTxnId, μέχρι τώρα δεν δέχεται η προφορτωμένη, επομένως δεν το ξέρω στο POS
        $transaction_data["uniqueTxnId"] = $reference;
        
        

        $uniqueIntegratorId = "";
        //* Παράμετρος χρήστη για την IP του VPOS διότι είναι μεταβαλλόμενη και δεν μπορούμε να την ελέγχουμε στατικά. Αν είναι συμπληρωμένη βάζει πάντα uniqueIntegratorId. 
        //* Για να βρούμε την IP, nslookup virtualpos.services.novidea.gr
        if(!empty($_SESSION['cor011_cardlink_vpos_ip'])) {
            $uniqueIntegratorId = "b8feaeecfea94530a2f81dca91b8b801";
        }
        
        
        $transaction_data["type"]               = $transaction_type;
        $transaction_data["host"]               = $pos00_01['crdlinkv2_host'];
        $transaction_data["host_port"]          = $pos00_01['crdlinkv2_host_port'];
        $transaction_data["amount"]             = number_format($amount, 2, '.', '');
        $transaction_data["uniqueIntegratorId"] = $uniqueIntegratorId;


        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19 where nr01=?", $t19, array($pos00_04['t19']));  
            $p_sign_s       = $t19['p_sign_s']; //Το μήνυμα της υπογραφής
            $p_sign_s_arr   = explode(";", $p_sign_s);
            //$response['p_sign_s_arr'] = $p_sign_s_arr;            
            //$uid;$mark;$datetime;$tnetvalue;$tvat_am;$tgross_val;$amount;$tidnsp

            $transaction_data["providerId"] = "016";    //https://test.gsis.gr/myaade/ypahes/api/v1/getAllSignatures
            $transaction_data["posId"]      = $pos00_01['tidnsp'];

            //Ζητάνε string για τα ποσά, επομένως θεωρώ ότι θέλουν τα ποσά όπως τα χρησιμοποίησα για να φτιάξω την υπογραφή

            $transaction_data["signature"]          = $t19['p_sign'];
            $transaction_data["documentIdentifier"] = $p_sign_s_arr["0"];
            $transaction_data["signatureDataTime"]  = $p_sign_s_arr["2"];
            
            if(!empty($p_sign_s_arr["1"])){
                $transaction_data["uniqueEntryNumber"] = $p_sign_s_arr["1"];
            }

            $transaction_data["netValue"]           = $p_sign_s_arr["3"];
            $transaction_data["vat"]                = $p_sign_s_arr["4"];
            $transaction_data["totalDocumentValue"] = $p_sign_s_arr["5"];
            $transaction_data["payableAmount"]      = $p_sign_s_arr["6"];
        }


        $response['data'] = $pos00_01;
        $response['transaction_data'] = $transaction_data;
        
        pos00_add_to_log(
            "cardlinkv2-prepare-data:".$transaction_type,
            null,
            $response['transaction_data'],
            $pos00_01['crdlinkv2_host'] . ":" . $pos00_01['crdlinkv2_host_port'] . "/" . $transaction_type 
        );
        
        pos00_add_external_log(
            $pos00_01['crdlinkv2_host'] . ":" . $pos00_01['crdlinkv2_host_port'] . "/" . $transaction_type, 
            "cardlinkv2-prepare-data:".$transaction_type, 
            "Προετοιμασία Συναλλαγής". " " . $transaction_type, 
            array(),
            $response['transaction_data'],
            !$response['ok'], 
            $transaction_data["signature"]
        );



        return $response;
    }
    
    function pos00_cardlink_v2_read_transaction_response($pos00_04_nr01, $data, $message=''){

        $response = array("ok" => 1, "msg" => "");

        pegasus_mysql_use("select * from pos00_04 where nr01 = ? ", $pos00_04, array($pos00_04_nr01));  

        $p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $p_sign = pegasus_mysql_printfld('t19', 'p_sign', 'nr01=:nr01', array('nr01'=>$pos00_04['t19'])); 
        }
        
        if(empty($data["respCodeResp"])){
            $response["ok"]  = 0;
            $response["msg"] = "Δεν πήραμε επιτυχή απάντηση για την πληρωμή από το POS" . ( (empty($message) && $message != "Success") ? "" : " (".$message.")");
            
            pos00_add_to_log("cardlinkv2-read-response:fail", null, $data);            
            pos00_add_external_log("", "cardlinkv2-read-response:fail", $response['msg'], array(), $data, !$response['ok'], $p_sign);
            
            return $response;
        }

        
        //print_r($data);
        /**
         * respCodeResp: Returned to the ECR from the EFT to indicate the status of the transaction. A “00” response codeindicates an approval status. 
         * respMessageResp: Message to be printed in accordance with LINK Response Code above or message which was sent from HOST (see Field No 44, position 17 in LINK Certification Guide).
         * refNumResp: This number is generated by EFT and sent to host to help identify the concerned transaction in a unique way. This number should remain the same for all messages relative to the transaction.
         * tipAmountResp: Tip amount. The decimal point is implied after the first 8 digits.
         * ecrRefNumResp: Reference number provided by ECR
         * eftRefNumResp: Reference number generated by EFT for sending into host
         * printData: Data need to be printed on EFT side.?
         * eftTidResp:
         * invoceNumber: ?
         * invoceNumberCumulative?
         * uniquePaymentIdResp: Identifier consist from Acquirer code, batch number, sequence number and approval code separated by symbol “;” Unique Payment Id contains following subfields separated by symbol “;” Payment Service Provider (Acquirer)
         *                  code (number of digits AN3) Batch Number [number of digits ΑΝ6] Sequence Number [number of digits AN6] Approval Code [number of digits AN6] 
         * uniquePaymentIdEcrResp: String Payment Identifier when the transaction is is initiated by ECR
         */
         
        //Αυτό είναι ο διάβασα της απάντησης με το που στείλω μία προφορτωμένη
        if($pos00_04['profortosi'] == 1 && empty($pos00_04['txnid'])){
            if($data["respCodeResp"]!="00"){
                $error_messages = pos00_cardlink_v2_error_codes();
                $response["ok"]  = 0;
                $response["msg"] = $error_messages[$data["respCodeResp"]];
                
                pos00_add_to_log("cardlinkv2-read-response:fail:".$data["respCodeResp"], null, $data);            
                pos00_add_external_log("", "cardlinkv2-read-response:fail:".$data["respCodeResp"], $response['msg'], array(), $data, !$response['ok'], $p_sign);

                return $response;
            } 

            if($data['numOfInstallmentsResp']>0){
                array_push($arr1 , 'instalments');  array_push($arr2, $data['numOfInstallmentsResp']);
                pegasus_mysql_update('pos00_04', $arr1, $arr2, "nr01=?", 0, 1, 1, array($pos00_04_nr01));
            }
            
            
            $response["ok"]  = 1;
            $response["msg"] = $_SESSION["peg_dic_pos00_cardlink_preload_completed"];
            
            pos00_add_to_log("cardlinkv2-read-response:success:registerReceipt:".$data["respCodeResp"], null, $data);            
            pos00_add_external_log("", "cardlinkv2-read-response:success:registerReceipt:".$data["respCodeResp"], $response['msg'], array(), $data, !$response['ok'], $p_sign);

            return $response;
        }

        $txnid = $data["refNumResp"];
        if($pos00_04['profortosi'] == 1){
            //waitingNewDll
            $txnid = $pos00_04['txnid'];
            //bug: Έχουν bug στις προφορτωμένες και δεν μου στέλνουν το ποσό που τελικά πληρώθηκε, για αυτό και θα σετάρω το ποσό για το οποίο εξέδωσα την υπογραφή 
            if(empty($data["amountResp"])){
                $data["amountResp"] = $pos00_04["amount"];
            }
        }
        
        $amountResp = (strpos($data["amountResp"], '.') === false) ? number_format((float)$data["amountResp"]/100, 2, '.', '') : $data["amountResp"];
        $tipAmountResp = (strpos($data["tipAmountResp"], '.') === false) ? number_format((float)$data["tipAmountResp"]/100, 2, '.', '') : $data["tipAmountResp"];
        $payableAmountResp = (strpos($data["payableAmountResp"], '.') === false) ? number_format((float)$data["payableAmountResp"]/100, 2, '.', '') : $data["payableAmountResp"];
    
        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01, 
            $data["uniqueTxnId"],
            (!empty($data["amountResp"])) ? $amountResp : $payableAmountResp, 
            $tipAmountResp, 
            $data["uniquePaymentIdResp"], 
            $txnid
        );

        if($data["respCodeResp"] != "00"){ //Transaction failed
            $error_messages = pos00_cardlink_v2_error_codes();
            $response = $pos_complete->on_failed_payment($error_messages[$data["respCodeResp"]]);
            
            pos00_add_to_log("cardlinkv2-read-response:fail:".$data["respCodeResp"], null, $data);
            pos00_add_external_log("", "cardlinkv2-read-response:fail:".$data["respCodeResp"], $response['msg'], array(), $data, !$response['ok'], $p_sign);

            return $response;
        }
        
        $response = $pos_complete->on_successful_payment();
        pos00_add_to_log("cardlinkv2-read-response:success:".$data["respCodeResp"], null, $data);            
        pos00_add_external_log("", "cardlinkv2-read-response:success:".$data["respCodeResp"], $response['msg'], array(), $data, !$response['ok'], $p_sign);
        
        return $response;
    }

    function pos00_cardlink_v2_error_codes(){
        return 
        [
            "00" => "Approved",
            "51" => "Declined By Host",
            "DC" => "Declined by Card (EMV)",
            "UD" => "Unsupported Card",
            "UC" => "User Cancelled",
            "CC" => "Cancelled by cashier",
            "LC" => "Lost Carrier (Communication Error)",
            "TO" => "Time Out (Communication Error)",
            "CE" => "Communication Error (Other)",
            "ND" => "Not Delivered",
            "NA" => "Host Not Available",
            "IM" => "Invalid MAC received from host",
            "JF" => "Journal Full – batch is need to be settled",
            "UN" => "Error – Wrong Transaction",
            "IS" => "Invalid Sequence Number",
            "ID" => "Invalid Transaction Data (Void)",
            "IB" => "Invalid Batch Number",
            "EC" => "Expired Card",
            "WC" => "Wrong Card (Invalid card used for Void)",
            "VT" => "Transaction already voided (Void)",
            "XC" => "Transaction is approved however EMV Fail appears on 2nd GenAC, auto-reversal is generated (EMV)",
            "RC" => "Error occurred during chip card reading or card was removed before whole chip checking performed.",
            "CL" => "Connection Lost. Sends when DLL received at least one hold on from POS but after timeout no other message has been received from POS",
            "Y1" => "Offline approved. Special response code for the interaction with the chip card.",
            "Y2" => "Approval (after card-initiated referral). Special response code for the interaction with the chip card.",
            "Y3" => "Unable to go online, offline approved. Special response code for the interaction with the chip card.",
            "Z1" => "Offline declined. Special response code for the interaction with the chip card.",
            "Z2" => "Decline (after card-initiated referral). Special response code for the interaction with the chip card.",
            "Z3" => "Unable to go online, offline declined. Special response code for the interaction with the chip card.",
            "EA" => "Unknown authorization code",
            "NT" => "No Transaction found in journal to provide transaction details code",
            "SE" => "Syntax error in request",
            "IC" => "Invalid currency",
            "IE" => "Internal POS error",
            "IN" => "Invalid command",
            "WP" => "Wrong parameter",
            "MM" => "Missing MAC",
            "ME" => "MAC error",
            "MS" => "MAC is not supported"
            ];
    }


     /**
	 * Γινεται έλεγχος των παραμέτρων συνδεσης με το EDPS POS μέσα απο την οθόνη των Συσκευών
	 *
	 * @param  int      $pos00_03_nr01  Τιμή που έχει συμπληρωθεί στο πεδίο της οθόνης
	 * @param  string   $ip             Τιμή που έχει συμπληρωθεί στο πεδίο της οθόνης
	 * @param  string   $port           Τιμή που έχει συμπληρωθεί στο πεδίο της οθόνης
	 * @return array    
	 */
    function pos00_edps_check_device_params( $pos00_03_nr01, $ip, $port){
        $response = array('ok'=>0, 'msg'=>'');

            
        //Check Connection With the POS Device
        if(!($pos00_03_nr01>0)) {           
            $response['msg'] = $_SESSION["peg_dic_pos00_pos00_01_empty_pos00_03"];
            return $response;

        }else{
            pegasus_mysql_use('select * from pos00_03 where nr01=?', $pos00_03, array($pos00_03_nr01));
            $pos00_03_ip    = $pos00_03['ip'];
            $pos00_03_port  = $pos00_03['port'];

            if(empty($pos00_03_ip)){        
                $response['msg'] = $_SESSION["peg_dic_pos00_pos00_03_empty_ip"];
                return $response;
            }
            
            if(empty($pos00_03_port)){        
                $response['msg'] = $_SESSION["peg_dic_pos00_pos00_03_empty_port"];
                return $response;
            }
        }

        if(empty($ip)) {      
            $response['msg'] = $_SESSION["peg_dic_pos00_pos00_01_empty_edps_ip"];
            return $response;
        }

        if(empty($port)) {  
            $response['msg'] = $_SESSION["peg_dic_pos00_pos00_01_empty_edps_port"];
            return $response;
        }
        

        if(empty($response['msg'])) {
            $response['ok'] = 1;
            $response['data']['pos00_03_nr01']  = $pos00_03_nr01;
            $response['data']['pos00_03_ip']    = $pos00_03_ip;
            $response['data']['pos00_03_port']  = $pos00_03_port;   
            $response['data']['edps_ip']        = $ip;
            $response['data']['edps_port']      = $port;
        }

        return $response;
    }

    function pos00_edps_prepare_transaction($pos00_04_nr01, $amount){

        $response = array(
            'ok'        => 1,
            'msg'       => '',
            'data'      => array()
        );

        $pos00_04 = pos00_find_pos00_04($pos00_04_nr01);
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));

        $pos00_04_type = 1; // Sale
        $transaction_type = 1;
        if($kodikos_pistosis < 0){
            $transaction_type = 2; //refund
            $pos00_04_type = 2; // Refund
        }
        
        if($pos00_04['profortosi'] == 1){
            $transaction_type = 9;
        }

        // Για την EDPS στο pos00_04.txnid κρατάω τα receipt, authId concat με ; ανάμεσα διότι χρειάζεται και τα δύο για το void.
        if(!empty($pos00_04['txnidinit'])) {
            $txnidinit = explode(';', $pos00_04['txnidinit']);
            $receipt = $txnidinit[0];
            $authId = $txnidinit[1];
            if(!empty($receipt) && !empty($authId)) {
                $transaction_type = 4; // Void
                $pos00_04_type = 3; // Void
            }
        }

        $pos00_01 = pos00_find_pos00_01($pos00_01_nr01);
        
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $reference_number  = rand(0, 999999999);
        $pegasus_reference = $pos00_04_nr01 . date("YmdHis");
        pegasus_mysql_update("pos00_04", array("p01", "p03", "type", "descr"), array($reference_number, $pegasus_reference, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));


        $transaction_data = [
            "msgType"       => "TransactionRequest",
            "ecrRefNo"      => $reference_number,
            "txnType"       => $transaction_type,
            "amount"        => round($amount*100),
            "tipAmount"     => 0,
            "providerId"    => "016",
        ];

        // Για Void θέλω και αυτά τα 2.
        if($transaction_type == 4) {
            $transaction_data["receipt"] = $receipt;
            $transaction_data["authId"] = $authId;
        }

        $p_sign = "";
        if(!empty($pos00_04['t19'])){
            pegasus_mysql_use("select * from t19 where nr01 = ?", $t19, array($pos00_04['t19']));  
            $p_sign       = $t19['p_sign'];
            $p_sign_s     = $t19['p_sign_s']; //Το μήνυμα της υπογραφής
            $p_sign_s_arr = explode(";", $p_sign_s);
            
            $transaction_data["input"]      = $p_sign_s;
            $transaction_data["signature"]  = $t19['p_sign'];
        }


        $response['data'] = $pos00_01;
        $response['data']['message_base64'] = base64_encode(json_encode($transaction_data));
        
        pos00_add_to_log("edps-prepare-data", $transaction_data, null);
        pos00_add_external_log("", "edps-prepare-data", 'Success', $transaction_data, null, false, $p_sign);

        return $response;
    }

    function pos00_edps_read_transaction_response($pos00_04_nr01, $data, $message=''){

        $response = array("ok"=>1, "msg"=>"");
        
        //Mock Data
        // $data["response"]["rc"] = "00";
        // $data["response"]["ecrRefNo"] = $data["request"]["ecrRefNo"];
        // $data["response"]["txn"]["originalAmount"] = $data["request"]["amount"];
        // $data["response"]["txn"]["tipAmount"] = 0;
        // $data["response"]["txn"]["rc"] = "00";
                
        if(empty($data["response"])){
            $msg = "Δεν πήραμε επιτυχή απάντηση για την πληρωμή από το POS" . ( (empty($message) && $message != "Success") ? "" : " (".$message.")");
            if(isset($data["exception"])){
                $msg = $data["exception"];
            }

            $response["ok"]  = 0;
            $response["msg"] = $msg;
            
            $pos00_04 = pos00_find_pos00_04($pos00_04_nr01);
            $p_sign   = '';
            if(!empty($pos00_04['t19'])) {
                $p_sign = pegasus_mysql_printfld('t19', 'p_sign', 'nr01=:nr01', array('nr01'=>$pos00_04['t19'])); 
            }

            pos00_add_to_log("edps-read-response", null, $data);
            pos00_add_external_log("", "edps-read-response", $response["msg"],  null, $data, true, $p_sign);

            return $response;
        }

        
        pos00_add_to_log("edps-read-response", null, $data);

        //Προφόρτωση
        if($data["response"]["rc"]=="00" && $data["request"]["txnType"]=="9"){
            $response["msg"] = $_SESSION["peg_dic_pos00_edps_preload_completed"];            
            pos00_add_external_log("", "edps-read-response", $response["msg"],  null, $data, false, $data["response"]["txn"]["signature"]);
            return $response;
        }
        
        $tid = $data["response"]["txn"]["bid"].";".$data["response"]["txn"]["rrno"].";".$data["response"]["txn"]["authId"];

        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01, 
            $data["response"]["ecrRefNo"],
            abs($data["response"]["txn"]["originalAmount"]/100),
            $data["response"]["txn"]["tipAmount"]/100,
            $tid,
            $data["response"]["txn"]["receipt"] . ";" . $data["response"]["txn"]["authId"]
        );
        //* Στο txnid concat το receipt και authId με ; ανάμεσα, θέλω και τα δύο για το void.
        

        if($data["response"]["txn"]["rc"]!="00"){ //Transaction failed
            $error_messages = pos00_edps_error_codes();
            $response = $pos_complete->on_failed_payment($error_messages[$data["response"]["txn"]["rc"]]);
            pos00_add_external_log("", "edps-read-response", $response["msg"],  null, $data, !$response["ok"], $data["response"]["txn"]["signature"]);
            return $response;
        }


        $response = $pos_complete->on_successful_payment();        
        pos00_add_external_log("", "edps-read-response", $response["msg"],  null, $data, !$response["ok"], $data["response"]["txn"]["signature"]);

        return $response;
    }

    function pos00_edps_sync_response($data, $message=''){
        $response  = array("ok"=>0, "msg"=>"");        
        $level_str = "&emsp;&emsp;&emsp;"; 
        
        if($data["response"]["rc"]=="00"){
            if(!(count($data["response"]["txns"])>0)){
                $response['msg'] = $level_str . $_SESSION["peg_dic_pos00_edps_sync_no_preloads"];
            }else{
                $msg = "";
                foreach ($data["response"]["txns"] as $preload) {
                    pegasus_mysql_use("select nr01, descr from pos00_04 where p01=:p01", $pos00_04, array("p01"=>$preload['ecrRefNo']));

                    if($pos00_04["nr01"]>0){
                        $edps_transaction = pos00_edps_read_transaction_response($pos00_04["nr01"], array("response" => $preload));
                        $response['transactions'][] = $edps_transaction;
                        $msg .= (!empty($msg)) ? "<br>" : "";
                        $msg .= $level_str . "ΜΚ: " . $pos00_04["nr01"] . " | " . $pos00_04["descr"] . ":  ";
                        $msg .= $edps_transaction['msg'];
                    }
                }

                $response['ok']  = 1;
                $response['msg'] = $msg;
            }

        }else{
            $error_messages  = pos00_edps_error_codes();
            $msg_error_code  = (!empty($error_messages[$data["response"]["rc"]])) ? ' ('.$error_messages[$data["response"]["rc"]].')' : "";
            $response['msg'] = $level_str . $_SESSION["peg_dic_pos00_edps_sync_fail"] . $msg_error_code; 
        }
         
        
        pos00_add_to_log('edps-sync-request', $data["request"], $data["response"]);
        pos00_add_external_log("", "edps-sync-request", $response['msg'], $data["request"], $data["response"], !$response["ok"]);

        return $response;
    }

    function pos00_edps_get_response($pos00_04_nr01, $data, $message=''){
        $response  = array("ok"=>0, "msg"=>"");        
        $level_str = ""; 
        
        if(is_array($data["response"]["txn"]) && $data["response"]["txn"]["rc"]=="00"){
            $tid = $data["response"]["txn"]["bid"].";".$data["response"]["txn"]["rrno"].";".$data["response"]["txn"]["authId"];

            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01, 
                $data["response"]["ecrRefNo"],
                abs($data["response"]["txn"]["originalAmount"]/100),
                $data["response"]["txn"]["tipAmount"]/100,
                $tid,
                $data["response"]["txn"]["receipt"] . ";" . $data["response"]["txn"]["authId"]
            );
    
            $complete_payment = $pos_complete->on_successful_payment();
            $response['msg']  = $level_str . $complete_payment["msg"];
            $response['ok']   = 1;

        }else{
            $error_messages  = pos00_edps_error_codes();
            $msg_error_code  = (!empty($error_messages[$data["response"]["txn"]["rc"]])) ? ' ('.$error_messages[$data["response"]["txn"]["rc"]].')' : "";
            $response['msg'] = $level_str . $msg_error_code; 
        }
         
        
        pos00_add_to_log('edps-get-request', $data["request"], $data["response"]);
        pos00_add_external_log("", "edps-get-request", $response['msg'], $data["request"], $data["response"], !$response["ok"], $data["response"]["txn"]["signature"]);

        return $response;
    }

    function pos00_edps_error_codes(){ 
        return 
        [
            "00" => "OK",
            "05" => "GENERIC_ERROR",
            "57" => "TXN_NOT_PERMITTED",
            "58" => "TXN_VALIDATION_FAILED",
            "59" => "TXN_SIGNED_AMOUNT_ERROR",
            "60" => "TXN_SIGNATURE_EXISTS",
            "61" => "TXN_ECRREFNO_INVALID",
            "62" => "TXN_SYNC_REQUIRED",
            "76" => "TXN_NOT_FOUND",
            "C1" => "CARD_NOT_ENTERED",
            "C2" => "CARD_DECLINED",
            "C3" => "CARD_EXPIRED",
            "C4" => "TXN_ABORTED",
            "Z1" => "HOST_CONNECT_FAILED",
            "Z2" => "HOST_CONNECT_TIMEOUT",
            "Z3" => "HOST_REPLY_TIMEOUT",
            "Z7" => "ICC_REJECTED_ARPC",
            "Z9" => "BATCH_EMPTY",
            "ZE" => "HOST_COMM_FAILED",
            "P1" => "PRINTER_FAILURE",
            "BZ" => "TERMINAL_BUSY",
            "XX" => "GENERIC_ECR_ERROR"
        ];
    }

    /**
     * Καταχωρεί εγγραφές logs στον πίνακα pos00_99
     * 
     * @param  string  $title				H περιγραφή για τον pos00_99
     * @param  string|array  $request		To Request σε string ή array
     * @param  string|array  $response		To Response σε string ή array
     */
    function pos00_add_to_log(
        $title,
        $request,
        $response, 
        $url = ''
    ){
        $pos00_99_request = $request;
		if(is_array($request)) {
			$pos00_99_request = print_r($request,true);
		}
		$pos00_99_response = $response;
		if(is_array($response)) {
			$pos00_99_response = print_r($response,true);
		}
		$insert = array(
			'nr01'	=> pegasus_mysql_newrec('pos00_99'),
			'dt'	=> date('Y-m-d'),
			'tm'	=> date('H:i'),
			'p01'	=> $title,
            'p02'   => $url, 
			'p30'	=> print_r($pos00_99_request, 1),
			'p31'	=> print_r($pos00_99_response, 1)
		);
		pegasus_mysql_insert(
			'pos00_99', 
			array_keys($insert), 
			array_values($insert)
		);
    }
    function pos00_add_external_log(
        $url,
        $code,
        $title = '',
        $request = array(),
        $response = array(),
        $is_error = true,
        $p_sign = ''
    ) {
        $attributes = array(
            'service-host'  => $url,
            'host'          => $_SERVER['SERVER_NAME'],
            'p_sign'        => $p_sign
        );
        core00_external_logging::send(
            $is_error?1:0,
            "pos00:$code",
            $_SESSION['username'],
            $request,
            $response,
            $title,
            $attributes
        );
        
    }

    function pos00__pos00_dashboard_d_initialize($data, $mmnr01, $mnr01, $_d, $container_id){
          
        //Τύποι Συσκευών που δε συμμετέχουν στο POS Dashboard
        $types_excluded = array(7, 90);
        $types_excluded_in_stm = pegasus_mysql_create_in($types_excluded, 'pos00_01_p02');

        pegasusSetGlobalVar($container_id . '_where_pos00_01', 
            array(
                'sql'       => ' pos00_01.p02 not in ('.$types_excluded_in_stm['sql'].') ', 
                'sqlParams' => $types_excluded_in_stm['sqlParams']
            )
        ); 
        
        $data['date_from'] = date('Y-m-01');
        $data['date_to']   = date('Y-m-d');

        $params['date_from'] = $data['date_from'];
        $params['date_to']   = $data['date_to'];
        pos00_set_dashboard_grid_query($container_id, $params);
        
        return $data;
    }

    function pos00_set_dashboard_grid_query($container_id, $params = array()) {

        $grid00_query_sqlParams = array();

        //Τύποι Συσκευών που δε συμμετέχουν στο POS Dashboard
        $types_excluded = array(7, 90);
        $types_excluded_in_stm = pegasus_mysql_create_in($types_excluded, 'pos00_01_p02');

        
        $where = '';
        $where .= ' AND pos00_01.p02 not in ('.$types_excluded_in_stm['sql'].') ';
        $grid00_query_sqlParams = $types_excluded_in_stm['sqlParams'];

        foreach ($params as $key => $value) {
            if(!empty($value)) {
                $grid00_query_sqlParams[$key] = $value;

                if($key == 'pos00_01') {
                    $where .= " AND pos00_04.pos00_01 = :pos00_01 ";
                }elseif($key == 'date_from') {
                    $where .= " AND pos00_04.remfdate >= :date_from ";
                }elseif($key == 'date_to') {
                    $where .= " AND pos00_04.remfdate <= :date_to ";
                }
            }
        }
        
        // echo '<pre>' .print_r($params, 1). '</pre>';

        $grid00_query_sql = 
        "SELECT 
            pos00_04.nr01 AS nr01,
            pos00_04.remfdate AS pos00_04_date,
            pos00_04.remftime AS pos00_04_time,
            pos00_04.pos00_01 AS pos00_01,
            pos00_01.req_sign AS p_sign_en,
            pos00_04.amount AS pos00_04_amount,
            pos00_04.type AS pos00_04_type,
            pos00_04.t01 AS pos00_04_t01,
            pos00_04.p02 AS pos00_04_p02,
            pos00_04.profortosi AS profortosi,
            pos00_04.txnid AS pos00_04_txnid,
            pos00_04.txnidinit AS pos00_04_txnidinit,
            t19.tid AS t19_tid
        FROM pos00_04
        LEFT JOIN pos00_01 on pos00_04.pos00_01 = pos00_01.nr01
        LEFT JOIN t19 on pos00_04.t19 = t19.nr01
        WHERE 1=1 ".$where."
        ";

        // echo '<pre>' .pegasus_replace_values_in_sql($grid00_query_sql, $grid00_query_sqlParams). '</pre>';

		$grid00_query = array(
			'sql'       => $grid00_query_sql,
			'sqlParams' => $grid00_query_sqlParams
        );
		pegasusSetGlobalVar($container_id . '_grid00_query', $grid00_query);
    }
    /**
     *
     *
     *  Euronet Web ECR
     *
     *
     */
    
    
    /**
     * Επιστρέφει το production URL για το API της Euronet εκτός αν εχει οριστεί 
     * η παράμετρος χρήστη cor011_pos00_euronet2_url που τότε επιστρέφει αυτήν.
     * 
     * Ε: 10001362 Δ: 10170362
     * 
     * @return string
     */
    function pos00_euronet2_get_url()
    {
        if (!empty($_SESSION['cor011_pos00_euronet2_url'])) {
            return $_SESSION['cor011_pos00_euronet2_url'];
        }
        /**
         * PROD Euronet Web ECR service API URL
         */
        return "https://webecr.epayworldwide.com:11007";
    }
    /**
     * Επιστρέφει τα στοιχεία σύνδεσης του vendor account της ΤΕΣΑΕ 
     * στο Production API της Euronet εκτός αν έχει οριστεί η παράμετρος 
     * χρηστή cor011_pos00_euronet2_url που τότε επιστρέφει τα  στοιχεία 
     * σύνδεσης του vendor account του DEV API ης Euronet.
     * 
     * Ε: 10001362 Δ: 10170362
     *
     * @return array
     */
    function pos00_euronet2_get_vendor_account() {
        $username = 'vendor_tesae_web';
        $password = '6157218e-9503-4a8a-b109-aa66333003ab3';
        if(!empty($_SESSION['cor011_pos00_euronet2_url'])) {
            $username = 'vendor_tesae';
            $password = 'Qq7r1t31Brp';
        }
        return array(
            'username'  => $username,
            'password'  => $password
        );
    }
    /**
     * Ε: 10001362 Δ: 10170362
     */
    function pos00_euronet2_set_token(
        $pos00_01_nr01,
         $log_p_sign = ''
    ) {
        $pos00_euronet2_get_vendor_account = pos00_euronet2_get_vendor_account();
        $request = array(
            'url'       => pos00_euronet2_get_url() . '/token/',
            'headers'   => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Pegasus Web App'
            ),
            'data'  => $pos00_euronet2_get_vendor_account
        );
        try {
            $response_token = pegasus_curl_request_post(
                $request['url'],
                json_encode($request['data']),
                false,
                $request['headers'],
                array(),
                true
            );
        } catch (Exception $exc) {
            /**
             * @todo Αν πρέπει να βάλουμε ποιο φιλικό μήνυμα 
             */
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_set_token:curl:{$exc->getCode()}",
                $exc->getMessage(),
                $request['data'],
                array(),
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'euronet:check-credentials',
                $request['data'],
                'JSON: ' . $exc->getMessage(),
                $request['url']
            );
            return array(
                'ok'    => 0,
                'msg'   => "Exception " . $exc->getMessage()
            );
        }
        pos00_add_to_log(
            'euronet:check-credentials',
            $request['data'],
            $response_token['response'],
            $request['url']
        );
        $response_arr2 = json_decode($response_token['response'], true);
        if (
            !is_array($response_arr2)
            || $response_token["http_code"] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_set_token:http_code:{$response_token['http_code']}",
                $msg,
                $request['data'],
                $response_token,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        $update = array(
            'euronet2_token'        => $response_arr2["access"],
            'euronet2_refreshtoken' => $response_arr2["refresh"]
        );
        pegasus_mysql_update(
            'pos00_01',
            array_keys($update),
            array_values($update),
            'nr01 = :nr01',
            1,
            1,
            1,
            array('nr01' => $pos00_01_nr01)
        );
        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_connection'];
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_set_token:success",
            $msg,
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );
        return array(
            'ok' => 1,
            'msg' => $msg,
            'euronet2_token' =>  $response_arr2["access"]
        );
    }
    function pos00_euronet2_get_token(
        $pos00_01_nr01,
        $log_p_sign = ''
    ) {
    
        $data = array(
            "ok" => 1,
            "msg" => "",
            "euronet2_token" => ""
        );
    
        $euronet2_token = pegasus_mysql_printfld('pos00_01', 'euronet2_token', 'nr01=?', array($pos00_01_nr01));
        $data['euronet2_token'] = $euronet2_token;
    
        if (empty($euronet2_token)) {
            $data = pos00_euronet2_set_token($pos00_01_nr01, $log_p_sign);
        }
    
        return $data;
    }
    function pos00_euronet2_refresh_token(
        $pos00_01_nr01, 
        $log_p_sign = ''
    ) {
    
        $euronet2_refreshtoken = pegasus_mysql_printfld('pos00_01', 'euronet2_refreshtoken', 'nr01=?', array($pos00_01_nr01));
        $request = array(
            'url'   => pos00_euronet2_get_url() . '/token/refresh/',
            'data'  => array(
                'refresh' => $euronet2_refreshtoken
            )
        );
        if (empty($euronet2_refreshtoken)) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_refresh_token:empty_euronet2_refreshtoken",
                'Δεν βρέθηκε refresh token. Θα προσπαθήσει να κάνει νέο token',
                array(),
                array(),
                true,
                $log_p_sign
            );
            return pos00_euronet2_set_token($pos00_01_nr01, $log_p_sign);
        }
        try {
            $response_refreshtk = pegasus_curl_request_post(
                $request['url'],
                json_encode($request['data']),
                false,
                array(
                    'Content-Type: application/json',
                    'Accept: application/json',
                    'User-Agent: Pegasus Web App',
                ),
                array(),
                true
            );
        } catch (Exception $exc) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_refresh_token:curl:{$exc->getCode()}",
                $exc->getMessage(),
                array(),
                array(),
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'euronet:refresh-token',
                $request['data'],
                'JSON: ' . $exc->getMessage(),
                $request['url']
            );
            return array(
                'ok'    => 0,
                'msg'   => "Exception " . $exc->getMessage()
            );
        }
        pos00_add_to_log(
            'euronet:refresh-token',
            $request['data'],
            $response_refreshtk['response'],
            $request['url']
        );
        $response_arr = json_decode($response_refreshtk['response'], true);
        if (
            !is_array($response_arr)
            || $response_refreshtk["http_code"] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_refresh_token:http_code:{$response_refreshtk['http_code']}",
                $msg,
                $request['data'],
                $response_refreshtk,
                true,
                $log_p_sign
            );
            return pos00_euronet2_set_token($pos00_01_nr01, $log_p_sign);
        }
        if (empty($response_arr["access"])) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_refresh_token:pos00_euronet2_set_token",
                'Δεν κατάφερε να κάνει refresh token. Θα προσπαθήσει να κάνει νέο token',
                $request['data'],
                $response_arr,
                true,
                $log_p_sign
            );
            return pos00_euronet2_set_token($pos00_01_nr01, $log_p_sign);
        }
    
        $update = array(
            'euronet2_token'    => $response_arr["access"]
        );
        pegasus_mysql_update(
            'pos00_01',
            array_keys($update),
            array_values($update),
            'nr01=:nr01',
            1,
            1,
            1,
            array('nr01' => $pos00_01_nr01)
        );
        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_refresh_token'];
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_refresh_token:pos00_euronet2_set_token",
            $msg,
            $request['data'],
            $response_arr,
            false,
            $log_p_sign
        );
        return array(
            'ok' => 1,
            'msg' => $msg,
        );
    }
    function pos00_euronet2_create_api_key(
        $pos00_01_nr01,
        $called_after_refresh = false
    ) {
        $euronet2_auth_code = pegasus_mysql_printfld('pos00_01','euronet2_auth_code','nr01 = :nr01', array('nr01' => $pos00_01_nr01));
    
        if (empty($euronet2_auth_code)) {
            return array(
                'ok'    => 0,
                'msg'   => $_SESSION['peg_dic_pos00_pos00_01_empty_auth_code']
            );
        }
        $data_token = pos00_euronet2_get_token($pos00_01_nr01);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
        $request = array(
            'url'       => pos00_euronet2_get_url() . '/authorization/redeem/',
            'headers'    => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Pegasus Web App',
                'Authorization: Bearer ' . $data_token['euronet2_token']
            ),
            'data'      => array(
                'Type' => 'webecr',
                'Code' => $euronet2_auth_code
            )
        );
        try {
            $response_api_key = pegasus_curl_request_post(
                $request['url'],
                json_encode($request['data']),
                false,
                $request['headers'],
                array(),
                true
            );
        } catch (Exception $exc) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_create_api_key:curl:{$exc->getCode()}",
                $exc->getMessage(),
                $request['data'],
                array(),
                true
            );
            pos00_add_to_log(
                'euronet:create-api-key',
                $request['data'],
                'JSON: ' . $exc->getMessage(),
                $request['url']
            );
            return array(
                'ok'    => 0,
                'msg'   => "Exception " . $exc->getMessage()
            );
        }
        pos00_add_to_log(
            'euronet:create-api-key',
            $request['data'],
            $response_api_key['response'],
            $request['url']
        );
    
        if (
            $response_api_key["http_code"] == 401
            && $called_after_refresh == false
        ) {
            $res_refresh = pos00_euronet2_refresh_token($pos00_01_nr01);
            if ($res_refresh['ok'] == 0) {
                return $res_refresh;
            }
            return pos00_euronet2_create_api_key($pos00_01_nr01, $euronet2_auth_code, true);
        }
        $response_arr2 = json_decode($response_api_key['response'], true);
        if (
            !is_array($response_arr2)
            || $response_api_key["http_code"] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_create_api_key:http_code:{$response_api_key['http_code']}",
                $msg,
                $request['data'],
                $response_api_key,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        if ($response_arr2["status"] == "invald_authorization_code") {
            $msg = $_SESSION['peg_dic_pos00_pos00_01_wrong_auth_code'];
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_create_api_key:invald_authorization_code",
                $msg,
                $request['data'],
                $response_arr2,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        /**
         * 
         */
        $update = array(
            'euronet2_api_key'  => $response_arr2['Id']
        );
        pegasus_mysql_update(
            'pos00_01',
            array_keys($update),
            array_values($update),
            'nr01 = :nr01',
            1,
            1,
            1,
            array('nr01' => $pos00_01_nr01)
        );
        $msg = $_SESSION['peg_dic_pos00_pos00_01_success_api_key'];
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_create_api_key:success",
            $msg,
            $request['data'],
            $response_arr2,
            false
        );

        $pos00_euronet2_update_api_key_resp = pos00_euronet2_update_api_key_by_tidnsp($pos00_01_nr01);
        if($pos00_euronet2_update_api_key_resp['ok'] != 1) {
            return $pos00_euronet2_update_api_key_resp;
        }
        return array(
            'ok' => 1,
            'msg' => $_SESSION['peg_dic_pos00_pos00_01_success_api_key'],
            'euronet2_api_key' => $response_arr2['Id']
        );
    }
    function pos00_euronet2_find_pos($pos00_01_nr01,  $called_after_refresh = false)
    {

        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        $data_token = pos00_euronet2_get_token($pos00_01_nr01);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
    
        $request = array(
            'url'       => pos00_euronet2_get_url() . '/terminal/',
            'headers'   => array(
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Pegasus Web App',
                'Authorization: Bearer ' . $data_token['euronet2_token'],
                'X-Api-Key: ' . $pos00_01['euronet2_api_key']
            )
        );
        try {
            $req_response = pegasus_curl_request(
                $request['url'],
                false,
                $request['headers'],
                array(),
                true
            );
        } catch (Exception $exc) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_find_pos:curl:{$exc->getCode()}",
                $exc->getMessage(),
                array(),
                array(),
                true
            );
            pos00_add_to_log(
                'euronet:find-pos',
                array(),
                'JSON: ' . $exc->getMessage(),
                $request['url']
            );
            return array(
                'ok'    => 0,
                'msg'   => "Exception " . $exc->getMessage()
            );
        }
        pos00_add_to_log(
            'euronet:find-pos',
            array(),
            $req_response['response'],
            $request['url']
        );
    
        if (
            $req_response["http_code"] == 401
            && $called_after_refresh == false
        ) {
            $res_refresh = pos00_euronet2_refresh_token($pos00_01_nr01);
            if ($res_refresh['ok'] == 0) {
                return $res_refresh;
            }
            return pos00_euronet2_find_pos($pos00_01_nr01, true);
        }
        $response_arr = json_decode($req_response['response'], true);
        if (
            !is_array($response_arr)
            || $req_response["http_code"] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_find_pos:http_code:{$req_response['http_code']}",
                $msg,
                array(),
                $req_response,
                true
            );
            return array(
                'ok'    => 0,
                'meg'  => $msg
            );
        }
        if ($response_arr["count"] == 0) {
            $msg = $_SESSION['peg_dic_pos00_pos00_01_no_pos_found'];
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_find_pos:count",
                $msg,
                array(),
                $req_response,
                true
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        foreach ($response_arr["results"] as $terminal) {
    
            $pos00_06 = array();
    
            $pos00_06['id']          = $terminal["id"];
            $pos00_06['tid']         = $terminal['TerminalID'];
            $pos00_06['description'] = $terminal['TerminalID'];
    
            $pos00_06['pos00_01']    = $pos00_01_nr01;
    
            $pos00_06_nr01 = pegasus_mysql_printfld("pos00_06", "nr01", "id=? && pos00_01=?", array($terminal["id"], $pos00_01_nr01));
    
            if ($pos00_06_nr01 > 0) {
                // Στο update δεν κάνουμε update το friendly name
                unset($pos00_06['description']);
                pegasus_mysql_update(
                    'pos00_06',
                    array_keys($pos00_06),
                    array_values($pos00_06),
                    " nr01 = ?",
                    0,
                    1,
                    1,
                    array($pos00_06_nr01)
                );
            } else {
                $pos00_06['nr01']  = pegasus_mysql_newrec('pos00_06');
                $pos00_06_nr01 = $pos00_06['nr01'];
                pegasus_mysql_insert('pos00_06', array_keys($pos00_06), array_values(($pos00_06)));
            }
        }
    
        $result = array(
            'ok' => 1,
            'msg' => $_SESSION['peg_dic_pos00_pos00_01_success_found_mul_devices'],
            'pos00_06' => array('value' => 0, 'display' => '')
        );
    
        if ($response_arr["count"] == 1) {
            $pos00_06 = array();
            pegasus_mysql_use('SELECT * FROM pos00_06 WHERE nr01 = :nr01', $pos00_06, array('nr01' => $pos00_06_nr01));

            $update = array(
                'euronet2_pos00_06' => $pos00_06['nr01'],
                'tidnsp'            => $pos00_06['tid']
            );
            pegasus_mysql_update(
                'pos00_01',
                array_keys($update),
                array_values($update),
                'nr01 = :nr01',
                1,
                1,
                1,
                array('nr01' => $pos00_01_nr01)
            );
            $result['pos00_06'] = array(
                'value'     => $pos00_06_nr01,
                'display'   => $pos00_06['description']
            );
            $result['pos00_06_tid'] = $pos00_06['tid'];
            $result['msg'] = $_SESSION['peg_dic_pos00_pos00_01_success_one_pos_found'];
        }
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_find_pos:success",
            $result['msg'],
            array(),
            $response_arr,
            false
        );
        return $result;
    }
    /**
     *
     * @param  int  $pos00_04_nr01
     * @param  float  $amount
     * @param  boolean $called_after_refresh
     * @return array
     */
    function pos00_euronet2_send_transaction(
        $pos00_04_nr01, 
        $amount, 
        $called_after_refresh = false
    ) {
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        pegasus_mysql_use("select * from pos00_06 where nr01 = ?", $pos00_06, array($pos00_01["euronet2_pos00_06"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));
    
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }

        $data_token = pos00_euronet2_get_token($pos00_01_nr01, $log_p_sign);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
    
        $transaction_type = 0;
        if ($kodikos_pistosis < 0) {
            $transaction_type = 1; //refund
        }
    
        if (!empty($pos00_04['mailphone'])) {
            $transaction_type = 4; // Mail order/Telephone order
        }
    
        $pos00_04_type = 1; // Sale
        if ($transaction_type == 1) {
            $pos00_04_type = 2; // Refund
        }
        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $pegasus_reference = $pos00_04_nr01 . date("YmdHis");
        pegasus_mysql_update("pos00_04", array("p03", "type", "descr"), array($pegasus_reference, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
    
        $data = array(
            "TxnType"  =>  $transaction_type,
            "Amount"  =>  round($amount * 100),
            "TipAmount"  =>  0,
            "CurrencyCode" => 978,
            "CustomerReference" => $pegasus_reference
        );
    
        if ($pos00_04['profortosi']) {
            $data['PreloadTransaction'] = true;
            $data['PreloadExpiration'] = 1440; //TODO: Να δούμε πόσα λεπτά χρειάζεται να βάλω στην προφόρτωση
        }
    
        // Αριθμός Δόσεων αν είναι συμπληρωμένος. //? Εδώ περνάνε και τα 0 και τα αρνητικά στο API τους.
        if ($pos00_04['instalments'] > 0) {
            $data['Instalments'] = $pos00_04['instalments'];
        }
    
        // Αν έχω επιστροφή και συμπληρωμένο initial transaction id
        if ($transaction_type == 1 && !empty($pos00_04['txnidinit'])) {
            $data['InitialTransaction'] = $pos00_04['txnidinit'];
        }
    
    
        if (!empty($pos00_04['t19'])) {
            pegasus_mysql_use("select * from t19  where nr01 = ?", $t19, array($pos00_04['t19']));
            $p_sign_s = $t19['p_sign_s']; //Το μήνυμα της υπογραφής
            $p_sign_s_arr = explode(";", $p_sign_s);
    
            $povider_data = [
                "Uid"  => $p_sign_s_arr["0"],
                "Mark"  => empty($p_sign_s_arr["1"]) ? null : $p_sign_s_arr["1"],
                "SignatureTimestamp"  => $p_sign_s_arr["2"],
                "NetAmount"  => $p_sign_s_arr["3"],
                "VatAmount"  => $p_sign_s_arr["4"],
                "TotalAmount" => $p_sign_s_arr["5"],
                "ProviderId" => "016",
                "Signature"  => bin2hex(base64_decode($t19['p_sign']))
            ];
            $data["ProviderData"] = $povider_data;
        }
        $request = array(
            'url'		=> pos00_euronet2_get_url() . '/terminal/' . $pos00_06["id"] . '/txninit/',
            'header'    =>  array(
                'Content-Type: application/json',
                'Accept: application/json',
                'User-Agent: Pegasus Web App',
                'Authorization: Bearer ' . $data_token['euronet2_token'],
                'X-Api-Key: ' . $pos00_01['euronet2_api_key']
            ),
            'data' => $data
        );
        try {
    
            $txinit_resp = pegasus_curl_request_post(
                $request['url'],
                json_encode($request['data']),
                false,
                $request['header'],
                array(
                    CURLOPT_TIMEOUT => 10
                ),
                true
            );
        } catch (Exception $exc) {
            if ($exc->getCode() == CURLE_OPERATION_TIMEDOUT) {
                $msg = $_SESSION['peg_dic_pos00_euronet2_curl_timeout'];
                //pos00_add_external_log( $request['url'], "pos00_euronet2_send_transaction:curl:CURLE_OPERATION_TIMEDOUT", $msg, $request, array(), true, $log_p_sign);
                pos00_add_to_log(
                    'euronet:send-transaction',
                    $data,
                    $msg,
                    $request['url']
                );
                return array(
                    'ok'                => 1,
                    'show_pos00_d06'    => true
                );
            }
            $msg = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:curl:{$exc->getCode()}",
                $msg,
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'euronet:send-transaction',
                $data,
                $msg,
                $request['url']
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        pos00_add_to_log(
            'euronet:send-transaction',
            $data,
            $txinit_resp['response'],
            $request['url']
        );
    
        if (
            $txinit_resp["http_code"] == 401 
            && $called_after_refresh == false
        ) {
            $res_refresh = pos00_euronet2_refresh_token($pos00_01_nr01);
            if ($res_refresh['ok'] == 0) {
                pos00_add_external_log(
                    $request['url'],
                    "pos00_euronet2_send_transaction:pos00_euronet2_refresh_token",
                    "Δεν είναι δυνατή η αποστολή πληρωμής (http_code 401)",
                    $request['data'],
                    array(
                        'pos00_euronet2_send_transaction' => $txinit_resp,
                        'pos00_euronet2_refresh_token'    => $res_refresh
                    ),
                    true,
                    $log_p_sign
                );
                return $res_refresh;
            }
            return pos00_euronet2_send_transaction($pos00_04_nr01, $amount, true);
        }
        $response_arr2 = json_decode($txinit_resp['response'], true);
        if (
            !is_array($response_arr2)
            || $txinit_resp['http_code'] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:http_code:{$txinit_resp['http_code']}",
                $msg,
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        if ($response_arr2["status"] == "invald_authorization_code") {
            $msg = $_SESSION['peg_dic_pos00_pos00_01_wrong_auth_code'];
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:invald_authorization_code",
                $msg,
                $request['data'],
                $response_arr2,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        if (empty($response_arr2["Id"])) {
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $txinit_resp['response'],
                $_SESSION['peg_dic_pos00_pos00_01_fail_transanction']
            );
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:IdError",
                $result['msg'],
                $request['data'],
                $response_arr2,
                true,
                $log_p_sign
            );
            return $result;
        }
        pegasus_mysql_update('pos00_04', array('p01', 'txnid'), array($response_arr2["Id"], $response_arr2['Transaction']['TxnId']), "nr01 = ? ", 0, 1, 1, array($pos00_04_nr01));
        /**
         * Intent status
         * The possible values for the intent status are:
         * 1: PENDING - Intent has been registered to the backend and is pending to be sent to the device
         * 2: SENT - Intent has been sent to the device
         * 3: COMPLETED - Intent has been successfully completed by the device and has registered the results
         * */
        if (empty($response_arr2["Status"]) || empty($response_arr2["Result"])) {
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $txinit_resp['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            $result['msg'] = "Δεν βρέθηκε η πληρωμή. " . $txinit_resp['response'];
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:StatusResultError",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        if ($response_arr2["Status"] == 1) {
            $result['ok']       = 0;
            $result["pending"]  = 1;
            $result['msg']      = "Η πληρωμή είναι σε κατάσταση: PENDING";
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:StatusError",
                $result['msg'],
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        if ($response_arr2["Status"] == 2) {
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:Result:".$response_arr2["Status"],
                'Δεν είναι δυνατή η διαχείριση Status 2 σε νέα καταχώρηση',
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );


            if ($pos00_04["profortosi"] == 1) {
                return array(
                    'ok'        => 1,
                    'pending'   => 0,
                    'msg'       => $_SESSION["peg_dic_pos00_mellon_status_sent_profortosi"]
                );
            } else {
                return array(
                    'ok'        => 0,
                    'pending'   => 1,
                    'msg'       => $_SESSION["peg_dic_pos00_euronet2_status_sent"]
                );
            }
        }
    
        $expected_results = [
            "1" => "APPROVED - The transaction has been completed and approved by the authorization system",
            "2" => "DECLINED - The transaction has been completed and declined by the authorization system",
            "3" => "CANCELLED - The transaction has been cancelled by the POS user before reaching completion",
            "4" => "FAILED - The transaction has failed to complete",
            "5" => "UNKNOWN - The transaction result is unknown. Only possible if the device hasn't responded with resuls",
            "6" => "BUSY - The transaction has failed because the POS is currently unavailable for transactions (either processing another transaction or under maintenance)",
            "7" => "MAX_TRANSACTIONS - The POS device has reached its transaction limit for the specific batch. Batch closing should be performed on the device before continuing transactions"
        ];
    
        if ($response_arr2["Result"] != 1) { //Transaction failed
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_send_transaction:Result:".$response_arr2["Result"],
                "Η πληρωμή απέτυχε... Result = {$response_arr2["Result"]}",
                $request['data'],
                $txinit_resp,
                true,
                $log_p_sign
            );
            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01,
                $pos00_04['p01']
            );
            return $pos_complete->on_failed_payment($expected_results[$response_arr2["Result"]]);
        }
        $Transaction = $response_arr2["Transaction"];
       /**
         * Ε: 10001662
         * 
         * Για να εξυπηρετήσουμε και τα split payment των πρωτοφορεμένων κρατάμε 
         * το transactionId ως έχει αλλά ως Amount και  TipAmount ορίζουμε το 
         * σύνολο των Amount και TipAmount των Transaction του TransactionList.
         */
        if(
            !empty($Transaction)
            && !is_array($Transaction)
        ) {
            $Transaction = array(
                'Id'        => $Transaction,
                'Amount'    => 0,
                'TipAmount' => 0
            );
            foreach($response_arr2["TransactionList"]['Transaction'] as $v) {
                if(!empty($v['Amount'])) {
                    $Transaction['Amount'] += $v['Amount'];
                }
                if(!empty($v['TipAmount'])) {
                    $Transaction['TipAmount'] += $v['TipAmount'];
                }
            }
        }
        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01,
            $response_arr2['Id'],
            $Transaction['Amount'] / 100,
            $Transaction['TipAmount'] / 100,
            $response_arr2['TransactionId'],
            $Transaction['Id']
        );
    
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_check_transaction:success",
            "Ο έλεγχος πληρωμής εκτελέστηκε με επιτυχία",
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );
        $pos_complete_on_successful_payment_resp  = $pos_complete->on_successful_payment();
        $pos_complete_on_successful_payment_resp['msg'] = str_replace(
             '#id#',
             $response_arr2["Id"],
            $_SESSION['peg_dic_pos00_pos00_01_success_tx']
        );
        return $pos_complete_on_successful_payment_resp;
    }
    function pos00_pos00_d06_initialize($data, $mmnr01, $mnr01, $_d, $container_id)
    {
    
        global $PegInput;
        $PegInput->addVar(new peg_input_number('pos00_04_nr01'));
        $PegInput->addVar(new peg_input_number('v_profortosi'));
        $pos00_04_nr01 = $PegInput->getRequest('pos00_04_nr01');
        $v_profortosi = $PegInput->getRequest('v_profortosi');
    
        $data['v_message'] = $_SESSION['peg_dic_pos00_trans_submit_transaction'];
        if ($v_profortosi == 1) {
            $data['peg_screenTitle'] = $_SESSION['peg_dic_pos00_d04_profortosi_title'];
            $data['v_message'] = $_SESSION['peg_dic_pos00_d04_profortosi_message'];
            $data['btn_00_text'] = $_SESSION['peg_dic_pos00_d04_profortosi_btn'];
        }
        $data['v_message_readonly'] = 1;
        $data["pos00_04_nr01"] = $pos00_04_nr01;
    
        return $data;
    }
    
    function pos00_euronet2_check_transaction($pos00_04_nr01, $called_after_refresh = false)
    {
    
        $result = array(
            "ok" => 0,
            "msg" => "",
            "pending" => 0  //Αν είναι pending, δεν πρέπει να κλείσει την οθόνη
        );
        pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($pos00_04_nr01));
        $pos00_01_nr01 = $pos00_04["pos00_01"];
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        pegasus_mysql_use("select * from pos00_06 where nr01 = ?", $pos00_06, array($pos00_01["euronet2_pos00_06"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));
    
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            $log_p_sign = pegasus_mysql_printfld('t19','p_sign','nr01 = :nr01',array('nr01' => $pos00_04['t19'])); 
        }

        $data_token = pos00_euronet2_get_token($pos00_01_nr01, $log_p_sign);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
    
        $transaction_type = 0;
        if ($kodikos_pistosis < 0) {
            $transaction_type = 1; //refund
        }
    
        if (!empty($pos00_04['mailphone'])) {
            $transaction_type = 4; // Mail order/Telephone order
        }

        /**
         * Έλεγχος  προφόρτωσης
         */
        if($pos00_04['profortosi'] == 1) {
            $pos00_euronet2_check_profortosi_transaction_resp = pos00_euronet2_check_profortosi_transaction(
                $pos00_01_nr01,
                $pos00_04['p03'],
                $log_p_sign
        );
            if($pos00_euronet2_check_profortosi_transaction_resp['ok'] != 1) {
                return $pos00_euronet2_check_profortosi_transaction_resp;
            }
        }
    
        try {
            $request = array(
                'url'		=> pos00_euronet2_get_url() . '/terminal/' . $pos00_06["id"] . '/txninit/',
                'header'    =>  array(
                    'Content-Type: application/json',
                    'Accept: application/json',
                    'User-Agent: Pegasus Web App',
                    'Authorization: Bearer ' . $data_token['euronet2_token'],
                    'X-Api-Key: ' . $pos00_01['euronet2_api_key']
                ),
                'data'   => array(
                    "TxnType"  =>  $transaction_type,
                    "CustomerReference" => $pos00_04['p03']
                )
            );
    
            $txintent_resp = pegasus_curl_request_post(
                $request['url'],
                json_encode($request['data']),
                false,
                $request['header'],
                array(
                    /**
                     * Για να αντιμετωπίσουμε την αργή απόκριση του production service της Euronet αφήσαμε τo timeout ελεύθερο.
                     */
                    //CURLOPT_TIMEOUT => 10
                ),
                true
            );
    
    
        } catch (Exception $exc) {
            $result['ok'] = 0;
            $result['msg'] = "Exception " . $exc->getMessage();
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:curl:{$exc->getCode()}",
                $result['msg'],
                $request,
                $result,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'euronet:check-transaction',
                null,
                'JSON: ' . $exc->getMessage(),
                $request['url']
            );
            return $result;
        }
        pos00_add_to_log(
            'euronet:check-transaction',
            $request,
            $txintent_resp['response'],
            $request['url']
        );
    
        if ($txintent_resp["http_code"] == 401 and $called_after_refresh == false) {
            $res_refresh = pos00_euronet2_refresh_token($pos00_01_nr01);
            if ($res_refresh['ok'] == 0) {
                pos00_add_external_log(
                    $request['url'],
                    "pos00_euronet2_check_transaction:pos00_euronet2_refresh_token",
                    "Δεν είναι δυνατή η εκτέλεση ελέγχου πληρωμής (HTTP 401)",
                    $request['data'],
                    array(
                        'pos00_euronet2_check_transaction'    => $txintent_resp,
                        'pos00_euronet2_refresh_token'        => $res_refresh
                    ),
                    true,
                    $log_p_sign
                );
                return $res_refresh;
            }
            return pos00_euronet2_check_transaction($pos00_04_nr01, true);
        }
        /**
         * Euronet invalid JSON (STAN) Error
         * 
         * ΠΡΟΣΟΧΉ! Πρέπει να αφαιρεθεί αμέσως μόλις διορθώσει η Euronet to error
         */
        $exists = preg_match('/(?<="STAN":)[0-9]{6}/',$txintent_resp['response'],$matches);
        if(
            $exists !== false
            && count($matches) > 0 
        ) {
            $recover = preg_replace(
                '/(?<="STAN":)[0-9]{6}/',
                '"${0}"',
                $txintent_resp['response']
            );
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:stan_error_recover",
                "Προσωρινή αντιμετώπιση του προβλήματος ανάγνωσης transactions (transaction.STAN) της Euronet.",
                $txintent_resp['response'],
                $recover,
                false,
                $log_p_sign
            );
            $txintent_resp['response'] = $recover;
        }
        $response_arr2 = json_decode($txintent_resp['response'], true);
        if (
            !is_array($response_arr2)
            || $txintent_resp['http_code'] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:http_code:{$txintent_resp['http_code']}",
                $msg,
                $request['data'],
                $txintent_resp,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        /**
         * Intent status
         * The possible values for the intent status are:
         * 1: PENDING - Intent has been registered to the backend and is pending to be sent to the device
         * 2: SENT - Intent has been sent to the device
         * 3: COMPLETED - Intent has been successfully completed by the device and has registered the results
         * */
        if (empty($response_arr2["Status"]) || empty($response_arr2["Result"])) {
            $result['ok'] = 0;
            $result['msg'] = str_replace(
                '#response#',
                $txintent_resp['response'],
                $_SESSION['peg_dic_pos00_pos00_01_not_expected_answer']
            );
            $result['msg'] = "Δεν βρέθηκε η πληρωμή";
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:StatusResultError",
                $result['msg'],
                $request['data'],
                $response_arr2,
                true,
                $log_p_sign
            );
            return $result;
        }
        if ($response_arr2["Status"] == 1) {
            $result['ok']       = 0;
            $result["pending"]  = 1;
            $result['msg']      = "Η πληρωμή είναι σε κατάσταση: PENDING";
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:StatusError",
                $result['msg'],
                $request['data'],
                $txintent_resp,
                true,
                $log_p_sign
            );
            return $result;
        }
        if ($response_arr2["Status"] == 2) {
            if ($pos00_04["profortosi"] == 1) {
                if(empty($response_arr2["Transaction"])) {
                    return array(
                        'ok'    => 0,
                        'pending'   => 1,
                        'msg'   => 'Η προφόρτωση δεν έχει ολοκληρωθεί.'
                    );
                } else {
                    return array(
                    'ok'        => 1,
                    'pending'   => 0,
                    'msg'       => $_SESSION["peg_dic_pos00_mellon_status_sent_profortosi"]
                    );
                }
            } else {
                return array(
                    'ok'        => 0,
                    'pending'   => 1,
                    'msg'       => $_SESSION["peg_dic_pos00_euronet2_status_sent"]
                );
            }
        }
    
        $expected_results = [
            "1" => "APPROVED - The transaction has been completed and approved by the authorization system",
            "2" => "DECLINED - The transaction has been completed and declined by the authorization system",
            "3" => "CANCELLED - The transaction has been cancelled by the POS user before reaching completion",
            "4" => "FAILED - The transaction has failed to complete",
            "5" => "UNKNOWN - The transaction result is unknown. Only possible if the device hasn't responded with resuls",
            "6" => "BUSY - The transaction has failed because the POS is currently unavailable for transactions (either processing another transaction or under maintenance)",
            "7" => "MAX_TRANSACTIONS - The POS device has reached its transaction limit for the specific batch. Batch closing should be performed on the device before continuing transactions"
        ];
    
        if ($response_arr2["Result"] != 1) { //Transaction failed
            $pos_complete = new pos00_complete_payment(
                $pos00_04_nr01,
                $pos00_04['p01']
            );
    
            return $pos_complete->on_failed_payment($expected_results[$response_arr2["Result"]]);
        }
        $Transaction = $response_arr2["Transaction"];
        if(empty($Transaction)) {
            return array(
                'ok'    => 0,
                'msg'   => 'Η συναλλαγή δεν έχει ολοκληρωθεί'
            );
        }
         /**
         * Ε: 10001662
         * 
         * Για να εξυπηρετήσουμε και τα split payment των πρωτοφορεμένων κρατάμε 
         * το transactionId ως έχει αλλά ως Amount και  TipAmount ορίζουμε το 
         * σύνολο των Amount και TipAmount των Transaction του TransactionList.
         */
        if(
            !empty($Transaction)
            && !is_array($Transaction)
        ) {
            $Transaction = array(
                'Id'        => $Transaction,
                'Amount'    => 0,
                'TipAmount' => 0
            );
            foreach($response_arr2["TransactionList"]['Transaction'] as $v) {
                if(!empty($v['Amount'])) {
                    $Transaction['Amount'] += $v['Amount'];
                }
                if(!empty($v['TipAmount'])) {
                    $Transaction['TipAmount'] += $v['TipAmount'];
                }
            }
        }
        $pos_complete = new pos00_complete_payment(
            $pos00_04_nr01,
            $response_arr2["Id"],
            $Transaction['Amount'] / 100,
            $Transaction['TipAmount'] / 100,
            $response_arr2['TransactionId'],
            $Transaction['Id']
        );
        pos00_add_external_log(
            $request['url'],
            "pos00_euronet2_check_transaction:success",
            "Ο έλεγχος πληρωμής εκτελέστηκε με επιτυχία",
            $request['data'],
            $response_arr2,
            false,
            $log_p_sign
        );
    
        return $pos_complete->on_successful_payment();
    }
    /**
     * Στην περίπτωση που δοκιμάσουμε να πάρουμε νέο API Key για μια Συσκευή POS Euronet Web ECR 
     * τότε ενημερώνουμε όλες τις υπόλοιπες  Συσκευή POS Euronet Web ECR που έχουν τα ίδια τερματικά 
     * με το αυτή την συσκευή με το νέο API Key.
     *
     * @param  integer $pos00_01_nr01
     * @param  string  $euronet2_api_key
     * @return void
     */
    function pos00_euronet2_update_api_key_by_tidnsp($pos00_01_nr01 = 0) {
        /**
         * Ενημερώνουμε τα τερματικά για αυτήν την  Συσκευή POS Euronet Web ECR
         */
        $pos00_euronet2_find_pos_resp = pos00_euronet2_find_pos($pos00_01_nr01);
        if($pos00_euronet2_find_pos_resp['ok'] != 1) {
            return $pos00_euronet2_find_pos_resp;
        }
        /**
         * Ενημερώνουμε όλες τις άλλες συσκευές POS Euronet Web ECR που έχουν τερματικά με το ίδιο tid (TID_NSP) με το API Key του pos00_01 (by pos00_01_nr01)
         */
        $sql = "    UPDATE pos00_01
                    JOIN (	
                            SELECT 
                                    pos00_01.euronet2_api_key,
                                    pos00_01.euronet2_auth_code,
                                    pos00_06_01.pos00_01
                            FROM pos00_01
                            JOIN pos00_06 AS pos00_06_00 ON pos00_06_00.pos00_01 = pos00_01.nr01
                            JOIN pos00_06 As pos00_06_01 ON pos00_06_01.tid = pos00_06_00.tid
                            WHERE pos00_01.nr01 = :pos00_01
                            GROUP BY pos00_06_00.pos00_01
                    ) AS tt
                    SET 
                        pos00_01.euronet2_api_key = tt.euronet2_api_key,
                        pos00_01.euronet2_auth_code = tt.euronet2_auth_code
                    WHERE tt.pos00_01 = pos00_01.nr01
        ";
        $values = array(
            'pos00_01' => $pos00_01_nr01
        );
        pegasus_query($sql, $values);
        return array(
            'ok'    => 1
        );
    }
    function pos00_euronet2_check_profortosi_transaction(
        $pos00_01_nr01,
        $CustomerReference,
        $log_p_sign = ''
    ) {
        pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_01_nr01));
        $data_token = pos00_euronet2_get_token($pos00_01_nr01);
        if ($data_token['ok'] == 0) {
            return $data_token;
        }
        try {
            $request = array(
                'url'		=> pos00_euronet2_get_url() . '/terminal/'.$pos00_01["tidnsp"].'/getpending/',
               'header'    =>  array(
                    'Content-Type: application/json',
                    'Accept: application/json',
                    'User-Agent: Pegasus Web App',
                    'Authorization: Bearer ' . $data_token['euronet2_token'],
                    'X-Api-Key: ' . $pos00_01['euronet2_api_key']
                )
            );
            $pegasus_curl_request_resp = pegasus_curl_request(
                $request['url'],
                false,
                $request['header'],
                array(),
                true
            );
        } catch (Exception $exc) {
            $msg = 'Ο έλεγχος προφόρτωσης επέστρεψε σφάλμα';
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_profortosi_transaction:curl:{$exc->getCode()}",
                $msg,
                array(),
                $pegasus_curl_request_resp,
                true,
                $log_p_sign
            );
            pos00_add_to_log(
                'euronet:check_profortosi',
                $request,
                'CURL: ' . $exc->getMessage(),
                $request['url']
            );
            return array(
                'ok'    => 1,
                'msg'   => $msg
            );
        }
        $response = json_decode($pegasus_curl_request_resp['response'], true);
        if (
            !is_array($response)
            || $pegasus_curl_request_resp['http_code'] != 200
        ) {
            $error = '';
            if (isset($response_arr2['error'])) {
                $error = ": ".$response_arr2['error'];
            }
            $msg = $_SESSION['peg_dic_pos00_pos00_01_euronet2_resp_error'].$error;
            pos00_add_to_log(
                'euronet:check_profortosi',
                $request,
                'JSON: ' . json_last_error_msg(),
                $request['url']
            );
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:http_code:{$pegasus_curl_request_resp['http_code']}",
                $msg,
                array(),
                $pegasus_curl_request_resp,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 0,
                'msg'   => $msg
            );
        }
        if($response['processed_transactions'] == 0) {
            $msg = 'Δεν βρέθηκε καμία προφόρτωση σε αναμονή';
            pos00_add_to_log(
                'euronet:check_profortosi',
                array(),
                print_r($response,true),
                $request['url']
            );
            pos00_add_external_log(
                $request['url'],
                "pos00_euronet2_check_transaction:count",
                $msg,
                array(),
                $response,
                true,
                $log_p_sign
            );
            return array(
                'ok'    => 1,
                'msg'   => $msg
            );
        }
        return array(
            'ok'    => 1
        );
    }

    function pos00_inss_get_url(){
        $url = "https://apierp.inss.com.gr:8001";

        return $url;
    }

    function pos00_inss_get_token($pos00_01_nr01, $log_p_sign='') {
        $data = array("ok"=>1, "msg"=>"", "api"=>array());

        pegasus_mysql_use("select * from pos00_01 where nr01=?", $pos00_01, array($pos00_01_nr01));
        $data['api']['access_token']  = $pos00_01["inss_token"]; 
        $data['api']['refresh_token'] = $pos00_01["inss_refreshtoken"]; 

        if(empty($data['api']['access_token']) || empty($pos00_01["inss_vat_id"])){
            $data = pos00_inss_set_token($pos00_01_nr01, $log_p_sign);
        }

        return $data;
    }

    /**
     * Καλεί το /api/login και σετάρει το pos00_01.inss_token και pos00_01.inss_refreshtoken
     * @param int $pos00_01_nr01
     * @return array [ok, msg, token]
     * 
     */
    function pos00_inss_set_token($pos00_01_nr01, $log_p_sign='') {
        $response = array('ok'=>0, 'msg'=>'');

        $url  = pos00_inss_get_url();        
        $url .= "/api/login";
        
        $curl_options = array(CURLOPT_TIMEOUT_MS => 20000);
        $header       = array(
            'Content-Type: application/json'
        );        

        pegasus_mysql_use("select * from pos00_01 where nr01=?", $pos00_01, array($pos00_01_nr01));

        //Στοχεια TESAE στο INSS API (admin - demo ΑΦΜ "999999999")
        $username = "f.psarra@tesae.com";
        $password = "123Fp!@#";

        //Login με βαση το ΑΦΜ του καθε Πελάτη
        $payload = array(  
            "username"  => $username,
            "password"  => $password,
            "vatNumber" => $pos00_01["inss_vat_id"],
            "timeout"   => 30
        );
        

        //Έλεγχος αν έχει καταχωρηθεί ΑΦΜ για τη Συσκευή
        //Αν δεν έχει καταχωρηθεί ΑΦΜ ΔΕ θα πρεπει να παραγεται token και να γινεται Login
        if(empty($pos00_01["inss_vat_id"])){
            $response['ok']  = 0; 
            $response['msg'] = $_SESSION['peg_dic_pos00_inss_empty_vat_id'];
            
            pos00_add_to_log("inss:api:login:fail", $payload, $response, $url);
            return $response;
        }

        
        try {
            $curl_result = pegasus_curl_request_post($url, json_encode($payload), false, $header, $curl_options, true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("inss:api:login:curl_exception:".$response['code'], array(), $response, $url);
            pos00_add_external_log($url, "inss:api:login:curl_exception:".$response['code'], $response['msg'], array(), $response, true);
            return $response;
        }

        $login = json_decode($curl_result['response'], true);

        if($curl_result['http_code']==200){
            $ok  = 1;
            $msg = $_SESSION['peg_dic_pos00_pos00_01_success_connection'];

            $tokens = array(
                'inss_token'          => $login["access_token"],
                'inss_refreshtoken'   => $login["refresh_token"]
            );            
            pegasus_mysql_update('pos00_01', array_keys($tokens), array_values($tokens), 'nr01 = :nr01', 1, 1, 1, array('nr01'=>$pos00_01_nr01));

            $log_status = "success";

        }else{
            $ok  = 0; 
            $msg = $_SESSION['peg_dic_pos00_pos00_01_wrong_credentials'];   
            $log_status = "fail";
        }
        
        $response['ok']   = $ok; 
        $response['msg']  = $msg;
        $response['code'] = $curl_result['http_code'];
        $response['api']  = $login;

        pos00_add_to_log("inss:api:login:".$log_status.":".$curl_result['http_code'], array(), array(), $url);
        pos00_add_external_log($url, "inss:api:login:".$log_status.":".$curl_result['http_code'], $response['msg'], array(), array(), !$response['ok']);
        
        return $response;
    }

    /**
     *
     * @param  int $pos00_01_nr01
     * @return array
     */
    function pos00_inss_refresh_token($pos00_01_nr01, $log_p_sign=''){
        $response = array('ok'=>0, 'msg'=>'');

        $url  = pos00_inss_get_url();        
        $url .= "/api/token/refresh";

        
        $refresh_token = pegasus_mysql_printfld('pos00_01', 'inss_refreshtoken', 'nr01=?', array($pos00_01_nr01)); 
        
        if(empty($refresh_token)){
            $response['msg'] = "Το refresh token ειναι κενό";
            pos00_add_to_log("inss:api:token:refresh:fail", array(), $response, $url);
            pos00_add_external_log($url, "inss:api:token:refresh:fail", $response['msg'], array(), array(), true);

            return pos00_inss_set_token($pos00_01_nr01);
        }
        
        $curl_options = array(CURLOPT_TIMEOUT_MS => 20000);
        $header       = array(
            'Content-Type: application/json'
        );

        $payload = array(  
            "refreshToken"  => $refresh_token
        );
        
        try {
            $curl_result = pegasus_curl_request_post($url, json_encode($payload), false, $header, $curl_options, true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("inss:api:token:refresh:curl_exception:".$response['code'],array() , $response, $url);
            return $response;
        }

        $refresh = json_decode($curl_result['response'], true);

        if($curl_result['http_code']==200){
            $ok  = 1;
            $msg = $_SESSION['peg_dic_pos00_pos00_01_success_refresh_token'];

            $tokens = array('inss_token' => $refresh["access_token"]);            
            pegasus_mysql_update('pos00_01', array_keys($tokens), array_values($tokens), 'nr01=:nr01', 1, 1, 1, array('nr01'=>$pos00_01_nr01));

            $log_status = "success";

        }else{
            $ok  = 0; 
            $msg = $_SESSION['peg_dic_pos00_pos00_01_fail_find_refresh_token'];   
            $log_status = "fail";
        }

        $response['ok']   = $ok; 
        $response['msg']  = $msg;
        $response['code'] = $curl_result['http_code'];
        $response['api']  = $refresh;

        pos00_add_to_log("inss:api:token:refresh:".$log_status.":".$curl_result['http_code'], array(), $response, $url);


        if(empty($response['token'])){
            /**
             * Αν κάτι δεν πάει καλά και δεν μπορεί να πάρει νέο token από 
             * το refresh token τότε θα πρέπει να δοκιμάσει να ξανά κάνει 
             * login (get token).
             * πχ. Στην περίπτωση expired refresh token.
             */
            return pos00_inss_set_token($pos00_01_nr01);
        }
        
        return $response;
    }

    function pos00_inss_handshake($pos00_01_nr01, $called_after_refresh=false){

        $data_token = pos00_inss_get_token($pos00_01_nr01);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        
        pegasus_mysql_use("select * from pos00_01 where nr01=?", $pos00_01, array($pos00_01_nr01));

        $url  = pos00_inss_get_url();        
        $url .= "/api/process";
        
        $curl_options = array(CURLOPT_TIMEOUT_MS => 20000);
        $header       = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data_token['api']['access_token']
        );

        $payload = array(  
            "SessionID"  => "handshake_".date('YmdHis'),
            "TransType"  => 1,
            "TID"        => $pos00_01['tidnsp']
        );
        
        try {
            $curl_result = pegasus_curl_request_post($url, json_encode($payload), false, $header, $curl_options, true);
        }catch(Exception $e){
            $response['ok']   = 0; 
            $response['msg']  = $e->getMessage();
            $response['code'] = $e->getCode();

            pos00_add_to_log("inss:api:handshake:curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "inss:api:handshake:curl_exception:".$response['code'], $response['msg'], $payload, $response, true);
            return $response;
        }

        $handshake = json_decode($curl_result['response'], true);

        $ok = 0; 
        $log_status = "fail";
        if(!in_array($curl_result['http_code'], array("200"))){
            //Αν http_code!=200
            if(isset($handshake['error']) && !empty($handshake['error'])){
                $msg = $handshake['error'];
            }

            //Έλεγχος σε περιπτωση που πρεπει να εκτελεσω ξανά την ενέργεια με Refresh Token
            if(in_array($curl_result['http_code'], array("401","403")) && $called_after_refresh==false){

                //401: Authentication token missing
                //403: Invalid token

                $data_refresh_token = pos00_inss_refresh_token($pos00_01_nr01);
                if($data_refresh_token['ok']==0){
                    return $data_refresh_token;
                }else{
                    return pos00_inss_handshake($pos00_01_nr01, true);
                }
            }

        }elseif(isset($handshake['status']) && $handshake['status']!="200"){
            //Σφαλμα τύπου: Missing required fields
            if(isset($handshake['error']) && !empty($handshake['error'])){
                $msg = $handshake['error'];
            }

        }elseif($handshake['ResponseCode']!="000"){
            if(isset($handshake['ErrorMsg']) && !empty($handshake['ErrorMsg'])){
                $msg = $handshake['ErrorMsg'];
            }

        }else{
            $ok  = 1; 
            $msg = 'Η επικοινωνία με τη συσκευή πραγματοποιήθηκε επιτυχώς.';    
            $log_status = "success";
        }
        
        $response['ok']   = $ok; 
        $response['msg']  = $msg;
        $response['code'] = $curl_result['http_code'];
        $response['api']  = $handshake;        
        $response['token']  = $data_token;
        

        pos00_add_to_log("inss:api:handshake:".$log_status.":".$curl_result['http_code'], $payload, $response, $url);
        pos00_add_external_log($url, "inss:api:handshake:".$log_status.":".$curl_result['http_code'], $response['msg'], $payload, $response, !$response['ok']);

        
        return $response;
    }
    
    function pos00_inss_send_transaction($pos00_04_nr01, $amount, $called_after_refresh=false){
        $response = array("ok"=>0, "msg"=>"", "pending"=>1);

        pegasus_mysql_use("select * from pos00_04 where nr01=?", $pos00_04, array($pos00_04_nr01));
        pegasus_mysql_use("select * from pos00_01 where nr01=?", $pos00_01, array($pos00_04["pos00_01"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));
        
        $pos00_01_nr01 = $pos00_04["pos00_01"];
    
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            pegasus_mysql_use("select * from t19 where nr01=?", $t19, array($pos00_04['t19']));
            $log_p_sign = $t19["p_sign"];
        }

        $data_token = pos00_inss_get_token($pos00_01_nr01, $log_p_sign);
        if($data_token['ok'] == 0){
            return $data_token;
        }
        
        $status = ($pos00_01['p04']==1) ? "demo" : "live";

        $transaction_type = 2;
        if($kodikos_pistosis<0) {
            //Reversal (refund/void)
            $transaction_type = 5; 

        }elseif($pos00_04['tip']){
            //Purchase With Tip
            $transaction_type = 3; 

        }elseif($pos00_04['instalments']>0){
            //Purchase With Installments
            $transaction_type = 16; 

        }elseif($pos00_04['profortosi']) {
            //Regreceipt
            $transaction_type    = 1002; 
            $response['pending'] = 0; 
        }


        $pos00_04_type = 1; // Sale
        if ($transaction_type==5) {
            $pos00_04_type = 3; // Void
        }

        $descr = pos00_pos00_04_update_descr($pos00_04_type, $pos00_01['p02']);
        $date_time = date("YmdHis");
        //$reference_number  = rand(0, 999999999);
        $pegasus_reference = $pos00_04_nr01 . $date_time;
        
        pegasus_mysql_update("pos00_04", array("p03", "type", "descr"), array($pegasus_reference, $pos00_04_type, $descr), "nr01=?", 0, 1, 1, array($pos00_04_nr01));
        
        

        $url  = pos00_inss_get_url();        
        $url .= "/api/process";
        
        $curl_options = array(CURLOPT_TIMEOUT_MS => 5000);
        $header       = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data_token['api']['access_token']
        );

        $payload = array(  
            "SessionID"     => $pegasus_reference,
            "TransType"     => $transaction_type,
            "TID"           => $pos00_01['tidnsp'],
            "Amount"        => round($amount * 100),
            "type"          => "sync",
            "ProviderID"    => "016",
            "status"        => $status,
            "isNeedPrint"   => true
        );

        switch ($transaction_type) {
            case 3:
                unset($payload["Amount"]);
                $payload["PurchaseAmount"]  = round($amount * 100);
                $payload["TipAmount"]       = round(0 * 100);
                break;
            case 5:
                unset($payload["Amount"]);
                if (!empty($pos00_04['txnidinit'])) {
                    $payload['OrigSequenceNumber'] = $pos00_04['txnidinit'];
                }
                break;
            case 16:
                $payload["InstallmentNum"] = $pos00_04['instalments'];
                break;
            case 1002:
                $payload["Time"] = $date_time;
                break;

            default:
                break;
        }


        if (!empty($pos00_04['t19'])) {            
            $payload["SignatureInput"] = $t19['p_sign_s'];
            $payload["Signature"]      = $t19['p_sign'];
        }     

        
        try {
            $curl_result = pegasus_curl_request_post($url, json_encode($payload), false, $header, $curl_options, true);
        }catch(Exception $e){

            if ($e->getCode()==CURLE_OPERATION_TIMEDOUT) {
                $response['ok']   = 1; 
                $response['msg']  = $_SESSION['peg_dic_pos00_inss_curl_timeout'];
            }else{
                $response['ok']   = 0; 
                $response['msg']  = $e->getMessage();
            }
            
            $response['code'] = $e->getCode();

            pos00_add_to_log("inss:api:process:transtype:".$transaction_type.":curl_exception:".$response['code'], $payload, $response, $url);
            pos00_add_external_log($url, "inss:api:process:transtype:".$transaction_type.":curl_exception:".$response['code'], $response['msg'], $payload, $response, true, $log_p_sign);
            
            return $response;
        }

        $transaction = json_decode($curl_result['response'], true);

        $ok = 0; 
        $log_status = "fail";
        if(!in_array($curl_result['http_code'], array("200"))){
            //Αν http_code!=200
            if(isset($transaction['error']) && !empty($transaction['error'])){
                $msg = $transaction['error'];
            }

            //Έλεγχος σε περιπτωση που πρεπει να εκτελεσω ξανά την ενέργεια με Refresh Token
            if(in_array($curl_result['http_code'], array("401","403")) && $called_after_refresh==false){
                //401: Authentication token missing
                //403: Invalid token

                $data_refresh_token = pos00_inss_refresh_token($pos00_01_nr01, $log_p_sign);
                if($data_refresh_token['ok']==0){
                    return $data_refresh_token;
                }else{
                    return pos00_inss_send_transaction($pos00_04_nr01, $amount, true);
                }
            }

        }elseif(isset($transaction['status']) && $transaction['status']!="200"){
            //Σφαλμα τύπου: Missing required fields
            if(isset($transaction['error']) && !empty($transaction['error'])){
                $msg = $transaction['error'];
            }

        }elseif($transaction['ResponseCode']!="000"){
            if(isset($transaction['ErrorMsg']) && !empty($transaction['ErrorMsg'])){
                $msg = $transaction['ErrorMsg'];
            }

        }else{
            $ok  = 1; 
            $msg = 'Η συναλλαγή πραγματοποιήθηκε επιτυχώς.';    
            $log_status = "success";
        }
        
        $response['ok']   = $ok; 
        $response['msg']  = $msg;
        $response['code'] = $curl_result['http_code'];
        $response['api']  = $transaction;

        pos00_add_to_log("inss:api:process:transtype:".$transaction_type.":".$log_status.":".$curl_result['http_code'], $payload, $response, $url);
        pos00_add_external_log($url, "inss:api:process:transtype:".$transaction_type.":".$log_status.":".$curl_result['http_code'], $response['msg'], $payload, $response, !$response['ok'], $log_p_sign);


        //Στην "pos00_check_send_transaction" θα προχωρώ σε on_failed_payment/on_successful_payment
        
        return $response;
    }

    function pos00_inss_check_transaction($pos00_04_nr01, $called_after_refresh=false){
        $response = array("ok"=>0, "msg"=>"", "pending"=>0);

        pegasus_mysql_use("select * from pos00_04 where nr01=?", $pos00_04, array($pos00_04_nr01));
        pegasus_mysql_use("select * from pos00_01 where nr01=?", $pos00_01, array($pos00_04["pos00_01"]));
        $kodikos_pistosis = pegasus_mysql_printfld("t02", "p04", "p01=?", array($pos00_04["t02p01"]));
        
        $pos00_01_nr01 = $pos00_04["pos00_01"];
    
        $log_p_sign = '';
        if(!empty($pos00_04['t19'])) {
            pegasus_mysql_use("select * from t19 where nr01=?", $t19, array($pos00_04['t19']));
            $log_p_sign = $t19["p_sign"];
        }

        $data_token = pos00_inss_get_token($pos00_01_nr01, $log_p_sign);
        if($data_token['ok'] == 0){
            return $data_token;
        }

        $url  = pos00_inss_get_url();        
        $url .= "/api/transaction/".$pos00_04["p03"];
        
        $curl_options = array(CURLOPT_TIMEOUT_MS => 20000);
        $header       = array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $data_token['api']['access_token']
        );

        
        try {
            $curl_result = pegasus_curl_request($url, false, $header, $curl_options, true);
        }catch(Exception $e){

            if ($e->getCode()==CURLE_OPERATION_TIMEDOUT) {
                $response['ok']   = 1; 
                $response['msg']  = $_SESSION['peg_dic_pos00_inss_curl_timeout'];
            }else{
                $response['ok']   = 0; 
                $response['msg']  = $e->getMessage();
            }
            
            $response['code'] = $e->getCode();

            pos00_add_to_log("inss:api:process:transaction:curl_exception:".$response['code'], array($pos00_04["p03"]), $response, $url);
            pos00_add_external_log($url, "inss:api:process:transaction:curl_exception:".$response['code'], $response['msg'], array($pos00_04["p03"]), $response, true, $log_p_sign);
            
            return $response;
        }


        $transaction = json_decode($curl_result['response'], true);
        
        $ok = 0; 
        $log_status = "fail";
        if(!in_array($curl_result['http_code'], array("200"))){
            //Αν http_code!=200
            if(isset($transaction['error']) && !empty($transaction['error'])){
                $msg = $transaction['error'];
            }

            //Έλεγχος σε περιπτωση που πρεπει να εκτελεσω ξανά την ενέργεια με Refresh Token
            if(in_array($curl_result['http_code'], array("401","403")) && $called_after_refresh==false){
                //401: Authentication token missing
                //403: Invalid token

                $data_refresh_token = pos00_inss_refresh_token($pos00_01_nr01, $log_p_sign);
                if($data_refresh_token['ok']==0){
                    return $data_refresh_token;
                }else{
                    return pos00_inss_check_transaction($pos00_04_nr01, true);
                }
            }elseif($curl_result['http_code']=="409"){
                //"Transaction is still processing"
                $msg = 'Η συναλλαγή δεν έχει ολοκληρωθεί';
                $response['pending'] = 1;
            }

        }elseif($transaction['ResponseCode']!="000"){
            if(isset($transaction['ErrorMsg']) && !empty($transaction['ErrorMsg'])){
                $msg = $transaction['ErrorMsg'];
            }

        }else{
            $ok  = 1; 
            $msg = 'Η συναλλαγή πραγματοποιήθηκε επιτυχώς.';      
            $log_status = "success";
        }
        
        $response['ok']   = $ok; 
        $response['msg']  = $msg;
        $response['code'] = $curl_result['http_code'];
        $response['api']  = $transaction;
        

        pos00_add_to_log("inss:api:process:transaction:".$log_status.":".$curl_result['http_code'], array($pos00_04["p03"]), $response, $url);
        pos00_add_external_log($url, "inss:api:process:transaction:".$log_status.":".$curl_result['http_code'], $response['msg'], array($pos00_04["p03"]), $response, !$response['ok'], $log_p_sign);


        if($curl_result['http_code']=="200" && isset($transaction['ResponseCode'])){


            if($transaction['ResponseCode']=="000" && !empty($transaction["transactionId"])){
                //Success
                switch ($transaction['TransType']) {
                    case 3:
                        $amount     = $transaction["PurchaseAmount"];
                        $tip_amount = $transaction["TipAmount"];
                        break;
    
                    default:
                        $amount     = $transaction["Amount"];
                        $tip_amount = 0;
                        break;
                }
    
                $pos_complete = new pos00_complete_payment(
                    $pos00_04_nr01, 
                    $transaction['SessionID'],
                    $amount/100,
                    $tip_amount/100,
                    $transaction["transactionId"],
                    $transaction["SequenceNumber"]
                );   
    
                return $pos_complete->on_successful_payment(); 

            }else{
                //Fail
                $pos_complete = new pos00_complete_payment(
                    $pos00_04_nr01,
                    $pos00_04['p01']
                );
        
                return $pos_complete->on_failed_payment($response['msg']);
            }

        }

        //Σε όλες τις αλλες περιπτώσεις ΔΕΝ κανει Complete Payment (Success/Fail)
        return $response;  
    }
    
    function pos00_pos00_04_update_descr($type = 0, $pos00_01_type = 0) {

        $descr = pos00_device_properties::get_pos_type_description($pos00_01_type);
        switch ($type) {
            case 1:
                $descr = 'SALE: ' . $descr;
                break;
            case 2:
                $descr = 'REFUND: ' . $descr;
                break;
            case 3: 
                $descr = 'VOID: ' . $descr;
                break;
            default:
                $descr = $descr;
        }
        return $descr;
    }

    function pos00_check_pos00_01_terminal($pos00_01_nr01){

        $pos00_01 = array();

        $query  = "select pos00_01.nr01, pos00_02.nr01 as pos00_02_nr01, t18.nr01 as t18_nr01 ";
        $query .= "from pos00_01 ";
        $query .= "left join pos00_02 on pos00_02.pos00_01=pos00_01.nr01 and pos00_02.cor003p01=:cor003p01 ";
        $query .= "left join t18 on t18.pos00_01=pos00_01.nr01 and t18.cor003p01=:cor003p01 ";
        $query .= "where pos00_01.nr01=:pos00_01_nr01 and (pos00_02.nr01 is not null or t18.nr01 is not null) ";
        $query .= "group by pos00_01.nr01;";

        $values_arr = array(
            "cor003p01"     => $_SESSION["cor003_p01"],
            "pos00_01_nr01" => $pos00_01_nr01
        );

        pegasus_mysql_use($query, $pos00_01, $values_arr);

        if($pos00_01['nr01']>0){
            return true;
        }else{
            return false;
        }
    }

    function pos00_pos00_d07_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {   
        global $PegInput;
        $PegInput->addVar(new peg_input_number('pos00_04_nr01'));
        $PegInput->addVar(new peg_input_number('v_profortosi'));
        $pos00_04_nr01 = $PegInput->getRequest('pos00_04_nr01');
        $v_profortosi = $PegInput->getRequest('v_profortosi');
        
        $data['v_message'] = $_SESSION['peg_dic_pos00_trans_submit_transaction'];
        if($v_profortosi == 1) {
            $data['peg_screenTitle'] = $_SESSION['peg_dic_pos00_d04_profortosi_title'];
            $data['v_message'] = $_SESSION['peg_dic_pos00_d04_profortosi_message'];
            $data['btn_00_text'] = $_SESSION['peg_dic_pos00_d04_profortosi_btn'];
        }
        $data['v_message_readonly'] = 1;    
        $data["pos00_04_nr01"] = $pos00_04_nr01;
        
        return $data;
    }

    function pos00_pos00_d08_initialize($data, $mmnr01, $mnr01, $_d, $container_id) {   
        
        global $PegInput;
        $PegInput->addVar(new peg_input_number('pos00_04_nr01'));
        $PegInput->addVar(new peg_input_number('v_profortosi'));

        $pos00_04_nr01 = $PegInput->getRequest('pos00_04_nr01');
        $v_profortosi  = $PegInput->getRequest('v_profortosi');
        
        $data['v_message'] = $_SESSION['peg_dic_pos00_trans_submit_transaction'];
        if($v_profortosi == 1) {
            $data['peg_screenTitle'] = $_SESSION['peg_dic_pos00_d04_profortosi_title'];
            $data['v_message']       = $_SESSION['peg_dic_pos00_d04_profortosi_message'];
            $data['btn_00_text']     = $_SESSION['peg_dic_pos00_d04_profortosi_btn'];
        }

        $data['v_message_readonly'] = 1;    
        $data["pos00_04_nr01"]      = $pos00_04_nr01;
        
        return $data;
    }