<?php

    /**
     * Στάδιο - Sync:                            $exec = "sync";
     * Στάδιο - Sync (Response):                 $exec = "sync_resp";
     * Στάδιο - Εύρεση Πληρωμών:                 $exec = "get";
     * Στάδιο - Εύρεση Πληρωμών (Response):      $exec = "get_resp";
     * Τερματισμός εκτέλεσης:                    $exec = "-1";
     */

    global $PegInput;
    require_once('../pos00_00/header.php');
    $response = array("ok"=>1, "msg"=>"", "exec"=>"", "exec_sync"=>0, "exec_sync_nr01"=>0);  

        

    $PegInput->addVar(new peg_input_alphanumeric('pos00_04_recs'));
    $PegInput->addVar(new peg_input_number('pos00_01_nr01'));
    $PegInput->addVar(new peg_input_number('pos00_04_nr01'));
    $PegInput->addVar(new peg_input_number('exec_sync'));
    $PegInput->addVar(new peg_input_number('exec_sync_nr01'));
    $PegInput->addVar(new peg_input_alphanumeric('exec'));
    $PegInput->addVar(new peg_input_alphanumeric('message'));
    $PegInput->addVar(new peg_input_alphanumeric('message_base64'));
    $PegInput->addVar(new peg_input_alphanumeric('action'));
    

    $pos00_04_recs      = $PegInput->getRequest('pos00_04_recs');
    $pos00_01_nr01      = $PegInput->getRequest('pos00_01_nr01');
    $pos00_04_nr01      = $PegInput->getRequest('pos00_04_nr01');
    $exec_sync          = $PegInput->getRequest('exec_sync');
    $exec_sync_nr01     = $PegInput->getRequest('exec_sync_nr01');
    $exec               = $PegInput->getRequest('exec');
    $message            = $PegInput->getRequest('message');
    $data_base64        = $PegInput->getRequest('message_base64');
    $action             = $PegInput->getRequest('action');


    $exec               = (isset($exec) && !empty($exec)) ? $exec : "sync";
    $exec_sync          = (isset($exec_sync)) ? $exec_sync : 0;
    $exec_sync_nr01     = (isset($exec_sync_nr01)) ? $exec_sync_nr01 : 0;

    $pos00_04_recs_arr  = explode(",", $pos00_04_recs);


    //Σε περίπτωση που δεν εχουμε POS Πληρωμές προς Ενημέρωση ολοκληρώνουμε τη διαδικασια
    if(empty($pos00_04_recs) && !($pos00_04_nr01>0)){
        $response['msg']    = $_SESSION["peg_dic_pos00_dashboard_update_completed"];
        $response['exec']   = "-1"; 
        echo json_encode($response);
        return;
    }
    

    /**
     * Στάδιο - Sync
     * Έλεγχος πριν ξεκινήσει η Ενημέρωση των Επιλεγμένων POS Πληρωμών
     * Αν οι επιλεγμένες POS Πληρωμές ανηκουν στο συγκεκριμένο Τερματικό κι αντιστοιχούν σε Συσκευής POS με ενεργή τη λειτουργία "Sync" 
     * Εκτελούμε πρώτα τη λειτουργία "Sync" για καθε Συσκευής POS
     * Διαδοχικά requests με $exec_sync_nr01=pos00_01.nr01
     */
    if($exec=="sync"){
        $response['pos00_04_recs'] = $pos00_04_recs;

        $nr01_in_stm    = pegasus_mysql_create_in($pos00_04_recs_arr, 'nr01');
        $values_arr     = $nr01_in_stm['sqlParams'];
        $values_arr['exec_sync_nr01'] = $exec_sync_nr01;
        
        //Ψάχνουμε να βρουμε την επόμενη Συσκευή που έχει ενεργό το Sync (EDPS:6)
        $query  = "select count(*) as cnt, pos00_01, pos00_01.p01 as pos00_01_p01, pos00_01.p02 as pos00_01_p02 ";
        $query .= "from pos00_04 ";
        $query .= "join pos00_01 on pos00_01.nr01=pos00_04.pos00_01 ";
        //$query .= "where pos00_01.p02 in ('6') and pos00_01.nr01>:exec_sync_nr01 ";
        $query .= "where pos00_01.p02 in ('6') and pos00_01.nr01>:exec_sync_nr01 and pos00_04.nr01 in (".$nr01_in_stm['sql'].") ";
        $query .= "group by pos00_01.nr01 ";
        $query .= "order by pos00_01.nr01";

        $result       = pegasus_query($query, $values_arr);
        $pos00_04_arr = pegasus_fetchall($result);

        if(!($exec_sync_nr01>0)){
            $response['msg'] = "<strong>Συγχρονισμός Συσκευών</strong>"."<br><br>";
        }

        foreach ($pos00_04_arr as $pos00_04_tmp) {
            if(pos00_check_pos00_01_terminal($pos00_04_tmp["pos00_01"])){

                $response['exec']               = "sync_resp"; 
                $response['msg']               .= str_replace('##pos00_01_p01##', '<strong>'.$pos00_04_tmp["pos00_01_p01"].'</strong>', $_SESSION['peg_dic_pos00_pos00_01_sync_'.$pos00_04_tmp["pos00_01_p02"]]); 
                $response['exec_sync']          = $pos00_04_tmp["pos00_01_p02"]; 
                $response['exec_sync_nr01']     = $pos00_04_tmp["pos00_01"];
                $response['data']               = array();


                $pos00_01_arr = pos00_find_pos00_01($pos00_04_tmp["pos00_01"]);
                if($pos00_04_tmp["pos00_01_p02"]==6){
                    //Check Connection with the EDPS POS Device    
                    $check_params = pos00_edps_check_device_params($pos00_01_arr["edps_pos00_03"], $pos00_01_arr["edps_ip"], $pos00_01_arr["edps_port"]);

                    if($check_params["ok"]==1) {
                        $response['data']                   = $check_params["data"];
                        $response['data']['message_base64'] = base64_encode('{"msgType":"SyncRequest"}');
                    }else{
                        $response['msg'] .= "<br>&emsp;&emsp;&emsp;".$check_params["msg"];
                    }
                    
                }
                
                //GoTo Στάδιο - Sync (Response)
                echo json_encode($response);
                return;
            }
        }  
        
        //GoTo Στάδιο - Εύρεση Πληρωμών
        $response['exec']           = "get";
        $response['msg']            = "<br><br>"."<strong>Ενημέρωση Επιλεγμένων από EFT/POS</strong>"."<br>";
        $response['pos00_04_recs']  = $pos00_04_recs;
        $response['exec_sync']      = 0; 
        $response['exec_sync_nr01'] = 0;
        echo json_encode($response);
        return;


    }elseif($exec=="sync_resp"){
        //Στάδιο - Sync Response
        if($exec_sync>0){ 
            $exec = "sync";            
            $response['data'] = array();

            if($exec_sync==6){   
                //EDPS Sync Response  
                $data = json_decode(base64_decode($data_base64), true);
                $edps_response = pos00_edps_sync_response($data, $message);

                $response['msg'] = $edps_response['msg'];
                //$response['dbg'] = $data;

            }

            
            //GoTo Στάδιο - Sync
            $response['οκ']                     = 1; 
            $response['exec']                   = $exec; 
            $response['action']                 = $action;
            $response['pos00_04_recs']          = $pos00_04_recs;
            $response['exec_sync_nr01']         = $exec_sync_nr01;
            $response['data']['message_base64'] = "";
            
            echo json_encode($response);
            return;
        }


        //GoTo Στάδιο - Sync (Response)
        $response['exec']           = "sync";
        $response['msg']           .= "<br>";
        $response['pos00_04_recs']  = $pos00_04_recs;
        $response['exec_sync']      = 0; 
        $response['exec_sync_nr01'] = $exec_sync_nr01;
        echo json_encode($response);
        return;


    }elseif($exec=="get"){

        //Στάδιο - Εύρεση Πληρωμών
        //Διαβαζω & Αφαιρώ το πρωτο ΜΚ απο τις επιλεγμένες Πληρωμές σε περιπτωση που δεν περιμένω Websocket Get Resonse (EDPS)            
        $pos00_04_nr01 = array_shift($pos00_04_recs_arr);
        $pos00_04_recs = implode(',', $pos00_04_recs_arr);


        if($pos00_04_nr01>0){
        
            $query  = "select pos00_04.*, pos00_01.p02 as pos00_01_p02 ";
            $query .= "from pos00_04 ";
            $query .= "join pos00_01 on pos00_01.nr01=pos00_04.pos00_01 ";
            $query .= "where pos00_04.nr01=:pos00_04_nr01 ";
    
            pegasus_mysql_use($query, $pos00_04_arr, array("pos00_04_nr01"=>$pos00_04_nr01));
            $response['data']['pos00_04'] = $pos00_04_arr;
    
            $device_properties  = pos00_device_properties::get_properties($pos00_04_arr["pos00_01_p02"]);
            $msg                = "ΜΚ: " . $pos00_04_arr['nr01'] . " | " . $pos00_04_arr['descr'] . ':  ';
    
            if($device_properties['receive_one']==true) {
    
                if($pos00_04_arr["pos00_01_p02"]==4){                
                    //Viva
                    $viva_wallet       = new viva_wallet_api();        
                    $check_transaction = $viva_wallet->retrieve_session_by_id($pos00_04_arr["nr01"]);

                    $response['data']['api']    = $check_transaction;
                    $response['msg']            = $msg . $check_transaction['msg'];
    
                }elseif($pos00_04_arr["pos00_01_p02"]==5){                
                    //Mellon v2
                    $check_transaction          = pos00_mellv2_check_transaction($pos00_04_arr["nr01"]);
                    $response['data']['api']    = $check_transaction;
                    $response['msg']            = $msg . $check_transaction['msg'];
    
                }elseif($pos00_04_arr["pos00_01_p02"]==8){               
                    //Euronet v2
                    $check_transaction          = pos00_euronet2_check_transaction($pos00_04_arr["nr01"]);
                    $response['data']['api']    = $check_transaction;
                    $response['msg']            = $msg . $check_transaction['msg'];
    
                }elseif($pos00_04_arr["pos00_01_p02"]==9) {
                    //Neosoft
                    $check_transaction          = pos00_neosoft_check_transaction($pos00_04_arr["nr01"]);
                    $response['data']['api']    = $check_transaction;
                    $response['msg']            = $msg . $check_transaction['msg'];
                    
                }elseif($pos00_04_arr["pos00_01_p02"]==6) {              
                    //EDPS
                    $pos00_01_arr = pos00_find_pos00_01($pos00_04_arr["pos00_01"]);
    
                    if(!pos00_check_pos00_01_terminal($pos00_01_arr["nr01"])){
                        $response['msg'] = "Η συσκευή POS '##pos00_01_p01##' δεν ειναι προσβασιμη απο αυτο το Τερματικο Web Client";
                        $response['msg'] = $msg . str_replace('##pos00_01_p01##', $pos00_01_arr["p01"], $response['msg']);
                    }else{
                        //EDPS Get Reuest
                        $response['data']['pos00_01'] = $pos00_01_arr;  
                        
                        //Check Connection with the EDPS POS Device    
                        $check_params = pos00_edps_check_device_params($pos00_01_arr["edps_pos00_03"], $pos00_01_arr["edps_ip"], $pos00_01_arr["edps_port"]);

                        $response['msg'] = $msg;
                        if($check_params["ok"]==1) {
                            $exec = "get_resp";
                            $response['data']                   = array_merge($response['data'], $check_params["data"]);
                            $response['data']['message_base64'] = base64_encode('{"msgType":"GetTxnRequest", "ecrRefNo": "'.$pos00_04_arr["p01"].'"}');
                        }else{
                            $response['msg'] .= "<br>&emsp;&emsp;&emsp;".$check_params["msg"];
                        }
                    }

                }elseif($pos00_04_arr["pos00_01_p02"]==7) {     
                    /** @deprecated [Cardlink (6.3) | Συμβατή με Α1155] */
                    $response['msg']            = $msg.'<span style="color:#FF0000;">'.$_SESSION["peg_dic_pos00_cardlink_preload_not_compatible"].'</span>'; 
                    $response['exec']           = $exec;
                    $response['pos00_04_recs']  = $pos00_04_recs;
                    echo json_encode($response);
                    return;
                }
    
            }else{
                $response['msg'] = $msg . 'peg_dic_pos00_dashboard_receive_one_no_supp';
            }
            
        }

    }elseif($exec=="get_resp"){
        //Στάδιο - Εύρεση Πληρωμών (Response)            
        $exec = "get";
        if($pos00_04_nr01>0){
        
            $query  = "select pos00_04.*, pos00_01.p02 as pos00_01_p02 ";
            $query .= "from pos00_04 ";
            $query .= "join pos00_01 on pos00_01.nr01=pos00_04.pos00_01 ";
            $query .= "where pos00_04.nr01=:pos00_04_nr01 ";
    
            pegasus_mysql_use($query, $pos00_04_arr, array("pos00_04_nr01"=>$pos00_04_nr01));
            $response['data']['pos00_04'] = $pos00_04_arr;
    
            $device_properties = pos00_device_properties::get_properties($pos00_04_arr["pos00_01_p02"]);
    
            if($device_properties['receive_one']==true) {
                
                if(in_array($pos00_04_arr["pos00_01_p02"], array('6'))){               
                    //EDPS Get Response
                    $pos00_01_arr = pos00_find_pos00_01($pos00_04_arr["pos00_01"]);
    
                    if(!pos00_check_pos00_01_terminal($pos00_01_arr["nr01"])){
                        $response['msg'] = "Η συσκευή POS '##pos00_01_p01##' δεν ειναι προσβασιμη απο αυτο το Τερματικο Web Client";
                        $response['msg'] = str_replace('##pos00_01_p01##', $pos00_01_arr["p01"], $response['msg']);
                    }else{
                        
                        if($pos00_04_arr["pos00_01_p02"]==6){ 
                            $data = json_decode(base64_decode($data_base64), true);
                            $edps_response = pos00_edps_get_response($pos00_04_arr["nr01"], $data, $message);

                            $response['msg'] = $edps_response['msg'];
                            $response['ok']  = 1;
                        }
                    }
                }
    
            }
        }
    }
    
    $response['exec']           = $exec;
    $response['pos00_04_recs']  = $pos00_04_recs;
    echo json_encode($response);
    return;