<?php
    
    if(class_exists('FPDI')===false){
        require_once('../../pegasus_cloud_app/prints_libs/FPDI/fpdi.php'); 
    }
    
    
    class PrintsElement {

        protected $table;
        protected $data;
        protected $fields;
    
        public function __construct($tableData=null){

            if(!is_array($tableData)){
                pegasus_mysql_use('select * from '.$this->table.' where nr01=:nr01', $data, array('nr01'=>$tableData));
            }else{
                $data = $tableData;    
            }

            $this->setFields();
            foreach ($this->getFields() as $fld) {
                $this->data[$fld] = $data[$fld];
            }
        }

        public function create(){
            $this->data['nr01'] = pegasus_mysql_newrec($this->table);
            pegasus_mysql_insert($this->table, array_keys($this->data), array_values($this->data));
        }

        public function delete(){
            if($this->data['nr01']>0){
                pegasus_mysql_delete($this->table, 'nr01=:nr01',  0, array('nr01'=>$this->data['nr01']));
            } 
        }


        public function setFields(){            
            $this->fields = array();
        }

        public function getFields(){   
            return $this->fields;
        }


        public function __get($key) {
            if(isset($this->data[$key])) {
                return $this->data[$key];
            }
        }

        public function __set($key, $value) {
            if(isset($this->data[$key])) {
                $this->data[$key] = $value;
            }
        }
    }

    class PrintsP85 extends PrintsElement {

        protected $table   = 'p85';
        protected $maxNr01 = 140000000000000;
        protected $data;
        protected $fields;

        protected $p86Records;
        protected $prints_02Records; 

        
        public function addP86(PrintsP86 $p86){    
            $this->p86Records[] = $p86;
        }

        public function create(){

            //Insert P85
            $this->data['nr01'] = pegasus_mysql_newrec('p85');
            if($this->data['nr01']<$this->maxNr01){
                pegasus_mysql_insert('p85', array_keys($this->data), array_values($this->data));
    
                foreach ($this->p86Records as $p86) {
                    $p86->p85 = $this->data['nr01'];
                    $p86->create();
                }
            }
        }

        public function delete($remakeNr01=true){             
            if($this->data['nr01']>0){
                pegasus_mysql_delete('p85', 'nr01=:p85',  0, array('p85'=>$this->data['nr01']));   
                pegasus_mysql_delete('p86', 'p85=:p85',   0, array('p85'=>$this->data['nr01'])); 
                
                if($remakeNr01==true){
                    $this->remakeNr01();
                }
            }
        }

        protected function remakeNr01(){
            pegasus_mysql_remake_p75('p85'); 
            pegasus_mysql_remake_p75('p86');
            pegasus_mysql_remake_p75('prints_02');
        }

        public function setFields(){            
            $this->fields = array(
                'nr01','p01','ep01','module','is_std','p50','q10','p50_class','classtype','p300',
                'orient','pagesize','height','width','rows','cols','body_height','headfootonce','mtop','mbot','mleft','mright',
                'main_style','rolling_paper','rotate','hpos','vpos','code','body_sql_code','p30'
            );
        }
    }

    class PrintsP86 extends PrintsElement {

        protected $table = 'p86';
        protected $data;
        protected $fields;        

        public function setFields(){            
            $this->fields = array(
                'nr01','p85','tax','pos','tp',
                'col','col0','row','row0','size','align','rotate',
                'descr','prints_01p00','p30','cond','p87'
            );
        }
    }

    class PrintsQ10P85 {
        
        private $q10Nr01;
        private $p85Nr01;

        private $p85UserData;

        public function __construct($q10Nr01=0){
            $this->q10Nr01 = $q10Nr01;

            $query  = 'select nr01, p300 ';
            $query .= 'from p85 ';
            $query .= 'where q10=:q10Nr01 and is_std=1 and nr01<"140000000000000";';
            pegasus_mysql_use($query, $p85, array('q10Nr01'=>$this->q10Nr01));

            if($p85['nr01']>0){
                $this->p85Nr01 = $p85['nr01'];

                $this->p85UserData = array(
                    'p300' => $p85['p300'],    
                );
            }
        }  
        
        public function getP85Nr01(){
            return $this->p85Nr01;
        }

        public function create(){     
            
            if(!($this->q10Nr01>0)){
                throw new Exception('nr01 check failed');
            }
            
            if($this->p85Nr01>0){
                $this->delete();   
            }

            $data = $this->makeP85();
            $p85  = new PrintsP85($data['p85']);              
            foreach ($data['p86'] as $p86_data) {
                $p86 = new PrintsP86($p86_data);
                $p85->addP86($p86);
            }
            $p85->create();
    
        }   
        
        public function delete($remakeNr01=true){    
            $p85 = new PrintsP85($this->p85Nr01);
            $p85->delete($remakeNr01);    
        }

        public function makeP85(){
            
            //Set P85 Data from Q10
            $values_arr = array('q10nr01'=>$this->q10Nr01);
            $query_q10  = 'select * from q10 where nr01=:q10nr01;';
            pegasus_mysql_use($query_q10, $q10, $values_arr);


            //P: Portrait   0<char size<XX
            //L: Landscape XX<char size<155
            $total_fields_size = query_q12_get_fields_total_size($this->q10Nr01);
            if($total_fields_size<=90){                
                $b_height = 56;
                $orient   = 'P';
                $rows     = 74;
                $cols     = 95;
            }elseif($total_fields_size<=155){
                $b_height = 42;
                $orient   = 'L';
                $rows     = 60;
                $cols     = 160;
            }else{
                throw new Exception($_SESSION['peg_dic_prints_q10_p85_char_size_limit']);
            }

            $code = '$print_to_pdf_version = "function";';
            
            //Exp Memo
            $total_vars_memo = 0;
            $total_vars_memo = pegasus_mysql_printfld('q13', 'count(*)', 'p00=:q10nr01 and p012=1', $values_arr);
            
            
            $total_vars      = pegasus_mysql_printfld('q13', 'count(*)', 'p00=:q10nr01', $values_arr);
            $total_vars     += 2*$total_vars_memo;
            $body_height     = ($total_vars>8) ? ($b_height - ($total_vars-8)) : ($b_height);

            $p300 = 1;
            foreach ($this->p85UserData as $key => $value) {
                ${$key} = $value;
            }
            
            $p85_data = array(
                'nr01'          => 0,
                'p01'           => $q10['p01'],
                'ep01'          => $q10['ep01'],
                'is_std'        => 1,
                'q10'           => $q10['nr01'],
                'classtype'     => 2,
                'p300'          => $p300,
                'orient'        => $orient,
                'pagesize'      => 'A4',
                'height'        => 297,
                'width'         => 210,
                'rows'          => $rows,
                'cols'          => $cols,
                'body_height'   => $body_height,
                'headfootonce'  => 0,
                'mtop'          => 2,
                'mbot'          => 2,
                'mleft'         => 2,
                'mright'        => 2,
                'main_style'    => '140000000000010',
                'code'          => $code,
                'body_sql_code' => ''
            );

            //Make P86 Data
            $p86_data = $this->makeP86($p85_data);


            $data = array(
                'p85' => $p85_data,
                'p86' => $p86_data,
            );

            return $data;
        }

        public function makeP86($p85_data){
            
            $max_row = $p85_data['rows'] - $p85_data['mtop']  - $p85_data['mbot']; 
            $max_col = $p85_data['cols'] - $p85_data['mleft'] - $p85_data['mright']; 

            $p86_data   = array(); 
            $values_arr = array('q10nr01'=>$this->q10Nr01);            
            
            //$p85_data['orient']=='P'
            
            //Core Titles
            for($i=1; $i<=8; $i++){ 
                $col  = 0;
                $col0 = ($p85_data['orient']=='P') ? 40 : 60;

                $prints_01p00 = 'cor000_tit_line'.$i;    $descr = $i.'η Γραμμή Τίτλου';
                $p30 = 'return array("text"=>$pdf->printsData->getData("'.$prints_01p00.'"), "autoSizing"=>true);'."\n" . '/* ' . $descr . ' */';
                $p86_data[] = array(
                    'p85'=>$p85_data['nr01'],  
                    'tax'=>10,      'pos'=>1,   'tp'=>'exp', 'p30'=>$p30,   'cond'=>'',
                    'row'=>($i-1),  'row0'=>0,  'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 
                    'descr'=>$descr,'prints_01p00'=>$prints_01p00, 'p87'=>'140000000000001'
                ); 
            }


            //π-αναφορά 

            //Τίτλος
            $col  = ($p85_data['orient']=='P') ? 38 : 60;
            $col0 = ($p85_data['orient']=='P') ? 80 : 120;
            
            $prints_01p00 = 'q10_nr01_q10_nr01_p01';
            $p30 = 'return array("text"=>$pdf->printsData->getData("'.$prints_01p00.'"), "autoSizing"=>true);';
            $p86_data[] = array(
                'p85'=>$p85_data['nr01'],  
                'tax'=>30, 'pos'=>1,   'tp'=>'exp',    'p30'=>$p30,    'cond'=>'',
                'row'=>0,  'row0'=>0,  'col'=>$col,    'col0'=>$col0,  'size'=>($col0-$col),
                'descr'=>'Περιγραφή (el)','prints_01p00'=>$prints_01p00, 'p87'=>'140000000000001'
            );
            //Line
            $p86_data[] = array('p85'=>$p85_data['nr01'], 'tax'=>0, 'pos'=>1, 'tp'=>'line', 'row'=>1,  'row0'=>1,  'col'=>$col, 'col0'=>$max_col, 'descr'=>'Γραμμή', 'p87'=>'140000000000001');


            //Αρ. Σελίδας
            $col  = ($p85_data['orient']=='P') ? 81 : 140;
            $col0 = $max_col;
            $p30  = 'return array("text"=>"Αρ. Σελίδας: ".$pdf->getPage());';
            $p86_data[] = array(
                'p85'=>$p85_data['nr01'],  
                'tax'=>30, 'pos'=>1,   'tp'=>'exp', 'p30'=>$p30,    'cond'=>'',
                'row'=>0,  'row0'=>0,  'col'=>$col, 'col0'=>$col0,  'size'=>($col0-$col),
                'descr'=>'Αρ. Σελίδας', 'p87'=>'140000000000001'
            );
            
            
            //Μεταβλητές π-αναφορας
            $row   = 2;
            $query = 'select * from q13 where p00=:q10nr01 order by p05;';
            $res   = pegasus_query($query, $values_arr);

            if(pegasus_num_rows($res)>0){
                $i = 0;
                while ($q13=pegasus_fetch_assoc($res)) {

                    //Τίτλος Μεταβλητής
                    $col  = ($p85_data['orient']=='P') ? 43 : 65;
                    $col0 = ($p85_data['orient']=='P') ? $col + 15 : $col + 20;

                    $prints_01p00 = $q13['p02'].'_p01';     $descr = $q13['p01'].' (Τίτλος Μεταβλητής el)';
                    $p30 = 'return array("text"=>$pdf->printsData->getData("'.$prints_01p00.'"), "autoSizing"=>true);';
                    $p86_data[] = array(
                        'p85'=>$p85_data['nr01'], 'tax'=>50, 'pos'=>1, 'tp'=>'exp', 'p30'=>$p30,
                        'row'=>$row, 'row0'=>0, 'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 'descr'=>$descr, 'prints_01p00'=>$prints_01p00, 'p87'=>'140000000000001'
                    );


                    //Τιμή Μεταβλητής
                    $col  = ($p85_data['orient']=='P') ? $col0 + 2 : $col0 + 5;
                    $col0 = $max_col;

                    $prints_01p00 = $q13['p02'];
                    switch (true) {
                        case (strtoupper($q13['p03'])=='N' && !empty($q13['p03_1'])):
                            $method = 'Number("'.$prints_01p00.'", '.$q13['p03_1'].')';
                            break;
    
                        case (strtoupper($q13['p03'])=='D'):
                            $method = 'Date("'.$prints_01p00.'")';
                            break;
                            
                        case (strtoupper($q13['p03'])=='L'):
                            $method = 'Logic("'.$prints_01p00.'")';
                            break;  
                        
                        default:
                            $method = 'Data("'.$prints_01p00.'")';
                            break;
                    }
                    
                    $tp   = 'exp';
                    $row0 = 0;
                    //Exp Memo
                    if($q13['p012']==1){
                        $tp   = 'exp_memo';
                        $row0 = $row + 3;    
                    }
                    $p30 = 'return array("text"=>$pdf->printsData->get'.$method.', "autoSizing"=>true);'."\n" . '/* ' . $q13['p01'] . ' */';    
                    $p86_data[] = array(
                        'p85'=>$p85_data['nr01'], 'tax'=>50, 'pos'=>1, 'tp'=>$tp, 'p30'=>$p30, 'align'=>'L', 'prints_01p00'=>$q13['p02'],
                        'row'=>$row, 'row0'=>$row0, 'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 'descr'=>$q13['p01'], 'prints_01p00'=>$prints_01p00, 'p87'=>'140000000000001'
                    );

                    $row += 1;
                    //Exp Memo
                    if($q13['p012']==1){
                        $row += 1;   
                    }
                    
                    $i++;
                }
            }
            $row = ($row>8) ? $row : 8;


            
            //Header Lines
            $p86_data[] = array('p85'=>$p85_data['nr01'], 'tax'=>999, 'pos'=>1, 'tp'=>'line', 'row'=>($row+0.5), 'row0'=>($row+0.5), 'col'=>0, 'col0'=>$max_col, 'descr'=>'Γραμμή', 'p87'=>'140000000000001');
            $p86_data[] = array('p85'=>$p85_data['nr01'], 'tax'=>999, 'pos'=>1, 'tp'=>'line', 'row'=>($row+2.5), 'row0'=>($row+2.5), 'col'=>0, 'col0'=>$max_col, 'descr'=>'Γραμμή', 'p87'=>'140000000000001');
            $p86_data[] = array('p85'=>$p85_data['nr01'], 'tax'=>999, 'pos'=>1, 'tp'=>'exp',  'row'=>($row+2.5), 'row0'=>($row+3),   'col'=>0, 'col0'=>$max_col, 'descr'=>'Κενή Γραμμή', 'p87'=>'140000000000001');
            
            
            //Πεδία/Δεδομενα π-αναφορας
            $total_fields_size = query_q12_get_fields_total_size($this->q10Nr01, false);
            $col_per_char      = 0;
            if($total_fields_size != 0){
                $col_per_char      = $max_col/$total_fields_size;
            }

            $col   = 0;
            $row  += 1;
            $query = 'select * from q12 where p00=:q10nr01 and p026=0 order by p05;';
            $res   = pegasus_query($query, $values_arr);
            while ($q12=pegasus_fetch_assoc($res)) {
                //break;

                $align = 'L';
                if(strtoupper($q12['p06'])=='N'){ $align  = 'R'; }

                $q12_size = query_q12_get_fields_size($q12, false);
                $col0     = ($col + $q12_size*$col_per_char);                
                
                //Πεδία π-αναφορας
                $prints_01p00 = $q12['p03'].'_p01';     $descr = $q12['p01']  .' (Τίτλος Πεδίου el)';
                $p30 = 'return array("text"=>peg_substr($pdf->printsData->getData("'.$prints_01p00.'"), 0, '.($col0-$col).'), "autoSizing"=>true);';
                $p86_data[] = array(
                    'p85'=>$p85_data['nr01'], 'tax'=>100, 'pos'=>1, 'tp'=>'exp', 'p30'=>$p30, 'align'=>$align,
                    'row'=>$row, 'row0'=>0, 'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 'descr'=>$descr, 'prints_01p00'=>$prints_01p00, 'p87'=>'140000000000001'
                );


                //Δεδομενα π-αναφορας
                $descr = $q12['p01'];

                switch (true) {
                    case (strtoupper($q12['p06'])=='N' && !empty($q12['p08'])):
                        $method = 'Number("'.$q12['p03'].'", '.$q12['p08'].')';
                        break;

                    case (strtoupper($q12['p06'])=='D'):
                        $method = 'Date("'.$q12['p03'].'")';
                        break;
                        
                    case (strtoupper($q12['p06'])=='L'):
                        $method = 'Logic("'.$q12['p03'].'")';
                        break;  
                    
                    default:
                        $method = 'Data("'.$q12['p03'].'")';
                        break;
                }

                if(strtoupper($q12['p06'])=='N' && $q12['p022']==1){
                    $p30  = '$value = $pdf->printsData->getBodyData("'.$q12['p03'].'");'."\n";   
                    $p30 .= '$p85_output["sum"]["'.$q12["p03"].'"]["page"]  += $value;'."\n";   
                    $p30 .= '$p85_output["sum"]["'.$q12["p03"].'"]["total"] += $value;'."\n";   
                    $p30 .= 'return peg002_format_number($value, '.$q12['p08'].');';        
                }else{
                    if(strtoupper($q12['p06'])=='C' || strtoupper($q12['p06'])=='M'){
                        $p30 = 'return array("text"=>peg_substr($pdf->printsData->getBody'.$method.', 0, '.$q12['p07'].'));';
                    }else{
                        $p30 = 'return array("text"=>$pdf->printsData->getBody'.$method.');';
                    }    
                }

                $p86_data[] = array(
                    'p85'=>$p85_data['nr01'], 'tax'=>0, 'pos'=>2, 'tp'=>'exp', 'p30'=>$p30, 'align'=>$align,
                    'row'=>0, 'row0'=>0, 'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 'descr'=>$descr, 'prints_01p00'=>$q12['p03'], 'p87'=>'140000000000002'
                );

                if(strtoupper($q12['p06'])=='N' && $q12['p022']==1){
                    //Σύνολα π-αναφορας
                    $p30  = '//$value = $sum['.$q12["p03"].']["page"];'."\n";
                    $p30 .= '$value = $sum["'.$q12["p03"].'"]["total"];'."\n";
                    $p30 .= '$p85_output["sum"]["'.$q12["p03"].'"]["page"] = 0;'."\n";   
                    $p30 .= 'return peg002_format_number($value, '.$q12['p08'].');'."\n" . '/* ' . $descr . ' (Σύνολο) */'; 

                    $p86_data[] = array(
                        'p85'=>$p85_data['nr01'], 'tax'=>100, 'pos'=>3, 'tp'=>'exp', 'p30'=>$p30, 'align'=>$align,
                        'row'=>0.5, 'row0'=>0, 'col'=>$col, 'col0'=>$col0, 'size'=>($col0-$col), 'descr'=>$descr.' (Σύνολο)', 'p87'=>'140000000000003'
                    );
                }

                $col = $col0;
            }

            //Footer Lines
            $p86_data[] = array('p85'=>$p85_data['nr01'], 'tax'=>999, 'pos'=>3, 'tp'=>'line', 'row'=>0,  'row0'=>0,  'col'=>0, 'col0'=>$max_col, 'descr'=>'Γραμμή', 'p87'=>'140000000000003');

            
            return $p86_data;
        }      

    }

    

?>