<?php
    
    function prints_after_update(){

        pegasus_mysql_use('select * from p55 where p00="prints"', $p55);


        if (file_exists('../../pegasus_cloud_app/prints_classes/prints_template_expressions.php')) {
            unlink('../../pegasus_cloud_app/prints_classes/prints_template_expressions.php');
        }

        if (file_exists('../../pegasus_cloud_app/prints02/p85_d_check_form_properties.php')) {
            unlink('../../pegasus_cloud_app/prints02/p85_d_check_form_properties.php');
        }

        if($p55['ver']=='1' && $p55['rel']<='170') { 
            //Ενημερωση εκφράσεων Φορολογικά Στοιχεία για myData
            $sql = "update p86
                    set
                    p86.descr=REPLACE(descr, 'Υπογραφή', 'Φορολογικά Στοιχεία'),
                    p86.p30=REPLACE(p30, 'Υπογραφή', 'Φορολογικά Στοιχεία')
                    where prints_01p00 like '%invoices_signature%' and p86.tp='exp_html'; ";

            pegasus_query($sql, array());
        }
        
        if($p55['ver']=='1' && $p55['rel']<='57') { 
            $arr1 = array(); $arr2 = array();
            array_push($arr1, 'classtype'); array_push($arr2, 2);
            pegasus_mysql_update('p85', $arr1, $arr2, 'p85.classtype=1 and p85.module not in ("account","sme","")');
        }


        if($p55['ver']=='1' && $p55['rel']<='53') { 
            $arr1 = array(); $arr2 = array();
            array_push($arr1, 'p300'); array_push($arr2, 1);
            pegasus_mysql_update('p85', $arr1, $arr2, '1=1');
        }


        pegasus_mysql_use("select * from cor009 where nr01=1", $cor009);
        $arr1 = array();    $arr2 = array();
        foreach ($cor009 as $key => $value) {
            if(in_array($key, array('phcolor','pfcolor','phlncolor','pflncolor')) && strtoupper($value)=='FF0000'){  
                array_push($arr1, $key);   array_push($arr2, '000000');
            }
        }
        if(count($arr1)>0){
            pegasus_mysql_update('cor009', $arr1, $arr2, 'nr01=1');  
            peg_core_cor009_update_p87();         
        }


        pegasus_mysql_use("select * from p87 where nr01='140000000000017'", $p87);
        if($p87['font_size']=='9'){
            pegasus_mysql_update('p87', array('font_size'), array('10'), 'nr01=?', 0, 1, 1, array($p87['nr01']));  
        }
        
        if($p55['ver']==1 && $p55['rel']<=112){ 
            if(function_exists('query_q10_p85_create')){
                query_q10_p85_create();
            }
        }

        prints_after_update_module_change();
    }

    function prints_after_update_module_change(){
        
        /* STARTS - Change Module Core=>Prints */
        //$debug = true;

        //Change Module Core=>Prints
        $screens_arr = array(   "p88_d","p87_d","p87_d01","p86_d102","p86_d101",
                                "p86_d100","p86_d00","p86_d01","p86_d011","p86_d02",
                                "p86_d021","p86_d","p85_d00","p85_d","_p85_upld_d"
                            );
        $in_stmt_arr = pegasus_mysql_create_in($screens_arr,'scrn');
        $values_arr  = $in_stmt_arr['sqlParams'];


        //Change Module Core=>Prints - Update System Profiles
        $query_p95p50  = "select p95p50.* from p95p50,p50 "; 
        $query_p95p50 .= "where p95p50.p50=p50.p01 and "; 
        $query_p95p50 .= "p50.p02 in (".$in_stmt_arr['sql'].") and p50.module='core' and ";
        $query_p95p50 .= "p95p50.p95>=140000000000000 ";
        $query_p95p50 .= "order by p95p50.p95,p50.p02;";

        $res_p95p50 = pegasus_query($query_p95p50, $values_arr);
        while ($p95p50=pegasus_fetch_assoc($res_p95p50)) {
            $new_module_nr01 = pegasus_mysql_module_newrec('p95p50', 'prints');            
            $p95p50_dbg[$p95p50['nr01']] = $new_module_nr01;
            if($debug==true){ continue; }

            $arr1 = array();            $arr2 = array();
            array_push($arr1, 'nr01');   array_push($arr2, $new_module_nr01);
            pegasus_mysql_update('p95p50', $arr1, $arr2, 'nr01=?', 0, 1, 1, array($p95p50['nr01']));           
        }
        
        
        //Change Module Core=>Prints - Update Users Profiles
        $query_p95p80  = "select p80_new.nr01 as new_p80, p80.view_d, p95p80.* "; 
        $query_p95p80 .= "from p95p80,p80, p80 as p80_new "; 
        $query_p95p80 .= "where p95p80.p80=p80.nr01 and ";
        $query_p95p80 .= "p80.view_d in (".$in_stmt_arr['sql'].") and p80.module='core' and ";
        $query_p95p80 .= "p80_new.module='prints' and p80.view_d=p80_new.view_d and ";
        $query_p95p80 .= "p95p80.p95<140000000000000 ";
        $query_p95p80 .= "order by p95p80.p95,p80.view_d;";

        $res_p95p80 = pegasus_query($query_p95p80, $values_arr);
        while ($p95p80=pegasus_fetch_assoc($res_p95p80)) {
            $p95p80_dbg[$p95p80['nr01']] = $p95p80['new_p80'];
            if($debug==true){ continue; }

            $arr1 = array();            $arr2 = array();
            array_push($arr1, 'p80');   array_push($arr2, $p95p80['new_p80']);
            pegasus_mysql_update('p95p80', $arr1, $arr2, 'nr01=?', 0, 1, 1, array($p95p80['nr01']));           
        } 


        $query_p95p81  = "select p81_new.nr01 as new_p81, p81._d, p95p81.* "; 
        $query_p95p81 .= "from p95p81,p81, p81 as p81_new "; 
        $query_p95p81 .= "where p95p81.p81=p81.nr01 and ";
        $query_p95p81 .= "p81._d in (".$in_stmt_arr['sql'].") and p81.module='core' and ";
        $query_p95p81 .= "p81_new.module='prints' and p81._d=p81_new._d and p81.title=p81_new.title and ";
        $query_p95p81 .= "p95p81.p95<140000000000000 ";
        $query_p95p81 .= "order by p95p81.p95,p81._d;";

        $res_p95p81 = pegasus_query($query_p95p81, $values_arr);
        while ($p95p81=pegasus_fetch_assoc($res_p95p81)) {
            $p95p81_dbg[$p95p81['nr01']] = $p95p81['new_p81'];
            if($debug==true){ continue; }

            $arr1 = array();            $arr2 = array();
            array_push($arr1, 'p81');   array_push($arr2, $p95p81['new_p81']);
            pegasus_mysql_update('p95p81', $arr1, $arr2, 'nr01=?', 0, 1, 1, array($p95p81['nr01']));           
        }



        //Change Module Core=>Prints - Delete Core Data
        //p95p81
        $query_del  = "select p95p81.* from p95p81,p81 "; 
        $query_del .= "where p95p81.p81=p81.nr01 and "; 
        $query_del .= "p81._d in (".$in_stmt_arr['sql'].") and p81.module='core' ";
        $query_del .= "order by p95p81.p95,p81._d;";

        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p95p81'][] = $toDel['nr01'];
        }


        //p95p80
        $query_del  = "select p95p80.* from p95p80,p80 "; 
        $query_del .= "where p95p80.p80=p80.nr01 and "; 
        $query_del .= "p80.view_d in (".$in_stmt_arr['sql'].") and p80.module='core' ";
        $query_del .= "order by p95p80.p95,p80.view_d;";

        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p95p80'][] = $toDel['nr01'];
        }


        //p81
        $query_del = "select * from p81 where _d in (".$in_stmt_arr['sql'].") and module='core' order by _d;";
        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p81'][] = $toDel['nr01'];
        }


        //p80
        $query_del = "select * from p80 where view_d in (".$in_stmt_arr['sql'].") and module='core' order by view_d;";
        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p80'][] = $toDel['nr01'];
        }


        //p52
        $query_del  = "select * from p52 where p02 in (".$in_stmt_arr['sql'].") and module='core' order by p02;";
        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p52'][] = $toDel['nr01'];
        }

        //p51
        $query_del  = "select * from p51 where p02 in (".$in_stmt_arr['sql'].") and module='core' order by p02;";
        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p51'][] = $toDel['nr01'];
        }

        //p50
        $query_del  = "select * from p50 where p02 in (".$in_stmt_arr['sql'].") and module='core' order by p02;";
        $res_toDel = pegasus_query($query_del, $values_arr);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p50'][] = $toDel['nr01'];
        }

        //p20
        $query_del  = "select * from p20 where p01 in ('p85','p86','p87','p88') and p03 in ('p85','p86','p87','p88') and module='core';";
        $res_toDel = pegasus_query($query_del);
        while ($toDel=pegasus_fetch_assoc($res_toDel)) {
            $toDel_dbg['p20'][] = $toDel['nr01'];
        }


        
        foreach($toDel_dbg as $table=>$nr01_arr){
            foreach($nr01_arr as $nr01){
                //echo "<pre>". $table . " // " . $nr01 . "</pre>";
                if($debug==true){ continue; }
                pegasus_mysql_delete($table, 'nr01=?', 0, array($nr01));
            }
            peg002_clean_dCache($table.'_d');
        }
        
        //echo "<pre>". print_r($toDel_dbg,1) . "</pre>";


        //Change Module Core=>Prints - Selectboxes/Comboboxes/Grids
        $query_p52  = "select p52.p02,p52.desc05,p52.module,p52.par_nm,p52.par_val "; 
        $query_p52 .= "from p52 "; 
        $query_p52 .= "join (";
        $query_p52 .= "select concat(p02, '###', desc05) as fld from p52 ";
        $query_p52 .= "where par_nm='_d' and par_val in ('_p85_upld_d','p88_d','p87_d','p87_d01','p86_d102','p86_d101','p86_d100','p86_d00','p86_d01','p86_d011','p86_d02','p86_d021','p86_d','p85_d00','p85_d') ";
        $query_p52 .= "order by module";
        $query_p52 .= ") as p52_tmp on p52_tmp.fld=concat(p52.p02, '###', p52.desc05) ";
        $query_p52 .= "where p52.par_nm in ('module') and p52.module!='prints';";
        
        $res_p52 = pegasus_query($query_p52); 

        while ($p52=pegasus_fetch_assoc($res_p52)) {
            if($debug==true){ continue; }

            if($p52['par_nm']=='module' and $p52['par_val']!='prints'){ 
                $where_p52_upd = "p52.par_nm in ('module') and p52.p02=:p02 and p52.desc05=:desc05";
                pegasus_mysql_update('p52',array('par_val'), array('prints'), 
                                    $where_p52_upd, 0, 1, 1, array("p02"=>$p52['p02'],"desc05"=>$p52['desc05'])
                                    );
                
                if(pegasus_module_exists('peg002')){
                    peg002_clean_dCache($p52['p02']);
                }
            }                       
        }

        /* ENDS - Change Module Core=>Prints */
    }

    function prints_p85_d_initialize($data, $mmnr01='', $mnr01 ='', $_d='', $container_id=''){
                
        if($_d=='p85_d'){         
            
            $new_rec = 0;
            if(empty($data['nr01'])){
                $data['nr01'] = 0;
                $new_rec      = 1;
            }
            
            if(empty($data['nr01']) and ($_REQUEST['rec_copy_nr01']>0)){
                $data['nr01'] = pegasus_mysql_newrec('p85'); 
            }

            if($new_rec==1){
                $data['classtype'] = 2; 
                $data['code']      = (empty($data['code'])) ? '$print_to_pdf_version = "function";' : $data['code'];
            }
            
            /* Δημιουργώ τα δεδομενα στους temporary πίνακες συστήματος */ 
            if(!pegasus_mysql_table_exists('peg_tmp_prints_01')){
                pegasus_change_stracture('prints_01', 'prints_01_d', 'prints', 1, 1);
            }
            pegasus_make_all_tmp_recs('p85', $data, $data['nr01'], $_REQUEST['rec_copy_nr01'], 'p85_d-'.$data['nr01']);
            
            $whereTmpTbl =  ' ##tmp_tbl##.peg_flag!=9 and ##tmp_tbl##.peg_sess_id=:sid and ##tmp_tbl##.peg_mmnr01=:mmnr01 and ##tmp_tbl##.peg_mnr01=:mnr01 ';

            $values_array = array(  "sid"     => session_id(),
                                    "mnr01"   => $data['nr01'],
                                    "mmnr01"  => "p85_d-".$data['nr01'],
                                    "p85nr01" => $data['nr01']
                                );

            //p86
            $whereTmpP86 = str_replace('##tmp_tbl##', 'peg_tmp_p86', ' peg_tmp_p86.p85=:p85nr01 and '.$whereTmpTbl);
            pegasusSetGlobalVar($container_id . '_where', array('sql'=> $whereTmpP86, 'sqlParams'=>$values_array)); 
            
            //p87 
            $whereTmpP87 = str_replace('##tmp_tbl##', 'peg_tmp_p87', ' peg_tmp_p87.p85=:p85nr01 and '.$whereTmpTbl);
            pegasusSetGlobalVar($container_id . '_p87_where', array('sql'=> $whereTmpP87, 'sqlParams'=>$values_array));

            //prints_02 
            $whereTmpPrints_02 = str_replace('##tmp_tbl##', 'peg_tmp_prints_02', ' peg_tmp_prints_02.p85=:p85nr01 and '.$whereTmpTbl);
            pegasusSetGlobalVar($container_id . '_prints_02_where', array('sql'=> $whereTmpPrints_02, 'sqlParams'=>$values_array));
        

            //Initialize Prints Data/Standard Expressions (peg_tmp_prints_01 records)
            $sql_code = eval($data['body_sql_code']);
            //if($sql_code==''){
            if($data['classtype']>1){
                $p50_module = pegasus_mysql_printfld('p50', 'module', 'p01=:p85p50', array('p85p50'=>$data['p50']));
                $prints_data_class = ucfirst($p50_module).ucfirst($data['p50']).'PrintsData';

                $prints_data_class = $data['p50_class'];
                if(empty($prints_data_class) || !class_exists($prints_data_class)){
                    $prints_data_class = 'PrintsData';
                }
                $printsData = new $prints_data_class($data['nr01'], session_id()); 
                $printsData->initializeStandardExpressions();

                $whereTmpPrints_01 = str_replace('##tmp_tbl##', 'peg_tmp_prints_01', ' '.$whereTmpTbl);
                pegasusSetGlobalVar($container_id . '_prints_01_where', array('sql'=> $whereTmpPrints_01, 'sqlParams'=>$values_array));
            }else{
                pegasusSetGlobalVar($container_id . '_prints_01_where', '1=0');    
            }
        }
        
        if(!pegasus_module_exists('dias')){
            if($data['is_std']==1){
                $readonly_flds = array('p01', 'ep01', 'classtype', 'p50', 'p50_class', 'q10');
                foreach ($readonly_flds as $fld) {
                    $data['prints_p85_d01_'.$fld.'_readonly'] = 1;
                }
            }            
        }

        $data['screen_message'] = '';
        $data['screen_message_hidden'] = 1; 

        if($data['is_std']==1 && !empty($data['module']) && !pegasus_module_exists('dias')){
            $data['screen_message'] = $_SESSION['peg_dic_prints_dis_edit_standard_forms'];
            $data['screen_message_hidden'] = 0; 
        }
        $data['screen_message'] = (!empty($data['screen_message'])) ? '<div class="alert_message">' . $data['screen_message'] . '</div>' : '';


        //Set Global p85 Data
        $tmp_width  = ($data['orient']=='P') ? $data['width']  : $data['height'];
        $tmp_height = ($data['orient']=='P') ? $data['height'] : $data['width'];
        $ratio = 0;
        if(!empty($data['cols']) && !empty($data['rows'])){
            $ratio = ($tmp_width/$data['cols'])/($tmp_height/$data['rows']);
        }
        
        $data_tmp = array();
        if($data['hpos']*$data['vpos']>1){
            $p85_cols = (($data['cols']-$data['mleft']-$data['mright'])/$data['hpos']);
            $p85_rows = (($data['rows']-$data['mtop']-$data['mbot'])/$data['vpos']);
    
            $data_tmp['cols'] = $p85_cols;
            $data_tmp['rows'] = $p85_rows;
            $data_tmp['mtop']   = 0;
            $data_tmp['mleft']  = 0;
            $data_tmp['mbot']   = 0;
            $data_tmp['mright'] = 0;
        }


        $dataGlobal = array_merge($data, $data_tmp, array('ratio'=>$ratio));
        pegasusSetGlobalVar('global_data_p85_' . $data['nr01'], $dataGlobal);

        pegasusSetGlobalVar('p85_d_rec_copy_nr01_' . $data['nr01'], $_REQUEST['rec_copy_nr01']);
        
        return $data;
    }

    function  prints_p85_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){
        
        if($checkOnlyPerm != 1){
            
            $oldNr01       = $data['nr01'];
            $rec_copy_nr01 = pegasusGetGlobalVar('p85_d_rec_copy_nr01_' . $data['nr01']);             

            $tmpSelectWhere = 'peg_flag!=9 and peg_sess_id=:sid and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 ';
            $tmpSelectWhere_values = array("sid"=>session_id(), "mnr01"=>$oldNr01, "mmnr01"=>$mmnr01, "p85nr01"=>$oldNr01);

            if($data['is_std']==1 && !empty($data['module']) && pegasus_module_exists('dias')){
                $p55Ar = null;
                pegasus_mysql_use("select * from p55 where p00=:module", $p55Ar, array('module' => $data['module']));

                if(!($p55Ar['minnr01'] <= $data['nr01'] && $p55Ar['maxnr01'] >$data['nr01'] ) ){
                    //exei kai relation me to mail02 poy den to kanw update
                    $data['nr01'] = pegasus_mysql_module_newrec('p85', $data['module']);

                    $queryP87 = " select * from peg_tmp_p87 where p85=:p85nr01 and " . $tmpSelectWhere;
                    //echo $queryP87."\n\n";
                    $queryP86 = " select * from peg_tmp_p86 where p85=:p85nr01 and " . $tmpSelectWhere;
                    //echo $queryP86 . "\n\n";
                    $queryPrints_02 = " select * from peg_tmp_prints_02 where p85=:p85nr01 and " . $tmpSelectWhere;


                    //Update P87 Nr01 (Module)
                    $resP87  = pegasus_query($queryP87, $tmpSelectWhere_values); 
                    
                    while ($p87row = pegasus_fetch_assoc($resP87)) {
                        $p87nr01 = pegasus_mysql_module_newrec('p87', $data['module']); 
                        pegasus_mysql_update(   'peg_tmp_p87', 
                                                array('nr01', 'p85', 'peg_flag'), 
                                                array($p87nr01, $data['nr01'], 1), 
                                                "p85=:p85nr01 and nr01=:p87nr01 and " . $tmpSelectWhere, 
                                                0, 1, 1, 
                                                array_merge($tmpSelectWhere_values, array("p87nr01"=>$p87row['nr01']))
                                            );
                    }
                    
                    //Update P86 Nr01 (Module)
                    $resP86  = pegasus_query($queryP86, $tmpSelectWhere_values);
                    while ($p86row = pegasus_fetch_assoc($resP86)) {
                        $p86nr01 = pegasus_mysql_module_newrec('p86', $data['module']);
                        pegasus_mysql_update(   'peg_tmp_p86', 
                                                array('nr01', 'p85', 'peg_flag'), 
                                                array($p86nr01, $data['nr01'], 1), 
                                                "p85=:p85nr01 and nr01=:p86nr01 and " . $tmpSelectWhere, 
                                                0, 1, 1, 
                                                array_merge($tmpSelectWhere_values, array("p86nr01"=>$p86row['nr01']))
                                                );
                    }   
                    
                    //Update Prints_02 Nr01 (Module)
                    $resPrints_02  = pegasus_query($queryPrints_02, $tmpSelectWhere_values);
                    while ($prints_02row = pegasus_fetch_assoc($resPrints_02)) {
                        $prints_02nr01 = pegasus_mysql_module_newrec('prints_02', $data['module']);
                        pegasus_mysql_update(   'peg_tmp_prints_02', 
                                                array('nr01', 'p85', 'peg_flag'), 
                                                array($prints_02nr01, $data['nr01'], 1), 
                                                "p85=:p85nr01 and nr01=:prints_02nr01 and " . $tmpSelectWhere, 
                                                0, 1, 1, 
                                                array_merge($tmpSelectWhere_values, array("prints_02nr01"=>$prints_02row['nr01']))
                                                );
                    }

                    $tmp_src_dir = prints_get_forms_image_fpath(0, $oldNr01);
                }
            }

             
            
            //Form Images (Prints_02)
            $dst_dir = prints_get_forms_image_fpath(0, $data['nr01']);
            if($rec_copy_nr01>0){            
                //In case of Record Copy, copy Images' Folder
                $src_dir = prints_get_forms_image_fpath(0, $rec_copy_nr01);
                if(is_dir($src_dir)){ 
                    if(!is_dir($dst_dir)){ mkdir($dst_dir, 0755, true); }    
                    peg_rcopy(rtrim($src_dir, '/'), rtrim($dst_dir, '/'));
                }
                if(is_dir($tmp_src_dir)){ 
                    peg_rcopy(rtrim($tmp_src_dir, '/'), rtrim($dst_dir, '/'));
                    pegasus_delete_directory($tmp_src_dir);
                }
            }

            //Remove Useless Form's Image Files            
            $queryPrints_02 = " select * from peg_tmp_prints_02 where p85 in (:nr01,:oldnr01) and peg_flag=9 and peg_sess_id=:sid ";
            $resPrints_02	= pegasus_query($queryPrints_02, array('nr01'=>$data['nr01'], 'oldnr01'=>$oldNr01, "sid"=>session_id()));
            //echo pegasus_replace_values_in_sql($queryPrints_02, array('nr01'=>$data['nr01'], 'oldnr01'=>$oldNr01, "sid"=>session_id()));
            while ($prints_02row=pegasus_fetch_assoc($resPrints_02)) {
                $fpath = $dst_dir.$prints_02row["p02"].".".$prints_02row["p03"]; 
                if(file_exists($fpath)){
                    unlink($fpath);
                }
            }

        }

        return array($data, $permDeny);
    }

    function prints_p85_d_ondelete($data, $permDeny, $mmnr01, $checkOnlyPerm){

        if($checkOnlyPerm==0){
            $images_dir = prints_get_forms_image_fpath(0, $data['nr01']);
            if(is_dir($images_dir)){ 
                pegasus_delete_directory($images_dir);
            } 
        }

        return $permDeny;
    }

    function prints_p85_d100_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

        $data['glb_var'] = $_REQUEST['prints_global_var'];

        $hpos_max = 16;
        $vpos_max = 16;
        $global_var_data = pegasusGetGlobalVar($data['glb_var']);

        for ($v=0; $v<$vpos_max; $v++) {
            for ($h=0; $h<$hpos_max; $h++) {     
                if($h>=$global_var_data['hpos'] || $v>=$global_var_data['vpos']){ 
                    $data['btn_pos_'.$v.'_'.$h.'_hidden'] = 1;
                    if($v>=$global_var_data['vpos']){ 
                        $data['fld_cnt_'.pegasus_leading_zeros($v, 2).'_hidden'] = 1;
                    }
                }
            }
        }
        
        return $data;
    }

    function prints_p85_d200_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

        $data['glb_var'] = $_REQUEST['prints_global_var'];
        
        return $data;
    }

    function prints_prints_02_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='p85_d'){
            if($data['nr01']>0){
                $data['fpath'] = prints_get_forms_image_fpath($data['nr01'], 0, -1, true);
            }else{
                $data['p85'] = $mmnr01_arr[1];
            }
        } 
        

        if(!(pegasus_mysql_printfld('peg_tmp_prints_02', 'nr01', 'nr01=:nr01', array('nr01'=>$data['nr01']))>0)){
            $prints_02p00_max = pegasus_mysql_printfld('peg_tmp_prints_02', 'ifnull(max(p00)+1, 0)', 'p85=:p85nr01 and peg_flag!=9 and peg_sess_id=:sid', array('p85nr01'=>$data['p85'], 'sid'=>session_id()));
            $data['p00']      = $prints_02p00_max;
        }

        $data['p02'] = "img_" . $data['p00'];

        pegasusSetGlobalVar('prints_02_d_data_' . $container_id, $data);

        $data['p85_readonly'] = 1;
        $data['p00_readonly'] = 1;
        $data['p02_readonly'] = 1;
        $data['p03_readonly'] = 1;


        $data['nr01_hidden'] = 2;
        $data['p85_hidden']  = 2;

        return $data;
    }

    function  prints_prints_02_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='p85_d'){
            if($data['p00']==''){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_prints_prints_02_empty_p00']));
            }
            if(empty($data['p02'])){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_prints_prints_02_empty_p02']));
            }
            if(empty($data['p03'])){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_prints_prints_02_empty_p03']));
            }

            if(pegasus_mysql_printfld('peg_tmp_prints_02', 'nr01', 'nr01!=:nr01 and p85=:p85 and p00=:p00 and peg_flag!=9 and peg_sess_id=:sid', array('nr01'=>$data['nr01'], 'p85'=>$data['p85'], 'p00'=>$data['p00'], 'sid'=>session_id()))>0){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_prints_prints_02_not_unique']));
            }
        }

        if($checkOnlyPerm==0){ 
        }

        return array($data, $permDeny);
    }

    function prints_prints_02_d00_before_save(){

        $prints_02_data = pegasusGetGlobalVar('prints_02_d_data_' . $_REQUEST['prnt_container_id']);

        $dir = prints_get_forms_image_fpath(0, $prints_02_data['p85']);

        $file_type = peg_getFileExt($_FILES['vph']["name"]);
        if(($file_type!='jpeg') and ($file_type!='jpg') and ($file_type!='png')){
            return array('denysave'=>1,'denymsg'=>$_SESSION['peg_dic_prints_not_valid_image_type']);
        }
                
        if(!file_exists($dir)){
            $ret = @mkdir($dir);
            if(!$ret){
                $denySave = 1 ;
                $denyMsg  = '<p style="color:red;text-align:center;font-weight:bold;">Check the folder permissions (../../images/)</p>';
                return array('denysave'=>$denySave,'denymsg'=>$denyMsg);
            }
        }

        if ($_FILES['vph']["error"]==0) {
            $file_path = $dir . $prints_02_data['p02']. "." . $file_type;
            move_uploaded_file($_FILES['vph']["tmp_name"], $file_path);
        }        
    }


    function prints_prints_02_d01_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){
        
        $fpath = '';

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='prints_02_d'){
            pegasus_mysql_use('select * from peg_tmp_prints_02 where nr01=?', $prints_02, array($mmnr01_arr[1]));
            $fpath = prints_get_forms_image_fpath($mmnr01_arr[1], 0, -1, true);
        }

        if(file_exists($fpath)){
            $data['vshph']= "<p style='text-align:center;'><img style='max-width: 300px;max-height: 300px;' src='".$fpath."?".date('His')."' /></p>";
    	}else{
    		$data['vshph'] = "<p style='text-align:center; font-weight:bold; color:red;'>".$_SESSION['peg_dic_prints_img_not_found']."</p>";
    	}
        
        return $data;
    }


    function prints_p86_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

        if($_REQUEST['action']=='draw_add'){
            
            $new_col = (isset($_REQUEST['col'])) ? $_REQUEST['col'] : null;
            $new_row = (isset($_REQUEST['row'])) ? $_REQUEST['row'] : null; 

            if($new_col!=null && $new_row!=null){
                $refresh_data = prints_draw_refresh_data($mnr01, $_REQUEST['p85_container_id']);

                $header_ends   = $refresh_data['header_rows'];
                $footer_starts = $refresh_data['header_rows'] + $refresh_data['body_height'];

                $data['col'] = floor($new_col); 
                if($new_row<$header_ends || ($refresh_data['header_elems']+$refresh_data['body_elems']+$refresh_data['footer_elems'])==0){
                    $data['row'] = floor($new_row);  
                    $data['pos'] = 1;   
                }elseif($new_row>$footer_starts){
                    $data['row'] = floor(($new_row-$footer_starts));  
                    $data['pos'] = 3;
                }else{
                    $data['pos'] = 2;
                }
                
                $data['header_ends']   = $header_ends;
                $data['footer_starts'] = $footer_starts;
            }
            
        }

        if(empty($data['p85'])){
            $data['p85'] = $mnr01;
        }

        $data['message'] = '';
        $data['message_hidden'] = 1; 
        
        $data['but01_hidden'] = 1; 
        $data['but02_hidden'] = 1;
        $data['but03_hidden'] = 1;


        $p85_body_sql_code = pegasus_mysql_printfld('p85', 'body_sql_code', 'nr01=:p85nr01', array('p85nr01'=>$data['p85']));
        $sql_code = eval($p85_body_sql_code);
        if($sql_code!=''){
            $data['message'] = $_SESSION['peg_dic_prints_dis_expressions_body_sql'];
            $data['message_hidden'] = 0; 
        }

        if(!empty($data['prints_01p00'])){
            $data['descr_readonly'] = 1;   
        }

        $data['message'] = (!empty($data['message'])) ? '<div class="alert_message">' . $data['message'] . '</div>' : '';

        return $data;
    }

    function  prints_p86_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm, $grid_editing=0){

        $mmnr01_arr = explode('-', $mmnr01);
        if($mmnr01_arr[0]=='p85_d'){
            $type = 'confirm';
            if($grid_editing==1){
                $type = 'deny';
            }
            $check_limits = prints_draw_check_limits($data['p85'], $data['nr01'], $data['pos'], $data['row'], $data['row0'], $data['col'], $data['col0']);
            
            if($check_limits['status']===false){
                array_push($permDeny, array('type' => $type, 'message' => $check_limits['message']));
            }
            
            
            $values_array = array(
                                    "mnr01"   => $data['p85'],
                                    "mmnr01"  => "p85_d-".$data['p85'],
                                    "prints_01p00" => $data['prints_01p00']
                                );
            $is_body_only = pegasus_mysql_printfld('peg_tmp_prints_01', 'p100', 'p00=:prints_01p00 and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01', $values_array);
            if($is_body_only && $data['pos']!=2){
                array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_prints_body_only_expression'] . '('.$data['descr'] . ' [ΜΚ: '.$data['nr01'].']'.')'));
            }
        }

        if($checkOnlyPerm==0){ 
        }

        return array($data, $permDeny);
    }

    function prints_p86_d_sort_by_pos($a, $b){
        if($a['pos']-$b['pos']>0){
            return true;
        }else{
            return 0;
        }
    }

    function prints_p87_d_initialize($data, $mmnr01='', $mnr01='', $_d='', $container_id=''){

        if(empty($data['p85']) && $_REQUEST['grid_element_name']=='p87_grid'){
            $data['p85'] = $mnr01;
        }

        if(!pegasus_module_exists('dias')){
            $readonly_flds = array('module');
            foreach ($readonly_flds as $fld) {
                $data[$fld.'_readonly'] = 1;
            }    
            if(empty($data['nr01'])){
                $data['module'] = 'sme';
            }    
        }

        return $data;
    }

    /**
     * 
     * @param array     $p86
     * @param array     $p85 
     * @param string    $action
     * @param array     $p86_new (New Position)
     * @return array    array || false
     */
    function prints_draw_check_rotation($p86, $p85, $action, $p86_new=array()){
        $tmp_data = array();

        if(in_array($p86['rotate'], array(90,270))){

            if($action=='refresh'){                
                $tmp_data['row']  = $p86['row'] - ($p86['col0'] - $p86['col'])*$p85['ratio'];
                $tmp_data['row0'] = $p86['row'];
                $tmp_data['col']  = $p86['col'];
                $tmp_data['col0'] = $p86['col'] + ($p86['row0'] - $p86['row'])*1/$p85['ratio']; 

            }elseif($action=='update'){
                $tmp_data['row']  = $p86_new['row0'];
                $tmp_data['row0'] = $p86_new['row0'] + ($p86['row0'] - $p86['row']);
                $tmp_data['col']  = $p86_new['col'];
                $tmp_data['col0'] = $p86_new['col'] + ($p86['col0'] - $p86['col']);
            }

            return $tmp_data;
		}

        return false;
    }

    function prints_draw_check_limits($p85_nr01, $p86_nr01, $pos, $new_row, $new_row0, $new_col, $new_col0, $offset=false, $action=''){
        $response = array('status' => true, 'message' => '');
        
        $p85_arr = pegasusGetGlobalVar('global_data_p85_' . $p85_nr01);

        if(in_array($p85_arr['classtype'], array(0,1))){
            return $response;
        }

        //p86 Data
        $where = ' peg_flag!=9 and peg_sess_id=:sid and peg_mmnr01=:mmnr01 and peg_mnr01=:mnr01 and peg_tmp_p86.p85=:mnr01 ';
        $values_array = array("sid"=>session_id(), "mnr01"=>$p85_nr01, "mmnr01"=>"p85_d-".$p85_nr01); 

        $query_p86_tmp  = "select * from peg_tmp_p86 ";
        $query_p86_tmp .= "where " . $where . " ";    
        $query_p86_tmp .= "order by ";
        $query_p86_tmp .= "peg_tmp_p86.pos, peg_tmp_p86.tax desc, peg_tmp_p86.row, peg_tmp_p86.col desc;";
        
        $response['query'] = pegasus_replace_values_in_sql($query_p86_tmp, $values_array);

        $res = pegasus_query($query_p86_tmp, $values_array);
        $p86_arr = pegasus_fetchall($res);
        
        foreach ($p86_arr as $p86_tmp){  
            $p86_nr01_arr[] = $p86_tmp['nr01'];
        }
        
        //Push New P86 Record
        if(array_search($p86_nr01, $p86_nr01_arr)===false){
            $p86_pos = array('1'=>array(), '2'=>array(), '3'=>array());
            foreach ($p86_arr as $p86){
                $p86_pos[$p86['pos']][] = $p86;
            }
            $p86_pos[$pos][] = array('nr01'=>$p86_nr01,'row'=>$new_row,'row0'=>$new_row0,'pos'=>$pos);
            $p86_arr = array_merge($p86_pos['1'], $p86_pos['2'], $p86_pos['3']);            
        }


        //Check Rotation
        foreach ($p86_arr as $row){                  
            if($row['nr01']==$p86_nr01){
                $p86_new  = array('row'=>$new_row,'row0'=>$new_row0,'col'=>$new_col,'col0'=>$new_col0,'pos'=>$pos);
                $tmp_data = prints_draw_check_rotation($row, $p85_arr, $action, $p86_new);
                if($tmp_data!==false){
                    foreach($tmp_data as $key=>$value){
                        ${"new_".$key} = $value;
                    }
                }
                break;
            }
        }
        
        
        //Check Element
        if($new_row<0 || $new_row>$p85_arr['rows']-$p85_arr['mtop']-$p85_arr['mbot']){
            $response['status']  = false;
            $response['message'] = "[Μ.Κ.:" . $p86_nr01 . "] - " . $_SESSION['peg_dic_prints_element_exceeds_row_margins'];
            return $response;

        }elseif(($new_row>$p85_arr['rows'] || $new_row0>$p85_arr['rows']) && $p85_arr['rolling_paper']!=1){
            $response['status']  = false;
            $response['message'] = "[Μ.Κ.:" . $p86_nr01 . "] - " . $_SESSION['peg_dic_prints_element_exceeds_rows'];
            return $response;
        }

        if($new_col<0 || $new_col>$p85_arr['cols']-$p85_arr['mleft']-$p85_arr['mright']){
            $response['status']  = false;
            $response['message'] = "[Μ.Κ.:" . $p86_nr01 . "] - " . $_SESSION['peg_dic_prints_element_exceeds_col_margins'];
            return $response;

        }elseif($new_col>$p85_arr['cols'] || $new_col0>$p85_arr['cols']){
            $response['status']  = false;
            $response['message'] = "[Μ.Κ.:" . $p86_nr01 . "] - " . $_SESSION['peg_dic_prints_element_exceeds_cols'];
            return $response;
        }


        //Check Total Page
        $header_rows = 0;
        $footer_rows = 0;
        $p86_recs    = count($p86_arr);
        foreach ($p86_arr as $i=>$row){  
            
            $independent_element = true;
            if($row['tp']!='image' && !($row['tp']=='line' && $row['col0']==$row['col'])){
                $independent_element = false;
            }
            
            //Current Element
            if($row['nr01']==$p86_nr01){
                $offset_height = 0;
                if($offset===true){
                    if($row['pos']==2){
                        $offset_height = $header_rows;
                    }elseif($row['pos']==3){
                        $offset_height = $header_rows + $p85_arr['body_height'];
                    }
                }

                if($row['row0']>$row['row']){
                    $row['row0'] = $new_row0 - $offset_height;
                }elseif($row['tp']=='exp'){
                    $row['row0'] = 0;
                }
                $row['row'] = $new_row - $offset_height;
                

                $response['data']['p86'][$row['nr01']]['row']  = $row['row'];
                $response['data']['p86'][$row['nr01']]['row0'] = $row['row0'];
                $response['data']['p86'][$row['nr01']]['col']  = $new_col;
                $response['data']['p86'][$row['nr01']]['col0'] = $new_col0;
            }

            $height = $row['row0'] - $row['row'];
            if($height<0 || ($height==0 && $row['tp']!='line')){ $height = 1; }
            $height_tmp = $row['row'] + $height;


            if($row['pos']==1){
                if($header_rows<$height_tmp && $independent_element===false){
                    $header_rows = $height_tmp; 
                }
            }

            if($row['pos']==3){
                if($footer_rows<$height_tmp && $independent_element===false){
                    $footer_rows = $height_tmp; 
                }
            }


            //Element Exceeds Body
            if($row['pos']==2 && $p85_arr['headfootonce']!=1 && ($row['row']>$p85_arr['body_height'] || $row['row0']>$p85_arr['body_height'])){
                $response['status']  = false;
                $response['message'] = $_SESSION['peg_dic_prints_element_exceeds_body'];
                break;
            }

            //Total Rows Exceeds Page
            $total_active_rows = $header_rows + $footer_rows + $p85_arr['body_height'] + $p85_arr['mtop'] + $p85_arr['mbot'];
            if($total_active_rows>$p85_arr['rows'] && $p85_arr['headfootonce']!=1 && $p85_arr['rolling_paper']!=1){
                $message = $_SESSION['peg_dic_prints_page_exceeds_rows'];
                $message = str_replace("##activeRowsRatio##", $total_active_rows . "/" .$p85_arr['rows'], $_SESSION['peg_dic_prints_page_exceeds_rows']);
                
                //Find Οverflow Elements
                for ($j=$i+1; $j<$p86_recs; $j++) { 
                    $οverflow_row = $p86_arr[$j]['row'];
                    if($p86_arr[$j]['pos']==2){
                        $οverflow_row += $header_rows;
                    }elseif($p86_arr[$j]['pos']==3){
                        $οverflow_row += $header_rows + $p85_arr['body_height'];
                    }
                    if($οverflow_row>$p85_arr['rows'] && $p86_arr[$j]['tp']!='image' && !($p86_arr[$j]['tp']=='line')){
                        $message .= "</br>Μ.Κ.: " . $p86_arr[$j]['nr01'] . " - " . $p86_arr[$j]['descr'];
                    }
                }
                
                $response['status']  = false;
                $response['message'] = $message;
                break;
            }            
        }
        
        return $response;
    }

    /**
     * Refreshes Form Generation Data
     * @param int    $p85_nr01
     * @param string $p85_container_id
     * @return array $ret_array 
     * Returns 
     * Number of Elements According to Position (Head, Body, Footer)
     * Header/Body/Footer Rows
     * Elements Data According to Type (images, lines, boxes, elements)
     */
    function prints_draw_refresh_data($p85_nr01, $p85_container_id){

		$ret_array = array();

        //Get Form Data from GlobalVar (peg_temp_p85)
		$p85_arr = pegasusGetGlobalVar('global_data_p85_' . $p85_nr01);
		$actual_rows = $p85_arr['rows'] - $p85_arr['mtop']  - $p85_arr['mbot'];
		$actual_cols = $p85_arr['cols'] - $p85_arr['mleft'] - $p85_arr['mright']; 


		//Get Form Elements from GlobalVar (peg_temp_p86)
		$where_stm = pegasusGetGlobalVar($p85_container_id . '_where');
		$query_p86_tmp  = "select * from peg_tmp_p86 ";
		$query_p86_tmp .= "where " . $where_stm['sql'] . " ";    
		$query_p86_tmp .= "order by ";
		$query_p86_tmp .= "peg_tmp_p86.pos, peg_tmp_p86.tax desc, peg_tmp_p86.row, peg_tmp_p86.col desc;";
		
	
		$header_elems = 0;
		$body_elems   = 0;
		$footer_elems = 0;
		$header_rows  = 0;
		$footer_rows  = 0;
	
		$elements = array();
		$boxes 	  = array();
		$lines    = array();
		$images   = array();
        
        $res = pegasus_query($query_p86_tmp, $where_stm['sqlParams']);
		while($row=pegasus_fetch_assoc($res)){
	
			$independent_element = true;
			if($row['tp']!='image' && !($row['tp']=='line' && $row['col0']==$row['col'])){
				$independent_element = false;
			}
	
			if(empty($row['descr'])){
				$row['descr'] = $_SESSION['peg_dic_prints_tp_' . $row['tp']] . ' - ' . $row['nr01'];
			}
	
			$tmp_data = prints_draw_check_rotation($row, $p85_arr, 'refresh');
			if($tmp_data!==false){
				foreach($tmp_data as $key=>$value){
					$row[$key] = $value;
				}
			}
	
			//Element Size
			$height = $row['row0'] - $row['row'];
			if($height<0 || ($height==0 && $row['tp']!='line')){ $height = 1; }
			$row['height'] = $height;
	
			$width = $row['size'];
			if($width<=0){
				$width = $row['col0'] - $row['col'];
				if($width<=0){
					$width = $actual_cols - $row['col'];
				}
			}
			$row['width']  = $width;		
	
			
			$height_tmp = $row['row'] + $height;
			if($row['pos']==1){
				$header_elems++;
				if($header_rows<$height_tmp && $independent_element===false){
					$header_rows = $height_tmp; 
				}
			}

			if($row['pos']==2){
				$body_elems++;
			}
	
			if($row['pos']==3){
				$footer_elems++;
				if($footer_rows<$height_tmp && $independent_element===false){
					$footer_rows = $height_tmp; 
				}
			}
	
			if($row['pos']==2){
				$row['row']  += $header_rows;
				$row['row0'] += $header_rows;
			}elseif($row['pos']==3){
				$row['row']  += $header_rows + $p85_arr['body_height'];
				$row['row0'] += $header_rows + $p85_arr['body_height'];
			}
			
			
	
			if($row['tp']=='image'){
                $element_ratio_data = prints_element_aspect_ratio($row['nr01'], true, 1);
                $row['descr']      .= " [".peg002_format_number(abs($element_ratio_data['ratio']), 2).":1]";
                
				$images[] = $row;
			}elseif($row['tp']=='line'){
				$lines[] = $row;
			}elseif($row['tp']=='box'){
				$boxes[] = $row;
			}else{
				$elements[] = $row;
			}
		}
		
		
		$ret_array['body_height']  = $p85_arr['body_height']; 

		$ret_array['header_elems'] = $header_elems; 
		$ret_array['body_elems']   = $header_elems; 
		$ret_array['footer_elems'] = $footer_elems;
		$ret_array['header_rows']  = $header_rows;   
		$ret_array['footer_rows']  = $footer_rows; 
		
		$ret_array['images']   = $images;
		$ret_array['lines']    = $lines;
		$ret_array['boxes']    = $boxes;
		$ret_array['elements'] = $elements;

		return $ret_array;
	}

    function prints_tcpdf_clean_html($html){	
        //Τα tags που επιτρέπονται στην TCPDF
        $tcpdf_allowed_tags = "<a><b><blockquote><br><dd><del><div><dl><dt><em><font><h1><h2><h3><h4><h5><h6><hr><i><img><li><ol><p><pre><small><span><strong><sub><sup><table><tcpdf><td><th><thead><tr><tt><u><ul>";
        $html = strip_tags($html, $tcpdf_allowed_tags);

        //Αντικαθιστώ τις αλλαγες γραμμών κοκ που μπορεί να έχουν προκύψει από το τοπικό
        $html = str_replace(array("\r\n", "\r", "\n"), "", $html);
        $html = str_replace("\t", '', $html);
        $html = str_replace("&nbsp;", '', $html);

        //freesans η γραμματοσειρά που υπάρχει στην TCPDF για τα ελληνικά
        $html = str_replace('font-family:', 'font-family:\'freesans\',', $html);
        // $html = str_replace('<br>', '', $html);

        $doc = new DOMDocument();
        $p30_tmp = mb_convert_encoding($html, 'HTML-ENTITIES', "UTF-8");
        if(!empty($p30_tmp)){
            $doc->loadHTML($p30_tmp, LIBXML_HTML_NODEFDTD);
        } 
        

        /*
        $p30_tmp = $doc->saveHTML($doc->getElementsByTagName('body')[0]->nodeValue);
        $result = '';
        $i = 0;
        foreach ($doc->getElementsByTagName('body')['0']->childNodes as $node) {
            $i++;
            $result .= $doc->saveHtml($node);
            Για debug -- βρες το i με το πρόβλημα και κάνε echo
            if ($i == 11) {
                //DOMElement
                var_dump(utf8_encode($doc->saveHtml($node)));
                break;
            }
        }*/

        $result = $doc->saveHtml();
        return $result;
    }


?>