<?php

    //New Version TCPDF
    function prints_print_form_to_tcpdf(&$pdf, $p85_input, $form_to_print_flag=false, &$custom_addPageConfition_cnt = 0){
        
        if(empty($p85_input['p85_nr01'])){
            die("empty p85_nr01");
        }
        //Recursive Case      
        $custom_addPageConfition = $p85_input['custom_addPageConfition'];
        $classType               = $p85_input['classType'];
        
        /**
         * Variables from Κώδικας πρίν την εκτέλεση της εκτύπωσης
         * 
         * -- $printColRows = true; Ean tha ektypwsei grammes kai stiles
         * -- $backgroundImageFile The background image @example ../../images/webappForm/bgimg.png
         * -- $custom_addPageConfition = array(
         *      mod => //Ean aritmo pou tha kanei mode ton aritmo tis epanalipsis gia na dijei se mia thesi ston pinaka action
         *      cnt => counter start from 0 
         *      action => array(
         *         array(
         *                  custom_offset_y => To offset se grammer (int)
         *                  custom_offset_x => To offset se stiles (int)
         *                  addpage => an tha kanei addpage (boolean)
         *         )
         *      )
         *  )
         */
        
                
        $vdisft             = false;
        $printColRows       = false;    // Den ektipwnei  dedomena h forma otan einai true mono row kai col
        $printHeaderOnce    = false;    // Energopoiome to header kai to footer na ektipononte mia fora
        $body_sql_code      = '';       // O sql kodikas ektelesis tou body
        $body_rows          = 0;        // O sinolikos aritmos grammvn tou body
        
        $body_offset_i      = 0;        // Διόρθωση body γραμμης (TCPDF)        
        $custom_offset_y    = 0;
        $custom_offset_x    = 0;

        $custom_addPage     = false;   //Ean einai true h kentiki klasi prepei na orizei ta condithion se mia metavliti
        
        if(isset($custom_addPageConfition) && is_array($custom_addPageConfition)){
            $custom_addPage = true;
    
            if(empty($custom_addPageConfition_cnt)){ 
                $custom_addPageConfition_cnt = 0; 
            }
            if(empty($custom_addPageConfition['mod'])){
                $custom_addPageConfition['mod'] = 1;
            }
            if(empty($custom_addPageConfition['position'])){
                $custom_addPageConfition['position'] = 1;
            }
            
            if($custom_addPageConfition['mod']!=sizeof($custom_addPageConfition['action'])){
                die("Mode wrong value");
            }
        }
                 
        
        $p85_output = array();    //Data που προκύπτουν από τον "Κώδικας πρίν την εκτέλεση της εκτύπωσης"
         
        //Select Forma
        pegasus_mysql_use("select * from p85 where nr01= :p85_nr01 " , $p85, array('p85_nr01' => $p85_input['p85_nr01']));
        //Select Main Form
        pegasus_mysql_use("select * from p87 where nr01= :p85_main_style " , $p87, array('p85_main_style' => $p85['main_style']));
               

        if(!empty($p85['code'])){
            try {
                eval($p85['code']);
            } catch (\Throwable $th) {
                die($th->getMessage());
            }            
        }

        if($p85['rolling_paper']==1){
            $tmp_g_height  =  ($p85['height']/$p85['rows']); 
            $p85['height'] = 10000;
            $p85['rows']   = round($p85['height']/$tmp_g_height);

            if(isset($p85_input['p85_height']) && !empty($p85_input['p85_height'])){
                $p85['height'] = $p85_input['p85_height'];
            }
            if(isset($p85_input['p85_rows']) && !empty($p85_input['p85_rows'])){
                $p85['rows'] = $p85_input['p85_rows'];
            }
        }
       
        
        if(strtolower($print_to_pdf_version)!='function'){
            return false;
        }
        
        if(1==1 || !isset($form_to_print_flag) || $form_to_print_flag == false){
            $classType  = $p85['classtype'];            
            $p85_orient = $p85['orient'];

            if(empty($p85['pagesize']) and $p85['width']>0 and $p85['height']>0){
                $p85['pagesize'] = array($p85['width'], $p85['height']);
            }
            if($p85['rotate']!=0){
                $p85['pagesize']['Rotate'] = $p85['rotate'];
            }
            
            
            //In case we have Multiple Forms Printing
            if($form_to_print_flag==true){
                //In case we have Label Printing (Multiple Position Layout)
                if(($p85['hpos']*$p85['vpos']>1)){
                    $p85_cols   = ($p85['cols']-$p85['mleft']-$p85['mright'])/$p85['hpos'];
                    $p85_rows   = ($p85['rows']-$p85['mtop']-$p85['mbot'])/$p85['vpos'];
    
                    $p85_width  = ($p85_orient=='P') ? $p85['width'] : $p85['height'];
                    $p85_width  = $p85_cols*($p85_width/$p85['cols']);
    
                    $p85_height = ($p85_orient=='P') ? $p85['height'] : $p85['width'];
                    $p85_height = $p85_rows*($p85_height/$p85['rows']);
                    
                    $p85['width']  = $p85_width;
                    $p85['height'] = $p85_height;
                    $p85['cols']   = $p85_cols;
                    $p85['rows']   = $p85_rows;
                    $p85['mtop']   = 0;
                    $p85['mleft']  = 0;
                    $p85['mbot']   = 0;
                    $p85['mright'] = 0;
    
                    $p85['orient'] = ($p85['width']<=$p85['height']) ? 'P' : 'L';
                    $p85_orient = $p85['orient']; 
                    
                    $p85['pagesize'] = array($p85['width'], $p85['height']);
                }
                
                if($p85['rotate']!=0){
                    $p85['pagesize']['Rotate'] = 0;
                }
            }
            //echo "<pre>". print_r($p85,1) . "</pre>";


            $pdf = new pegTCPDF($p85['rows'], $p85['cols'], $p85['width'], $p85['height'], $p85_orient, 'mm', $p85['pagesize'], $p85['mtop'],  $p85['mleft'], $p85['mbot'], $p85['mright'], $p85['headfootonce'], $p85['classtype']);
            

            $pdf->setDataDource($p85['p50'], $p85['q10']);
            //TODO RemUser
            $pdf->SetAuthor('PegasusWebApplication');
            //TODO Anafora
            //$pdf->SetTitle('PegasusWebApp');
            $pdf->SetTitle(prints_generate_pdf_filename($p85_input));
            //TODO DESC
            $pdf->SetSubject($p85['p30'] );
            $pdf->SetKeywords($p85['p30']); //MAKE THE
            $pdf->set_vdisft($vdisft);
            //XXX add parameter
            //$pdf->SetAutoPageBreak(false);

            $pdf->p85_callMethod = 'function';
        }
        
                
        //Initialize Prints Data 
        $prints_data_class = $p85['p50_class'];
        if(empty($prints_data_class) || !class_exists($prints_data_class)){
            $prints_data_class = 'PrintsData';
        }
        $pdf->printsData = new $prints_data_class($p85['nr01'], 0, $p85_input); 

        $time_0 = microtime(true);
        if(!(is_array($p85_input['dias_main_nr01']) && $pdf->printsData->getMultipleInputMode()==1)){
            $pdf->printsData->makeExpressionsData();
        }
        //echo get_class($pdf->printsData);
        $time_1 = microtime(true);

        if(is_array($p85_input['dias_main_nr01']) && !isset($form_to_print)){
            //In case of Multiple Nr01s are in separate Multiple Forms (Multiple Position Layout)
            if($pdf->printsData->getMultipleInputMode()==1){

                foreach ($p85_input['dias_main_nr01'] as $ii => $main_nr01){
                    $form_to_print[] = $p85['nr01'];	
                    $form_to_print_main_nr01[] = $main_nr01;
                    if(isset($p85_input['form_to_print_p85_input']) && is_array($p85_input['form_to_print_p85_input'])){
                       $form_to_print_p85_input[] = $p85_input['form_to_print_p85_input'][$ii];
                    }
                }

                if(!is_array($custom_addPageConfition)){  
                    $custom_addPageConfition = array('ignore_borders'=>true);
                    //$custom_addPageConfition = array();
                    if($p85_input['position']>1){
                        $custom_addPageConfition['position'] = $p85_input['position'];
                    }
                }
            }
        } 

        
        //Multiple Forms
        if(isset($form_to_print) and is_array($form_to_print) and (!isset($form_to_print_flag) || $form_to_print_flag==false)){
              
            //Auto Multiple Layout Initialization according to Form Properties    
            if(is_array($custom_addPageConfition)){            
                $p85_hpos = ($p85['hpos']>1) ? $p85['hpos'] : 1;
                $p85_vpos = ($p85['vpos']>1) ? $p85['vpos'] : 1;
                //Support Older Versions
                $p85_hpos = (isset($custom_addPageConfition['fpc'])) ? $custom_addPageConfition['fpc'] : $p85_hpos;
                $p85_vpos = (isset($custom_addPageConfition['fpr'])) ? $custom_addPageConfition['fpr'] : $p85_vpos;
                
                if(!isset($custom_addPageConfition['mod'])){ 
                    $custom_addPageConfition['mod'] = $p85_hpos*$p85_vpos; 
                }
                
                $pos_tmp = 0;
                for ($v=0; $v<$p85_vpos; $v++) {
                    for ($h=0; $h<$p85_hpos; $h++) {  
                        $pos_tmp++;
                        $index_tmp = ($pos_tmp) % ($p85_hpos*$p85_vpos);
                        if(isset($custom_addPageConfition['action'][$index_tmp]['custom_offset_x']) && isset($custom_addPageConfition['action'][($pos_tmp) % ($p85_hpos*$p85_vpos)]['custom_offset_y'])){
                            continue;
                        }
                        $sample_rows = ($custom_addPageConfition['ignore_borders']===true) ? $p85['rows'] : ($p85['rows']-$p85['mtop']-$p85['mbot']);
                        $sample_cols = ($custom_addPageConfition['ignore_borders']===true) ? $p85['cols'] : ($p85['cols']-$p85['mleft']-$p85['mright']);
                        
                        $custom_addPageConfition['action'][$index_tmp]['custom_offset_x'] = ($sample_cols/$p85_hpos)*$h;
                        $custom_addPageConfition['action'][$index_tmp]['custom_offset_y'] = ($sample_rows/$p85_vpos)*$v;
                        

                        if(!isset($custom_addPageConfition['action'][$index_tmp]['addpage'])){
                            if($custom_addPageConfition['mod']>1){
                                $custom_addPageConfition['action'][$index_tmp]['addpage'] = false; 
                                if($index_tmp==1){
                                    $custom_addPageConfition['action'][$index_tmp]['addpage'] = true;
                                }
                            }else{
                                $custom_addPageConfition['action'][$index_tmp]['addpage'] = true;    
                            }
                        }
                    }
                }

                //$custom_addPageConfition['ignore_borders'] = true;
            }           
        
                
            //echo "<pre>". print_r($custom_addPageConfition,1) . "</pre>";   
            
            $form_to_print_flag = true;
            
            $uid = uniqid('p85_'.$p85['nr01'].'_');
            $dir  = '../../tmp/prints/_tempStore/' . $uid;
            if(!is_dir($dir) && $p85_input['ajax']!=true){ mkdir($dir, 0777, true); }

            $index = 1;
            foreach ($form_to_print as $key=>$tmp_form_to_print_value){

                //echo $key;
                if($tmp_form_to_print_value>0 ){
                    $p85_input['p85_nr01']                = $tmp_form_to_print_value;
                    $p85_input['classType']               = $classType;
                    $p85_input['main_p85_nr01']           = $p85['nr01'];
                    $p85_input['custom_addPageConfition'] = $custom_addPageConfition;
                    $p85_input['form_to_print_index']     = $index;

                    if(isset($form_to_print_main_nr01[$key])){
                        //Different "dias_main_nr01" for each extra form_to_print
                        $p85_input['dias_main_nr01'] = $form_to_print_main_nr01[$key];
                    }
                    if(isset($form_to_print_p85_input[$key]) && is_array($form_to_print_p85_input[$key])){
                        //Different "p85_input" for each extra form_to_print
                        $p85_input = array_merge($p85_input, $form_to_print_p85_input[$key]);
                        if(isset($p85_input['form_to_print_p85_input'][$key]) && is_array($p85_input['form_to_print_p85_input'][$key])){
                            //Αν προερχομαι απο εκτυπωση έχει ήδη ορισμενο 'form_to_print_p85_input'
                            $p85_input = array_merge($p85_input, $p85_input['form_to_print_p85_input'][$key]);
                        }
                    }
                    
                    if($p85_input['ajax']!=true){
                        prints_print_form_to_tcpdf($pdf, $p85_input, $form_to_print_flag, $custom_addPageConfition_cnt);
                    
                        //echo "<pre>". $custom_addPageConfition_cnt . "</pre>";
                        //echo "<pre>". print_r($pdf,1) . "</pre>";

                        //θεωρώ ότι μία φόρμα ascii δεν μπορεί να έχει εκτύπωση πολλαπλών φορμών
                        if($p85_input['ascii_mode']){
                            $ascii_textElementsArray = $pdf->textElementsArray;
                        }

                        $filename = $dir . '/p85_'.$p85['nr01'].'_'.$custom_addPageConfition_cnt.'.pdf';
                        $pdf_string = $pdf->Output('tmp_p85_'.$p85_input['p85_nr01'].'.pdf', 'S');
                        file_put_contents($filename, $pdf_string);
                        if($pdf instanceof pegTCPDF){
                            $pdf->resetForm();
                        }
                    }

                    $p85_input_data[] = $p85_input;

                    $index++;                    
                }
            }


            $form_to_print_flag = false;

            if($p85_input['ajax']==true && count($p85_input_data)>0){
                return array(
                    'p85_input_data'          => $p85_input_data,
                    'custom_addPageConfition' => $custom_addPageConfition,
                    'p85'                     => $p85,  
                    'time_10'=>($time_1 - $time_0)*1000,                 
                );
            }

            $pdf_FPDI   = prints_merge_multiple_forms_to_pdf($p85, $custom_addPageConfition, $custom_addPageConfition_cnt, $dir);
            $pdf        = $pdf_FPDI;
            
            //θεωρώ ότι μία φόρμα ascii δεν μπορεί να έχει εκτύπωση πολλαπλών φορμών
            if($p85_input['ascii_mode'] && $index<=2){
                if(count($ascii_textElementsArray)>0){
                    $pdf->set_textElementsArray($ascii_textElementsArray);
                }
            }

            if(is_dir($dir)){
                $dir_handle = opendir($dir);
                while($file = readdir($dir_handle)) {
                    if ($file!="." && $file!="..") {
                        if (!is_dir($dir."/".$file)){
                            unlink($dir."/".$file);
                        }
                    }
                }
                closedir($dir_handle);
                rmdir($dir);
            }

            return true;
        }


        
           

        //New TCPDF Version
        if($pdf instanceof pegTCPDF){  
            $pdf->p85_nr01  = $p85_input['p85_nr01'];
            $pdf->p87       = $p87;
            $pdf->setP85_output($p85_output);

            $query_p86 = "select * from p86 where p85=:p85_nr01 and pos!=2 order by p86.pos, p86.tax, p86.row, p86.col";                  
            $res = pegasus_query($query_p86, array('p85_nr01' => $p85_input['p85_nr01']));

            $header_elem_height_per_row = array();
            $footer_elem_height_per_row = array();
    
            //Calculate Header/Footer Max Rows
            while($elem=pegasus_fetch_assoc($res)){

                if(prints_check_elem_condition($elem['cond'], $p85_output, $pdf)==false){
                    continue;
                }

                $independent_element = true;
                if($elem['tp']!='image' && !($elem['tp']=='line' && $elem['col0']==$elem['col'])){
                    $independent_element = false;
                }                

                $tmp_data = prints_check_elem_rotation($elem, $p85);
                if($tmp_data!==false){
                    foreach($tmp_data as $key=>$value){
                        $elem[$key] = $value;
                    }
                }

                //Element Size
                $height = $elem['row0'] - $elem['row'];                    
                if($elem['row0']==0 && ($elem['tp']=='exp_memo' || $elem['tp']=='exp_html')){
                    $heightTmp = $pdf->p86_data_to_pdf($elem, true);
                    
                    if($heightTmp['height']>=0){
                        $height = $heightTmp['row0'] - $heightTmp['row'];
                    }
                }elseif($height<0 || ($height==0 && $elem['tp']!='line')){ 
                    $height = 1; 
                }

                
                if($elem['pos']==1 && $independent_element===false){
                    //strval: Change Number to string
                    $header_elem_height_per_row[strval($elem['row'])][$elem['nr01']] = $height;  
                    $header_elem_per_row[strval($elem['row'])][$elem['nr01']] = $elem;
                }

                if($elem['pos']==3 && $independent_element===false){
                    //strval: Change Number to string
                    $footer_elem_height_per_row[strval($elem['row'])][$elem['nr01']] = $height;  
                    $footer_elem_per_row[strval($elem['row'])][$elem['nr01']] = $elem;
                }
            }
            
            //Calculate Elements Max Rows Height Separately
            $last_row0   = 0;
            $header_rows = 0;
            if(is_array($header_elem_height_per_row)){
                ksort($header_elem_height_per_row);
            }
            foreach ($header_elem_height_per_row as $row => $elem_height_arr) {
                $max_row_height = max($elem_height_arr);
                $header_rows += $max_row_height;
            }

            //Calculate (for 2nd time) Elements Max Rows Height According to their relative Position
            foreach ($header_elem_height_per_row as $row => $elem_height_arr) {
                $max_row_height = max($elem_height_arr);
                $max_row_height_keys = array_keys($elem_height_arr, $max_row_height);
                $elem = $header_elem_per_row[$row][$max_row_height_keys[0]];
                
                $header_rows += ($row - $last_row0);

                if($elem['row0']==0){
                    if($elem['tp']=='exp'){
                        $last_row0 = $elem['row'] + 1;
                    }elseif($elem['tp']=='exp_memo' || $elem['tp']=='exp_html'){
                        $last_row0 = $elem['row'];
                    }
                }elseif(($elem['row']==$elem['row0'] && $elem['tp']!='line')){
                    $last_row0 = $elem['row0'] + 1;                    
                }else{
                    $last_row0 = $elem['row0'];
                }

            }

            $last_row0   = 0;
            $footer_rows = 0;
            if(is_array($footer_elem_height_per_row)){
                ksort($footer_elem_height_per_row);
            }
            foreach ($footer_elem_height_per_row as $row => $elem_height_arr) {
                $max_row_height = max($elem_height_arr);
                $footer_rows += $max_row_height;
            }
            foreach ($footer_elem_height_per_row as $row => $elem_height_arr) {
                $max_row_height = max($elem_height_arr);
                $max_row_height_keys = array_keys($elem_height_arr, $max_row_height);
                $elem = $footer_elem_per_row[$row][$max_row_height_keys[0]];
                
                $footer_rows += ($row - $last_row0);

                if($elem['row0']==0){
                    if($elem['tp']=='exp'){
                        $last_row0 = $elem['row'] + 1;
                    }elseif($elem['tp']=='exp_memo' || $elem['tp']=='exp_html'){
                        $last_row0 = $elem['row'];
                    }
                }elseif(($elem['row']==$elem['row0'] && $elem['tp']!='line')){
                    $last_row0 = $elem['row0'] + 1;
                }else{
                    $last_row0 = $elem['row0'];
                }
            }

            $footer_rows_avail = $p85['rows']-$p85['mtop']-$p85['mbot'] - $header_rows - $p85['body_height'];
            if($footer_rows<$footer_rows_avail){
                $footer_rows = $footer_rows_avail;
            }

            $pdf->max_head_row   = $header_rows;
            $pdf->max_footer_row = $footer_rows;
            

            // echo "<pre>". $header_rows . "</pre>";   
            // echo "<pre>". print_r($header_elem_height_per_row,1) . "</pre>";
            // echo "<pre>". $footer_rows . "</pre>";
            // echo "<pre>". print_r($footer_elem_height_per_row,1) . "</pre>"; 
        }
        
        if($pdf instanceof pegTCPDF){ 
            $pdf->setPrintHeader(true);
            if(file_exists($backgroundImageFile)){
                $pdf->setBackgroundImage($backgroundImageFile);
            }else{
                //Κάνω unset στην περίπτωση που εκτυπώνω πολλές φόρμες  
                //και π.χ. η πρώτη έχει background αλλά η δεύτερη όχι
                $pdf->unSetBackgroundImage();
            }
        }
        
        
        //Ean h forma tha ektiponei mia fora to header kai mia fora to Footer
        if($p85['headfootonce']){
            $printHeaderOnce = true;
        }else{
            $pdf->bodyheight = $p85['body_height'];
        }
        
        //Start main style 
        //H set font kalei thn add font 
        $pdf->AddFontFamily($p87['font'], '', $p87['font'] . '.php', '', $p87['nr01']);         
        $pdf->SetFont($p87['font'], '', $p87['font_size']);         
        $pdf->setHeaderFont(array($p87['font'], '', $p87['font_size']));
        $pdf->setFooterFont(array($p87['font'], '', $p87['font_size']));
        
        //toDel pDF_Data (keep only bodyQuery, for printForms with body_sql_code)        
        if(!empty($p85['body_sql_code'])){
            $pdf_printsData = $pdf->printsData;
            $body_sql_code = eval($p85['body_sql_code']);
            unset($pdf_printsData);
        }  
        $pDF_Data = new PDF_Data();
        if(is_array($body_sql_code) || !empty($body_sql_code)){
            if($p85_input['q10_nr01']>0){
                query_makeQuery00ArrOfReport_replace_q13($p85_input['q10_nr01'], $p85_input, 1);
            }
            if (is_array($body_sql_code)) {
                $sql       = $body_sql_code['sql'];
                $sqlParams = $body_sql_code['sqlParams'];
            } else {
                $sql = $body_sql_code;
                $sqlParams = array();
            }
            
            //echo pegasus_replace_values_in_sql($sql, $sqlParams);
            $pDF_Data->setQuery($sql, $sqlParams);
            $body_data_result = $pDF_Data->pegasus_query();

            $body_sql_data_tmp = $pDF_Data->getData();
            $pdf->printsData->setBodyData($body_sql_data_tmp);

        }elseif(!empty($p85['q10'])){
            //Do Nothing, Reports are taken care of inside PrintsData Class

        }elseif(empty($p85['p50']) && empty($p85['p50_class'])){               
            $br_query             = pegasusGetGlobalVar('gridData_' . $p85_input['dias_container_id'] . '_grid_query' );
            $br_query_whereParams = pegasusGetGlobalVar('gridData_' . $p85_input['dias_container_id'] . '_grid_query_whereParams' );
            
            $pDF_Data->setQuery($br_query, $br_query_whereParams);
            $body_data_result = $pDF_Data->pegasus_query();
        }
        
        
        //Set Top Margin According to max_head_row
        $pdf->_setTopMargin($pdf->max_head_row + $pdf->_getNumOfRowsFromTCPDFHeight($pdf->getHeaderMargin()));        
        
        $body_query    = "select * from p86 where p85=:p85_nr01 and pos=2 order by p86.tax, p86.row, p86.col;"; 
        $body_res      = pegasus_query($body_query, array('p85_nr01' => $p85_input['p85_nr01']));
        $body_data     = pegasus_fetchall($body_res);        
        $body_data_per_row = array();        
        foreach ($body_data as $elem){
            $body_data_per_row[$elem['row']][] = $elem;
        }
        
        $footer_query  = "select * from p86 where p85=:p85_nr01 and pos=3 order by p86.tax, p86.row, p86.col;";
        $footer_res    = pegasus_query($footer_query, array('p85_nr01' => $p85_input['p85_nr01']));
        $footer_data   = pegasus_fetchall($footer_res); 

        //Set Bottom Margin According to max_footer_row
        if($printHeaderOnce){ 
            $pdf->_setBottomMargin($p85['mbot'], true);
        }else{ 
            $pdf->_setBottomMargin($pdf->max_footer_row, true);  
        }
        

        //ektipwnei grammes kai steiles
        if($printColRows){
            $pdf->_setTopMargin($p85['mtop']);
            $pdf->_setBottomMargin($p85['mbot'], true);
            $pdf->setPrintHeader(false);
            $pdf->setPrintFooter(false);
            $pdf->AddPage($p85_orient, $p85['pagesize']);
    
            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2 ,2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2 ,2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2 ,2)), hexdec(substr($p87['font_color'], 4, 2)));
            $p85col = $p85['cols'] - $p85['mleft'] - $p85['mright'];
            
            for ($i = 0; $i < $p85col; $i++) {
                $ekatosta = (int)($i/100)%10 ;
                $dekadika = (int)($i/10)%10;
                if($ekatosta!=0){
                    $tmpRes = $pdf->peg_print_cell(array(
                            'grami' => 0,
                            'stili' => $i
                    ), $ekatosta);
                }
                if($dekadika!=0 || $ekatosta!=0){
                    $tmpRes = $pdf->peg_print_cell(array(
                            'grami' => 1,
                            'stili' => $i
                    ), $dekadika);
                }
                
                $tmpRes = $pdf->peg_print_cell(array(
                        'grami' => 2,
                        'stili' => $i
                ), $i%10 );
            }
            $p85rows = $p85['rows'] - $p85['mtop'] -  $p85['mbot'] -1;
            for ($i = 0; $i < $p85rows ; $i++) {
                $tmpRes = $pdf->peg_print_cell(array(
                        'grami' => $i,
                        'stili' => 0
                ), "$i");
            }
            return true;
        } 
        
        // Αν το header εκυπωνεται μια φορα
        if($printHeaderOnce){
            $i    = 0; // To $i den mporei na mpei sthn class giati epirezetai apo ta dedomena
            $page = 0;

            $pdf->setPrintFooter(false);
            if($custom_addPage===false){
                $pdf->AddPage($p85_orient, $p85['pagesize']);
            }elseif(is_array($custom_addPageConfition)){
                $custom_addPageConfition_cnt++;
                $pdf->AddPage($p85_orient, $p85['pagesize']);
            }
            
            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2, 2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2, 2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2, 2)), hexdec(substr($p87['font_color'], 4, 2)));
            //echo "<pre>". $pdf->getHeaderMargin() . "</pre>";
            //Reset Top Margin
            $pdf->_setTopMargin($pdf->_getNumOfRowsFromTCPDFHeight($pdf->getHeaderMargin()));
            $pdf->setPrintHeader(false);

            

            $body_rows = $pdf->printsData->getBodyNumOfRows(); 
            while($pdf->printsData->hasMoreBodyData()){
                $body = $pdf->printsData->getBodyData();            
                if(count($body_data)>0 and ($pdf instanceof pegTCPDF)){
                    foreach ($body_data_per_row as $row_elem){
                        $pdf->bodyMultiRow($row_elem, $body); 
                    }
                }

                $pdf->printsData->goToNextBodyRow(); 
            }

            //Print Footer
            $pdf->offset_y = $pdf->getTCPDFLastRow();
            foreach ($footer_data as $elem){
                $pdf->p86_data_to_pdf($elem);
            }

        }else{
            
            $page = 0;             
            if($custom_addPage===false){
                $page++; // To plithos tvn selidwn 
                $pdf->AddPage($p85_orient, $p85['pagesize']);

            }elseif(is_array($custom_addPageConfition)){
                $custom_addPageConfition_cnt++;
                $page++;
                $pdf->AddPage($p85_orient, $p85['pagesize']);
            }

            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2, 2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2, 2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2, 2)), hexdec(substr($p87['font_color'], 4, 2)));
           

            $body_rows = $pdf->printsData->getBodyNumOfRows();
            while($pdf->printsData->hasMoreBodyData()){
                $body = $pdf->printsData->getBodyData();
                if(count($body_data)>0 and ($pdf instanceof pegTCPDF)){
                    foreach ($body_data_per_row as $row_elem){
                        $pdf->bodyMultiRow($row_elem, $body); 
                    }
                }

                $pdf->printsData->goToNextBodyRow(); 
            }
            
            //Last's Page Footer is printed by TCPDF::Output
            $pdf->setP85_output(array('pegasus_last_footer'=>true));

            //Terminate Last Page (ASCII mode case)
            if($p85_input['ascii_mode']===true){
                $pdf->endPage();
            }


            $dbg['dbg_pdf'] = $pdf->dbg;
            unset($body_data_result);
            unset($pDF_Data);
        }
        
        
        
        if(empty($p85_input['p85_height']) && empty($p85_input['p85_rows']) && $p85['rolling_paper']==1){
            prints_calc_single_page_pdf_info($pdf, $p85_input);
            prints_print_form_to_pdf($pdf, $p85_input, false);
        }

        return array(
            'time_10'=>($time_1 - $time_0)*1000,
        );

		return true;  
    }

    function prints_merge_multiple_forms_to_pdf($p85, $custom_addPageConfition, $custom_addPageConfition_cnt, $dir){

        $filename = "p85_".$p85['nr01'];
        
        if($custom_addPageConfition['ignore_borders']===true){
            $pdf_FPDI = new FPDI($p85['rows'], $p85['cols'], $p85['width'], $p85['height'], $p85['orient'], 'mm', $p85['pagesize'], 0,  0, 0, 0, $p85['headfootonce'], $p85['classtype']);
        }else{
            $pdf_FPDI = new FPDI($p85['rows'], $p85['cols'], $p85['width'], $p85['height'], $p85['orient'], 'mm', $p85['pagesize'], $p85['mtop'],  $p85['mleft'], $p85['mbot'], $p85['mright'], $p85['headfootonce'], $p85['classtype']);
        }

        $pdf_FPDI->setPrintHeader(false);
        $pdf_FPDI->setPrintFooter(false);
        $pdf_FPDI->SetHeaderMargin(0);
        $pdf_FPDI->SetFooterMargin(0);

        if(is_array($custom_addPageConfition)){  
            
            $p85_hpos = ($p85['hpos']>1) ? $p85['hpos'] : 1;
            $p85_vpos = ($p85['vpos']>1) ? $p85['vpos'] : 1;
            //Support Older Versions
            $p85_hpos = (isset($custom_addPageConfition['fpc'])) ? $custom_addPageConfition['fpc'] : $p85_hpos;
            $p85_vpos = (isset($custom_addPageConfition['fpr'])) ? $custom_addPageConfition['fpr'] : $p85_vpos;

            
            $page_margins = $pdf_FPDI->getMargins();

            $addPageOffset  = 0;
            $print_position = false;
            if($custom_addPageConfition['position']>1){
                $addPageOffset = $custom_addPageConfition['position'] - 1;
                $print_position = true;
            }    
            
            $tmpCnt = $addPageOffset;     
            for ($addPageCnt=1+$addPageOffset; $addPageCnt<=$custom_addPageConfition_cnt+$addPageOffset; $addPageCnt++) { 

                $pageCount = $pdf_FPDI->setSourceFile($dir . "/".$filename."_".($addPageCnt-$addPageOffset).".pdf");
                
                
                //$pageCount = 1  ==>  PDF File somewhere on a Page
                //$pageCount > 1  ==>  Merge whole PDF File / Consecutive PDF pages
                for ($pageNo=1; $pageNo<=$pageCount; $pageNo++) {
                    $adjustPageSize = false;

                    $tmpCnt++; 
                    $tmpVar = ($tmpCnt) % $custom_addPageConfition['mod'];
                    if($custom_addPageConfition['action'][$tmpVar]['addpage'] or $print_position===true){
                        $pdf_FPDI->addPage($p85['orient'], $p85['pagesize']);
                        $print_position = false;
                    }

                    $add_page_col = $custom_addPageConfition['action'][$tmpVar]['custom_offset_x'];
                    $add_page_row = $custom_addPageConfition['action'][$tmpVar]['custom_offset_y'];

                    $add_page_x = $pdf_FPDI->_getTCPDFXFromStili($add_page_col);
                    $add_page_y = $pdf_FPDI->_getTCPDFYFromGrammi($add_page_row);
                    if($custom_addPageConfition['ignore_borders']===true){
                        $add_page_x = $pdf_FPDI->_getTCPDFXFromStili($add_page_col, false);
                        $add_page_y = $pdf_FPDI->_getTCPDFYFromGrammi($add_page_row, false);
                    }


                    $add_page_w = ($pdf_FPDI->getPageWidth()-$page_margins['left']-$page_margins['right'])/$p85_hpos;
                    $add_page_h = ($pdf_FPDI->getPageHeight()-$page_margins['top']-$page_margins['bottom'])/$p85_vpos;
                    if($custom_addPageConfition['ignore_borders']===true){
                        $add_page_w = $pdf_FPDI->getPageWidth()/$p85_hpos;
                        $add_page_h = $pdf_FPDI->getPageHeight()/$p85_vpos;
                    }

                    if($p85['rolling_paper']==1){
                        $add_page_h = 0;
                        $add_page_x = null;
                        $add_page_y = null;
                        $adjustPageSize = true;
                    }

                    //Δεν λαμβάνει υπόψη το υψος της σελίδας που προκυπτει απο το πλήθος θέσεων εκτυπωσης $p85_hpos*$p85_vpos
                    if($custom_addPageConfition['ignore_auto_page_w']===true){
                        $add_page_w = 0;
                    }

                    if($custom_addPageConfition['ignore_auto_page_h']===true){
                        $add_page_h = 0;
                    }

                    $tplIdx         = $pdf_FPDI->importPage($pageNo);                        
                    $tplIdx_size    = $pdf_FPDI->getTemplateSize($tplIdx);
                    $add_page_ratio = $tplIdx_size['w']/$tplIdx_size['h'];
                    //$add_page_h = $add_page_w/$add_page_ratio;                        
                    //echo $add_page_x." -- ".$add_page_y." -- ".$add_page_w." -- ".$add_page_h."<br>";
                    $pdf_FPDI->useTemplate($tplIdx,  $add_page_x, $add_page_y, $add_page_w, $add_page_h, $adjustPageSize);
                }
            }              
        }else{  
            //Merge whole PDF File / Consecutive PDF pages (cover cases where $custom_addPageConfition is undefined)
            $pageCount = $pdf_FPDI->setSourceFile($dir . "/".$filename."_".$custom_addPageConfition_cnt.".pdf");
            
            for ($pageNo=1; $pageNo<=$pageCount; $pageNo++) {                        
                $tplIdx = $pdf_FPDI->importPage($pageNo); 
                $pdf_FPDI->addPage($p85['orient'], $p85['pagesize']);
                $pdf_FPDI->useTemplate($tplIdx);
            }
        }

        return $pdf_FPDI;
    }

    function prints_print_form_to_pdf(&$pdf, $p85_input, $form_to_print_flag=false, &$custom_addPageConfition_cnt = 0){
        if(empty($p85_input['p85_nr01'])){
            die("empty p85_nr01");
        }        
    
        //Select Forma
        pegasus_mysql_use("select * from p85 where nr01= :p85_nr01 " , $p85, array('p85_nr01' => $p85_input['p85_nr01']));
        //Select Main Form
        pegasus_mysql_use("select * from p87 where nr01= :p85_main_style " , $p87, array('p85_main_style' => $p85['main_style']));

        
        if($p85['classtype']==2){
            return prints_print_form_to_tcpdf($pdf, $p85_input, $form_to_print_flag, $custom_addPageConfition_cnt);
        }

        //Recursive Case      
        $custom_addPageConfition = $p85_input['custom_addPageConfition'];
        $classType               = $p85_input['classType'];
        
        /**
         * Variables from Κώδικας πρίν την εκτέλεση της εκτύπωσης
         * 
         * -- $printColRows = true; Ean tha ektypwsei grammes kai stiles
         * -- $backgroundImageFile The background image @example ../../images/webappForm/bgimg.png
         * -- $custom_addPageConfition = array(
         *      mod => //Ean aritmo pou tha kanei mode ton aritmo tis epanalipsis gia na dijei se mia thesi ston pinaka action
         *      cnt => counter start from 0 
         *      action => array(
         *         array(
         *                  custom_offset_y => To offset se grammer (int)
         *                  custom_offset_x => To offset se stiles (int)
         *                  addpage => an tha kanei addpage (boolean)
         *         )
         *      )
         *  )
         */
        
        
        $vdisft             = false;
        $printColRows       = false;    // Den ektipwnei  dedomena h forma otan einai true mono row kai col
        $printHeaderOnce    = false;    // Energopoiome to header kai to footer na ektipononte mia fora
        $body_sql_code      = '';       // O sql kodikas ektelesis tou body
        $body_rows          = 0;        // O sinolikos aritmos grammvn tou body
        
        $body_offset_i      = 0;        // Διόρθωση body γραμμης (TCPDF)
        
        
        $custom_offset_y    = 0;
        $custom_offset_x    = 0;
        $custom_addPage     = false;   //Ean einai true h kentiki klasi prepei na orizei ta condithion se mia metavliti
        
        if(isset($custom_addPageConfition) && is_array($custom_addPageConfition)){
            $custom_addPage = true;
    
            if(empty($custom_addPageConfition_cnt)){ 
                $custom_addPageConfition_cnt = 0; 
            }
            if(empty($custom_addPageConfition['mod'])){
                $custom_addPageConfition['mod'] = 1;
            }
            if(empty($custom_addPageConfition['position'])){
                $custom_addPageConfition['position'] = 1;
            }
            if($custom_addPageConfition['mod']  != sizeof($custom_addPageConfition['action'] )){
                die("Mode wrong value");
            }
        }
                 
        
        $p85_output = array();    //Data που προκύπτουν από τον "Κώδικας πρίν την εκτέλεση της εκτύπωσης"
        if(!empty($p85['code'])){
            try {
                eval($p85['code']);
            } catch (\Throwable $th) {
                die($th->getMessage());
            }
            
        }


        if($p85['rolling_paper']==1){
            $p85['height'] = 10000;
            $p85['rows']   = round($p85['height']/2);

            if(isset($p85_input['p85_height']) && !empty($p85_input['p85_height'])){
                $p85['height'] = $p85_input['p85_height'];
            }
            if(isset($p85_input['p85_rows']) && !empty($p85_input['p85_rows'])){
                $p85['rows'] = $p85_input['p85_rows'];
            }
        }
       
        
        if(strtolower($print_to_pdf_version)!='function'){
            return false;
        }
        
        if(!isset($form_to_print_flag) || $form_to_print_flag == false ){
            $classType =  $p85['classtype'];
            
            $p85_orient = $p85['orient'];
            if($classType ==0){
                $pdf = new pegPDF($p85['rows'], $p85['cols'], $p85['width'], $p85['height'], $p85_orient, 'mm', 'A4', $p85['mleft'], $p85['mbot'],  $p85['mright'], $p85['mtop']);     
            }else{               
                if(empty($p85['pagesize']) and $p85['width']>0 and $p85['height']>0){
                    $p85['pagesize'] = array($p85['width'], $p85['height']);
                }
                if($p85['rotate']!=0){
                    $p85['pagesize']['Rotate'] = $p85['rotate'];
                }
                
                $pdf = new pegTCPDF($p85['rows'], $p85['cols'], $p85['width'], $p85['height'], $p85_orient, 'mm', $p85['pagesize'], $p85['mtop'],  $p85['mleft'], $p85['mbot'], $p85['mright'], $p85['headfootonce']);
                $pdf->p85_callMethod = 'function';

                $pdf->setDataDource($p85['p50'], $p85['q10']);
                //TODO RemUser
                $pdf->SetAuthor('PegasusWebApplication');
                //TODO Anafora
                $pdf->SetTitle('PegasusWebApp');
                //TODO DESC
                $pdf->SetSubject($p85['p30'] );
                $pdf->SetKeywords($p85['p30']); //MAKE THE
                $pdf->set_vdisft($vdisft);
                //XXX add parameter
                //$pdf->SetAutoPageBreak(false);   
            }
        }

        if(isset($form_to_print) and is_array($form_to_print) and (!isset($form_to_print_flag) || $form_to_print_flag==false)){
            $form_to_print_flag = true;
            //var_dump($form_to_print);
            
            
            $index = 1;
            foreach ($form_to_print as $key=>$tmp_form_to_print_value){
                //echo $key;
                if($tmp_form_to_print_value>0 ){
                    $p85_input['p85_nr01']  = $tmp_form_to_print_value;
                    $p85_input['classType'] = $classType;
                    $p85_input['custom_addPageConfition'] = $custom_addPageConfition;
                    $p85_input['form_to_print_index']     = $index;
                    if(isset($form_to_print_main_nr01[$key])){
                        //Different "dias_main_nr01" for each extra form_to_print
                        $p85_input['dias_main_nr01'] = $form_to_print_main_nr01[$key];
                    }
                    prints_print_form_to_pdf($pdf, $p85_input, $form_to_print_flag, $custom_addPageConfition_cnt);
                    if($pdf instanceof pegTCPDF){
                        //$pdf->resetBodyRows();
                        $pdf->resetForm();
                    }
                    $index++;
                }
            }
            $form_to_print_flag = false;
            return true;
        }
        
        if($pdf instanceof pegTCPDF){       
            //Apenergopoiw to Default header
            $pdf->setPrintHeader(false);
            if(file_exists($backgroundImageFile)){
                $pdf->setBackgroundImage($backgroundImageFile);
            }
            else{
                //Κάνω unset στην περίπτωση που εκτυπώνω πολλές φόρμες  
                //και π.χ. η πρώτη έχει background αλλά η δεύτερη όχι
                $pdf->unSetBackgroundImage();
            }
        }
        
        
        //Ean h forma tha ektiponei mia fora to header kai mia fora to Footer
        if($p85['headfootonce']){
            $printHeaderOnce = true;
        }else{
            $pdf->bodyheight = $p85['body_height'] ;
        }
        
        
        //Start main style 
        //H set font kalei thn add font 
        if($pdf instanceof pegTCPDF){
            $pdf->AddFontFamily($p87['font'], '', $p87['font'] . '.php', '', $p87['nr01']);
        }else{
            $pdf->AddFont($p87['font'], '', $p87['font'] . '.php');
        }
         
        $pdf->SetFont($p87['font'], '', $p87['font_size']); 
        if($p87['fill']==1){
            $fill=true;
        }else{
            $fill=false;
        }
        $border = $p87['border'];   
        //END main style
        
        if(!empty($p85['body_sql_code'])){
            $body_sql_code = eval($p85['body_sql_code']);
        }
        
        $pDF_Data = new PDF_Data();
        if(is_array($body_sql_code) || !empty($body_sql_code)){
            if($p85_input['q10_nr01']>0){
                 query_makeQuery00ArrOfReport_replace_q13($p85_input['q10_nr01'], $p85_input, 1);
            }
            if (is_array($body_sql_code)) {
                $sql       = $body_sql_code['sql'];
                $sqlParams = $body_sql_code['sqlParams'];
            } else {
                $sql = $body_sql_code;
                $sqlParams = array();
            }
            $pDF_Data->setQuery($sql , $sqlParams);
            $body_data_result = $pDF_Data->pegasus_query();
        }elseif(!empty($p85['q10'])){
            query_makeQuery00ArrOfReport_replace_q13($p85['q10'], $p85_input, 1);
            $p85_q10_query = query_make_select($p85['q10']);
            $p85_q10_arr = query_replace_q13_from_array($p85['q10'], $p85_q10_query, $p85_input); 
            $pDF_Data->setQuery($p85_q10_arr['sql'], $p85_q10_arr['sqlParams'] );
            $body_data_result = $pDF_Data->pegasus_query();
        }else{            
            $br_query             = pegasusGetGlobalVar('gridData_' . $p85_input['dias_container_id'] . '_grid_query' );
            $br_query_whereParams = pegasusGetGlobalVar('gridData_' . $p85_input['dias_container_id'] . '_grid_query_whereParams' );

            $pDF_Data->setQuery($br_query, $br_query_whereParams);
            $body_data_result = $pDF_Data->pegasus_query();
        }
        
        $headers_query = "select * from p86 where p85=:p85_nr01 and pos=1 order by p86.tax, p86.row, p86.col;";
        $headers_res   = pegasus_query($headers_query, array('p85_nr01' => $p85_input['p85_nr01']));
        if(!$printHeaderOnce){
            $pdf->max_head_row = pegasus_mysql_printfld('p86', 'max(p86.row)', " p85=:p85_nr01 and pos=1", array('p85_nr01' => $p85_input['p85_nr01']));
        }
        $headers_data  = pegasus_fetchall($headers_res);         
        
        $body_query    = "select * from p86 where p85=:p85_nr01 and pos=2 order by p86.tax, p86.row, p86.col;"; 
        $body_res      = pegasus_query($body_query, array('p85_nr01' => $p85_input['p85_nr01']));
        $body_data     = pegasus_fetchall($body_res); 
        
        $footer_query  = "select * from p86 where p85=:p85_nr01 and pos=3 order by p86.tax, p86.row, p86.col;";
        $footer_res    = pegasus_query($footer_query, array('p85_nr01' => $p85_input['p85_nr01']));
        $footer_data   = pegasus_fetchall($footer_res); 
        
        /* 
        print_r($headers_data);
        echo "<br/>####<br/>";
        print_r($body_data);
        echo "<br/>####<br/>";
        print_r($footer_data);
        echo "<br/>####<br/>";
        die(); 
        */

        //ektipwnei grammes kai steiles
        if($printColRows){
            $pdf->AddPage($p85_orient);
    
            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2 ,2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2 ,2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2 ,2)), hexdec(substr($p87['font_color'], 4, 2)));
            $p85col = $p85['cols'] - $p85['mleft'] - $p85['mright'];
            
            for ($i = 0; $i < $p85col; $i++) {
                $ekatosta = (int)($i/100)%10 ;
                $dekadika = (int)($i/10)%10;
                if($ekatosta!=0){
                    $tmpRes = $pdf->peg_print_cell(array(
                            'grami' => 0,
                            'stili' => $i
                    ), $ekatosta);
                }
                if($dekadika!=0 || $ekatosta!=0){
                    $tmpRes = $pdf->peg_print_cell(array(
                            'grami' => 1,
                            'stili' => $i
                    ), $dekadika);
                }
                
                $tmpRes = $pdf->peg_print_cell(array(
                        'grami' => 2,
                        'stili' => $i
                ), $i%10 );
            }
            $p85rows = $p85['rows'] - $p85['mtop'] -  $p85['mbot'] -1;
            for ($i = 0; $i < $p85rows ; $i++) {
                $tmpRes = $pdf->peg_print_cell(array(
                        'grami' => $i,
                        'stili' => 0
                ), "$i");
            }
            return true;
        }
        // Αν το header εκυπωνεται μια φορα
        // die('printHeaderOnce' . $printHeaderOnce);
        if($printHeaderOnce){
            $i = 0; // To $i den mporei na mpei sthn class giati epirezetai apo ta dedomena
            
            $pdf->AddPage($p85_orient);
            
            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2, 2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2, 2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2, 2)), hexdec(substr($p87['font_color'], 4, 2)));
    

            if($_REQUEST['debug']==1){
                echo '<pre> headers_data start</pre>';
                echo '<pre>  ' . print_r( $headers_data , true). ' </pre>';
                echo '<pre> headers_data end</pre>';

                echo '<pre> body_data start</pre>';
                echo '<pre>  ' . print_r( $body_data , true) . ' </pre>';
                echo '<pre> body_data end</pre>';

                echo '<pre> body_data_values start</pre>';
                echo '<pre>  ' . print_r( $pDF_Data->getData(), true) . ' </pre>';
                echo '<pre> body_data_values end</pre>';

                echo '<pre> footer_data start</pre>';
                echo '<pre>  ' . print_r( $footer_data , true) . ' </pre>';
                echo '<pre> footer_data end</pre>';

            }
            
            //Menei otan to header kai to footer ektiponete mia dora
            if(count($headers_data)>0){ 
                foreach ($headers_data as $elem){
                   $ret_array = prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                //    if($ret_array['print_again']){
                //         prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                //    }
                }
            }
            
            $pdf->offset_y = 0;//To midenizw giati exei eisaxthe sto $max_head_row  
            while($body = $pDF_Data->pegasus_fetch_assoc()){
                
                if($pdf instanceof pegTCPDF ){
                    $pdf->set_triggerAddBodyRow(true) ;
                }
                
                $i = $i + $pdf->addBodyI();
                

                $count_body_data = count($body_data);
                $count_body_data_i=0;
                if($count_body_data > 0){ 
                    
                    foreach( $body_data as $elem ){
                        $count_body_data_i++;

                        $default_upi = false;
                        if($count_body_data_i==$count_body_data){
                            $default_upi = true;
                        }

                        $p85_output['body'] = $body;
                        prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page, $default_upi);
                    }
                    
                    $pdf->flushBodyI();
                }
            }
        
            
            //Menei otan to header kai to footer ektiponete mia dora
            if(count($footer_data)>0){ 
                foreach ($footer_data as $elem){
                    $ret_array = prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                    // if($ret_array['print_again']){
                    //     prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                    // }
                }
            }
        }else{
       
            $body_rows   = $pDF_Data->getNumOfRows();
            $page = 0;
            
            //echo "<pre>". print_r($custom_addPageConfition,1) . "</pre>";
            
            $rrr = 0;
            //Να εκτελείται τουλάχιστον μία φορά οταν προερχεται απο "custom_addPageConfition" χωρις Body Data
            $custom_addPage_once = true;
            while($pdf->hasMoreRows($body_rows) or ($body_rows==0 and $custom_addPage_once==true)){
                if($custom_addPage===false){
                    $page++; // To plithos tvn selidwn 
                    $pdf->AddPage($p85_orient);
                }else if(is_array($custom_addPageConfition)){

                    $print_position = false;
                    if($custom_addPageConfition_cnt==0 && $custom_addPageConfition['position']>1){
                        $custom_addPageConfition_cnt = $custom_addPageConfition['position'];
                        $print_position = true;
                    }else{
                        $custom_addPageConfition_cnt++;
                    }
                    $tmpVar =  $custom_addPageConfition_cnt%$custom_addPageConfition['mod'];
                    //echo "<pre>\n-".$tmpVar." cnt: ". $custom_addPageConfition_cnt ." mod:".$custom_addPageConfition['mod'];
                    if($custom_addPageConfition['action'][$tmpVar]['addpage'] or $print_position===true){
                        //echo "\n->Added page";
                        $page++;
                        $pdf->AddPage($p85_orient);
                    }
                    //echo "</pre>";
                    $custom_offset_y = $custom_addPageConfition['action'][$tmpVar]['custom_offset_y'] ;
                    $custom_offset_x = $custom_addPageConfition['action'][$tmpVar]['custom_offset_x'] ;                   
                }
                
                
                if($pdf instanceof pegTCPDF){
                    $pdf->addFormPage();
                    $pdf->custom_offset_y = $custom_offset_y;
                    $pdf->custom_offset_x = $custom_offset_x;                    
                }
                
                $pdf->offset_y = $custom_offset_y; // Apostasi apo pano
                $pdf->offset_x = $custom_offset_x; // Apostasi apo aristera
                $i = 0;                            // Tempory metavliti pou thn sygkrinw me to p85['body_height']
                
                $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2, 2)), hexdec(substr($p87['fill_color'], 4, 2)));
                $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2, 2)), hexdec(substr($p87['draw_color'], 4, 2)));
                $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2, 2)), hexdec(substr($p87['font_color'], 4, 2)));
                
                if(count($headers_data)>0){
                    foreach ($headers_data as $elem){

                        
                        prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                        /*
                            $ret_array=
                            if($ret_array['print_again']){
                                prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                            }
                        */
                    }
                }


                while($pdf->hasMoreSpace($i+$body_offset_i)){                    
                    if($pdf instanceof pegTCPDF ){
                        if(!($pdf->hasMoreRows($body_rows))){
                            if(!isset($overflow_elements) || (is_array($overflow_elements) && !(count($overflow_elements)>0))){
                                break;
                            }
                        }
                        if(!isset($overflow_elements) || (is_array($overflow_elements) && !(count($overflow_elements)>0))){
                            $pdf->set_triggerAddBodyRow(true) ;
                        }
                        $i = $i + $pdf->addBodyI(); 
                        $dbg['i'][] = $i;
                               
                    }else{
                        $i++;
                    }
                    
                    
                    //Check Overflow Elements
                    if(is_array($overflow_elements) && count($overflow_elements)>0){
                        if($first_overflow_element==true){
                            $last_body_row = $pdf->get_body_rows_i();
                            $first_overflow_element = false;
                        }
                        
                        foreach ($overflow_elements as $key=>$elem){
                            //Check & Print Overflow Elements
                            $ret_print_data = prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page); 
                            unset($overflow_elements[$key]);
                            if(count($ret_print_data['overflow_element'])){
                                $overflow_elements[] = $ret_print_data['overflow_element'];
                            }
                        }
                        
                        if($pdf instanceof pegTCPDF ){                           
                            $pdf->flushBodyI();                            
                        }

                        if(!($pdf->hasMoreRows($body_rows))){
                            $pdf->removeBodyRow();
                        }
                        continue;
                    }else{
                        //Neutralize body_rows_i
                        if($last_body_row>0){
                            $pdf->resetBodyRows($last_body_row);
                            $last_body_row = 0;
                        }
                    }
                    
                    $body = $pDF_Data->pegasus_fetch_assoc(); 
                    //echo "<pre>". print_r($body,1) . "</pre>";
                    if(count($body_data)>0 and ((($pdf instanceof pegTCPDF) and $pdf->hasMoreRows($body_rows)) || !($pdf instanceof pegTCPDF))){
                        foreach ($body_data as $elem){
                            $p85_output['body'] = $body;                            
                            $ret_print_data = prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page); 
                            
                            //Check For Overflow Elements
                            if(is_array($ret_print_data['overflow_element']) && count($ret_print_data['overflow_element'])){
                                $overflow_elements[] = $ret_print_data['overflow_element'];
                            }
                        }
                        
                        if(is_array($overflow_elements) && count($overflow_elements)>0){
                            $first_overflow_element = true;
                            if($pdf instanceof pegTCPDF and $pdf->get_body_rows_i()==0){                           
                                $pdf->flushBodyI();                            
                            }
                            break;
                        } 
                                               
                        
                        
                        if($pdf instanceof pegTCPDF ){                           
                            $pdf->flushBodyI();                            
                        }
                    }
                                  
                }
                
                if(!$printHeaderOnce){
                    if(count($footer_data)>0){ 
                        foreach ($footer_data as $elem){

                            if(!($pdf->hasMoreRows($body_rows))){
                                $p85_output['pegasus_last_footer'] = true;
                            }
                            
                            prints_print_form_to_pdf_data($pdf, $p85_output, $classType, $p87, $elem, $i, $page);
                        }
                    }
                }
                
                $custom_addPage_once = false;
            }
            
            // echo "<pre>";
            // var_dump($pdf->getFormCharacteristics());
            // var_dump($pdf->textElementsArray);
            // echo "</pre>";

            $dbg['dbg_pdf'] = $pdf->dbg;
            unset($body_data_result);
            unset($pDF_Data);
        }
        
        if(empty($p85_input['p85_height']) && empty($p85_input['p85_rows']) && $p85['rolling_paper']==1){
            prints_calc_single_page_pdf_info($pdf, $p85_input, $i);
            prints_print_form_to_pdf($pdf, $p85_input, false);                    
        }
		return true;  
    }

    function prints_print_form_to_pdf_data(&$pdf, &$p85_output, $classType, $p87, $elem, &$i, &$page , $default_upi=false){
        
        $print_again =false;
        foreach ($p85_output as $key => $value){
            ${$key} = $value;
        }
        
        //Ektelw to condition gia na dw an tha ektypwsw to pedio
        if(!empty($elem['cond'])){
            
            $cond = eval($elem['cond']);
            if($cond==false){
                return array("print_again" => $print_again);
            }
        }
        
        if($elem['tp']=='image' && isset($p85_output['ca_server_without_images']) && $p85_output['ca_server_without_images']){
            //TODO: memo με valign top
            $elem['p30'] = 'return "[Εικόνα]";';//POL1257 4.4.1
            $elem['tp']='exp';
            $elem['row0'] = 0;
        }
        
        //Midenizw tis metavlites
        $tmpRes             = null;
        $fill               = false;
        $border             = '';
        $url                = '';
        $text               = '';
        $valign             = '';
        $value_updoffset    = false;
        $value_upi          = $default_upi;
        $value_text         = ''; 
        $stretch            = 0;
        $auto_sizing        = false;
        $rotate             = $elem['rotate'];

        if(!empty($elem['p30'])){
            $value = eval($elem['p30']);
        }
        
        
        //Ean exei font to element
        $p87_nr01 = (is_array($value) && $value['p87_nr01']>0) ? $value['p87_nr01'] : $elem['p87'];
        if($p87_nr01>0){
            pegasus_mysql_use("select * from p87 where nr01=?;", $p87_00, array($p87_nr01));
            $font_style  = '';
            $font_style .= ($p87_00['bold']==1)      ? 'B' : '';
            $font_style .= ($p87_00['italic']==1)    ? 'I' : '';
            $font_style .= ($p87_00['underline']==1) ? 'U' : '';
            $font_style .= ($p87_00['strikeout']==1) ? 'D' : '';

            $pdf->AddFontFamily($p87_00['font'], '', $p87_00['font'] . '.php', '', $p87_00['nr01']); 
            $pdf->SetFont($p87_00['font'],  $font_style, $p87_00['font_size']); 
            $pdf->SetFillColor(hexdec(substr($p87_00['fill_color'], 0, 2)), hexdec(substr($p87_00['fill_color'], 2, 2)), hexdec(substr($p87_00['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87_00['draw_color'], 0, 2)), hexdec(substr($p87_00['draw_color'], 2, 2)), hexdec(substr($p87_00['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87_00['font_color'], 0, 2)), hexdec(substr($p87_00['font_color'], 2, 2)), hexdec(substr($p87_00['font_color'], 4, 2)));
            
                        
            if($p87_00['fill']==1){
                $fill=true;
            }else{
                $fill=false;
            }
            $border = $p87_00['border'];        
            unset($p87_00);
        }

        
        $pdf->peg_tmp_lastPrintElementRowsHeight = 0;        
        if($elem['tp']=='line'){
            //XXX Grammi
            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);
            $tmpRes = $pdf->peg_print_line($row, $col, $row0, $col0, $elem['size']);            
        }
        
        if($elem['tp']=='exp'){
            //XXX Ekfrasi           
            
            if(gettype($value) == "array" ){
                $url = (isset($value['url'])) ? $value['url'] : '';
                $value_updoffset = (isset($value['updoffset'])) ? $value['updoffset']       : false;
                $value_upi   = (isset($value['upi']))           ? $value['upi']             : $default_upi;
                $stretch     = (isset($value['stretch']))       ? $value['stretch']         : 0;
                $auto_sizing = (isset($value['autoSizing'])) 	? $value['autoSizing'] 	    : false;
                $rotate      = (isset($value['rotate']))		? $value['rotate']	    	: 0;
			    $text = $value['text'];
            }elseif (gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double"){
                $text = $value;
            }

            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);          
        


            if($classType == 0){
                $size = $elem['size'];
                if(empty($size)){
                    $size = strlen($value);
                }
                $pdf->peg_print_cell($row, $col, $text, $border, $size, $elem['align'], $fill);
            }else{
                //$border    = '';
                $tmpCellAr = array( 
                            'grami'         => $row,
                            'stili'         => $col,
                            'grami0'        => $row0,
                            'stili0'        => $col0,
                            'border'        => $border,
                            'size'          => $elem['size'],
                            'align'         => $elem['align'], 
                            'fill'          => $fill,
                            'upi'           => $value_upi,
                            'url'           => $url,
                            'stretch'       => $stretch,
                            'auto_sizing'   => $auto_sizing,
                            'rotate'        => $rotate
                        );
                $tmpRes = $pdf->peg_print_cell($tmpCellAr, $text);


                if(!empty($text)){
                    $pdf->peg_tmp_lastPrintElementRowsHeight = $tmpRes['height'];
                }
                //$value_updoffset
                if($value_updoffset){
                    $pdf->offset_y += $tmpRes['height'];
                }
                unset($tmpCellAr);
            }
        }
                        
        if($elem['tp']=='exp_memo'){

            //Keimeno me anadiplwsi
            $value_text = "";
            $value_syntelesthsLineHeight = 1;
            
            if(gettype($value)=="array" ){
                $value_text = $value['text'];
                $url        = (isset($value['url'])) ? $value['url'] : '';
                $valign     = (isset($value['valign'])) ? $value['valign'] : 'T';
                $value_upi  = (isset($value['upi'])) ? $value['upi'] : $default_upi;
                $value_syntelesthsLineHeight = (!empty($value['sLN'])) ? $value['sLN'] : 1;
                $value_updoffset             = (isset($value['updoffset']))?$value['updoffset']:false;
                $ln     	= (isset( $value['ln'])) ? $value['ln'] : '2';

            }elseif(gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double"){
                $value_text = $value;
            }
            
            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);
            
            if($elem['row0']==0){
                $row0=0;
            }
            
            $tmpMemoAr = array(
                            'grami'         => $row,
                            'stili'         => $col,
                            'grami0'        => $row0,
                            'stili0'        => $col0,
                            'elemsize'      => $elem['size'],
                            'border'        => $border,
                            'align'         => $elem['align'], 
                            'fill'          => $fill,
                            'url'           => $url,
                            'upi'           => $value_upi,
                            'valign'        => $valign,
                            'synLineHeight' => $value_syntelesthsLineHeight,
                            'ln'            => $ln
                    );
            
            if($elem['pos']=='2' && $pdf->getPrintHeaderOnce()==false){
                //Check Overflow Memo Body Elements
                $elem_width = 0;
                if($elem['size']>0){
                    $elem_width = $pdf->getSWidth()*$elem['size'];
                }elseif ($col0>0){
                    $elem_width = $pdf->getSWidth()*($col0-$col);
                }               

                $stringLength = $pdf->peg_estimateMaxStringLength($value_text, $elem_width, $pdf->bodyheight*$pdf->getGHeight());
                if($stringLength<strlen($value_text)){
                    $value_text_overflow = peg_substr($value_text, $stringLength, strlen($value_text));
                    $value_text = peg_substr($value_text, 0, $stringLength);
                    $overflow_element = $elem;
                    $overflow_element['p30'] = "return '". $value_text_overflow . "';";
                }
            }

            $tmpRes = $pdf->peg_print_memo_array($tmpMemoAr, $value_text);  
            
            if( $tmpRes['print_again'] ){
                $print_again = true;
            }elseif($value_updoffset){            
                $pdf->offset_y += $tmpRes['height'];                    
            }
        }

        if($elem['tp']=='exp_html' and $classType!=0){
            //Keimeno me anadiplwsi
            $value_text = "";
            $value_syntelesthsLineHeight = 1;
        
            if(gettype($value) == "array" ){
                $value_text = $value['text'];
                $value_updoffset = (isset($value['updoffset'])) ? $value['updoffset'] : false;
                $value_upi       = (isset($value['upi'])) ? $value['upi'] : $default_upi;
                $value_syntelesthsLineHeight = (!empty($value['sLN'])) ? $value['sLN'] : 1;
            }elseif (gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double"){
                $value_text = $value;
            }
        
            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);
                
            if($elem['row0']==0){
                $row0 = 0;
            }
                
            $tmpMemoAr = array(
                    'grami'         => $row,
                    'stili'         => $col,
                    'grami0'        => $row0,
                    'stili0'        => $col0,
                    'elemsize'      => $elem['size'],
                    'align'         => $elem['align'],
                    'fill'          => $fill,
                    'upi'           => $value_upi,
                    'synLineHeight' => $value_syntelesthsLineHeight
            );            
            $tmpRes = $pdf->peg_print_html_array($tmpMemoAr, $value_text);

            if($value_updoffset){
                $pdf->offset_y += $tmpRes['height'];
            }       
        }
        
        if($elem['tp']=='image'){
            $imagepath = "";
            $imagelink = "";
            
            if(gettype($value)=="array" ){
                $imagepath = $value['img'];
                $imagelink = $value['link'];
            }elseif(gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double" ){
                $imagepath = $value;
            }
            
            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);
            
            $pdf->peg_print_image_array(array(
                    'grami'  => $row,
                    'stili'  => $col,
                    'grami0' => $row0,
                    'stili0' => $col0,
                    'link'   => $imagelink
                    
            ), $imagepath);
        }
        
        if($elem['tp']=='barcode'){
            
            if(gettype($value)=="array"){
                $code  = $value['value'];
                $type  = $value['barcodeType'];
                $text  = (isset($value['text'])) ? $value['text'] : true; 
                $label = (isset($value['label'])) ? $value['label'] : ''; 
                $hpadding = (isset($value['hpadding']))	? $value['hpadding'] : 'auto'; 
			    $vpadding = (isset($value['vpadding']))	? $value['vpadding'] : 'auto'; 
                $orientation = $value['orientation'];
                $value_upi   = (isset($value['upi'])) ? $value['upi'] : $default_upi; 
            }elseif (gettype($value)=="string"  || gettype($value)=="integer" || gettype($value)=="double" ){
                $code = $value;
            }
            
            list($row, $col, $row0, $col0) = $pdf->peg_get_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0'], $i);
            
            $tmpBarCodeAr = array(
                'grami'        => $row,
                'stili'        => $col,
                'grami0'       => $row0,
                'stili0'       => $col0,
                'upi'          => $value_upi,
                'elemsize'     => $elem['size'],
                'align'        => $elem['align'],
                'type'         => $type,
                'orientation'  => $orientation,
                'text'         => $text,
                'label'        => $label,
                'hpadding'     => $hpadding,
                'vpadding'     => $vpadding
            );

            $tmpBarCodeRes = $pdf->peg_print_barcode_array($tmpBarCodeAr, $code);
            if(!empty($code)){
                $pdf->peg_tmp_lastPrintElementRowsHeight = $tmpBarCodeRes['rowsHeight'];
            }
        }

        if(isset($value)){
            unset($value);
        }
        if(isset($tmpRes)){
            unset($tmpRes);
        }
        
        //Epanaferw to default theme
        if($p87_nr01>0){
            $pdf->SetFont($p87['font'], '', $p87['font_size']); 
        
            $pdf->SetFillColor(hexdec(substr($p87['fill_color'], 0, 2)), hexdec(substr($p87['fill_color'], 2, 2)), hexdec(substr($p87['fill_color'], 4, 2)));
            $pdf->SetDrawColor(hexdec(substr($p87['draw_color'], 0, 2)), hexdec(substr($p87['draw_color'], 2, 2)), hexdec(substr($p87['draw_color'], 4, 2)));
            $pdf->SetTextColor(hexdec(substr($p87['font_color'], 0, 2)), hexdec(substr($p87['font_color'], 2, 2)), hexdec(substr($p87['font_color'], 4, 2)));
            if($p87['fill']==1){
                $fill=true;
            }else{
                $fill=false;
            }
            $border = $p87['border']; 
        }
        
        $ret_array = array("print_again" => $print_again);
        if(is_array($overflow_element) && count($overflow_element)){ $ret_array = array_merge($ret_array, array("overflow_element"=>$overflow_element)); }

        
        return $ret_array;
    }    
    
    function prints_generate_pdf_filename($p85_input){

        $filename = '';
        
        $query  = 'select desc02,edesc02,desc07 from p50 ';
        $query .= 'join p51 on p51.p02=p50.p02 and p51.module=p50.module ';
        $query .= 'where p50.p01=? and p51.desc07="screen";';

        pegasus_mysql_use("select p50,q10 from p85 where nr01=:p85_nr01 ", $p85, array('p85_nr01'=>$p85_input['p85_nr01']));
        
        if($p85['q10']>0){
            $filename = pegasus_mysql_printfld('q10', 'ep01', 'nr01=?', array($p85['q10']));
            if(empty($filename)){
                pegasus_mysql_use($query, $p50, array('q10'));
                $filename = $p50['edesc02'] . '_' . $p85['q10'];
            }
        }elseif(!empty($p85_input['dias_main_table'])){
            
            if(function_exists('peg_'.$p85_input['dias_main_table'].'_find_mail_attached_filename')){
                $functionname = 'peg_'.$p85_input['dias_main_table'].'_find_mail_attached_filename';			
                $filename = $functionname( $p85_input['dias_main_nr01']);
                $filename = str_replace(".pdf", "", $filename);
            }
            if(empty($filename)){
                pegasus_mysql_use($query, $p50, array($p85_input['dias_main_table']));
                $filename = $p50['edesc02'];	
                if(empty($filename)){
                    $filename = $p85_input['dias_main_table'];
                }
                if($p85_input['dias_main_table']=='p51'){
                    $filename .= '_' . pegasus_mysql_printfld('p51', 'p02', 'nr01=?', array($p85_input['dias_main_nr01']));
                }else{
                    if(is_array($p85_input['dias_main_nr01']) or strpos($p85_input['dias_main_nr01'], ',')!==false){
                        $filename .= '_' . date('Ymd'). '_' .date('His');
                    }else{
                        $filename .= '_' . $p85_input['dias_main_nr01'];
                    }
                }		
            }             		
        }elseif(in_array($p85_input['p85_nr01'], array(140000000000000,140000000000001,140000000000003,140000000000004))){
            if(!empty($p85_input['q10_nr01'])){
                $filename = pegasus_mysql_printfld('q10', 'ep01', 'nr01=?', array($p85_input['q10_nr01']));
                if(empty($filename)){
                    pegasus_mysql_use($query, $p50, array('q10'));
                    $filename = $p50['edesc02'] . '_' . $p85_input['q10_nr01'];
                }	
            }
        }else{
            $filename = 'doc_' . $p85_input['p85_nr01'] . '_' . date('Ymd') . '_' . date('His');        
        }


        
        $replace_arr = array(
            ' '=>'_',
            '/'=>'_',
        );
        $filename = str_replace(array_keys($replace_arr), array_values($replace_arr), $filename);
        if(!empty($filename)){
            $filename .= '.pdf';
        }
    
        return $filename;       
    }

    function prints_calc_single_page_pdf_info(&$pdf, &$p85_input){
        
        //TODO Rows Prediction if last element is image
        $margins     = $pdf->getMargins();
        $page_height = $pdf->GetY()+$margins['header']+$margins['footer']+$margins['top']+$margins['bottom']+2*$pdf->getGHeight();
        $pdf_last_page_total_rows = $pdf->_getNumOfRowsFromTCPDFHeight($page_height);

        $pdf_total_rows   = $pdf->_getGrammes()*($pdf->getNumPages()-1) + $pdf_last_page_total_rows;
        $pdf_total_height = $pdf->getGHeight()*$pdf_total_rows;

        $p85_input['p85_rows']   = ceil($pdf_total_rows);
        $p85_input['p85_height'] = ceil($pdf_total_height);
        
        //Διόρθωση για να μην υπαρχει αυτοματη αλλαγή orientation στη σελίδα [tcpdf->setPageOrientation()]
        if($p85_input['p85_height']<$pdf->getWidth()){
            $p85_input['p85_height'] = $pdf->getWidth();    
        }
        
        //$pdf->MultiCell($width, $height, "Hello TCPDF Roll!", 1, 'L', true, 1, 0, $pdf->GetY()+2*$pdf->getGHeight(), true, 0, false, true);	
		
        
        /**Debug**/
        $dbg = array(   'y' => $pdf->GetY(),
                        'page_height'                   => $page_height,
                        '_getNumOfRowsFromTCPDFHeight'  => $pdf->_getNumOfRowsFromTCPDFHeight( $pdf->GetY()),
                        'getTCPDFLastRow'               => $pdf->getTCPDFLastRow(),
                        'offset_y'                      => $pdf->offset_y,
                        'Grammes'                       => $pdf->_getGrammes(),
                        's_width'                       => $pdf->getSWidth(),
                        'g_height'                      => $pdf->getGHeight(),
                        'numpages'                      => $pdf->getNumPages(),
                        'margins'                       => $pdf->getMargins(),
                        'pdf_last_page_total_rows'      => $pdf_last_page_total_rows,
                        'pdf_total_rows'                => $pdf_total_rows,
                        'pdf_total_height'              => $pdf_total_height,
                        'pdf_final_total_rows'          => $p85_input['p85_rows'],
                        'pdf_final_total_height'        => $p85_input['p85_height']
                    );

        if($_REQUEST['debug']=='calc_single_page'){       
            echo "<pre>". print_r($dbg,1) . "</pre>";  
        }
        // peg_write_file("../../tmp/tesae_prints_debug", print_r($dbg,1));


        return true;
    }


    /**
     * Only For Debug W/H
     * @param string $p86_nr01
     * @param bool $return_array
     * @param int $mode (0:p86, 1:peg_tmp_p86)
     * @return mixed 
     */
    function prints_element_aspect_ratio($p86_nr01, $return_array=false, $mode=0){

        $tbl = ($mode==1) ? 'peg_tmp_p86' : 'p86 ';

        $query  = 'select '.$tbl.'.*, '; 
        $query .= 'p85.orient as p85_orient, p85.pagesize as p85_pagesize, p85.height as p85_height, p85.width as p85_width, '; 
        $query .= 'p85.rows as p85_rows, p85.cols as p85_cols ';
        $query .= 'from '.$tbl.' ';
        $query .= 'left join p85 on p85.nr01='.$tbl.'.p85 ';
        $query .= 'where '.$tbl.'.nr01=?;';

        pegasus_mysql_use($query, $p86, array($p86_nr01));
        
        if($p86['p85_orient']=='L' && !empty($p86['p85_pagesize'])){            
            $width_mm  = ($p86['col0']-$p86['col'])*($p86['p85_height']/$p86['p85_cols']);
            $height_mm = ($p86['row0']-$p86['row'])*($p86['p85_width']/$p86['p85_rows']);
        }else{
            $width_mm  = ($p86['col0']-$p86['col'])*($p86['p85_width']/$p86['p85_cols']);
            $height_mm = ($p86['row0']-$p86['row'])*($p86['p85_height']/$p86['p85_rows']);    
        }

        $ratio = $width_mm/$height_mm;

        $ratio = array(
            'p86_nr01'   =>  $p86['nr01'],
            'orient'     =>  $p86['p85_orient'],
            'pagesize'   =>  $p86['p85_pagesize'],
            'width_mm'   =>  $width_mm,
            'height_mm'  =>  $height_mm,
            'ratio'      =>  $ratio,
        );
        
        return ($return_array==true) ? $ratio : "<pre>". print_r($ratio, 1) . "</pre>";
    }


    /**
     * 
     * @param array     $p86
     * @param array     $p85
     * @return array    array || false
     */
    function prints_check_elem_rotation($p86, $p85){
        $tmp_data = array();

        if(in_array($p86['rotate'], array(90,270))){
            $p85['ratio'] = ($p85['width']/$p85['cols'])/($p85['height']/$p85['rows']);
            
            $tmp_data['row']  = $p86['row'] - ($p86['col0'] - $p86['col'])*$p85['ratio'];
            $tmp_data['row0'] = $p86['row'];
            $tmp_data['col']  = $p86['col'];
            $tmp_data['col0'] = $p86['col'] + ($p86['row0'] - $p86['row'])*1/$p85['ratio']; 
            return $tmp_data;
		}

        return false;
    }


    //Check Condition για να δω αν θα εμφανιζεται το πεδίο
    /**
     * @param string    $cond
     * @param array     $p85_output
     * @param pegTCPDF  $pdf
     * @param boolean   $update_p85_output  Set true if you want to Update $p85_output from condition
     * @param array     $body               p85 body sql data (only for older Print Forms Versions)
     * @return array    array || false
     */
    function prints_check_elem_condition($cond, $p85_output, $pdf=null, $update_p85_output=false, $body=null){
        
        foreach ($p85_output as $key => $value){
            ${$key} = $value;
        }
        
        $result = true;
        if(!empty($cond)){					
            $result = eval($cond);
        }

        if($update_p85_output==true){
            $pdf->setP85_output($p85_output);   
        }

        return $result;
    }


    /** 
     * Prints_02 Table Data
     * @param integer   $nr01   ID
     * @param integer   $p85    Form
     * @param integer   $p00    File Code
     * @param boolean   $tmp    Use Temp Table
     * @return string   $fpath  File/Directory Path
     */
    function prints_get_forms_image_fpath($nr01, $p85=0, $p00=-1, $tmp=false, $full_path=true){

        $fpath = '';
        $table = ($tmp==true) ? 'peg_tmp_prints_02' : 'prints_02';

        $query = 'select * from '.$table.' ';
        if($nr01>0){
            $query .= 'where nr01=:nr01;';
            $values_arr = array('nr01'=>$nr01);
        }else{            
            $query .= 'where p85=:p85 and p00=:p00;';
            $values_arr = array('p85'=>$p85, 'p00'=>$p00);
        }
        pegasus_mysql_use($query, $prints_02, $values_arr);

        if($prints_02['nr01']>0 && !empty($prints_02['p02'])){
            $fpath = $prints_02['p02'].'.'.$prints_02['p03'];
            if($full_path==true){
                $fpath = '../../images/webappForm'.$prints_02['p85'].'/'.$prints_02['p02'].'.'.$prints_02['p03'];
            }
        }elseif($p85>0){
            $fpath = '../../images/webappForm'.$p85.'/';
        }
        
        return $fpath;
    }

    function prints_print_form_to_pdf_prepare_request(&$p85_input, $payload){

        foreach ($payload as $key => $value){
            
            if(!in_array(strtolower($key), array('hpos', 'vpos', 'cookiesinfo_popup', 'phpsessid', 'contactus_popup', 'pegasuswebappprp', '__unam'))){

                if($key=='dias_main_nr01'){
                    $dias_main_nr01_arr = explode(',', $value);
                    //In case of Multiple Nr01s or Multiple Position Layout
                    if(count($dias_main_nr01_arr)>1 || $payload['vpos']*$payload['hpos']>1){
                        $p85_input[$key] = $dias_main_nr01_arr;
                    }else{
                        $p85_input[$key] = $dias_main_nr01_arr[0];
                    }
                }elseif($key=='form_to_print_p85_input'){
                    //par1_1:val1_1#par1_2:val1_2,par2_1:val2_1#par2_2:val2_2
                    $exp_arr = explode(',', $value);  
                    foreach ($exp_arr as $i=>$input_data) {
                        $exp_arr_2 = explode('#', $input_data); 
                        foreach ($exp_arr_2 as $ii=>$input_data_2) {
                            $exp_arr_3 = explode(':', $input_data_2); 
                            $input_data_arr[$i][$exp_arr_3[0]] = $exp_arr_3[1];  
                        } 
                    }
    
                    if(count($input_data_arr)>1){
                        $p85_input['form_to_print_p85_input'] = $input_data_arr;
                    }else{
                        foreach ($input_data_arr[0] as $j=>$v) {
                            $p85_input[$j] = $v;  
                        }
                    }
                }else{
                    $p85_input[$key] = $value;
                }

            }
        }
    }
?>