<?php
class prints_pegapi_actions extends pegapi_RestObject
{
    /**
     * @return array
     */
    public function print()
    {
        switch ($this->method) {
            case 'POST':
                return $this->post();
                break;
        }
	}    
	private function post()
	{
		try {
			$ret = array(
				'status'	=> 200,
                'code'      => 200
			);
			$tbl 		= $this->request['tbl'];
			$tbl_nr01 	= $this->request['tbl_nr01'];	
			$p85 		= $this->request['p85'];
			
			$ret_arr = array();
			$ret_arr['ok'] = 1;
            $code   = 403;
            $status = 403;
			if(!pegasus_mysql_table_exists($tbl)) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_tbl_not_exists'];
			}elseif(!pegasus_mysql_printfld($tbl, 'nr01', 'nr01 = ?', array($tbl_nr01))) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_record_not_exists'];
			}elseif(!empty($p85) && !pegasus_mysql_printfld('p85', 'nr01', 'nr01 = ?', array($p85))) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_p85_not_exists'];
			}elseif(!empty($p85) && pegasus_mysql_printfld('p85', 'p50', 'nr01 = ?', array($p85)) != $tbl) {
				$ret_arr['ok'] = 0;
				$ret_arr['msg'] = $_SESSION['peg_dic_mail_p85_wrong_tbl'];
			}

			// Αν δεν έχω σφάλμα από πάνω.
			if($ret_arr['ok'] == 1) {
				$p85_input = array();
				$p85_input['p85_nr01']        = $p85;
				$p85_input['dias_main_table'] = $tbl;	
				$p85_input['dias_main_nr01']  = $tbl_nr01;
			
				if(pegasus_module_exists('prints')){            
					if(prints_print_form_to_pdf($pdf, $p85_input)){
						$filename = prints_generate_pdf_filename($p85_input);
						$pdf->Output($filename);    
					}    
				}
			}
			
			$ret['data'] = array();
			$ret['data']['ok']  = $ret_arr['ok'];
			$ret['data']['msg'] = $ret_arr['msg'];
            $ret['code']    = $code;
            $ret['status']  = $status;
			return $ret;
		} catch(Exception $e) {
			return array(
				'status'	=> 403,
				'code'		=> 403,
				'data'		=> array('error' => array('title' => "Error", 'detail' => $e->getMessage()))
			);
		}
	}
}