<?php
	
	if(class_exists('TCPDF')===false){		
		if(file_exists('../../pegasus_cloud_app/prints_libs/TCPDF/tcpdf.php')){
			require('../../pegasus_cloud_app/prints_libs/TCPDF/tcpdf.php');
		}else{
			if(!file_exists('../../pegasus_cloud_app/core_libs/tcpdf/tcpdf.php')){
				die('File core_libs/tcpdf/tcpdf.php not found');
			}	
			require('../../pegasus_cloud_app/core_libs/tcpdf/tcpdf.php');
		}
	}
    
    class pegTCPDF extends TCPDF { 
    	private static $tmpPath = '../../tmp/_tcpdf_print/';
		
		public 	$p85_nr01;
		public 	$p85_classType;
		public 	$p85_callMethod;
		private	$p85_output;
        public 	$p87;

		/**
    	 * Τα Δεδομενα Εκτύπωσης της Φόρμας
    	 * @var PrintsData
    	 */
		public 	$printsData;	
    	
    	/**
    	 * Boolean metavliti opoi tha kanei brake to body
    	 * anejartita tou 
    	 * @var bool
    	 */
    	public $bodyBreak  = FALSE;
    	
    	/**
    	 * Sthn allagi selidaw h aritmisi twn grmmwn prepei na jekinaei apo to 0
    	 * @var int
    	 */
    	public $minusGrammes;
    	/**
    	 * To offset se grammes (se kathe nea selida midenizetai)
    	 * @var double
    	 */
    	public $offset_y;
    	 
    	public $custom_offset_y;
    	/**
    	 * To offset se stiles (se kathe nea selida midenizetai)
    	 * @var double
    	 */
    	public $offset_x;
    	 
    	public $custom_offset_x;
    	
    	/**
    	 * To upsos toy header (se kathe nea selida midenizetai)
    	 * @var double
    	 */
    	public $max_head_row;	
		public $max_footer_row;

    	/**
    	 * To upsos toy body (se kathe nea selida midenizetai) kai arxikopoieite apo to pp85
    	 * @var double
    	 */
    	public $bodyheight;
    	
    	public $textElementsArray; 

		public $initialCellPaddings;
    	
    	/**
    	 * H panafora apo diavazw ta dedomena
    	 * @var number
    	 */
    	private $dataDourceQ10;
    	/**
    	 * O p;inakas pou diavazw ta dedomena
    	 * @var string
    	 */
    	private $dataDourceP50;
    	
    	private $width;
    	private $height;
		private $format;
    	
    	/**
    	 * Toplithis ton grammvn tis ektypwsis
    	 * @var int
    	 */
    	private $grammes;
    	/**
    	 * To plitos twn stilwn ths ektiposis
    	 * @var int
    	 */
    	private $stiles;
    	/**
    	 * Sintelestis anamesa sto upsos ths forma me to plithos ton grammvn
    	 * ($this->h /$this->grammes)
    	 * @var float
    	 */
    	private $g_height;
    	/**
    	 * Sintelestis anamesa sto platos ths forma me to plithos twnstilwn
    	 * ($this->w )/$this->stiles;
    	 * @var float
    	 */
    	private $s_width;
    	
    	
    	/**
    	 * To top margin se grammes
    	 * @var int
    	 */
    	private $top_margin;
    	/**
    	 * To right margin se stiles
    	 * @var int
    	 */
    	private $right_margin;
    	/**
    	 * To bottom margin se grammes
    	 * @var int
    	 */
    	private $bottom_margin;
    	/**
    	 * To left margin se stiles
    	 * @var int
    	 */
    	private $left_margin;
    	
    	/**
    	 * Ean tha ektypvnete to header mia fora
    	 * to xreiazome gia na mhn epireazw to bodyheight
    	 * @var boolean
    	 */
    	private $printHeaderOnce;
    	/**
    	 * Poio einai to plithos ton dedomenwn poy exoyn ektypothei sto body of this page
    	 * @var int
    	 */
    	private $body_rows_i;
    	/**
    	 * To path gia thn bg eikona
    	 * @var string 
    	 * 
    	 * @example 
    	 *     ../../imagename
    	 */
    	private $bgImage;
    	
    	/**
    	 * To teleytaio upsos poy epsestrepse h _getHeight
    	 * @var double
    	 */
    	private $peg_tmp_lasth;
    	/**
    	 * Ti tiposai gia teleytaia fora
    	 * @var string
    	 *     enum {
    	 * 		  line	=> Grammi
    	 * 		  exp		=> ektipwnei keli (ekfrasi)
    	 * 		  exp_memo=> keimeno me anadiplwsi
    	 * 		  exp_html=> Ektipwnei html
    	 * 		  image	=> eikona
    	 *     }
    	 */
    	private $peg_tmp_lastPrintType;
    	/**
    	 * Pou tioposai gia teleutaia fora
    	 * @var enum{1=> header,2 => body,3 => footer}
    	 */
		private $peg_tmp_lastPosition;
		
		private $peg_tmp_lastPageStart;
		
		/**
    	 * Height of the last Printed Element
		 * This value is updated during an element print 
    	 */
		public $peg_tmp_lastPrintElementRowsHeight;
    	/**
    	 * Ean tha prepei na mhdenistoun oi grammes giati exw allagi selidas
    	 * @var boolean
    	 */
    	private $updMinusTrigger;
    	/**
    	 * To trigger pou mou leei otu prepei na ekrelesv to add body i
    	 * Diladi exei prostethei ena neo eidos sthn ektipwsei
    	 * @var boolean $triggerAddBodyRow
    	 */
    	private $triggerAddBodyRow;
    	
    	
    	
    	/**
    	 * H i eggrafi poy ektypwnw sthn selida
    	 * @var int
    	 */
    	private $body_tmp_i;
    	/**
    	 * Poio einai to plithos ton dedomenwn poy exoyn ektypothei sto body
    	 * @var array{};
    	 */
    	private $body_row_i_data;
    	/**
    	 * Einai true otan ekteleite to flush data gia na ektypvenei dedomena sto body
    	 * @var boolean
    	 */
    	private $bodyFlush	= FALSE;
    	/**
    	 * Poia einai h megaliteri grammi pou typwsai gia teleytaia
    	 * fora sto body
    	 */
    	private $peg_tmp_last_bodyrow;
    	/**
    	 * Thelw na jerw poia einai h megaliteri grammi apo thn trecousa ektipwsi
    	 */
    	private $peg_tmp_last_body_current_row;

		private $peg_max_body_elem_height;
    	/**
    	 * Ean tha einai disable h ektupwsi toy footer
    	 * @var boolean $vdisft
    	 */
    	private $vdisft = false;
    	
    	private $cashingAddFont = array();
    	
    	private $fillColorAr;
    	private $drawColorAr;
    	private $textColorAr;
    	//XXX Start metavlites poy ektipwnonte apo th forma 
    	private $formPage;
    	
    	/**
    	 * 
    	 * @param string $var
    	 * @param string $string
    	 */
    	
    	private function _writeLogFile($var='', $string=''){
    		return;
    		$mode = 'a';
    		/* if($this->execForTime==0){
    			$mode = 'w';
    			} */
    	
    		$fp = fopen(pegTCPDF::$tmpPath.'/tcpdf.log', $mode );
    		if($fp === false){
    			die('Error ' . pegTCPDF::$tmpPath.'/tcpdf.log');
    		}
    		if(!empty($var)){
    			fprintf($fp, 
    					"Export Var:\n %s \n\n ###\n\n",
    					var_export($var,true) );
    		}
    		if(!empty($string)){
    // 			$string
    			fprintf($fp,
    					" \n ###\n Export Var: %s \n ###\n",
    					$string );
    		
    			
    		}
    		
    		fclose($fp);
    	}
    	
    	public function __construct(
    					$grammes='77', $stiles='115', $total_width='297', $total_height='210', 
    					$orientation='P', $unit='mm', $size='A4' ,  $top_margin=0 ,
    					$left_margin=0 , $bottom_margin=0 , $right_margin=0 ,
    					$printHeaderOnce = false, $classType=1
    			){
    		parent::__construct($orientation,$unit,$size);
    		
			$this->p85_classType = $classType;

    		$this->width  = $total_width;
    		$this->height = $total_height;
			$this->format = $size;
    		
    		
    		$this->updMinusTrigger	= false;
    		$this->minusGrammes		= 0;
    		$this->offset_y			= 0;
    		$this->offset_x			= 0;
    		$this->custom_offset_y = 0;
    		$this->custom_offset_x = 0;
    		 
    		$this->max_head_row		= 0;
    		$this->bodyheight		= 0;
    		/* $thkis->body_rows_i		= 0; */
    		$this->lastRow			= 0;
    		$this->peg_tmp_lastPosition = 0;
    		$this->peg_tmp_last_bodyrow = 0;
    		$this->peg_tmp_last_body_current_row = 0;
    		$this->printHeaderOnce = $printHeaderOnce;
    		$this->url = "";
			$this->tcpdflink = false;
    		$this->peg_color = array(
    				'maincolor' =>
    				array('r' => '', 'g' => '', 'b' => '') ,
    				'linkcolor' =>
    				array('r' => '', 'g' => '', 'b' => '')
    		);
    		
    		$this->triggerAddBodyRow = false;
    		
    		$this->_setGrammes($grammes);
    		$this->_setStiles($stiles);    		
    		
			$this->initialCellPaddings = $this->getCellPaddings();
    		
    		
    		/* $this->_setTotalWidth($total_width);
    		$this->_setTotalHeight($total_height);*/
    		$this->_setLeftMargin($left_margin);
    		$this->_setTopMargin($top_margin);
    		$this->_setRightMargin($right_margin);
    		/* if($bottom_margin<3){
    			$bottom_margin = 3;
    		} */
    		$this->bottom_margin  = $bottom_margin; 
    		
    		$this->setAutoPageBreak(true, $this->_getTCPDFYFromGrammi(0));
    		$this->setFooterMargin(4);
			
			if($this->p85_classType==2){
				if($this->top_margin==0){
					$this->setHeaderMargin(0);	
				}else{
					$this->setHeaderMargin($this->_getTCPDFHeight(0, $this->top_margin));
				}
				
				if($this->top_margin==0){
					$this->setAutoPageBreak(true, 0);
					$this->setFooterMargin(0);
				}else{
					$this->setAutoPageBreak(true, $this->_getTCPDFHeight(0, $this->bottom_margin));
					$this->setFooterMargin($this->_getTCPDFHeight(0, $this->bottom_margin));
				}
			}

    		$this->setFooterFont(Array('helvetica', '', 8));
    		/* $this->setFooterData(array(0,64,0));
    		$this->setFooterFont(Array('helvetica', '', 8)); */
    		$this->dataDourceQ10 ="";
    		$this->dataDourceP50 ="";
    	
    		$this->bodyFlush = false;
    		
    		$this->resetForm();
    		$this->vdisft = false;
    		
			$this->cashingAddFont = array();
			
    		$this->textElementsArray = array();			 
    	}

		public function setP85_output($p85_output){
			foreach ($p85_output as $key => $value){
				$this->p85_output[$key] = $value;
			}
		}

		public function getP85_output(){
			return $this->p85_output;
		}

		public function getPrintHeaderOnce(){
			return $this->printHeaderOnce;
		}

		public function getPrintHeader(){
			return $this->print_header;
		}

		public function getWidth(){
			return $this->width;
		}

		public function getHeight(){
			return $this->height;
		}
		
    
		public function getFormCharacteristics(){
			$form_characteristics = array();

			//Χρησιμοποιούνται από την PrintsPDFToText
			$form_characteristics['left_margin'] 	= $this->left_margin;
			$form_characteristics['top_margin'] 	= $this->top_margin;
			$form_characteristics['bottom_margin'] 	= $this->bottom_margin;
			$form_characteristics['cell_paddings'] 	= $this->getCellPaddings();
			$form_characteristics['grammes'] 		= $this->grammes;
			$form_characteristics['page_width'] 	= $this->getPageWidth();
			$form_characteristics['right_margin'] 	= $this->right_margin;
			
			$form_characteristics['header_margin'] 	= $this->_getNumOfRowsFromTCPDFHeight($this->getHeaderMargin());
			$form_characteristics['footer_margin'] 	= $this->_getNumOfRowsFromTCPDFHeight($this->getFooterMargin());

			$form_characteristics['print_header'] 	= $this->print_header;
			$form_characteristics['print_footer'] 	= $this->print_footer;

			//Κρατάω τα παρακάτω σχολιασμένα γιατί μπορεί να χρειαστούν στο μέλλον
			//Φέρνει το Width/Height από την currentpage, επομένως, θα πρέπει να έχει γίνει κάποια εκτύπωση τουλαχιστον μια φορα
			/*
			$form_characteristics['page_height'] = $this->getPageHeight();
			$form_characteristics['stiles'] = $this->stiles;

			$form_characteristics['scale_factor'] = $this->getScaleFactor();
			$form_characteristics['cell_margins'] = $this->getCellMargins();
			$form_characteristics['FontAscent'] = $this->FontAscent;
			$form_characteristics['FontDescent'] = $this->FontDescent;	
			$form_characteristics['s_width'] = $this->s_width;*/

			return $form_characteristics;
		}
		public function getMultiCellHeight($w, $h, $txt, $border=0, $align='J', $fill=false, $ln=1, $x='', $y='', $reseth=true, $stretch=0, $ishtml=false, $autopadding=true, $maxh=0, $valign='T', $fitcell=false) {

			 if($ishtml){
			 	$height = $this->getHTMLCellHeight($w, $h, $x, $y, $txt='', $border, $ln, $fill, $reseth, $align, $autopadding);
			 }else{
				$this->startTransaction();

				// store starting values
				$start_y    = $this->GetY();
				$start_page = $this->getPage();

				$tmp_new_page = false;
				if($start_page==0){ 
					$tmp_new_page = true;
					$this->AddPage($this->CurOrientation, $this->format); 					
					$start_y    = $this->GetY();
					$start_page = $this->getPage();
				}
				//if($start_page==0){ $start_page = 1; }
				$height   = $this->MultiCell($w, $h, $txt, $border, $align, $fill, $ln, $x, $y, $reseth, $stretch, $ishtml, $autopadding, $maxh, $valign, $fitcell);
				$end_y    = $this->GetY();
				$end_page = $this->getPage();

				// echo "<pre>". $height  . "</pre>";
				// echo "<pre>$end_y - $start_y</pre>";
				
				// calculate height
				$height = 0;
				if ($end_page == $start_page) {
					$height = $end_y - $start_y;
				} else {
					for ($page=$start_page; $page <= $end_page; ++$page) {
						$this->setPage($page);
						if ($page == $start_page) {
							// first page
							$height += $this->getPageHeight() - $start_y - $this->getBreakMargin();
						
						} elseif ($page == $end_page) {
							// last page
							$__margins = $this->getMargins();
							$height += $end_y - $__margins['top'] ;
						} else {
							$__margins = $this->getMargins();
							$height += $this->getPageHeight() - $__margins['top'] - $this->getBreakMargin();
						}
					}
				}
	
				//restore previous object
				$this->rollbackTransaction(true);
				if($tmp_new_page==true){ 
					$this->deletePage($start_page);
				}
			}

 
			return $height;
		}		



		public function getHTMLCellHeight($w, $h, $x, $y, $html='', $border=0, $ln=0, $fill=false, $reseth=true, $align='', $autopadding=true){
			
			//Checks if there is a "nobr" attribute inside html and returns "0" height (code from "writeHTML")
			$dom   = $this->getHtmlDomArray($html);
			$maxel = count($dom);
			$key   = 0;
			while ($key<$maxel) {
				if ($dom[$key]['tag'] AND $dom[$key]['opening'] AND isset($dom[$key]['attribute']['nobr']) AND ($dom[$key]['attribute']['nobr'] == 'true')) {
					return 0;	
				}
				++$key;
			}

			$this->startTransaction();
			// store starting values
			$start_y    = $this->GetY();
			$start_page = $this->getPage();

			$tmp_new_page = false;
			if($start_page==0){ 
				$tmp_new_page     = true;
				$tmp_print_header = $this->print_header;
				$this->setPrintHeader(false);
				$this->AddPage($this->CurOrientation, $this->format); 
				$start_y    = $this->GetY();
				$start_page = $this->getPage();
			}
			
			// call your printing functions with your parameters
			// - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
			//echo "<br>writeHTMLCell $w, $h, $x, $y, $html, $border, $ln, $fill, $reseth, $align, $autopadding";
			$this->writeHTMLCell($w, $h, $x, $y, $html, $border, $ln, $fill, $reseth, $align, $autopadding);
			
			
		
			//- - - - - - - - - - - - - - - - - - - - - - - - - - - - -
			// get the new Y
			$end_y = $this->GetY();
			$end_page = $this->getPage();

			// calculate height
			$height = 0;
			if ($end_page == $start_page) {
				$height = $end_y - $start_y;
			} else {

				for ($page=$start_page; $page <= $end_page; ++$page) {
					$this->setPage($page);
					if ($page == $start_page) {
						// first page
						$height += $this->getPageHeight() - $start_y - $this->getBreakMargin();
					} elseif ($page == $end_page) {
						// last page
						$__margins = $this->getMargins();
						$height += $end_y - $__margins['top'] ;
					} else {
						$__margins = $this->getMargins();
						$height += $this->getPageHeight() - $__margins['top'] - $this->getBreakMargin();
					}
				}
			}
			
			// echo "<pre>getHTMLCellHeight</pre>";
			// echo "<pre>html=". $html . "</pre>";
			// echo "<pre>start_page=". $start_page . "</pre>";
			// echo "<pre>start_y=". $start_y . "</pre>";
			// echo "<pre>end_page=". $end_page . "</pre>";
			// echo "<pre>end_y=". $end_y . "</pre>";
			// echo "<pre>height=". $height . "</pre>";
			//echo '<pre>'.print_r($this,1).'</pre>';
			//restore previous object
			$this->rollbackTransaction(true);
			if($tmp_new_page==true){ 
				$this->deletePage($start_page);
				$this->setPrintHeader($tmp_print_header);
			}
			//unset($pdf);

			//return 1;
			 return $height ;
		}		
		
		
    	public function setDataDource($p50,$q10){
    		if(!empty($q10)){
    			$this->dataDourceQ10 = $q10;
    			return ;
    		}
    		$this->dataDourceP50 = $p50;
    		
    	}
    	
    	public function set_triggerAddBodyRow($val){
    		if(gettype($val) == 'boolean'){
    			$this->triggerAddBodyRow = $val;
    		}
    	}
    	
		public function printBackgroundImage(){
    	    if(!empty($this->bgImage)){
				$bMargin = $this->getBreakMargin();				// get the current page break margin
				$auto_page_break = $this->getAutoPageBreak();	// get current auto-page-break mode
				$this->setAutoPageBreak(false, 0); 				// disable auto-page-break

				$total_width  = $this->width;
				$total_height = $this->height;
				if($this->CurOrientation=='L'){
					$total_width  = $this->height;
					$total_height = $this->width;
				}

				$this->Image($this->bgImage, 0, 0, $total_width, $total_height, '', '', '', false, 300, '', false, false, 0);				
				
				$this->setAutoPageBreak($auto_page_break, $bMargin);	// restore auto-page-break status				
				$this->setPageMark();									// set the starting point for the page content
			}
    	}
    	
    	public function setBackgroundImage($filename){
    	    if(file_exists($filename)){
    	        $this->bgImage = $filename;
			}
    	} 
		public function unSetBackgroundImage(){
			unset($this->bgImage);
		} 
			
    	public function resetBodyRows($body_rows=0){
    		$this->body_rows_i = $body_rows;
    	} 
    	public function resetFormPage(){
    	    $this->formPage = 0;
    	} 
    	public function addFormPage(){
    	    ++$this->formPage;
    	}
    	public function getFormPage(){
    	    return $this->formPage;
		}

		public function getSWidth(){
    	    return $this->s_width;
		}

		public function getGHeight(){
    	    return $this->g_height;
		}
		
		
    	
    	public function resetForm(){
    	    
    	    $this->resetBodyRows();
    	    $this->resetFormPage();
    	    $this->resetLastH();
    	    
    	   
    	    
    	    $this->updMinusTrigger	= false;
    	    $this->minusGrammes		= 0;
    	    $this->offset_y			= 0;
    	    $this->offset_x			= 0;
    	    $this->custom_offset_y = 0;
    	    $this->custom_offset_x = 0;
    	    $this->max_head_row		= 0;
    	    $this->bodyheight		= 0;
    	    $this->lastRow			= 0;
    	    $this->peg_tmp_lastPosition = 0;
    	    $this->peg_tmp_last_bodyrow = 0;
    	    $this->peg_tmp_last_body_current_row = 0;
    	    $this->triggerAddBodyRow = false;
    	    
    	    $this->bodyFlush = false;
    	    
    	    $this->body_row_i_data             = array();
    	    $this->body_row_i_data['elem']     = array();
    	    $this->body_row_i_data['rowstart'] = NULL;
    	    $this->body_row_i_data['rowend']   = NULL;
    	} 
    
    	
    	/**
    	 * Sthn prosthiki neas selidas thelw na energopoio to trigger tou midenismoy
    	 * @see TCPDF::AddPage()
    	 */
    	public function AddPage($orientation='', $format='', $keepmargins=false, $tocpage=false){
    		$this->updMinusTrigger = true;
			$this->offset_y = 0;

    		parent::AddPage($orientation, $format, $keepmargins, $tocpage);
    		
			if($this->p85_classType==1){
				$this->printBackgroundImage();
			}
    	}
    	
    	/**
    	 * Kanei add Ta font. kai elegxei ean exoun idi ginei add
    	 * @see TCPDF::AddFont()
    	 */
    	public function addFontFamily($family, $style='', $fontfile='', $subset='', $id=0){

			$subset = (empty($subset))	?	'default'	:	$subset;
    		 
    		if($id>0 and isset($this->cashingAddFont[$id])){
				//Font Allready Added
				/* print_r($this->cashingAddFont); */
				return ;    						
    		}
    	
    		if($id>0){
				$this->cashingAddFont[$id] = array('style' => $style, 'fontfile' => $fontfile, 'subset' => $subset);
			}
    			
    		return $this->AddFont($family, $style, $fontfile, $subset);
    	}
    	/**
    	 * Kanei add Ta font. Thn kanw extend 
    	 * 		1. gia n mhn exw fatal error sta arialgreek
    	 * 		2. Na kanw add font ean yparxei eidi
    	 * @see TCPDF::AddFont()
    	 */
    	public function AddFont($family, $style='', $fontfile='', $subset=''){

			$subset = (empty($subset))	?	'default'	:	$subset;

    		if(strtolower($family) == "arialgreek" || empty($family)){
    			//$family = 'dejavusans';
    			$family = 'freesans'; //Ξ‘Ξ»Ξ»Ξ±Ξ³Ξ· Ξ³ΞΉΞ± ΞΌΞ±ΟΞΊΞΏΞ¶Ξ±Ξ½Ξ½ΞµΟ‚ Ξ Ξ Ξ¥ 2020048 
    			//$file = '';
    		}
    		return parent::AddFont($family, $style, $fontfile, $subset);
    	}
    	/**
    	 * Kanei set Ta font. Thn kanw extern gia n mhn exw fatal error sta arialgreek
    	 * @see TCPDF::setFont()
    	 */
    	public function setFont($family, $style='', $size=null, $fontfile='', $subset='default', $out=true){
			if(strtolower($family) == "arialgreek"  || empty($family)){
    			//$family = 'dejavusans';
    			$family = 'freesans'; //Ξ‘Ξ»Ξ»Ξ±Ξ³Ξ· Ξ³ΞΉΞ± ΞΌΞ±ΟΞΊΞΏΞ¶Ξ±Ξ½Ξ½ΞµΟ‚ Ξ Ξ Ξ¥ 2020048 
    			//$file = '';
    		}
    		return parent::setFont($family, $style, $size, $fontfile, $subset, $out);
    	}
    	
    	
    	public function setFillColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    			$this->fillColorAr = array(
    					'col1'	=> $col1, 
    					'col2'	=> $col2, 
    					'col3'	=> $col3, 
    					'col4'	=> $col4, 
    					'ret'		=> $ret, 
    					'name'	=> $name
    					
    			);		
    		return parent::setFillColor($col1, $col2, $col3, $col4, $ret, $name);
    	}
    	
    	public function setDrawColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    		$this->drawColorAr = array(
    				'col1'	=> $col1,
    				'col2'	=> $col2,
    				'col3'	=> $col3,
    				'col4'	=> $col4,
    				'ret'		=> $ret,
    				'name'	=> $name
    					
    		);
    		return parent::setDrawColor($col1, $col2, $col3, $col4, $ret, $name);
    	}
    	public function setTextColor($col1=0, $col2=-1, $col3=-1, $col4=-1, $ret=false, $name=''){
    		$this->textColorAr = array(
    				'col1'	=> $col1,
    				'col2'	=> $col2,
    				'col3'	=> $col3,
    				'col4'	=> $col4,
    				'ret'		=> $ret,
    				'name'	=> $name
    					
    		);
    		parent::setTextColor($col1, $col2, $col3, $col4, $ret, $name);
    	}


		public function MultiRow($left, $right) {
			// MultiCell($w, $h, $txt, $border=0, $align='J', $fill=0, $ln=1, $x='', $y='', $reseth=true, $stretch=0)
	
			$page_start = $this->getPage();
			$y_start = $this->GetY();
	
			// write the left cell
			$this->MultiCell(40, 0, $left, 1, 'R', 1, 2, '', '', true, 0);
	
			$page_end_1 = $this->getPage();
			$y_end_1 = $this->GetY();
			
			$this->setPage($page_start);
	
			// write the right cell
			$this->MultiCell(0, 0, $right, 1, 'L', 0, 1, $this->GetX() ,$y_start, true, 0);
	
			$page_end_2 = $this->getPage();
			$y_end_2 = $this->GetY();
	
			// set the new row position by case
			if (max($page_end_1,$page_end_2) == $page_start) {
				$ynew = max($y_end_1, $y_end_2);
			} elseif ($page_end_1 == $page_end_2) {
				$ynew = max($y_end_1, $y_end_2);
			} elseif ($page_end_1 > $page_end_2) {
				$ynew = $y_end_1;
			} else {
				$ynew = $y_end_2;
			}
	
			$this->setPage(max($page_end_1,$page_end_2));
			$this->setXY($this->GetX(),$ynew);
		}


		public function bodyMultiRow($body_row=array(), $body) {
			
			$page_start = $this->getPage();
			$y_start    = $this->GetY();

			$page_end = array();
			$y_end    = array(); 
			
			foreach ($body_row as $index => $elem) {
				$x_start = $this->_getTCPDFXFromStili($elem['col']);
				$ret_body_data = $this->p86_body_data_to_pdf($body, $elem, $page_start, $x_start, $y_start);
				$page_end[$index] = $ret_body_data['page_end'];
				$y_end[$index]    = $ret_body_data['y_end'];
			}
	
			// set the new row position by case
			if(max($page_end)==$page_start) {
				$y_new = max($y_end);
			}elseif (min($page_end)==max($page_end)) {
				$y_new = max($y_end);
			}else{
				foreach ($page_end as $key => $value) {
					if($value==max($page_end) && $y_new<$y_end[$key]){
						$y_new = $y_end[$key];	
					}
				}	
			}

			if ($this->rtl) {
				$x_new = $this->original_rMargin;
			} else {
				$x_new = $this->original_lMargin;
			}
			
	
			$this->setPage(max($page_end));
			$this->setXY($x_new, $y_new);
			
		}

		/**
		 * Prints p86 body data to pdf.
		 * @param array	$body	p85 body sql data (only for older Print Forms Versions)
		 * @param array $elem	p86 body element
		 * @param int 	$page	print page
		 * @param float	$x		x position in user units
	 	 * @param float	$y		y position in user units
		 * @return array(page_end, y_end)
		 * @public
		 */
		public function p86_body_data_to_pdf($body, $elem, $page, $x='', $y=''){

			$ret_array = array();
			$ret_array['page_end'] = $page;
			$ret_array['y_end']    = $y;

			foreach ($this->p85_output as $key => $value){
				$p85_output[$key] = $value;
				${$key} = $value;
			}


			//Set $pdf copy of $this object inside Body Data
			$pdf = $this;
			//Ektelw to condition gia na dw an tha ektypwsw to pedio
			if(prints_check_elem_condition($elem['cond'], $p85_output, $pdf, true, $body)==false){
				return $ret_array;
			}		
	
			if(!empty($elem['p30'])){
				$value = eval($elem['p30']);
			}
			$this->setP85_output($p85_output);
			

			//Midenizw tis metavlites
			$fill        = false;
			$border      = '';
			$url         = '';
			$value_text  = ''; 
			$ln 		 = '2';
			$stretch     = 0;
			$auto_sizing = false;
			$rotate      = $elem['rotate'];
			$align 		 = (!empty($elem['align'])) ? $elem['align'] : 'L';
			$valign      = '';

			if(gettype($value)=="array"){
				$value_text  = $value['text'];
				$url         = (isset($value['url'])) 			? $value['url'] 		: '';
				$valign      = (isset($value['valign'])) 		? $value['valign'] 		: 'T';
				$rotate      = (isset($value['rotate']))	 	? $value['rotate'] 		: $rotate;
				$stretch     = (isset($value['stretch']))       ? $value['stretch']  	: $stretch;
				$auto_sizing = (isset($value['autoSizing']))	? $value['autoSizing']	: $auto_sizing;
				$value_upi   = (isset($value['upi']))           ? $value['upi']         : $default_upi;
				$ln     	 = ($value_upi==true) 				? '1'		 			: $ln;

			}elseif(gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double"){
				$value_text = $value;
			}
							

			$width = 0;
			if($elem['size']>0){
				$width = $this->_getTCPDFWidth(0, $elem['size']);
			}elseif($elem['col0']>0){
				$width = $this->_getTCPDFWidth($elem['col'], $elem['col0']);
			}
			
			$height    = 0;
			$maxHeight = 0;
			if($elem['row0']>0){
				$height = $this->_getTCPDFHeight($elem['row'], $elem['row0']);
				if($valign=='B' || $valign=='M' || $valign=='T'){
					$maxHeight = $height;
				}
			}
			
			
			$pushTextElements  = false;
			$textElementsArray = array( 
				'page_start'	=> $page,
				'pegasus_grammi_start' => $this->_getRowFromY($y, false),
				'pegasus_stili_start'  => $elem['col'],
				'text' => $value_text,
				'returned_nl' => 1,
			);
			
			$this->peg_tmp_lastPageStart = $page;
			$this->setPage($page);


			//Ean exei font to element
			$p87_nr01 = (is_array($value) && $value['p87_nr01']>0) ? $value['p87_nr01'] : $elem['p87'];
			if($p87_nr01>0){
				pegasus_mysql_use("select * from p87 where nr01=?;", $p87_00, array($p87_nr01));
			}else{
				$p87_00 = $this->p87;
			}
			
			if($p87_00['nr01']>0){
				$font_style  = '';
				$font_style .= ($p87_00['bold']==1)      ? 'B' : '';
				$font_style .= ($p87_00['italic']==1)    ? 'I' : '';
				$font_style .= ($p87_00['underline']==1) ? 'U' : '';
				$font_style .= ($p87_00['strikeout']==1) ? 'D' : '';
	
				$this->addFontFamily($p87_00['font'], '', $p87_00['font'] . '.php', '', $p87_00['nr01']);
				$this->setFont($p87_00['font'],  $font_style, $p87_00['font_size']);
				$this->setFontSize($p87_00['font_size']); 
				$this->setFillColor(hexdec(substr($p87_00['fill_color'], 0, 2)), hexdec(substr($p87_00['fill_color'], 2, 2)), hexdec(substr($p87_00['fill_color'], 4, 2)));
				$this->setDrawColor(hexdec(substr($p87_00['draw_color'], 0, 2)), hexdec(substr($p87_00['draw_color'], 2, 2)), hexdec(substr($p87_00['draw_color'], 4, 2)));
				$this->setTextColor(hexdec(substr($p87_00['font_color'], 0, 2)), hexdec(substr($p87_00['font_color'], 2, 2)), hexdec(substr($p87_00['font_color'], 4, 2)));
				
							
				if($p87_00['fill']==1){
					$fill = true;
				}else{
					$fill = false;
				}
				$border = $p87_00['border']; 
				unset($p87_00);
			}

			if($elem['tp']=='exp' or $elem['tp']=='exp_memo'){
				$nl = $this->MultiCell($width, $height, $value_text, $border, $align, $fill, $ln, $x, $y, true, $stretch, false, true, $maxHeight, $valign, false);
				
				$pushTextElements = true;
				$textElementsArray['page_end'] = $this->getPage();


				//ASCII textElements
				if($elem['tp']=='exp'){	
					$textElementsArray['fname'] = 'peg_print_cell';
					$textElementsArray['returnHeight'] = ($textElementsArray['returnHeight']==0) ? 1 : $height;
				
				}elseif($elem['tp']=='exp_memo'){	
					$returnHeight = $this->_getNumOfRowsFromTCPDFHeight($this->GetY()-$y);

					$textElementsArray['fname'] = 'peg_print_memo_array';
					$textElementsArray['pegasus_width'] = $width;
					$textElementsArray['returnHeight']  = $returnHeight;
					$textElementsArray['returned_nl']   = $nl;
					$textElementsArray['letter_widths'] = $this->GetStringWidth($value_text, '', '', 0, true);
				}

			}elseif($elem['tp']=='exp_html'){
				
				//Help 
				//HTML break Page '<br pagebreak="true" />';

				$value_text = $this->peg_formatHtmlText($value_text);

				$nl = $this->MultiCell($width, $height, $value_text, $border, $align, $fill, $ln, $x, $y, true, 0, true, true, 0, $valign, false);	
				
				//ASCII textElements
				$pushTextElements = true;
				$textElementsArray['fname'] = 'peg_print_html_array';
				$textElementsArray['pegasus_width'] = $width;
				$textElementsArray['returnHeight']  = $returnHeight;
				$textElementsArray['returned_nl']   = $nl;
				$textElementsArray['letter_widths'] = $this->GetStringWidth($value_text, '', '', 0, true);
			
			}elseif($elem['tp']=='line'){

				if($elem['size']>0){
					$lineWidthTmp = $this->LineWidth;
					$this->setLineWidth($elem['size']);    				
				}
				
				if($stili_bottom>($this->stiles-$this->right_margin)){
					$stili_bottom = ($this->stiles-$this->right_margin);
				}

				
				$y_top    = $this->_getTCPDFYFromGrammi($elem['row']);
				$y_bottom = $this->_getTCPDFYFromGrammi($elem['row0']);
				$x_top    = $this->_getTCPDFXFromStili($elem['col']);
    			$x_bottom = $this->_getTCPDFXFromStili($elem['col0']);
				if($elem['row']==$elem['row0']){
					$y_top 	  = $y;
					$y_bottom = $y;
				}elseif($elem['col']==$elem['col0']){
					$x_top 	  = $x;
					$x_bottom = $x;

					$y_bottom = $y+($y_bottom-$y_top);
					$y_top 	  = $y;
				}
				
				$this->Line($x_top, $y_top, $x_bottom, $y_bottom);

				if($elem['size']>0){
					$this->setLineWidth($lineWidthTmp);
				}

			}elseif($elem['tp']=='barcode'){

				$type        = 'C39'; 
				$orientation = 'H'; 
				$hpadding 	 = 'auto'; 
				$vpadding 	 = 'auto';
				$text        = true;
				$label       = '';
				$valign 	 = 'B';	//The value can be: T,M,B,N
				$position    = '';
				$marginTop 	 = 0;

				//if true distort the barcode to fit width and height, otherwise preserve aspect ratio
				$distort = false;
				//(float) width of the smallest bar in user units (empty string = default value = 0.4mm)
				$xres = null;

				if(is_array($value)){
					$code     	 = $value['value'];
					$type     	 = $value['barcodeType'];
					$text     	 = (isset($value['text']))        ? $value['text']        : $text; 
					$label 	  	 = (isset($value['label']))       ? $value['label']       : $label; 
					$hpadding 	 = (isset($value['hpadding']))	  ? $value['hpadding']    : $hpadding; 
					$vpadding 	 = (isset($value['vpadding']))	  ? $value['vpadding'] 	  : $vpadding;
					$position 	 = (isset($value['position'])) 	  ? $value['position']    : $position;
					$orientation = (isset($value['orientation'])) ? $value['orientation'] : $orientation;
					$xres 		 = (isset($value['xres'])) 		  ? $value['xres'] 		  : $xres;
					$border      = (isset($value['border']))	  ? $value['border'] 	  : false;

					$marginTop   = (isset($value['marginTop']))   ? $value['marginTop']   : $marginTop;
				}else{
					$code = $value;
				}

				$style = array(
					'position' 		=> $position,
					'align'			=> 'C',
					'stretch' 		=> false,
					'fitwidth' 		=> true,
					'cellfitalign' 	=> '',
					'border' 		=> $border,
					'hpadding' 		=> $hpadding,
					'vpadding' 		=> $vpadding,
					'fgcolor' 		=> array(0,0,0),
					'bgcolor' 		=> false, //array(255,255,255),
					'text' 			=> $text,
					'font' 			=> $p87_00['font'],
					'fontsize' 		=> $p87_00['font_size'],
					'stretchtext' 	=> 4,
					'label' 		=> $label
				);
				// echo "<pre>". $width . "</pre>";
				// echo "<pre>". $height . "</pre>";


				if($marginTop>0){
					$y += $this->_getTCPDFHeight(0,$marginTop);
				}

				if(in_array($type, array('DATAMATRIX', 'PDF417', 'QRCODE', 'RAW', 'RAW2'))){
					$this->write2DBarcode($code, $type, $x, $y, $width, $height, $style, $valign, $distort);
				}else{
					if($orientation=='H'){
					   $this->write1DBarcode($code, $type, $x, $y, $width, $height, $xres, $style, $valign);    
					}elseif($orientation=='V'){
						$this->StartTransform();
						$this->Rotate(90, $x+$width, $y+$height);
						$this->write1DBarcode($code, $type, $x+$width, $y+$height-$width, $height, $width, $xres, $style, $valign);
						$this->StopTransform();    
					}
				}
				
			}
			
			$ret_array['page_end']  = $this->getPage();
			$ret_array['y_end']     = $this->GetY();
			

			//ASCII textElements
			if($pushTextElements){				
				//Correction on Page Break (ASCII)
				if($textElementsArray['page_end']>$textElementsArray['page_start'] && $textElementsArray['returnHeight']<=1){
					$textElementsArray['page_start'] = $textElementsArray['page_end'];
					$textElementsArray['pegasus_grammi_start'] = ($this->_getRowFromY(($this->GetY()-$this->lasth), false));
				}

				$this->_push_textElementsArray($textElementsArray);
			}
			
			//Epanaferw to default theme
			// if($p87_nr01>0){
			// 	$this->setFont($this->p87['font'], '', $this->p87['font_size']);
			// 	$this->setFillColor(hexdec(substr($this->p87['fill_color'], 0, 2)), hexdec(substr($this->p87['fill_color'], 2, 2)), hexdec(substr($this->p87['fill_color'], 4, 2)));
			// 	$this->setDrawColor(hexdec(substr($this->p87['draw_color'], 0, 2)), hexdec(substr($this->p87['draw_color'], 2, 2)), hexdec(substr($this->p87['draw_color'], 4, 2)));
			// 	$this->setTextColor(hexdec(substr($this->p87['font_color'], 0, 2)), hexdec(substr($this->p87['font_color'], 2, 2)), hexdec(substr($this->p87['font_color'], 4, 2)));
			// 	if($this->p87['fill']==1){
			// 		$fill = true;
			// 	}else{
			// 		$fill = false;
			// 	}
			// 	$border = $this->p87['border']; 
			// }

			return $ret_array;	
		}


		/**
		 * Prints p86 Header/Footer data to pdf.
		 * @param $elem array() p86 element
		 * @param $getOnlyHeight (boolean)
		 * @return float Height if $getOnlyHeight==true
		 * @public
		 */
		public function p86_data_to_pdf($elem, $getOnlyHeight=false){

			foreach ($this->p85_output as $key => $value){
				$p85_output[$key] = $value;
				${$key} = $value;
			}
			
			//Set $pdf copy of $this object inside Data
			$pdf = $this;
			//Ektelw to condition gia na dw an tha ektypwsw to pedio
			if(prints_check_elem_condition($elem['cond'], $p85_output, $pdf, true)==false){
				return;
			}
			
			if($elem['tp']=='image' && isset($this->p85_output['ca_server_without_images']) && $this->p85_output['ca_server_without_images']){
				//TODO: memo με valign top
				$elem['p30']  = 'return "[Εικόνα]";';	//POL1257 4.4.1
				$elem['tp']   = 'exp';
				$elem['row0'] = 0;
			}
	
			if(!empty($elem['p30'])){
				$value = eval($elem['p30']);
			}

			$this->setP85_output($p85_output);

			//Midenizw tis metavlites
			$fill        = false;
			$border      = '';
			$url         = '';
			$value_text  = ''; 
			$ln 		 = '2';
			$stretch     = 0;
			$auto_sizing = false;
			$rotate      = $elem['rotate'];
			$align 		 = (!empty($elem['align'])) ? $elem['align'] : 'L';
			$valign      = '';

			$value_updoffset = false;
			$value_upi       = false;

			//Ean exei font to element
			$p87_nr01 = (is_array($value) && $value['p87_nr01']>0) ? $value['p87_nr01'] : $elem['p87'];
			if($p87_nr01>0){
				pegasus_mysql_use("select * from p87 where nr01=?;", $p87_00, array($p87_nr01));
			}else{
				$p87_00 = $this->p87;
			}
			
			if($p87_00['nr01']>0){
				//pegasus_mysql_use("select * from p87 where nr01=?;", $p87_00, array($p87_nr01));
				$font_style  = '';
				$font_style .= ($p87_00['bold']==1)      ? 'B' : '';
				$font_style .= ($p87_00['italic']==1)    ? 'I' : '';
				$font_style .= ($p87_00['underline']==1) ? 'U' : '';
				$font_style .= ($p87_00['strikeout']==1) ? 'D' : '';
	
				$this->addFontFamily($p87_00['font'], '', $p87_00['font'] . '.php', '', $p87_00['nr01']); 
				$this->setFont($p87_00['font'],  $font_style, $p87_00['font_size']); 
				$this->setFillColor(hexdec(substr($p87_00['fill_color'], 0, 2)), hexdec(substr($p87_00['fill_color'], 2, 2)), hexdec(substr($p87_00['fill_color'], 4, 2)));
				$this->setDrawColor(hexdec(substr($p87_00['draw_color'], 0, 2)), hexdec(substr($p87_00['draw_color'], 2, 2)), hexdec(substr($p87_00['draw_color'], 4, 2)));
				$this->setTextColor(hexdec(substr($p87_00['font_color'], 0, 2)), hexdec(substr($p87_00['font_color'], 2, 2)), hexdec(substr($p87_00['font_color'], 4, 2)));
				
							
				if($p87_00['fill']==1){
					$fill = true;
				}else{
					$fill = false;
				}
				$border = $p87_00['border'];        
				unset($p87_00);
			}
			
			if(gettype($value)=="array"){
				$value_text  = $value['text'];
				$url         = (isset($value['url'])) 			? $value['url'] 		: '';
				$valign      = (isset($value['valign'])) 		? $value['valign'] 		: 'T';
				$rotate      = (isset($value['rotate']))	 	? $value['rotate'] 		: $rotate;
				$stretch     = (isset($value['stretch']))       ? $value['stretch']  	: $stretch;
				$auto_sizing = (isset($value['autoSizing']))	? $value['autoSizing']	: $auto_sizing;
				
				$value_updoffset = (isset($value['updoffset'])) ? $value['updoffset'] 	: $value_updoffset;
				$value_upi   	 = (isset($value['upi']))           ? $value['upi']     : $value_upi;
				$ln = ($value_upi==true || $value_updoffset==true)  ? '1' 				: $ln;

			}elseif(gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double"){
				$value_text = $value;
			}

			
			
			if($elem['tp']=='line'){
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);
				$tmpRes = $this->peg_print_line($row, $col, $row0, $col0, $elem['size'], $elem['pos']);            
			}

			if($elem['tp']=='exp'){
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);

				// TesaeDev Edit-Comment 
				// Όταν έχω Εκφρασεις για Header/Footer μίας γραμμής κι εχω ορισμένη "Έως Στήλη" ή "Μεγεθος (σε cols)" 
				// θα πρεπει να περιορίζεται αυτοματα το μεγεθος της εκφρασης
				// Under Test
				$width = 0;
				if($size>0){
					$width = $this->s_width*$size;
				}elseif($elem['col0']>0){
					$width = $this->_getTCPDFWidth($elem['col'], $elem['col0']);
				}

				$text_width = $this->GetStringWidth($value_text);
				if(	$text_width>$width && 
					$width>0 &&
					!(($elem['row0']-$elem['row'])>1) &&
					strpos($value_text, $this->getAliasNumPage())===false &&
					strpos($value_text, $this->getAliasNbPages())===false
				){
					$auto_sizing = true;
				}



				$tmpCellAr = array( 
					'nr01'          => $elem['nr01'],
					'grami'         => $row,
					'stili'         => $col,
					'grami0'        => $row0,
					'stili0'        => $col0,
					'border'        => $border,
					'size'          => $elem['size'],
					'align'         => $align, 
					'fill'          => $fill,
					'upi'           => $value_upi,
					'url'           => $url,
					'stretch'       => $stretch,
					'auto_sizing'   => $auto_sizing,
					'rotate'        => $rotate,
					'pos'           => $elem['pos']
				);
				$tmpRes = $this->peg_print_cell($tmpCellAr, $value_text);
			}
			

			if($elem['tp']=='exp_memo'){
				
				$value_syntelesthsLineHeight = 1;
				
				if(gettype($value)=="array" ){
					$value_syntelesthsLineHeight = (!empty($value['sLN'])) ? $value['sLN'] : 1;
				}
				
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);
				
				if($elem['row0']==0){
					$row0 = 0;
				}
				
				$tmpMemoAr = array(
					'grami'         => $row,
					'stili'         => $col,
					'grami0'        => $row0,
					'stili0'        => $col0,
					'elemsize'      => $elem['size'],
					'border'        => $border,
					'align'         => $align, 
					'fill'          => $fill,
					'url'           => $url,
					'upi'           => $value_upi,
					'valign'        => $valign,
					'synLineHeight' => $value_syntelesthsLineHeight,
					'ln'            => $ln,
					'pos'           => $elem['pos']
				);
				
				$tmpRes = $this->peg_print_memo_array($tmpMemoAr, $value_text, $getOnlyHeight);				
				if($getOnlyHeight==false){
					if($row0==0){
						$this->offset_y += $tmpRes['height'];
					}
				}
			}


			if($elem['tp']=='exp_html'){
				
				$value_syntelesthsLineHeight = 1;
			
				if(gettype($value) == "array" ){
					$value_syntelesthsLineHeight = (!empty($value['sLN'])) ? $value['sLN'] : 1;
				}
			
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);
					
				if($elem['row0']==0){
					$row0 = 0;
				}
					
				$tmpHtmlAr = array(
						'grami'         => $row,
						'stili'         => $col,
						'grami0'        => $row0,
						'stili0'        => $col0,
						'elemsize'      => $elem['size'],
						'align'         => $align,
						'fill'          => $fill,
						'upi'           => $value_upi,
						'synLineHeight' => $value_syntelesthsLineHeight,
						'pos'           => $elem['pos'],
						'ln'            => $ln,
				);            
				$tmpRes = $this->peg_print_html_array($tmpHtmlAr, $value_text, $getOnlyHeight);  
				if($getOnlyHeight==false){
					if($row0==0){
						$this->offset_y += $tmpRes['height'];
					}
				}
				
			}


			if($elem['tp']=='image'){
				$imagepath = "";
				$imagelink = "";
				
				if(gettype($value)=="array" ){
					$imagepath   = $value['img'];
					$imagelink   = $value['link'];
					$imageborder = $value['border'];
				}elseif(gettype($value)=="string" || gettype($value)=="integer" || gettype($value)=="double" ){
					$imagepath = $value;
				}
				
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);
				
				$tmpImageAr = array( 
					'grami'  => $row,
					'stili'  => $col,
					'grami0' => $row0,
					'stili0' => $col0,
					'link'   => $imagelink,
					'pos'    => $elem['pos'],
					'border' => $imageborder,
				);

				$tmpRes = $this->peg_print_image_array($tmpImageAr, $imagepath);
			}

			if($elem['tp']=='barcode'){
				$position = '';

				if(gettype($value)=="array"){
					$code  = $value['value'];
					$type  = $value['barcodeType'];
					$text  = (isset($value['text'])) ? $value['text'] : true; 
					$label = (isset($value['label'])) ? $value['label'] : ''; 
					$hpadding = (isset($value['hpadding']))	? $value['hpadding'] : 'auto'; 
					$vpadding = (isset($value['vpadding']))	? $value['vpadding'] : 'auto';
					$fontsize = (isset($value['fontsize'])) ? $value['fontsize'] : $p87_00['font_size'];
					$orientation = $value['orientation'];
					$position 	 = (isset($value['position'])) ? $value['position'] : $position;

				}elseif (gettype($value)=="string"  || gettype($value)=="integer" || gettype($value)=="double" ){
					$code = $value;
				}
				
				list($row, $col, $row0, $col0) = $this->get_elem_position($elem['pos'], $elem['row'], $elem['col'], $elem['row0'], $elem['col0']);
				
				$tmpBarCodeAr = array(
					'position' 	   => $position,
					'grami'        => $row,
					'stili'        => $col,
					'grami0'       => $row0,
					'stili0'       => $col0,
					'upi'          => $value_upi,
					'elemsize'     => $elem['size'],
					'align'        => $align,
					'type'         => $type,
					'orientation'  => $orientation,
					'text'         => $text,
					'label'        => $label,
					'hpadding'     => $hpadding,
					'vpadding'     => $vpadding,
					'pos'          => $elem['pos'],
					'font'		   => $p87_00['font'],
					'fontsize'     => $fontsize,
				);
	
				$tmpRes = $this->peg_print_barcode_array($tmpBarCodeAr, $code);
				if($getOnlyHeight==false){
				}
				
			}



			//Epanaferw to default theme
			if($p87_nr01>0){
				$this->setFont($this->p87['font'], '', $this->p87['font_size']); 				
				$this->setFillColor(hexdec(substr($this->p87['fill_color'], 0, 2)), hexdec(substr($this->p87['fill_color'], 2, 2)), hexdec(substr($this->p87['fill_color'], 4, 2)));
				$this->setDrawColor(hexdec(substr($this->p87['draw_color'], 0, 2)), hexdec(substr($this->p87['draw_color'], 2, 2)), hexdec(substr($this->p87['draw_color'], 4, 2)));
				$this->setTextColor(hexdec(substr($this->p87['font_color'], 0, 2)), hexdec(substr($this->p87['font_color'], 2, 2)), hexdec(substr($this->p87['font_color'], 4, 2)));
				if($this->p87['fill']==1){
					$fill = true;
				}else{
					$fill = false;
				}
				$border = $this->p87['border']; 
			}

			if($getOnlyHeight==true){
				return $tmpRes;	
			}
		}

		public function get_elem_position($pos, $row=0, $col=0, $row0=0, $col0=0){
			
    		switch ($pos) {
    			case 1:
    				/*  echo "<br/>1= $this->offset_y +$row ;";   */
    				$row  = $this->offset_y + $row;
    				$col  = $this->offset_x + $col;
    				$row0 = $this->offset_y + $row0;
    				$col0 = $this->offset_x + $col0;
					//echo "<br/>case 1 = $row, $row0";
    				break;

    			case 2:
    				break;

    			case 3:
    				/* 	echo "<br/>3= $this->offset_y+$row + $this->max_head_row + $this->bodyheight ;"; 
    				flush();
    				die(); */
					
					$body_offset = $this->max_head_row + $this->bodyheight;
					if($this->printHeaderOnce==true){
						$body_offset = 0;
						if($this->peg_tmp_lastPageStart!=$this->getPage()){
							$this->offset_y = -($row - $this->getTCPDFLastRow());
						}
					}
    				$row  = $this->offset_y + $row  + $body_offset;
    				$row0 = $this->offset_y + $row0 + $body_offset;					
    				$col  = $this->offset_x + $col;
    				$col0 = $this->offset_x + $col0;
    				break;
    			default:
    				die("Underfinted position $pos");
    			break;
    		}
    	
    		if($row0<$row){
    			$row0 = 0;
    		}
    		if($col0<$col){
    			$col0 = 0;
    		} 
    		return array($row, $col, $row0, $col0);
    	}
    	
		protected function setHeader(){
			if($this->p85_classType==2 && $this->printHeaderOnce==true){
				$this->printBackgroundImage();
			}
			
			parent::setHeader();
		}

		public function Header(){
			if($this->p85_classType==2){
				
				if($this->printHeaderOnce==false){
					$this->printBackgroundImage();
				}

				// // Set Example Header
				// $this->Cell(0, 10, '<< TCPDF Example 003 >>', 0, 1, 'C', 0, '', 0, false, 'M', 'M');
				// $this->Cell(0, 10, '<< TCPDF Example 003 >>', 0, 1, 'C', 0, '', 0, false, 'M', 'M');
				// return;
				
				$this->setCellPaddings($this->initialCellPaddings['L'], 0, $this->initialCellPaddings['R'], 0);

				$headers_query = "select * from p86 where p85=:p85_nr01 and pos=1 order by p86.tax, p86.row, p86.col;";
				$headers_res   = pegasus_query($headers_query, array('p85_nr01' => $this->p85_nr01));
				$headers_data  = pegasus_fetchall($headers_res);

				foreach ($headers_data as $elem){
					$this->p86_data_to_pdf($elem);
				}
			}
		}
    	
    	
    	public function Footer(){ 
			
			if($this->p85_classType==2){
			
				// Set Example Footer				
				// $this->Cell(0, 0, 'Page '.$this->getAliasNumPage().'/'.$this->getAliasNbPages(), 'T', 0);
				// return;

				$this->SetY(($this->_getTCPDFHeight(0, $this->bottom_margin) + $this->GetFooterMargin())*(-1));
				$this->setCellPaddings($this->initialCellPaddings['L'], 0, $this->initialCellPaddings['R'], 0);

				$footer_query  = "select * from p86 where p85=:p85_nr01 and pos=3 order by p86.tax, p86.row, p86.col;";
				$footer_res    = pegasus_query($footer_query, array('p85_nr01' => $this->p85_nr01));
				$footer_data   = pegasus_fetchall($footer_res);
				foreach ($footer_data as $elem){
					$this->p86_data_to_pdf($elem);
				}
				return;
			}

    	    if($this->width < 85 && $this->printHeaderOnce == true){
    
    	        if($this->peg_tmp_lastPosition == 3){
    				//parent::Footer();
    				//$this->offset_y+$row + $this->max_head_row + $this->bodyheight
    	            $tmp_grammi = $this->offset_y + $this->lastRow + 2 + $this->max_head_row + $this->bodyheight;
    	            $footer_y = $this->_getTCPDFYFromGrammi( $this->offset_y + $this->lastRow + 2 + $this->max_head_row + $this->bodyheight);
    	            
					$this->setTextColorArray($this->footer_text_color);
					if($this->dataDourceP50 != 'a55' && $this->dataDourceP50 != 't08' ){
						$this->peg_print_line($tmp_grammi , 0 , $tmp_grammi ,  ($this->stiles- $this->right_margin - $this->left_margin)   );
					}
    	            if ($this->getRTL()) {
    	                $this->setXY($this->original_rMargin-1, $footer_y);
    	                
    	                if($this->dataDourceP50 != 'a55' && $this->dataDourceP50 != 't08' ){
							$this->Cell(0, 0,"Powered by Pegasus Technology ©", 0, 0, 'R');
						}
    	                
    	            } else {
    	                $this->setXY($this->original_lMargin +1, $footer_y);
    	                
    	               
    	                if($this->dataDourceP50 != 'a55'  && $this->dataDourceP50 != 't08'){
							$this->Cell(0, 0, "Powered by Pegasus Technology ©" , 0, 0, 'L');
						}
    	               
    	            }
    	             
    	        }
    	        return "";
    	    }
    	    if(
    	        $this->dataDourceP50 != 'a55' &&
				$this->dataDourceP50 != 'a56' &&
    	        $this->dataDourceP50 != 'courier05_00' &&
    	        $this->dataDourceP50 != 'r18' &&
    	        $this->vdisft == false){
    			parent::Footer();
    			
    // 			
    			
    			if (!$this->getRTL()) {
    				$this->SetX(($this->original_rMargin + 1));
    				$this->Cell(0, 0, "Powered by Pegasus Technology ©" , 0, 0, 'L');
    				
    			} else {
    				$this->SetX(($this->original_lMargin - 1));
    				$this->Cell(0, 0,"Powered by Pegasus Technology ©", 0, 0, 'R');
    				
    			}
    			/* if($this->prnttime){
    				$printTimeStamp = $_SESSION['peg_dic_core_print'] . date('d/m/Y h:i' , strtotime("now"));
    				$this->Cell( 0, 0,$printTimeStamp, 0, 0, 'C');
    				
    			} */
    		}
    	}
    	
    
    	/**
    	 * H sunartisi epistrefei true oso uparxoyn dedomena pou den ektypwthei sto body 
    	 * @param int $body_rows
    	 * @param int $body_rows_i
    	 * @return boolean
    	 */
    	public function hasMoreRows($body_rows, $body_rows_i = 0){  //body_rows_i not used
    		//XXX Den Xriazete h isotita metraei apo to 0 .
    	    return ($body_rows > $this->body_rows_i  );
    	}
    	/**
    	 * H synartisi epistrefei true oso xwrane eggrafes sto body.
    	 * Episeis epiraszete apo thn metavliti 
    	 * @param float $i
    	 * @param float $bodyheight
    	 * @return boolean
    	 * @see this->bodyBreak
    	 */
    	public function hasMoreSpace($i, $bodyheight = 0){//bodyheight not used
    		if($this->bodyBreak == true){ 
    			$this->bodyBreak = false; 
    			return false;
    		}
    		//echo  ($i<$this->bodyheight);
    		
    		
    // 		if( ($i >=  ($this->grammes - $this->top_margin - $this->bottom_margin )) ){
    // 		    return false;
    // 		}
    		    
    		return ( $i  <$this->bodyheight) ;
    	} 
    	
    	/**
    	 * Epistefei poio dedomeno (to i dedomeno) exw ektypwsei
    	 * @return number
    	 */
    	public function get_body_rows_i(){
    		return $this->body_rows_i;
    	}
    	
    	public function set_vdisft($var = FALSE){
    		if(gettype($var) == "boolean"){
    			$this->vdisft = $var ;
    		}
    	}
    	
    	public function setGrammiStili($stili,$grammi){
    	    $x_tmp = $this->_getTCPDFXFromStili($stili);
    	    $y_tmp = $this->_getTCPDFYFromGrammi($grammi);
    	    
    	    return $this->setXY($x_tmp, $y_tmp);
    	}
    	/**
    	 * Aujani ton metriti twn dedomenvn einai methodos giati den thelw na pirazete mesa apo thn forma
    	 */
    	public function addBodyRow(){
    		if($this->triggerAddBodyRow ){
    			$this->body_rows_i++;
    			$this->set_triggerAddBodyRow(false);
    		}
    	}

		public function removeBodyRow(){
    		if($this->triggerAddBodyRow){
    			$this->body_rows_i--;
    			$this->set_triggerAddBodyRow(false);
    		}
    	}

    	/**
    	 * Aujani ton metriti twn dedomenvn einai methodos to tcpdf paizei swsta
    	 */
    	public function addBodyI(){
    // 		$ttt = false;
			$this->peg_max_body_elem_height = 0;
    		$tmp_var=0;
    		$tmp_var_plush =0;
    		if(count($this->body_row_i_data['elem'])>0 ){
    // 		    var_dump(debug_backtrace());
    		    
    			//edw mpenei mono ean sthn prohgoumeni selida emine sto cash
    			//Efoson to position exw apo to cash
    			//den thelw sto update na mou kanei minus grammes
    			$this->peg_tmp_lastPosition = 2;
    			//pernei to hrader afou einai prwto element
    			$this->offset_y = $this->custom_offset_y;
    			
    			$this->updMinusTrigger = true;
    			$this->lastRow = 0;
				
				//Comment to fix row Break
    			//$this->updateMaxHeaderRow();
				/* TesaeDev Edit-Comment */
				// if( ($this->body_row_i_data['rowstart'] +1 )> ($this->max_head_row)){ 
				// 	/* echo "Before The disanse: " .($this->max_head_row -$this->body_row_i_data['rowstart'])."<br/>";
				// 	echo "Before1  The disanse: (" .$this->max_head_row ."-".$this->body_row_i_data['rowstart'].")<br/>";   */
				// 	$this->_updateBodyElement(($this->offset_y + $this->max_head_row - $this->body_row_i_data['rowstart'] +1 ));
				// 	/* die(print_r($this->body_row_i_data, true)); */					
				// }
    			if( ($this->body_row_i_data['rowstart'])> ($this->max_head_row)){ 
    			    $this->_updateBodyElement(($this->offset_y + $this->max_head_row - $this->body_row_i_data['rowstart']));    				
    			}
				
    			// 
    			$this->peg_tmp_last_bodyrow=$this->body_row_i_data['rowstart'];
    			
    			$this->flushBodyI();
    			
    // 			$this->peg_tmp_last_bodyrow = $this->getTCPDFLastRow();
    			 
    			$this->updMinusTrigger = false;
    			$this->set_triggerAddBodyRow(true);
    			if($this->bodyBreak === true){
    				return 1;
    			}
    			//Gia na diorthwsw to minus grammes toy body				
				/* TesaeDev Edit-Comment */
    			//$tmp_var_plush = 1;
    		} 
    		
    		// if($this->peg_tmp_last_bodyrow){
    			$tmp_var += $this->_getHeight($this->peg_tmp_last_bodyrow, $this->peg_tmp_last_body_current_row );
    		// }
    		
    		if($tmp_var<1){
    			$tmp_var = 	1;
    		}
    		$this->body_row_i_data             = array();
    		$this->body_row_i_data['elem']     = array();
    		$this->body_row_i_data['rowstart'] = NULL;
    		$this->body_row_i_data['rowend']   = NULL;
			
    		return $tmp_var + $tmp_var_plush;
    	}
    	
    	private function _bodyBreakeEmptySpace(){
    		if($this->printHeaderOnce==false){
    			//TODO 001 Ayth h synthiki na paei se private method
    //  			echo "		( " . $this->max_head_row . "+ " .$this->bodyheight .") <= ". $this->body_row_i_data['rowend'] ." <br/>";
     			
    			if(
    			    ($this->max_head_row+$this->bodyheight + $this->custom_offset_y) <= 
    			    ($this->body_row_i_data['rowend'] +1) and $this->body_tmp_i != 0 
    			){
    
    				//echo " 				" . print_r($this->body_row_i_data, true) ."<br/><br/>";
    				//$this->_updateBodyElement(($this->max_head_row - $this->body_row_i_data['rowstart']  ));
    				//$this->_updateBodyElement(-$this->body_tmp_i);
    // 				 echo "here<br/>"; 
    		
    				$this->bodyBreak = true;
    				return true;
    				
    			}
    // 			if(($this->body_row_i_data['rowend'] +1) >=  ($this->grammes - $this->top_margin - $this->bottom_margin) ){
    // 			    //Ean paei na ektypwsei ektos PDF
    // 			    $this->bodyBreak = true;
    // 			    return true;
    // 			}
    		}
    		return false;
    	}
    	
    	/**
    	 * Ayth h methodos kaleite mono apo to while ths (print_to_pdf00.php) kai thn addBodyI
    	 * Ayto simvenei gt mono tote theloume na ekteleite h addBodyRow() wste
    	 * otan ena body row exei update i epoudeni na mhn min moy ayjanei to body_row_i
    	 */
    	public function flushBodyI(){
    // 	    var_dump($this->_bodyBreakeEmptySpace());
    		if($this->_bodyBreakeEmptySpace()){
    			return;
    		}
    // 		echo $this->triggerAddBodyRow ;
    		$this->addBodyRow();
    // 		echo $this->triggerAddBodyRow ."<br/><br/><br/>";
    		$this->_flushBodyI();
    	}
    	
     	private function _flushBodyI(){ 
     		if($this->_bodyBreakeEmptySpace()){ 
    			return;
    		}/*
     		else{
     			//Sthn ektipwsi se lista
     			
     			$res_tmp = $this->checkPageBreak($ttt, '', true);
     			
     		}*/
     		$fontAr =  array('family' => $this->FontFamily, 'style' => $this->FontStyle, 'sizept' => $this->FontSizePt);
     		
     		
    //  		 echo "<br/><br/>#######<br/>";
    //  		echo var_export($this->body_row_i_data,true) . "<br/><br/>";  
     		
     		
    //  		if($this->printHeaderOnce and
    //  		    (
    //  		        ($this->grammes - $this->top_margin - $this->bottom_margin) <=
    //  		        ($this->body_row_i_data['rowend']  )
    //  		        )
     		    
    //  		    and $this->body_tmp_i != 0
    //  		    ){ 
     		        
    // //  		        $this->_updateBodyElement( -1 * $this->body_row_i_data['rowend']  ); 
    //  		        return;
    //  		}
     		//XXX prepei na einai true gia na pernaei toys elegxous kai na ektypwneo
     		$this->bodyFlush = true;
     		//XXX Thelw na einai diktis se element gt to element tropopoieite apo th sinarthsh _updateBodyElement
     		foreach ($this->body_row_i_data['elem'] as &$elem){
				$tmpRes = array();
    // 		for ($i = 0; $i < count($this->body_row_i_data['elem']); $i++) {
     			if($this->printHeaderOnce){ 
     			    $current_page = $this->page;
     				$tmpheighttt = $this->_getRowFromY($this->y);
     			}
     			
     			
     			    
    //  			$elem = &$this->body_row_i_data['elem'][$i];
     			
     			
    //  		echo "<br>#################<br>";
    //  				echo $elem['fname'] . "<br/>";
    //  				echo "	Font: " . $elem['font']['family']. $elem['font']['style'].$elem['font']['sizept'] . "<br/>";
    //  				echo "	args: " . print_r($elem['args'] , true);
    //  			echo "<br>#################<br>";  
     			
     			$this->setFont($elem['font']['family'], $elem['font']['style'],$elem['font']['sizept']);
     			
     			
     			$this->setFillColor($elem['fillColorAr']['col1'], $elem['fillColorAr']['col2'], $elem['fillColorAr']['col3'], 
     					$elem['fillColorAr']['col4'],  $elem['fillColorAr']['ret'], $elem['fillColorAr']['name']);
     			$this->setDrawColor( $elem['drawColorAr']['col1'], $elem['drawColorAr']['col2'], $elem['drawColorAr']['col3'],
     					$elem['drawColorAr']['col4'], $elem['drawColorAr']['ret'], $elem['drawColorAr']['name']);
     			$this->setTextColor( $elem['textColorAr']['col1'], $elem['textColorAr']['col2'], $elem['textColorAr']['col3'],
     					$elem['textColorAr']['col4'], $elem['textColorAr']['ret'], $elem['textColorAr']['name']);
     			
     			
						
						
     			switch ($elem['fname']) {
     				case 'peg_print_line':
     					
     					$this->peg_print_line(
     						$elem['args']['grami_top'], 
     						$elem['args']['stili_top'], 
     						$elem['args']['grami_bottom'], 
     						$elem['args']['stili_bottom']
     					);
     					break;
     				case 'peg_print_text':
     					$this->peg_print_text(
     						$elem['args']['grami'], 
     						$elem['args']['stili'],
     						$elem['args']['text']
     					);
     					break;
     				default:
     					$elem['args']['grami0'] = $this->body_row_i_data['rowend'];
    //  					echo $elem['fname']."<br/>";
    //  					print_r($elem['args']['param']);
     					if( method_exists($this,$f=$elem['fname']) ){
							$tmpRes = $this->{$f}($elem['args']['param'], $elem['args']['text']);
     					}
     					break;
     			}
     			if($this->printHeaderOnce and $current_page != $this->page){
    //  			    echo 'from y = ' . $this->_getRowFromY($this->y) . ' rowstart ' .  $this->body_row_i_data['rowstart'] . "<br/>";

					/* TesaeDev Edit-Comment */
					$rows = $this->_getRowFromY($this->y) - $this->body_row_i_data['rowstart'];
					
					if($elem['upi']!=1 && $elem['fname']=='peg_print_memo_array'){
						$rows -= $tmpRes['height'];
					}
     			    $this->_updateBodyElement($rows);
     			}
     		
    
     		}
    //  		echo "<br>#################<br>";
    //  		print_r( $this->body_row_i_data);
    //  		echo "<br>#################<br>";
    //  		echo "rec ". $this->body_row_i_data['rowend']." <br/> "; 
     		//XXX sto telos prepei na einai panta false
     		$this->bodyFlush = false;
    //  		if($this->printHeaderOnce){
    //  		    $this->peg_tmp_last_body_current_row = $this->_getRowFromY($this->y);
    //  		}else{
    
    //  		}
     		$this->peg_tmp_last_body_current_row = $this->body_row_i_data['rowend'];
     		
    //  		$this->peg_tmp_last_bodyrow			 = $this->body_row_i_data['rowstart'];
     		$this->body_row_i_data['rowstart'] = NULL;
     		$this->body_row_i_data['rowend'] = NULL; 
     		$this->body_row_i_data['elem'] = array();
     		
     		$this->setFont($fontAr['family'], $fontAr['style'],$fontAr['sizept']);
     		return ;
     	}
     	
    	
    	/**
    	 * Arxikopoiei ta rows
    	 * @param enum{1=> header,2 => body,3 => footer} $pos
    	 * @param number $row grammi apo
    	 * @param number $col stili apo
    	 * @param number $row0 grammi eos
    	 * @param number $col0 stili eos
    	 * @param number $i metavliti gia thn thesi ths kathe grammis sto body
    	 * @return array($row,$col,$row0,$col0 )
    	 */
    	public function peg_get_position($pos , $row = 0, $col= 0, $row0= 0,$col0= 0, $i = 0){
			
    		$this->body_tmp_i = 0;
    		if($pos != $this->peg_tmp_lastPosition){
    // 		    echo $pos . "<br/>";
    			if($pos==2){
    				$this->updateMaxHeaderRow();
    // 				print( $this->getTCPDFLastRow() . '<>' .$this->max_head_row . "<br/>" . $this->custom_offset_y  . "<br/>");
    			}
    		 
    			    //Morei se mia dorma na exw 2 header
    			    //Old Den exw thema gia to header giati to arxikopoio me header ston constuctor
        			$this->updMinusTrigger = true;
    	       		$this->lastRow = 0;
    		     
    			$this->peg_tmp_lastPosition = $pos;
    			$this->offset_y=$this->custom_offset_y;
    			/* die(var_export($this)); */
    		}
    		if($this->peg_tmp_lastPosition==2){
    			$this->_updMinusGrammes($i);
    		}else{
    			$this->_updMinusGrammes();
    		}

			/* TesaeDev Edit-Comment */
			$newRow = false;
			$newRowHeight = 0;
			if($this->lastRow<$row){
				$newRow = true;
				$newRowHeight = $this->_getHeight($this->lastRow, $row);
			}

    		$this->lastRow = $row;
			
			$row  = $row - $this->minusGrammes;
			$row0 = $row0 - $this->minusGrammes; 
			
    		switch ($pos) {
    			case 1:
    				/*  echo "<br/>1= $this->offset_y +$row ;";   */
    				$row  = $this->offset_y + $row;
    				$col  = $this->offset_x + $col;
    				$row0 = $this->offset_y + $row0;
    				$col0 = $this->offset_x + $col0;
    				break;

    			case 2:
    				//echo "<br/>2= $this->offset_y + $row + $i + $this->max_head_row;	";
    				$this->body_tmp_i = $i;
    				// $row  = $this->offset_y+$row+$i+$this->max_head_row;
    				// $col  = $this->offset_x+$col;
    				// $row0 = $this->offset_y+$row0+$i+$this->max_head_row;
    				// $col0 = $this->offset_x+$col0;
					/* TesaeDev Edit-Comment */
					if($this->peg_max_body_elem_height>0 && $newRow==true && $this->p85_callMethod=='function'){
						$this->offset_y += $this->peg_max_body_elem_height - $newRowHeight - $this->peg_tmp_lasth;
					}
					
					$row  = $this->offset_y+$row+$i+$this->max_head_row;
					$row0 = $this->offset_y+$row0+$i+$this->max_head_row;					
    				$col  = $this->offset_x+$col;
    				$col0 = $this->offset_x+$col0;
    				break;

    			case 3:
    				/* 	echo "<br/>3= $this->offset_y+$row + $this->max_head_row + $this->bodyheight ;"; 
    				flush();
    				die(); */
					
    				$row  = $this->offset_y + $row + $this->max_head_row + $this->bodyheight;
    				$col  = $this->offset_x + $col;
    				$row0 = $this->offset_y + $row0 + $this->max_head_row +  $this->bodyheight;
    				$col0 = $this->offset_x + $col0;
    				break;
    			default:
    				die("Underfinted position $pos");
    			break;
    		}
    	
    		if($row0<$row){
    			$row0 = 0;
    		}
    		if($col0<$col){
    			$col0 = 0;
    		}
    // 		if($row >=  ($this->grammes - $this->top_margin - $this->bottom_margin) ){
    // 		echo "<br/>"."--> " .$row ." vs ".$this->grammes  ."=".($this->grammes-$row)."<br/>";
    // 			echo "<br/>"."--> " . $this->offset_y."+".$row."+".$i."+".$this->max_head_row ."<br/>";
    // 		}
    		//echo $row ." , ".$col." , ".$row0." , ".$col0 . "<br/>";
    		return array($row,$col,$row0,$col0 );
    	}
    	
    	
    	/**
    	 * Ektiponimia grammi
    	 * @param float $grami_top (apo poia grammi tha jekinisei ba tupwnei)
    	 * @param float $stili_top (apo poia stili tha jekinisei ba tupwnei)
    	 * @param float $grami_bottom (eos poia grammi tha tupwnei)
    	 * @param float $stili_bottom (eos poia stli tha tupwnei)
    	 * @param float $width (poio tha einai to fardos ths grammis)
    	 */
    	public function peg_print_line($grami_top, $stili_top, $grami_bottom, $stili_bottom, $width=0, $pos=0){
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$this->_pushBodyElement(array(
    					'fname'		=> 'peg_print_line',
    					'rowstart'	=>$grami_top,
    					'args'	=> array(
    							'grami_top' => $grami_top,
    							'stili_top' => $stili_top,
    							'grami_bottom' => $grami_bottom,
    							'stili_bottom' => $stili_bottom,
    							'width' => $width
    					)
    			));
    			return ;
    		}
    		
    		$this->peg_tmp_lastPrintType = 'line';
    		if(!empty($width)){
    			$lineWidthTmp = $this->LineWidth;
    			$this->setLineWidth($width);
    				
    		}
    		if($stili_bottom > ($this->stiles-$this->right_margin) ){
    			$stili_bottom = ($this->stiles-$this->right_margin);
    		}
    		
    		$y_top_tmp    = $this->_getTCPDFYFromGrammi($grami_top);
    		$y_bottom_tmp = $this->_getTCPDFYFromGrammi($grami_bottom);
    		$x_top_tmp    = $this->_getTCPDFXFromStili($stili_top);
    		$x_bottom_tmp = $this->_getTCPDFXFromStili($stili_bottom);

			if($this->p85_classType==2){
				if($pos==1 or $pos==3){				
					$y_top_tmp    = $this->_getTCPDFYFromGrammi($grami_top,false) + $this->getHeaderMargin();
					$y_bottom_tmp = $this->_getTCPDFYFromGrammi($grami_bottom,false) + $this->getHeaderMargin();
				}
			}

			$this->peg_tmp_lastPageStart = $this->getPage();
    		
    		$this->Line($x_top_tmp, $y_top_tmp, $x_bottom_tmp, $y_bottom_tmp);

    		if(!empty($width)){
    			$this->setLineWidth($lineWidthTmp);
    		}
    	}
    	
    	/**
    	 * Ektyponei ena keimeno miaw grammis 
    	 * 2del @see peg_print_cell
    	 * @param float $grami se poia grammi
    	 * @param float $stili se poia stili
    	 * @param string $text
    	 */
    	public function peg_print_text($grami , $stili  , $text){
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_text',
    					'rowstart'	=>$grami,
    					'args'	=> array(
    							'grami' => $grami,
    							'stili' => $stili,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		if(empty($text)){
    			return ;
    		}
    	
    		if(pegasus_lock_check_app()==1){
    			$text = '.' . substr($text ,1);
    		}
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
    		$this->text($x_tmp  , $y_tmp , $text);
    	
    	}
    
    	/**
    	 *  Ektypvnei ena keli
    	 * @param array(
    	 * 	grami
    	 *  stili
    	 *  grami0
    	 *  stili0
    	 *  border
    	 *  size
    	 *  align
    	 *  fill
    	 *  url
    	 * ) $param
    	 * @param string $text
    	 */
    	public function peg_print_cell($param = array(), $text){
    		$this->peg_tmp_lastPrintType = 'exp';
    		
    
    		$width	= 0;
    		$height = 0;
    		$heightRet = 1;
    		
    		// $grami , $stili  , $text ,  $border=0 , $size=0 , $align='L' , $fill=false, $url='' 
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		
    		
    		$grami0	= (!empty( $param['grami0']))?$param['grami0'] : 0;
    		$stili0	= (!empty( $param['stili0']))?$param['stili0'] : 0;
    		
    		$border	 	 = (!empty($param['border']))		?	$param['border'] 		: '';
    		$size	 	 = (!empty($param['size']))			?	$param['size'] 			: 0;
    		$align 	 	 = (!empty($param['align']))		?	$param['align'] 		: 'L';
    		$fill	 	 = (!empty($param['fill']))			?	$param['fill'] 			: false;
			$url	 	 = (!empty($param['url']))			?	$param['url'] 			: '';
			$stretch     = (!empty($param['stretch']))		?	$param['stretch'] 		: 0;
			$auto_sizing = (isset($param['auto_sizing'])) 	? 	$param['auto_sizing'] 	: false;
			$rotate      = (isset($param['rotate']))		? 	$param['rotate']		: 0;
			$upi	 	 = (isset($param['upi']) and $param['upi']===true)?$param['upi'] : false;

    		if($size>0){
    			$width = $this->s_width*$size;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
    		}
    		if($grami0>0){
    			$height = $this->_getTCPDFHeight($grami, $grami0);
			}
			/* TesaeDev Edit-Comment */
			$heightRet = $this->_getHeight($grami, $grami0, true);

			$text_width = $this->GetStringWidth($text);
			if($auto_sizing===true){
				while($text_width>($width-$this->s_width)){
					$text = peg_substr($text, 0, -1);
					$text_width = $this->GetStringWidth($text);
				}
			}

    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			if($rowEndTmp==0 || $rowEndTmp == $grami ){
    				$rowEndTmp = ($grami + $this->_getNumOfRowsFromTCPDFHeight($this->getCellHeight($this->FontSize)) );
    			}
    			
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_cell',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		
    		
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			if($this->p85_classType==2){
				if($param['pos']==1 or $param['pos']==3){
					$y_tmp = $this->_getTCPDFYFromGrammi($grami,false) + $this->getHeaderMargin();	
				}
			}
    		
    // 		 $text = "'". round($this->peg_tmp_last_bodyrow )."'--"  .$this->max_head_row ."--"
    // 		 . $text;  
			$this->setXY($x_tmp  ,   $y_tmp);
			
			// $x_start = $this->GetX();
			// $y_start = $this->GetY();
			$page_start = $this->getPage();
			$this->peg_tmp_lastPageStart = $page_start;

			if($rotate>0){
				$this->StartTransform();
				$this->Rotate($rotate);
				//$border=1;
			}
			
			$this->Cell($width, $height, $text, $border, 0, $align, $fill, $url, $stretch);	

			if($rotate>0){
				$this->StopTransform();	
			}
					
			// $x_end = $this->GetX();
			// $y_end = $this->GetY();   	
			$page_end = $this->getPage();
			$this->_push_textElementsArray( array( 
												'pegasus_grammi_start' => $grami,
												'pegasus_stili_start' => $stili,
												'text' => $text,
												'returned_nl' => 1,
												'page_start'  => $page_start,
												'returnHeight' => $heightRet,
												'fname' => 'peg_print_cell',

												/*,'x_start' => $x_start,
												'y_start' => $y_start,
												'x_end' => $x_end,
												'y_end' => $y_end,
												'pegasus_width' => $width,
												'pegasus_height' => $height,
												'fname' => 'peg_print_cell',
												'page_end'  => $page_end,
												'peg_tmp_lastPosition' => $this->peg_tmp_lastPosition,
												'align' => $param['align'],
												'letter_widths' => $this-> GetStringWidth($text, '', '', 0, true),
												'stringWidth' => $this->GetStringWidth($text),
												'extra_vars_for_debug' =>
												 array( 'rowstart'	=> $grami,
														'upi'		=> $upi,
														'param'	=>$param
														)*/
												)
												);
    		return array('height' => $heightRet);
    	
    	}
    	
    	/**
    	 * Ektipwnei ena memo se polles grammes.
    	 * To plithos twn grammwn einai grami0 - grami
    	 * To megethos einai elemsize h stili0 -stili
    	 * @param  array() $param array(
    			 'grami' => $grami,
    			 'stili' => $stili,
    			 'grami0' => $grami0,
    			 'stili0' => $stili0,
    			 'elemsize' => $elemsize,
    			 'synLineHeight' =>me ti tha polaplasiastei to line height
    		 )
    	 * @param string $text
    	 */
    	public function peg_print_memo_array($param = array(), $text, $getOnlyHeight=false){
			
    		$this->peg_tmp_lastPrintType = 'exp_memo';
    		$width		= 0;
    		$height		= 0;
    		$maxHeight	= 0;
    		$this->url ="";
    		$grami	= $param['grami'] ; 
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;

    		$border	= (!empty( $param['border']))?$param['border'] : '';
    		$align	= (!empty( $param['align']))?$param['align'] : 'L';
    		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
    		$url	= (!empty( $param['url']))?$param['url'] : '';
    		$upi		= (isset($param['upi']) and $param['upi']===true)?$param['upi'] : false;
			if( !empty( $param['valign']) and 
				((strtoupper($param['valign'])=='T' || strtoupper($param['valign'])=='B' || strtoupper($param['valign'])=='M')) 
			  ){
				$valign	= strtoupper($param['valign']);
			}
			else{
				$valign	= 'T';
			}
			$ln	= (isset($param['ln'])) ? $param['ln'] : '2';
			
    		//die($valign);
    		//$valign = 'B';
    		/* T: TOP
    		M: middle
    		B: bottom */
    		
    		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] :0;
    		$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
    		
    		
    		if($elemsize>0){
    			$width = $this->s_width*$elemsize;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
			}
			
			if($grami0>0){
    			$height = $this->_getTCPDFHeight($grami, $grami0);
    			//$text.=$this->g_height; 
    			//$heightRet = $grami0 - $grami;
    			if($valign=='B' || $valign=='M' || $valign=='T'){ //20200911: Δεν είχαμε το  $valign=='T' και δεν δούλευε το maxHeight
					$maxHeight	= $height;
					//echo "\nmaxHeight: ". $maxHeight;
    			}
			}
			//  if(!($grami0>0)){				
			// 	$rowEndTmp   = $this->getMultiCellHeight($width, $height, $text, $border,$align, $fill, 1, '' , '',true,0, false,true,$maxHeight, $valign);
			// 	$grami0      = $this->_getNumOfRowsFromTCPDFHeigΟht($height) +$grami;

			//  }
			// 	//$height = $this->getStringHeight($width, $text);
			// 	 $height00 = /*$this->g_height**/ $this->getMultiCellHeight($width, $height, $text, $border,$align, $fill, 1,'' , '',true,0, false,true,$maxHeight, $valign) ;
			//	$height01 = /*$this->g_height**/ $this->getStringHeight($width, $text);
			// 	 $grami0 = ($this->_getNumOfRowsFromTCPDFHeight($height00) +$grami);
			// 	// //$grami0 = $height00 + $grami;
			// 		// echo '<pre>x_tmp:'    . $x_tmp  . '</pre>';
			// 		// echo '<pre>y_tmp:'   . $y_tmp . '</pre>';
			// 	if($_REQUEST['debug']==1 and $this->peg_tmp_lastPosition==2 ){
			// 		echo '<pre>=======culculate grammi0 in peg_print_memo_array===============</pre>';
			// 		echo '<pre>text:'     . $text   . '</pre>';
			// 		echo '<pre>height:'   . $height . '</pre>';
			// 		echo '<pre>getMultiCellHeight:' . $height00 . '</pre>';
			// 		echo '<pre>getStringHeight:'    . $height01 . '</pre>';
			// 		echo '<pre>g_height:' . $this->g_height . '</pre>';
			// 		echo '<pre>h:'        . $this->h . '</pre>';
			// 		echo '<pre>grammesh:' . $this->grammes . '</pre>';
					
			// 	}
			// }

			// // Aν η γραμη ειναι μεγαλυτερη απο τις γραμμες τις σελιδας , εχει σεταριστει το onOverflowChangePage true και δεν ειναι στο body.
			// if($grami0+$this->bottom_margin  >= $this->grammes and $onOverflowChangePage and $this->peg_tmp_lastPosition!=2){
			// 	$this->addPage();
			// 	return array('height' => 0 , 'print_again' => true);
			// }

			if($getOnlyHeight==true){
				$rowEndTmp = $grami0;
				$heightTmp = $height;
    			if($rowEndTmp==0){
					$heightTmp = $this->getMultiCellHeight($width, $height, $text, $border,$align, $fill, 1, '' , '',true,0, false,true,$maxHeight, $valign);
					$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($heightTmp) + $grami);
				}	
				return array('height'=>$heightTmp, 'row'=>$grami, 'row0'=>$rowEndTmp);	
			}

    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			if($rowEndTmp==0){
					$rowEndTmp   = ($this->_getNumOfRowsFromTCPDFHeight($this->getMultiCellHeight($width, $height, $text, $border,$align, $fill, 1, '' , '',true,0, false,true,$maxHeight, $valign)) +$grami);
				}
				
				// 	$rowEndTmp00 = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
				// 					// //$grami0 = $height00 + $grami;
				// 	if($_REQUEST['debug']==1){
				// 		echo '<pre>=======culculate rowEndTmp ===============</pre>';
				// 		echo '<pre>rowEndTmp:  ' . $rowEndTmp   . '</pre>';
				// 		echo '<pre>rowEndTmp00:' . $rowEndTmp00 . '</pre>';					
				// 	}
    			// }
    			/* die(print_r($param,true)); */
				
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_memo_array',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
			} 
			$this->tmp_grammes = $grami;
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
			$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			if($this->p85_classType==2){
				if($param['pos']==1 or $param['pos']==3){
					$y_tmp = $this->_getTCPDFYFromGrammi($grami,false) + $this->getHeaderMargin();
				}
			}
			
			// $x_start = $x_tmp;
			// $y_start = $y_tmp;
			$x_start = $this->GetX();
			$y_start = $this->GetY();
			

			$page_start  = $this->getPage();
			$this->peg_tmp_lastPageStart = $page_start;
			
			$returned_nl = $this->MultiCell($width, $height, $text, $border,$align, $fill, $ln, $x_tmp, $y_tmp,true,0,false, true, $maxHeight, $valign);
			
			$x_end = $this->GetX();
			$y_end = $this->GetY(); 

			$page_end = $this->getPage();


    		$this->lastPage();
			$gramiEnd = $this->getTCPDFLastRow();
			//TODO: Να γράψω από που αρχικοποιείται το tmp_grammes
			$returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd, true);
			if($this->p85_classType==2){
				$returnHeight = $this->_getNumOfRowsFromTCPDFHeight($y_end-$y_start);
				if($ln!=0){
					$returnHeight--;
				}
			}
			//echo "<pre>returnHeight= ".$returnHeight . "</pre>";
			
			$this->_push_textElementsArray(
				array( 
					'returned_nl' => $returned_nl,
					'pegasus_grammi_start' => $grami,
					'pegasus_stili_start' => $stili,
					'page_start'  => $page_start,
					'page_end'  => $page_end,
					'text' => $text,
					'pegasus_width' => $width,
					'returnHeight' => $returnHeight,
					'fname' => 'peg_print_cell',
					'letter_widths' => $this-> GetStringWidth($text, '', '', 0, true)

					/*,'x_start' => $x_start,
					'y_start' => $y_start,
					'x_end' => $x_end,
					'y_end' => $y_end,
					'pegasus_height' => $maxHeight,
					'fname' => 'peg_print_memo_array',
					'peg_tmp_lastPosition' => $this->peg_tmp_lastPosition,
					'align' => $param['align'],
					'stringWidth' => $this->GetStringWidth($text),
					'extra_vars_for_debug' =>
					array( 'rowstart'	=> $grami,
						   'upi'		=> $upi,
						   'gramiEnd'	=> $gramiEnd,
						   //'returnHeight' => $returnHeight,
						   'param'	=>$param)*/
				)
			);
    		return array('height' => $returnHeight);
    	
    	}
    	
    	
    	public function peg_print_html_array($param = array(), $text, $getOnlyHeight=false){
			
			$text = $this->peg_formatHtmlText($text);

    		$this->peg_tmp_lastPrintType = 'exp_html';
    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$width = 0;
    		$height =0;
    		
    		$align	= (!empty( $param['align']))?$param['align'] : '';
    		$fill	= (!empty( $param['fill']))?$param['fill'] : false;
    		$border	= (!empty( $param['border']))?$param['border'] : '';
    		$elemsize = (!empty( $param['elemsize']) and $param['elemsize']>0)?$param['elemsize'] :0;
    		$syntelesthsLineHeight = (!empty( $param['synLineHeight']) and $param['synLineHeight']>0)?$param['synLineHeight'] : 1;
    		$upi		= (isset($param['upi']) and $param['upi']===true)?$param['upi'] : false;
    		$ln	= (isset($param['ln'])) ? $param['ln'] : '2';

    		if($elemsize>0){
    			$width = $this->s_width*$elemsize;
    		}elseif ($stili0>0){
    			$width = $this->_getTCPDFWidth($stili, $stili0);
    		}
    		if($grami0>0){
    			$height = $this->_getTCPDFHeight($grami, $grami0);
    			//$text.=$this->g_height;
    			// $heightRet = $grami0 - $grami;
    			// if($valign=='B'){
    			// 	$maxHeight = $height;
    			// }
    		}

			if($getOnlyHeight==true){
				$rowEndTmp = $grami0;
				$heightTmp = $height;
    			if(!($height>0)){
					$heightTmp = $this->getHTMLCellHeight($width, $height, '', '', $text, $border, $ln, $fill, true, $align, true);
					$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($heightTmp) + $grami);
				}	
				return array('height'=>$heightTmp, 'row'=>$grami, 'row0'=>$rowEndTmp);	
			}

    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			if($rowEndTmp==0 ){
    				if(!empty($text)){
						//$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
						$height = $this->getHTMLCellHeight($width, $height, '', '', $text, $border,2, $fill, true, $align, true);
						$rowEndTmp = ( $this->_getNumOfRowsFromTCPDFHeight($height) + $grami );
						
    				}else{ 
    					$rowEndTmp = $grami;
    				}
    			}
    			
    			
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_html_array',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => $text
    					)
    			));
    			return ;
    		}
    		
    	
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			if($this->p85_classType==2){
				if($param['pos']==1 or $param['pos']==3){
					$y_tmp = $this->_getTCPDFYFromGrammi($grami,false) + $this->getHeaderMargin();	
				}
			}
    		
    		$this->setXY($x_tmp, $y_tmp);
    		
    		$this->tmp_grammes = $grami;
			$x_start = $this->GetX();
			$y_start = $this->GetY();


			$page_start  = $this->getPage();
			$this->peg_tmp_lastPageStart = $page_start;

    		$returned_nl = $this->writeHTMLCell($width, $height, $x_tmp, $y_tmp, $text, $border, $ln, $fill, true, $align, true) ;
			$x_end = $this->GetX();
			$y_end = $this->GetY();

			$page_end = $this->getPage();

    		$this->lastPage();
    		$gramiEnd = $this->getTCPDFLastRow(true);
    
    		$returnHeight = $this->_getHeight($this->tmp_grammes, $gramiEnd, true);
			if($this->p85_classType==2){
				$returnHeight = $this->_getNumOfRowsFromTCPDFHeight($y_end-$y_start);
			}


			// echo "<pre>y_start= ". $y_start . "</pre>";
			// echo "<pre>y_end= ". $y_end . "</pre>";
			// echo "<pre>tmp_grammes= ". $this->tmp_grammes . "</pre>";
			// echo "<pre>gramiEnd= ". $gramiEnd . "</pre>";
			// echo "<pre>height= ". ($y_end-$y_start) . "</pre>";
			// echo "<pre>height= ". $this->_getNumOfRowsFromTCPDFHeight($y_end-$y_start) . "</pre>";
			// echo "<pre>returnHeight= ". $returnHeight . "</pre>";
			
			

			$this->_push_textElementsArray( array( 
				'returned_nl' 			=> $returnHeight,
				'pegasus_grammi_start' 	=> $grami,
				'pegasus_stili_start' 	=> $stili,
				'page_start'  			=> $page_start,
				'page_end'  			=> $page_end,
				'text' 					=> $text,
				'pegasus_width' 		=> $width,
				'returnHeight' 			=> $returnHeight,
				'fname' 				=> 'peg_print_html_array',
				'letter_widths' 		=> $this->GetStringWidth($text, '', '', 0, true),
				/*'x_start' => $x_start,
				'y_start' => $y_start,
				'x_end' => $x_end,
				'y_end' => $y_end,
				'pegasus_height' => $height,
				'fname' => 'peg_print_html_array',
				'peg_tmp_lastPosition' => $this->peg_tmp_lastPosition,
				'align' => $param['align'],
				'stringWidth' => $this->GetStringWidth($text),
				'returned_nl' => "-1", //IT IS HTML - No returned nl
				'extra_vars_for_debug' => array(
					'rowstart'	=> $grami,
					'gramiEnd'	=> $gramiEnd,
					'upi'		=> $upi,
					'returnHeight' => $returnHeight,
					'param'	=>$param)*/
				)
			);
			
			
    		return array('height' => $returnHeight);
    	}
    	
    	
    	/**
    	 * H synarthsh ayth ektypvnei mia eikona.
    	 * Ean den exoume orisi grami0, stili0 kai elemsize doyleyei opws douleue
    	 * @param array $param array(
    				 'grami' => $grami,
    				 'stili' => $stili,
    				 'grami0' => $grami_h,
    				 'stili0' => $stili_w
    				 'link' => $link
    			 )
    	 * @param string $file image path
    	 */
    	public function peg_print_image_array($param = array(), $file){
    		
    		
    		
    		$this->peg_tmp_lastPrintType = 'image';
    		$width  = 0;
    		$height = 0;
    		$align	= 'L';
    		$palign = '';
    		$resize = false;
			$dpi	= 0;
    		$ismask = false;
			$border = 0;
    		$fitbox = 'LT';
    		$hidden = false;
    		$fitonpage = false;

    		$grami	= $param['grami'] ;
    		$stili	= $param['stili'] ;
    		$grami0	= $param['grami0'] ;
    		$stili0	= $param['stili0'] ;
    		
    		$link   = (isset($param['link']))	?	$param['link'] 	: '';
    		$upi    = (isset($param['upi']))	?	$param['upi'] 	: false;
			$border = (isset($param['border']))	?	$param['border']: 0;
    		
    		if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    			$rowEndTmp = $grami0;
    			/* if($rowEndTmp==0){
    				$rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
    			} */
    			
    		
    			$this->_pushBodyElement(array(
    					'fname' => 'peg_print_image_array',
    					'rowstart'	=> $grami,
    					'rowend'	=> $rowEndTmp,
    					'upi'		=> $upi,
    					'args'	=> array(
    							'param' => $param,
    							'text' => ""
    					)
    			));
    			return ;
    		}
    		
    		$x_tmp = $this->_getTCPDFXFromStili($stili);
    		$y_tmp = $this->_getTCPDFYFromGrammi($grami);
			if($this->p85_classType==2){
				if($param['pos']==1 or $param['pos']==3){
					$y_tmp = $this->_getTCPDFYFromGrammi($grami,false) + $this->getHeaderMargin();	
				}
			}
    		
    		if(!file_exists($file)){
    			return;
    		}
    		
    		
    		$width  = $this->_getTCPDFWidth($stili,$stili0); // The width to print in user unit
    		$height =  $this->_getTCPDFHeight($grami,$grami0);// The height to print in user unit
    		//echo ($width*$this->k)/($height*$this->k);
    		
    		list($image_width, $image_height, $image_type, $image_attr) = getimagesize($file);
    		if($image_width<($width*$this->k) ){
    			$width = 0;
    		}
    		if($image_height<($height*$this->k) ){
    			$height = 0;
    		}
			/*
    		$this->setXY($x_tmp  ,   $y_tmp);
     		$text = ' grami=' . $grami. ', grami0=' . $grami0 . ' stili=' . $stili .' , stili0='. $stili0 . ' width=' . $width . ' height=' . $height . ' x_tmp=' . $x_tmp . ' y_tmp=' . $y_tmp;
    		$this->Cell($width , 0  , $text , 0  , 0 , $align , false, ''); */

    		$this->peg_tmp_lastPageStart = $this->getPage();



			//Disable auto-page-break (override "fitBlock" method if inHeader or inFooter)
			if($this->p85_classType==2 && ($this->InHeader || !$this->InFooter)){
				//get the current page break margin & auto-page-break mode
				$break_margin 	 = $this->getBreakMargin();
				$auto_page_break = $this->getAutoPageBreak();
				// disable auto-page-break
				$this->setAutoPageBreak(false, 0);
			}

			$this->Image($file, $x_tmp, $y_tmp, 
    				$width, $height, '', $link,$align, $resize, 
    				$dpi, $palign, $ismask,$ismask, $border, $fitbox, 
    				$hidden, $fitonpage, false); 


			//Restore auto-page-break
			if($this->p85_classType==2 && ($this->InHeader || !$this->InFooter)){
				$this->setAutoPageBreak($auto_page_break, $break_margin);
			}		
    	}
    	/**
    	 * 1d
    	 *  'C39':  // CODE 39 - ANSI MH10.8M-1983 - USD-3 - 3 of 9.
    	 *  'C39+': // CODE 39 with checksum
    	 *  'C39E': // CODE 39 EXTENDED
    	 *  'C39E+': // CODE 39 EXTENDED + CHECKSUM
    	 *  'C93': // CODE 93 - USS-93
    	 *  'S25': // Standard 2 of 5
    	 *  'S25+': // Standard 2 of 5 + CHECKSUM
    	 *  'I25': // Interleaved 2 of 5
    	 *  'I25+': // Interleaved 2 of 5 + CHECKSUM
    	 *  'C128': // CODE 128
    	 *  'C128A': // CODE 128 A
    	 *  'C128B': // CODE 128 B
    	 *  'C128C': // CODE 128 C
    	 *  'EAN2': // 2-Digits UPC-Based Extension
    	 *  'EAN5': // 5-Digits UPC-Based Extension
    	 *  'EAN8': // EAN 8
    	 *  'EAN13': // EAN 13
    	 *  'UPCA': // UPC-A
    	 *  'UPCE': // UPC-E
    	 *  'MSI': // MSI (Variation of Plessey code)
    	 *  'MSI+': // MSI + CHECKSUM (modulo 11)
    	 *  'POSTNET': // POSTNET
    	 *  'PLANET': // PLANET
    	 *  'RMS4CC': // RMS4CC (Royal Mail 4-state Customer Code) - CBC (Customer Bar Code)
    	 *  'KIX': // KIX (Klant index - Customer index)
    	 *  'IMB': // IMB - Intelligent Mail Barcode - Onecode - USPS-B-3200
    	 *  'IMBPRE': // IMB - Intelligent Mail Barcode - Onecode - USPS-B-3200- pre-processed
    	 *  'CODABAR': // CODABAR
    	 *  'CODE11': // CODE 11
    	 *  'PHARMA': // PHARMACODE
    	 *  'PHARMA2T': // PHARMACODE TWO-TRACKS
    	 
    	 * DATAMATRIX : Datamatrix (ISO/IEC 16022)
    	 * PDF417 : PDF417 (ISO/IEC 15438:2006) PDF417,a,e,t,s,f,o0,o1,o2,o3,o4,o5,o6 :
    	 * QRCODE
    	 * RAW
    	 * RAW2
    	 *
    	 
    	 
    	 * @param array $param
    	 * @param number $value
    	 */
    	public function peg_print_barcode_array($param=array(), $value){
    	    $this->peg_tmp_lastPrintType = 'barcode';
    	    
    	    $width  = 0;
    	    $height = 0;
    	    //T: top-right for LTR or top-left for RTL
    	    //M: middle-right for LTR or middle-left for RTL
    	    //B: bottom-right for LTR or bottom-left for RTL
    	    //N: next line
			$align = 'B'; 
			
    	    //if true distort the barcode to fit width and height, otherwise preserve aspect ratio
    	    //only 2D
			$distort = false;

			$hpadding = (isset($param['hpadding']))	? $param['hpadding'] : 'auto'; 
			$vpadding = (isset($param['vpadding']))	? $param['vpadding'] : 'auto'; 
			$fontsize = (isset($param['fontsize']))	? $param['fontsize'] : 8; 
			$font 	  = (isset($param['font']))		? $param['font'] 	 : 'helvetica'; 
			$position = (isset($param['position'])) ? $param['position'] : '';
			
    	    $style = array(
    	        'position' 		=> $position,
    	        'align'			=> 'C',
    	        'stretch' 		=> false,
    	        'fitwidth' 		=> true,
    	        'cellfitalign' 	=> '',
    	        'border' 		=> false,
    	        'hpadding' 		=> $hpadding,
    	        'vpadding' 		=> $vpadding,
    	        'fgcolor' 		=> array(0,0,0),
    	        'bgcolor' 		=> false, //array(255,255,255),
    	        'text' 			=> $param['text'],
    	        'font' 			=> $font,
    	        'fontsize' 		=> $fontsize,
				'stretchtext' 	=> 4,
				'label' 		=> $param['label']
			);
    	    
    	    //(float) width of the smallest bar in user units (empty string = default value = 0.4mm)
    	    //Only 1D
    	    $xres = null;
    	    
    	    
    	    
    	    $grami	= $param['grami'] ;
    	    $stili	= $param['stili'] ;
    	    $grami0	= $param['grami0'] ;
    	    $stili0	= $param['stili0'] ;
    	    
    	    $type        = (isset($param['type']))?$param['type'] : 'C39'; 
            $orientation = (isset($param['orientation']))?$param['orientation'] : 'H'; 
    	    $upi		 = (isset($param['upi']))?$param['upi'] : false;
    	    
    	    if(empty($value) && isset($param['args']) && isset($param['args']['text'])){
    	        $value = $param['args']['text'];
    	    }
    	    
    	    if($this->peg_tmp_lastPosition==2 and !$this->bodyFlush ){
    	        $rowEndTmp = $grami0;
    	        /* if($rowEndTmp==0){
    	         $rowEndTmp = ($this->_getNumOfRowsFromTCPDFHeight($this->getStringHeight($width, $text)) +$grami);
    	         } */
    	        
    	        
    	        $this->_pushBodyElement(array(
    	            'fname' => 'peg_print_barcode_array',
    	            'rowstart'	=> $grami,
    	            'rowend'	=> $rowEndTmp,
    	            'upi'		=> $upi,
    	            'args'	=> array(
    	                'param' => $param,
    	                'text' => $value
    	            )
    	        ));
    	        return ;
    	    }
    	    
    	    $x_tmp = $this->_getTCPDFXFromStili($stili);
    	    $y_tmp = $this->_getTCPDFYFromGrammi($grami);
			if($this->p85_classType==2){
				if($param['pos']==1 or $param['pos']==3){
					$y_tmp = $this->_getTCPDFYFromGrammi($grami,false) + $this->getHeaderMargin();	
				}
			}
    	    
    	    if(empty($value)){
    	        return;
    	    }
    	    
    	    $width  = $this->_getTCPDFWidth($stili, $stili0); // The width to print in user unit
    	    $height = $this->_getTCPDFHeight($grami,$grami0);// The height to print in user unit
			$rows   = $this->_getHeight($grami, $grami0, true); 
			
			//echo "<pre>". print_r( $param,1) . "</pre>";
			//echo $type." -- ".$x_tmp." -- ".$y_tmp." -- ".$width." -- ".$height." -- ".$rows."<br>";                      
			
			$this->peg_tmp_lastPageStart = $this->getPage();

			
			//set&restore margins for Barcode Creation
			$tmp_tMargin = $this->tMargin;
			$tmp_bMargin = $this->bMargin;
			if($this->print_header===true){ $this->tMargin = $this->getHeaderMargin(); }
			if($this->print_footer===true){ $this->bMargin = $this->getFooterMargin(); }

			//Disable auto-page-break (override "fitBlock" method if inHeader or inFooter)
			if($this->p85_classType==2 && ($this->InHeader || !$this->InFooter)){
				//get the current page break margin & auto-page-break mode
				$break_margin 	 = $this->getBreakMargin();
				$auto_page_break = $this->getAutoPageBreak();
				// disable auto-page-break
				if($this->getPage()>1){
					$this->setAutoPageBreak(false, 0);
				}
			}

    	    if( in_array($type, array('DATAMATRIX', 'PDF417', 'QRCODE', 'RAW', 'RAW2'))){
    	        $this->write2DBarcode($value, $type, $x_tmp, $y_tmp,$width, $height, $style , $align , $distort);
    	    }else{
    	        if($orientation=='H'){
    	           $this->write1DBarcode($value, $type, $x_tmp, $y_tmp, $width, $height, $xres , $style , $align);    
    	        }elseif($orientation=='V'){
                    $this->StartTransform();
                    $this->Rotate(90, $x_tmp+$width, $y_tmp+$height);
                    $this->write1DBarcode($value, $type, $x_tmp+$width, $y_tmp+$height-$width, $height, $width, $xres, $style , $align);
                    $this->StopTransform();    
    	        }
			}

			//Restore auto-page-break
			if($this->p85_classType==2 && ($this->InHeader || !$this->InFooter)){
				if($this->getPage()>1){
					$this->setAutoPageBreak($auto_page_break, $break_margin);
				}				
			}

			//restore margins
			$this->tMargin = $tmp_tMargin;
			$this->bMargin = $tmp_bMargin;
			

			return array('height' => $height, 'rowsHeight' => $rows);
    	} 
    
    	/**
    	 * Kanei set ta margins
    	 * Pros to paron to bottom to agnwei
    	 * @param number $top_margin
    	 * @param number $left_margin
    	 * @param number $bottom_margin
    	 * @param number $right_margin
    	 */
    	public function peg_set_margins($top_margin=0 ,$left_margin=0 , $bottom_margin=0 , $right_margin=0 ){
    		$this->_setTopMargin($top_margin);
    		$this->_setRightMargin($right_margin);
    		$this->_setLeftMargin($left_margin);
    	
    	}
    	
    	/**
    	 * Epstrefi thn grammi poy tipwsai teleytaia fora
    	 * @return number
    	 */
    	public function getTCPDFLastRow($include_margins=true){
    	    return ($this->_getRowFromY($this->y, $include_margins) -  $this->custom_offset_y);
    	}
    	
    	/**
    	 * Arxikopoiei poses grammes tha exei to PDF
    	 * @param double $grammes
    	 */
    	private function _setGrammes($grammes){
    		if(empty($this->grammes )){
    			if(!empty($grammes)){
    				$this->grammes = $grammes;
    				$this->g_height = ($this->h /$this->grammes);
    			}
			}
		}
		public function _getGrammes(){
    	    return $this->grammes;
		}
		
    	/**
    	 * Arxikopoiei poses steiles tha exei to PDF
    	 * @param double $stiles
    	 */
    	private function _setStiles($stiles){
    		if(empty($this->stiles )){
    			if(!empty($stiles)){
    				$this->stiles = $stiles;
    				$this->s_width = ($this->w )/$this->stiles;
    			}
    		}
    	}
    	/**
    	 * To margin apo aristera
    	 * @param double $margin
    	 */
    	private function _setLeftMargin($margin){
    		if(!empty($margin) or $margin===0 or is_numeric($margin)){
    			$this->left_margin = $margin;
    			parent::SetLeftMargin(($this->left_margin * $this->s_width ));
    		}
    	}
    	 /**
    	  * To margin apo pano
    	  * @param double $margin
    	  */
    	public function _setTopMargin($margin) {
    		if(!empty($margin) or $margin===0 or is_numeric($margin)){
    			$this->top_margin = $margin;
    			parent::SetTopMargin(($this->top_margin*$this->g_height));
    		}
    	}
		/**
    	  * @param double $margin
    	  */
    	public function _setBottomMargin($margin, $setAutoPageBreak=false) {
    		if(!empty($margin) or $margin===0 or is_numeric($margin)){
    			$this->bottom_margin = $margin;
				if($setAutoPageBreak==true){
					$this->setAutoPageBreak(true, $this->_getTCPDFHeight(0, $this->bottom_margin)+$this->GetFooterMargin());
				}
    		}
    	}
    	 /**
    	  * To deji margin
    	  * @param double $margin
    	  */
    	private function _setRightMargin($margin){
    		if(!empty($margin) or $margin===0 or is_numeric($margin)){
    			$this->right_margin = $margin;
    			parent::SetRightMargin(($this->right_margin * $this->s_width));
    		}
    	}
    	/**
    	 * Epistrefei to upsos se grammes
    	 * Ean to end == 0 || $end == $start epistrefei to 1
    	 * Ean to end < start epistrefei to absolute end
    	 * Diaforetika epistrefei thn diafora tous
    	 * @param float $start grammi apo
    	 * @param float $end grammi eos
    	 * @return number
    	 */
		/* TesaeDev Edit-Comment */
     	private function _getHeight($start, $end, $set=false){
     		$start = floatval($start);
     		$end   = floatval($end);
     		
     		if($end == 0 || $end == $start){
     			$peg_tmp_lasth = 1;
     		}elseif ($end > $start){
     			$peg_tmp_lasth = $end - $start;
     		}else{
     			$peg_tmp_lasth = abs($end);
     		}
			
			if($set==true){
				$this->peg_tmp_lasth = $peg_tmp_lasth;
				if($this->peg_tmp_lastPosition=='2' && $this->peg_max_body_elem_height<$peg_tmp_lasth){
					$this->peg_max_body_elem_height = $peg_tmp_lasth;
				}
			}
			
			
    		/*if($this->peg_tmp_lasth<1){
    			$this->peg_tmp_lasth=1;
    		}*/
     		return $peg_tmp_lasth;
     	}  
    	
    	/**
    	 * Epistrefei to x position sto PDF
    	 * @param double $stili
    	 * @return float
    	 */
    	public function _getTCPDFXFromStili($stili, $include_margins=true){
			if($include_margins==true){
				return (($stili*$this->s_width)+($this->left_margin*$this->s_width) );
			}else{
				return (($stili*$this->s_width));
			}
    	}
    	/**
    	 * Epistrefei to Y sto PDF
    	 * @param double $grami
    	 * @return float
    	 */
    	public function _getTCPDFYFromGrammi($grami, $include_margins=true){
			if($include_margins==true){
				return  ( (($grami) *$this->g_height) + ($this->top_margin*$this->g_height ) );
			}else{
				return  ( (($grami) *$this->g_height) );
			}
    	}
    	/**
    	 * Orizoume to stili apo , stili eos kai mas epistrefei to width gia to TCPDF
    	 * @param double $start
    	 * @param double $end
    	 * @return number
    	 */
    	public function _getTCPDFWidth($start,$end){
    		return (($end-$start)*$this->s_width);
    	}
    	/**
    	 * Orizoume to grammi apo , grammi eos kai mas epistrefei to height gia to TCPDF
    	 * @param double $start
    	 * @param double $end
    	 * @return number
    	 */
    	public function _getTCPDFHeight($start,$end){
    		return (float) (($this->_getHeight($start, $end))*$this->g_height);
    	}
    	
    	/**
    	 * Epistrefei thn grammi apo to y toy TCPDF
    	 * @param float $y //Current vertical position in user unit for cell positioning.
    	 * @return number
    	 */
    	public function _getRowFromY($y, $include_margins=true){
			if($include_margins==true){
				return  (($y /$this->g_height) - $this->top_margin);
			}else{
				return  (($y /$this->g_height));
			}
    	}
    	
    	public function _getNumOfRowsFromTCPDFHeight($height){
    		return  ($height /$this->g_height) ;
    	}
    	/**
    	 * Sthn allagi selidas midenizei ta Upsoi
    	 */
    	private function _updMinusGrammes($i=0){
    		if($this->updMinusTrigger){
    			 
				/* TesaeDev Edit-Comment */
    			//if($i>0 && !$this->printHeaderOnce){$i--;}
				//if($i>0){$i--;}// To i jekinaei apo 1	
    			// oi grammes pou dilwnw stp p87
    			$this->minusGrammes		= $this->lastRow+ $i ;
    			
    		
    			if($this->printHeaderOnce ){
    				//To $this->max_head_row kai to bodyheight ensomatonontai sto minusGrammes
    				
    				$this->updateMaxHeaderRow();
    				// 			if($this->peg_tmp_lasth > )
    				$this->offset_y			= 0;
    				$this->bodyheight		= 0;				
    			}
    			
    			$this->peg_tmp_last_body_current_row = 0;
    			$this->updMinusTrigger	= false;
    			
    		}
    	} 
    	
    	private function updateMaxHeaderRow(){
    		
    		$this->max_head_row		= $this->getTCPDFLastRow();
			/* TesaeDev Edit-Comment */
    		if($this->peg_tmp_lastPrintType=='exp' && $this->max_head_row!=0){
			//if($this->peg_tmp_lastPrintType=='exp'){
    			$this->max_head_row += $this->peg_tmp_lasth;
    		} 
    	}
    	
    	/**
    	 * Kanei pish ena ellement tou body ean to height tou enia mealitero ap;o ta alla tote
    	 * kanei pdate to max row tis grammis
    	 * @param array $elem
    	 * @method peg_print_line -- Den allazei to upsos
    	 * @method peg_print_text -- Den allazei to upsos
    	 * @method peg_print_cell -- Mporei na allajei to upsos
    	 * @method peg_print_memo_array -- Mporei na allajei to upsos
    	 * @method peg_print_html_array -- Mporei na allajei to upsos
    	 * @method peg_print_image_array -- Mporei na allajei to upsos
    	 */
    	private function _pushBodyElement( $elem = array()){
    		$this->body_row_i_data['grammistart'] =  $this->body_tmp_i;
    		//TODO Otan allazei h grammi top na kanw flush to body kai na kalw to addbosy
    		$tmpStartRow = null;
    		$tmpEndRow = null;
    		switch ($elem['fnameaddBodyI']) {
    			case 'peg_print_line':
    				$tmpStartRow = $elem['rowstart'];
    				break;
    			case 'peg_print_text':
    				$tmpStartRow = $elem['rowstart'];
    				if(!empty($elem['args']['text'])){
    					$tmpEndRow = ($tmpStartRow + $this->_getNumOfRowsFromTCPDFHeight($this->getCellHeight($this->FontSize)) );
    				}else{
    					$tmpEndRow  = $elem['rowend'];
    				}
    				break;
    			default:
    				$tmpStartRow = $elem['rowstart'];
    				$tmpEndRow  = $elem['rowend'];
    	
    				break;
    		}
    		$elem['font'] = array('family' => $this->FontFamily, 'style' => $this->FontStyle, 'sizept' => $this->FontSizePt);
    		$elem['fillColorAr'] = $this->fillColorAr;
    		$elem['drawColorAr'] = $this->drawColorAr;
    		$elem['textColorAr'] = $this->textColorAr;
    		
    		/* var_dump($elem);
    		echo "<br/><br/>"; */
    		/* if($elem['fname'] == "peg_print_html_array" and $this->peg_tmp_lastPosition==2){
    			die("??". var_export($elem,true));
    		}  */
			

			$minlen = (0.01 / $this->k); // minimum acceptable length (3 point)			
			
			
    		if($tmpStartRow!==NULL and   ( $this->body_row_i_data['rowstart']<$tmpStartRow || $this->body_row_i_data['rowstart']===NULL)  ){
			//if($tmpStartRow!==NULL and   ( $tmpStartRow-$this->body_row_i_data['rowstart']>$minlen || $this->body_row_i_data['rowstart']===NULL)  ){	
    			/* echo "Ean exw allagi grammis se ena rec ths mias grammis tou body"; */
    			//Ean exw allagi grammis se ena rec ths mias grammis tou body
    			if($this->body_row_i_data['rowstart']!==NULL){
    				// $elem['rowstart']
    				$this->_flushBodyI();
    				
    				/* $tmpVarFloat = $this->_getHeight( $elem['rowstart'], $elem['rowend']);
    				
     				echo "##################<br/>tmpVarFloat = $tmpVarFloat  ".$this->body_row_i_data['rowstart']." and ".$this->body_row_i_data['rowend']." <br/><br/>";			
    				echo print_r($elem, true)."<br/><br/><br/>"; 
    				
     				$this->offset_y+=$tmpVarFloat ;
    				
    
    				$this->_updateBodyElementData($elem,$tmpVarFloat); */
    				
    			}else{
    				$this->peg_tmp_last_bodyrow = $tmpStartRow;
    			}
    		
    			if($this->body_row_i_data['rowstart']===NULL ){
    				//Prepei na einai jexwristo giati to  $this->_flushBodyI(); mporei na to kanei null
    				$this->body_row_i_data['rowstart']=$tmpStartRow;
    			}
    			$this->body_row_i_data['elem'][] = $elem;
    			//array_push($this->body_row_i_data['elem'], $elem);
    			
    		}else{
    			//array_push($this->body_row_i_data['elem'], $elem);
    			$this->body_row_i_data['elem'][] = $elem;
    			
    		}
    		
    		
    		
    		if($elem['upi']){
    			//$this->body_row_i_data['elem'][] = $elem;
    			//array_push($this->body_row_i_data['elem'], $elem);
    			if($tmpEndRow!==NULL /* and $this->body_row_i_data['rowend']<$tmpEndRow */){
    				$this->body_row_i_data['rowend']=$tmpEndRow;
    			}
    			
    			// $tmpVarFloat = $this->_getHeight($this->body_row_i_data['rowstart'], $this->body_row_i_data['rowend']);
    			$tmpVarFloat = $this->_getHeight( $elem['rowstart'], $elem['rowend']);
    			$this->_flushBodyI();
    			
    			$this->offset_y+=$tmpVarFloat ;
    		}
    		//Sta arxidia mou poy ekteleite panta sto telos
    		if($tmpEndRow!==NULL  and $this->body_row_i_data['rowend']<$tmpEndRow ){
    		    //see ppy 2035180
    			$this->body_row_i_data['rowend']=$tmpEndRow;
    		}

			$minlen = (0.01 / $this->k); // minimum acceptable length (3 point)
    
    		// echo "<br/>##########<br/>";
    		// print_r($this->body_row_i_data);
    		// echo "<br/>##########<br/>";
    	}
		

		public function set_textElementsArray($textElementsArray=array()){
			$this->textElementsArray = $textElementsArray;
		}

		private function _push_textElementsArray($element){

			if(!is_array($element)){
				return;
			}
			if(!isset($element['page_start'])){
				return;
			}
			if(!isset($element['pegasus_grammi_start'])){
				return;
			}
			if(!array_key_exists($element['page_start'], $this->textElementsArray)){
				$this->textElementsArray[(string)$element['page_start']] = array();
			}
			if(!array_key_exists((string)$element['pegasus_grammi_start'], $this->textElementsArray[$element['page_start']])){
				$this->textElementsArray[$element['page_start']][(string)$element['pegasus_grammi_start']] = array();
			}
			$this->textElementsArray[$element['page_start']][(string)$element['pegasus_grammi_start']][] = $element;
		}



    	/**
    	 * Kanei minus to row twn body element
    	 */
    	private function _updateBodyElement( $i ){
    	   
    		//Efoson to position exw apo to cash
    		//den thelw sto update na mou kanei minus grammes
    		$this->peg_tmp_lastPosition = 2;
    		//$this->body_row_i_data['grammistart']	= 0;
    		// echo "qqq=" .$this->body_row_i_data['rowstart'] . " = " .  $this->body_row_i_data['rowstart'] ."+". $i ."<br/>";
    		$this->body_row_i_data['rowstart']		= $this->body_row_i_data['rowstart']+$i;
    		$this->body_row_i_data['rowend']		= $this->body_row_i_data['rowend'] + $i;
    		
    		
    		//$i
    		foreach ($this->body_row_i_data['elem']  as &$elem ){
				$this->_updateBodyElementData($elem ,$i, $this->body_row_i_data['rowstart'], $this->body_row_i_data['rowend']);
			}
    		// echo "<br/>#####<br/>".print_r($this->body_row_i_data, true)."<br/>#####<br/>";
    	}
    
    	private function _updateBodyElementData(&$elem,$i ,$rowstart = 0,$rowend = 0){
    			switch ($elem['fname']) {
    				case 'peg_print_line':
    					$elem['args']['grami_top']=$elem['args']['grami_top']+$i;
    					$elem['args']['grami_bottom']=$elem['args']['grami_bottom']+$i;
    			
    					break;
    				case 'peg_print_text':
    					$elem['args']['grami']=$elem['args']['grami']+$i;
    					break;
    				default:
    					if (is_array($elem['args']['param'])){
    						if($elem['args']['param']['grami0']>0){
    							$elem['args']['param']['grami0']=$elem['args']['param']['grami0']+$i;
    						}
    						if($elem['args']['param']['grami']>0){
    							$elem['args']['param']['grami'] = $elem['args']['param']['grami']+$i;
    						}
    					}
    					if (is_array($elem['args'])){
    					    $elem['args']['grami0'] = $elem['args']['grami0'] +$i;
    					}
    					/* else 
    						die(print_r($elem, true)); */
    					break;
    			}
    			$elem['rowstart']	= $elem['rowstart'] + $i;
    			$elem['rowend']		= $elem['rowend'] + $i;
    			/* $elem['rowend']		= $elem['rowend'] + $i; */
    			
    			
    		
    	}
    	

    	/**
    	 * Einai upo katargisi
    	 * @deprecated
    	 * @see peg_print_memo_array()
    	 */
    	public function peg_print_memo($grami , $stili ,$grami0 , $stili0  , $text){
    	
    		if(empty($text)){
    			return ;
    		}
    	
    		return $this->peg_print_memo_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami0,
    						'stili0' => $stili0
    				) ,$text
    		);
    	
    	}
    	/**
    	 * Einai upo katargisi
    	 * @deprecated
    	 * @see peg_print_image_array()
    	 */
    	public function peg_print_image($file , $grami , $stili , $grami_h , $stili_w   ){
    	
    		$this->peg_print_image_array(
    				array(
    						'grami' => $grami,
    						'stili' => $stili,
    						'grami0' => $grami_h,
    						'stili0' => $stili_w
    				) ,$file
    		);
    	}

		/**
    	 * Calculate appropriate size for a string to fit in at $max_height
		 * @param $str
		 * @param $width		element's width
		 * @param $max_height	element's max available height
		 * @param $step			recursive step
		 * @param $factor		length multiplication factor
		 * @return $length		max appropriate string length
    	 */
		public function peg_estimateMaxStringLength($str, $width, $max_height, $step=0, $factor=1){

			if($step==0){
				$factor = 1;
			}
			$length = strlen($str)*$factor;
			$str_tmp = peg_substr($str, 0, $length);
			$string_height = $this->getStringHeight($width, $str_tmp, false, true, '', 0);
			$rows_diff = $this->_getNumOfRowsFromTCPDFHeight($max_height-$string_height);
			
			if($string_height>$max_height or $rows_diff<2){
				$factor -= 1/pow(2, ++$step);
				$length = $this->peg_estimateMaxStringLength($str, $width, $max_height, $step, $factor);

			}elseif($rows_diff>3 && $step!=0){	
				$factor += 1/pow(2, ++$step);
				$length = $this->peg_estimateMaxStringLength($str, $width, $max_height, $step, $factor);
			}
			
			return $length;
		}

		/**
    	 * Format Html Text
		 * @param	string	$html	HTML Text
		 * @return 	string	$html	Formatted HTML Text
    	 */
		public function peg_formatHtmlText($html){

			//Format Links
			$server_url = "https://" . $_SERVER["SERVER_NAME"];
			if(!empty($_SERVER['SERVER_NAME'])){
				$replace_arr = array(
					'href="/'	=>	'href="'	. $server_url . '/',	
					'href=\'/'	=>	'href=\''	. $server_url . '/',
					'src="/'	=>	'src="'		. $server_url . '/',
					'src=\'/'	=>	'src=\''	. $server_url . '/',
				);

				$html = str_replace(array_keys($replace_arr), array_values($replace_arr), $html);
			}
			
			return $html;
		}
    	
    }	
    
?>
