/**
 * @class Functions.query.core
 * 
 * @member WebApp.view 
 *  
 *  ##Properties
 *  
 *  The global variables of the module
 *   
 *  ##Methods
 *  
		- General functions
		- Start After draw listeners
 *  
 *  The functions of the module
 *  
 */

/**
 * Εμφανίζει την οθόνη εκετέλεσης μιας π-Αναφοράς σε ένα νεό παράθυρο.
 * @param {number} nr01
 * @param {String} container_id
 * @param {String} parent_container_id
 * @param {Object} params με τις παραμετρους που θα περάσουν στην π-Αναφορά. 
 * @returns
 */
function peg_query_window_execute(nr01, container_id, parent_container_id, params) {

	return peg_windowShow_d(
		'',
		'q10_d90_' + nr01 + '_d',
		'query',
		parent_container_id,
		container_id,
		nr01,
		'',
		'c-c',
		params,
		false, true, 0, null,
		'tablet'
	);
			
}

/**
 * The requestin XSR on function {@link query_export_q10}
 * @type {string}
 */
var query_export_q10_refresh_values_ajax = '';
/**
 * Export a preport
 * @param {String} container_id
 * @param {Number} mnr01
 * @returns
 */
function query_export_q10(container_id, mnr01) {
	var q10_d_container_id = container_id;

	/*console.log(' p85_d_container_id ' + p85_d_container_id + ' mnr01 ' + mnr01);*/

	params = {};
	params.mnr01 = mnr01;

	if (query_export_q10_refresh_values_ajax != '') {
		if (query_export_q10_refresh_values_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(query_export_q10_refresh_values_ajax);
		}
	}

	query_export_q10_refresh_values_ajax = pegAjaxDefer('/' + main_path + '/query02/q10_export.php',
		params,
		function (jsondata) {
			if (jsondata.ok == 0) {
				pegAlert(jsondata.msg);
			} else {
				win = window.open('/' + main_path + '/query02/q10_export_download.php?q10_nr01=' + jsondata.data, 'download');
			}
		}
	);

}

//XXX _d function
/**
 * π-Αναφορές
 * @param {String} container_id
 * @returns
 */
function query_q10_d_afterDraw_listeners(container_id) {
	return;
}

function query_q10_d_refresh_all_grids(container_id){
	var q10_d01_container_id = pegGetContainer_id_d(container_id, 'q10_d01', '', 'q10_d');
	var q10_d02_container_id = pegGetContainer_id_d(container_id, 'q10_d02', '', 'q10_d');
	var q10_d03_container_id = pegGetContainer_id_d(container_id, 'q10_d03', '', 'q10_d');
	var q10_d04_container_id = pegGetContainer_id_d(container_id, 'q10_d04', '', 'q10_d');
	var q10_d06_container_id = pegGetContainer_id_d(container_id, 'q10_d06', '', 'q10_d');

	pegGridRefresh(q10_d01_container_id, 'grid01');
	pegGridRefresh(q10_d01_container_id, 'grid02');

	pegGridRefresh(q10_d02_container_id, 'grid02');

	pegGridRefresh(q10_d03_container_id, 'grid02');

	pegGridRefresh(q10_d04_container_id, 'grid02');

	pegGridRefresh(q10_d06_container_id, 'grid02');
}

var query_q10_d_p02_on_change = '';
function query_q10_d00_afterDraw_listeners(container_id) {
	var q10_d_container_id = pegGetContainer_id_d(container_id, 'q10_d', '', 'q10_d');
	var q10_nr01 = pegGetVal('nr01', q10_d_container_id); 
	var p02 = pegGetCmp(container_id, 'p02');
	p02.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (query_q10_d_p02_on_change != '') {
			if (query_q10_d_p02_on_change.id > 0) {
				Ext.ux.AjaxDefer.abort(query_q10_d_p02_on_change);
			}
		}
		params = {};
		params.q10_p02 = newValue;
		params.container_id = q10_d_container_id;
		params.q10_nr01 = q10_nr01;
		query_q10_d_p02_on_change = pegAjaxDefer('/' + main_path + '/query01/query_q10_d_p02_on_change.php',
			params,
			function (jsondata) {
				query_q10_d_refresh_all_grids(q10_d_container_id);
			}
		);
	});
}

var query_q10_d_q10_d01_on_select = '';
function query_q10_d01_afterDraw_listeners(container_id) {
	var q10_d_container_id = pegGetContainer_id_d(container_id, 'q10_d', '', 'q10_d');
	var q10_nr01 = pegGetVal('nr01', q10_d_container_id); 

	var screen = pegGetCmp(container_id);
	var but01 = pegGetCmp(container_id, 'but01');
	var grid01 = pegGetCmp(container_id, 'grid01');
	var grid02 = pegGetCmp(container_id, 'grid02');

	query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, 'q10_d01');

	grid01.on('select',
		function (view, record, item, index, e, opts) {
			if (query_q10_d_q10_d01_on_select != '') {
				if (query_q10_d_q10_d01_on_select.id > 0) {
					Ext.ux.AjaxDefer.abort(query_q10_d_q10_d01_on_select);
				}
			}
			params = {};
			params.selected_table = record.data.p01;
			params.selected_alias = record.data.p04;
			params.container_id = q10_d_container_id;
			params.q10_nr01 = q10_nr01;
			query_q10_d_q10_d01_on_select = pegAjaxDefer('/' + main_path + '/query01/query_q10_d_q10_d01_on_select.php',
				params,
				function (jsondata) {
					pegGridRefresh(container_id, 'grid02');
				}
			);

		}
	);

}


function query_q10_d02_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var but01 = pegGetCmp(container_id, 'but01');
	var grid01 = pegGetCmp(container_id, 'grid01');
	var grid02 = pegGetCmp(container_id, 'grid02');
	grid01.setpeg_isEditable(true);
	query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, 'q10_d02');
}

function query_q10_d03_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var but01 = pegGetCmp(container_id, 'but01');
	var grid01 = pegGetCmp(container_id, 'grid01');
	var grid02 = pegGetCmp(container_id, 'grid02');

	query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, 'q10_d03');
}
function query_q10_d04_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var but01 = pegGetCmp(container_id, 'but01');
	var grid01 = pegGetCmp(container_id, 'grid01');
	var grid02 = pegGetCmp(container_id, 'grid02');

	query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, 'q10_d04');
}


function query_q10_d05_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var grid01 = pegGetCmp(container_id, 'grid01');

	grid01.on('beforeedit', function (e, editor) {

		if (parseFloat(editor.record.data['nr01']) < 1) {
			return false;
		}
		return true;
	});
	grid01.on('edit', function (editor, e) {
		values = e.record.data;
		pegSave_grid_row(
			grid01.peg_view__d,
			'peg_tmp_q13', grid01.peg_view_module, grid01.getMnr01(), grid01.getMmnr01(),
			values,
			function (jsondata) {
				e.record.data['nr01'] = jsondata.nr01;
				if (jsonData.ok == 0) {
					pegAlert(jsonData.message);
				}


			}
		);
		e.record.commit();
	});

}


function query_q10_d06_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var but01 = pegGetCmp(container_id, 'but01');
	var grid01 = pegGetCmp(container_id + '_grid01');
	var grid02 = pegGetCmp(container_id + '_grid02');

	query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, 'q10_d06');
}

function query_q10_d85_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var grid = pegGetCmp(container_id, 'grid');

	grid.peg_isEditable = false;
	grid.record_change = function (me, row) {
		//pegAlert("TEST");
		//	var row=pegGridGetSelectedRow(me.getContainer_ID() , me.name , me.mnr01  , me.mmnr01 ); 
		if (row) {
			var nr01 = row.nr01;
			if (nr01 < 1) {
				pegGetDic('peg_dic_core_perm_deny_edit_rec', function (desc) {
					pegAlert(desc);
				});
			} else {
				var ppp_par_con_id = '';
				var screen00 = screen;
				try {
					ppp_par_con_id = screen00.getPeg_screen_parent_container_id();
				} catch (e) {
					ppp_par_con_id = me.getContainer_ID();
				}

				var parent_container_id = screen.getPeg_screen_parent_container_id();
				var parent_element_name = screen.getPeg_screen_parent_element_name();
				var parent_screen 		= pegGetCmp(parent_container_id);

				dias_main_field = "nr01";
				if(parent_screen!=undefined){	
					if(parent_screen.peg__d=="inventory_004_d00"){
						dias_main_field = "i00nr01";
					}else if(parent_screen.peg__d=="colorsize_001_d00"){
						dias_main_field = "i47nr01";
					}else if(parent_screen.peg__d=="serial_001_d00"){
						dias_main_field = "i31nr01";
					}
				}


				var dias_main_nr01;
				console.log(parent_container_id , parent_element_name);
				if (!pegIsEmpty(parent_element_name)) {
					if (pegGetCmp(parent_container_id, parent_element_name).xtype == 'webappGrid') {
						var selected_row = pegGridGetSelectedRow(parent_container_id, parent_element_name);
						dias_main_nr01 = selected_row[dias_main_field];
					}
				} else {
					dias_main_nr01 = pegGetCmp(parent_container_id).peg_nr01;
				}dias_main_field
				var dias_main_table = row.p02;

				peg_query_window_execute(nr01, '', ppp_par_con_id, {
					grid_element_name: me.name,
					peg_screen_parent_element_name: me.name,
					peg_screen_parent_container_id: me.getContainer_ID(),
					dias_main_table: dias_main_table,
					dias_main_nr01: dias_main_nr01
				});
			}
		}
	};


}

function query_q13_d_afterDraw_listeners(container_id) {
	var p012 = pegGetCmp(container_id, 'p012');
	let p03 = pegGetCmp(container_id, 'p03');
	p012.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == oldValue || (pegIsEmpty(newValue) && pegIsEmpty(oldValue))) {
			return;
		}
		if (me.getValue() == 1) {
			pegSetFieldHidden('fldset02', container_id, true);
		}
		else {
			pegSetFieldHidden('fldset02', container_id, false);
		}
	});
	p03.on('change', function (me, newValue, oldValue, eOpts) {
		if (newValue == 'N') {
			pegSetFieldHidden('p03_1', container_id, false);
		}else {
			pegSetFieldHidden('p03_1', container_id, true);
		}
	});
}
/**
 * 
 * @param {string} container_id 
 * @param {object} values 
 */
var query_q10_update_fav_ajax = '';
function query_q10_update_fav(
	params = {},
	next
) {
	if (query_q10_update_fav_ajax != '') {
		if (query_q10_update_fav_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(query_q10_update_fav_ajax);
		}
	}
	const url = '/' + main_path + '/query05/query_q10_update_fav.php';
	tran_update_factors_from_tran15_ajax = pegAjaxDefer(url, params, function (jsonData) {
		if (!jsonData) {
			return pegAlert('pegAjaxDefer response error');
		}
		if (jsonData.ok != 1) {
			return pegAlert(jsonData.msg);
		}
		if(typeof next == 'function') {
			return next();
		}
	}, 'json', 0, true)
}
function query_q10_d95_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var grid = pegGetCmp(container_id, 'grid');
	
	if(peg002_IsMobileOrTabletScreen()) {
		 grid.setpeg_isEditable(false);
	}else{
		grid.setpeg_isEditable(true);
	}

	grid.on('edit', function (editor, context) {
		const values = {
			nr01:context.record.data.nr01,
			vfav:context.record.data.vfav?1:0
		};
		return query_q10_update_fav(values,function() {
			return pegGridRefresh(container_id, 'grid');
		});
	});
	grid.on('itemclick', function (view, record, item, index, e, eOpts) {
		if((e.position.colIdx>0) || peg002_IsMobileScreen() ){
			var nr01 = record.get('nr01');
			if (nr01 < 1) {
				pegGetDicAlert('peg_dic_core_perm_deny_edit_rec');
			} else {
				pegAddTab_d('', '', 'q10_d90_' + nr01 + '_d', 'query', '', nr01);
			}
	
		}

	});
}
/**
 * Είναι η οθόνη που θα εμφανίσει τη λίστα με τις εκτυπώσεις για την αναφορά
 * @param {*} container_id 
 */
function query_q10_d97_afterDraw_listeners(container_id) {
	var screen 		 = pegGetCmp(container_id);
	var grid 		 = pegGetCmp(container_id, 'grid');
	var parentScreen = pegGetCmp(screen.peg_screen_parent_container_id);
	var btn01 		 = pegGetCmp(container_id, 'btn01');

	var screens = query_q10_d90_find_screens(parentScreen.peg__d);
	var results_tab_container_id = '';
	if (screens) {
		results_tab_container_id = pegGetContainer_id_d(screen.peg_screen_parent_container_id, screens.results_tab_name, '', screens.main_screen);
	}

	WebApp.view.grid.Grid.peg_setEditableHidden(grid, true);

	grid.record_change = function (grid, row) {
		var params = {};
		params['q10_nr01'] 			= parentScreen.getNr01();
		params['dias_container_id'] = results_tab_container_id;
		ppp_params01 				= pegGetFormVal_d(parentScreen.getContainer_ID(), parentScreen.peg__d);

		params = Ext.Object.merge(params, ppp_params01);
		console.log(params);
		if (row) {
			var nr01 = row.nr01;
			if (nr01 < 1) {
				pegGetDicAlert('peg_dic_core_perm_deny_edit_rec');
			} else {
				pegPrintToPDF(nr01, params);
			}
		}


	};

	btn01.setPeg_handler(function (me) {
		var params = {};
		params['q10_nr01'] 			= parentScreen.getNr01();
		params['dias_container_id'] = results_tab_container_id;
		ppp_params01 				= pegGetFormVal_d(parentScreen.getContainer_ID(), parentScreen.peg__d);

		params = Ext.Object.merge(params, ppp_params01);
		var row=pegGridGetSelectedRow(grid.getContainer_ID() , grid.name , grid.getGridMnr01()  , grid.mmnr01 );
		if (row) {
			var nr01 = row.nr01;
			if (nr01 < 1) {
				pegGetDicAlert('peg_dic_core_perm_deny_edit_rec');
			} else {
				pegPrintToPDF(nr01, params);
			}
		}
	});

}
function query_q16_d_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var search = pegGetCmp(container_id, 'search');
	var pro_exp = pegGetCmp(container_id, 'pro_exp');

	search.setHandler(function () {
		peg_windowShow_d(
			'',
			'q16_d01',
			'query',
			screen.getContainer_ID(),
			'',
			0,
			'',
			'',
			{
				mmnr01: screen.getMmnr01(),
				mnr01: screen.getMnr01()
			}
		);
	});
	pro_exp.setHandler(function () {
		peg_windowShow_d(
			'',
			'q16_d02',
			'query',
			screen.getContainer_ID(),
			'',
			0,
			'',
			'',
			{
				mmnr01: screen.getMmnr01(),
				mnr01: screen.getMnr01()
			}
		);
	});
}

function query_q16_d01_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var grid = pegGetCmp(container_id, 'grid');
	grid.setpeg_isEditable(false);
	grid.record_change = function (grid, row) {

		pegSetVal_d('p03', container_id, 'q16_d', '', '{' + row.p02 + '}');
		pegWindowClose(screen.peg_winid);

	};
}

function query_q16_d02_afterDraw_listeners(container_id) {
	var screen = pegGetCmp(container_id);
	var grid = pegGetCmp(container_id, 'grid');

	grid.setpeg_isEditable(false);

	grid.record_change = function (grid, row) {
		pegSetVal_d('p03', container_id, 'q16_d', '', '{' + row.exp.replace(/{|}/g, '') + '}');
		pegWindowClose(screen.peg_winid);

	};
}



function query_q10_tabscreen_afterDraw_listeners(screen, but01, grid01, grid02, actionType) {
	var container_id = screen.getContainer_ID();
	var pegUrl = '';
	var pegTmpTable = '';
	if (actionType == 'q10_d01') {
		pegUrl = '/' + main_path + '/query01/q10_0009.php';
		pegTmpTable = 'peg_tmp_q11';
	} else if (actionType == 'q10_d02') {
		pegUrl = '/' + main_path + '/query01/q10_0010.php';
		pegTmpTable = 'peg_tmp_q12';
	} else if (actionType == 'q10_d03') {
		pegUrl = '/' + main_path + '/query01/q10_0011.php';
		pegTmpTable = 'peg_tmp_q14';
	} else if (actionType == 'q10_d04') {
		pegUrl = '/' + main_path + '/query01/q10_0012.php';
		pegTmpTable = 'peg_tmp_q15';
	} else if (actionType == 'q10_d06') {
		pegUrl = '/' + main_path + '/query01/q10_0013.php';
		pegTmpTable = 'peg_tmp_q16';
	} else {
		pegAlert('Underfited action type');
		return;
	}

	but01.setHandler(function () {

		var peg_parms_array = {};
		var peg_selected_items = grid02.getSelectionModel().selected.items;
		var peg_i = 0;
		Ext.Array.each(peg_selected_items, function (name, index, peg_selected_items_itself) {

			peg_i++;
			var peg_fld_name = 'peg_fld_' + peg_i + '_';

			var peg_data = peg_selected_items_itself[index].data;
			Ext.Object.each(peg_data, function (name, index, peg_data_itself) {
				peg_parms_array[peg_fld_name + name] = index;
			});
		});

		peg_parms_array['container_id'] = container_id;
		peg_parms_array['mmnr01'] = grid02.getMmnr01();
		peg_parms_array['mnr01'] = grid02.getGridMnr01();

		pegAjax(
			pegUrl,
			peg_parms_array,
			function (jsonData) {
				pegGridRefresh(container_id, 'grid01');
			}, 'json');
	});

	grid01.on('beforeedit', function (e, editor) {

		if (parseFloat(editor.record.data['nr01']) < 1) {
			return false;
		}
		return true;
	});
	grid01.on('edit', function (editor, e) {
		values = e.record.data;
		pegSave_grid_row(
			grid01.peg_view__d,
			pegTmpTable, grid01.peg_view_module, grid01.getMnr01(), grid01.getMmnr01(),
			values,
			function (jsondata) {
				e.record.data['nr01'] = jsondata.nr01;
				if (jsondata.ok == 0) {
					pegAlert(jsondata.message);
				}


			}
		);
		e.record.commit();
	});
	grid01.on('drop', function (node, data, dropRec, dropPosition) {
		var peg_parms_array = {};
		var peg_selected_items = data.records;
		var peg_i = 0;
		var peg_i = 0;
		Ext.Array.each(peg_selected_items, function (name, index, peg_selected_items_itself) {

			peg_i++;
			var peg_fld_name = 'peg_fld_' + peg_i + '_';

			var peg_data = peg_selected_items_itself[index].data;
			Ext.Object.each(peg_data, function (name, index, peg_data_itself) {
				peg_parms_array[peg_fld_name + name] = index;
			});
		});

		peg_parms_array['container_id'] = container_id;
		peg_parms_array['mmnr01'] = grid02.getMmnr01();
		peg_parms_array['mnr01'] = grid02.getGridMnr01();

		pegAjax(pegUrl, peg_parms_array, function (jsonData) {
			pegGridRefresh(container_id, 'grid01', jsonData.nr01);
			if (jsonData.ok == 0) {
				pegAlert(jsonData.message);
			}
		}, 'json');
	});


}

var query_create_q10_d90_screen_ajax = '';
function query_create_q10_d90_screen(q10Nr01) {

	params00 = {};
	params00.q10Nr01 = q10Nr01;

	if (query_create_q10_d90_screen_ajax != '') {
		if (query_create_q10_d90_screen_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(query_create_q10_d90_screen_ajax);
		}
	}

	query_create_q10_d90_screen_ajax = pegAjaxDefer('/' + main_path + '/query03/create_q10_d90_screen.php', params00, function (jsonData) {
	});
}

function query_view_screen_afterDraw_listeners(container_id, main_screen_name) {

	var screen = pegGetCmp(container_id);
	var main_screen_container_id = screen.peg_mainForm;
	//Θέλω η afterdraw να εκτελεστεί μόνο για την main οθόνη
	if (main_screen_container_id != container_id) {
		return;
	}
	q10_d90_refresh_results(container_id, main_screen_name, true);

	var fields = pegGetFormFields(main_screen_container_id);
	if (fields.items) {

		fields.items.forEach(element => {
			element.on('blur', function (me) {
				if ((me.peg_onBlurValueHasChanged()))  {
					q10_d90_refresh_results(container_id, main_screen_name);
				}
			});
		});
	}
	var screens = query_q10_d90_find_screens(main_screen_name);

	// κατασκευή ονόματος συνάρτησης afterdraw για συγκεκριμένη αναφορά
	let module_00 = pegGetVal('module_00', container_id);
	let nr01 = pegGetVal('nr01', container_id);
	let listenerFNName = module_00 + '_query_' + nr01
	try {
		let listenerFN = null;
		try {
			listenerFN = eval(listenerFNName);
		} catch (error) {

		}
		// ελέγχω αν υπάρχει η συνάρτηση
		if (typeof listenerFN === 'function') {
			listenerFN(container_id, screens, main_screen_name);
		}
	} catch (error) {
	}

	var grid01 = pegGetCmp_d('grid01', container_id, screens.results_tab_name, '', main_screen_name);
	grid01.on('itemdblclick', function (dv, record, item, index, e) {
		query_q10_d901_itemdblclick(grid01, grid01.getMnr01());
	});

	var refresh_button =  pegGetCmp(container_id, 'refresh_button');
	if(refresh_button){
		refresh_button.setPeg_handler(function (me) { 
			q10_d90_refresh_results(container_id, main_screen_name);
		});	
	}

}


function query_q10_d90_find_screens(main_screen_name) {

	screens = {};
	screens.main_screen = main_screen_name;
	screens.results_tab_name = main_screen_name + "100";
	screens.grouped_results_tab_name = main_screen_name + "200";
	screens.results_screen_name = main_screen_name + "101";
	screens.charts_prefix_name = main_screen_name + "5";

	return screens;
}

q10_d90_refresh_results_ajax = '';
function q10_d90_refresh_results(container_id, main_screen_name, from_initialize) {
	
	screens = query_q10_d90_find_screens(main_screen_name);
	if (screens) {
		main_screen_name = screens.main_screen;
		results_tab_name = screens.results_tab_name;
		grouped_results_tab_name = screens.grouped_results_tab_name;
		charts_prefix_name = screens.charts_prefix_name;

		main_screen_container_id = container_id;
		results_tab_container_id = pegGetContainer_id_d(main_screen_container_id, results_tab_name, '', main_screen_name);
		grouped_results_tab_container_id = pegGetContainer_id_d(main_screen_container_id, grouped_results_tab_name, '', main_screen_name);

		params = pegGetFormVal_d(main_screen_container_id, main_screen_name);
		params.from_initialize = from_initialize;
		params.main_screen_container_id = main_screen_container_id;
		params.results_tab_container_id = results_tab_container_id;
		if (q10_d90_refresh_results_ajax) {
			if (q10_d90_refresh_results_ajax.id) {
				Ext.ux.AjaxDefer.abort(q10_d90_refresh_results_ajax);
			}
		}
		q10_d90_refresh_results_ajax = pegAjax(
			'/' + main_path + '/query03/q10_d90_refresh.php',
			params,
			function (jsonData) {
				pegGridRefresh(results_tab_container_id, 'grid01');
			},
			'json',
			true
		);

		charts = [];
		i = 0;
		while ((chart_container_id = pegGetContainer_id_d(main_screen_container_id, charts_prefix_name + i, '', main_screen_name))
			!= ''
		) {
			charts.push({ 'container_id': chart_container_id, 'name': charts_prefix_name + i });
			i++;
		}
		if(charts.length > 0 ){
			params.charts = JSON.stringify(charts);
			charts_q10_d90_refresh_charts(params);
		}
		
		
		if (grouped_results_tab_container_id) {
			q10_d902_refresh_results(
				main_screen_container_id,
				main_screen_name,
				grouped_results_tab_container_id);
		}

	}

}


//Είναι η query_q10_d902_grid_strore_reload - την αλλάζω για να παίρνει τις παραμέτρους 
//από την οθόνη και όχι από το παλιό grid
function q10_d902_refresh_results(main_screen_container_id, main_screen_name, grouped_results_tab_container_id, from_initialize) {

	manaScreen = pegGetCmp(main_screen_container_id);
	grid = pegGetCmp(grouped_results_tab_container_id, 'grid01');

	if (pegIsEmpty(grid)) {
		return false;
	}

	var store_prp = {
		container_id: grouped_results_tab_container_id,
		url_vars00: grid.url_vars00,

		name: grid.name,
		url_params: grid.url_params,
		_d: grid.peg__d,
		table: grid.peg_table,
		module: grid.peg_module,

		view_d: grid.peg__d,
		view_table: grid.peg_table,
		view_module: grid.peg_view_module,
		view_orderby: grid.peg_view_orderby,
		view_groupby: grid.peg_view_groupby,
		pageSize: grid.pageSize,
		request_params_d: grid.request_params_d,
		grid_request_params: grid.grid_request_params,
		request_params: grid.request_params,
		vars: grid.vars

	};

	var params = {
		nr01: manaScreen.getNr01(),
		container_id: grouped_results_tab_container_id,
		from_initialize: from_initialize
	};
	ppp_params01 = pegGetFormVal_d(main_screen_container_id, main_screen_name);
	params = Ext.Object.merge(params, ppp_params01);

	pegAjax(
		'/' + main_path + '/query03/q10_d902.php',
		params,
		function (resp) {
			if (resp['ok']) {

				resp['data']['columns'] = WebApp.view.grid.Grid.peg_initColumns(grid, resp['data']['columns'], grid.getContainer_ID());
				store_prp['fields'] = resp['data']['fields'];
				var store = Ext.create('WebApp.store.Grid.Grid', store_prp);
				grid.peg_view__d=grid.peg__d;
				grid.reconfigure(store, resp['data']['columns'], grid.getContainer_ID());
				grid.peg_afterDraw();
				store.load();

				pegSetVal('grouped_q12_sum', grouped_results_tab_container_id, resp['data']['columnSum']);
			} else if (!pegIsEmpty(resp['msg'])) {
				pegAlert(resp['msg']);
			}
		},
		'json'
	);

}

function query_find_qstring_from_params_object(json_object) {
	var queryString = Object.keys(json_object).map((key) => {
		return encodeURIComponent(key) + '=' + encodeURIComponent(json_object[key])
	}).join('&');
	if (queryString) {
		queryString = '&' + queryString;
	}
	return queryString;
}

//#region PDF EXPORT
/**
 * Εκτυπώνει το PDF από τα grid (Αποτελέσματα & Ομαδοποιημένα Αποτελέσματα)
 * για την καινούρια λογική οθονών όπου κάθε αναφορά έχει το δικό της _d
 * @param {*} container_id 
 * @param {*} grouped_results_tab_name 
 */
function query_q10_d90_export_pdf_handler(container_id, grouped_results_tab_name) {
	var screen = pegGetCmp(container_id);
	var manaScreen = pegGetCmp(screen.peg_mainForm);
	ppp_params01 = pegGetFormVal_d(manaScreen.getContainer_ID(), manaScreen.peg__d);
	query_export_pdf(manaScreen, screen, ppp_params01, grouped_results_tab_name);
}

function query_export_pdf(manaScreen, screen, ppp_params01, grouped_results_tab_name) {
	var isGroupedTab = false;
	var dataMsg = manaScreen.peg_getData('msg');
	if (!pegIsEmpty(dataMsg)) {
		pegGetDicAlert('peg_dic_query_table_not_exist_alert');
		return;
	}
	var peg002_q12fld_p07sum = 0;
	if (screen.peg__d == grouped_results_tab_name) {
		peg002_q12fld_p07sum = manaScreen.peg_getData('grouped_q12_sum');
		isGroupedTab = true;
	} else {
		peg002_q12fld_p07sum = manaScreen.peg_getData('peg002_q12fld_p07sum');
	}
	var ppp_params = {};
	ppp_params.q10_nr01 = manaScreen.getNr01();
	ppp_params.container_id = manaScreen.getContainer_ID();
	ppp_params.sub_container_id = screen.getContainer_ID();
	ppp_params._d = screen.peg__d;
	ppp_params = Ext.Object.merge(ppp_params, ppp_params01);
	ppp_params.isGroupedTab = isGroupedTab;

	if (peg002_q12fld_p07sum <= 90) {
		pegPrintToPDF('140000000000003', ppp_params);
	} else if (peg002_q12fld_p07sum <= 155) {
		pegPrintToPDF('140000000000004', ppp_params);
	} else {
		console.info('Current column num', peg002_q12fld_p07sum);
		pegGetDic('peg_dic_query_export_pdf_len_cols_deny', function (desc) {
			var txt = desc.replace('{landscape_cols}', "155");
			txt = txt.replace('{portrait_cols}', "104");
			pegAlert(txt);
		});
	}
}
//#endregion PDF EXPORT


//#region PRINT REPORT FORM
/**
 * Εμφανίζει τη λίστα με τις εκτυπώσεις της αναφοράς 
 * για την καινούρια λογική οθονών όπου κάθε αναφορά έχει το δικό της _d
 * @param {*} container_id : Το container_id της οθόνης με το grid των αποτελεσμάτων
 */
function query_q10_d90_print_report_form_pdf_handler(container_id) {
	var screen 		= pegGetCmp(container_id);
	var manaScreen 	= pegGetCmp(screen.peg_mainForm);
	ppp_params01 	= pegGetFormVal_d(manaScreen.getContainer_ID(), manaScreen.peg__d);
	query_print_report_form(screen, ppp_params01);
}


function query_print_report_form(screen, ppp_params01) {
	var manaScreen 					= pegGetCmp(screen.peg_mainForm);
	ppp_params01.container_id 		= manaScreen.getContainer_ID();
	ppp_params01.sub_container_id 	= screen.getContainer_ID();
	ppp_params01._d 				= screen.peg__d;
	peg_windowShow_d('', 'q10_d97', 'query', manaScreen.getContainer_ID(), '', manaScreen.getNr01(), '', '', ppp_params01);
}
//#endregion PRINT REPORT FORM

//#region EXPORT EXCEL

function query_q10_d90_export_excel_handler(container_id, grouped_results_tab_name) {
	var screen = pegGetCmp(container_id);
	var manaScreen = pegGetCmp(screen.peg_mainForm);
	var ppp_params01 = pegGetFormVal_d(manaScreen.getContainer_ID(), manaScreen.peg__d);
	query_export_excel(screen, ppp_params01, grouped_results_tab_name);
}
var query_q10_d95_fav_reports_ajax ='';
function query_q10_d95_fav_reports(container_id){
    const fav_val = pegGetVal('fav_val',container_id);

	if (query_q10_d95_fav_reports_ajax != '') {
		if (query_q10_d95_fav_reports_ajax.id > 0) {
			Ext.ux.AjaxDefer.abort(query_q10_d95_fav_reports_ajax);
		}
	}
	
	let ajax_params={
		container_id:container_id,
		fav:fav_val =='1' ? '0': '1'
	}
	query_q10_d95_fav_reports_ajax = pegAjaxDefer('/' + main_path + '/query01/q10_q95_fav.php',
		ajax_params,
		function (jsondata) {
			pegSetVal('fav_val',container_id,jsondata.data.fav_val);
			pegGridRefresh(container_id, 'grid');
			pegToast(jsondata.msg,'success');
		}
	);
}
function query_export_excel(screen, params, grouped_results_tab_name) {

	var manaScreen = pegGetCmp(screen.peg_mainForm);
	var qstring = query_find_qstring_from_params_object(params);
	var q10_nr01 = manaScreen.getNr01();
	var dataMsg = manaScreen.peg_getData('msg');
	var isGroupedTab = "false";

	if (!pegIsEmpty(dataMsg)) {
		pegGetDicAlert('peg_dic_query_table_not_exist_alert');
		return;
	}

	if (screen.peg__d == grouped_results_tab_name) {
		isGroupedTab = "true";
	}

	var win0 = 0;
	if (win0) {
		win0.close();
	}
	win0 = window.open('/' + main_path + '/query01/create_xls.php?_d=' + screen.peg__d +
		'&q10_nr01=' + q10_nr01 +
		'&container_id=' + manaScreen.getContainer_ID() +
		'&sub_container_id=' + screen.getContainer_ID() +
		'&isGroupedTab=' + isGroupedTab +
		qstring,
		'print00');
}
//#endregion EXCEL

//#region EXPORT CSV

function query_q10_d90_export_csv_handler(container_id, grouped_results_tab_name) {
	var screen = pegGetCmp(container_id);
	var manaScreen = pegGetCmp(screen.peg_mainForm);
	var ppp_params01 = pegGetFormVal_d(manaScreen.getContainer_ID(), manaScreen.peg__d);
	query_export_csv(screen, ppp_params01, grouped_results_tab_name);
}
function query_export_csv(screen, params, grouped_results_tab_name) {

	var manaScreen = pegGetCmp(screen.peg_mainForm);
	var qstring = query_find_qstring_from_params_object(params);
	var q10_nr01 = manaScreen.getNr01();
	var dataMsg = manaScreen.peg_getData('msg');
	var isGroupedTab = "false";

	if (!pegIsEmpty(dataMsg)) {
		pegGetDicAlert('peg_dic_query_table_not_exist_alert');
		return;
	}
	if (screen.peg__d == grouped_results_tab_name) {
		isGroupedTab = "true";
	}
	var win0 = 0;
	if (win0) {
		win0.close();
	}
	win0 = window.open('/' + main_path + '/query01/create_csv.php?_d=' + screen.peg__d +
		'&q10_nr01=' + q10_nr01 +
		'&container_id=' + manaScreen.getContainer_ID() +
		'&sub_container_id=' + screen.getContainer_ID() +
		'&isGroupedTab=' + isGroupedTab +
		qstring,
		'print00');

	console.log('/' + main_path + '/query01/create_csv.php?_d=' + screen.peg__d +
		'&q10_nr01=' + q10_nr01 +
		'&container_id=' + manaScreen.getContainer_ID() +
		'&sub_container_id=' + screen.getContainer_ID() +
		'&isGroupedTab=' + isGroupedTab +
		qstring);
}
//#endregion EXPORT CSV
/**
 * 
 * @param {*} grid01 Είναι το object του grid
 */
function query_q10_d901_itemdblclick(grid01, q10_nr01) {
	var row = pegGridGetSelectedRow(grid01.getContainer_ID(), grid01.name, grid01.getGridMnr01(), grid01.getMmnr01());
	if (row) {
		params = { q10_nr01: q10_nr01 };
		pegAjaxDefer('/' + main_path + '/query01/q10_0014.php', params, function (jsondata) {
			if (jsondata.ok === 1) {
				var nr01 = row[jsondata.data.q12_fld];

				if (jsondata.data.q12_fld) {
					if (nr01 < 1) {
						pegAlert(jsondata.data.peg_dic_core_perm_deny_edit_rec);
						return;
					}
					pegAddTab_d(
						'',
						jsondata.data.nr01_tabl,
						jsondata.data.peg_d, jsondata.data.module, '',
						nr01,
						''
					);
				}

			}
		}, 'json', true);
	}
}


var query_q10_p85_create_ajax = '';
function query_q10_p85_create(q10Nr01){

	params00 = {};
	params00.q10Nr01 = q10Nr01;

	if (query_q10_p85_create_ajax!='') {
		if (query_q10_p85_create_ajax.id>0) {
			Ext.ux.AjaxDefer.abort(query_q10_p85_create_ajax);
		}
	}

	query_q10_p85_create_ajax = pegAjaxDefer(
		'/' + main_path + '/query05/q10_p85_create.php', 
		params00, 
		function (jsonData) {
			if(jsonData.msg!=''){
				if(jsonData.ok==1){
					pegToast(jsonData.msg);
				}else{
					pegToast(jsonData.msg, 'alert');	
				}
			}
		}
	);
}

/**
 * Εκτυπώνει το query που εκτελεί η αναφορά
 * @param {*} container_id : Το container_id της οθόνης με το grid των αποτελεσμάτων
 */
var query_q10_d90_echo_sql_query_ajax = '';
function query_q10_d90_echo_sql_query(container_id) {
	var screen = pegGetCmp(container_id);
	var main_screen_container_id = screen.peg_mainForm;
	var parent_screen = pegGetCmp(main_screen_container_id);
	var screens = query_q10_d90_find_screens(parent_screen.peg__d);

	grouped_results_tab_container_id = pegGetContainer_id_d(main_screen_container_id, screens.grouped_results_tab_name, '', screens.main_screen);

	params = pegGetFormVal_d(main_screen_container_id, screens.main_screen);
	params.show_grouped_results = 0;
	if(grouped_results_tab_container_id == container_id) {
		params.show_grouped_results = 1;
	}

	if (query_q10_d90_echo_sql_query_ajax!='') {
		if (query_q10_d90_echo_sql_query_ajax.id>0) {
			Ext.ux.AjaxDefer.abort(query_q10_d90_echo_sql_query_ajax);
		}
	}

	query_q10_d90_echo_sql_query_ajax = pegAjaxDefer(
		'/' + main_path + '/query03/q10_d90_echo_sql_query.php', 
		params, 
		function (jsonData) {
			if(jsonData.msg!=''){
				if(jsonData.query != '') {
					pegAlert(jsonData.query);
				}
			}
		}
	);
}