<?php 

class Q10_d90Element
{

    public $name; //p51.name
    public $title; //p51.desc02
    public $eTitle; //p51.edesc02

    protected $screenIndex; //p51.desc06   
    protected $_d; //p51.p02
    protected $module; //p51.module

    protected $view_type; //p51.desc07
    protected $field_type; //p51.desc16

    protected $browseIndex ;
    protected $size ;
    protected $decimals ;

    protected $p52; // $this->p52[par_nm] = array('par_val' => value , 'code' => (1 || 0 ) ); ;
    protected $container; //p52.fieldset
    protected $initPHP = '';
    protected $insertChangePHP = '';

    public function __construct($title, $eTitle, $name, $browseIndex=0, $size=0, $decimals=0)
    {
        $this->title = $title;
        $this->eTitle = $eTitle;
        $this->p52 = array();
        $this->name = $name;

        $this->browseIndex = $browseIndex;
        $this->size = $size;
        $this->decimals = $decimals;
    }
    public function init($module, $_d, $screenIndex)
    {
        $this->screenIndex = $screenIndex;
        $this->_d = $_d;
        $this->module = $module;
    }

    public function addP52($p52Index, $p52Value){
        $this->p52[$p52Index] = $p52Value;
    }

    public function create()
    {

        if (empty($this->_d) || empty($this->module) || empty($this->name)) {
            throw new Exception("empty _d-module-name");
        }

        $arr = array();
        $arr['nr01'] =  pegasus_mysql_newrec('p51');
        $arr['p02'] = $this->_d;
        $arr['module'] = $this->module;
        $arr['desc02'] = $this->title;
        $arr['edesc02'] = $this->eTitle;
        $arr['desc05'] = $this->name;
        $arr['desc16'] = $this->field_type; //Τύπος πεδίου
        $arr['desc06'] = $this->screenIndex; //Screen Index
        $arr['desc07'] = $this->view_type; //view type

        $arr['desc13'] = $this->browseIndex; //Browse Index
        $arr['desc132'] = $this->browseIndex; //Browse Index
        $arr['desc17'] = $this->size; //Μέγεθος πεδίου
        $arr['desc18'] = $this->decimals; //Δεκαδικά     

        
        $arr['desc131'] = 0; //Property Browse Index
        $arr['desc08'] = 0; //Sorted Index
        $arr['desc99'] = 0; //Empty On Copy
        $arr['desc98'] = 0; //Enable Quick Find
        $arr['desc14'] = ''; //Index Expression

        pegasus_mysql_insert('p51', array_keys($arr), array_values($arr));

        $p52 = array();
        $p52['p02'] = $this->_d; //_d
        $p52['desc05'] = $this->name; //Όνομα πεδίου
        $p52['desc07'] = $this->view_type; //Τύπος πεδίου
        $p52['module'] = $this->module;
        foreach ($this->p52 as $par_nm => $par_val_arr) {
            $p52['nr01'] =  pegasus_mysql_newrec('p52');
            $p52['par_nm'] = $par_nm;
            $p52['par_val'] = $par_val_arr['par_val'];
            $p52['code'] = $par_val_arr['code'];
            $p52['par_val_js'] = isset($par_val_arr['par_val_js']) ? $par_val_arr['par_val_js'] : '';
            pegasus_mysql_insert('p52', array_keys($p52), array_values($p52));
        }
    }
}

class Q10_D90Toolbar{

    private $type = 'button'; 
    private $module_00 = 'sme';
    private $pos = 'top';

    private $module;
    private $_d;
    private $title;
    private $eTitle;
    private $iconcls;
    private $icon;
    private $icon_only;
    private $handler_js;
    private $profiles;

    public function __construct($input_arr = array()){
        if(!is_array($input_arr) || empty($input_arr)){
            throw new Exception("Invalid Initialize of Toolbar");
        }

        if(empty($input_arr["module"]) || empty($input_arr["_d"])){
            throw new Exception("Invalid Initialize of module or _d of Toolbar");
        }

        $this->module = $input_arr["module"];
        $this->_d = $input_arr["_d"];

        $this->title = isset($input_arr["title"])?$input_arr["title"]:"";
        $this->eTitle = isset($input_arr["eTitle"])?$input_arr["eTitle"]:"";
        $this->iconcls = isset($input_arr["iconcls"])?$input_arr["iconcls"]:"";
        $this->icon = isset($input_arr["icon"])?$input_arr["icon"]:"";
        $this->icon_only = isset($input_arr["icon_only"])?$input_arr["icon_only"]:"";
        $this->handler_js = isset($input_arr["handler_js"])?$input_arr["handler_js"]:"";

        if(isset($input_arr["type"])){
            $this->type = $input_arr["type"];
        }
        if(isset($input_arr["pos"])){
            $this->pos = $input_arr["pos"];
        }
   
    }

    public function create(){
        if (empty($this->_d) || empty($this->module)) {
            throw new Exception("empty _d-module");
        }
        $arr = array();
        $arr['nr01'] =  pegasus_mysql_newrec('p81');
        $arr['type'] = $this->type;
        $arr['module_00'] = $this->module_00;
        $arr['pos'] = $this->pos;

        $arr['module'] = $this->module;
        $arr['_d'] = $this->_d;
        $arr['title'] = $this->title;
        $arr['eTitle'] = $this->eTitle;
        $arr['iconcls'] = $this->iconcls;
        $arr['icon'] = $this->icon;
        $arr['icon_only'] = $this->icon_only;
        $arr['handler_js'] = $this->handler_js;

        pegasus_mysql_insert('p81', array_keys($arr), array_values($arr));

        if(is_array($this->profiles)){
            foreach ($this->profiles as $value) {
                $p95p81 = array();
                $p95p81['nr01'] = pegasus_mysql_newrec('p95p81');
                $p95p81['p95'] = $value;
                $p95p81['p300'] = 1;
                $p95p81['p81'] =  $arr['nr01'];
                pegasus_mysql_insert('p95p81', array_keys($p95p81), array_values($p95p81));
    
                unset($p95p81);
            }
        }
    }

    public function setProfilesWithPrivilege($profiles){
        $this->profiles = $profiles;
    }

}