<?php

/**
 * Τα grid για 
 * case '140000003000001': // Αποτελέσματα αναφοράς
 * case '140000003000002': // Ομαδοποιημένα αποτελέσματα αναφοράς
 */
class QueryDashboardShowReportGrid extends DashboardElement
{
    //private $gridSum;
    public function __construct($params_array)
    {
        parent::__construct($params_array);
        $this->view_type = 'grid';

        $this->p52['padding'] = array('par_val' => "0 5 5 5", 'code' => 0);

        $this->InitializeFromType();

        $this->p52['title'] = array('par_val' => $this->title, 'code' => 0);
        $this->p52['eTitle'] = array('par_val' => $this->eTitle, 'code' => 0);
        $this->p52['disable_auto_load_store'] = array('par_val' => "false", 'code' => 0);
        $this->p52['summary_en'] = array('par_val' => "1", 'code' => 0);

        $this->p52['preventHeader'] = array('par_val' => "false", 'code' => 0);
        $this->p52['header_refresh'] = array('par_val' => "def", 'code' => 0);
    }
    public function create()
    {
        parent::create();
    }
    protected function InitializeFromType()
    {

        if ($this->dashboard00_11_row['dashboard00_12'] == 140000003000001) {
            pegasus_mysql_use('select * from q10 where nr01 = ?', $q10, array($this->dashboard00_11_row['q10_raw']));

            if (!($q10['nr01'] > 0)) {
                throw  new Exception();
            }

            $this->p52['grid_fields'] = array('par_val' => "return query_makeFieldsOfReport('" . $q10['nr01'] . "');", 'code' => 1);
            $this->p52['query'] = array('par_val' => "return dashboard00_query_q10_d901_make_grid_query('" . $q10['nr01'] . "');", 'code' => 1);
            $this->p52['query00'] = array('par_val' => "return query_makeQuery00ArrOfReport_replace_q13('" . $q10['nr01'] . "',array(),1,\$_REQUEST['container_id']);", 'code' => 1);
            $this->p52['query_after'] = array('par_val' => "return query_makeQueryAfterArrOfReport_replace_q13('" . $q10['nr01'] . "',array(),1,\$_REQUEST['container_id']);", 'code' => 1);
            $this->p52['title_array'] = array('par_val' => "return query_makeTitleArrayOfReport('" . $q10['nr01'] . "', '" . $this->name . "');", 'code' => 1);
            $this->p52['record_panafores'] = array('par_val' => "ref", 'code' => 0);
            $this->p52['record_print_forms'] = array('par_val' => "ref", 'code' => 0);
            $this->p52['record_send_mail'] = array('par_val' => "ref", 'code' => 0);
            $this->p52['record_change'] = array('par_val' => "query_q10_d901_itemdblclick(me, '" . $q10['nr01'] . "');", 'code' => 0);
        }

        if ($this->dashboard00_11_row['dashboard00_12'] == 140000003000002) { //Ομαδοποιημένα αποτελέσματα

            pegasus_mysql_use('select * from q10 where nr01 = ?', $q10, array($this->dashboard00_11_row['q10_grouped']));

            if (!($q10['nr01'] > 0)) {
                throw  new Exception();
            }

            $q10_nr01 = $q10['nr01'];

            $grid_fieldsPHP =
                'list($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums) = query_q10_d902_find_titles_fields_sums(\'' . $q10_nr01 . '\',"' . $this->name . '");' . "\n" .
                'return $q10_d902_grid_fields;';
            $grid_titlesPHP =
                'list($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums) = query_q10_d902_find_titles_fields_sums(\'' . $q10_nr01 . '\',"' . $this->name . '");' . "\n" .
                'return $q10_d902_grid_title;';
            $grid_queryPHP =
                'list($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums) = query_q10_d902_find_titles_fields_sums(\'' . $q10_nr01 . '\',"' . $this->name . '");' . "\n" .
                '$q10_d902_grid_query = query_q10_d902_find_query(\'' . $q10_nr01 . '\', $q10_d902_grid_fields);' . "\n" .
                '$q10_d902_grid_query = query_replace_q13_from_array(\'' . $q10_nr01 . '\', $q10_d902_grid_query);' . "\n" .
                'return $q10_d902_grid_query;';
            $grid_initPHP = 
            'list($q10_d902_grid_title, $q10_d902_grid_fields, $columnsSums) = query_q10_d902_find_titles_fields_sums(\'' . $q10_nr01 . '\',"' . $this->name . '");'. "\n" .
            'pegasusSetGlobalVar($container_id. \'_\'.'."'$this->_d'".'.\'_\'.'."'$this->name'".'.\'_grid_fields\', $q10_d902_grid_fields);';

            $this->p52['grid_fields'] =  array('par_val' => $grid_fieldsPHP, 'code' => 1);
            $this->p52['title_array'] =  array('par_val' => $grid_titlesPHP, 'code' => 1);
            $this->p52['query'] =  array('par_val' => $grid_queryPHP, 'code' => 1);
            $this->appendToScreenInitialize($grid_initPHP);

        }
        $this->p52['header_link'] = array('par_val' => "dashboard00_button_open_report(" . $q10['nr01'] . ")", 'code' => 0);

        if (empty($this->title)) {
            $this->title = $q10['p01'];
        }
        if (empty($this->eTitle)) {
            $this->eTitle = $q10['ep01'];
        }
    }
    /**
     * @return true||false
     */
    public function CheckPermission()
    {
        if ($this->dashboard00_11_row['dashboard00_12'] == 140000003000001) {
            $all_table_exist = peg_query_allReportTablesExist($this->dashboard00_11_row['q10_raw']);
            $can_profile_read = peg_query_canProfileRead($this->dashboard00_11_row['q10_raw'], $this->profile);
            return $all_table_exist && $can_profile_read;
        }
        if ($this->dashboard00_11_row['dashboard00_12'] == 140000003000002) { //Ομαδοποιημένα αποτελέσματα
            $all_table_exist = peg_query_allReportTablesExist($this->dashboard00_11_row['q10_grouped']);
            $can_profile_read = peg_query_canProfileRead($this->dashboard00_11_row['q10_grouped'], $this->profile);
            return $all_table_exist && $can_profile_read;
        }
    }
}
