<?php

require_once('../retail00_00/header.php');

$PegInput->addVar(new peg_input_alphanumeric('container_id'));
$PegInput->addVar(new peg_input_number('a55nr01'));
$container_id = $PegInput->getRequest('container_id');
$a55nr01 = $PegInput->getRequest('a55nr01');

$ret_arr = array();
$ret_arr['msg'] = $_SESSION['peg_dic_retail00_01_d06_amount_help'];

$query = 'SELECT * FROM t01 WHERE p302 = :a55nr01';
$queryParams = array('a55nr01' => $a55nr01);
$res = pegasus_query($query, $queryParams);
$msg = '';

$a55p05 = pegasusGetGlobalVar('peg_a55_d-' . $a55nr01 . '_p05');
$totals = invoices_get_total_var('retail00_01', $a55nr01);

// Στοιχεία Ορισμού Παραστατικού
pegasus_mysql_use('SELECT * FROM a10 WHERE p01 = ?', $a10, array($a55p05));
$p_kklo = $a10['p04']; // Κωδικός Κίνησης Λογιστηρίου

// Στοιχεία Κωδικού Κίνησης Λογιστηρίου (του επιλεγμένου παραστατικού)
pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = ? ', $t02, array($p_kklo));
$p_kkxr = $t02['p03']; // Συντελεστής Χρέωσης
$p_kkpi = $t02['p04']; // Συντελεστής Πίστωσης

$p_asyn = 1; // Λογικά εδώ πάντα θα είναι 1, γίνεται -1 όταν αφορά ακύρωση.

$pn02 = 1; // Ισοτιμία
if(isset($totals['pn02']) && $totals['pn02'] > 0) {
    $pn02 = $totals['pn02'];
}
// Σύνολο Παραστατικού
// 23/10/2023 - Υπολογίζω και την ισοτιμία στο σύνολο γιατί τα t01.p03, t01.p04 είναι πάντα σε €. Το p0109 όχι.
$total = ($totals['p0109'] * $p_asyn * $p_kkxr / $pn02) - ($totals['p0109'] * $p_asyn * $p_kkpi / $pn02);

$msg .= '<table><tr>';
$msg .= '<td>' . '<b>' . $_SESSION['peg_dic_retail00_01_d06_invoice_total'] . '</td>';
$msg .= '<td>' . '&nbsp&nbsp&nbsp' . '</td>';
$msg .= '<td>' . '<b>' . number_format($total, 2, $_SESSION['cor000_decimal_char'], $_SESSION['cor000_thousand_char']) .'</b>' . '</td>';
$msg .= '</tr></table>';

$msg .= '<hr>';
$msg .= '<table>';

if(pegasus_num_rows($res) > 0) {
    while($row = pegasus_fetch_assoc($res)) {
        
        $t01_total = ($row['p03']) - ($row['p04']);
        $sign = '-';
        if($t01_total >= 0) {
            $sign = '+';
        }
        $msg .= '<tr>';
        $msg .= '<td>' . $row['p05'] . '</td>';
        $msg .= '<td>' . '&nbsp&nbsp&nbsp&nbsp&nbsp' . '</td>';
        $msg .= '<td>' . '<b>' . $sign . '</b>' . '</td>';
        $msg .= '<td>' . '<b>' .number_format(abs($t01_total), 2, $_SESSION['cor000_decimal_char'], $_SESSION['cor000_thousand_char']) . '</b>' . '</td>';
        $msg .= '</tr>';
        $total = round($total + $t01_total, 2);
    }
}else{
    $msg .= '<tr><td>';
    $msg .= '<i>' . $_SESSION['peg_dic_retail00_01_d06_no_t01'] . '</i>';
    $msg .= '</td></tr>';
}
$msg .= '</table>';
$msg .= '<hr>';

$msg .= '<table><tr>';
$msg .= '<td>' . '<b>' . $_SESSION['peg_dic_retail00_01_d06_invoice_remainder'] . '</td>';
$msg .= '<td>' . '' . '</td>';
$msg .= '<td>' . '<b>' . number_format($total, 2, $_SESSION['cor000_decimal_char'], $_SESSION['cor000_thousand_char']) . '</b>' . '</td>';
$msg .= '</tr></table>';


$ret_arr['msg'] .= $msg;


echo json_encode($ret_arr);