<?php
require_once("../retail00_00/header.php");

$PegInput->addVar(new peg_input_alphanumeric('tbl'));
$PegInput->addVar(new peg_input_number('tbl_nr'));
$PegInput->addVar(new peg_input_number('tbl_p07'));
$PegInput->addVar(new peg_input_number('tbl_pn02'));
$PegInput->addVar(new peg_input_number('total_p0100'));
$PegInput->addVar(new peg_input_number('p0102'));

$pattern = '/^i71_rec_nr01_(\d+)$/';
$i71_rec_values = array();
// Στο request περνάω όλα τα i71_rec_nr01_x, με την παρακάτω foreach τα διαβάζω και τα περνάω στο i71_rec_values.
foreach ($_REQUEST as $key => $value) {
    if (preg_match($pattern, $key, $matches)) {
        $i = $matches[1];
        // $i71_rec_values[$key] = $value;
        $PegInput->addVar(new peg_input_number($key));
        $i71_rec_values[$key] = $PegInput->getRequest($key);
    }
}

$tbl =      $PegInput->getRequest('tbl');
$tbl_nr =   $PegInput->getRequest('tbl_nr');
$tbl_p07 =  $PegInput->getRequest('tbl_p07');
$tbl_pn02 = $PegInput->getRequest('tbl_pn02');
$total_p0100 = $PegInput->getRequest('total_p0100');
$p0102 =    $PegInput->getRequest('p0102');

$ret = array();

$data = retail00_refresh_all_i71($tbl, $tbl_nr, $tbl_p07, $tbl_pn02, $total_p0100, $p0102);
$ret['i71_records'] = $data['i71_records'];

// Φιλτράρω τα i71_records για να πάρω μόνο τα i71_rec_nr01_x
$i71_rec_values_from_db = array_filter($data['i71_records'], function ($key) use ($pattern) {
    return preg_match($pattern, $key);
}, ARRAY_FILTER_USE_KEY);
// Συγκρίνουμε αν τα arrays έχουν διαφορές και από τις δυο πλευρές και κάνουμε merge τις διαφορές τους.
// Note: Η σειρά των arrays παίζει ρόλο στην array_diff_assoc, γι'αυτό ελέγχουμε και με τις δυο πιθανές σειρές και κάνουμε merge.
$i71_rec_diffs_1 = array_diff_assoc($i71_rec_values_from_db, $i71_rec_values);
$i71_rec_diffs_2 = array_diff_assoc($i71_rec_values, $i71_rec_values_from_db);
$i71_rec_diffs   = array_merge($i71_rec_diffs_1, $i71_rec_diffs_2);

// Αν το i71_rec_diffs δεν είναι κενό, έχω διαφορές στα δεδομένα ανάμεσα σε οθόνη και βάση και σετάρω flag για recalc structure.
// Ελέγχω και το empty $data['i71_records] για να μου αδειάσει μετά από clear invoice.

$ret['recalc_structure'] = 0;
if(!empty($i71_rec_diffs) || empty($data['i71_records'])) {
    $ret['recalc_structure'] = 1;
}

echo json_encode($ret);