<?php

class retail00_home_navigation {
    private $container_id;

    private $has_next;
    private $has_prev;
    private $has_home;

    private $last_position; //Εν δυνάμει το offset που θα παίρνουν τα query.
    private $last_position_i00; //Same, but για τα είδη.
    private $last_position_std; //Same, but για τα std actions.
    private $history;


    // private $rows_amount;
    // private $columns_amount;
    private $buttons_min_width;
    private $buttons_min_height;
    private $buttons_amount;
    private $std_actions_amount; // Πλήθος std actions
    
    private $i21;
    private $i22;
    private $i29;
    private $i30;

    private $a01_a55;

    private $only_std_actions;

    public function __construct($params, $no_history_params) {
        // $this->has_home = 1;
        // $this->has_prev = 1;
        // $this->has_next = 1;

        $this->set_container_id($params['container_id']); // Το θέλω για τα ajax.

        $this->set_a01_a55_params($no_history_params);

        // $screen_width = $params['screen_width'];
        // if(empty($params['screen_width'])) {
        //     $screen_width = $_SESSION['retail00_00_p01'];
        // }

        if($no_history_params['refresh'] == 1){
            $params = $this->set_params_last_history();
        }else{
            $this->calc_history($params);
        }

        $this->set_nav_params($params);
        // $this->calc_rows_cols($screen_width);
        $this->calc_buttons($params['memo_width'], $params['memo_height']);
        $this->set_std_actions_amount(0); // Στον constructor τα αρχικοποιώ με 0.
        
        $this->set_only_std_actions(0);
        if(isset($params['only_std_actions']) && $params['only_std_actions'] > 0) {
            $this->set_only_std_actions($params['only_std_actions']);
        }

        // echo '<pre>' .print_r($params, 1). '</pre>';

    }

    public function set_a01_a55_params($no_history_params) {
        $this->a01_a55 = array(
            'a01nr01' => $no_history_params['a01nr01'],
            'a01p45'  => $no_history_params['a01p45'] ,
            'a01p48'  => $no_history_params['a01p48'] ,
            'a01p06'  => $no_history_params['a01p06'] ,
            'a01p52'  => $no_history_params['a01p52'] ,
            'a01p52a' => $no_history_params['a01p52a'],
            'a01p523' => $no_history_params['a01p523'],
            'a55p01'  => $no_history_params['a55p01'] ,
            'a55p703' => $no_history_params['a55p703'],
            'a55p07'  => $no_history_params['a55p07'] 
        );
    }

    public function set_params_last_history() {
        $prev_history = pegasusGetGlobalVar($this->get_container_id() . '_retail00_01_d_history');
        $this->set_history($prev_history); // set_history με το ίδιο γιατί χρειάζομαι το object στα navigation

        $last_history = $prev_history[count($prev_history)-1];

        return $last_history;
    }

    private function calc_history($params) {
        $prev_history = pegasusGetGlobalVar($this->get_container_id() . '_retail00_01_d_history');
        
        if($params['go_home'] == 1) {
            $prev_history = array();
        }

        $history = array();
        if(!empty($prev_history)) {
            foreach($prev_history as $val) {
                $history[] = $val;
            }
        }
       if($params['go_prev'] == 1) {
            array_pop($history);
        }else{
            $history[] = $params;
        }
    
        pegasusSetGlobalVar($this->get_container_id() . '_retail00_01_d_history' , $history);
        // echo '<pre>' .print_r($history, 1). '</pre>';
        $this->set_history($history);
    }

    public function set_nav_params($params) {

        // Αρχικοποιώ το last position (εν δυνάμει offset)
        $this->set_last_position(0);
        if(!empty($params['last_position']) && $params['last_position'] > 0) {
            $this->set_last_position($params['last_position']);
        }

        $this->set_last_position_i00(0);
        if(!empty($params['last_position_i00']) && $params['last_position_i00'] > 0) {
            $this->set_last_position_i00($params['last_position_i00']);
        }

        $this->set_last_position_std(0);
        if(!empty($params['last_position_std']) && $params['last_position_std'] > 0) {
            $this->set_last_position_std($params['last_position_std']);
        }

        if(!isset($params['go_home']) || $params['go_home'] != 1) {
            if(isset($params['i21']) && !empty($params['i21'])) {
                $this->set_i21($params['i21']);
            }
            if(isset($params['i22']) && !empty($params['i22'])) {
                $this->set_i22($params['i22']);
            }
            if(isset($params['i29']) && !empty($params['i29'])) {
                $this->set_i29($params['i29']);
            }
            if(isset($params['i30']) && !empty($params['i30'])) {
                $this->set_i30($params['i30']);
            }
        }

        if( 
            (isset($params['i21']) && !empty($params['i21'])) ||
            (isset($params['only_std_actions']) && $params['only_std_actions'] == 1) ||
            (($this->get_last_position() > 0) || 
             ($this->get_last_position_std() >0))
        ) {
            $this->set_has_home(1);
            $this->set_has_prev(1);
        }
    }

    /**
     * Υπολογίζει τα rows και columns βάσει του screen width, από τις Βασικές Παραμέτρους.
     * @param int $screen_width - Πλάτος Οθόνης
     */
    // public function calc_rows_cols($screen_width = 0) {
    //     //* Βασικές Παράμετροι Τερματικού.
    //     pegasus_mysql_use('SELECT * FROM retail00_04 WHERE cor003p01 = ?', $client_params, array($_SESSION['pegasus_client_uid']));
    //     if(!empty($client_params)) {
    //         $rows_amount    = $client_params['p02'];
    //         $columns_amount = $client_params['p03'];
    //         // Αρχικοποιεί με Γραμμές 1 και Στήλες 1 και μετά υπολογίζει.
    //         if(($screen_width <= $client_params['p04']) && $screen_width > $client_params['p07']) {
    //             $rows_amount    = $client_params['p05'];
    //             $columns_amount = $client_params['p06'];
    //         }elseif(($screen_width <= $client_params['p07'])) {
    //             $rows_amount    = $client_params['p08'];
    //             $columns_amount = $client_params['p09'];
    //         }
    //     }else{
    //         $rows_amount    = $_SESSION['retail00_00_p02'];
    //         $columns_amount = $_SESSION['retail00_00_p03'];
    //         // Αρχικοποιεί με Γραμμές 1 και Στήλες 1 και μετά υπολογίζει.
    //         if(($screen_width <= $_SESSION['retail00_00_p04']) && $screen_width > $_SESSION['retail00_00_p07']) {
    //             $rows_amount    = $_SESSION['retail00_00_p05'];
    //             $columns_amount = $_SESSION['retail00_00_p06'];
    //         }elseif(($screen_width <= $_SESSION['retail00_00_p07'])) {
    //             $rows_amount    = $_SESSION['retail00_00_p08'];
    //             $columns_amount = $_SESSION['retail00_00_p09'];
    //         }
    //     }


    //     $this->set_rows_amount($rows_amount);
    //     $this->set_columns_amount($columns_amount);
    // }

    /**
     * Υπολογίζει τα rows και columns βάσει του memo width και memo height δυναμικά.
     * @param int $memo_width - Πλάτος Memo
     * @param int $memo_height - Ύψος Memo
     */
    public function calc_buttons($memo_width, $memo_height) {
        pegasus_mysql_use(
            'SELECT p01, p02 FROM retail00_04 WHERE cor003p01 = ?', 
            $client_params, 
            array($_SESSION['pegasus_client_uid'])
        );
        if(!empty($client_params)) {
            // Ελάχιστο Πλάτος Κουμπιού
            $but_min_width  = $client_params['p01'];
            // Ελάχιστο Ύψος Κουμπιού
            $but_min_height = $client_params['p02'];
        }else{
            // Ελάχιστο Πλάτος Κουμπιού
            $but_min_width  = $_SESSION['retail00_00_p01'];
            // Ελάχιστο Ύψος Κουμπιού
            $but_min_height = $_SESSION['retail00_00_p02'];
        }
        //if empty default 200
        $but_min_width  = (!empty($but_min_width) ? $but_min_width : 200);
        $but_min_height = (!empty($but_min_height) ? $but_min_height : 200);

        //if less than 100, set to 100
        $but_min_width  = ($but_min_width > 100 ? $but_min_width : 100);
        $but_min_height = ($but_min_height > 100 ? $but_min_height : 100);
        // $this->set_buttons_min_width($but_min_width);
        // $this->set_buttons_min_height($but_min_height);
        
        $memo_width = $memo_width - 10; // Parent total padding
        $memo_height = $memo_height - 10; // Parent total padding

        $horizontalButs = floor($memo_width / $but_min_width);
        $verticalButs = floor($memo_height / $but_min_height);

        // Εδώ πειράζω το width και το height για να γεμίζει το κενό που πιθανώς δημιουργείται
        $but_min_width = floor($memo_width / $horizontalButs); 
        $but_min_height = floor($memo_height / $verticalButs); 

        $this->set_buttons_min_width($but_min_width);
        $this->set_buttons_min_height($but_min_height);

        // Σύνολο Κουμπιών που χωράνε στο memo.
        $total_buttons = $horizontalButs * $verticalButs;
        $this->set_buttons_amount($total_buttons);
    }

    /**
     * Φτιάχνει την HTML για τα buttons μαζί με το style.
     * @param array $params
     * @return string $ret - Style + HTML.
     */
    public function make_html($params = array()) {

        // $rows_amount    = $this->get_rows_amount();
        // $columns_amount = $this->get_columns_amount();
        $buttons_amount = $this->get_buttons_amount();

        $button_min_width = $this->get_buttons_min_width();
        $button_min_height = $this->get_buttons_min_height();

        // Removed flex-grow: 1 from .retail00_home_buttons.
        $style = '
            <style>
                .retail00_home_buttons_container {
                    text-align: left;
                }
                .retail00_home_rows {
                    width: 100%;
                    display: flex;
                    flex-wrap: wrap;
                }
                .retail00_home_buttons {
                    background-color: #efefef;
                    color: #4c4c4c;
                    width: '.$button_min_width.'px;
                    height: '.$button_min_height.'px;
                    box-sizing: border-box;
                    border: 2px solid white;
                    text-align: center;
                    padding: 15px 7px;
                    font-weight: normal;
                    font-size: 13px;
                    cursor: pointer;
                    
                    
                    display: flex;
                    flex-direction: column;
                    align-content: center;
                    justify-content: space-evenly;
                    

                    .retail00_home_buttons_clsize {
                        font-size: 11px;
                    }
                    .retail00_home_buttons_price {
                        font-weight: bold;
                        font-size: 15px;
                    }
                    .retail00_home_buttons_home{
                        .fa {
                            display: block;
                            font-size: 20px;
                        }
                    }
                    .retail00_home_buttons_prev{
                        .fa {
                            display: block;
                            font-size: 20px;
                        }
                    }
                    .retail00_home_buttons_next {
                        .fa {
                            display: block;
                            font-size: 20px;
                        }
                    }
                    &.home {
                        background-color: #dfffe2;
                    }
                    &.prev {
                        background-color: #b6e9fb;
                    }
                    &.next {
                        background-color: #b6e9fb;
                    }
                    &.group {
                        background-color: #fffce0;
                    }
                    &.blank {
                        opacity: 0.5;
                        cursor: not-allowed;
                    }
                    &.std_action {
                        background-color: #dfffe2;
                    }
                    &:hover {
                        -webkit-filter: brightness(97%);
                    }
                    &:active {
                        transform: scale(0.93);
                        -webkit-filter: brightness(92%);
                    }
                }
            </style>
        ';
        $html = '<div class="retail00_home_buttons_container">';
        $actions = $this->make_actions();
        $rows = '';
        // foreach (array_chunk($actions, $columns_amount, true) as $row) {
        $rows .= '<div class="retail00_home_rows">';
        foreach ($actions as $key => $value) {
            $button_style = '';
            if(!empty($value['font'])) {
                $button_style .= "color: #" . $value['font'] . ";";
            }
            if(!empty($value['bg'])) {
                $button_style .= " background-color: #" . $value['bg'] . ";";
            }
            $extra_class = '';
            if(isset($value['extra_class']) && !empty($value['extra_class'])) {
                $extra_class = $value['extra_class'];
            }
            $icon = '';
            if(!empty($value['icon'])) {
                $icon = '<i class="'.$value['icon'].'" style="font-size: 20px;"></i>';
            }
            $rows .= '<div class="retail00_home_buttons '.$extra_class.'" id="button_'.$key.'" style="'.$button_style.'" onclick="'.$value['handler'].'">' .$icon. $value['text'] . '</div>';
            
            //* Placeholder handler αν δεν κάνει κάτι το κουμπί.
            $rows = str_replace('##handler##', 'pegAlert(this.innerText)', $rows);
            //* Placeholder text αν δεν είναι κενό.
            $rows = str_replace('##inner_text##', 'Button '.$key, $rows);
        }
        $rows .= '</div>';
        // }
        $html .= $rows;
        $html .= '</div>';

        $ret = $style . $html;
        return $ret;
    }

        /**
     * Επιστρέφει τον πίνακα με όλα τα buttons.
     * @return array $actions
     */
    public function make_actions() {
        // $buttons_amount = $this->get_rows_amount() * $this->get_columns_amount();
        $buttons_amount = $this->get_buttons_amount();
        $actions = array();
        $std_actions = array();
        $groups_products_actions = array();
        $nav_actions = array();
        // $actions = array_fill(0, $buttons_amount, '##inner_text##');
        // $actions = array_fill(0, $buttons_amount, array('font' => '', 'bg' => '', 'text' => '##inner_text##', 'handler' => '##handler##'));
        $actions_amount = 0;
        //* Φτιάχνω πρώτα τα std actions για να σεταριστεί το πλήθος τους. Αν δεν είμαι σε home 
        $std_actions = $this->make_std_actions();
        if($this->get_only_std_actions() != 1) {
            //* Μετά τις ομάδες/προϊόντα για να έχω, ή όχι, το next 
            $groups_products_actions = $this->make_groups_products_actions();
        }
        //* Και τέλος τα nav
        $nav_actions = $this->make_nav_actions();

        //* Αν έχω next, το βγάζω από τα nav actions και το βάζω στο τέλος.
        // $nav_actions_next = array();
        // foreach ($nav_actions as $key => $value) {
        //     if ($value['extra_class'] === "next") {
        //         $nav_actions_next[] = $value;
        //         unset($nav_actions[$key]);
        //     }
        // }
        // $nav_actions = array_values($nav_actions); // Reindex

        // $actions = array_merge($nav_actions, $groups_products_actions, $std_actions, $nav_actions_next);
        $actions = array_merge($nav_actions, $groups_products_actions, $std_actions);

        // echo $this->get_last_position() . ' - ' . $this->get_last_position_i00() . ' - ' . $this->get_has_next();

        return $actions;
    }

    public function make_nav_actions() {
        $actions = array();
        $action_key = 0;
        if ($this->get_has_home() == 1) {
            $handler_params = array();
            $handler_params['container_id'] = $this->get_container_id();
            $handler_params['go_home'] = 1;

            $actions[$action_key]['text']    = '<div class="retail00_home_buttons_home">
                                                    <i class="fa fa-home" aria-hidden="true"></i>
                                                    Αρχική
                                                </div>';
            $actions[$action_key]['handler'] = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
            $actions[$action_key]['extra_class'] = 'home';
            $action_key++;
        }
        if ($this->get_has_prev() == 1) {
            $handler_params = array();
            $handler_params['container_id'] = $this->get_container_id();
            $handler_params['go_prev'] = 1; //TODEL?
            $history = $this->get_history();
            $prev_page = $history[count($history)-2];
            
            $handler_params['i21'] = $prev_page['i21'];
            $handler_params['i22'] = $prev_page['i22'];
            $handler_params['i29'] = $prev_page['i29'];
            $handler_params['i30'] = $prev_page['i30'];
            $handler_params['has_next'] = $prev_page['has_next'];
            $handler_params['has_home'] = $prev_page['has_home'];
            $handler_params['has_prev'] = $prev_page['has_prev'];
            $handler_params['last_position'] = $prev_page['last_position'];
            $handler_params['last_position_i00'] = $prev_page['last_position_i00'];
            $handler_params['last_position_std'] = $prev_page['last_position_std'];
            $handler_params['only_std_actions']  = $prev_page['only_std_actions'];
            

            $actions[$action_key]['text']    = '<div class="retail00_home_buttons_prev">
                                                    <i class="fa fa-arrow-left" aria-hidden="true"></i>
                                                    Προηγούμενο
                                                </div>';
            $actions[$action_key]['handler'] = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
            $actions[$action_key]['extra_class'] = 'prev';
            $action_key++;
        }
        if ($this->get_has_next() == 1) {
            $handler_params = array();
            $handler_params['container_id'] = $this->get_container_id();
            $handler_params['go_next'] = 1;
            $handler_params['i21'] = $this->get_i21();
            $handler_params['i22'] = $this->get_i22();
            $handler_params['i29'] = $this->get_i29();
            $handler_params['i30'] = $this->get_i30();
            $handler_params['last_position'] = $this->get_last_position();
            $handler_params['last_position_i00'] = $this->get_last_position_i00();
            $handler_params['last_position_std'] = $this->get_last_position_std();
            $handler_params['only_std_actions']  = $this->get_only_std_actions();

            $actions[$action_key]['text']    = '<div class="retail00_home_buttons_next">
                                                    <i class="fa fa-arrow-right" aria-hidden="true"></i>
                                                    Επόμενο
                                                </div>';
            $actions[$action_key]['handler'] = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
            $actions[$action_key]['extra_class'] = 'next';
            $action_key++;
        }

        return $actions;
    }

    public function make_std_actions() {
        $actions = array();

        if(    (!empty($this->get_i21())
             || !empty($this->get_i22())
             || !empty($this->get_i29())
             || !empty($this->get_i30())) && $_SESSION['retail00_00_p06'] != 1
        ) {
            return $actions;
        }

        $std_actions_queryParams = array('termatiko' => $_SESSION['pegasus_client_uid']);
        pegasus_mysql_use('SELECT count(*) as cnt FROM retail00_05 WHERE cor003p01 = :termatiko', $ana_termatiko, $std_actions_queryParams);
        if($ana_termatiko['cnt'] == 0) {
            //* Αν δεν βρω εγγραφές στο retail00_05 για το ενεργό τερματικό μου, κάνω την παράμετρο '' για να διαβάσω από τις γενικές Βασικές Παραμέτρους
            $std_actions_queryParams['termatiko'] = '';
        }
        $limit = " LIMIT " . $this->get_last_position_std() . " , " . ($this->get_buttons_amount()+1);

        
        if($_SESSION['retail00_00_p06'] == 1 && $this->get_only_std_actions() != 1){
            $limit = " LIMIT " . ($this->get_buttons_amount()+1);
        }

        $std_actions_query = "  SELECT 
                                    retail00_05.p01 as font,
                                    retail00_05.p02 as bg,
                                    retail00_05.p04 as p04,
                                    retail00_05.i00pno as i00pno,
                                    retail00_05.a10 as a10,
                                    retail00_05.p85 as p85,

                                    retail00_03.p00 as p00,
                                    retail00_03.p01 as p01,
                                    if(retail00_05.p06<>'', retail00_05.p06, retail00_03.p02) as p02,
                                    if(retail00_05.p07<>'', retail00_05.p07, retail00_03.p03) as p03,
                                    if(retail00_05.p05<>'', retail00_05.p05, retail00_03.p05) as icon,
                                    retail00_03.nr01 as retail00_03
                                FROM retail00_05
                                LEFT JOIN retail00_03 on retail00_05.retail00_03 = retail00_03.nr01
                                WHERE 
                                    cor003p01 = :termatiko
                                    -- (cor003p01 = :termatiko 
                                    -- OR (    cor003p01 = '' AND 
                                    --         retail00_03 NOT IN (SELECT retail00_03 FROM retail00_05 WHERE cor003p01 = :termatiko))
                                    -- )
                                    AND (retail00_05.p03 = 0 OR retail00_05.p03 = 1)
                                ORDER by retail00_05.tax, retail00_05.nr01
                                " . $limit
        ;

        if($this->get_only_std_actions() == 1) {
            //? group_by_condition ---> Το ΜΚ του retail00_03 - Αν έχω π-αναφορά ή προσθήκη είδους, concat και το ΜΚ της για να μου τις φέρνει όλες αλλιώς έφερνε μόνο μια.
            $std_actions_query = "SELECT * FROM
                                    (SELECT retail00_05.p01 as font,
                                            retail00_05.p02 as bg,
                                            retail00_05.p04 as p04,
                                            retail00_05.i00pno as i00pno,
                                            retail00_05.a10 as a10,
                                            retail00_05.p85 as p85,

                                            retail00_03.p00 AS p00,
                                            retail00_03.p01 AS p01,
                                            if(retail00_05.p06<>'', retail00_05.p06, retail00_03.p02) as p02,
                                            if(retail00_05.p07<>'', retail00_05.p07, retail00_03.p03) as p03,
                                            if(retail00_05.p05<>'', retail00_05.p05, retail00_03.p05) as icon,
                                            retail00_03.nr01 AS retail00_03,
                                            retail00_03.tax AS tax,
                                            if(retail00_05.p04 > 0, concat(retail00_03.nr01, retail00_05.p04, retail00_05.i00pno), retail00_03.nr01) as group_by_condition
                                    FROM retail00_03
                                    LEFT JOIN retail00_05 ON retail00_03.nr01 = retail00_05.retail00_03 AND retail00_05.cor003p01 = :termatiko
                                    WHERE retail00_03.nr01 <> 140000146000009
                                        AND retail00_03.p04 = 0 OR (retail00_03.p04 = 1 AND retail00_05.p04 > 0) OR (retail00_03.p04 = 2 AND retail00_05.i00pno <> '')
                                    
                                    UNION 
                                    SELECT  '' as font,
                                            '' as bg,
                                            '' as p04,
                                            '' as i00pno,
                                            '' as a10,
                                            '' as p85,

                                            retail00_03.p00 AS p00,
                                            retail00_03.p01 AS p01,
                                            retail00_03.p02 AS p02,
                                            retail00_03.p03 AS p03,
                                            retail00_03.p05 AS icon,
                                            retail00_03.nr01 AS retail00_03,
                                            retail00_03.tax AS tax,
                                            retail00_03.nr01 as group_by_condition
                                    FROM retail00_03
                                    WHERE retail00_03.nr01 <> 140000146000009
                                        AND retail00_03.p04 = 0 ) AS ttt
                                    GROUP BY group_by_condition
                                    ORDER BY tax,
                                            retail00_03
                                    " . $limit;
        }
        // echo '<pre>' .pegasus_replace_values_in_sql($std_actions_query, $std_actions_queryParams). '</pre>';
        $res = pegasus_query($std_actions_query, $std_actions_queryParams);
        //Κρατάω το count των std_actions
        
        $has_overflow = 0;
        if(pegasus_num_rows($res) > $this->get_buttons_amount()) {
            $has_overflow = 1;
            $this->set_std_actions_amount($this->get_buttons_amount());
        }else{
            $this->set_std_actions_amount(pegasus_num_rows($res));
        }
        $actions_max = $this->get_buttons_amount(); 

        if($this->get_last_position_std() > 0
            || ($this->get_only_std_actions() > 0 && $this->get_std_actions_amount()+$this->get_has_prev()+$this->get_has_home() > $actions_max)
        ) {
            $this->set_has_prev(1);
            $this->set_has_home(1);
            $actions_max = $actions_max - 2;
        }
        // Σύνθετη if για να καλύπτει όλες τις ακραίες περιπτώσεις.
        if(($this->get_std_actions_amount() >= $actions_max && $this->get_only_std_actions() == 0)
            || ($this->get_only_std_actions() > 0 
            &&  (
                    (($this->get_std_actions_amount() == $actions_max) && ($this->get_std_actions_amount()+$this->get_has_prev()+$this->get_has_home() > $actions_max) )
                    || $has_overflow == 1
                ) )
        ) {
            $this->set_has_next(1);
            $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" 
        }
        $action_key = 0;

        while ($row = pegasus_fetch_assoc($res)) {
            if($action_key == $actions_max || $actions_max < 0) {
                break;
            }

            $actions[$action_key]['extra_class']    = 'std_action';
            $actions[$action_key]['font']    = $row['font'];
            $actions[$action_key]['bg']      = $row['bg'];
            $actions[$action_key]['text']    = $row['p02'];
            $actions[$action_key]['icon']    = $row['icon'];
            if($_SESSION['lang'] != 'GR') {
                $actions[$action_key]['text'] = $row['p03'];
            }
            // Container id, Κωδικός std action, Module std action
            $handler_params =  $this->get_container_id() ."', ". $row['p00'] .", '" . $row['p01'];
            if(!empty($row['p04'])) {
                // Αν έχει π-Αναφορά
                $handler_params =  $this->get_container_id() ."', ". $row['p00'] .", '" . $row['p01'] . "', '" . $row['p04'];
                pegasus_mysql_use('SELECT p01, ep01 FROM q10 WHERE nr01 = :q10_nr01', $q10, array('q10_nr01' => $row['p04']));
                if($_SESSION['lang'] == 'GR') {
                    // $actions[$action_key]['text'] .= '<br>' . $q10['p01'];
                    $actions[$action_key]['text'] = $q10['p01'];
                }else{
                    // $actions[$action_key]['text'] .= '<br>' . $q10['ep01'];
                    $actions[$action_key]['text'] =  $q10['ep01'];
                }
            }

            if(!empty($row['a10'])) {
                // Αν έχει τυπο παραστατικού
                $handler_params =  $this->get_container_id() ."', ". $row['p00'] .", '" . $row['p01'] . "', '', '', '', '" . $row['a10'];
                pegasus_mysql_use('SELECT p02, ep02 FROM a10 WHERE p01 = :a10_nr01', $a10, array('a10_nr01' => $row['a10']));
                if($_SESSION['lang'] == 'GR') {
                    $actions[$action_key]['text'] .= ':<br>' . $a10['p02'];
                }else{
                    $actions[$action_key]['text'] .= ':<br>' . $a10['ep02'];
                }
            }
            if(!empty($row['p85'])) {
                // Αν έχει τυπο παραστατικού
                $handler_params =  $this->get_container_id() ."', ". $row['p00'] .", '" . $row['p01'] . "', '', '', '', '', '" . $row['p85'];
                pegasus_mysql_use('SELECT p01, ep01 FROM p85 WHERE nr01 = :p85_nr01', $p85, array('p85_nr01' => $row['p85']));
                if($_SESSION['lang'] == 'GR') {
                    $actions[$action_key]['text'] .= ':<br>' . $p85['p01'];
                }else{
                    $actions[$action_key]['text'] .= ':<br>' . $p85['ep01'];
                }
            }
            if(!empty($row['i00pno'])) {
                // Αν έχει προσθήκη είδους
                $a01_a55 = $this->get_a01_a55_params();
                $price_arr = inventory_find_price(
                    $row['i00pno'], 
                    $a01_a55['a01nr01'], 
                    1, 
                    $a01_a55['a55p01'],
                    $a01_a55['a01p45'], // Καθεστώς ΦΠΑ
                    'a01', // mode
                    $a01_a55['a55p07'], // Τιμές με ΦΠΑ
                    $a01_a55['a55p703'], // Αποθήκη
                    $a01_a55['a01p48'], // Βασικός Τιμοκατάλογος
                    $a01_a55['a01p06'], // Ειδικός Τιμοκατάλογος
                    $a01_a55['a01p52'], // % Έκπτωση 1
                    $a01_a55['a01p52a'],// % Έκπτωση 2
                    $a01_a55['a01p523'] // Επιπλέον % Έκπτωσης
                );
                pegasus_mysql_use('SELECT p616, p616p FROM i00 WHERE pno = :i00pno', $i00_p616_data, array('i00pno' => $row['i00pno']));
                $v616 = invoices_calculate_EFK('',$price_arr['price'],$price_arr['discount_1'],$price_arr['discount_2'],$price_arr['fpa'],$price_arr['preview_wthfpa'],$i00_p616_data['p616'],$i00_p616_data['p616p']);
                $i00_total  = invoices_make_product_total(
                    1, //posotita
                    $price_arr['price'],
                    $price_arr['fpa'],
                    $price_arr['discount_1'],
                    $price_arr['discount_2'],
                    $price_arr['eisfora_anakyklosis'],
                    $v616,
                    $price_arr['preview_wthfpa'],
                    0,
                    $_SESSION['inventory_000_p07']
                );

                // $price_arr['price'] = peg002_format_number($price_arr['price'], $_SESSION['inventory_000_p07'], 1);
                $i00_total = peg002_format_number($i00_total, $_SESSION['inventory_000_p07'], 1);
                $price_text = "<div class='retail00_home_buttons_price'>" . $i00_total . "€</div>";
                
                $handler_params =  $this->get_container_id() ."', ". $row['p00'] .", '" . $row['p01'] . "', '', '', '" . $row['i00pno'];
                pegasus_mysql_use('SELECT name, ename FROM i00 WHERE pno = :i00pno', $i00, array('i00pno' => $row['i00pno']));
                if($_SESSION['lang'] == 'GR') {
                    $actions[$action_key]['text'] = $i00['name'] . "<br>" . $price_text;
                }else{
                    $actions[$action_key]['text'] = $i00['ename'] . "<br>" . $price_text;
                }
            }
            $actions[$action_key]['handler'] = "retail00_std_action('" . $handler_params . "')";
            
            $action_key++;
        }

        $last_position_std = $this->get_last_position_std() + $action_key;
        $this->set_last_position_std($last_position_std);

        return $actions;
    }
    public function make_groups_products_actions() {
        // $buttons_amount = $this->get_rows_amount() * $this->get_columns_amount();
        $buttons_amount = $this->get_buttons_amount();
        $actions = array();

        $i00_query_where = "";
        $i00_queryParams = array();
        if(!empty($this->get_i21())) {
            $i00_queryParams['i21'] = $this->get_i21();
            $i00_query_where .= " AND i00.p9901 = :i21 ";
        }
        if(!empty($this->get_i22())) {
            $i00_queryParams['i22'] = $this->get_i22();
            $i00_query_where .= " AND i00.p9902 = :i22 ";
        }
        if(!empty($this->get_i29())) {
            $i00_queryParams['i29'] = $this->get_i29();
            $i00_query_where .= " AND i00.p910 = :i29 ";
        }
        if(!empty($this->get_i30())) {
            $i00_queryParams['i30'] = $this->get_i30();
            $i00_query_where .= " AND i00.p911 = :i30 ";
        }
        $i00_clsize_select  = "";             
        $i00_clsize_join    = "";
        $i00_clsize_order   = "";
        if(pegasus_module_exists('colorsize')) {
            $i00_clsize_select  = ",i47.p02 as i47_p02,
                                    i47.p03 as i47_p03,
                                    ";
            if($_SESSION['lang'] == 'GR') {
                $i00_clsize_select .= " i40.p02 as i40_p02,
                                        i43.p02 as i43_p02 ";
            }else{
                $i00_clsize_select .= " i40.ep02 as i40_p02,
                                        i43.ep02 as i43_p02 ";
            }

            $i00_clsize_join    = " LEFT JOIN i47 AS i47 ON i47.p01=i00.pno AND i47.nr01>-1 
                                    LEFT JOIN i40 AS i40 ON i47.p02=i40.p01
                                    LEFT JOIN i43 AS i43 ON i47.p03=i43.p01";
            $i00_clsize_order   = " ,i47.px01, i47.pm01 ";
        }
        $a01_a55 = $this->get_a01_a55_params();
                
        $action_key = 0;
        $actions_max = $this->calc_actions_max();
        $last_position = $this->get_last_position();

        //* Start Ομάδες
        if(empty($this->get_i21())) {
            // offset = last position, limit = πόσα κουμπιά εμφανίζω (συνολικά).
            $limit = " LIMIT " . $this->get_last_position() . " , " . $buttons_amount;
            $i21_query = "SELECT * FROM i21 WHERE i21.tax > -1 ORDER BY tax, p00 " . $limit;
            // print($i21_query);
            $actions_max = $this->calc_actions_max();
            $res = pegasus_query($i21_query);
            $group_count = pegasus_num_rows($res);
            if($group_count > $actions_max) {
                $this->set_has_next(1);
                $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" ///* Δεν είναι πολύ clean.
            }
            if($this->get_has_next() == 0) {
                // Αν δεν έχω ήδη next και έχω αρχίσει να εκτυπώνω προϊόντα.
                pegasus_mysql_use("SELECT count(*) as cnt FROM i00 WHERE 1=1 " . $i00_query_where, $group_i00_cnt, $i00_queryParams);
                if($group_i00_cnt['cnt']+$group_count > $actions_max) {
                    $this->set_has_next(1);
                    $actions_max = $actions_max - 1;
                }
            }
            // echo $action_key;
            // echo $actions_max;
            while ($row = pegasus_fetch_assoc($res)) {
                if($action_key == $actions_max || $actions_max < 0) {
                    break;
                }
                $handler_params = array();
                $handler_params['container_id'] = $this->get_container_id();
                $handler_params['i21'] = $row['nr01'];
                $handler_params['has_next'] = $this->get_has_next();

                $actions[$action_key]['extra_class']  = 'group';
                $actions[$action_key]['font']      = $row['pcf01_cl'];
                $actions[$action_key]['bg']        = $row['pcb01_cl']; 
                if(!empty($row['pct01'])) {
                    $title = $row['pct01'];
                }else{
                    $title = $row['p00'];
                }
                $actions[$action_key]['text']      = $title;
                $actions[$action_key]['handler']   = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
                if($_SESSION['lang'] != 'GR') {
                    $actions[$action_key]['text'] = $row['p04'];
                }
                $action_key++;
            }
            // Η τελευταία θέση εκτύπωσης
            
            // π.χ. Αν $actions_max = 27, τότε το last_position μπορεί να είναι 27 ή μικρότερο.
            $last_position = $this->get_last_position() + $action_key;
            $this->set_last_position($last_position); //! Δεν είμαι σίγουρος για αυτό. Νομίζω θα παίξει με την κατάλληλη αλλαγή στα είδη.
        }

        //* End Ομάδες
        //* Start Υποομάδες
        if(!empty($this->get_i21()) && empty($this->get_i22())) {
            // offset = last position, limit = πόσα κουμπιά εμφανίζω (συνολικά).
            $limit = " LIMIT " . $this->get_last_position() . " , " . $buttons_amount;
            $i22_query = "SELECT * FROM i22 WHERE p01 = :i21 AND i22.tax > -1 ORDER BY tax, p00 " . $limit;
            $i22_queryParams = array('i21' => $this->get_i21());

            $actions_max = $this->calc_actions_max();
            $res = pegasus_query($i22_query, $i22_queryParams);
            $group_count = pegasus_num_rows($res);
            if($group_count > $actions_max) {
                $this->set_has_next(1);
                $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" ///* Δεν είναι πολύ clean.
            }
            if($this->get_has_next() == 0) {
                // Αν δεν έχω ήδη next και έχω αρχίσει να εκτυπώνω προϊόντα.
                pegasus_mysql_use("SELECT count(*) as cnt FROM i00 WHERE 1=1 " . $i00_query_where, $group_i00_cnt, $i00_queryParams);
                if($group_i00_cnt['cnt']+$group_count > $actions_max) {
                    $this->set_has_next(1);
                    $actions_max = $actions_max - 1;
                }
            }
            while ($row = pegasus_fetch_assoc($res)) {
                if($action_key == $actions_max || $actions_max < 0) {
                    break;
                }
                $handler_params = array();
                $handler_params['container_id'] = $this->get_container_id();
                $handler_params['i21'] = $this->get_i21();
                $handler_params['i22'] = $row['nr01'];
                $handler_params['has_next'] = $this->get_has_next();
                // $handler_params['history'] = $this->get_history();

                $actions[$action_key]['extra_class']  = 'group';
                $actions[$action_key]['font']      = $row['pcf01_cl'];
                $actions[$action_key]['bg']        = $row['pcb01_cl'];
                if(!empty($row['pct01'])) {
                    $title = $row['pct01'];
                }else{
                    $title = $row['p00'];
                }
                $actions[$action_key]['text']      = $title;
                $actions[$action_key]['handler']   = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
                if($_SESSION['lang'] != 'GR') {
                    $actions[$action_key]['text'] = $row['p05'];
                }
                $action_key++;
            }
            // Η τελευταία θέση εκτύπωσης
            
            // π.χ. Αν $actions_max = 27, τότε το last_position μπορεί να είναι 27 ή μικρότερο.
            $last_position = $this->get_last_position() + $action_key;
            $this->set_last_position($last_position); //! Δεν είμαι σίγουρος για αυτό. Νομίζω θα παίξει με την κατάλληλη αλλαγή στα είδη.
        }
        //* End Υποομάδες

        //* Start Οικογένειες
        if(!empty($this->get_i22()) && empty($this->get_i29())) {
            // offset = last position, limit = πόσα κουμπιά εμφανίζω (συνολικά).
            $limit = " LIMIT " . $this->get_last_position() . " , " . $buttons_amount;
            $i29_query = "SELECT * FROM i29 WHERE p01 = :i22 AND i29.tax > -1 ORDER BY tax, p00 " . $limit;
            $i29_queryParams = array('i22' => $this->get_i22());

            $actions_max = $this->calc_actions_max();
            $res = pegasus_query($i29_query, $i29_queryParams);
            $group_count = pegasus_num_rows($res);
            if($group_count > $actions_max) {
                $this->set_has_next(1);
                $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" ///* Δεν είναι πολύ clean.
            }
            if($this->get_has_next() == 0) {
                // Αν δεν έχω ήδη next και έχω αρχίσει να εκτυπώνω προϊόντα.
                pegasus_mysql_use("SELECT count(*) as cnt FROM i00 WHERE 1=1 " . $i00_query_where, $group_i00_cnt, $i00_queryParams);
                if($group_i00_cnt['cnt']+$group_count > $actions_max) {
                    $this->set_has_next(1);
                    $actions_max = $actions_max - 1;
                }
            }
            while ($row = pegasus_fetch_assoc($res)) {
                if($action_key == $actions_max || $actions_max < 0) {
                    break;
                }
                $handler_params = array();
                $handler_params['container_id'] = $this->get_container_id();
                $handler_params['i21'] = $this->get_i21();
                $handler_params['i22'] = $this->get_i22();
                $handler_params['i29'] = $row['nr01'];
                $handler_params['has_next'] = $this->get_has_next();
                // $handler_params['history'] = $this->get_history();

                $actions[$action_key]['extra_class']  = 'group';
                $actions[$action_key]['font']      = $row['pcf01_cl'];
                $actions[$action_key]['bg']        = $row['pcb01_cl'];
                if(!empty($row['pct01'])) {
                    $title = $row['pct01'];
                }else{
                    $title = $row['p00'];
                }
                $actions[$action_key]['text']      = $title;
                $actions[$action_key]['handler']   = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
                if($_SESSION['lang'] != 'GR') {
                    $actions[$action_key]['text'] = $row['p05'];
                }
                $action_key++;
            }
            // Η τελευταία θέση εκτύπωσης
            
            // π.χ. Αν $actions_max = 27, τότε το last_position μπορεί να είναι 27 ή μικρότερο.
            $last_position = $this->get_last_position() + $action_key;
            $this->set_last_position($last_position); //! Δεν είμαι σίγουρος για αυτό. Νομίζω θα παίξει με την κατάλληλη αλλαγή στα είδη.
        }
        //* End Οικογένειες

        //* Start Υπο-Οικογένειες
        if(!empty($this->get_i29()) && empty($this->get_i30())) {
            // offset = last position, limit = πόσα κουμπιά εμφανίζω (συνολικά).
            $limit = " LIMIT " . $this->get_last_position() . " , " . $buttons_amount;
            $i30_query = "SELECT * FROM i30 WHERE p01 = :i29 AND i30.tax > -1 ORDER BY tax, p00 " . $limit;
            $i30_queryParams = array('i29' => $this->get_i29());

            $actions_max = $this->calc_actions_max();
            $res = pegasus_query($i30_query, $i30_queryParams);
            $group_count = pegasus_num_rows($res);
            if($group_count > $actions_max) {
                $this->set_has_next(1);
                $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" ///* Δεν είναι πολύ clean.
            }
            if($this->get_has_next() == 0) {
                // Αν δεν έχω ήδη next και έχω αρχίσει να εκτυπώνω προϊόντα.
                pegasus_mysql_use("SELECT count(*) as cnt FROM i00 WHERE 1=1 " . $i00_query_where, $group_i00_cnt, $i00_queryParams);
                if($group_i00_cnt['cnt']+$group_count > $actions_max) {
                    $this->set_has_next(1);
                    $actions_max = $actions_max - 1;
                }
            }
            while ($row = pegasus_fetch_assoc($res)) {
                if($action_key == $actions_max || $actions_max < 0) {
                    break;
                }
                $handler_params = array();
                $handler_params['container_id'] = $this->get_container_id();
                $handler_params['i21'] = $this->get_i21();
                $handler_params['i22'] = $this->get_i22();
                $handler_params['i29'] = $this->get_i29();
                $handler_params['i30'] = $row['nr01'];
                $handler_params['has_next'] = $this->get_has_next();
                
                $actions[$action_key]['extra_class']  = 'group';
                $actions[$action_key]['font']      = $row['pcf01_cl'];
                $actions[$action_key]['bg']        = $row['pcb01_cl'];
                if(!empty($row['pct01'])) {
                    $title = $row['pct01'];
                }else{
                    $title = $row['p00'];
                }
                $actions[$action_key]['text']      = $title;
                $actions[$action_key]['handler']   = "retail00_navigation(".htmlspecialchars(json_encode($handler_params)).")";
                if($_SESSION['lang'] != 'GR') {
                    $actions[$action_key]['text'] = $row['p05'];
                }
                $action_key++;
            }
            // Η τελευταία θέση εκτύπωσης
            
            // π.χ. Αν $actions_max = 27, τότε το last_position μπορεί να είναι 27 ή μικρότερο.
            $last_position = $this->get_last_position() + $action_key;
            $this->set_last_position($last_position); //! Δεν είμαι σίγουρος για αυτό. Νομίζω θα παίξει με την κατάλληλη αλλαγή στα είδη.
        }
        //* End Υπο-Οικογένειες
        
        
        //* Start Προϊόντα
        //* if action_key < actions_max σημαίνει ότι έχω χώρο να εκτυπώσω προϊόντα.
        if(
            ($action_key < $actions_max) 
        ) {
            $last_position_i00 = 0;
            $limit = " LIMIT " . $this->get_last_position_i00() . " , " . $buttons_amount;
            $i00_query = "SELECT 
                            i00.pno, 
                            i00.name, 
                            i00.ptax, 
                            i00.pcf01_cl, 
                            i00.pcb01_cl, 
                            i00.pct01
                            " . $i00_clsize_select . "
                        FROM i00 
                        " . $i00_clsize_join . "
                        WHERE 1=1 
                            AND i00.p203 = 0
                            AND i00.ptax > -1
                        " . $i00_query_where . " 
                        ORDER BY i00.ptax, i00.name, i00.nr01 " . $i00_clsize_order . $limit;

            $actions_max = $this->calc_actions_max();
            // echo '<pre>' .pegasus_replace_values_in_sql($i00_query, $i00_queryParams). '</pre>';
            $res = pegasus_query($i00_query, $i00_queryParams);
            // + action_key για να λάβω υπόψιν και πόσες ομάδες έχουν εκτυπωθεί
            if((pegasus_num_rows($res)+$action_key > $actions_max) && ($this->get_has_next() == 0)) {
                $this->set_has_next(1);
                $actions_max = $actions_max - 1; // Αφαιρώ ένα επειδή σέταρα "next" ///* Δεν είναι πολύ clean.
            }
            // num_rows+$action_key αν είναι μικρότερο του max σημαίνει τελευταία σελίδα.
            if(pegasus_num_rows($res)+$action_key <= $actions_max) {
                $this->set_has_next(0);
            }

            // var_dump($this->get_last_position_i00());
            // var_dump($this->get_history());
            $history_tmp = $this->get_history();

            while ($row = pegasus_fetch_assoc($res)) {
                if($action_key == $actions_max || $actions_max < 0) {
                    break;
                }
                // echo '<pre>' .end($history_tmp['last_position']). '</pre>';
                //TODO needs better testing
                $last_history_element = array();
                if (is_array($history_tmp) && !empty($history_tmp)) {
                    $last_history_element = end($history_tmp); 
                }
                if( $_SESSION['retail00_00_p05'] == 1
                    // && (empty(end($history_tmp['last_position'])) ))
                    && (empty($last_history_element) || empty($last_history_element['last_position']))
                    && (empty($this->get_i21()) && empty($this->get_i22()) && empty($this->get_i29()) && empty($this->get_i30()))
                    && !$this->get_has_prev()
                ){
                    $actions[$action_key]['extra_class']  = 'blank';
                    $actions[$action_key]['handler']  = '';
                    $actions[$action_key]['text']  = '';
                    
                    $action_key++;
                    $this->set_last_position_i00(0);
                }else{

                

                    $add_item_params = array();
                    $add_item_params['code'] = $row['pno'];
                    $add_item_params['a00_nr01'] = $a01_a55['a01nr01']; //! Αλλαγή ονοματος μεταβλητης (το έχω πάρει από την online insert)
                    

                    $price_arr = inventory_find_price(
                        $row['pno'], 
                        $a01_a55['a01nr01'], 
                        1, 
                        $a01_a55['a55p01'],
                        $a01_a55['a01p45'], // Καθεστώς ΦΠΑ
                        'a01', // mode
                        $a01_a55['a55p07'], // Τιμές με ΦΠΑ
                        $a01_a55['a55p703'], // Αποθήκη
                        $a01_a55['a01p48'], // Βασικός Τιμοκατάλογος
                        $a01_a55['a01p06'], // Ειδικός Τιμοκατάλογος
                        $a01_a55['a01p52'], // % Έκπτωση 1
                        $a01_a55['a01p52a'],// % Έκπτωση 2
                        $a01_a55['a01p523'] // Επιπλέον % Έκπτωσης
                    );
                    pegasus_mysql_use('SELECT p616, p616p FROM i00 WHERE pno = :i00pno', $i00_p616_data, array('i00pno' => $row['pno']));
                    $v616 = invoices_calculate_EFK('',$price_arr['price'],$price_arr['discount_1'],$price_arr['discount_2'],$price_arr['fpa'],$price_arr['preview_wthfpa'],$i00_p616_data['p616'],$i00_p616_data['p616p']);
                    $i00_total  = invoices_make_product_total(
                        1, //posotita
                        $price_arr['price'],
                        $price_arr['fpa'],
                        $price_arr['discount_1'],
                        $price_arr['discount_2'],
                        $price_arr['eisfora_anakyklosis'],
                        $v616,
                        $price_arr['preview_wthfpa'],
                        0,
                        $_SESSION['inventory_000_p07']
                    );
                    // $price_arr['price'] = number_format($price_arr['price'], $_SESSION['inventory_000_p07'], $_SESSION['cor000_decimal_char'], $_SESSION['cor000_thousand_char']);
                    // $price_arr['price'] = peg002_format_number($price_arr['price'], $_SESSION['inventory_000_p07'], 1);
                    //* Να ρωτήσω αν θέλουμε κάπως συγκεκριμένα την εμφάνιση της τιμής. Ίσως πρέπει να το βγάλω έξω από το "text"
                    // $price_text = "<div class='retail00_home_buttons_price'>" . $price_arr['price'] . "€</div>";
                    
                    $i00_total = peg002_format_number($i00_total, $_SESSION['inventory_000_p07'], 1);
                    $price_text = "<div class='retail00_home_buttons_price'>" . $i00_total . "€</div>";

        
                    $actions[$action_key]['font']      = $row['pcf01_cl'];
                    $actions[$action_key]['bg']        = $row['pcb01_cl'];
                    if(!empty($row['pct01'])) {
                        $title = $row['pct01'];
                    }else{
                        $title = $row['name'];
                        if($_SESSION['lang'] != 'GR') {
                            $title = $row['ename'];
                        }
                    }
                    // Αν έχει Χ-Μ
                    $cl_title = '';
                    $cl_separator = '';
                    if(isset($row['i47_p02']) && !empty($row['i47_p02'])) {
                        $add_item_params['color'] = $row['i47_p02'];
                        // Αν δεν έχει συμπληρωμένη περιγραφή Χ-Μ, περνάω τον κωδικό
                        if(!empty($row['i40_p02'])) {
                            $cl_title = $row['i40_p02'];
                        }else{
                            $cl_title = $row['i47_p02'];
                        }
                        $cl_separator = ' - ';
                    }
                    $sz_title = '';
                    if(isset($row['i47_p03']) && !empty($row['i47_p03'])) {
                        $add_item_params['size'] = $row['i47_p03'];
                        // Αν δεν έχει συμπληρωμένη περιγραφή Χ-Μ, περνάω τον κωδικό
                        if(!empty($row['i43_p02'])) {
                            $sz_title = $row['i43_p02'];
                        }else{
                            $sz_title = $row['i47_p03'];
                        }
                    }
                    $clsize_element = '';
                    if(!empty($cl_title) || !empty($sz_title)) {
                        $clsize_element = '<div class="retail00_home_buttons_clsize">';
                        $clsize_element .= $cl_title . $cl_separator . $sz_title;
                        $clsize_element .= '</div>';
                    }
                    
                    $actions[$action_key]['text']      = $title . $clsize_element . $price_text;
                    // $actions[$action_key]['handler']   = '##handler##';
                    $actions[$action_key]['handler']   = "retail00_add_item_new('".$this->get_container_id()."', ".htmlspecialchars(json_encode($add_item_params)).")";
                    // if($_SESSION['lang'] != 'GR') {
                    //     $actions[$action_key]['text'] = $row['pno'] . ' - ' . $row['ename'];
                    // }
                    $action_key++;
                    $last_position_i00++;
                }
            }
            // Η τελευταία θέση εκτύπωσης
            $last_position_i00 = $this->get_last_position_i00() + $last_position_i00;
            $this->set_last_position_i00($last_position_i00); //! Δεν είμαι σίγουρος για αυτό. Νομίζω θα παίξει με την κατάλληλη αλλαγή στα είδη.

            while($action_key < $actions_max) {
                $actions[$action_key]['extra_class']  = 'blank';
                $actions[$action_key]['handler']  = '';
                $actions[$action_key]['text']  = '';
                // echo '----'.$this->get_has_next();
                $action_key++;
            }
        }
        //* End Προϊόντα

        return $actions;
    }

    public function calc_actions_max() {
        // $actions_max = $this->get_rows_amount() * $this->get_columns_amount();
        $actions_max = $this->get_buttons_amount();
        if($this->get_has_home() === 1) {
            $actions_max = $actions_max - 1;
        }
        if($this->get_has_prev() === 1) {
            $actions_max = $actions_max - 1;
        }
        if($this->get_has_next() === 1) {
            $actions_max = $actions_max - 1;
        }
        if($this->get_std_actions_amount() > 0) {
            $actions_max = $actions_max - $this->get_std_actions_amount();
        }
        
        return $actions_max;
    }

    public function set_container_id($container_id) {
        $this->container_id = $container_id;
    }

    public function get_container_id() {
        return $this->container_id;
    }

    public function set_has_next($has_next) {
        $this->has_next = $has_next;
    }

    public function get_has_next() {
        return $this->has_next;
    }

    public function set_has_prev($has_prev) {
        $this->has_prev = $has_prev;
    }

    public function get_has_prev() {
        return $this->has_prev;
    }

    public function set_has_home($has_home) {
        $this->has_home = $has_home;
    }

    public function get_has_home() {
        return $this->has_home;
    }

    // public function set_rows_amount($rows_amount) {
    //     $this->rows_amount = $rows_amount;
    // }

    // public function get_rows_amount() {
    //     return $this->rows_amount;
    // }

    // public function set_columns_amount($columns_amount) {
    //     $this->columns_amount = $columns_amount;
    // }

    // public function get_columns_amount() {
    //     return $this->columns_amount;
    // }

    public function set_i21($i21) {
        $this->i21 = $i21;
    }

    public function get_i21() {
        return $this->i21;
    }

    public function set_i22($i22) {
        $this->i22 = $i22;
    }

    public function get_i22() {
        return $this->i22;
    }

    public function set_i29($i29) {
        $this->i29 = $i29;
    }

    public function get_i29() {
        return $this->i29;
    }

    public function set_i30($i30) {
        $this->i30 = $i30;
    }

    public function get_i30() {
        return $this->i30;
    }

    public function set_last_position($last_position) {
        $this->last_position = $last_position;
    }

    public function get_last_position() {
        return $this->last_position;
    }

    public function set_last_position_i00($last_position_i00) {
        $this->last_position_i00 = $last_position_i00;
    }

    public function get_last_position_i00() {
        return $this->last_position_i00;
    }

    public function set_last_position_std($last_position_std) {
        $this->last_position_std = $last_position_std;
    }

    public function get_last_position_std() {
        return $this->last_position_std;
    }

    public function set_std_actions_amount($std_actions_amount) {
        $this->std_actions_amount = $std_actions_amount;
    }

    public function get_std_actions_amount() {
        return $this->std_actions_amount;
    }

    public function set_history($history) {
        $this->history = $history;
    }

    public function get_history() {
        return $this->history;
    }

    public function get_a01_a55_params() {
        return $this->a01_a55;
    }

    public function set_buttons_amount($buttons_amount) {
        $this->buttons_amount = $buttons_amount;
    }

    public function get_buttons_amount() {
        return $this->buttons_amount;
    }

    public function set_buttons_min_width($buttons_min_width) {
        $this->buttons_min_width = $buttons_min_width;
    }

    public function get_buttons_min_width() {
        return $this->buttons_min_width;
    }

    public function set_buttons_min_height($buttons_min_height) {
        $this->buttons_min_height = $buttons_min_height;
    }

    public function get_buttons_min_height() {
        return $this->buttons_min_height;
    }

    public function set_only_std_actions($only_std_actions) {
        $this->only_std_actions = $only_std_actions;
    }

    public function get_only_std_actions() {
        return $this->only_std_actions;
    }
}