<?php 
// update version v1v47
function peg_suppliers_get_d00_data( $nr01 ){
	
	
    $peg_tmpquery="SELECT d00.nr01 as pnr01,
	                   if(d00.p190='', d00.p19, d00.p190)  as p19,
	                   if(d00.p19=d00.p190 || d00.p190='', '', d00.p19)   as p190,
	                   d00.p2    as p2,
	                   d00.p3    as p3,
	                   d00.p4    as p4,
	                   d00.p23   as p23,
	                   d00.p5   as p5,
	                   IF(d00.p7_1!='', d00.p7_1, d00.p7)     as p7,
	                   d00.p20  as p20,
	                   d00.p22  as p22,
	                   d00.pc22 as pc22,
	                   d00.p803 as p11,
	                   d00.p900 as p51,
	                   
	                   d00.p013 as p4_1,
	                   d00.p014 as p4_2,
	                   d00.p06 as p4_3,	  
	                    d00.p012 as p6,                 
        
	                   ifnull(d64_p8.p001, '')  as p8,
	                   ifnull(d64_p9.p001, '')  as p9,
	                   ifnull(d64_p10.p001, '') as p10,
	                   ifnull(d65_p01.p01, '')  as p01
        
	               FROM d00
	               LEFT JOIN d64 as d64_p8  ON d64_p8.p00=d00.nr01
	                                        && d64_p8.pd100='phone-01'
	               LEFT JOIN d64 as d64_p9  ON d64_p9.p00=d00.nr01
	                                        && d64_p9.pd100='phone-02'
	               LEFT JOIN d64 as d64_p10 ON d64_p10.p00=d00.nr01
	                                        && d64_p10.pd100='fax-01'
        
	               LEFT JOIN d65 as d65_p01 ON d65_p01.p00=d00.nr01
	                                        && d65_p01.pd100='email-01'
	               WHERE d00.nr01=?;";
    
    pegasus_mysql_use($peg_tmpquery, $peg_qresult, array($nr01));
    
    
    $peg_json_return_array = array();
    $peg_json_return_array['pnr01']  = $peg_qresult['pnr01'];
    $peg_json_return_array['p19']   = $peg_qresult['p19'];
    $peg_json_return_array['p190']  = $peg_qresult['p190'];
    $peg_json_return_array['p2']    = $peg_qresult['p2'];
    $peg_json_return_array['p3']    = $peg_qresult['p3'];
    $peg_json_return_array['p4']    = $peg_qresult['p4'];
    $peg_json_return_array['p23']   = $peg_qresult['p23'];
    $peg_json_return_array['p5']    = $peg_qresult['p5'];
    $peg_json_return_array['p7']    = $peg_qresult['p7'];
    $peg_json_return_array['p20']   = $peg_qresult['p20'];
    $peg_json_return_array['p22']   = $peg_qresult['p22'];
    $peg_json_return_array['pc22']  = $peg_qresult['pc22'];
    
    if(!empty($peg_qresult['pc22'])){
		$peg_json_return_array['p22'] = pegasus_mysql_printfld('d40' , 'p01' , 'p02=:p02', array('p02' => $peg_qresult['pc22']));
    }
    
    $peg_json_return_array['p11']   = $peg_qresult['p11'];
    $peg_json_return_array['p51']   = $peg_qresult['p51'];
	
	$peg_json_return_array['p4_1']   = $peg_qresult['p4_1'];
	$peg_json_return_array['p4_2']   = $peg_qresult['p4_2'];
	$peg_json_return_array['p4_3']   = $peg_qresult['p4_3'];
	$peg_json_return_array['p6']   = $peg_qresult['p6'];
	
    $peg_json_return_array['p8']    = $peg_qresult['p8'];
    $peg_json_return_array['p9']    = $peg_qresult['p9'];
    $peg_json_return_array['p10']   = $peg_qresult['p10'];
    $peg_json_return_array['p01']   = $peg_qresult['p01'];
    
    
    return $peg_json_return_array;
    
} 
/**
 * Return array keys and array of defulat values (from session)
 */
function peg_suppliers_a00__get_default_values(){
	//Map table's fields to default values
	$default_values_from_session=array(
		'p02'=>'suppliers_000_p01',
		'p48'=>'suppliers_000_p02',
		'p45'=>'suppliers_000_p03',
		'p05'=>'suppliers_000_p06',
		'p010'=>'suppliers_000_p05',
		'p803c'=>'suppliers_000_p615',
		'p4_1'=>'suppliers_000_p07',
		'p4_2'=>'suppliers_000_p08',
		'p4_3'=>'suppliers_000_p09',
		'pl20'=>'suppliers_000_pl20'
	);
	$default_values=array();
	// Get Session Value for each default table field
	foreach($default_values_from_session as $fieled_name=>$session_name)
		$default_values[$fieled_name]=$_SESSION[$session_name];
	return $default_values;
}

function peg_suppliers_a00_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
   
    if( !$data['nr01']>0 ){
		// Set Default values
		$default_values=peg_suppliers_a00__get_default_values();
		foreach($default_values as $default_field=>$default_value)
			$data[$default_field]=$default_value;	
    }

    if(strtolower(substr($mmnr01,0,5))=='d00_d' and  !($data['nr01']>0) ){
        $data['pnr01'] = $mnr01;
        $ret = peg_suppliers_get_d00_data( $data['pnr01'] );
        foreach ($ret as $key => $value) {
            $data[$key] =  $value;
        }
        
    }
    if(!empty($data['pc22'])){
        $data['p22'] = pegasus_mysql_printfld('d40' , 'p01' , 'p02=?', array($data['pc22']));
    }

    if($_d=='a00_d'){
        if(empty($data['nr01'])){
            $data['nr01'] = pegasus_mysql_newrec("a00");
            $peg_is_newrec =1 ;
        }
        
        $whereTmpTbl = ' peg_flag!=9 and '.
            ' peg_sess_id=:session and '.
            ' peg_mmnr01=:mmnr01 and  '.
			' peg_mnr01=:mnr01 ';
		
		$values = array(
			'session' 	=> session_id(),
			'mmnr01'	=> 'a00_d-'.$data['nr01'],
			'mnr01'		=> $data['nr01']
		);
        //Dimiourgoume ola ta tmp
        pegasus_make_all_tmp_recs('a00' , $data , $data['nr01'] , $_REQUEST['rec_copy_nr01'] , 'a00_d-'.$data['nr01'] );
        
        pegasusSetGlobalVar( 
			$container_id. '_where_a74' , 
			array(
				'sql' => ' peg_tmp_a74.p00=:mnr01 and '.$whereTmpTbl,
				'sqlParams' => $values
			)
		);
        
        pegasusSetGlobalVar( 
			$container_id. '_where_a75' ,
			array(
				'sql' => ' peg_tmp_a75.p00=:mnr01 and '.$whereTmpTbl,
				'sqlParams' => $values 
			)
		);
			
 		//Ypokatastimata
	    pegasusSetGlobalVar( 
			$container_id. '_where_a76' , 
			array(
				'sql' => ' peg_tmp_a76.p601=:mnr01 and '.$whereTmpTbl,
				'sqlParams' => $values
			)
		);
        
        if( !empty($data['pc22']) ){
            $data['p22_readonly'] = 1;
        }
	}
	
	$data['nr01_hidden'] = 2;

    return $data;
}

function  peg_suppliers_a00_d_onsave($data, $permDeny, $mmnr01, $checkOnlyPerm){

	// same p801 if not empty
	if (!empty($data['p801']) and pegasus_mysql_printfld('a00', 'nr01', 'nr01<>:nr01 and p801=:p801',
		array(
			'nr01' => $data['nr01'],
			'p801' => $data['p801']
		)) <> 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_001']));
	}

	// same pnr01 if not empty
	if (!empty($data['pnr01']) and pegasus_mysql_printfld('a00', 'nr01', 'nr01<>:nr01 and pnr01=:pnr01',
		array(
			'nr01' => $data['nr01'],
			'pnr01' => $data['pnr01']
		)) <> 0) {
		array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_suppliers_a00_002']));
	}

	//not empty p19
	if (trim($data['p19']) == false) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_003']));
	}

	//VAT Code is right?
	if ($data['p05'] == 1  and check_AFM($data['p20']) == false) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_004']));
	}

	if ($data['pl20'] == 0  and check_AFM($data['p20']) == false) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_011']));
	}

	// basic pricelist (i23)

	if (pegasus_mysql_table_exists('i23') and  pegasus_mysql_printfld('i23', 'nr01', "p01=:p01", array('p01' => $data['p48'])) == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_005']));
	}

	// VAT type
	if (pegasus_mysql_table_exists('a26') and  pegasus_mysql_printfld('a26', 'nr01', "p01=:p01", array('p01' => $data['p45'])) == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_006']));
	}

	//p803c invcust_diatiaxi_fpa_deny - Υποχρεωτική διάταξη απαλλαγης για το συγκεκριμένο καθεστως
	if (!($data['p803c']>0) and 
		pegasus_mysql_printfld('a26', 'p04', "p01=:p01", array('p01' => $data['p45'])) == 1) {
		array_push($permDeny, array('type' => 'deny', 'message' =>   $_SESSION['peg_dic_suppliers_diatiaxi_fpa_deny']));
	}

	// receipt Code
	if (pegasus_mysql_table_exists('a15') and pegasus_mysql_printfld('a15', 'nr01', "nr01=:nr01", array('nr01' => $data['p02'])) == 0) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_007']));
	}

	// Tax Office
	if (!empty($data['pc22'])) {
		$data['p22'] = pegasus_mysql_printfld('d40', 'p01', 'p02=?', array($data['pc22']));
	}

	if (empty($data['p22']) and empty($data['pc22']) and $data['p05'] == 1) {
		array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_008']));
	}

	// same p20  if not empty
	if (!empty($data['p20']) and pegasus_mysql_printfld('a00', 'nr01', 'nr01<>:nr01 and p20=:p20',
		array( 'nr01' => $data['nr01'], 'p20' => $data['p20']))<>0 && $data['p0400']==0) {
			
		if($_SESSION['suppliers_000_dn_p20']==1){
			array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_suppliers_a00_012']));
		}else{
			array_push($permDeny, array('type' => 'confirm', 'message' => $_SESSION['peg_dic_suppliers_a00_009']));
		}
		
	}

	return array($data, $permDeny);
}


function peg_suppliers_a00_d00_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){

	// Πίνακας: a01_d - Πελάτες
	pegasusSetGlobalVar( 
		$container_id . '_where_a00' , 
		array(
			'sql' => "pnr01=:mnr01",
			'sqlParams' => array(
				'mnr01' => $mnr01
			)
		)
	);	
	return $data;
}
function peg_suppliers_a76_d_initialize($data,$mmnr01='',$mnr01='',$_d='',$container_id=''){
    if($_d=='a76_d'){
        if(substr($mmnr01,0,5)=='a00_d'){
            $data['p601_hidden'] = '2';
            $data['p601'] = $mnr01;
        }
    }
    return $data;
}

function suppliers_after_update(){
	peg_suppliers_user_defined_fields();
}

/**
 * Βρίσκει το υπόλοιπο του προμηθευτή
 *
 * $a00_p21 = O logariasmos toy προμηθευτή.
 * $p09_min  = Από κατάστημα.
 * $p09_max  = Έως κατάστημα.
 */
function suppliers_find_balance($a00_p21 = 0, $p09_min = 0, $p09_max = 999){

	$values = array();
	$values['a00_p21'] = $a00_p21;
	$values['p09_min'] = $p09_min;
	$values['p09_max'] = $p09_max;

	pegasus_mysql_use(
		"select  ifnull(sum(t00tot.p03),0) as balance 
        						from t00tot where p01=:a00_p21 
        						and p09>=:p09_min 
        						and p09<=:p09_max;",
		$t00tot,
		$values
	);

	return $t00tot['balance'];
}


function peg_suppliers_user_defined_fields(){
	for ($i = 0; $i < 4; $i++) {
	        
		for ($ii = 1; $ii < 6; $ii++) {
			//Den yparxei lektiko ston p82 
			$p00 = 'suppliers_pd'.$ii.$i.'_tit';
	    	pegasus_mysql_use('select * from p82 where p00=:p00', $p82, array('p00' => $p00));
	            
	        $tit  = $p82['p01'];
	        $etit = $p82['ep01'];
	            
	        if( !empty($_SESSION['suppliers_000_pd' .$ii .$i]) ){
	        	$tit  = $_SESSION['suppliers_000_pd' .$ii .$i];
	            $etit = $_SESSION['suppliers_000_pd' .$ii .$i];
	        }
	            
	            
	        $arr1 = array(); $arr2 = array();
	        array_push($arr1 , 'desc02');  array_push($arr2 , $tit);
			array_push($arr1 , 'edesc02'); array_push($arr2 , $etit);
			$desc05 = 'pd'.$ii.$i;
			pegasus_mysql_update('p51', $arr1, $arr2, 'p02 in ("a00_d" , "a00_d004" ) and desc05=:desc05', 
			0, 1, 1, array('desc05'=> $desc05)); 
	   }
	        
	}    
	    pegasus_delete_directory('../../tmp/suppliers/a00_d/');
	    pegasus_delete_directory('../../tmp/suppliers/a00_d004/');
	

	if( pegasus_module_exists('peg002') ){
		peg002_clean_dCache('a00_d');
		peg002_clean_dCache('a00_d004');
	}
}


 


?>