<?php 
//* TODEL, replaced by mydt_mydt10.php
if (file_exists('../mydt_libs/mydt_before_mydt10.php')) {
	require_once('../mydt_libs/mydt_before_mydt10.php');
}
if (file_exists('../mydt_libs/mydt_mydt10.php')) {
	require_once('../mydt_libs/mydt_mydt10.php');
}


class account00_account00_01_d{
    private $input_data = array(
        'v_type'	    => 0, 
        
        'v_a14'			=> 0,  
        
        'v_amount'		=> 0, 
        

        'v_t08'			=> 0, //Η απόδειξη είσπραξης (v_type == 3)

        'v_t18'			=> 0, //Ρυθμίσεις για Εισπράξεις/Επιστροφές EFTPOS // Αποδείξεις  (v_type == 3 ή 2)


        'v_a01'			=> 0, //Πελάτης για την καταχώρηση Απόδειξης(v_type == 3 ή 2) ή ο πελάτης του Παραστατικού(απλά ενημερωτικό) (v_type == 1)
        'v_a18'			=> 0, //Σειρά για την καταχώρηση Απόδειξης(v_type == 3 ή 2) ή η σειρά του Παραστατικού(απλά ενημερωτικό) (v_type == 1)
        'v_t07'			=> 0, //Κατάστημα για την καταχώρηση Απόδειξης(v_type == 3 ή 2) ή το κατάστημα του Παραστατικού(απλά ενημερωτικό) (v_type == 1)


        'v_a55'			=> 0, //Παραστατικό πελάτη - (v_type == 1)
        'v_pos00_02'	=> 0, //Μ.Κ. Ρυθμίσεις POS για παραστατικό πελάτη - (v_type == 1)
		'v_profortosi'  => 0, //Ετεροχρονισμένη πληρωμή, που θέλω απλά να προφορτώσω στο pos, για να στείλω π.χ. με delivery,
		'v_idtorefund'  => 0, //Ετεροχρονισμένη, το transaction id της συναλλαγής που θέλω να κάνω refund
		'v_idtorefund_txt'  => 0, //Ετεροχρονισμένη, το transaction id της συναλλαγής που θέλω να κάνω refund (text field)
		'v_preauthid'   => 0, //Ετεροχρονισμένη, το transaction id της προέγκρισης
		'v_instalments' => 0, //Αριθμός Δόσεων
		'v_mailphone'   => 0, //Αν είναι μέιλ/τηλεφωνική
		
        'v_hota04'		=> 0, //Κράτηση hotel
        'v_tran01'		=> 0, //Φορτωτική
    );

	private $dyn_fld_pattern_nr01 = '/^a55_rec_nr01_(\d+)$/';
	private $dyn_fld_pattern_amount = '/^a55_rec_amount_(\d+)$/';
	private $no_amount_check; // Το σετάρουμε αν στα input_data υπάρχει έστω ένα "a55_rec_nr01_" key. Το κάνω class variable για να γλιτώσω επαναλαμβανόμενες foreach.


    public function __construct($input_data) {
        foreach ($this->input_data as $key => $value) {
            $this->input_data[$key] = $input_data[$key];
        }

		// Περνάω και τα dynamic fields στα input_data
		$this->no_amount_check = 0;
		foreach ($input_data as $key => $value) {
			if (preg_match($this->dyn_fld_pattern_nr01, $key, $matches)) {
				$this->input_data[$key] = $input_data[$key];
				$this->no_amount_check = 1;
			}
			if (preg_match($this->dyn_fld_pattern_amount, $key, $matches)) {
				$this->input_data[$key] = $input_data[$key];
			}
		}
    }

    public function refresh_screen_values($container_id, $calledfrom){

        $v_type = $this->input_data['v_type'];
        //The data to be returned
        $data = array(
            'v_a55'		=> array('hidden' => true, 'readonly' => false),
            'v_t18'		=> array('hidden' => true, 'readonly' => false),
            'v_a01'		=> array('hidden' => true, 'readonly' => false),
    
            'v_a14'		=> array('hidden' => true, 'readonly' => false),
            'v_t08'		=> array('hidden' => true, 'readonly' => false),
            'v_a18p01'	=> array('hidden' => true, 'readonly' => false),
            // 'v_aa'	    => array('hidden' => true, 'readonly' => true),
            'v_t07p01'	=> array('hidden' => true, 'readonly' => false),
            'v_pos00_02'=> array('hidden' => true, 'readonly' => false),

			'v_profortosi'=> array('hidden' => true, 'readonly' => false),
			'v_idtorefund'=> array('hidden' => true, 'readonly' => false),
			'v_idtorefund_txt'=> array('hidden' => true, 'readonly' => false),
			'v_preauthid'=> array('hidden' => true, 'readonly' => false),
			'v_instalments'=> array('hidden' => true, 'readonly' => false),
			'v_mailphone'=> array('hidden' => true, 'readonly' => true),

			'v_a55p05'	=> array('hidden' => true, 'readonly' => false),
			'v_a55p06'	=> array('hidden' => true, 'readonly' => false),
			
            'v_hota04'  => array('hidden' => false, 'readonly' => false),
			'v_tran01'	=> array('hidden' => true,  'readonly' => false),

			'v_tran01p105'	=> array('hidden' => true, 'readonly' => false),
			'v_tran01sp00'	=> array('hidden' => true, 'readonly' => false),
			'v_tran01p00'	=> array('hidden' => true, 'readonly' => false),			
    
            'v_info_message'=> array('hidden' => true, 'readonly' => false)
        );

		account00_account00_01_d_set_query_v_a14($this->input_data, $container_id, $v_type);
		account00_account00_01_d_set_query_v_pos00_02($this->input_data, $container_id, $v_type);
		
        if($v_type==1 || $v_type==4){
			//$data['message'] = '<div class="peg_alert_info_plain">' .$a55_msg. '</div>';
			$refresh_values = call_user_func_array(array($this, "_refresh_screen_values_type_".$v_type), array($container_id, $calledfrom, $data));
        }else{
            $refresh_values = $this-> _refresh_screen_values_type_2_3($container_id, $calledfrom, $data);
        } 
		
		if(isset($refresh_values['data']['v_info_message']['value']) && !empty($refresh_values['data']['v_info_message']['value'])){
			$refresh_values['data']['v_info_message']['value'] = '<div class="peg_alert_info_plain" style="text-align:center;">' .$refresh_values['data']['v_info_message']['value']. '</div>';
		}
        
		return $refresh_values;
    }

     private  function _refresh_screen_values_type_1($container_id, $calledfrom, $data){
       
        // die("Refresh της οθόνης για type == 1 ");
        $v_a55 = $this->input_data['v_a55'];
        $v_a14 = $this->input_data['v_a14'];

		//Αρχικοποίηση Παραστατικού σε περίπτωση που γινεται αλλαγή Κράτησης
		$data['v_a55']['value']   = 0;
		$data['v_a55']['display'] = "";
		$data['v_a55']['hidden']  = false;
		$data['v_a14']['hidden']  = false;

		$data['v_hota04']['value'] = 0;

		$data['v_instalments']['value'] = 0;
		$data['v_instalments']['hidden'] = true;
		$data['v_mailphone']['value'] = 0;
		$data['v_mailphone']['hidden'] = true;

		
		//v_a55 query			
		$sqlParams_v_a55 = array();
		$sql_v_a55 = "	SELECT a55.* 
						FROM a55
						JOIN t35 ON t35.tbl_nr = a55.nr01
						WHERE t35.tbl='a55' and t35.p03<>0 and a55.p08 = 0";
						
		$v_a01_where = '';	
		if($this->input_data['v_hota04']>0){
			$data['v_hota04']['value']  = $this->input_data['v_hota04'];			

			//Δε θα πρεπει να φερνει τα Παραστατικά απο Μαζική Κράτηση
			$sql_v_a55 .= " AND a55.nr01 IN ( 
									select a55_nr01 from (
										select
											group_concat(DISTINCT hota04.nr01 separator '##') as group_hota04_nr01,
											group_concat(DISTINCT hota17.nr01 separator '##') as group_hota17_nr01,
											i01.p06 as a55_nr01
										from i01
										left join hota17 on i01.pd101='hota17' and i01.pd102=hota17.nr01
										join hota04 on (i01.pd101='hota04' and i01.pd102=hota04.nr01) or (hota04.nr01=hota17.pnr01)     
										where i01.p07=2 
										group by i01.p06
										having group_hota04_nr01 not like '%##%' and group_hota04_nr01=:hota04_nr01
									) as a55_00
								) ";
								
			$sqlParams_v_a55['hota04_nr01'] = $this->input_data['v_hota04'];
		}	

		pegasusSetGlobalVar($container_id . '_where_v_a01', $v_a01_where);
		pegasusSetGlobalVar($container_id . '_query_v_a55', array('sql' => $sql_v_a55, 'sqlParams' => $sqlParams_v_a55));
		
		$query_v_a55 = array('sql' => $sql_v_a55, 'sqlParams' => $sqlParams_v_a55);
		pegasus_mysql_use( "select count(*) as cnt  from (" .$query_v_a55['sql'] . ") as tt", $a55, $query_v_a55['sqlParams']);
		
		if($a55['cnt'] == 0 ){
			$data['v_a55']['hidden'] = true;
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  $_SESSION['peg_dic_account00_invoice_with_balance_was_not_found']
			);
		}

		if(!($v_a55 > 0)) {
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  '<div class="alert_message">' . $_SESSION['peg_dic_account00_select_a55'] . '</div>'
		   );
   
		}
	
		$sql = "SELECT  mydt10.einv AS mydt10_einv,
						mydt10.mark	AS mydt10_mark,
						a01.p19		AS a01_p19, 
						a55.p03 	AS a55_p03, 
						a55.p701 	AS a55_p701, 
						a55.p05 	AS a55_p05, 
						a55.p06 	AS a55_p06, 
						a10.p02     AS a10_p02,
						a10.p00     AS a10_p00
				FROM a55
				JOIN a01 ON a01.nr01 = a55.p03
				JOIN a10 ON a55.p05 = a10.p01
				LEFT JOIN mydt10 ON mydt10.tbl = 'a55' AND mydt10.tbl_nr01=a55.nr01
				WHERE a55.nr01 = :nr01
				and mydt10.auth_cd !='' and mydt10.einv>0 /* Θέλω να φυγει μονο για παραστατικό που εχει auth_code  */
			";
		$values = array('nr01'	=> $v_a55);
		pegasus_mysql_use($sql,$a55,$values);


		$data['v_a55']['value']   = $v_a55;
		$data['v_a55']['display'] = $v_a55;

		//Έλεγχος αν είναι Παραστατικό Ηλεκτρονικής Τιμολόγησης (Pegasus Web App [1] & Τοπικό[51])
		if(!in_array($a55['mydt10_einv'], array(1, 51))) {
			return array(
				 		'ok'	=> 0,
				 		'data'	=> $data,
				 		'error_message'	=>  '<div class="alert_message">' . $_SESSION['peg_dic_account00_mydt10_einv_is_empty'] . '</div>'
					);			
		}

        //Εύρεση στοιχείων από το παραστατικό
		$data['v_a01']['value'] = $a55['a55_p03'];
		$data['v_a01']['display'] = $a55['a01_p19'];
		$data['v_a01']['hidden'] = false;
		$data['v_a01']['readonly'] = true;

		//Σειρά
		$data['v_a18p01']['value'] = $a55['a55_p701'];
		$data['v_a18p01']['hidden'] = false;
		$data['v_a18p01']['readonly'] = true;

		// Τύπος
		$data['v_a55p05']['value'] = $a55['a10_p00'];
		$data['v_a55p05']['display'] = $a55['a10_p02'];
		$data['v_a55p05']['hidden'] = false;
		$data['v_a55p05']['readonly'] = true;

		// Αριθμός
		$data['v_a55p06']['value'] = $a55['a55_p06'];
		$data['v_a55p06']['hidden'] = false;
		$data['v_a55p06']['readonly'] = true;
		

		// $data['v_aa']['value'] = $a55['a55_p06'];
		// $data['v_aa']['hidden'] = false;

		//Ευρεση/Έλεγχος υπολοιπου παραστατικού
		// pegasus_mysql_use("select sum(p03) as p03 , sum(p04) as p04 from t01 where t01.p303 IN (2,4,9) and t01.p302=:a55_nr01"  , $t01_tot , array('a55_nr01' => $v_a55));
		// $ypoloipo = $t01_tot['p03'] - $t01_tot['p04'];

		// if(pegasus_module_exists('account01')) {
		// 	$t38_main = pegasus_mysql_printfld('t01', 'nr01', 'p302 = ? AND p303 = 2', array($v_a55));
		// 	if(!empty($t38_main)) {
		// 		pegasus_mysql_use(
		// 			'	SELECT
		// 					sum(p03) AS t38_xreosi,
		// 					sum(p04) AS t38_pistosi
		// 				FROM t38
		// 				WHERE
		// 					p01 = :t38_main ',
		// 			$t38_sum,
		// 			array('t38_main' => $t38_main)
		// 		);
		// 	}
		// 	if(!empty($t38_sum['t38_xreosi']) || !empty($t38_sum['t38_pistosi'])) {
		// 		// Χρεώσεις μείον Πιστώσεις
		// 		$t38_tot = ($t38_sum['t38_xreosi']) - ($t38_sum['t38_pistosi'] );
		// 		$ypoloipo = $ypoloipo + $t38_tot;
		// 	}
		// }
		$ypoloipo = invoices_calc_a55_aneisprakto($v_a55, 'a55', false);

		if(abs($ypoloipo) > 0){
			$data['v_info_message']['hidden'] = false;
			$yp_formatted = number_format(abs($ypoloipo), 2, $_SESSION['cor000_decimal_char'] , '' );
			$data['v_info_message']['value'] = str_replace('##yp_formatted##', $yp_formatted, $_SESSION["peg_dic_account00_message_ypoloipo_poso"]);	
		}		

		$data['v_amount']['value'] = abs($ypoloipo);
		$data['v_amount']['hidden'] = false;

		//TODO: Να διορθωσω το μνμ εδω 
		if( abs($ypoloipo)==0 ) {
			return array(
				 		'ok'	=> 0,
				 		'data'	=> $data,
				 		'error_message'	=>  '<div class="alert_message">' . str_replace( 
									array('#p03#', '#p04#') , 
									array(	number_format($t01_tot['p03'] , 2, $_SESSION['dek_poin'], $_SESSION['th_poin']) , 
											number_format($t01_tot['p04'] , 2, $_SESSION['dek_poin'], $_SESSION['th_poin']) ) , 
									$_SESSION['peg_dic_account00_a55_was_fully_paid']) . '</div>'
					);
			
		}


		if(!($v_a14 > 0)){
			$data['v_pos00_02']['value']   = 0;
			$data['v_pos00_02']['display'] = '';
		}
		
		/**
		 * Έλεγχος και αρχικοποίηση του πεδίου v_a14 (μόνο αν έχει οριστεί παραστατικό)
		 */
		$data['v_a14']['hidden'] = true;
		if($v_a55 > 0) {
			$_query_v_paytype = pegasusGetGlobalVar($container_id . '_query_v_a14');
			$_query_v_paytype['sqlParams']['a55'] = $v_a55;
			
			$a14_selected = false;
			if($v_a14 > 0 ){
				pegasus_mysql_use( 
					"SELECT * FROM (" . $_query_v_paytype['sql'] . ") AS ttt where ttt.nr01 = :v_a14", 
					$a14, 
					array_merge($_query_v_paytype['sqlParams'], array("v_a14" => $v_a14))
				);
				if($a14["nr01"] > 0 ){
					$a14_selected = true;
				}
			}
			if(!$a14_selected){
				pegasus_mysql_use($_query_v_paytype['sql'], $a14, $_query_v_paytype['sqlParams']);
			}
			
			pegasusSetGlobalVar($container_id . '_query_v_a14',$_query_v_paytype);

			if(!($a14['nr01'] > 0)){
				
				return array(
					'ok'	=> 0,
					'data'	=> $data,
					'error_message'	=>  $_SESSION['peg_dic_account00_payment_type_not_found']
			   );
			}
			//echo pegasus_replace_values_in_sql($_query_v_paytype['sql'], $_query_v_paytype['sqlParams']);
			$data['v_a14']['value'] = $a14['nr01'];
			$data['v_a14']['display'] =  $a14['p01'];
			$data['v_a14']['hidden'] = false;
			
		}

		$data['v_pos00_02']['hidden'] = true;
		if(($a14['nr01'] > 0)){

			$data['v_pos00_02']['readonly'] = false;
			$data['v_pos00_02']['hidden'] = false;

			// print_r($input_data);
			$_query_v_pos00_02= pegasusGetGlobalVar($container_id . '_query_v_pos00_02');
			$_query_v_pos00_02['sqlParams']['a55'] = $v_a55;
			$_query_v_pos00_02['sqlParams']['a14'] = $a14['nr01'];
			pegasus_mysql_use($_query_v_pos00_02['sql'], $pos00_02, $_query_v_pos00_02['sqlParams']);
			pegasusSetGlobalVar($container_id . '_query_v_pos00_02',$_query_v_pos00_02);
		
			pegasus_mysql_use("select pos00_02.*, count(*) as cnt from ( " . $_query_v_pos00_02['sql'] . ") as pos00_02 ", $pos00_02, $_query_v_pos00_02['sqlParams']);

			pegasus_mysql_use('SELECT * FROM pos00_01 WHERE nr01 = :pos00_01_nr01', $pos00_01, array("pos00_01_nr01" => $pos00_02['pos00_01']));

			//* Σετάρει τα global var για το v_idtorefund.
			account00_set_idtorefund_globalvar($pos00_02['pos00_01'], $container_id);
			
			if($pos00_02['cnt'] == 1){
				$data['v_pos00_02']['readonly'] = true;
				$data['v_pos00_02']['value'] = $pos00_02['nr01'];
				$data['v_pos00_02']['display'] = $pos00_02['pos00_01_p01'];

				pegasus_mysql_use('SELECT * FROM a10 WHERE a10.p01 = :a55_p05', $a10, array("a55_p05" => $a55['a55_p05']));
				pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = :a10_p04', $t02, array("a10_p04" => $a10['p04']));
				

				$device_properties = pos00_device_properties::get_properties($pos00_01['p02']);

				// Δέχεται Δόσεις
				$data['v_instalments']['hidden'] = true;
				$data['v_instalments']['value'] = 0;
				/**
				 * Δεχόμαστε δόσεις μόνο αν:
				 * - Το POS υποστηρίζει δόσεις 
				 * - Έχει γίνει και η αντίστοιχη επιλογή στο pos00_02.p00
				 * - Είναι για παραστατικό είσπραξης 
				 */
				if(
					$device_properties['instalments'] == true
					&& $pos00_02['p00'] == 1 
					&& $t02['p03'] > 0
				) {
					$data['v_instalments']['hidden'] = false;
				}

				// Δέχεται Mail/Phone Order
				$data['v_mailphone']['hidden'] = true;
				$data['v_mailphone']['value']  = 0;
				if($pos00_02['p01'] == 1 && $t02['p03'] > 0) { // Το περιορίζω και στα παραστατικά είσπραξης.
					//$data['v_mailphone']['hidden'] = false;
					$data['v_mailphone']['value']  = $pos00_02['p01'];

					//Μήνυμα για "mailphone"
					$data['v_info_message']['value'] .= str_replace('##eftpos##', $a14['p01'], $_SESSION["peg_dic_account00_message_mailphone"]);
					$data['v_info_message']['hidden'] = false;
				}

				// Παραστατικό με αρνητικό συντελεστή χρέωσης = Επιστροφή
				$data['v_idtorefund']['value'] = 0;
				if($t02['p03'] < 0 && $device_properties['void'] == true) {
					$data['v_idtorefund']['hidden'] = false;
				}

				// Δέχεται Ολοκλήρωση προέγκρισης
				$data['v_preauthid']['hidden'] = true;
				$data['v_preauthid']['value'] = '';
				if($pos00_02['p02'] == 1 && $t02['p03'] > 0) { // Το περιορίζω και στα παραστατικά είσπραξης.
					$data['v_preauthid']['hidden'] = false;
				}

				$data['v_profortosi']['hidden'] = true;
				$data['v_profortosi']['value'] = 0;
				if($device_properties['preload'] == true && $t02['p03'] > 0) { // Το περιορίζω και στα παραστατικά είσπραξης.
					$data['v_profortosi']['hidden'] = false;
				}
			}

			if($pos00_02['cnt'] == 0){
				$data['v_pos00_02']['value']   = 0;
				$data['v_pos00_02']['display'] = '';

				$data['v_instalments']['value'] = 0;
				$data['v_instalments']['hidden'] = true;

				$data['v_mailphone']['value'] = 0;
				$data['v_mailphone']['hidden'] = true;

				$data['v_idtorefund']['value'] = 0; //TODO να γίνει 0 όταν το κάνω comboboxv2
				$data['v_idtorefund']['hidden'] = true;

				$data['v_idtorefund_txt']['value'] = '';
				$data['v_idtorefund_txt']['hidden'] = true;

				$data['v_preauthid']['value'] = '';
				$data['v_preauthid']['hidden'] = true;

				$data['v_profortosi']['value'] = 0;
				$data['v_profortosi']['hidden'] = false;
			}
 
		}

		// Για τους τρόπους είσπραξης στην οθόνη είσπραξης
		account00_set_a14_global_var($v_a55, 'a55', $container_id);
		
        return array(
            'ok'	=> 1,
            'data'	=> $data
        );

     }

     private function _refresh_screen_values_type_2_3($container_id, $calledfrom, $data){
        // die("Refresh της οθόνης για type == 2 ή 3");
        $v_type   = $this->input_data["v_type"];
        $v_t18    = $this->input_data['v_t18'];
        $v_t08    = $this->input_data['v_t08'];
        $v_t07p01 = $this->input_data['v_t07p01'];
        $v_a18p01 = $this->input_data['v_a18p01'];
		$v_a01 	  = $this->input_data['v_a01'];
    	  
		$v_amount = $this->input_data['v_amount']; 
		$v_hota04 = $this->input_data['v_hota04'];

		$container_properties = array();

		$data['v_hota04']['value']  = $v_hota04;
		$data['v_a01']['value'] 	= $v_a01;
        $data['v_t18']['hidden'] 	= false;

		$invtype = '8.4';
		if($v_type == 3){
			$invtype = '8.5';
		}
		

		pegasusSetGlobalVar($container_id . '_v_a01', $v_a01);
		pegasusSetGlobalVar($container_id . '_v_hota04', $v_hota04);
		pegasusSetGlobalVar($container_id . '_where_v_a01', '');

		$v_t18_query = array(
			'sql' => "SELECT t18.* FROM t18 JOIN q31 on t18.t10p01 = q31.p03 WHERE t18.cor003p01 = :cor003p01 AND q31.p05 = :invtype AND q31.p01 = '620019'",
			'sqlParams' => array(
				'cor003p01'	=>$_SESSION['cor003_p01'],
				'invtype'=>$invtype
			)
		);
		pegasusSetGlobalVar($container_id . '_query_v_t18', $v_t18_query);
			
		pegasus_mysql_use($v_t18_query['sql'], $t18, $v_t18_query["sqlParams"] );
		// echo pegasus_replace_values_in_sql($v_t18_query['sql'], $v_t18_query["sqlParams"]);

		if(empty($t18)){
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  str_replace("##invtype##", $invtype, $_SESSION['peg_dic_account00_pos_payment_configuration_not_found']) 
		   );
		}


		$t18_nr01 = $v_t18;
		if($calledfrom == "v_type" ){
			$data['v_t18']['value'] = $t18['nr01'];
			$data['v_t18']['display'] = $t18['p00'];
			$t18_nr01 = $data['v_t18']['value'];
		}
        
		pegasus_mysql_use("select  t18.* from t18 where nr01=:nr01", $t18, array('nr01'=>$t18_nr01) );
        //echo pegasus_mysql_printfld('q31' , 'count(*)' ,  "p01='620019' and p03=:p03 and p05 = :p05 " , array("p03" => $t18['t10p01'], "p05" => $invtype ) );
        //  print_r(array("p03" => $t18['t10p01'], "p05" => $invtype ));
		if(pegasus_mysql_printfld('q31' , 'count(*)' ,  "p01='620019' and p03=:p03 and p05 = :p05 " , array("p03" => $t18['t10p01'], "p05" => $invtype ) )==0){
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  $_SESSION['peg_dic_account00_receipt_type_no_q31_84_85']
		   );
		}



		if($v_type == 3){
			$data['v_t08']['hidden'] = false;
			$query_v_t08 = pegasusGetGlobalVar($container_id . '_query_v_t08');
			pegasus_mysql_use( "select count(*) as cnt  from (" .$query_v_t08['sql'] . ") as tt", $t08_arr, $query_v_t08['sqlParams']);

			if($t08_arr['cnt'] == 0 ){
				$data['v_t08']['hidden'] = true;
				return array(
					'ok'	=> 0,
					'data'	=> $data,
					'error_message'	=>  $_SESSION['peg_dic_account00_sent_to_mydata_receipt_was_not_found']
			   );
			}
		}

		
		if(!($t18_nr01>0)) {
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  $_SESSION['peg_dic_account00_choose_pos_collection_refund_type']
		   );
	   
		}

		

		pegasus_mysql_use("select * from t18 where nr01 = ?", $t18, array($t18_nr01) );

		$data['v_a01']['hidden']    = false;
		$data['v_a18p01']['hidden'] = false;
		// $data['v_aa']['hidden']  = false;
		$data['v_amount']['hidden'] = false;

		$data['v_instalments']['hidden'] = true;
		$data['v_instalments']['value']  = 0;


		$pos00_01_p02 = pegasus_mysql_printfld('pos00_01', 'p02', 'nr01=?', array($t18['pos00_01']));
		$device_properties = pos00_device_properties::get_properties($pos00_01_p02);

		
		
		if($v_type == 2) {
			// echo '<pre>' .print_r($this->input_data, 1). '</pre>';
			$container_properties['fldset01']['hidden'] = true;
			if(pegasus_module_exists('account01')) {
				$container_properties['fldset01']['hidden'] = false;
				foreach ($this->input_data as $key => $value) {
					if (preg_match($this->dyn_fld_pattern_nr01, $key, $matches)) {
						$i = $matches[1];
						$rec_nr01s[$i] = $value;
					}
				}
				if(!empty($rec_nr01s) && $calledfrom != 'v_a01') { // αν έχω αλλαγή στο v_a01 θέλω πάντα να το βγάλει από readonly γιατί καθαρίζω τα δυναμικά.
					// Αν έχω έστω ένα επιλεγμένο παραστατικό, κάνω το amount = 0;
					$data['v_amount']['readonly'] = true;
				}
			}

			if($v_hota04>0){
				if($calledfrom=="v_type" || $calledfrom=="v_t18" || $calledfrom=="v_a18p01"){
					$data['v_hota04']['readonly'] = true;
					if(!empty($v_a01)) {
						$data['v_a01']['readonly'] = true;						
					}
				}

				if($v_amount>0){
					$data['v_amount']['value']    = $v_amount;
					$data['v_amount']['readonly'] = false;
				}

				$v_a01_where = array(
					'sql' 		=> "a01.nr01 in (						
								select distinct hota60.a01_nr01 from hota60 where hota60.hota04_nr01 = :v_hota04 and hota60.a01_nr01 <> 0
								union all 
								select hota04.p030 from hota04 where hota04.nr01 = :v_hota04 and hota04.p030 <> 0)",
					'sqlParams' => array('v_hota04'=>$v_hota04)
				);
				pegasusSetGlobalVar($container_id . '_where_v_a01', $v_a01_where);
			}
			
			
			/**
			 * Δεχόμαστε δόσεις μόνο αν: Το POS υποστηρίζει δόσεις 
			 */
			if($device_properties['instalments']==true && $t18['p03']>0) {
				$data['v_instalments']['hidden'] = false;
			}
		}
		
		


		if($v_type == 3){
			pegasusSetGlobalVar($container_id . '_where_v_a01', '');
			
			$data['v_hota04']['display'] = 0;
			$data['v_hota04']['hidden']  = true;

			pegasus_mysql_use("SELECT t08.*, 
									t10.p02 as t10_p02,
									a01.p19 as a01_p19,
									a01.nr01 as a01_nr01  
									FROM t08 
									JOIN t10 ON t08.p05 = t10.p01
									JOIN a01 ON t08.p03 = a01.p21
									WHERE t08.nr01 = :nr01", $t08, array("nr01" => $v_t08));

			
			$data['v_t08']['value']    = $v_t08;
			$data['v_t08']['display']  = $t08['t10_p02'];
			$data['v_amount']['value'] = $t08["p0109"];
				
			
			if($calledfrom == "v_t08" ){	
				//Αρχικοποιώ τον πελάτη για την καινούρια απόδειξη πληρωμής
				$data['v_a01']['value']    = $t08["a01_nr01"];
				$data['v_a01']['display']  = $t08["a01_p19"];	
	
				//$data['v_t07p01']['value'] = $t08["p021"];
				//$data['v_a18p01']['value'] = $t08["p701"];
				//$data['v_aa']['value']  = $t08["p06"];			
			}


			if($t08["p0109"]>0){
				$data['v_info_message']['value'] .= str_replace('##remainder##', number_format($t08["p0109"], 2, $_SESSION['dek_poin'], ''), $_SESSION['peg_dic_account00_amount_not_greater_than_total_amount']);
				$data['v_info_message']['hidden'] = false;	
			}


			//Όταν εχω Συσκευή POS που υποστηρίζει μονο Void κι οχι Refund, ενημερωνω το idtorefund
			pegasus_mysql_use("	SELECT 
									pos00_04.txnid as pos00_04_txnid
								FROM t19 
								JOIN pos00_04 ON pos00_04.t19=t19.nr01
								WHERE tbl='t08' and tbl_nr01=:t08nr01", 
								$t19, 
								array("t08nr01" => $v_t08));
								

			$data['v_idtorefund_txt']['value'] = '';
			if(!empty($t19["pos00_04_txnid"]) && ($device_properties['void'] && !$device_properties['refund'])) {
				$data['v_idtorefund_txt']['hidden']   = 2;
				$data['v_idtorefund_txt']['readonly'] = true;
				$data['v_idtorefund_txt']['value'] 	  = $t19["pos00_04_txnid"];
			}
		}

		if($t18['p01'] == 1) {
			//Μήνυμα για "mailphone"
			$data['v_info_message']['value'] .= str_replace('##eftpos##', $t18['p00'], $_SESSION["peg_dic_account00_message_mailphone"]);
			$data['v_info_message']['hidden'] = false;
		}

        // αν εχει αλλαξει 
		if( $calledfrom == "v_type" || $calledfrom == "v_t18" ){   
			$data['v_a18p01']['value'] = $_SESSION['cor003_p102'];
			//$data['v_a18p01']['display'] =  pegasus_mysql_printfld("a18", "p02", "p01=:p01", array("p01" =>  $_SESSION['cor003_p102']));
			$a18p01=$data['v_a18p01']['value'];
		}
	

		//Εύρεση Καταστήματος
		$t10 = array();
		pegasus_mysql_use('SELECT * FROM t10 WHERE p01=:t10_p01', $t10, array('t10_p01'=>$t18["t10p01"]));
		if( in_array($calledfrom, array("v_type", "v_t18", "v_hota04")) ){   

			if(in_array($calledfrom, array("v_type","v_hota04")) && $v_hota04>0){
				//Αν έρχομαι απο Κράτηση πρωτα βρισκω το Κατάστημα Κράτησης
				$t07p01 = pegasus_mysql_printfld('hota04', 't07', 'nr01=?', array($v_hota04));
			}else if(!empty($t10) && $t10['p010']!=-1 ) {
				//Διαφορετικά το Κατάστημα απο Ορισμός Αποδείξεων
				$t07p01 = $t10['p010']; // Ορισμός Αποδείξεων / Κατάστημα
			} else {
				//Διαφορετικά το Κατάστημα απο Τερματικό
				$t07p01 = $_SESSION['cor003_p104'];
			}

			$data['v_t07p01']['value'] = $t07p01;
		}


		if( $calledfrom == "v_t07p01" || $calledfrom == "v_a18p01" ){
			$t07p01=$v_t07p01;
			$a18p01=$v_a18p01;
		}

		///kvdikos metriti
		$t10_p06 = $t10['p06'];

		// if( $calledfrom == "v_type" || $calledfrom == "v_t18" || $calledfrom == "v_t07p01" || $calledfrom == "v_a18p01"  ){   
		// 	$data['v_aa']['value'] = account_make_invoice_num($t07p01, $t10_p06, $a18p01, false);
		// }

		if(pegasus_module_exists('stores')) {
			$data['v_t07p01']['hidden'] = false;	
		}

        return array(
            'ok'	=> 1,
            'data'	=> $data,
			'container_properties' => $container_properties
        );
     }

	private  function _refresh_screen_values_type_4($container_id, $calledfrom, $data){
		// die("Refresh της οθόνης για type == 4 ");
        $v_tran01 = $this->input_data['v_tran01'];
        $v_a14 	  = $this->input_data['v_a14'];

		//Αρχικοποίηση Παραστατικού σε περίπτωση που γινεται αλλαγή Κράτησης
		$data['v_tran01']['value']   = 0;
		$data['v_tran01']['display'] = "";
		$data['v_tran01']['hidden']  = false;
		$data['v_a14']['hidden']     = false;
		$data['v_hota04']['hidden']  = true;

		$data['v_instalments']['value']  = 0;
		$data['v_instalments']['hidden'] = true;
		$data['v_mailphone']['value'] 	 = 0;
		$data['v_mailphone']['hidden']   = true;

		
		//v_tran01 query			
		$sqlParams_v_tran01 = array();
		$sql_v_tran01		= "	SELECT tran01.* 
								FROM tran01
								JOIN t35 ON t35.tbl_nr = tran01.nr01
								WHERE t35.tbl='tran01' and t35.p03<>0 ";
						
		$v_a01_where = '';
		pegasusSetGlobalVar($container_id . '_where_v_a01', $v_a01_where);
		pegasusSetGlobalVar($container_id . '_query_v_tran01', array('sql' => $sql_v_tran01, 'sqlParams' => $sqlParams_v_tran01));
		
		$query_v_tran01 = array('sql' => $sql_v_tran01, 'sqlParams' => $sqlParams_v_tran01);
		pegasus_mysql_use( "select count(*) as cnt  from (" .$query_v_tran01['sql'] . ") as tt", $tran01, $query_v_tran01['sqlParams']);

		if($tran01['cnt'] == 0 ){
			$data['v_tran01']['hidden'] = true;
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=> $_SESSION['peg_dic_account00_invoice_with_balance_was_not_found']
			);
		}

		if(!($v_tran01>0)) {
			return array(
				'ok'	=> 0,
				'data'	=> $data,
				'error_message'	=>  '<div class="alert_message">' . $_SESSION['peg_dic_account00_select_tran01'] . '</div>'
		   );
   
		}
	
		$sql = "SELECT  tran01.p61, 
 						tran01.sp00, 
						tran01.p105, 
						tran01.p00,
						mydt10.einv 	AS mydt10_einv,
						mydt10.mark		AS mydt10_mark,
						a01.p19			AS a01_p19, 
						tran20.p02     	AS tran20_p02,
						tran20.p00     	AS tran20_p00
				FROM tran01
				JOIN a01 ON a01.nr01 = tran01.p61
				JOIN tran20 ON tran20.p01=tran01.p105
				LEFT JOIN mydt10 ON mydt10.tbl = 'tran01' AND mydt10.tbl_nr01=tran01.nr01
				WHERE tran01.nr01 = :nr01
				and mydt10.auth_cd !='' and mydt10.einv>0
			";

		$values = array('nr01'	=> $v_tran01);
		pegasus_mysql_use($sql, $tran01, $values);
		
		$data['v_tran01']['value']   = $v_tran01;
		$data['v_tran01']['display'] = $v_tran01;
		
		//Έλεγχος αν είναι Φορτωτική Ηλεκτρονικής Τιμολόγησης (Pegasus Web App [1] & Τοπικό[51])
		if(!in_array($tran01['mydt10_einv'], array(1, 51))) {
			return array(
				 		'ok'	=> 0,
				 		'data'	=> $data,
				 		'error_message'	=>  '<div class="alert_message">' . $_SESSION['peg_dic_account00_mydt10_einv_is_empty'] . '</div>'
					);
		}

        //Εύρεση στοιχείων από τη Φορτωτική
		$data['v_a01']['value']    = $tran01['p61'];
		$data['v_a01']['display']  = $tran01['a01_p19'];
		$data['v_a01']['hidden']   = false;
		$data['v_a01']['readonly'] = true;

		// Τύπος
		$data['v_tran01p105']['value']    = $tran01['p105'];
		$data['v_tran01p105']['display']  = $tran01['tran20_p02'];
		$data['v_tran01p105']['hidden']   = false;
		$data['v_tran01p105']['readonly'] = true;

		//Σειρά
		$data['v_tran01sp00']['value']    = $tran01['sp00'];
		$data['v_tran01sp00']['hidden']   = false;
		$data['v_tran01sp00']['readonly'] = true;

		// Αριθμός
		$data['v_tran01p00']['value']    = $tran01['p00'];
		$data['v_tran01p00']['hidden']   = false;
		$data['v_tran01p00']['readonly'] = true;
		
		//Υπολογισμός Υπολοίπου από 't35'
		$ypoloipo = pegasus_mysql_printfld('t35', 'p03', 'tbl="tran01" AND tbl_nr=:nr01', array('nr01' => $v_tran01));

		if(abs($ypoloipo)>0){
			$data['v_info_message']['hidden'] = false;
			$yp_formatted = number_format(abs($ypoloipo), 2, $_SESSION['cor000_decimal_char'] , '' );
			$data['v_info_message']['value'] = str_replace('##yp_formatted##', $yp_formatted, $_SESSION["peg_dic_account00_message_ypoloipo_poso"]);	
		}		

		$data['v_amount']['value']  = abs($ypoloipo);
		$data['v_amount']['hidden'] = false;
		
		if( abs($ypoloipo)==0 ) {
			return array(
				 		'ok'	=> 0,
				 		'data'	=> $data,
				 		'error_message'	=>  '<div class="alert_message">' . $_SESSION['peg_dic_account00_tran01_was_fully_paid'] . '</div>'
					);			
		}


		if(!($v_a14 > 0)){
			$data['v_pos00_02']['value']   = 0;
			$data['v_pos00_02']['display'] = '';
		}
		
		/**
		 * Έλεγχος και αρχικοποίηση του πεδίου v_a14 (μόνο αν έχει οριστεί Φορτωτική)
		 */
		$data['v_a14']['hidden'] = true;
		if($v_tran01 > 0) {
			$_query_v_paytype = pegasusGetGlobalVar($container_id . '_query_v_a14');
			$_query_v_paytype['sqlParams']['tran01'] = $v_tran01;
			
			$a14_selected = false;
			if($v_a14 > 0 ){
				pegasus_mysql_use( 
					"SELECT * FROM (" . $_query_v_paytype['sql'] . ") AS ttt where ttt.nr01 = :v_a14", 
					$a14, 
					array_merge($_query_v_paytype['sqlParams'], array("v_a14" => $v_a14))
				);

				if($a14["nr01"] > 0 ){
					$a14_selected = true;
				}
			}

			if(!$a14_selected){
				pegasus_mysql_use($_query_v_paytype['sql'], $a14, $_query_v_paytype['sqlParams']);
			}
			
			pegasusSetGlobalVar($container_id . '_query_v_a14', $_query_v_paytype);

			if(!($a14['nr01'] > 0)){				
				return array(
					'ok'	=> 0,
					'data'	=> $data,
					'error_message'	=>  $_SESSION['peg_dic_account00_payment_type_not_found']
			   );
			}
			
			$data['v_a14']['value']   = $a14['nr01'];
			$data['v_a14']['display'] = $a14['p01'];
			$data['v_a14']['hidden']  = false;
			
		}

		$data['v_pos00_02']['hidden'] = true;
		if(($a14['nr01'] > 0)){
			$data['v_pos00_02']['readonly'] = false;
			$data['v_pos00_02']['hidden']   = false;

			// print_r($input_data);
			$_query_v_pos00_02= pegasusGetGlobalVar($container_id . '_query_v_pos00_02');
			$_query_v_pos00_02['sqlParams']['tran01'] = $v_tran01;
			$_query_v_pos00_02['sqlParams']['a14']    = $a14['nr01'];
			pegasus_mysql_use($_query_v_pos00_02['sql'], $pos00_02, $_query_v_pos00_02['sqlParams']);
			pegasusSetGlobalVar($container_id . '_query_v_pos00_02',$_query_v_pos00_02);
		
			pegasus_mysql_use("select pos00_02.*, count(*) as cnt from ( " . $_query_v_pos00_02['sql'] . ") as pos00_02 ", $pos00_02, $_query_v_pos00_02['sqlParams']);
			pegasus_mysql_use('SELECT * FROM pos00_01 WHERE nr01 = :pos00_01_nr01', $pos00_01, array("pos00_01_nr01" => $pos00_02['pos00_01']));
						
			if($pos00_02['cnt'] == 1){
				$data['v_pos00_02']['readonly'] = true;
				$data['v_pos00_02']['value']    = $pos00_02['nr01'];
				$data['v_pos00_02']['display']  = $pos00_02['pos00_01_p01'];

				pegasus_mysql_use('SELECT * FROM tran20 WHERE tran20.p01 = :tran01_p105', $tran20, array("tran01_p105" => $tran01['p105']));
				pegasus_mysql_use('SELECT * FROM t02 WHERE p01=:tran20_p04', $t02, array("tran20_p04" => $tran20['p04']));
				

				$device_properties = pos00_device_properties::get_properties($pos00_01['p02']);

				// Δέχεται Δόσεις
				$data['v_instalments']['hidden'] = true;
				$data['v_instalments']['value']  = 0;

				/**
				 * Δεχόμαστε δόσεις μόνο αν:
				 * - Το POS υποστηρίζει δόσεις 
				 * - Έχει γίνει και η αντίστοιχη επιλογή στο pos00_02.p00
				 * - Είναι για παραστατικό είσπραξης 
				 */
				if($device_properties['instalments']==true && $pos00_02['p00']==1 && $t02['p03']>0) {
					$data['v_instalments']['hidden'] = false;
				}

				// Δέχεται Mail/Phone Order
				$data['v_mailphone']['hidden'] = true;
				$data['v_mailphone']['value']  = 0;
				if($pos00_02['p01'] == 1 && $t02['p03'] > 0) { // Το περιορίζω και στις Φορτωτικές είσπραξης.
					//$data['v_mailphone']['hidden'] = false;
					$data['v_mailphone']['value']  = $pos00_02['p01'];

					//Μήνυμα για "mailphone"
					$data['v_info_message']['value'] .= str_replace('##eftpos##', $a14['p01'], $_SESSION["peg_dic_account00_message_mailphone"]);
					$data['v_info_message']['hidden'] = false;
				}

				// Παραστατικό με αρνητικό συντελεστή χρέωσης = Επιστροφή
				$data['v_idtorefund']['value'] = 0;
				if($t02['p03'] < 0 && $device_properties['void'] == true) {
					$data['v_idtorefund']['hidden'] = false;
				}

				// Δέχεται Ολοκλήρωση προέγκρισης
				$data['v_preauthid']['hidden'] = true;
				$data['v_preauthid']['value']  = '';
				if($pos00_02['p02'] == 1 && $t02['p03'] > 0) { // Το περιορίζω και στα παραστατικά είσπραξης.
					$data['v_preauthid']['hidden'] = false;
				}

				$data['v_profortosi']['hidden'] = true;
				$data['v_profortosi']['value']  = 0;
				if($device_properties['preload'] == true && $t02['p03'] > 0) { // Το περιορίζω και στα παραστατικά είσπραξης.
					$data['v_profortosi']['hidden'] = false;
				}
			}

			if($pos00_02['cnt'] == 0){
				$data['v_pos00_02']['value']   = 0;
				$data['v_pos00_02']['display'] = '';

				$data['v_instalments']['value']  = 0;
				$data['v_instalments']['hidden'] = true;

				$data['v_mailphone']['value']  = 0;
				$data['v_mailphone']['hidden'] = true;

				$data['v_idtorefund']['value']  = 0;
				$data['v_idtorefund']['hidden'] = true;

				$data['v_idtorefund_txt']['value']  = '';
				$data['v_idtorefund_txt']['hidden'] = true;

				$data['v_preauthid']['value']  = '';
				$data['v_preauthid']['hidden'] = true;

				$data['v_profortosi']['value']  = 0;
				$data['v_profortosi']['hidden'] = false;
			}
 
		}
		
        return array(
            'ok'	=> 1,
            'data'	=> $data
        );
	}



    public function pay_button(){

        // die("Έναρξη  διαδικασίας πληρωμής στο POS");

        $v_amount = $this->input_data['v_amount'];
        $v_type   = $this->input_data['v_type'];

        // Έλεγχος ότι το ποσό είναι μεγαλύτερο του μηδενός
        if($v_amount <= 0 && $this->no_amount_check == 0) {
            return array(
                'ok'	=> 0,
                'msg'	=> $_SESSION['peg_dic_account00_amount_greter_than_zero']
            );
        }
		
        if($v_type==1 || $v_type==4){
			//$data['message'] = '<div class="peg_alert_info_plain">' .$a55_msg. '</div>';
			return call_user_func_array(array($this, "_pay_button_type_".$v_type), array());
            //return $this->_pay_button_type_1();
        }else{
            return $this->_pay_button_type_2_3();
        }
        
    }

    private function _pay_button_type_1(){
        // die("Ετεροχρονισμένη Πληρωμή (Είσπραξη ή Επιστροφή) σε Παραστατικο");
        
        $v_amount 			= $this->input_data['v_amount'];
        $v_pos00_02 		= $this->input_data["v_pos00_02"]; //Ρυθμίσεις POS για παραστατικό πελάτη 
        $v_a55 				= $this->input_data['v_a55'];
		$v_profortosi 		= $this->input_data['v_profortosi'];
		$v_idtorefund 		= $this->input_data['v_idtorefund'];
		$v_idtorefund_txt 	= $this->input_data['v_idtorefund_txt'];
		$v_preauthid 		= $this->input_data['v_preauthid'];
		$v_instalments 		= $this->input_data['v_instalments'];
        $v_hota04 			= $this->input_data['v_hota04'];


		$ypoloipo = invoices_calc_a55_aneisprakto($v_a55, 'a55', false);
		if( ($v_amount -  abs($ypoloipo)) > 0.0001) {
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_account00_amount_not_greater_from_remaining']
			);
		}

		pegasus_mysql_use(
			"SELECT pos00_02.*
                FROM pos00_02
                WHERE pos00_02.nr01 = :pos00_02_nr01", 
			$pos00_02, 
			array("pos00_02_nr01" => $v_pos00_02)
        );
		
		pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02["pos00_01"]));

		//Έλεγχος πλήθους Δόσεων
		if($pos00_02['p00']==1){
			if($pos00_01["p02"]==4){
				//VIVA
				if($v_instalments<1 || $v_instalments>36){
					$msg = str_replace(array("##min##", "##max##"), array(1, 36), $_SESSION['peg_dic_account00_pay_instalments_not_valid']);
					return array(
						'ok'	=> 0,
						'msg'	=> $msg
					);	
				}
			}
		}

		//* Αν βάλουμε και άλλες λογικές που θέλουμε να συμπληρώνουμε το pos00_04_init με ΜΚ, να μπουν εδώ.
		if($v_idtorefund > 0) {
			$pos00_04_init = $v_idtorefund;
		}
		$txnid_init = '';
		// Είτε το ένα, είτε το άλλο θα είναι γεμάτο, ποτέ και τα δύο μαζί
		// Θα μπορούσα να ελέγχω και εδώ αν είναι παραστατικό είσπραξης ή επιστροφής αλλά νομίζω είναι λίγο περιττό.
		if(!empty($v_idtorefund)) {
			if($v_idtorefund == -1 && !empty($v_idtorefund_txt)) {
				$txnid_init = $v_idtorefund_txt;
			}else{
				$txnid_init = pegasus_mysql_printfld('pos00_04', 'txnid', 'nr01 = ?', array($v_idtorefund));
			}
		}elseif(!empty($v_preauthid)) {
			$txnid_init = $v_preauthid;
		}

		//Το πεδίο "v_mailphone" δε διαβαζεται πλέον απο το Request αλλα απο τις Ρυθμίσεις POS
		$v_mailphone = $pos00_02["p01"];

		//βαζω το hota04 στην initiate
		$initiate_payment = new pos00_initiate_payment();
        $initiate_payment_res = $initiate_payment->initiate(
			$v_amount, 
			$pos00_02["pos00_01"], 
			$this->find_t02_for_new_pos00_04(), 
			$v_a55, 
			$pos00_02["nr01"], 
			$v_profortosi,
			$txnid_init,
			$v_instalments,
			$v_mailphone,
			$pos00_04_init,
			$v_hota04
		);

		if($initiate_payment_res["ok"] != 1){
			return $initiate_payment_res;
		}

		$pos00_04_nr01 = $initiate_payment_res['pos00_04_nr01'];		

		return array(
			'ok'	=> 1,
			'data' => array(
				'pos00_04_nr01'	=> $pos00_04_nr01, 
				'pos00_01' => $pos00_01, //Το περνάω γιατι το χρειάζεται για να βρει τον τυπο πληρωμης 
				'amount' => $v_amount
			)
		);

    }

     private function _pay_button_type_2_3(){

        $v_t18 =    $this->input_data['v_t18'];
        $v_type =   $this->input_data['v_type'];
        $v_t08 =    $this->input_data['v_t08'];
        $v_a01 =    $this->input_data['v_a01'];
        $v_a18 =    $this->input_data['v_a18'];
        $v_t07 =    $this->input_data['v_t07'];
        $v_amount = $this->input_data['v_amount'];
        $v_hota04 = $this->input_data['v_hota04'];
		$v_instalments 	  = $this->input_data['v_instalments'];
		$v_idtorefund_txt = $this->input_data['v_idtorefund_txt'];

        // die("Προείσπραξη ή Επιστροφή Προείσπραξης");
        pegasus_mysql_use('select * from t18 where nr01=?;' , $t18 , array($v_t18) );
		$t18_mydt50 = pegasus_mysql_printfld('q31', 'p05', 'p01 = "620019" AND p03 = :t18_t10p01', array('t18_t10p01' => $t18['t10p01'])); // Το βρίσκουμε από q31 γιατί αφαιρέσαμε το t18.mydt50
        pegasus_mysql_use('select * from pos00_01 where nr01=?;' , $pos00_01 , array($t18['pos00_01']) );
        $tidnsp = $pos00_01["tidnsp"];
		/**
		 * Ε: 10001355 Δ: 10169584
		 * Αφαίρεση ελέγχου καταχώρισης tidnsp από το webApp. Ο έλεγχος μετατέθηκε στο service
		 * 
		 */
        // if(empty($tidnsp)){
        //     return array(
        //         'ok'	=> 0,
        //         'msg'	=> $_SESSION['peg_dic_account00_tidnsp_missing']
        //     );
        // }

        pegasus_mysql_use('select * from a01 where nr01=?;' , $a01 , array($v_a01) );	
		if(!$a01['nr01']>0){
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_account00_customer_not_chosen']
			);
		}

		$txnid_init = '';

		if($v_type == 3){ //Ακύρωση προηγούμενης Απόδειξης είσπραξης 
			pegasus_mysql_use('select * from t08 where nr01=?;' , $t08 , array($v_t08) );
			if(!$t08['nr01']>0){
				return array(
					'ok'	=> 0,
					'msg'	=> $_SESSION['peg_dic_account00_receipt_not_chosen']
				);
			}	
			
			//Υπολογισμός Υπολοίπου Απόδειξης από 't35'
			if(($v_amount - $t08['p0109']) > 0.0001) {
				return array(
					'ok'	=> 0,
					'msg'	=> $_SESSION['peg_dic_account00_amount_not_greater_from_remaining'].": ".number_format($t08["p0109"], 2, $_SESSION['dek_poin'], '')
				);
			}

			if(!empty($v_idtorefund_txt)) {
				$txnid_init = $v_idtorefund_txt;
			}
		}

		$einv01_nr01 = einv_check_settings_before_save($v_a18, $t18['t10p01'], $v_t07, 't08');

		$msg = '';
		$t08_t38s_string = "";
		// Υπολογισμοί των παραστατικών της απόδειξης, Αν υπάρχουν.
		if($v_type == 2) {

			//Έλεγχος πλήθους Δόσεων
			if($t18['p03']>0){
				if($pos00_01["p02"]==4){
					//VIVA
					if($v_instalments<1 || $v_instalments>36){
						$msg = str_replace(array("##min##", "##max##"), array(1, 36), $_SESSION['peg_dic_account00_pay_instalments_not_valid']);
						return array(
							'ok'	=> 0,
							'msg'	=> $msg
						);	
					}
				}
			}
		
			foreach ($this->input_data as $key => $value) {
				if (preg_match($this->dyn_fld_pattern_nr01, $key, $matches)) {
					$i = $matches[1];
					$rec_nr01s[$i] = $value;
				}
				if (preg_match($this->dyn_fld_pattern_amount, $key, $matches)) {
					$i = $matches[1];
					$rec_amounts[$i] = $value;
				}
			}
			if(!empty($rec_nr01s)) {
				// Αν έχω έστω ένα επιλεγμένο παραστατικό, κάνω το amount = 0;
				$v_amount = 0;
			}
			
			foreach ($rec_nr01s as $key => $value) {
				if(empty($rec_nr01s[$key])) {
					if(!empty($msg)) {
						$msg .= "<br>";
					}
					$msg .= $_SESSION['peg_dic_account00_type_2_multi_a55_err1']; // No invoice selected.
					continue;
				}
				pegasus_mysql_use("SELECT * FROM a55 WHERE nr01 = ?", $a55, array($rec_nr01s[$key]));
				$a10_p00 = pegasus_mysql_printfld('a10', 'p00', 'p01 = ?', array($a55['p05']));
				$msg_prefix = "<u>" . $a10_p00 . " " . $a55['p701'] . " " . $a55['p06'] . " (" . $rec_nr01s[$key] . ")</u>";

				if (isset($rec_amounts[$key])) {
					$rec_amount = $rec_amounts[$key];
					if(empty($rec_amounts[$key])) {
						if(!empty($msg)) {
							$msg .= "<br>";
						}
						$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_type_2_multi_a55_err2']; // Amount for the selected invoice is empty
					}else{
						$t35_ypol = pegasus_mysql_printfld('t35', 'p03', 'tbl = "a55" AND tbl_nr = ?', array($rec_nr01s[$key]));
						pegasus_mysql_use('SELECT einv, einv_nr FROM mydt10 WHERE tbl = "a55" AND tbl_nr01 = ?', $mydt10, array($rec_nr01s[$key]));

						if($mydt10['einv']==51 && pegasus_module_exists('einv03')){
							//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση από Τοπικό[51]
							$mydt10_einv01_nr01 = einv03_get_settings_from_fem012($mydt10['einv_nr']);
						}else{
							$mydt10_einv01_nr01 = $mydt10['einv_nr'];
						}

						//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση (Pegasus Web App[1] & Τοπικό[51])
						if(!in_array($mydt10['einv'], array(1, 51))) {
							if(!empty($msg)) {
								$msg .= "<br>";
							}
							$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_type_2_multi_a55_err4']; // Invoice must be sent with Pegasus e-Invoicing.
						}elseif($mydt10_einv01_nr01 != $einv01_nr01){
							if(!empty($msg)) {
								$msg .= "<br>";
							}
							$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_type_2_multi_a55_err5']; // Invoice has been sent to the provider with different credentials.

						}elseif($rec_amount > $t35_ypol) {
							if(!empty($msg)) {
								$msg .= "<br>";
							}
							$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_type_2_multi_a55_err3'] . " " . $t35_ypol; // Collection amount exceeds the invoice's balance
							// return;
						}else{
							$t08_t38s_string .= $value . ';' . $rec_amounts[$key] . '#';
							$v_amount += $rec_amounts[$key];
						}
					}
				}else{
					if(!empty($msg)) {
						$msg .= "<br>";
					}
					$msg .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_type_2_multi_a55_err2']; // Amount for the selected invoice is empty
				}
			}
			//* Είναι το string που αποθηκεύω στο pos00_04.t08_t38s /// Καλύτερο var name
			$t08_t38s_string = trim($t08_t38s_string, '#');
		}

		if(!empty($msg)) {
			return array(
				'ok'	=> 0,
				'msg'	=> $msg
			);
		}
		// echo '<pre>' . $t08_t38s_string . '</pre>';
		// echo '<pre>' . print_r(explode('#', trim($t08_t38s_string, '#')), 1) . '</pre>';

		$t08_nr01 =  pegasus_mysql_newrec('t08');

		$pos_protocol   = pos00_device_properties::get_pos_protocol($pos00_01["p02"]); 

		$issuer_branch = pegasus_mysql_printfld('mydt00', 'taxnet_cd', 'nr01 = 1');
		$issuer_vat    = pegasus_mysql_printfld('cor000', 'f00p204', 'nr01 = 1');

		if(pegasus_module_exists("stores")) {
			pegasus_mysql_use('SELECT * FROM t07 WHERE p01 = ?', $t07, array($v_t07));
			$issuer_branch = $t07['p06'];
			// Αν το κατάστημα που επέλεξα έχει Ομάδα
			if(!empty($t07['p07'])) {
				pegasus_mysql_use('SELECT * FROM t05 WHERE p01 = ?', $t05, array($t07['p07']));
				// Και η ομάδα έχει ΑΦΜ.
				if(!empty($t05['p204'])) {
					// Παίρνω vat από αυτό.
					$issuer_vat = $t05['p204'];
				}
			}
		}
		
		if(empty($issuer_branch)) {
			$issuer_branch = 0;
		}
		$seira = $v_a18;
		// Παράμετρος - Το λεκτικό του παραστατικού προστίθεται στη σειρά
		if($_SESSION['mydt00_p103'] == 1) {
			$t10_p00 = pegasus_mysql_printfld('t10', 'p00', 'p01 = ?', array($t18['t10p01']));
			if($seira != '') {
				$seira = '-'.$seira;
			}
			$seira = $t10_p00 . $seira;
		}

		$ret = einv_create_payment_signature(
			date("Y-m-d"),
			$issuer_vat,
			$issuer_branch, 
			$t18_mydt50,
			$seira, // σειρά
			0, // αριθμός
			0, 
			$v_amount,  
			0,
			$v_amount, 
			$v_amount, 
			$tidnsp, 
			"t08",
			$t08_nr01,
			'',
			$einv01_nr01, 
			$pos_protocol
		);

		if($ret['ok']!=1){
			return array(
				"ok" =>  0, 
				"msg" => $ret["msg"]
			);
		}	

		

	    $t19_nr01 = pegasus_mysql_newrec('t19');
		$arr1 = array('nr01');          $arr2 = array( $t19_nr01 );
		array_push($arr1 , 'tbl');      array_push($arr2 , 't08'); 
		array_push($arr1 , 'tbl_nr01');   array_push($arr2 , $t08_nr01); 
		array_push($arr1 , 'tidnsp');   array_push($arr2   , $tidnsp); 
		array_push($arr1 , 'init_am');   array_push($arr2  , $v_amount); 	
		array_push($arr1 , 'p_sign');    array_push($arr2  , $ret["data"]["p_sign"]); 
		array_push($arr1 , 'p_sign_s');    array_push($arr2  , $ret["data"]["p_sign_string"]); 
		pegasus_mysql_insert('t19' ,  $arr1 , $arr2);


		$t08_p600 = 0;
		if($v_type == 3){
			$t08_p600 = $t08['nr01'];
		}		 
		
		//Το πεδίο "v_mailphone" δε διαβαζεται πλέον απο το Request αλλα απο τις Εισπράξεις/Επιστροφές EFTPOS 
		$mailphone = $t18["p01"];  
		
		$pos00_04_array = array(
			"pos00_01" 	=> $pos00_01['nr01'],
			"t19" 		=> $t19_nr01,
			"t02p01" 	=> $this->find_t02_for_new_pos00_04(),
			"amount" 	=> $v_amount,
			"txnidinit" => $txnid_init,
			"t08_p701" 	=> $v_a18,
			"t08_p0121" => $v_t07,
			"t08_p03" 	=> $a01['p21'],
			"t08_p600" 	=> $t08_p600,
			"t18" 		=> $v_t18,
			"t08_t38s" 	=> $t08_t38s_string,
			"hota04" 	=> $v_hota04,
			"instalments"	=> $v_instalments,
			"mailphone" 	=> $mailphone
		);
		$pos00_04_nr01 = pos00_set_pos_transaction(0, $pos00_04_array);  

		return array(
			'ok'	=> 1,
			'data' => array(
				'pos00_04_nr01'	=> $pos00_04_nr01, 
				'pos00_01' => $pos00_01, //Το περνάω γιατι το χρειάζεται για να βρει τον τυπο πληρωμης 
				'amount' => $v_amount
			)
		);
        
    }

	private function _pay_button_type_4(){
        // die("Ετεροχρονισμένη Πληρωμή (Είσπραξη ή Επιστροφή) σε Φορτωτική");
        
        $v_amount 			= $this->input_data['v_amount'];
        $v_pos00_02 		= $this->input_data["v_pos00_02"]; //Ρυθμίσεις POS για παραστατικό πελάτη 
		$v_profortosi 		= $this->input_data['v_profortosi'];
		$v_idtorefund 		= $this->input_data['v_idtorefund'];
		$v_idtorefund_txt 	= $this->input_data['v_idtorefund_txt'];
		$v_preauthid 		= $this->input_data['v_preauthid'];
		$v_instalments 		= $this->input_data['v_instalments'];
        $v_tran01 			= $this->input_data['v_tran01'];
		
		
		//Υπολογισμός Υπολοίπου από 't35' αντι για 'invoices_calc_a55_aneisprakto'
		$ypoloipo = pegasus_mysql_printfld('t35', 'p03', 'tbl="tran01" AND tbl_nr=:nr01', array('nr01' => $v_tran01));

		if( ($v_amount - abs($ypoloipo)) > 0.0001) {
			return array(
				'ok'	=> 0,
				'msg'	=> $_SESSION['peg_dic_account00_amount_not_greater_from_remaining']
			);
		}

		pegasus_mysql_use(
			"	SELECT pos00_02.*
                FROM pos00_02
                WHERE pos00_02.nr01 = :pos00_02_nr01", 
			$pos00_02, 
			array("pos00_02_nr01" => $v_pos00_02)
        );	
		
		pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02["pos00_01"]));

		//Έλεγχος πλήθους Δόσεων
		if($pos00_02['p00']==1){
			if($pos00_01["p02"]==4){
				//VIVA
				if($v_instalments<1 || $v_instalments>36){
					$msg = str_replace(array("##min##", "##max##"), array(1, 36), $_SESSION['peg_dic_account00_pay_instalments_not_valid']);
					return array(
						'ok'	=> 0,
						'msg'	=> $msg
					);	
				}
			}
		}

		//* Αν βάλουμε και άλλες λογικές που θέλουμε να συμπληρώνουμε το pos00_04_init με ΜΚ, να μπουν εδώ.
		if($v_idtorefund > 0) {
			$pos00_04_init = $v_idtorefund;
		}

		$txnid_init = '';
		// Είτε το ένα, είτε το άλλο θα είναι γεμάτο, ποτέ και τα δύο μαζί
		// Θα μπορούσα να ελέγχω και εδώ αν είναι παραστατικό είσπραξης ή επιστροφής αλλά νομίζω είναι λίγο περιττό.
		if(!empty($v_idtorefund)) {
			if($v_idtorefund == -1 && !empty($v_idtorefund_txt)) {
				$txnid_init = $v_idtorefund_txt;
			}else{
				$txnid_init = pegasus_mysql_printfld('pos00_04', 'txnid', 'nr01 = ?', array($v_idtorefund));
			}
		}elseif(!empty($v_preauthid)) {
			$txnid_init = $v_preauthid;
		}

		//Το πεδίο "v_mailphone" δε διαβαζεται πλέον απο το Request αλλα απο τις Ρυθμίσεις POS
		$v_mailphone = $pos00_02["p01"];
		
		//βαζω το hota04 στην initiate
		$initiate_payment = new pos00_initiate_payment();
        $initiate_payment_res = $initiate_payment->initiate(
			$v_amount, 
			$pos00_02["pos00_01"], 
			$this->find_t02_for_new_pos00_04(), 
			0, 
			$pos00_02["nr01"], 
			$v_profortosi,
			$txnid_init,
			$v_instalments,
			$v_mailphone,
			$pos00_04_init,
			0,
			$v_tran01
		);

		if($initiate_payment_res["ok"] != 1){
			return $initiate_payment_res;
		}

		$pos00_04_nr01 = $initiate_payment_res['pos00_04_nr01'];	
		return array(
			'ok'   => 1,
			'data' => array(
				'pos00_04_nr01'	=> $pos00_04_nr01, 
				'pos00_01' 		=> $pos00_01, //Το περνάω γιατι το χρειάζεται για να βρει τον τυπο πληρωμης 
				'amount' 		=> $v_amount
			)
		);

    }

	
	private function find_t02_for_new_pos00_04(){
		$t02 = 0;

		$v_type = $this->input_data['v_type'];
	
		if(in_array($v_type, array(1,4))){
			$v_pos00_02 = $this->input_data['v_pos00_02'];
			$t02 = pegasus_mysql_printfld("pos00_02", "t02p01", "nr01=?", array($v_pos00_02));

        }else{
			$v_t18 = $this->input_data['v_t18'];

			$query = 
					"SELECT t10.p04 as t02
					 FROM t18
					 JOIN t10 on t10.p01 = t18.t10p01
					 WHERE t18.nr01 = ?
					";
			pegasus_mysql_use($query, $t18, array($v_t18));
			$t02 = $t18["t02"];

        }
		return $t02;
	}


}




class account00_post_pos_payment_actions{
    
    private $pos00_04 = 0; // MK pos00_04
    private $amount = 0;
    private $amount_t = 0;
    private $tid = 0;
    private $akyr_msg = '';
    private $success = 0; //0: The payment failed from the POS, 1: The payment was successful

    private $t19; 		//Υπογραφή πληρωμής
    private $a55; 		//Το παραστατικό (μόνο στην περίπτωση της ετεροχρονισμένης)
    private $tran01; 	//Φορτωτική (μόνο στην περίπτωση της ετεροχρονισμένης)
	private $pos00_02; 	//Οι ρυθμίσεις pos για το παραστατικό 
	private $t02p01;
	private $este03_nr01s;
	private $a55_nr01s;

    public function __construct($pos00_04, $amount, $amount_t, $tid, $akyr_msg, $success) {
        $this->pos00_04  = $pos00_04;
        $this->amount    = abs($amount);
        $this->amount_t  = abs($amount_t);
        $this->tid       = $tid;
        $this->akyr_msg  = $akyr_msg;
        $this->success   = $success;  

        pegasus_mysql_use("select * from pos00_04 where nr01=:nr01" , $pos00_04 , array('nr01'=> $this->pos00_04));

        $this->t19 		= $pos00_04["t19"];
        $this->a55 		= $pos00_04["a55"];
        $this->tran01 	= $pos00_04["tran01"];
		$this->pos00_02 = $pos00_04["pos00_02"];
		$this->t02p01 	= $pos00_04["t02p01"];
		$this->este03_nr01s = $pos00_04["este03_nr01s"];
		$this->a55_nr01s 	= $pos00_04["a55_nr01s"];

		//* Σε περίπτωση που το POS έχει επιστρέψει αθροιστικά το pay_am + tip_am διορθώνω τα ποσά στην υπογραφή. Τα mydt13 δημιουργούνται από την υπογραφή μετά.
		if($this->amount > 0 && $this->amount_t > 0){
			$init_am = pegasus_mysql_printfld('t19', 'init_am', 'nr01 = ?', array($this->t19));
			if($init_am > 0){
				if(($init_am+$this->amount_t) == $this->amount){
            		$this->amount = abs($init_am);
				}
        	}
		}
    }

    public function exec(){       
		//* Προσθέσαμε το "toast_type" στο return για να μπορούμε να διαφοροποιήσουμε τα toast που εμφανίζουμε ανάλογα αν η πληρωμή ήταν επιτυχημένη ή αποτυχημένη.
        if(!($this->t19 > 0)){
            return array(
                "ok" => 0, 
                "msg" => $_SESSION['peg_dic_account00_signature_not_found'],
				"toast_type" => 'alert'
            );
        }

		pegasus_mysql_use("SELECT * FROM pos00_04 WHERE nr01 = :nr01", $pos00_04, array('nr01' => $this->pos00_04));

		if(!empty($pos00_04['t01'])) {
			return array(
				"ok" => 0,
				"msg" => $_SESSION['peg_dic_account00_pos00_04_t01_exists_err1'],
				"toast_type" => 'alert'
			);
		}

        //Αυτά τα if είναι προσωρινά και θα διαβάζουν πότε είμαι σε ετεροχρονισμένη/ταυτόχρονη από την κατάσταση του υποέκδοση στο παραστατικό ή στην απόδειξη
        if($this->success==1){
			$toast_type = 'success';
			if($pos00_04['este01']>0){
				if(!empty($this->este03_nr01s)){
					if(!empty($this->a55_nr01s) ){
						/**έχω πολλά a55 και εκτελώ ταυτόχρονη και δημιουργώ ένω t01 για 8.4 */
						$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success_estiasi();
					}else{
						/**έχω ένα a55 και εκτελώ ετεροχρονισμένη */
						$ret = $this->_exec_pos_payment_eteroxronismeni_to_a55_success();
					}
				}elseif(empty($this->este03_nr01s)){
					/**Από την οθόνη των αποδείξεων */
					if(!empty($this->a55_nr01s)){
						/**έχω πολλά a55 και εκτελώ ταυτόχρονη και δημιουργώ ένω t01 για 8.4 */
						$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success_estiasi();
					}else{
						/**έχω ένα a55 και εκτελώ ετεροχρονισμένη */
						$ret = $this->_exec_pos_payment_eteroxronismeni_to_a55_success();
					}
				}
			}elseif($this->a55 > 0 ){
				$a55_y_ekd = pegasus_mysql_printfld("a55", "y_ekd", "nr01 = ?", array($this->a55));
				if($a55_y_ekd == 0){
					$ret =  $this->_exec_pos_payment_eteroxronismeni_to_a55_success();
					if($ret["ok"] == 1){
						$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment'];
					}
				}
				else{
					$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success(); //Επιτυχής πληρωμή για Ταυτόχρονο παραστατικό
					if($ret["ok"] == 1){
						$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment'];
					}
				}

			
			}elseif($this->tran01>0){
				$ret =  $this->_exec_pos_payment_eteroxronismeni_to_tran01_success();
				if($ret["ok"] == 1){
					$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment'];
				}

			}else{
				$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success(); //Επιτυχής πληρωμή για 8.4(ΑπόδειξηΕίσπραξης), 8.5 (Απόδειξη πληρωμής)
				if($ret["ok"] == 1){
					$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment'];
				}
			} 
        }
        else{
			$toast_type = 'alert';
			if($this->a55 > 0 ){
				$a55_y_ekd = pegasus_mysql_printfld("a55", "y_ekd", "nr01 = ?", array($this->a55));
				if($a55_y_ekd == 0){
					$ret = $this->_exec_pos_payment_eteroxronismeni_to_a55_failure();
					if($ret["ok"] == 1){
						$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment_cancellation'];
					}
				}
				else{
					$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_failure(); //Αποτυχημένη πληρωμή για 8.4(ΑπόδειξηΕίσπραξης), 8.5 (Απόδειξη πληρωμής)
					if($ret["ok"] == 1){
						$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment_and_ypoekcancellation'];
					}
				}

			}elseif($this->tran01>0){
				$ret = $this->_exec_pos_payment_eteroxronismeni_to_tran01_failure();
				if($ret["ok"] == 1){
					$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment_cancellation'];
				}

			}else{
				$ret = $this->_exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_failure(); //Αποτυχημένη πληρωμή για 8.4(ΑπόδειξηΕίσπραξης), 8.5 (Απόδειξη πληρωμής)
				if($ret["ok"] == 1){
					$ret["msg"] = $_SESSION['peg_dic_account00_successful_payment_and_ypoekcancellation'];
				}
			}
			if(!empty($this->akyr_msg)) {
				$ret["msg"] .= "<br><br>Μήνυμα Ακύρωσης POS:<br>" . $this->akyr_msg;
			}
        }

		$ret['toast_type'] = $toast_type;

		return $ret;

    }

    private function _exec_pos_payment_eteroxronismeni_to_a55_success(){
        // die("Ετεροχρονισμένη επιτυχής πληρωμή παραστατικού");

		pegasus_mysql_use("select * from pos00_02 where nr01 =? ", $pos00_02, array($this->pos00_02) ); 
		pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02['pos00_01']));
		pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($this->pos00_04));
		// print_r($pos00_01);
		$t01_data = array(
			"p02"  => date("Y-m-d"),
			"p02t" => date("H:i:s"),
			"p302" => $this->a55,
			"p07"  => $this->t02p01, 
			"vp03" => $this->amount,
			"a14_nr01" => $pos00_02["a14"], 
			"p05" => str_replace('##pos00_01_p01##', $pos00_01['p01'], $_SESSION['peg_dic_pos00_pos_transaction'])
		);
		pegasus_mysql_use("select * from a55 where nr01 = ?", $a55, array($this->a55));
		$t01_nr01 = pos00_set_account_transaction(0, $t01_data, "a55", $a55);
		pos00_set_pos_transaction($this->pos00_04, array("t01" => $t01_nr01));

        pegasus_mysql_update(
            "t19", 
            array("pay_am", "tip_am", "tid", "t01"), 
            array($this->amount, $this->amount_t, $this->tid, $t01_nr01), 
            "nr01=?", 0, 1, 1, 
            array($this->t19)
        );
		
		if(pegasus_module_exists('estiasi')){
			if(!empty($pos00_04['este03_nr01s'])){
				$nr01_array = explode("#", $pos00_04['este03_nr01s']);
				$este55 = pegasus_mysql_printfld('este55', 'nr01', 'p03=?', array($_SESSION['user']));
				foreach ($nr01_array as $nr01) {
					$este03nr01 = pegasus_mysql_printfld('este03', 'nr01', 'nr01=:product', array('product' => $nr01));
					if(empty($este03nr01)){
						/**Αν είμαι από REST */
						$este03nr01 = pegasus_mysql_printfld('este03', 'nr01', 'uid=:product', array('product' => $nr01));
					}
					if($este03nr01 > 0){
						$query_i36 = " select nr01 from este03 where p107 = :este03nr01 ";
						$res_i36 = pegasus_query($query_i36, array('este03nr01' => $este03nr01));
						while ($row = pegasus_fetch_assoc($res_i36)) {
							$i36_array[] = $row['nr01'];
						}
						if(is_array($i36_array) && count($i36_array) > 0){
							$in_stmt_arr = pegasus_mysql_create_in($i36_array, 'este03_nr01');
							$in_str = $in_stmt_arr['sql'];
							pegasus_mysql_update(
								'este03',
								array('p109', 'p110', 'p111', 'p112', 'p113' , 't01'),
								array(1, $pos00_04['a14'], '', '', $este55,  $t01_nr01),
								"nr01 in ($in_str)",
								0,
								1,
								1,
								$in_stmt_arr['sqlParams']
							);
						}
					}
				}
			}
		}
        return einv_send_payment_signature($this->t19); 	
    }

    private function _exec_pos_payment_eteroxronismeni_to_a55_failure(){
        // die("Ετεροχρονισμένη αποτυχημένη πληρωμή παραστατικού");
        pegasus_mysql_update("t19", array("akyr", "akyr_msg"), array(1, $this->akyr_msg), "nr01=?", 0, 1, 1, array($this->t19));
		$ret = einv_send_payment_signature($this->t19); 
		return $ret;
    }

	private function _exec_pos_payment_eteroxronismeni_to_tran01_success(){
        // die("Ετεροχρονισμένη επιτυχής πληρωμή Φορτωτικής");

		pegasus_mysql_use("select * from pos00_02 where nr01 =? ", $pos00_02, array($this->pos00_02) ); 
		pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02['pos00_01']));
		pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($this->pos00_04));
		// print_r($pos00_01);

		$t01_data = array(
			"p02"  		=> date("Y-m-d"),
			"p02t" 		=> date("H:i:s"),
			"p302" 		=> $this->tran01,			
			"p303" 		=> "18",
			"p07"  		=> $this->t02p01, 
			"vp03" 		=> $this->amount,
			"a14_nr01" 	=> $pos00_02["a14"], 
			"p05" 		=> str_replace('##pos00_01_p01##', $pos00_01['p01'], $_SESSION['peg_dic_pos00_pos_transaction'])
		);
		pegasus_mysql_use("select * from tran01 where nr01=?", $tran01, array($this->tran01));

		$t01_nr01 = pos00_set_account_transaction(0, $t01_data, "tran01", $tran01);
		pos00_set_pos_transaction($this->pos00_04, array("t01" => $t01_nr01));

        pegasus_mysql_update(
            "t19", 
            array("pay_am", "tip_am", "tid", "t01"), 
            array($this->amount, $this->amount_t, $this->tid, $t01_nr01), 
            "nr01=?", 0, 1, 1, 
            array($this->t19)
        ); 

        return einv_send_payment_signature($this->t19); 	
    }
	
    private function _exec_pos_payment_eteroxronismeni_to_tran01_failure(){
        // die("Ετεροχρονισμένη αποτυχημένη πληρωμή Φορτωτικής");

        pegasus_mysql_update("t19", array("akyr", "akyr_msg"), array(1, $this->akyr_msg), "nr01=?", 0, 1, 1, array($this->t19));
		$ret = einv_send_payment_signature($this->t19); 
		return $ret;
    }

    private function _exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success(){
        //die("Επιτυχής ταυτόχρονη πληρωμή");

        pegasus_mysql_use("select * from t19 where nr01 = :nr01", $t19, array("nr01" => $this->t19));
        if($t19['tbl']=='t08'){

			pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($this->pos00_04));
			$t18 = pegasus_mysql_use('SELECT * FROM t18 WHERE nr01 = :t18_nr01', $t18, array("t18_nr01" => $pos00_04['t18']));

			$t08_nr01 =  $t19['tbl_nr01'];
			$screen = new screen();
			$screen->container_id = pegasus_container_id_create(0 , session_id() , 't08_d');
			$screen->module       = 'receipts';
			$screen->_d           = 't08_d';
			$screen->table        = 't08';
			$screen->nr01         =  $t08_nr01;
			$screen->read_data_from_db();
			$screen->read_params_from_db();

			if($screen->data['permDeny']==1){
				return array(
					"ok" =>  0, 
					"msg" => $screen->data['permDenyMessage']
				);
			}

			$p_sign_s_array = explode(';', $t19['p_sign_s']);
			$dateTime = DateTime::createFromFormat('YmdHis',  $p_sign_s_array[2]);
			$date = $dateTime->format('Y-m-d');
			$time = $dateTime->format('H:i');
		
			$screen->data['nr01'] =  $t08_nr01;
			$screen->data['p05'] = $t18['t10p01']; // parastatiko
			$screen->data['p03'] = $pos00_04['t08_p03']; // λογαριασμός
			$screen->data['p08'] = "0";
			$screen->data['p701'] = $pos00_04['t08_p701']; // σειρά

			$screen->data['p0121'] = $pos00_04['t08_p0121']; // κατάστημα
			$screen->data['p01'] = $date;
			$screen->data['p02'] = $time;
			$screen->data['vp0105'] = 0;
			$screen->data['p0105'] = 0;
			$screen->data['p0109'] = 0;
			$screen->data['p600'] = $pos00_04['t08_p600']; // μκ απόδειξης που μετασχημάτισε (γεμάτο μόνο στις ακυρώσεις)
			
		
			$arr1 = array('nr01'); $arr2 = array(pegasus_mysql_newrec('t09'));
			array_push($arr1 , 'p01');     array_push($arr2 , $t18['t11p01']); 
			array_push($arr1 , 'p00');     array_push($arr2 , $t08_nr01); 
			array_push($arr1 , 'p03');     array_push($arr2 , $t19['init_am']); 
		
			array_push($arr1 , 'peg_flag');       array_push($arr2 , '2'); 
			array_push($arr1 , 'peg_mnr01');      array_push($arr2 , $t08_nr01); 
			array_push($arr1 , 'peg_mmnr01');     array_push($arr2 , 't08_d-' . $t08_nr01); 
			array_push($arr1 , 'peg_sess_id');     array_push($arr2 , session_id()); 
			pegasus_mysql_insert('peg_tmp_t09' ,  $arr1 , $arr2);

			$_REQUEST = $screen->data;
			$_REQUEST['no_confirm'] = 1;
			$ret = $screen->save_data();
			peg_close_d($screen->container_id);

			if(!$ret[0]){
				return array(
					"ok" =>  0, 
					"msg" => $ret[1]
				);
			}

			//Κράτηση Διαμονής εφόσον υπάρχει (Καταχώρηση 8.4 χωρίς σύνδεση με Παραστατικά)
			$hota04_nr01 = $pos00_04['hota04'];

			// Insert τα t38 αν υπάρχουν. Μετά το save_data για να έχει δημιουργηθεί το t08 και αντίστοιχα το t01 του.
			if(!empty($pos00_04['t08_t38s']) && pegasus_module_exists('account01')) {
				$rec_nr01_arr = array();

				$pairs = explode('#', $pos00_04['t08_t38s']);
				foreach ($pairs as $pair) {
					$fields = explode(';', $pair);

					$rec_nr01_arr[] = $fields[0];
					$rec_nr01     	= $fields[0];
					$rec_amount   	= $fields[1];
					
					if(!empty($rec_nr01) && !empty($rec_amount)) {
						$a55_t01 = pegasus_mysql_printfld('t01', 'nr01', 'p302 = ? and p303 = 2', array($rec_nr01)); //* το 2 ειναι μόνο για a55!
						$t08_t01 = pegasus_mysql_printfld('t01', 'nr01', 'p302 = ? and p303 = 6', array($t08_nr01)); //* το 6 είναι η ενημέρωση από απόδειξη

						$arr1 = array();	$arr2 = array();
						array_push($arr1, 'nr01');    array_push($arr2, pegasus_mysql_newrec('t38')); 
						array_push($arr1, 'p01');     array_push($arr2, $a55_t01); 
						array_push($arr1, 'p02');     array_push($arr2, $t08_t01); 
						array_push($arr1, 'p03');     array_push($arr2, 0); // Είναι πληρωμές από POS πάντα πιστώνουν. Εκτός αν είμαι χαζός.
						array_push($arr1, 'p04');     array_push($arr2, $rec_amount); //* Ίσως θέλω αρνητικό πρόσιμο αν το pos00_04 είναι refund ή void.

						pegasus_mysql_insert('t38', $arr1, $arr2);
					}
				}
				
				//Σύνδεση Κρατήσεων με την Αποδειξη - hota63
				$hota04_nr01 = 0;
				if(pegasus_module_exists('hot013')){ 
					//Έλεγχος αν όλα τα Παραστατικά συνδέονται με την ίδια Κράτηση
					$hota04_nr01 = hot013_find_hota04_from_a55($rec_nr01_arr);
				}
			}

			//Μόνο στις ακυρώσεις Απόδειξης που περιέχει Κράτηση
			if($pos00_04['t08_p600']>0){
				$hota04_nr01 = pegasus_mysql_printfld('hota63', 'hota04', 'tbl="t08" and tbl_nr01=:tbl_nr01', array('tbl_nr01'=>$pos00_04['t08_p600'])); 
			}
			
			if ($hota04_nr01>0 && pegasus_mysql_table_exists('hota63')){	
				//Ελεγχος αν υπάρχει ήδη η συνδεση			
				$hota63_nr01 = pegasus_mysql_printfld('hota63', 'nr01', 'hota04=:hota04 and tbl="t08" and tbl_nr01=:tbl_nr01', array('hota04'=>$hota04_nr01,'tbl_nr01'=>$t08_nr01));
	
				if(!($hota63_nr01>0)){
					$arr1 = array('nr01');			$arr2 = array(pegasus_mysql_newrec('hota63'));
					array_push($arr1, 'hota04');	array_push($arr2, $hota04_nr01);
					array_push($arr1, 'tbl');		array_push($arr2, 't08');
					array_push($arr1, 'tbl_nr01');	array_push($arr2, $t08_nr01);
					
					pegasus_mysql_insert('hota63', $arr1, $arr2);
				}
			}


            pegasus_mysql_use("select * from t01 where p303 = 6  and p302 = ? ", $t01, array($t19['tbl_nr01']));
            pegasus_mysql_update("pos00_04", array("t01"), array($t01['nr01']), "nr01=?", 0, 1, 1, array($this->pos00_04));

			pegasus_mysql_update(
				"t19", 
				array("pay_am", "tip_am", "tid", "t01"), 
				array($this->amount, $this->amount_t, $this->tid, $t01['nr01']), 
				"nr01=?", 0, 1, 1, 
				array($this->t19)
			); 

            return einv00_check_and_save('t08',$t19['tbl_nr01']);
        }
        else if($t19['tbl']=='a55'){
			//add t01
            //pegasus_mysql_update("pos00_04", array("t01"), array($t01['nr01']), "nr01=?", 0, 1, 1, array($this->pos00_04));

			pegasus_mysql_use("select * from pos00_02 where nr01 =? ", $pos00_02, array($this->pos00_02) ); 
			pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02['pos00_01']));
			pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($this->pos00_04));
			// print_r($pos00_01);
			$t01_data = array(
				"p02"  => date("Y-m-d"),
				"p02t" => date("H:i:s"),
				"p302" => $this->a55,
				"p07"  => $this->t02p01, 
				"vp03" => $this->amount,
				"a14_nr01" => $pos00_02["a14"], 
				"p05" => str_replace('##pos00_01_p01##', $pos00_01['p01'], $_SESSION['peg_dic_pos00_pos_transaction'])
			);
			pegasus_mysql_use("select * from a55 where nr01 = ?", $a55, array($this->a55));
			$t01_nr01 = pos00_set_account_transaction(0,  $t01_data, "a55", $a55); 
			pos00_set_pos_transaction($this->pos00_04, array("t01" => $t01_nr01));

			pegasus_mysql_update(
				"t19", 
				array("pay_am", "tip_am", "tid", "t01"), 
				array($this->amount, $this->amount_t, $this->tid, $t01_nr01), 
				"nr01=?", 0, 1, 1, 
				array($this->t19)
			); 
			
			return array(
				"ok" => 1, 
				"msg" => "Ολοκληρώθηκε η πληρωμή με επιτυχία"
			);
			
		}
        
    }

	private function _exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_success_estiasi(){
		pegasus_mysql_use("select * from pos00_02 where nr01 = ?", $pos00_02, array($this->pos00_02)); 
		pegasus_mysql_use("select * from pos00_01 where nr01 = ?", $pos00_01, array($pos00_02['pos00_01']));
		pegasus_mysql_use("select * from pos00_04 where nr01 = ?", $pos00_04, array($this->pos00_04));
		
		$t01_data = array(
			"p302" => $pos00_04['este01'],
			"p303" => 71,
			"pd101" => 'a14',
			"pd102" => $pos00_04['a14'],
			"p07"  => $_SESSION['este98_t02_84'],
			"p05" => str_replace('##pos00_01_p01##', $pos00_01['p01'], $_SESSION['peg_dic_pos00_pos_transaction']),
			"p02"   => date('Y-m-d'),
			"p02t"  => date("H:i")
		);
		/**Δημιουργία t01 */
		/**Χρησιμοποιώ την νέα συνάρτηση από το account, που μου επιστρέφει το καινούριο t01 που δημιούργησε*/
		$t01 = account_add_t01($t01_data, $this->amount);
		$t01_nr01 = $t01['nr01'];
		/**Update pos00_04 */
		pos00_set_pos_transaction($this->pos00_04, array("t01" => $t01_nr01));

        pegasus_mysql_update(
            "t19", 
            array("pay_am", "tip_am", "tid", "t01"), 
            array($this->amount, $this->amount_t, $this->tid, $t01_nr01), 
            "nr01=?", 0, 1, 1, 
            array($this->t19)
        );

		if(!empty($this->este03_nr01s)){
			/**Αν είμαι από πληρωμή ειδών */
			/**Σύνδεση este03 με t01 */
			$este03data = array_filter(explode('#', $this->este03_nr01s), function($value) {
				return trim($value) !== '';
			});
			$este03data = array_values($este03data);
			$in_stmt_arr = pegasus_mysql_create_in($este03data, 'este03_nr01');
			$in_str = $in_stmt_arr['sql'];

			pegasus_mysql_use("select * from este03 where nr01 in ($in_str)", $este03, $in_stmt_arr['sqlParams']);
			if(empty($este03)){
				/**Είμαι από REST */
				$where = "este03.uid in ($in_str)";
			}else{
				$where = "este03.nr01 in ($in_str)";
			}
			$este55 = pegasus_mysql_printfld('este55', 'nr01', 'p03=?', array($_SESSION['user']));
			pegasus_mysql_update(
				"este03", 
				array('p109', 'p110', 'p111', 'p112', 'p113' , 't01'),
				array(1, $pos00_04['a14'], '', '', $este55,  $t01_nr01), 
				$where, 0, 1, 1, 
				$in_stmt_arr['sqlParams']
			);
		}


		if(pegasus_module_exists('account01')){
			if(!empty($pos00_04['a55_nr01s']) && !empty($pos00_04['este03_nr01s'])){
				$a55data = explode('#', $pos00_04['a55_nr01s']);
				$a55data = array_filter($a55data, function($value) {
            		return !empty($value);
        		});
				$in_stmt_arr_a55 = pegasus_mysql_create_in($a55data, 'a55_nr01');
				$in_str_a55 = $in_stmt_arr_a55['sql'];

				$este03data = explode('#', $pos00_04['este03_nr01s']);
				$este03data = array_filter($este03data, function($value) {
            		return !empty($value);
        		});
				$in_stmt_arr_este03 = pegasus_mysql_create_in($este03data, 'este03_nr01');
				$in_str_este03 = $in_stmt_arr_este03['sql'];

				pegasus_mysql_use("select * from este03 where nr01 in ($in_str_este03)", $este03, $in_stmt_arr_este03['sqlParams']);

				if(empty($este03)){
					/**Είμαι από REST */
					$where = "este03.uid";
				}else{
					$where = "este03.nr01";
				}
				foreach($este03data as $value){
					$a55_query = 
						"SELECT 
							a55.nr01,
							este03.p104 
						from este03
						join este98 on este98.nr01=1 
						join i01 ON i01.pd101='este03' and i01.pd102=este03.nr01 
						join a55 on a55.nr01=i01.p06 and a55.p05!=este98.p244 and a55.p05!=este98.p245 
						join a10 on a55.p05=a10.p01 
						join t02 on t02.p01=a10.p04 and t02.p03>0 
						where $where = :este03nr01 and a55.nr01 in ($in_str_a55)
						limit 1";
					$query_params = array();
					$query_params['este03nr01'] = $value;
					$query_params = array_merge($query_params, $in_stmt_arr_a55['sqlParams']);
					pegasus_mysql_use($a55_query, $a55_res, $query_params);
	
					$a55_nr01 = $a55_res['nr01'];
					$t38_tot[$a55_nr01] += $a55_res['p104']; 
				}
			}elseif(!empty($pos00_04['a55_nr01s']) && empty($pos00_04['este03_nr01s'])){
				$a55data = explode('#', $pos00_04['a55_nr01s']);
				$a55data = array_filter($a55data, function($value) {
            		return !empty($value);
        		});
				foreach($a55data as $a55){
					if($a55){
						list($a55_nr01, $a55_amount) = explode(':', $a55);
						$t38_tot[$a55_nr01] = $a55_amount; 
					}
				}
			}

			foreach ($t38_tot as $a55_nr01 => $t38){
				$a55_t01 = pegasus_mysql_printfld('t01', 'nr01', 'p302 = ? and p303 = 2', array($a55_nr01));

				$arr1 = array();				$arr2 = array();
				array_push($arr1, 'nr01');    	array_push($arr2, pegasus_mysql_newrec('t38')); 
				array_push($arr1, 'p01');     	array_push($arr2, $a55_t01); 
				array_push($arr1, 'p02');     	array_push($arr2, $t01_nr01); 			// edw bazw to t01 tis kinissi  $t01_nr01 
				array_push($arr1, 'p03');     	array_push($arr2, 0); 					// Είναι πληρωμές από POS πάντα πιστώνουν. Εκτός αν είμαι χαζός.
				array_push($arr1, 'p04');     	array_push($arr2, $t38); 				//* Ίσως θέλω αρνητικό πρόσιμο αν το pos00_04 είναι refund ή void.
				
				pegasus_mysql_insert('t38', $arr1, $arr2);
			}
		}
		
		$sql_este01 = "SELECT 
						este01.nr01 AS este01_nr01,
						este01.p01 AS este01_p01,
						a01.p20 AS a01_p20,
						d23.p01 AS d23_p01,
						a01.nr01 AS a01_nr01,
						a01.p19 AS a01_p19,
						a01.p4 AS a01_p4,
						concat(ifnull(concat(d22.p02, ' '), ''), ifnull(concat(a01.p5, ' '), ''), ifnull(concat(a01.p6, ' '), '')) AS cp_city,
						a01.p7 as a01_p7
					FROM este01
					LEFT JOIN a01 on a01.nr01=este01.p05
					LEFT JOIN d23 ON d23.p01=a01.p4_1
					LEFT JOIN d22 ON d22.p01=a01.p4_3
					where este01.nr01 = :este01nr01 ";
		pegasus_mysql_use($sql_este01, $este01, array('este01nr01' => $pos00_04['este01']));

		pegasus_mysql_use("SELECT * FROM este98 WHERE 1=1",$este98); //??? να δουμε οτι χρειαζεται

		// pegasus_mysql_use('SELECT * FROM f00 WHERE 1=1',$f00);
		//*create mydt13 --> Δημιουργεί το mydt13
		$arr1 = array();               $arr2 = array();
		$mydt10_nr01 = pegasus_mysql_newrec('mydt10');
		array_push($arr1, 'nr01');   	array_push($arr2, $mydt10_nr01);

		array_push($arr1, 'einv');      array_push($arr2, '1');
		array_push($arr1, 'einv_nr');   array_push($arr2, $_SESSION['este98_einv01']); // $este98['fem012'] neo pedio sto este98 poy ua epilegoyme ta stoixeia toy paroxoy gia to K.K. toy 8.4
		
		$is_branch = pegasus_mysql_printfld('mydt00', 'taxnet_cd', 'nr01 = 1');											//Αρ.Εγκατάστασης Εκδότη
		$is_vat = pegasus_mysql_printfld('cor000', 'f00p204', 'nr01 = 1');												//ΑΦΜ Εκδότη
		$is_name =  $_SESSION['cor000_f00p203'] .' '. $_SESSION['cor000_f00p2031'] .' '. $_SESSION['cor000_f00p2032'];	//Επωνυμία Εκδότη
		$is_address = $_SESSION['cor000_f00p207'] .' '. $_SESSION['cor000_f00p208'];									//Διεύθυνση Εκδότη
		$is_city = $_SESSION['cor000_f00p206'];																			//Πόλη Εκδότη
		$is_zip = $_SESSION['cor000_f00p209'];																			//ΤΚ Εκδότη
		$is_tbl = 'cor000';																								//Πίνακας Εκδότη
		$is_nr01 = 1;																									//ΜΚ Πίνακα Εκδότη
		
		if(pegasus_module_exists('stores')){
			//Διαβαζω το καταστημα απο το t01.
			$store = pegasus_mysql_printfld('t01', 'p09', 'nr01=?', array($t01_nr01));
			//Aν το καταστημα εχει ομαδα και η ομαδα εχει ΑΦΜ τοτε διαβαζω απο εκει τα στοιχεια 
			pegasus_mysql_use("SELECT * FROM t07 WHERE p01=?", $t07, array($store));
			if(!empty($t07['p07'])){
				pegasus_mysql_use("SELECT * FROM t05 WHERE p01=?", $t05, array($t07['p07']));
				$is_branch = $t07['p06'];
				$is_country ='GR';
				if(!empty($t05['p204'])){
					$is_vat = $t05['p204'];
					$is_name =  $t05['p203'] .' '. $t05['p2031'] .' '. $t05['p2032'];
					$is_address = $t05['p207'] .' '. $t05['p208'];
					$is_city = $t05['p206'];
					$is_zip = $t05['p209'];
					$is_tbl = 't05';
					$is_nr01 = $t05['nr01']; 
				}
			}
		}

		array_push($arr1, 'is_name');   	array_push($arr2, $is_name);
		array_push($arr1, 'is_address');   	array_push($arr2, $is_address);
		array_push($arr1, 'is_city');   	array_push($arr2, $is_city);
		array_push($arr1, 'is_zip');   		array_push($arr2, $is_zip);
		array_push($arr1, 'is_tbl');   		array_push($arr2, $is_tbl);
		array_push($arr1, 'is_nr01');   	array_push($arr2, $is_nr01);


		array_push($arr1, 'is_vat');   		array_push($arr2, $is_vat);
		array_push($arr1, 'is_branch');   	array_push($arr2, $is_branch );
		if(empty($is_country)){
			$is_country='GR';
		}
		array_push($arr1, 'is_country');   	array_push($arr2, $is_country ); //Χώρας Εκδότη


		$cp_vat = $este01['a01_p20'];
		array_push($arr1, 'cp_vat');   		array_push($arr2, $cp_vat); //ΑΦΜ Λήπτη 
		$cp_country = $este01['d23_p01'] ;
		if(empty($cp_country)){
			$cp_country='GR';
		}
		array_push($arr1, 'cp_country');   	array_push($arr2, $cp_country); 		//Χώρας Λήπτη
		array_push($arr1, 'cp_branch');   	array_push($arr2, 0 ); 					//Αρ.Εγκατάστασης Λήπτη
		array_push($arr1, 'cp_name');   	array_push($arr2, $este01['a01_p19'] ); //Επωνυμία Λήπτη
		array_push($arr1, 'cp_address');   	array_push($arr2, $este01['a01_p4'] ); 	//Διεύθυνση Λήπτη
		array_push($arr1, 'cp_city');   	array_push($arr2, $este01['cp_city'] ); //Πόλη Λήπτη
		array_push($arr1, 'cp_zip');   		array_push($arr2, $este01['a01_p7'] ); 	//ΤΚ Λήπτη
		array_push($arr1, 'cp_tbl');   		array_push($arr2, 'a01' ); 				//Πίνακας Λήπτη
		array_push($arr1, 'cp_nr01');   	array_push($arr2, $este01['a01_nr01']);	//ΜΚ Πίνακα Λήπτη

		$issuedate= date('Y-m-d');
		array_push($arr1, 'issuedate');   	array_push($arr2, $issuedate ); 		//Ημερομηνία Έκδοσης
		array_push($arr1, 'issuetime');   	array_push($arr2, date('H:i:s') ); 		//Ώρα Έκδοσης
		$invtype= '8.4';
		array_push($arr1, 'invtype');   	array_push($arr2, $invtype); 			//Κατηγορία Παραστατικού
		array_push($arr1, 'currency');   	array_push($arr2, 'EUR' ); 				//Κωδικός Νομίσματος
		array_push($arr1, 'exchrate');   	array_push($arr2, '1' ); 				//Ισοτιμία
		
		
		$a55_array = array_filter(explode('#', $pos00_04['a55_nr01s']), function($value) {
			return !empty($value);
		});
		$in = pegasus_mysql_create_in($a55_array,'a55_nr01');
		$in_str = $in['sql'];

		$mconauth_query="SELECT group_concat(auth_cd) as mconauth FROM mydt10 WHERE tbl='a55' AND tbl_nr01 in ($in_str) AND auth_cd!=''";
		// echo pegasus_replace_values_in_sql($mconauth_query, $in['sqlParams']);

		pegasus_mysql_use($mconauth_query, $mconauth_res, $in['sqlParams']);
		array_push($arr1, 'mconauth');   	array_push($arr2, $mconauth_res['mconauth'] );//Συνδεδεμένα Παρ/κά (marks) f101.p019 -> mydt10 where tbl='a55' && tbl_nr01 = {f101.p019[i]}


		array_push($arr1, 'tgross_val');   	array_push($arr2, $this->amount); 		//Συνολική Aξία
		array_push($arr1, 'tnetvalue');   	array_push($arr2, $this->amount); 		//Συνολική Aξία
		
		array_push($arr1, 'p00');   		array_push($arr2, '1'); 				//1/2=Εσοδο/Εξοδο
		array_push($arr1, 'p01');   		array_push($arr2, '1'); 				//Αποστολή/Παραλαβή
		array_push($arr1, 'tbl');   		array_push($arr2, 't01'); 				//Πίνακας
		array_push($arr1, 'tbl_nr01');   	array_push($arr2, $t01_nr01); 			//ΜΚ Πίνακα
		$aa_query = "select t02.p0903_1, t02.p0903_2 from t01 left join t02 on t02.p01=t01.p07 where t01.nr01=:t01_nr01";
		pegasus_mysql_use($aa_query, $t01_t02, array('t01_nr01' => $t01_nr01));
		array_push($arr1, 'aa');   			array_push($arr2, $t01['p06_aa']); 		//Μετρητής na baloyme tin swsti metabliti
			

		pegasus_mysql_use("SELECT * FROM mydt00 WHERE 1=1",$mydt00);
		$series = $t01_t02['p0903_2'] ;                      
		if($mydt00['p103'] == 1){ //Στη σειρά προστίθεται το λεκτικό του παραστατικού
			if(!empty($t01_t02['p0903_1'])){
				$series = $t01_t02['p0903_1'].($t01_t02['p0903_2']==''?'':'-').$series ;
			}
		}
		if(empty($series)){
			$series = 0;
		}
		array_push($arr1, 'series');   		array_push($arr2, $series); 


		$pnr01 = substr("ESTIASI#".$is_vat."#".str_replace('-','',$issuedate)."#".$is_branch."#".$invtype ."#".$series."#".$t01['p06_aa']."#".$cp_vat."#",0,100); 
		array_push($arr1, 'pnr01');   		array_push($arr2,  $pnr01 ); 				//Pegasus UID
	
		pegasus_mysql_insert('mydt10',$arr1,$arr2);

		$arr1 = array();               		$arr2 = array();
		array_push($arr1, 'nr01');   		array_push($arr2, pegasus_mysql_newrec('mydt11'));
		array_push($arr1, 'mydt10');   		array_push($arr2, $mydt10_nr01);
		array_push($arr1, 'linenumber');   	array_push($arr2, '1');				//ΑΑ γραμμης
		array_push($arr1, 'tbl');   		array_push($arr2, 't01' ); 			//Πίνακας
		array_push($arr1, 'tbl_nr01');   	array_push($arr2, $t01_nr01 ); 		//ΜΚ Πίνακα
		array_push($arr1, 'p104');   		array_push($arr2, '1' ); 			//1/2=Εσοδο/Εξοδο
		array_push($arr1, 'mydt57_p00'); 	array_push($arr2, 'category1_95' );	//Χαρακτηρισμός Εσόδου
		array_push($arr1, 'vatcat'); 		array_push($arr2, '8' );			//Κατηγορια ΦΠΑ
		array_push($arr1, 'netvalue'); 		array_push($arr2, $this->amount );	//Καθαρή Αξία
		pegasus_mysql_insert('mydt11',$arr1,$arr2);
		
		 
		$arr1 = array();               		$arr2 = array();
		array_push($arr1, 'nr01');   		array_push($arr2, pegasus_mysql_newrec('mydt12'));
		array_push($arr1, 'tbl');   		array_push($arr2, 't01' ); 			//Πίνακας
		array_push($arr1, 'tbl_nr01');   	array_push($arr2, $t01_nr01 ); 		//ΜΚ Πίνακα
		array_push($arr1, 'linenumber');   	array_push($arr2, '1');
		array_push($arr1, 'mydt10');   		array_push($arr2, $mydt10_nr01);
		array_push($arr1, 'p104');   		array_push($arr2, '1' ); 			//1/2=Εσοδο/Εξοδο
		array_push($arr1, 'mydt57_p00'); 	array_push($arr2, 'category1_95' );	//Χαρακτηρισμός Εσόδου
		array_push($arr1, 'vatcat'); 		array_push($arr2, '8' );			//Κατηγορια ΦΠΑ
		array_push($arr1, 'netvalue'); 		array_push($arr2, $this->amount );	//Καθαρή Αξία
		pegasus_mysql_insert('mydt12',$arr1,$arr2);

		//coderev20241011 -> να βγει έξω από το if για να ειναι γραμμενος 1 φορά ο κώδικας
		//*create mydt13 --> Δημιουργεί το mydt13
		pegasus_mysql_use("select * from t19 where nr01 = :nr01", $t19, array("nr01" => $this->t19));
		$arr1 = array();               $arr2 = array();
		array_push($arr1, 'nr01');     array_push($arr2, pegasus_mysql_newrec('mydt13'));
		array_push($arr1, 'mydt10');   array_push($arr2, $mydt10_nr01);
		array_push($arr1, 'type');     array_push($arr2, '7');
		array_push($arr1, 'tid');      array_push($arr2, $t19['tid']);
		array_push($arr1, 'amount');   array_push($arr2, $t19['pay_am']);
		array_push($arr1, 'amount_t'); array_push($arr2, $t19['tip_am']);
		array_push($arr1, 'tbl');      array_push($arr2, 't19');  
		array_push($arr1, 'tbl_nr01'); array_push($arr2, $t19['nr01']); 
		array_push($arr1, 'p_sign');   array_push($arr2, $t19['p_sign']);
		pegasus_mysql_insert('mydt13', $arr1, $arr2);
		
		
		//stelnei ston paroxo - to minama tha to emfanisoyme 
		$ret_arr = einv_send($mydt10_nr01);
		return $ret_arr;
	}
    private function _exec_pos_payment_tautoxroni_send_myDATA_pos_invoice_failure(){
        // die("Αποτυχημένη πληρωμή για 8.4(ΑπόδειξηΕίσπραξης), 8.5 (Απόδειξη πληρωμής)");   

		//Δεν κάνω cancel, γιατί θέλω να γίνουν report οι μη επιτυχημένες ταυτόχρονες πληρωμές από τον ΥΠΑΗΕΣ στο myDATA
		//$ret = einv_send_payment_signature($this->t19);


        pegasus_mysql_use("select * from t19 where nr01 = :nr01", $t19, array("nr01" => $this->t19));
		$message = "";
		if($t19['tbl']=='t08'){
            pegasus_mysql_update("t19", array("akyr", "akyr_msg"), array(1, $this->akyr_msg), "nr01=?", 0, 1, 1, array($this->t19));
		}	
		else if($t19['tbl']=='a55'){
			pegasus_mysql_update("t19", array("akyr", "akyr_msg"), array(1, $this->akyr_msg), "nr01=?", 0, 1, 1, array($this->t19));
		}
		return array(
			"ok" => 1, 
			"msg" => "Ακύρωση υπογραφής με επιτυχία"
		);
    }

}

class account00_create_signature{
	
	public function create_t19($amount, $tidnsp, $tbl, $tbl_nr01, $pos_protocol=''){

        $response = array(
            'ok'	    => 0,
            'msg'	    => "", 
            't19_nr01'  => 0
        );
        
        if($tbl_nr01>0){
			if($tbl=='a55'){
				pegasus_mysql_use("SELECT * FROM a55 WHERE nr01=?", $a55, array($tbl_nr01));
				
				if(empty($a55["y_ekd"])){
					pegasus_mysql_use("select * from mydt10 where tbl='a55' and tbl_nr01=:a55_nr01 and mydt10.auth_cd !='' ", $mydt10,  array("a55_nr01" => $tbl_nr01));
					
					if($mydt10['einv']==51 && pegasus_module_exists('einv03')){
						//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση από Τοπικό[51]
						$mydt10_einv01_nr01 = einv03_get_settings_from_fem012($mydt10['einv_nr']);
					}else{
						$mydt10_einv01_nr01 = $mydt10['einv_nr'];
					}

					$ret = einv_create_payment_signature(
						$mydt10['issuedate'],
						$mydt10['is_vat'],
						$mydt10['is_branch'], 
						$mydt10['invtype'],
						$mydt10['series'],
						$mydt10['aa'], 
						$mydt10['mark'], 
						$mydt10['tnetvalue'],  
						$mydt10['tvat_am'],
						$mydt10['tgross_val'], 
						$amount, 
						$tidnsp, 
						$mydt10['tbl'],
						$mydt10['tbl_nr01'],
						$mydt10['pnr01'],
						$mydt10_einv01_nr01,
						$pos_protocol
					);

				}else{
					//* Έλεγχος πρώτα αν το είδος του παραστατικού έχει αποστολή στο mydata (620014, 620068)
					$q = " SELECT 
								ifnull( (select q31_in.p05
											from q31 as q31_in
											where q31_in.p01=620068
											&& q31_in.p03=a10.p01
											limit 1), 
								ifnull( (select q31_in.p05
											from q31 as q31_in
											where q31_in.p01=620014
											&& q31_in.p03=a10.p01
											limit 1), '')) as invtype
							FROM a55
							JOIN a10 on a55.p05 = a10.p01
							WHERE a55.nr01 = :a55_nr01";
					$v = array('a55_nr01' => $tbl_nr01);
					pegasus_mysql_use($q, $q31, $v);

					if(empty($q31['invtype'])) {
						return array(
							'ok'	=> 0,
							'msg'	=> $_SESSION['peg_dic_account00_create_t19_no_q31']
						);
					}

					$mydt_mydt10_tmp = new mydt_mydt10("a55", $tbl_nr01);
					$mydt10 = $mydt_mydt10_tmp->get_mydt10_data(); // Επιστρέφει τα mydt10 data όπως θα καταχωρόντουσαν, χωρίς να καταχωρήσει
					
					$ret = einv_create_payment_signature(
						$a55["p01"],
						$mydt10['is_vat'],
						$mydt10['is_branch'], 
						$mydt10['invtype'],
						$mydt10['series'],
						0, //Εδώ θα πρέπει να βάλω 0 για να μην εχω κενά στην αρίθμηση 
						0, 
						$mydt10["tnetvalue"],
						$mydt10["tvat_am"],
						$mydt10["tgross_val"], 
						$amount, 
						$tidnsp, 
						"a55",
						$tbl_nr01,
						0,
						0,
						$pos_protocol
					);
				}

			}elseif($tbl=='tran01'){

				pegasus_mysql_use("select * from mydt10 where tbl='".$tbl."' and tbl_nr01=:tbl_nr01 and mark<>0", $mydt10, array("tbl_nr01" => $tbl_nr01));
				
				if($mydt10['einv']==51 && pegasus_module_exists('einv03')){
					//Έλεγχος αν προκειται για Ηλεκτρονική Τιμολόγηση από Τοπικό[51]
					$mydt10_einv01_nr01 = einv03_get_settings_from_fem012($mydt10['einv_nr']);
				}else{
					$mydt10_einv01_nr01 = $mydt10['einv_nr'];
				}

				$ret = einv_create_payment_signature(
					$mydt10['issuedate'],
					$mydt10['is_vat'],
					$mydt10['is_branch'], 
					$mydt10['invtype'],
					$mydt10['series'],
					$mydt10['aa'], 
					$mydt10['mark'], 
					$mydt10['tnetvalue'],  
					$mydt10['tvat_am'],
					$mydt10['tgross_val'], 
					$amount, 
					$tidnsp, 
					$mydt10['tbl'],
					$mydt10['tbl_nr01'],
					$mydt10['pnr01'],
					$mydt10_einv01_nr01,
					$pos_protocol
				);
			}elseif($tbl=='este01'){
				$invtype = '8.4';
				$issuer_branch = pegasus_mysql_printfld('mydt00', 'taxnet_cd', 'nr01 = 1');
				$issuer_vat = pegasus_mysql_printfld('cor000', 'f00p204', 'nr01 = 1');
				if(pegasus_module_exists("stores")) {
					pegasus_mysql_use('SELECT * FROM t07 WHERE p01 = ?', $t07, array($v_t07));
					$issuer_branch = $t07['p06'];
					// Αν το κατάστημα που επέλεξα έχει Ομάδα
					if(!empty($t07['p07'])) {
						pegasus_mysql_use('SELECT * FROM t05 WHERE p01 = ?', $t05, array($t07['p07']));
						// Και η ομάδα έχει ΑΦΜ.
						if(!empty($t05['p204'])) {
							// Παίρνω vat από αυτό.
							$issuer_vat = $t05['p204'];
						}
					}
				}
				if(empty($issuer_branch)) {
					$issuer_branch = 0;
				}
				/**Από τις βασικές παραμέτρους estiasi, βρίσκουμε την σειρά του ΚΚ */
				pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = ?', $t02, array($_SESSION['este98_t02_84']));
				$seira = $t02['p0903_2'] ;  
				// Παράμετρος - Το λεκτικό του παραστατικού προστίθεται στη σειρά
				if($_SESSION['mydt00_p103'] == 1) {
					if(!empty($t02['p0903_1'])){
						$seira = $t02['p0903_1'].($t02['p0903_2']==''?'':'-').$seira ;
					}
				}
				
				if($seira==''){
					$seira = 0;
				}
				$ret = einv_create_payment_signature(
					date("Y-m-d"),
					$issuer_vat,
					$issuer_branch, 
					$invtype,
					$seira, // σειρά
					0, // αριθμός
					0, 
					$amount,  
					0,
					$amount, 
					$amount, 
					$tidnsp, 
					'',  //ή κενό
					'',
					'',
					$_SESSION['este98_einv01'], //στοιχεία σύνδεσης του παρόχου από το este98
					$pos_protocol
				);
			}

    
            if($ret['ok'] == 0){
                return array(
                    'ok'	=> 0,
                    'msg'	=> $ret['msg']
                );
            }
    
            $t19_nr01 = pegasus_mysql_newrec('t19');
            $arr1 = array();                $arr2 = array();
            array_push($arr1, 'nr01');      array_push($arr2, $t19_nr01);
            array_push($arr1, 'tbl');       array_push($arr2, $tbl); 
            array_push($arr1, 'tbl_nr01');	array_push($arr2, $tbl_nr01); 
    
            array_push($arr1, 'p_sign');   	array_push($arr2, $ret['data']['p_sign']); 
            array_push($arr1, 'p_sign_s'); 	array_push($arr2, $ret['data']['p_sign_string']); 
            array_push($arr1, 'init_am');  	array_push($arr2, $amount);
            array_push($arr1, 'tidnsp');   	array_push($arr2, $tidnsp); 
    
            pegasus_mysql_insert('t19',  $arr1, $arr2);
            
            return array(
                'ok'	   => 1,
                'msg'	   => 'Επιτυχής καταχώρηση t19', 
                't19_nr01' => $t19_nr01
            );
        }

        return 0;

    }
}