<?php
/**
 *
 * @param  array   $data
 * @param  string  $mmnr01
 * @param  integer $mnr01
 * @param  string  $_d
 * @param  string  $container_id
 * @return array
 */
function account00_account00_01_d_initialize(
	$data = array(),
	$mmnr01 = '',
	$mnr01 = 0,
	$_d = '',
	$container_id = ''
) {
    $data['v_profortosi_readonly'] = true;

    //* Leaving this commented for now just in case. 
    //* To be deleted.
    // if( !(pegasus_module_exists('dias') ||  $_SESSION['cor011_account00_eftpos'] == 1) ) {
    //     $data = array();
    //     $data['permDeny'] = 1;
    //     $data['permDenyMessage'] = 'Η επιλεγμένη λειτουργία δεν είναι ακόμη ενεργή. Σε αυτή την επιλογή θα εμπεριέχονται όλες οι αλλαγές σύμφωνα με την απόφαση Α. 1155 /09-10-2023.';
    //     return $data;
    // }
    
	global $PegInput;
	//ΜΚ για Εισπράξεις/Επιστροφές EFTPOS
	// $PegInput->addVar(new peg_input_alphanumeric('account00_a55_nr01', 'request'));
	// $account00_a55_nr01 = $PegInput->getRequest('account00_a55_nr01');
	
	// if($account00_a55_nr01>0){
	// 	$data['v_type'] = 1;
	// 	$data['v_a55'] = $account00_a55_nr01;
	// }

    $PegInput->addVar(new peg_input_alphanumeric('nr01s', 'request'));
    $PegInput->addVar(new peg_input_alphanumeric('mode'));
    $PegInput->addVar(new peg_input_number('v_a01'));
    $PegInput->addVar(new peg_input_number('v_amount'));
    $PegInput->addVar(new peg_input_number('v_hota04'));
    
    $v_a01    = $PegInput->getRequest('v_a01');
    $v_amount = $PegInput->getRequest('v_amount');
    $v_hota04 = $PegInput->getRequest('v_hota04');
    $mode     = $PegInput->getRequest('mode');
    $nr01s    = $PegInput->getRequest('nr01s');
    $nr01s    = array_filter(explode(',', $nr01s));
    

    if(!empty($nr01s)) {
        
        if(pegasus_module_exists('hot013') && !in_array($mode, array('tran01_d'))){ 
            //Έλεγχος αν όλα τα Παραστατικά συνδέονται με την ίδια Κράτηση
            $hota04_nr01 = hot013_find_hota04_from_a55($nr01s);
            $data['v_hota04'] = $hota04_nr01;
        }
        
        if(count($nr01s)>1) {
            $data['v_type']   = 2;

        }elseif(count($nr01s)==1) {
            if($mode=='tran01_d') {
                $data['v_type']   = 4;
                $data['v_tran01'] = $nr01s[0];
            }else{
                $data['v_type']   = 1;
                $data['v_a55']    = $nr01s[0];
            }
        }

    }elseif($v_hota04>0) {
        //Σε περίπτωση που έρχομαι απο οθόνη Κράτησης με καποιο Ποσό
        $data['v_type']   = 2;
        $data['v_a01']    = $v_a01;
        $data['v_amount'] = $v_amount;
        $data['v_hota04'] = $v_hota04;
    }elseif($mode == 'retail00_01') {
        $data['v_type'] = 2;
        $data['v_a01'] = $v_a01;
    }

	// v_t07p01
	$where = '';
	if(pegasus_module_exists('stores')) {
		$where = peg_stores_get_stores_where_array('t07','p01');
	}
	pegasusSetGlobalVar($container_id . '_where_v_t07p01', $where);
    
	// v_t08 query
	$sql = "	SELECT t08.* 
				FROM t08
				JOIN a01 ON t08.p03 = a01.p21
				JOIN mydt10	ON mydt10.tbl = 't08'
							AND mydt10.tbl_nr01 = t08.nr01
							AND mydt10.einv = 1
							AND mydt10.invtype = '8.4'
							AND mydt10.mark!= '' 
				WHERE 1=1  ";
	$sqlParams = array();

	if(pegasus_module_exists('stores')) {
		$in = peg_stores_get_stores_where_array('t08','p0121');
		$sql .= "	AND ".$in['sql'];
		$sqlParams = $in['sqlParams'];
	}

	// echo pegasus_replace_values_in_sql($sql, $sqlParams);
	pegasusSetGlobalVar($container_id . '_query_v_t08', array('sql' => $sql, 'sqlParams' => $sqlParams));

        
	if($data['v_type'] == 1){
		$input_data = array();
		$input_data['v_type']   = 1;
		$input_data['v_a55']    = $nr01s[0];
		$data['v_a55_hidden']   = false;
		$data['v_a14_hidden']   = false;            
		$input_data['v_hota04'] = $data['v_hota04'];   

		$account00_account00_01_d = new account00_account00_01_d($input_data);
		$ret = $account00_account00_01_d->refresh_screen_values($container_id, 'v_a55');
        
		$i = -1;
		foreach ($ret['data'] as $k => $v) {
			$i++;
			$data[$k] 				= $v['value'];
			$data[$k.'_hidden'] 	= $v['hidden'];
			$data[$k.'_display'] 	= $v['display'];
			$data[$k.'_readonly'] 	= $v['readonly'];
		}

	}elseif($data['v_type']==2) {
		$input_data = array();
		$input_data['v_type']   = 2;          
		$input_data['v_hota04'] = $data['v_hota04'];        
		$input_data['v_amount'] = $data['v_amount']; 
        $input_data['v_a01']    = (count($nr01s)>1) ? pegasus_mysql_printfld('a55', 'p03', 'nr01 = ?', array($nr01s[0])) : $data['v_a01'];

		$account00_account00_01_d = new account00_account00_01_d($input_data);
		$ret = $account00_account00_01_d->refresh_screen_values($container_id, 'v_type');
		$i = -1;
		foreach ($ret['data'] as $k => $v) {
			$i++;
			$data[$k] 				= $v['value'];
			$data[$k.'_hidden'] 	= $v['hidden'];
			$data[$k.'_display'] 	= $v['display'];
			$data[$k.'_readonly'] 	= $v['readonly'];
		}        

        $data['a55_records'] = array();
        $i = 1;

        if(count($nr01s)>1) {
            $total_amount = 0;
            $data['v_amount_readonly'] = true;
        }elseif($data['v_amount']>0) {
            $total_amount = $data['v_amount'];
            $data['v_amount_readonly'] = false;
        }

        foreach($nr01s as $a55_nr01) {
            $a55_array['a55_rec_nr01_'.$i]   = $a55_nr01;
            $a55_array['a55_rec_amount_'.$i] = pegasus_mysql_printfld('t35', 'p03', 'tbl = "a55" AND tbl_nr = ?', array($a55_nr01));
            $total_amount += $a55_array['a55_rec_amount_'.$i];

            pegasus_mysql_use("SELECT * FROM a55 WHERE nr01 = ?", $a55, array($a55_nr01));
            pegasus_mysql_use("SELECT * FROM a10 WHERE p01 = ?", $a10, array($a55['p05']));
            $memo_data = array();
            $memo_data['seira'] = $a55['p701'];
            $memo_data['arithmos'] = $a55['p06'];
            $memo_data['typos'] = $a10['p02'];
            $memo_data['date'] = peg_dateToStr($a55['p01']);
            $memo_data['time'] = $a55['p02'];
            $par_lek = 'Παραστατικό';
            if($_SESSION['lang'] == 'EN') {
                $memo_data['typos'] = $a10['ep02'];
                $par_lek = 'Invoice';
            }
            $memo_html = $par_lek . ': ' . $a10['p00'] . ' / ' . $memo_data['seira'] . ' No. ' . $memo_data['arithmos'] . ' / ' . $memo_data['date']. ' ' .$memo_data['time'];
            $a55_array['a55_rec_memo_'.$i] = $memo_html;
            
            $i++;
        }

        $data['a55_records'] = $a55_array;
        $data['v_amount'] = $total_amount;
    
    }elseif($data['v_type']==4){
		$input_data = array();
		$input_data['v_type']    = 4;
		$input_data['v_tran01']  = $nr01s[0];
		$data['v_a14_hidden']    = false;    

		$account00_account00_01_d = new account00_account00_01_d($input_data);
		$ret = $account00_account00_01_d->refresh_screen_values($container_id, 'v_tran01');
        
		$i = -1;
		foreach ($ret['data'] as $k => $v) {
			$i++;
			$data[$k] 				= $v['value'];
			$data[$k.'_hidden'] 	= $v['hidden'];
			$data[$k.'_display'] 	= $v['display'];
			$data[$k.'_readonly'] 	= $v['readonly'];
		}

        $data['ddd'] = $ret;
	}

    if(isset($ret) && !empty($ret) && !empty($ret['error_message'])) {
        $data['message'] = $ret['error_message'];
        $data['btn02_hidden'] = true;
        $data['v_amount_hidden'] = true;
    }

    if($data['v_type'] != 2) {
        $data['fldset01_hidden'] = true;
    }
	return $data;
}

function account00_account00_01_d_v_type_ls_data() {
        
    $ls_data = array(
        array("p00" => 1,  "p01" => "Είσπραξη/Επιστροφή σε Παραστατικό",    "ep01" => "Collection/Return to Receipt"),
        array("p00" => 2,  "p01" => "Είσπραξη",                             "ep01" => "Payment"),
        array("p00" => 3,  "p01" => "Ακύρωση Είσπραξης",                    "ep01" => "Cancellation of Payment"),
    );

    if(pegasus_module_exists('tran')){
        $ls_data[] = array("p00" => 4,  "p01" => "Είσπραξη/Επιστροφή σε Φορτωτική", "ep01" => "Collection/Return to Consignment Note");
    }
    
    return json_encode($ls_data);
}

function account00_account00_01_d_set_query_v_a14($data, $container_id, $type){

    // v_a14 query
    $sqlParams = array('cor003p01' => $_SESSION['cor003_p01']);

    if($type=='4') {
        $sql_join = "
                    JOIN tran01 AS tran01_00 ON tran01_00.nr01=:tran01								        /* Φορτωτική */
                    JOIN tran20 AS tran20_00 ON tran20_00.p01=tran01_00.p105                                /* Ορισμός Παραστατικών Φορτωτικών */
                    JOIN t02 AS t02_00 ON t02_00.p01=tran20_00.p04                                          /* Κωδικοί Κίνησης Λογαριασμών (Παραστατικού Φορτωτικών)*/
                ";
        $sqlParams['tran01'] = $data['v_tran01'];

    }else{
        $sql_join = "	
                    JOIN a55 AS a55_00 ON a55_00.nr01=:a55												/* Παραστατικά Πελατών */
                    JOIN a10 AS a10_00 ON a10_00.p01=a55_00.p05											/* Ορισμός παραστατικών πελατών */
                    JOIN t02 AS t02_00 ON t02_00.p01=a10_00.p04											/* Κωδικοί Κίνησης Λογαριασμών (Παραστατικού)*/
                ";

        $sqlParams['a55'] = $data['v_a55'];
    }

    $sql = "	SELECT a14.*
                FROM a14																				/* Τρόποι Είσπραξης από Πελάτες */
                JOIN pos00_02 ON pos00_02.a14 = a14.nr01 AND pos00_02.cor003p01 = :cor003p01			/* Ρυθμίσεις POS */
                JOIN t02 ON t02.p01 = pos00_02.t02p01													/* Κωδικοί Κίνησης Λογαριασμών */
                JOIN q31 ON q31.p01 = 620042 AND q31.p03 = a14.nr01 AND q31.p05 = 7						/* Αντιστοιχίσεις Κεντρικών Πινάκων */
                ".$sql_join."
                WHERE 1 = 1
                AND (
                    a14.p02 = 0  																		/* Να μην έχει κωδικό κίνησης λογαριασμού */
                    /*OR a14.p02 = t02_00.p01 */														/* Ή να είναι ίδιος με αυτόν του παραστατικού */
                )
                AND IF(
                        t02_00.p03 > 0,																	/* Αν ο συντελεστής χρέωσης του κωδικού κίνησης του παραστατικού είναι θετικός */
                        t02.p04 > 0,																	/* Τότε μόνο τρόπους πληρωμής που έχουν κωδικό κίνησης με συντελεστή χρέωσης θετικό */
                        1 = 1
                )
                AND IF(																					/* Αν ο συντελεστής χρέωσης του κωδικού κίνησης του παραστατικού είναι αρνητικός */
                    t02_00.p03 < 0,																		/* τρόπους πληρωμής που έχουν κωδικό κίνησης με συντελεστή χρέωσης αρνητικό*/
                    t02.p04 < 0	,
                    1 = 1
                )
                GROUP BY a14.nr01
        ";

	pegasusSetGlobalVar($container_id . '_query_v_a14', array('sql' => $sql, 'sqlParams' => $sqlParams));
}

function account00_account00_01_d_set_query_v_pos00_02($data, $container_id, $type){

    // pos00_02 query
    $sqlParams = array('cor003p01' => $_SESSION['cor003_p01']);

    if($type=='4') {
        $sql_join = "
                    JOIN tran01 AS tran01_00 ON tran01_00.nr01=:tran01								        /* Φορτωτική */
                    JOIN tran20 AS tran20_00 ON tran20_00.p01=tran01_00.p105                                /* Ορισμός Παραστατικών Φορτωτικών */
                    JOIN t02 AS t02_00 ON t02_00.p01=tran20_00.p04                                          /* Κωδικοί Κίνησης Λογαριασμών (Παραστατικού Φορτωτικών)*/
                ";
        $sqlParams['tran01'] = $data['v_tran01'];

    }else{
        $sql_join = "	
                    JOIN a55 AS a55_00 ON a55_00.nr01=:a55												/* Παραστατικά Πελατών */
                    JOIN a10 AS a10_00 ON a10_00.p01=a55_00.p05											/* Ορισμός παραστατικών πελατών */
                    JOIN t02 AS t02_00 ON t02_00.p01=a10_00.p04											/* Κωδικοί Κίνησης Λογαριασμών (Παραστατικού)*/
                ";

        $sqlParams['a55'] = $data['v_a55'];
    }

    $sql = "SELECT pos00_02.*, pos00_01.p01 as pos00_01_p01, pos00_01.p01 as v_selectbox_pos00_01  
            FROM a14																				/* Τρόποι Είσπραξης από Πελάτες */
            JOIN pos00_02 ON pos00_02.a14 = a14.nr01 AND pos00_02.cor003p01 = :cor003p01
            JOIN pos00_01 ON pos00_02.pos00_01 = pos00_01.nr01										/* Ρυθμίσεις POS */
            JOIN t02 ON t02.p01 = pos00_02.t02p01													/* Κωδικοί Κίνησης Λογαριασμών */
            JOIN q31 ON q31.p01 = 620042 AND q31.p03 = a14.nr01 AND q31.p05 = 7						/* Αντιστοιχίσεις Κεντρικών Πινάκων */
            ".$sql_join."
            WHERE 1 = 1
            AND (
                a14.p02 = 0 
                and a14.nr01 = :a14  																		/* Να μην έχει κωδικό κίνησης λογαριασμού */			/* Ή να είναι ίδιος με αυτόν του παραστατικού */
            )
            AND IF(
                    t02_00.p03 > 0,																	/* Αν ο συντελεστής χρέωσης του κωδικού κίνησης του παραστατικού είναι θετικός */
                    t02.p04 > 0,																	/* Τότε μόνο τρόπους πληρωμής που έχουν κωδικό κίνησης με συντελεστή χρέωσης θετικό */
                    1 = 1
            )
            AND IF(																					/* Αν ο συντελεστής χρέωσης του κωδικού κίνησης του παραστατικού είναι αρνητικός */
                t02_00.p03 < 0,																		/* τρόπους πληρωμής που έχουν κωδικό κίνησης με συντελεστή χρέωσης αρνητικό*/
                t02.p04 < 0	,
                1 = 1
            )
            GROUP BY pos00_02.nr01
            ";

    $sqlParams['a14'] = $data['v_a14'];
    
    pegasusSetGlobalVar($container_id . '_query_v_pos00_02', array('sql' => $sql, 'sqlParams' => $sqlParams));
}

/** */	
function account00_00_t18_d_onsave(
    $data = array(),
    $permDeny = array(),
    $mmnr01 = '',
    $checkOnlyPerm = false
) {
    /**
     * Ελέγχουμε αν ο ορισμός της απόδειξης έχει συσχέτιση με παραστατικό myData 8.4 ή 8.5
     * 31/05/2024 - Αφαιρέσαμε το πεδίο mydt50 και τον έλεγχο του παρακάτω και προσθέσαμε εδώ επιπλέον να είναι προς αποστολή 620019
     */
    $sql = "    SELECT q31.nr01, q31.p03, q31.p05
                FROM q31 
                JOIN q30 ON q30.p01 = 't10' AND q30.nr01 = q31.p01
                WHERE 1 =1
                AND q31.p05 IN ('8.4','8.5')
                AND q31.p03 = :t10p01
                AND q31.p01 = '620019'
    ";

    $values = array('t10p01' => $data['t10p01']);
    $check  = array();
    pegasus_mysql_use($sql, $check, $values);

    if(!($check['nr01'] > 0)) {
        array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account00_t18_t10p01_wrong_q31']));
    }


    if($data['p01']>0) {
        $device_properties = array();
        if(pegasus_module_exists('pos00')) {
            $pos00_01 = pos00_find_pos00_01($data['pos00_01']);
            $device_properties = pos00_device_properties::get_properties($pos00_01["p02"]);
        }

        if(!isset($device_properties['moto']) || $device_properties['moto']==false) {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account00_t18_no_moto']));
        }

        if($check['p05']=='8.5') {
            array_push($permDeny, array('type' => 'deny', 'message' => $_SESSION['peg_dic_account00_t18_t10p01_no_moto']));
        }
    }

	return array(
        'data'      => $data, 
        'permDeny'  => $permDeny
    );
}

function account00__account00_pay_d_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
	global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl'));  
    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl_nr01'));  
    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl_mode'));  
	$account00_tbl = $PegInput->getRequest('account00_tbl');  
	$account00_tbl_nr01 = $PegInput->getRequest('account00_tbl_nr01');  
	$account00_tbl_mode = $PegInput->getRequest('account00_tbl_mode');  
    if(empty($account00_tbl_mode)) {
        $account00_tbl_mode = 'a55';
    }

    $data['collected_hidden'] = true;
    $data['change_hidden'] = true;
    $data['cash_memo_hidden'] = true;
    
    $data['fldcont01_hidden'] = true;
    // $data['cash_memo'] = account00_draw_cash_memo($container_id);

	$data['v_tbl'] = $account00_tbl;
	$data['v_tbl_nr01'] = $account00_tbl_nr01;
	if($account00_tbl == 'a55') {
		$remainder = invoices_calc_a55_aneisprakto($account00_tbl_nr01, 'a55', false, true);
		$data['amount'] = $remainder;
		// $data['a55nr01'] = $account00_tbl_nr01;

		$t01_grid_where = ' t01.p302 = :a55nr01 ';
		pegasusSetGlobalVar(
			$container_id. '_where_grid__account00_pay_d01',    // για τις κινήσεις
			array(
				'sql' => $t01_grid_where,
				'sqlParams' => array('a55nr01' => $account00_tbl_nr01)
			 )
		);

        //TODO Δεν είμαι σίγουρος ότι είναι σωστό να σετάρεται εδώ.
        if($remainder > 0) {
            account00_set_a14_global_var($account00_tbl_nr01, $account00_tbl_mode, $container_id);
        }
	}

    return $data;
}

function account00__account00_pay_d00_initialize($data = array(), $mmnr01 = '', $mnr01 = 0, $_d = '', $container_id = '') {
    global $PegInput;
    $PegInput->addVar(new peg_input_alphanumeric('device'));    
    $device = $PegInput->getRequest('device');

    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl'));  
    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl_nr01'));  
    $PegInput->addVar(new peg_input_alphanumeric('account00_mode'));  
	$account00_tbl = $PegInput->getRequest('account00_tbl');  
	$account00_tbl_nr01 = $PegInput->getRequest('account00_tbl_nr01');  
	$account00_mode = $PegInput->getRequest('account00_mode');  

	$data['v_tbl'] = $account00_tbl;
	$data['v_tbl_nr01'] = $account00_tbl_nr01;
	
    $remainder = invoices_calc_a55_aneisprakto($account00_tbl_nr01, 'a55', false, true);
    if($remainder > 0) {
        $data['payment_memo']       = account00_draw_payment_memo($container_id, $data['v_tbl_nr01']);
    }else{
        $data['fsetpanel00_hidden'] = true;
        $data['fsetpanel01_hidden'] = true;

        $data['msg00_hidden'] = false;
        $data['msg00'] = '<div class="peg_alert_info_plain" style="text-align:center;">' .$_SESSION['peg_dic_account00_pay_zero_remainder_info']. '</div>';
        $data['but_submit_inv_text'] = $_SESSION['peg_dic_account00_pay_ekdosi'];
        $data['but_print_inv_text']  = $_SESSION['peg_dic_account00_pay_ekdosi_print'];
        $data['but_email_inv_text']  = $_SESSION['peg_dic_account00_pay_ekdosi_email'];
        $data['but_print_imin_text'] = $_SESSION['peg_dic_account00_pay_ekdosi_print_imin'];
        $data['but_print_epson_text']= $_SESSION['peg_dic_account00_pay_ekdosi_print_epson'];
        $data['but_sms_inv_text']    = $_SESSION['peg_dic_account00_pay_ekdosi_sms'];
    }
    $data['collected_hidden']   = true;
    $data['change_hidden']      = true;
    $data['cash_memo_hidden']   = true;
    $data['room_charge_memo_hidden'] = true;

    $data['cash_memo']  = account00_draw_cash_memo($container_id);
    $data['msg_submit'] = '<div class="peg_alert_warning_plain" style="text-align:center;">' .$_SESSION['peg_dic_account00_pay_d_msg_submit']. '</div>';

    if(pegasus_module_exists('hot005')){
        $data['room_charge_memo'] = account00_draw_room_charge_memo($container_id);
    }

    if(pegasus_module_exists('imin00') && in_array($device, array('mobile'))){
        $data['but_print_imin_hidden'] = false;
    }

    if(pegasus_module_exists('epson00')){
        $data['but_print_epson_hidden'] = false;
    }
    
    return $data;
}

function account00_draw_payment_memo($container_id, $a55nr01) {

    $style = '
        <style>
            ._account00_pay_d_pay_methods_container {
                text-align: left;
            }
            ._account00_pay_d_pay_methods_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }

            ._account00_pay_d_pay_methods_buttons {
                display: inline-block;
                background-color: #b6e9fb;
                width: 33%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                padding: 15px 0;
                font-weight: bold;
                cursor: pointer;
                
                display: flex;
                height: 55px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                
                &.active {
                    color: #ffffff;
                    background-color: #00d26d;
                }
            }

        </style>
    ';

    // $a14_where = pegasusGetGlobalVar(pegasus_container_id_get_parentBy_d($container_id, 'retail00_01_d') . '_a14_where');
    $a14_where = pegasusGetGlobalVar('peg_'. $a55nr01 .'_a14_where');
    $a14_query = 'SELECT * FROM a14 WHERE ' . $a14_where['sql'] . ' ORDER BY p100, nr01';
    $res = pegasus_query($a14_query, $a14_where['sqlParams']);

    $html = '<div class="_account00_pay_d_pay_methods_container">';
    $rows = '<div class="_account00_pay_d_pay_methods_rows">';
    while($a14 = pegasus_fetch($res, PEG_FETCH_ASSOC)) {
        $is_metrita = pegasus_mysql_printfld('t02', 'p05', 'p01 = ?', array($a14['p02'])); // KK Λογιστηρίου - Ταμείο (όλο το ποσό)
        if(empty($is_metrita)) {
            $is_metrita = 0;
        }

        $is_epi_pistosi = account00_is_epi_pistosi_a14($a14['nr01']);

        $pos_settings = 0;
        if(pegasus_module_exists('pos00')) {
            $pos00_02 = pos00_find_pos00_02($a14['nr01'], $_SESSION["cor003_p01"]);
            if(!empty($pos00_02)) {
                $pos_settings = $pos00_02['nr01'];
            }
        }

        $rows .= '<div 
            class="_account00_pay_d_pay_methods_buttons" 
            onclick="account00_pay_d_change_payment(\''.$container_id.'\', '.$a14['nr01'].', '.$is_metrita.', \''.$a14['p01'].'\', '.$pos_settings.', this, '.$is_epi_pistosi.')"
        >';
        $rows .= $a14['p01'];
        $rows .= '</div>';
    }

    //Extra Payment Methods
    if(pegasus_module_exists('hot005')) {
        //Χρέωση σε Δωμάτιο - a14 (MK:-99999)
        pegasus_mysql_use('SELECT * FROM a55 WHERE nr01=?', $a55_data, array($a55nr01));
    
        if (!empty($a55_data['p05'])) {
            $kklo_p05 = pegasus_mysql_printfld('a10', 'p04', 'p01=:a55p05', array('a55p05' => $a55_data['p05']));
            $kkxr_p05 = pegasus_mysql_printfld('t02', 'p03', 'p01=:kklo_p05', array('kklo_p05' => $kklo_p05));
            //Δε θα εμφανίζεται σε Παραστατικά επιστροφής
            if($kkxr_p05>0) {
                $rows .= '<div 
                    class="_account00_pay_d_pay_methods_buttons" 
                    onclick="account00_pay_d_change_payment(\''.$container_id.'\', -99999, 0, \'Χρέωση σε Δωμάτιο\', 0, this, 0)"
                >';
                $rows .= 'Χρέωση σε Δωμάτιο';
                $rows .= '</div>';
            }
        }
    }

    $rows .= '</div>';
    $html .= $rows;
    $html .= '</div>';

    $payment_memo = $style . $html;
    return $payment_memo;
}

function account00_draw_cash_memo($container_id) {

    $decimal_sep = $_SESSION['cor000_decimal_char'];
    $values = array(
        "200",
        "100",
        "50",
        "20",
        "10",
        "5",
        "2",
        "1",
        "0".$decimal_sep."50",
        "0".$decimal_sep."20",
        "0".$decimal_sep."10",
        "0".$decimal_sep."05",
        "0".$decimal_sep."02",
        "0".$decimal_sep."01",
        "C"
    );

    $style = '
        <style>
            ._account00_pay_d_cash_memo_container {
                text-align: left;
            }
            ._account00_pay_d_cash_memo_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }

            ._account00_pay_d_cash_memo_buttons {
                display: inline-block;
                background-color: #e9e9e9;
                width: 33%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                font-weight: bold;
                cursor: pointer;
                
                display: flex;
                height: 55px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                align-items: center;
                font-size: 16px;
            }
            ._account00_pay_d_cash_memo_button_c {
                background-color: #f23a3a;
                color: #ffffff;
            }
        </style>
    ';
    $html = '<div class="_account00_pay_d_cash_memo_container">';
    $rows = '<div class="_account00_pay_d_cash_memo_rows">';
    foreach($values as $value) {
        $extra_class = '';
        $js_value = $value;
        if($value == 'C') {
            $extra_class = '_account00_pay_d_cash_memo_button_c';
        }else{
            // Αν έχω κόμμα ως decimal separator, το αλλάζω σε τελεία στην onclick. Το κάνω εδώ για να μην μπλέξω σε JS μετατροπή.
            $js_value = str_replace(',', '.', $value);
        }
        $rows .= '<div class="_account00_pay_d_cash_memo_buttons '.$extra_class.'" onclick="account00_pay_d_change_cash(\''.$js_value.'\', \''.$container_id.'\')">';
        $rows .= $value;
        $rows .= '</div>';
    }
    $rows .= '</div>';
    $html .= $rows;
    $html .= '</div>';

    $cash_memo = $style . $html;
    return $cash_memo;
}

function account00_draw_room_charge_memo($container_id) {
    
    $style = '
        <style>
            ._account00_pay_d_room_charge_memo_container {
                text-align: left;
            }
            ._account00_pay_d_room_charge_memo_rows {
                display: flex;
                align-content: center;
                flex-wrap: wrap;
                justify-content: flex-start;
            }
            ._account00_pay_d_room_charge_memo_buttons {
                background-color: #e9e9e9;
                width: 20%;
                box-sizing: border-box;
                border: 2px solid white;
                text-align: center;
                font-weight: normal;
                cursor: pointer;
                
                display: flex;
                flex-direction: column;
                height: 60px;
                align-content: center;
                flex-wrap: wrap;
                justify-content: space-evenly;
                align-items: center;
                font-size: 12px;

                &.active {
                    color: #ffffff;
                    background-color: #00d26d;
                }
            }
            ._account00_pay_d_room_charge_memo_buttons .room_title {
                font-weight: bold;
                font-size: 14px;
            }

            @media only screen and (max-width: 500px) {
                ._account00_pay_d_room_charge_memo_buttons {
                    width: 50%;
                }
            }
        </style>
    ';

    $queryParams = array();
    $queryParams["lang"] = $_SESSION['lang'];

    $query = "SELECT
                hota04.nr01     as hota04_nr01,
                hota04.p027     as hota04_p027,
                hota04.p015     as hota04_p015,
                hota04.p03      as hota04_p03,
                hota04.p04      as hota04_p04,
                hota04.p0160    as hota04_p0160,
                hota04.p01600   as hota04_p01600,
                hota04.p017     as hota04_p017,
                hota04.p030     as hota04_p030,
                hota04.p050     as hota04_p050,
                hota40.p02      as hota40_p02,
                a01.p19         as p030_sel,
                a01_00.p19      as p061_sel,
                IF(:lang = 'EN' && hota81.ep02 !='', hota81.ep02, hota81.p02) as pkat_sel
            FROM hota40
            LEFT JOIN hota04 ON hota04.nr01=hota40.p01
            LEFT JOIN hota81 ON hota81.p01=hota04.pkat and hota81.p03=0
            LEFT JOIN a01 ON a01.nr01=hota04.p030
            LEFT JOIN a01 as a01_00 ON a01_00.nr01=hota04.p061
            WHERE
                hota04.p024 <= '01000101' 
                and hota04.p027>'01000101'
                and hota04.p028<='01000101'
                and hota04.plog = 1 
                and hota04.nr01 = hota40.p01 
                and hota40.p107 = 1 
                and hota40.p101=curdate()
            GROUP BY hota40_p02
            ORDER BY hota40.p02;";
    $query_res = pegasus_query($query, $queryParams);
    

    $rows = '<div class="_account00_pay_d_room_charge_memo_rows">';
    while ($data = pegasus_fetch_assoc($query_res)) {
        $onomateponimo = $data['hota04_p03'];
        if(!empty($data['hota04_p04'])) {
            $onomateponimo .= ' ' . $data['hota04_p04'];
        }
        $rows .= '<div class="_account00_pay_d_room_charge_memo_buttons" id="_account00_pay_d_room_charge_memo_button_'.$data['hota04_nr01'].'" onclick="account00_pay_d_change_room(\''.$data['hota04_nr01'].'\', \''.$container_id.'\')">';
        $rows .= '<div class="room_title">' . $data['hota40_p02'] . '</div>';
        $rows .= '<div class="customer_title">' . $onomateponimo . '</div>';
        $rows .= '</div>';
    }
    $rows .= '</div>';


    $html = '<div class="_account00_pay_d_room_charge_memo_container">' . $rows . '</div>';
    $memo = $style . $html;
    return $memo;
}

function account00_set_a14_global_var($a55_nr01, $mode = '', $container_id = '') {
	pegasus_mysql_use('SELECT * FROM a55 WHERE nr01 = ?', $a55_data, array($a55_nr01));
	
	if (!empty($a55_data['p05'])) {
        $kklo_p05 = pegasus_mysql_printfld('a10', 'p04', 'p01 = :a55p05', array('a55p05' => $a55_data['p05']));
        $kkxr_p05 = pegasus_mysql_printfld('t02', 'p03', 'p01 = :kklo_p05', array('kklo_p05' => $kklo_p05));
        if($kkxr_p05 > 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 > 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);
            

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params  = $p02_in['sqlParams'];
            $a14_where_sql = "(a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 > 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 > 0 
                                AND pos00_02.cor003p01 = :termatiko ";
                pegasus_mysql_use($query_2, $val_2, array('termatiko' => $_SESSION['pegasus_client_uid']));
                
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);
                
                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "(a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }elseif($kkxr_p05 < 0) {
            $query = "SELECT GROUP_CONCAT(p01 SEPARATOR ',') AS p02_in FROM t02 WHERE p04 < 0";
            pegasus_mysql_use($query, $val);
            $p02_in_arr = explode(',' , $val['p02_in']);

            $p02_in      = pegasus_mysql_create_in($p02_in_arr, 'p02');
            $all_params = $p02_in['sqlParams'];
            $a14_where_sql = "(a14.p02 IN (" . $p02_in['sql'] . ")";
            if(pegasus_module_exists('pos00')) {
                // Και τα pos00_02 με τρόπο είσπραξης και ΚΚ.Λογ όπου το t02.p04 < 0
                $query_2 = "SELECT 
                                GROUP_CONCAT(a14 SEPARATOR ',') AS pos00_02_in 
                            FROM pos00_02 
                            JOIN t02 ON pos00_02.t02p01 = t02.p01
                            WHERE 
                                pos00_02.a14 > 0 
                                AND pos00_02.t02p01 > 0
                                AND t02.p04 < 0 
                                AND pos00_02.cor003p01 = :termatiko ";
                pegasus_mysql_use($query_2, $val_2, array('termatiko' => $_SESSION['pegasus_client_uid']));
                $pos00_02_in_arr = explode(',', $val_2['pos00_02_in']);

                $pos00_02_in = pegasus_mysql_create_in($pos00_02_in_arr, 'pos00_02');
                $all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams']);
                $a14_where_sql = "(a14.p02 IN (" . $p02_in['sql'] . ") OR a14.nr01 IN (" . $pos00_02_in['sql'] . ")";
            }
        }
        //* Αν έχει το δικαίωμα retail00_001 - Τότε εμφανίζω και τους Τρ. Είσπραξης χωρίς ΚΚ. Λογιστηρίου.
        //* Αν έχει και module POS, εξαιρώ από αυτό το IN τους Τρ. Είσπραξης χωρίς ΚΚ. Λογιστηρίου με σύνδεση σε Ρυθμίσεις POS.
		if(($mode == 'retail00_01' && pegasus_check_permission('retail00_001') == 1) || $mode != 'retail00_01') {
			if(pegasus_module_exists('pos00')) {
				$query_3 = "SELECT 
								GROUP_CONCAT(a14.nr01 SEPARATOR ',') AS a14_nr01_in
							FROM a14
							LEFT JOIN pos00_02 ON pos00_02.a14 = a14.nr01
							WHERE 
								pos00_02.a14 IS NULL
								AND a14.p02 = 0 ";
				pegasus_mysql_use($query_3, $val_3);
				$a14_nr01_in_arr = explode(',', $val_3['a14_nr01_in']);

				$a14_nr01_in = pegasus_mysql_create_in($a14_nr01_in_arr, 'a14_nr01');
				$all_params = array_merge($p02_in['sqlParams'], $pos00_02_in['sqlParams'], $a14_nr01_in['sqlParams']);
				$a14_where_sql .= " OR a14.nr01 IN (" . $a14_nr01_in['sql'] . ")";
			}else{
				$a14_where_sql .= " OR a14.p02 = 0";
			}
		}
        //* όλα τα προηγούμενα ΚΑΙ Διαδοχή >= 0 
        $a14_where_sql .= " ) AND a14.p100 >= 0 ";
        // echo '<pre>' . pegasus_replace_values_in_sql($a14_where_sql, $all_params) . '</pre>';
        pegasusSetGlobalVar(
            $container_id . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
        pegasusSetGlobalVar(
            'peg_'. $a55_data['nr01'] . '_a14_where',
            array(	'sql'		=> $a14_where_sql,
                    'sqlParams'	=> $all_params
            )
        );
	}
}

function account00_is_epi_pistosi_a14($a14_nr01) {
    pegasus_mysql_use('SELECT nr01, p02 FROM a14 WHERE nr01 = ? ', $a14, array($a14_nr01));;
    
    $is_epi_pistosi = 0;
    //* Αν βρήκα a14 με το παραπάνω ΜΚ και αυτό το a14 δεν έχει ΚΚ Λογιστηρίου
    if(!empty($a14['nr01']) && empty($a14['p02'])) {
        //* Σημαίνω τους Τρ. Είσπραξης που είναι Επί Πιστώσει, χωρίς σύνδεση με Ρυθμίσεις POS
        $has_pos00_02 = 0;
        if(pegasus_module_exists('pos00')) {
            $has_pos00_02 = pegasus_mysql_printfld('pos00_02', 'nr01', 'a14 = ?', array($a14_nr01));
        }
        if(empty($has_pos00_02)) {
            $is_epi_pistosi = 1;
        }
    }

    return $is_epi_pistosi;
}

/**
 * Θα προσθέτει κίνηση με σχετικό ΜΚ το a55nr01 και θα επιστρέφει το υπόλοιπο
 * Θα υπολογίζουμε τη διαφορά συνολικού ποσού και υπολοίπου και αν είναι 0 θα προχωράμε και σε καταχώρηση του παρ/κου
 * $data = array δεδομένων που έχω στο ajax (όλο το παραστατικό και το a01nr01) TODO: Να δω τι θα καταλήξω να χρειάζομαι από αυτά
 */
function account00_add_t01($data = array()) {

    $a55p05 = $data['p05'];
    $a55nr01 = $data['nr01'];
    $payment = $data['payment'];

    // Στοιχεία Ορισμού Παραστατικού
    pegasus_mysql_use('SELECT * FROM a10 WHERE p01 = ?', $a10, array($a55p05));
    // Στοιχεία Ορισμού Τρόπου Είσπραξης
    pegasus_mysql_use('SELECT * FROM a14 WHERE nr01 = ?', $a14, array($payment));
    $p_kklo = $a14['p02']; // Κωδικός Κίνησης Λογιστηρίου (Σε αυτές τις κινήσεις θα παίρνω του Τρόπου Είσπραξης)

    // Στοιχεία Κωδικού Κίνησης Λογιστηρίου (του επιλεγμένου παραστατικού)
    pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = ? ', $t02, array($p_kklo));
    $p_kkxr = $t02['p03']; // Συντελεστής Χρέωσης
    $p_kkpi = $t02['p04']; // Συντελεστής Πίστωσης

    $p_asyn = 1; // Λογικά εδώ πάντα θα είναι 1, γίνεται -1 όταν αφορά ακύρωση.

    /* START ADD t01 */
    $p303 = '9';
    
    if ($data['pn01'] == '' or $data['pn02'] <= 0) {
        $data['pn02'] = '1';
    }
    $p02 = date('H:i');
	//? Σχολίασα την ώρα και έβαλα και την ημερομηνία
    // if(!empty($data['p02'])) {
    //     $p02 = $data['p02'];
    // }
	$p01 = date('Y-m-d');

    pegasus_mysql_use('SELECT * FROM a01 WHERE nr01 = ?', $a01, array($data['p03']));

    $peg_arr1 = array();            $peg_arr2 = array();
    array_push($peg_arr1, 'p01');   array_push($peg_arr2,  $a01['p21']);
    array_push($peg_arr1, 'p02');   array_push($peg_arr2,  $p01); //YES
    array_push($peg_arr1, 'p02t');  array_push($peg_arr2,  $p02); //NO

    //23/10/2023 -- Το ποσό έρχεται πλέον σε €, αφαίρεση τη διαίρεση και έβαλα πολλαπλασιασμό στο Ξένο
    array_push($peg_arr1, 'p03');   array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkxr); //NO
    array_push($peg_arr1, 'p04');   array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkpi); //NO

    array_push($peg_arr1, 'pn03');  array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkxr * $data['pn02']);
    array_push($peg_arr1, 'pn04');  array_push($peg_arr2,  $data['amount'] * $p_asyn * $p_kkpi * $data['pn02']);

    array_push($peg_arr1, 'pn01');  array_push($peg_arr2,  $data['pn01']); //NO
    array_push($peg_arr1, 'pn02');  array_push($peg_arr2,  $data['pn02']); //NO


    $t01_p05 = '';
    if (!empty($data['p705'])) {
        $t01_p05 .= $data['p705'] . ' '; //NO
    }
    $a14_p01 = pegasus_mysql_printfld('a14', 'p01', 'p02= ?', array($p_kklo));
    if (!empty($a14_p01)) {
        $t01_p05 .= $a14_p01 . ' ';
    }
    $t01_p05 .= $data['p010'];
    array_push($peg_arr1, 'p05');   array_push($peg_arr2, $t01_p05);
    array_push($peg_arr1, 'p06');   array_push($peg_arr2,  $a10['p00'] . ' ' . $data['p701'] . ' ' . $data['p06']); //NO //NO

    array_push($peg_arr1, 'p07');   array_push($peg_arr2,  $p_kklo);
    array_push($peg_arr1, 'p09');   array_push($peg_arr2,  $data['p0121']); //NO

    // array_push($peg_arr1, 'p900');  array_push($peg_arr2,  $data['a55p04']); //YES
    array_push($peg_arr1, 'p900');  array_push($peg_arr2,  $data['p04']);
    // array_push($peg_arr1, 'p101');  array_push($peg_arr2,  $data['p0105']);
    // array_push($peg_arr1, 'p201');  array_push($peg_arr2, ($data['p0100'] - $data['p0102']));

    array_push($peg_arr1, 'p503');  array_push($peg_arr2,  $data['p503']); //NO
    array_push($peg_arr1, 'p504');  array_push($peg_arr2,  $data['p504']); //NO
    array_push($peg_arr1, 'p401');  array_push($peg_arr2,  $data['p016']); //NO

    if (pegasus_mysql_printfld('t01', 'count(*)', 'p302=? and p303=4', array($data['nr01'])) > 0) {
        pegasus_mysql_update('t01', $peg_arr1, $peg_arr2, 'p302=? and p303=4 ', 0, 1, 1, array($data['nr01']));
    } else {
        
        $t01_nr01 = pegasus_mysql_newrec('t01');
        array_push($peg_arr1, 'nr01');  array_push($peg_arr2,  $t01_nr01);
        array_push($peg_arr1, 'p302');  array_push($peg_arr2,  $data['nr01']);
        array_push($peg_arr1, 'p303');  array_push($peg_arr2,  $p303);
        array_push($peg_arr1, 'pd101');  array_push($peg_arr2,  'a14');
        array_push($peg_arr1, 'pd102');  array_push($peg_arr2,  $a14['nr01']);
        // array_push($peg_arr1, 'remguc');  array_push($peg_arr2,  $a14['nr01']);
        pegasus_mysql_insert('t01', $peg_arr1, $peg_arr2);

        if(pegasus_mysql_table_exists('account_001')) {
            //* Αποθηκεύει στον [account_001 - Επιπλέον Πεδία t01] το ποσό που εισπράχθηκε από την κίνηση μαζί με τα ρέστα.
            //* Ενημερώνει το πεδίο a55.p0110 και με το σύνολο τον χρημάτων που εισπράχθηκαν + ρέστα. π.χ. σε παραστατικό των 30€ αν ο πελάτης έδωσε 50€ και πήρε ρέστα 20€, εδώ αποθηκεύουμε 50. 
            $collected = $data['amount'];
            if($data['collected'] > 0) {
                $collected = $data['collected'];
            }
            $arr1 = array(); $arr2 = array();
            
            array_push($arr1, 'nr01');  array_push($arr2,  pegasus_mysql_newrec('account_001'));
            array_push($arr1, 't01');   array_push($arr2,  $t01_nr01);
            array_push($arr1, 'p04');   array_push($arr2,  $collected);
            pegasus_mysql_insert('account_001', $arr1, $arr2);
        }
    }
    /* END ADD t01 */

    //* Από εδώ και κάτω υπολογίζω το υπόλοιπο όλων των κινήσεων για αυτό το σχετικό ΜΚ και το επιστρέφω.
	//TODO mode
    $remainder = invoices_calc_a55_aneisprakto($data['nr01'], 'a55', false, true);
    

    return $remainder;
}

/**
 * Θα προσθέτει κίνηση Λοιπή Χρέωσης-Πίστωσης Διαμονής με σχετικό ΜΚ το a55nr01 και θα επιστρέφει το υπόλοιπο
 * @param array $data   δεδομένων που έχω στο ajax (όλο το παραστατικό και καποια params) TODO: Να δω τι θα καταλήξω να χρειάζομαι από αυτά
 */
function account00_add_hota17($data = array()) {

    $a55p05  = $data['p05'];

    // Στοιχεία Ορισμού Παραστατικού
    pegasus_mysql_use('SELECT * FROM a10 WHERE p01=?', $a10, array($a55p05));

    $peg_arr1 = array();                $peg_arr2 = array();
    array_push($peg_arr1, 'pnr01');     array_push($peg_arr2, $data['hota04_nr01']);
    array_push($peg_arr1, 'pd101');     array_push($peg_arr2, "a55");
    array_push($peg_arr1, 'pd102');     array_push($peg_arr2, $data['nr01']);
    array_push($peg_arr1, 'pdat');      array_push($peg_arr2, $data['p01']);    
    array_push($peg_arr1, 'p07');       array_push($peg_arr2, $data['p02']);   
    array_push($peg_arr1, 'p04');       array_push($peg_arr2, $data['amount']);
    array_push($peg_arr1, 'a01');       array_push($peg_arr2, $data['p03']);
    array_push($peg_arr1, 'p02');       array_push($peg_arr2, $_SESSION["f02_p9000"]);
    array_push($peg_arr1, 'p03');       array_push($peg_arr2, $a10['p00'] . ' ' . $data['p701']);
    // array_push($peg_arr1, 'p30');       array_push($peg_arr2, "account00");

    array_push($peg_arr1, 'nr01');  array_push($peg_arr2,  pegasus_mysql_newrec('hota17'));
    pegasus_mysql_insert('hota17', $peg_arr1, $peg_arr2);

    //* Από εδώ και κάτω υπολογίζω το υπόλοιπο όλων των κινήσεων για αυτό το σχετικό ΜΚ και το επιστρέφω.
    $remainder = invoices_calc_a55_aneisprakto($data['nr01'], 'a55', false, true);    

    return $remainder;
}

function account00_update_y_ekd($data, $no_confirm = 0, $mode = '') {

    if($data['tbl'] == 'a55' && $data['tbl_nr01'] > 0) {

        $screen = new screen();
        $screen->container_id = pegasus_container_id_create(0, session_id(), 'a55_d');
        $screen->module       = 'invcust';
        $screen->_d           = 'a55_d';
        $screen->table        = 'a55';
        $screen->nr01         = $data['tbl_nr01'];
        $screen->mnr01        = $data['tbl_nr01'];
        $screen->mmnr01       = 'a55_d-' . $data['tbl_nr01'];
        $screen->read_data_from_db(); // Δεν τη θέλω, τρέχει initialize και μου κόβει Nr01.
        $screen->read_params_from_db();
        // $screen->mmnr01       = 'a55_d-' . $a55_nr01;
        // echo $screen->data;
        //* Σκέφτηκα την αρχικοποίηση ημερομηνίας/ώρας αλλά θα τα κάνει η onsave του παραστατικού, όπως επίσης και τον αριθμό

        $screen->data['y_ekd'] = 0;
        $a55p30 = $screen->data['p30'];
        if($no_confirm == 1 /*&& $mode == 'retail00'*/) {
            $t01_query = 'SELECT * FROM t01 WHERE p302 = :a55nr01 AND p303 = 9';
            $t01_res = pegasus_query($t01_query, array('a55nr01' => $data['tbl_nr01']));
            //* Αν έχω μόνο μια κίνηση με όλο το ποσό για το παραστατικό, αλλάζω τον Τρόπο Είσπραξης του παραστατικού σε αυτόν της κίνησης.
            //* Κρατάω τον Τρόπο Είσπραξης στο t01.remguc ----> αλλαξε σε t01.pd102
            if(pegasus_num_rows($t01_res) == 1) {
                while($row = pegasus_fetch($t01_res, PEG_FETCH_ASSOC)) {
                    if (abs($row['pn03'] + $row['pn04']) == 0) {
                        $t01_total = abs($row['p03'] + $row['p04']);
                    } else {
                        $t01_total = abs($row['pn03'] + $row['pn04']);
                    }
                    //* Επιπλέον failsafe αν η κίνηση έχει όλο το ποσό του παραστατικού
                    if($screen->data['p0109'] - $t01_total == 0) {
                        $screen->data['p015'] = $row['pd102'];
                        $is_pos = 0;
                        if(pegasus_module_exists('pos00')) {
                            $pos00_02 = pos00_find_pos00_02($row['pd102'], $_SESSION["cor003_p01"]);
                            if(!empty($pos00_02)) {
                                $is_pos = 1;
                            }
                        }
                        //* Αν η κίνηση αφορά πληρωμή από POS, τότε κρατάμε την κατηγορία της σε 9.
                        if($is_pos == 0) {
                            pegasus_mysql_update('t01', array('p303'), array(4), 'nr01 = ?', 0, 1, 1, array($row['nr01']));
                        }
                    }
                }
            }else{
                //* Σημειώσεις για την κάθε κίνηση πρσθέτουμε μόνο όταν είναι παραπάνω από μία.
                while($row = pegasus_fetch($t01_res, PEG_FETCH_ASSOC)) {
                    if(!empty($a55p30)) {
                        $a55p30 .= "\n";
                    }
                    $a55p30 .= $row['p05'] . ": " . $row['p04'];
                }
            }
        }
    
        $screen->data['p30']   = $a55p30;
        // echo '<pre>' .print_r($screen->data, 1). '</pre>';
        $_REQUEST = $screen->data;
        $_REQUEST['no_confirm'] = $no_confirm;
        $ret = $screen->save_data();
    
        peg_close_d($screen->container_id);
    
        //ret[0] == false ---> Deny
        //ret[0] == true ----> ΟΚ
        //ret[0] == true ΚΑΙ ret[1] == "μήνυμα" ---> Confirm
        if ($ret[0] == false) {
            $ret_array['ok'] = 0;
            $ret_array['msg'] = $ret[1];
            return $ret_array;
        }
    
        $ret_array['ok'] = 1;
        $ret_array['data'] = $screen->data;
        if($ret[0] == true && !empty($ret[1])) {
            $ret_array['msg'] = $ret[1];
        }
    }

    return $ret_array;
}

function account00__account00_pay_d09_initialize($data,$mmnr01,$mnr01,$_d,$container_id){
	global $PegInput;
	$PegInput->addVar(new peg_input_alphanumeric('a55_msg'));
    $PegInput->addVar(new peg_input_alphanumeric('device'));    
    $PegInput->addVar(new peg_input_alphanumeric('account00_tbl'));    
    $PegInput->addVar(new peg_input_number('account00_tbl_nr01'));    

    $account00_tbl = $PegInput->getRequest('account00_tbl');  
	$account00_tbl_nr01 = $PegInput->getRequest('account00_tbl_nr01'); 
    $data['v_tbl'] = $account00_tbl;
	$data['v_tbl_nr01'] = $account00_tbl_nr01;

    $data['collected_hidden'] = true;
    $data['change_hidden'] = true;
    $data['cash_memo_hidden'] = true;
    
    $data['fldcont01_hidden'] = true;
    // $data['cash_memo'] = account00_draw_cash_memo($container_id);

    $a55_msg = $PegInput->getRequest('a55_msg');   
    $device = $PegInput->getRequest('device');

    $a55_msg = ltrim($a55_msg, '<br />'); // Remove break line from First Message.
    $data['message'] = '<div class="peg_alert_info_plain">' .$a55_msg. '</div>';
    
    if(pegasus_module_exists('imin00') && in_array($device, array('mobile'))){
        $data['but_print_imin_hidden'] = false;
    }

    if(pegasus_module_exists('epson00')){
        $data['but_print_epson_hidden'] = false;
    }
 
    return $data;
}

function account00_set_idtorefund_globalvar($pos00_02_nr01, $container_id) {
    pegasus_mysql_use('SELECT * FROM pos00_01 WHERE nr01 = :pos00_01_nr01', $pos00_01, array("pos00_01_nr01" => $pos00_02_nr01));

    // ******************* v_idtorefund query / where START ******************

    $pos00_04_flds_res = pegasus_query("SELECT desc05 FROM p51 
    JOIN p60 ON p60.p00 = p51.desc16 AND p60.isdbfld = 1
    WHERE p02 = 'pos00_04_d' AND module = 'pos00'");
    
    $fakerecord_select_flds = "";
    $truerecord_select_flds = "";
    while ($pos00_04_flds = pegasus_fetch_assoc($pos00_04_flds_res)) {
        if(!empty($fakerecord_select_flds)) {
            $fakerecord_select_flds .= " , ";
        }

        switch ($pos00_04_flds['desc05']) {
            case 'nr01':
                $fakerecord_select_flds .= " -1 AS " . $pos00_04_flds['desc05'] ." ";
                break;
            case 'descr':
                $fakerecord_select_flds .= " 'Χειροκίνητη Εισαγωγή' AS " . $pos00_04_flds['desc05'] ." ";
                break;
            default:
                $fakerecord_select_flds .= " '' AS " . $pos00_04_flds['desc05'] ." ";
        }
        
        if(!empty($truerecord_select_flds)) {
            $truerecord_select_flds .= " , ";
        }
        $truerecord_select_flds .= " pos00_04.".$pos00_04_flds['desc05']." AS " . $pos00_04_flds['desc05'] ." ";
    }
    $fakerecord_extra_flds = " , '' AS remfdate ";
    $truerecord_extra_flds = " , pos00_04.remfdate AS remfdate ";
    $v_idtorefund_query = 
    "SELECT * FROM (
        SELECT
            ".$fakerecord_select_flds.$fakerecord_extra_flds."
        UNION
        SELECT 
            ".$truerecord_select_flds.$truerecord_extra_flds."
        FROM pos00_04
        ORDER BY nr01 desc
    ) as pos00_04_tmp";
    
    $where_date = '';
    if($pos00_01['p02'] != 4) {
        //* Αν δεν είναι VIVA φέρνουμε μόνο τις σημερινές
        $where_date = ' AND pos00_04.remfdate = curdate() ';
    }
    
    
    //Πλέον ελέγχω και το ποσό, σε περίπτωση που έχει γίνει μερικό refund (partial refund) να μου την ξαναφέρει.
    //Σε περίπτωση της VIVA έχω void που βεβαια επιτρέπει το μερικό refund
    $v_idtorefund_where = ' pos00_04.nr01 = -1 OR (pos00_04.type = 1 AND pos00_04.t01 > 0 AND pos00_04.pos00_01 = :pos00_01 AND pos00_04.p02=0
                            AND pos00_04.txnid NOT IN (
                                SELECT txnidinit FROM (
                                    SELECT 
                                        pos00_04_tmp2.txnidinit, 
                                        sum(pos00_04_tmp2.amount) as refund_amount, 
                                        pos00_04_tmp3.amount as sale_amount 
                                    FROM pos00_04 AS pos00_04_tmp2
                                    JOIN pos00_04 AS pos00_04_tmp3 ON pos00_04_tmp3.txnid=pos00_04_tmp2.txnidinit
                                    WHERE pos00_04_tmp2.p02<>1 AND pos00_04_tmp2.type IN (2, 3)
						            GROUP BY pos00_04_tmp2.txnidinit
						            HAVING refund_amount>=sale_amount
                                ) as pos00_04_tmp5 
                            )
                            '.$where_date.') ';
                            

    pegasusSetGlobalVar($container_id . '_query_v_idtorefund', $v_idtorefund_query);
    pegasusSetGlobalVar($container_id . '_where_v_idtorefund', 
        array(
            'sql' => $v_idtorefund_where,
            'sqlParams' => array("pos00_01" => $pos00_02_nr01)
        )
    );
    // ******************* v_idtorefund query / where END ******************
}

function account00_account00_01_d_comboboxV2_dynamic_fields_where($field_name, $container_id){ 

    //Το Where για a55 που έχουν t35 με μη μηδενικό υπόλοιπο
    if (substr($field_name, 0, 13) == 'a55_rec_nr01_') {

        $sql  = "a55.y_ekd=0 AND a55.nr01 IN (SELECT t35.tbl_nr FROM t35 WHERE t35.tbl='a55' AND t35.p03 <> 0) AND a55.p08=0  ";       
        $sql .= " AND a55.p03=:a55_p03 ";    //Φέρνει τα Παραστατικά του Πελάτη
        
        $values_arr = array();
        $values_arr['a55_p03'] = pegasusGetGlobalVar($container_id.'_v_a01');
        
        $hota04_nr01 = pegasusGetGlobalVar($container_id.'_v_hota04');
        if($hota04_nr01>0){
            //Αν αφορά Κράτηση & Δε θα πρεπει να φερνει τα Παραστατικά απο Μαζική Κράτηση
            $sql .= " AND a55.nr01 IN ( 
                            select a55_nr01 from (
                                select
                                    group_concat(DISTINCT hota04.nr01 separator '##') as group_hota04_nr01,
                                    group_concat(DISTINCT hota17.nr01 separator '##') as group_hota17_nr01,
                                    i01.p06 as a55_nr01
                                from i01
                                left join hota17 on i01.pd101='hota17' and i01.pd102=hota17.nr01
                                join hota04 on (i01.pd101='hota04' and i01.pd102=hota04.nr01) or (hota04.nr01=hota17.pnr01)     
                                where i01.p07=2 
                                group by i01.p06
                                having group_hota04_nr01 not like '%##%' and group_hota04_nr01=:hota04_nr01
                            ) as a55_00
            ) ";

            $values_arr['hota04_nr01'] = $hota04_nr01;
        }

        $ret_arr = array('sql' => $sql, 'sqlParams' => $values_arr);
    }

    return $ret_arr;
}

function account00_after_update()
{
    pegasus_mysql_use('select rel, ver from p55 where p00="account00"', $version);

	if($version['ver'] == 1 && $version['rel'] <= 80) {
        if(pegasus_module_exists('receipts')){
            account00_create_eftpos_t10_t11();
        }
    }
}

function account00_create_eftpos_t10_t11() 
{
	if(empty(pegasus_mysql_printfld('q31', 'nr01', 'p01 = 620019 && p05 = "8.4"'))){

		//Βρισκω τον κωδικό (p01) της αποδ. εισπραξης
		pegasus_mysql_use("SELECT max(p01) + 10 as max_p01 FROM t10", $t10); 
		

		//Βρισκω τον κωδικό (p01) τou KK Λογ
        pegasus_mysql_use(
			"SELECT MAX(p01) AS max_p01 FROM t02 where t02.p01 < 2000 and t02.p01 > 1000",
			$t02
		); 

        if(!empty($t02['max_p01']) && empty(pegasus_mysql_printfld('t02', 'p01', 't02.p01 = ?', array($t02['max_p01'] + 1)))){
            $t02_p01 = $t02['max_p01'] + 1;
        }else{
            pegasus_mysql_use(
                "SELECT MAX(p01) AS max_p01 FROM t02",
                $t02
            );
            $t02_p01 = $t02['max_p01'] + 1;
        }

		//Δημιουργία εγγραφής στον q31 (συσχετισεις)
		$q31_arr1 = array();					$q31_arr2 = array();
		array_push($q31_arr1, 'nr01');			array_push($q31_arr2, pegasus_mysql_newrec('q31'));
		array_push($q31_arr1, 'p01');			array_push($q31_arr2, '620019');
		array_push($q31_arr1, 'p03');			array_push($q31_arr2,  $t10['max_p01']);
		array_push($q31_arr1, 'p05');			array_push($q31_arr2, '8.4');

		pegasus_mysql_insert('q31', $q31_arr1, $q31_arr2);

		//Δημιουργία Μετρητή για Απόδειξης Είσπραξης EFTPOS
		$a12_nr01 = pegasus_mysql_newrec('a12');
		$a12_arr1 = array();					$a12_arr2 = array();
		array_push($a12_arr1, 'nr01');			array_push($a12_arr2,  $a12_nr01);
		array_push($a12_arr1, 'p00');			array_push($a12_arr2,  'Απόδειξη Είσπραξης EFTPOS');

		pegasus_mysql_insert('a12', $a12_arr1, $a12_arr2);

		//Δημιουργία Απόδειξης Είσπραξης EFTPOS
		$t10_arr1 = array();					$t10_arr2 = array();
		array_push($t10_arr1, 'nr01');			array_push($t10_arr2, pegasus_mysql_newrec('t10'));
		array_push($t10_arr1, 'p01');			array_push($t10_arr2,  $t10['max_p01']);
		array_push($t10_arr1, 'p00');			array_push($t10_arr2,  'ΑΕΙΣΕ');
		array_push($t10_arr1, 'p02');			array_push($t10_arr2,  'Απόδειξη Είσπραξης EFTPOS');
		array_push($t10_arr1, 'p04');			array_push($t10_arr2,  $t02_p01); 
		array_push($t10_arr1, 'p06');			array_push($t10_arr2,  $a12_nr01);
		array_push($t10_arr1, 'p0102');			array_push($t10_arr2,  1);

		pegasus_mysql_insert('t10', $t10_arr1, $t10_arr2);

		//Δημιουργία KK Λογ για Απόδειξης Είσπραξης EFTPOS
		$t02_arr1 = array();					$t02_arr2 = array();
		array_push($t02_arr1, 'nr01');			array_push($t02_arr2, pegasus_mysql_newrec('t02'));
		array_push($t02_arr1, 'p01');			array_push($t02_arr2,  $t02_p01);
		array_push($t02_arr1, 'p02');			array_push($t02_arr2,  'Απόδειξη Είσπραξης EFTPOS');
		array_push($t02_arr1, 'p04');			array_push($t02_arr2,  1);
		array_push($t02_arr1, 'p010');			array_push($t02_arr2,  1);


		pegasus_mysql_insert('t02', $t02_arr1, $t02_arr2);


		//Δημιουργία αιτιολογιας Είσπραξη POS
		$t11_arr1 = array();					$t11_arr2 = array();
		array_push($t11_arr1, 'nr01');			array_push($t11_arr2, pegasus_mysql_newrec('t11'));
		array_push($t11_arr1, 'p01');			array_push($t11_arr2,  'ΑΕΙΣΕ');
		array_push($t11_arr1, 'p02');			array_push($t11_arr2,  'Είσπραξη EFTPOS');
		array_push($t11_arr1, 'p03');			array_push($t11_arr2,  0);
		array_push($t11_arr1, 'p015');			array_push($t11_arr2,  1);
		array_push($t11_arr1, 'p30');			array_push($t11_arr2,  '#'.$t10['max_p01'].'#');


		pegasus_mysql_insert('t11', $t11_arr1, $t11_arr2);

	}

	if(!empty($t02['max_p01']) && empty(pegasus_mysql_printfld('q31', 'nr01', 'p01 = 620019 && p05 = "8.5"'))){

		//Βρισκω τον κωδικό (p01) της αποδ. εισπραξης
		pegasus_mysql_use("SELECT max(p01) + 10 as max_p01 FROM t10", $t10); 
		

		//Βρισκω τον κωδικό (p01) τou KK Λογ
        pegasus_mysql_use(
			"SELECT MAX(p01) AS max_p01 FROM t02 where t02.p01 < 2000 and t02.p01 > 1000",
			$t02
		); 

        if(empty(pegasus_mysql_printfld('t02', 'p01', 't02.p01 = ?', array($t02['max_p01'] + 1)))){
            $t02_p01 = $t02['max_p01'] + 1;
        }else{
            pegasus_mysql_use(
                "SELECT MAX(p01) AS max_p01 FROM t02",
                $t02
            );
            $t02_p01 = $t02['max_p01'] + 1;
        } 

		//Δημιουργία εγγραφής στον q31
		$q31_arr1 = array();					$q31_arr2 = array();
		array_push($q31_arr1, 'nr01');			array_push($q31_arr2, pegasus_mysql_newrec('q31'));
		array_push($q31_arr1, 'p01');			array_push($q31_arr2, '620019');
		array_push($q31_arr1, 'p03');			array_push($q31_arr2, $t10['max_p01']);
		array_push($q31_arr1, 'p05');			array_push($q31_arr2, '8.5');

		pegasus_mysql_insert('q31', $q31_arr1, $q31_arr2);

		//Δημιουργία Μετρητή για Απόδειξης Επιστροφης EFTPOS
		$a12_nr01 = pegasus_mysql_newrec('a12');
		$a12_arr1 = array();					$a12_arr2 = array();
		array_push($a12_arr1, 'nr01');			array_push($a12_arr2,  $a12_nr01);
		array_push($a12_arr1, 'p00');			array_push($a12_arr2,  'Απόδειξη Επιστροφης EFTPOS');

		pegasus_mysql_insert('a12', $a12_arr1, $a12_arr2);

		//Δημιουργία Απόδειξης Επιστροφης EFTPOS
		$t10_arr1 = array();					$t10_arr2 = array();
		array_push($t10_arr1, 'nr01');			array_push($t10_arr2, pegasus_mysql_newrec('t10'));
		array_push($t10_arr1, 'p01');			array_push($t10_arr2,  $t10['max_p01']);
		array_push($t10_arr1, 'p00');			array_push($t10_arr2,  'ΑΕΠΣΕ');
		array_push($t10_arr1, 'p02');			array_push($t10_arr2,  'Απόδειξη Επιστροφης EFTPOS');
		array_push($t10_arr1, 'p04');			array_push($t10_arr2,  $t02_p01); 
		array_push($t10_arr1, 'p06');			array_push($t10_arr2,  $a12_nr01);
		array_push($t10_arr1, 'p0102');			array_push($t10_arr2,  1);

		pegasus_mysql_insert('t10', $t10_arr1, $t10_arr2);

		//Δημιουργία KK Λογ για Απόδειξης Επιστροφης EFTPOS
		$t02_arr1 = array();					$t02_arr2 = array();
		array_push($t02_arr1, 'nr01');			array_push($t02_arr2, pegasus_mysql_newrec('t02'));
		array_push($t02_arr1, 'p01');			array_push($t02_arr2,  $t02_p01);
		array_push($t02_arr1, 'p02');			array_push($t02_arr2,  'Απόδειξη Επιστροφης EFTPOS');
		array_push($t02_arr1, 'p04');			array_push($t02_arr2,  -1);
		array_push($t02_arr1, 'p010');			array_push($t02_arr2,  1);

		pegasus_mysql_insert('t02', $t02_arr1, $t02_arr2);

		//Δημιουργία αιτιολογιας Επιστροφή POS
		$t11_arr1 = array();					$t11_arr2 = array();
		array_push($t11_arr1, 'nr01');			array_push($t11_arr2, pegasus_mysql_newrec('t11'));
		array_push($t11_arr1, 'p01');			array_push($t11_arr2,  'ΑΕΠΣΕ');
		array_push($t11_arr1, 'p02');			array_push($t11_arr2,  'Επιστροφή EFTPOS');
		array_push($t11_arr1, 'p03');			array_push($t11_arr2,  0);
		array_push($t11_arr1, 'p015');			array_push($t11_arr2,  1);
		array_push($t11_arr1, 'p30');			array_push($t11_arr2,  '#'.$t10['max_p01'].'#');

		pegasus_mysql_insert('t11', $t11_arr1, $t11_arr2);

	}
	
}

function account00_t18_d_initialize($data=array(), $mmnr01='', $mnr01=0, $_d='', $container_id=''){
        $new_rec = 0;            
        if(!($data['nr01']>0)){
            $new_rec = 1;
        }

        $mmnr01_arr = explode('-', $mmnr01);

        $data['p01_hidden'] = true;
        $data['p03_hidden'] = true;
        if(!empty($data['pos00_01'])) {
            pegasus_mysql_use('select * from pos00_01 where nr01=:pos00_01', $pos00_01, array('pos00_01'=>$data['pos00_01'])); 

            if(!empty($pos00_01['p02'])) {
    
                $t10_p04 = pegasus_mysql_printfld('t10', 'p04', 'p01=:t10p01', array('t10p01'=>$data['t10p01']));
                $t02_p04 = pegasus_mysql_printfld('t02', 'p04', 'p01=:t02p01', array('t02p01'=>$t10_p04));

                $device_properties = pos00_device_properties::get_properties($pos00_01['p02']);

                if($device_properties['moto'] && $t02_p04>0 && $pos00_01['mellv2_bnk']!=8) {
                    $data['p01_hidden'] = false;
                }
                
                if($device_properties['instalments'] && $t02_p04>0) {
                    $data['p03_hidden'] = false;
                }
            }
        }
        return $data;
    }