<?php
require_once('../account00/header.php');

global $PegInput;

$PegInput->addVar(new peg_input_alphanumeric('mode'));
$PegInput->addVar(new peg_input_alphanumeric('nr01s'));
// $nr01 = $PegInput->getRequest('account00_a55_nr01');

$mode  = $PegInput->getRequest('mode');
$nr01s = $PegInput->getRequest('nr01s');
$nr01s = array_filter(explode(',', $nr01s));


if(in_array($mode, array('a55_d', 'a55_d01'))){
	$tbl = 'a55';
}elseif($mode=='tran01_d'){
	$tbl = 'tran01';
}

// Leaving this commented for now just in case. 
// To be deleted.
// if( !(pegasus_module_exists('dias') ||  $_SESSION['cor011_account00_eftpos'] == 1) ) {
// 	$data = array();
// 	$data['ok'] = 0;
// 	$data['msg'] = 'Η επιλεγμένη λειτουργία δεν είναι ακόμη ενεργή. Σε αυτή την επιλογή θα εμπεριέχονται όλες οι αλλαγές σύμφωνα με την απόφαση Α. 1155 /09-10-2023.';
// 	print json_encode($data);
// 	return;
// }

// echo '<pre>' .print_r($nr01s, 1). '</pre>';
$ret_arr = array();
$ret_arr['ok']  = 1;
$ret_arr['msg'] = '';


if(!pegasus_module_exists("pos00")) {
	$ret_arr['ok']  = 0;
	$ret_arr['msg'] = $_SESSION['peg_dic_account00_add_payment_error_no_pos00'];
	print json_encode($ret_arr);
	return;
}


if(count($nr01s) > 1 && !pegasus_module_exists("account01")) {
	$ret_arr['ok']  = 0;
	$ret_arr['msg'] = $_SESSION['peg_dic_account00_add_payment_error_no_account01'];
	print json_encode($ret_arr);
	return;
}


if(count($nr01s)>1 && $mode=='tran01_d'){
	$ret_arr['ok']  = 0;
	$ret_arr['msg'] = $_SESSION['peg_dic_account00_add_payment_error_tran01_multi'];
	print json_encode($ret_arr);
	return;
}


$prev_a01 = 0;
$curr_a01 = 0;
foreach($nr01s as $nr01) {

	pegasus_mysql_use("SELECT * FROM ".$tbl." WHERE nr01 = ?", $tbl_data, array($nr01));

	if($tbl=='a55'){
		// Αν το παραστατικό είναι υπό έκδοση 
		$a10_p00  = pegasus_mysql_printfld('a10', 'p00', 'p01 = ?', array($tbl_data['p05']));
		$a01_nr01 = $tbl_data['p03'];

		$msg_prefix = "<u>" . $a10_p00 . " " . $tbl_data['p701'] . " " . $tbl_data['p06'] . " (" . $nr01 . ")</u>";

	}elseif($tbl=='tran01'){
		$tran20_p00 = pegasus_mysql_printfld('tran20', 'p00', 'p01 = ?', array($tbl_data['p105']));

		$msg_prefix = "<u>" . $tran20_p00 . " " . $tbl_data['sp00'] . " " . $tbl_data['p00'] . " (" . $nr01 . ")</u>";
		$a01_nr01 = $tbl_data['p61'];
	}

	$curr_a01 = $a01_nr01;
	if($prev_a01 == 0) { $prev_a01 = $a01_nr01; }

	if($curr_a01 != $prev_a01) {
		$ret_arr['ok']  = 0;
		$ret_arr['msg'] = $_SESSION['peg_dic_account00_add_payment_error_diff_a01'];
		break;
	}



	if($tbl=='a55'){
		if($tbl_data['y_ekd'] == 1) {
			if(!empty($ret_arr['msg'])) {
				$ret_arr['msg'] .= '<br>';
			}
			$ret_arr['ok']   = 0;
			$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_y_ekd'];
			continue;
		}

	}elseif($tbl=='tran01'){
		if($tbl_data['sp02'] != 1) {
			if(!empty($ret_arr['msg'])) {
				$ret_arr['msg'] .= '<br>';
			}

			$ret_arr['ok']   = 0;
			$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_tran01_not_issued'];
			continue;
		}
	}
	


	$t35_p03 = pegasus_mysql_printfld('t35', 'p03', 'tbl = "'.$tbl.'" AND tbl_nr = :nr01', array('nr01' => $nr01));
	if(empty($t35_p03) || $t35_p03 == 0) {
		if(!empty($ret_arr['msg'])) {
			$ret_arr['msg'] .= '<br>';
		}
		$ret_arr['ok']   = 0;
		$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_no_t35'];
		continue;
	}


	// Το παραστατικό δεν έχει αποσταλεί με e-invoicing (Pegasus Web App[1] & Τοπικό[51])
	$mydt10_einv = pegasus_mysql_printfld('mydt10', 'einv', "tbl = '".$tbl."' AND tbl_nr01 = :nr01", array('nr01' => $nr01));
	if(!in_array($mydt10_einv, array(1, 51))) {
		if(!empty($ret_arr['msg'])) {
			$ret_arr['msg'] .= '<br>';
		}
		$ret_arr['ok']   = 0;
		$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_no_einv'];
	}


	//Το παραστατικό πρέπει να έχει auth_code για να προχωρήσω στην ετεροχρονισμένη
	if(empty(pegasus_mysql_printfld('mydt10','auth_cd',"tbl = '".$tbl."' AND tbl_nr01 = :nr01", array('nr01' => $nr01)))) {
		if(!empty($ret_arr['msg'])) {
			$ret_arr['msg'] .= '<br>';
		}
		$ret_arr['ok']   = 0;
		$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_no_mark'];
	}



	if($tbl=='a55'){
		$sql = "	SELECT COUNT(q31.nr01) q31_cnt
					FROM a55
					JOIN q31 ON q31.p01 IN (620014,620068) AND q31.p03 = a55.p05
					WHERE a55.nr01 = :nr01
				";

	}elseif($tbl=='tran01'){
		$sql = "	SELECT COUNT(q31.nr01) q31_cnt
					FROM tran01
					JOIN q31 ON q31.p01 IN (620030) AND q31.p03 = tran01.p105
					WHERE tran01.nr01 = :nr01
				";
	}

	

	$q31_check = array();
	pegasus_mysql_use($sql, $q31_check, array('nr01' => $nr01));
	if(!($q31_check['q31_cnt'] > 0 )) {
		if(!empty($ret_arr['msg'])) {
			$ret_arr['msg'] .= '<br>';
		}
		$ret_arr['ok']   = 0;
		$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_no_q31'];
	}


	if(pegasus_mysql_printfld('mydt10', 'COUNT(*)', "tbl = '".$tbl."' AND tbl_nr01 = :nr01 AND invtype IN ('8.4' , '8.5' , '8.6')",array('nr01' => $nr01)) > 0) {
		if(!empty($ret_arr['msg'])) {
			$ret_arr['msg'] .= '<br>';
		}
		$ret_arr['ok']   = 0;
		$ret_arr['msg'] .= $msg_prefix . ": " . $_SESSION['peg_dic_account00_add_payment_error_no_invtypes'];
	}
}

print json_encode($ret_arr);