<?php

require_once('../account00_00/header.php');

$PegInput->addVar(new peg_input_alphanumeric('container_id'));
$PegInput->addVar(new peg_input_number('a14nr01'));
$PegInput->addVar(new peg_input_alphanumeric('tbl'));
$PegInput->addVar(new peg_input_number('tbl_nr01'));


$container_id = $PegInput->getRequest('container_id');
$a14nr01      = $PegInput->getRequest('a14nr01');

$tbl = $PegInput->getRequest('tbl');
$tbl_nr01 = $PegInput->getRequest('tbl_nr01');


$ret_arr = array("ok" => 0, "msg" => "", "error" => 0);

$ret_arr['v_idtorefund_hidden']  = true;
$ret_arr['v_instalments_hidden'] = true;

//2 Περιπτώσεις:
//1 -> Η συσκευή POS των ρυθμίσεων του τρόπου είσπραξης, απαιτεί υπογραφή και στον Τρ. Είσπραξης, δεν έχει οριστεί Τρόπος Είσπραξης myDATA.
//2 -> Η συσκευή POS των ρυθμίσεων του τρόπου είσπραξης, απαιτεί υπογραφή και το παραστατικό δεν πηγαίνει με Πάροχο.

if(!empty($a14nr01)) {
    if(pegasus_module_exists("pos00")) {
        $q31_nr01 = pegasus_mysql_printfld('q31', 'nr01', 'p01="620042" and p05="7" and p03=:a14nr01', array('a14nr01' => $a14nr01));

        pegasus_mysql_use('SELECT * FROM pos00_02 WHERE a14 = :a14nr01', $pos00_02, array("a14nr01" => $a14nr01));
        $pos00_01_req_sign = pegasus_mysql_printfld('pos00_01', 'req_sign', 'nr01 = ?', array($pos00_02['pos00_01']));

        
        if($pos00_01_req_sign == 1 && empty($q31_nr01)) {
            // Δεν έχει q31 = 7 και απαιτεί υπογραφή
            $ret_arr['error'] = 1;
            $ret_arr['msg'] = $_SESSION['peg_dic_account00_pay_req_sign_without_q31'];
        }elseif($pos00_01_req_sign == 1 && empty(einv00_check_settings($tbl, $tbl_nr01))){
            // Απαιτεί υπογραφη και το παραστατικό δεν φεύγει με πάροχο.
            $ret_arr['error'] = 1;
            $ret_arr['msg'] = $_SESSION['peg_dic_account00_pay_req_sign_without_einv'];

        }elseif($pos00_01_req_sign == 1 && mydt_check_if_xeir_and_customer_invoice($tbl, $tbl_nr01) == 1) {
            // Τα χειρόγραφα παραστατικά δεν μπορούν να εισπραχθούν με EFTPOS διότι δεν διαβιβάζονται.
            $ret_arr['error'] = 1;
            $ret_arr['msg'] = $_SESSION['peg_dic_account00_pay_req_sign_xeir'];
        }else{
            $pos00_01_p02 = pegasus_mysql_printfld('pos00_01', 'p02', 'nr01 = ?', array($pos00_02['pos00_01']));
            $device_properties = pos00_device_properties::get_properties($pos00_01_p02);
    
            //* Μόνο για a55 στην τρέχουσα φάση.
            $a55_p05 = pegasus_mysql_printfld('a55', 'p05', 'nr01 = :tbl_nr01', array('tbl_nr01' => $tbl_nr01));
            pegasus_mysql_use('SELECT * FROM a10 WHERE a10.p01 = :a55_p05', $a10, array("a55_p05" => $a55_p05));
            pegasus_mysql_use('SELECT * FROM t02 WHERE p01 = :a10_p04', $t02, array("a10_p04" => $a10['p04']));
    
            // Παραστατικό με αρνητικό συντελεστή χρέωσης = Επιστροφή
            $ret_arr['dbg'] = $t02['p03'];
            
            if($t02['p03'] < 0 && $device_properties['void'] == true) {
                $ret_arr['v_idtorefund_hidden'] = false;
                account00_set_idtorefund_globalvar($pos00_02['pos00_01'], $container_id);
            }

            /**
             * Δεχόμαστε δόσεις μόνο αν:
             * - Το POS υποστηρίζει δόσεις 
             * - Έχει γίνει και η αντίστοιχη επιλογή στο pos00_02.p00
             * - Είναι για παραστατικό είσπραξης 
             */
            if($device_properties['instalments']==true && $pos00_02['p00']==1 && $t02['p03']>0) {
                $ret_arr['v_instalments_hidden'] = false;
            }
            
        }
    }
}

//Χρέωση σε Δωμάτιο
if(pegasus_module_exists('hot005') && $a14nr01==-99999){
    $hota18_p01 = $_SESSION["f02_p9000"];

    if(empty($hota18_p01)){
        // Αν δεν έχει συμπληρωθεί τμήμα στις Βασ. Παρ. Παραγγελιών-Παραστατικών
        $ret_arr["msg"] = $_SESSION["peg_dic_account00_hot005_hota18_empty"];
        echo json_encode($ret_arr);
        return; 

    }else{
        pegasus_mysql_use("select * from hota18 where p01=:p01", $hota18, array("p01"=>$hota18_p01));
        if(!empty($hota18["peid"]) || $hota18["p05"]>0){
            // Αν το τμήμα έχει ΚΚ ή είδος, βγάζει μήνυμα οτι δεν μπορεί να χρησιμοποιηθεί γιατί έχει ΚΚ/Είδος
            $ret_arr["msg"] = $_SESSION["peg_dic_account00_hot005_hota18_not_empty_p05_peid"];;   
            echo json_encode($ret_arr);
            return; 
        }
    }
}


$ret_arr["ok"] = 1;
echo json_encode($ret_arr);